/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql;

import java.util.Map;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.DruidExceptionMatcher;
import org.apache.druid.sql.SqlQueryPlus;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class SqlQueryPlusTest {
    @Test
    public void testSyntaxError() {
        DruidException e = (DruidException)Assert.assertThrows(DruidException.class, () -> SqlQueryPlus.builder((String)"SELECT COUNT(*) AS cnt, 'foo' AS").auth(CalciteTests.REGULAR_USER_AUTH_RESULT).build());
        MatcherAssert.assertThat((Object)e, (Matcher)DruidExceptionMatcher.invalidSqlInput().expectMessageContains("Incorrect syntax near the keyword 'AS' at line 1, column 31"));
    }

    @Test
    public void testSyntaxErrorJdbc() {
        SqlQueryPlus sqlQueryPlus = SqlQueryPlus.builder((String)"SELECT COUNT(*) AS cnt, 'foo' AS").auth(CalciteTests.REGULAR_USER_AUTH_RESULT).buildJdbc();
        DruidException e = (DruidException)Assert.assertThrows(DruidException.class, () -> ((SqlQueryPlus)sqlQueryPlus).freshCopy());
        MatcherAssert.assertThat((Object)e, (Matcher)DruidExceptionMatcher.invalidSqlInput().expectMessageContains("Incorrect syntax near the keyword 'AS' at line 1, column 31"));
    }

    @Test
    public void testUserProvidedContextOverridesSystemDefault() {
        Map<String, String> systemDefaultContext = Map.of("key", "system-default", "key2", "system-default2");
        Map<String, String> userProvidedContext = Map.of("key", "user-provided-value");
        SqlQueryPlus.Builder sqlQueryPlusBuilder = SqlQueryPlus.builder((String)"SELECT COUNT(*) AS cnt, 'foo' AS foo").systemDefaultContext(systemDefaultContext).queryContext(userProvidedContext).auth(CalciteTests.REGULAR_USER_AUTH_RESULT);
        Assert.assertEquals(Map.of("key", "user-provided-value", "key2", "system-default2"), (Object)sqlQueryPlusBuilder.build().context());
        Assert.assertEquals(Map.of("key", "user-provided-value", "key2", "system-default2"), (Object)sqlQueryPlusBuilder.buildJdbc().context());
        Assert.assertEquals(Map.of("key", "user-provided-value", "key2", "system-default2"), (Object)sqlQueryPlusBuilder.build().withContext(systemDefaultContext, userProvidedContext).context());
        Assert.assertEquals(Map.of("key", "system-default", "key2", "system-default2"), (Object)sqlQueryPlusBuilder.build().withContext(systemDefaultContext, Map.of()).context());
        Assert.assertEquals(Map.of("key", "user-provided-value"), (Object)sqlQueryPlusBuilder.build().withContext(Map.of(), userProvidedContext).context());
    }
}

