/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.quidem;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.hydromatic.quidem.CommandHandler;
import net.hydromatic.quidem.Quidem;
import org.apache.calcite.test.DiffTestCase;
import org.apache.calcite.util.Closer;
import org.apache.calcite.util.Util;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.druid.concurrent.Threads;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.quidem.DruidAvaticaTestDriver;
import org.apache.druid.quidem.DruidQuidemCommandHandler;
import org.apache.druid.quidem.DruidQuidemConnectionFactory;
import org.apache.druid.sql.calcite.MultiComponentSupplier;
import org.apache.druid.sql.calcite.SqlTestFrameworkConfig;
import org.apache.druid.sql.calcite.util.SqlTestFramework;
import org.junit.AssumptionViolatedException;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class DruidQuidemTestBase {
    public static final String IQ_SUFFIX = ".iq";
    private static final String OVERWRITE_PROPERTY = "quidem.overwrite";
    private static final String PROPERTY_FILTER = "quidem.filter";
    private static final String PROPERTY_SPLIT = "quidem.split";
    private final PathMatcher filterMatcher;
    private DruidQuidemRunner druidQuidemRunner;
    Set<String> commandLimitIgnoredFiles = ImmutableSet.of((Object)"qaSQL_scalar_string.iq", (Object)"qaSQL_scalar_numeric.iq", (Object)"qaAggFuncs_array_agg_timestamp.iq", (Object)"qaAggFuncs_array_agg_double.iq", (Object)"qaAggFuncs_array_agg_float.iq", (Object)"qaAggFuncs_array_agg_long.iq", (Object[])new String[]{"qaAggFuncs_array_agg_string.iq", "qaWin_sql.iq", "qaAggFuncs_string_agg_timestamp.iq", "qaAggFuncs_string_agg_double.iq", "qaAggFuncs_string_agg_float.iq", "qaAggFuncs_string_agg_long.iq", "qaAggFuncs_string_agg_string.iq", "qaUnnest_array_sql_scalar_funcs.iq", "qaUnnest_mv_sql_scalar_funcs.iq", "qaUnnest_mv_sql_other_funcs.iq", "qaUnnest_mv_sql.iq", "qaWin_orderby_range_negative_first_last.iq", "qaWin_orderby_range_negative_sum_count.iq", "qaWin_orderby_rows_negative_first_last.iq", "qaWin_orderby_rows_negative_sum_count.iq", "qaWin_basics.iq", "qaWin_orderby_range_0_following_first_last.iq", "qaWin_orderby_range_0_following_sum_count.iq", "qaWin_orderby_range_0_preceding_first_last.iq", "qaWin_orderby_range_0_preceding_sum_count.iq", "qaWin_orderby_range_1_following_first_last.iq", "qaWin_orderby_range_1_following_sum_count.iq", "qaWin_orderby_range_1_preceding_first_last.iq", "qaWin_orderby_range_1_preceding_sum_count.iq", "qaWin_orderby_range_current_first_last.iq", "qaWin_orderby_range_current_sum_count.iq", "qaWin_orderby_range_ub_following_first_last.iq", "qaWin_orderby_range_ub_following_sum_count.iq", "qaWin_orderby_range_ub_preceding_first_last.iq", "qaWin_orderby_range_ub_preceding_sum_count.iq", "qaWin_orderby_rows_0_following_first_last.iq", "qaWin_orderby_rows_0_following_sum_count.iq", "qaWin_orderby_rows_0_preceding_first_last.iq", "qaWin_orderby_rows_0_preceding_sum_count.iq", "qaWin_orderby_rows_1_following_first_last.iq", "qaWin_orderby_rows_1_following_sum_count.iq", "qaWin_orderby_rows_1_preceding_first_last.iq", "qaWin_orderby_rows_1_preceding_sum_count.iq", "qaWin_orderby_rows_current_first_last.iq", "qaWin_orderby_rows_current_sum_count.iq", "qaWin_orderby_rows_ub_following_first_last.iq", "qaWin_orderby_rows_ub_following_sum_count.iq", "qaWin_orderby_rows_ub_preceding_first_last.iq", "qaWin_orderby_rows_ub_preceding_sum_count.iq", "qaUnnest_array_sql_other_funcs.iq", "qaJsonCols_funcs_and_sql.iq", "qaUnnest_array_sql.iq", "qaUnnest_array_sql_filter.iq", "qaUnnest_mv_sql_filter.iq", "qaArray_sql.iq", "qaArray_ops_funcs.iq"});

    public DruidQuidemTestBase(CommandHandler commandHandler) {
        this(new DruidQuidemRunner(commandHandler, Quidem::new));
    }

    public DruidQuidemTestBase(DruidQuidemRunner druidQuidemRunner) {
        String filterStr = Strings.emptyToNull((String)System.getProperty(PROPERTY_FILTER, null));
        String splitStr = Strings.emptyToNull((String)System.getProperty(PROPERTY_SPLIT, null));
        this.filterMatcher = this.buildFilterMatcher(filterStr, splitStr);
        this.druidQuidemRunner = druidQuidemRunner;
    }

    private PathMatcher buildFilterMatcher(String filterStr, String splitStr) {
        if (filterStr != null && splitStr != null) {
            throw new IAE("Cannot configure multiple filter methods with properties: %s and %s.", new Object[]{PROPERTY_FILTER, PROPERTY_SPLIT});
        }
        if (filterStr != null) {
            return new IQPathMatcher(filterStr);
        }
        if (splitStr != null) {
            return new QuidemSplitPathMatcher(splitStr);
        }
        return TrueFileFilter.INSTANCE;
    }

    public List<QuidemTestCaseConfiguration> getTestConfigs() throws IOException {
        ArrayList<QuidemTestCaseConfiguration> ret = new ArrayList<QuidemTestCaseConfiguration>();
        List<String> fileNames = this.getFileNames();
        for (String file : fileNames) {
            try {
                ret.addAll(this.getConfigurationsFor(file));
            }
            catch (Exception e) {
                throw DruidException.defensive((Throwable)e, (String)"While processing configurations for quidem file [%s]", (Object[])new Object[]{file});
            }
        }
        return ret;
    }

    private List<QuidemTestCaseConfiguration> getConfigurationsFor(String testFileName) throws IOException {
        File inFile = new File(this.getTestRoot(), testFileName);
        ArrayList<QuidemTestCaseConfiguration> ret = new ArrayList<QuidemTestCaseConfiguration>();
        for (Class<? extends SqlTestFramework.QueryComponentSupplier> supplier : this.collectSuppliers(inFile)) {
            String supplierName = supplier == null ? null : supplier.getSimpleName();
            ret.add(new QuidemTestCaseConfiguration(supplierName, testFileName));
        }
        return ret;
    }

    private List<Class<? extends SqlTestFramework.QueryComponentSupplier>> collectSuppliers(File inFile) throws IOException {
        Set<Class<MultiComponentSupplier>> metaSuppliers = this.collectMetaSuppliers(inFile);
        switch (metaSuppliers.size()) {
            case 0: {
                return Collections.singletonList(null);
            }
            case 1: {
                return MultiComponentSupplier.getSuppliers((Class)Iterables.getOnlyElement(metaSuppliers));
            }
        }
        throw DruidException.defensive((String)"Multiple MetaComponentSuppliers found [%s].", (Object[])new Object[]{metaSuppliers});
    }

    private Set<Class<MultiComponentSupplier>> collectMetaSuppliers(File inFile) throws IOException {
        HashSet<Class<MultiComponentSupplier>> metaSuppliers = new HashSet<Class<MultiComponentSupplier>>();
        List lines = Files.readLines((File)inFile, (Charset)StandardCharsets.UTF_8);
        for (String line2 : lines) {
            String[] parts;
            if (!line2.startsWith("!use") || (parts = line2.split(" ")).length != 2) continue;
            SqlTestFrameworkConfig cfg = SqlTestFrameworkConfig.fromURL(parts[1]);
            this.validateFrameworkConfig(cfg);
            if (!MultiComponentSupplier.class.isAssignableFrom(cfg.componentSupplier)) continue;
            metaSuppliers.add(cfg.componentSupplier);
        }
        int nCommands = Iterables.size((Iterable)Iterables.filter((Iterable)lines, line -> line.startsWith("!")));
        if (!this.commandLimitIgnoredFiles.contains(inFile.getName()) && nCommands > 80) {
            throw DruidException.defensive((String)"There are too many commands [%s] in file [%s] which would make working with the test harder. Please reduce the number of queries/commands/etc", (Object[])new Object[]{nCommands, inFile});
        }
        return metaSuppliers;
    }

    protected void validateFrameworkConfig(SqlTestFrameworkConfig cfg) {
    }

    @ParameterizedTest
    @MethodSource(value={"getTestConfigs"})
    public void test(QuidemTestCaseConfiguration testConfig) throws Exception {
        String testName = testConfig.getTestName();
        File inFile = new File(this.getTestRoot(), testConfig.fileName);
        File outFile = new File(this.getTestRoot(), testName + ".out");
        try (AutoCloseable closeable = Threads.withThreadName((String)testName);){
            this.druidQuidemRunner.run(inFile, outFile, testConfig.componentSupplierName);
        }
        catch (Error e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof AssumptionViolatedException) {
                AssumptionViolatedException assumptionViolatedException = (AssumptionViolatedException)cause;
                throw assumptionViolatedException;
            }
            throw e;
        }
    }

    protected CommandHandler getCommandHandler() {
        return new DruidQuidemCommandHandler();
    }

    protected final List<String> getFileNames() throws IOException {
        ArrayList<String> ret = new ArrayList<String>();
        File testRoot = this.getTestRoot();
        if (!testRoot.exists()) {
            throw new FileNotFoundException(StringUtils.format((String)"testRoot [%s] doesn't exists!", (Object[])new Object[]{testRoot}));
        }
        for (File f : Files.fileTraverser().breadthFirst((Object)testRoot)) {
            if (!this.isTestIncluded(testRoot, f)) continue;
            Path relativePath = testRoot.toPath().relativize(f.toPath());
            ret.add(relativePath.toString());
        }
        if (ret.isEmpty()) {
            throw new IAE("There are no test cases in directory[%s] or there are no matches to filter[%s]", new Object[]{testRoot, this.filterMatcher});
        }
        Collections.sort(ret);
        return ret;
    }

    private boolean isTestIncluded(File testRoot, File f) {
        Path relativePath = testRoot.toPath().relativize(f.toPath());
        return !f.isDirectory() && f.getName().endsWith(IQ_SUFFIX) && this.filterMatcher.matches(relativePath);
    }

    protected abstract File getTestRoot();

    @AfterAll
    public static void afterAll() {
        DruidAvaticaTestDriver.CONFIG_STORE.close();
    }

    public static class DruidQuidemRunner {
        private CommandHandler commandHandler;
        private Function<Quidem.Config, Quidem> quidemMaker;

        public DruidQuidemRunner() {
            this(new DruidQuidemCommandHandler(), Quidem::new);
        }

        public DruidQuidemRunner(CommandHandler commandHandler, Function<Quidem.Config, Quidem> quidemMaker) {
            this.commandHandler = commandHandler;
            this.quidemMaker = quidemMaker;
        }

        public void run(File inFile) throws Exception {
            File outFile = new File(inFile.getParent(), inFile.getName() + ".out");
            this.run(inFile, outFile, null);
        }

        public void run(File inFile, File outFile, String componentSupplier) throws Exception {
            FileUtils.mkdirp((File)outFile.getParentFile());
            try (BufferedReader reader = Util.reader((File)inFile);
                 PrintWriter writer = Util.printWriter((File)outFile);
                 Closer closer = new Closer();){
                DruidQuidemConnectionFactory connectionFactory = new DruidQuidemConnectionFactory();
                if (componentSupplier != null) {
                    connectionFactory.onSet("componentSupplier", componentSupplier);
                }
                Quidem.ConfigBuilder configBuilder = Quidem.configBuilder().withConnectionFactory((Quidem.ConnectionFactory)connectionFactory).withPropertyHandler((Quidem.PropertyHandler)connectionFactory).withEnv(connectionFactory::envLookup).withCommandHandler(this.commandHandler);
                Quidem.Config config = configBuilder.withReader((Reader)reader).withWriter((Writer)writer).withStackLimit(-1).build();
                this.quidemMaker.apply(config).execute();
            }
            catch (Exception e) {
                throw new RE((Throwable)e, "Encountered exception while running [%s]", new Object[]{inFile});
            }
            String diff = DiffTestCase.diff((File)inFile, (File)outFile);
            if (!diff.isEmpty()) {
                if (DruidQuidemRunner.isOverwrite()) {
                    Files.copy((File)outFile, (File)inFile);
                } else if (DruidQuidemRunner.isUnsupportedComponentSupplier(diff, componentSupplier)) {
                    System.out.println("Skipping verification of unsupported componentSupplier " + componentSupplier);
                } else {
                    Assertions.fail((String)("Files differ: " + outFile + " " + inFile + "\n" + diff));
                }
            } else if (outFile.exists()) {
                outFile.delete();
            }
        }

        public static boolean isOverwrite() {
            String property = System.getProperty(DruidQuidemTestBase.OVERWRITE_PROPERTY, "false");
            return property.length() == 0 || Boolean.valueOf(property) != false;
        }

        private static boolean isUnsupportedComponentSupplier(String diff, String componentSupplier) {
            return diff.contains(StringUtils.format((String)"Unsupported componentSupplier[%s], skipping verification of diff.", (Object[])new Object[]{componentSupplier}));
        }
    }

    static class IQPathMatcher
    implements PathMatcher {
        private final List<PathMatcher> filterMatchers = new ArrayList<PathMatcher>();
        private final String filterStr;

        /*
         * WARNING - void declaration
         */
        public IQPathMatcher(String filterStr) {
            this.filterStr = filterStr;
            FileSystem fileSystem = FileSystems.getDefault();
            for (String string : filterStr.split(",")) {
                void var6_6;
                if (!string.endsWith("*") && !string.endsWith(DruidQuidemTestBase.IQ_SUFFIX)) {
                    String string2 = filterStr + DruidQuidemTestBase.IQ_SUFFIX;
                }
                this.filterMatchers.add(fileSystem.getPathMatcher("glob:" + (String)var6_6));
            }
        }

        @Override
        public boolean matches(Path path) {
            for (PathMatcher m : this.filterMatchers) {
                if (!m.matches(path)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return this.filterStr;
        }
    }

    static class QuidemSplitPathMatcher
    implements PathMatcher {
        private final int splitIndex;
        private final int splitCount;

        public QuidemSplitPathMatcher(String splitStr) {
            Pattern pattern = Pattern.compile("^([0-9]+)/([0-9]+)$");
            Matcher m = pattern.matcher(splitStr);
            if (!m.matches()) {
                throw DruidException.defensive((String)"Invalid split pattern; must match pattern [%s]", (Object[])new Object[]{pattern});
            }
            this.splitIndex = Integer.parseInt(m.group(1));
            this.splitCount = Integer.parseInt(m.group(2));
            if (this.splitCount < 1 || this.splitIndex < 0 || this.splitIndex >= this.splitCount) {
                throw DruidException.defensive((String)"invalid splitStr [%s]", (Object[])new Object[]{splitStr});
            }
        }

        @Override
        public boolean matches(Path path) {
            return Math.floorMod(path.toString().hashCode(), this.splitCount) == this.splitIndex;
        }

        public String toString() {
            return "split:" + this.splitIndex + "/" + this.splitCount;
        }
    }

    protected static class QuidemTestCaseConfiguration {
        final String fileName;
        final String componentSupplierName;

        public QuidemTestCaseConfiguration(String componentSupplierName, String fileName) {
            this.fileName = fileName;
            this.componentSupplierName = componentSupplierName;
        }

        public String getTestName() {
            if (this.componentSupplierName == null) {
                return this.fileName;
            }
            return StringUtils.format((String)"%s@%s", (Object[])new Object[]{this.fileName, this.componentSupplierName});
        }

        public String toString() {
            return this.getTestName();
        }
    }
}

