/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.quidem;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Injector;
import java.sql.Connection;
import org.apache.druid.error.DruidException;
import org.apache.druid.server.SpecificSegmentsQuerySegmentWalker;
import org.apache.druid.sql.hook.DruidHookDispatcher;

public interface DruidConnectionExtras {
    public ObjectMapper getObjectMapper();

    public SpecificSegmentsQuerySegmentWalker getWalker();

    public DruidHookDispatcher getDruidHookDispatcher();

    public boolean isExplainSupported();

    public Injector getInjector();

    public static DruidConnectionExtras unwrapOrThrow(Connection connection) {
        if (connection instanceof DruidConnectionExtras) {
            return (DruidConnectionExtras)((Object)connection);
        }
        throw DruidException.defensive((String)"Expected class [%s] to implement DruidConnectionExtras!", (Object[])new Object[]{connection.getClass()});
    }

    public static class DruidConnectionExtrasImpl
    implements DruidConnectionExtras {
        private final ObjectMapper objectMapper;
        private final DruidHookDispatcher druidHookDispatcher;
        private final boolean isExplainSupported;
        private final SpecificSegmentsQuerySegmentWalker walker;
        private final Injector injector;

        public DruidConnectionExtrasImpl(ObjectMapper objectMapper, DruidHookDispatcher druidHookDispatcher, boolean isExplainSupported, SpecificSegmentsQuerySegmentWalker walker, Injector injector) {
            this.objectMapper = objectMapper;
            this.druidHookDispatcher = druidHookDispatcher;
            this.isExplainSupported = isExplainSupported;
            this.walker = walker;
            this.injector = injector;
        }

        @Override
        public ObjectMapper getObjectMapper() {
            return this.objectMapper;
        }

        @Override
        public DruidHookDispatcher getDruidHookDispatcher() {
            return this.druidHookDispatcher;
        }

        @Override
        public boolean isExplainSupported() {
            return this.isExplainSupported;
        }

        @Override
        public SpecificSegmentsQuerySegmentWalker getWalker() {
            return this.walker;
        }

        @Override
        public Injector getInjector() {
            return this.injector;
        }
    }
}

