/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.query.expression.TimestampFloorExprMacro;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.expression.TimeUnits;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.joda.time.Period;

public class TimeFloorOperatorConversion
implements SqlOperatorConversion {
    public static final String SQL_FUNCTION_NAME = "TIME_FLOOR";
    public static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("TIME_FLOOR").operandTypes(SqlTypeFamily.TIMESTAMP, SqlTypeFamily.CHARACTER, SqlTypeFamily.TIMESTAMP, SqlTypeFamily.CHARACTER).requiredOperandCount(2).returnTypeCascadeNullable(SqlTypeName.TIMESTAMP).functionCategory(SqlFunctionCategory.TIMEDATE).build();

    public static DruidExpression applyTimestampFloor(DruidExpression input, PeriodGranularity granularity, PlannerContext plannerContext) {
        PeriodGranularity inputGranularity;
        TimestampFloorExprMacro.TimestampFloorExpr floorExpr;
        Preconditions.checkNotNull((Object)input, (Object)"input");
        Preconditions.checkNotNull((Object)granularity, (Object)"granularity");
        if (granularity.getPeriod().equals((Object)Period.days((int)1)) && (floorExpr = Expressions.asTimestampFloorExpr(input, plannerContext.getExpressionParser())) != null && Objects.equals((inputGranularity = floorExpr.getGranularity()).getTimeZone(), granularity.getTimeZone()) && Objects.equals(inputGranularity.getOrigin(), granularity.getOrigin()) && TimeFloorOperatorConversion.periodIsDayMultiple(inputGranularity.getPeriod())) {
            return input;
        }
        return DruidExpression.ofFunctionCall(input.getDruidType(), "timestamp_floor", (List<DruidExpression>)ImmutableList.of((Object)input, (Object)DruidExpression.ofStringLiteral(granularity.getPeriod().toString()), (Object)DruidExpression.ofLiteral(ColumnType.LONG, granularity.getOrigin() == null ? DruidExpression.nullLiteral() : DruidExpression.longLiteral(granularity.getOrigin().getMillis())), (Object)DruidExpression.ofStringLiteral(granularity.getTimeZone().toString())));
    }

    @Nullable
    public static List<DruidExpression> toTimestampFloorOrCeilArgs(PlannerContext plannerContext, RowSignature rowSignature, List<RexNode> operands) {
        ArrayList<DruidExpression> functionArgs = new ArrayList<DruidExpression>();
        functionArgs.add(Expressions.toDruidExpression(plannerContext, rowSignature, operands.get(0)));
        RexNode periodOperand = operands.get(1);
        if (periodOperand.isA(SqlKind.LITERAL) && RexLiteral.value((RexNode)periodOperand) instanceof TimeUnitRange) {
            Period period = TimeUnits.toPeriod((TimeUnitRange)RexLiteral.value((RexNode)periodOperand));
            if (period == null) {
                return null;
            }
            functionArgs.add(DruidExpression.ofStringLiteral(period.toString()));
        } else {
            functionArgs.add(Expressions.toDruidExpression(plannerContext, rowSignature, periodOperand));
        }
        functionArgs.add(OperatorConversions.getOperandWithDefault(operands, 2, operand -> {
            if (operand.isA(SqlKind.LITERAL)) {
                return DruidExpression.ofLiteral(Calcites.getColumnTypeForRelDataType(operand.getType()), DruidExpression.longLiteral(Calcites.calciteDateTimeLiteralToJoda(operand, plannerContext.getTimeZone()).getMillis()));
            }
            return Expressions.toDruidExpression(plannerContext, rowSignature, operand);
        }, DruidExpression.ofLiteral(null, DruidExpression.nullLiteral())));
        functionArgs.add(OperatorConversions.getOperandWithDefault(operands, 3, operand -> Expressions.toDruidExpression(plannerContext, rowSignature, operand), DruidExpression.ofStringLiteral(plannerContext.getTimeZone().getID())));
        return functionArgs.stream().noneMatch(Objects::isNull) ? functionArgs : null;
    }

    private static boolean periodIsDayMultiple(Period period) {
        return period.getMillis() == 0 && period.getSeconds() == 0 && period.getMinutes() == 0 && period.getHours() == 0 && (period.getDays() > 0 || period.getWeeks() > 0 || period.getMonths() > 0 || period.getYears() > 0);
    }

    @Override
    public SqlOperator calciteOperator() {
        return SQL_FUNCTION;
    }

    @Override
    @Nullable
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        RexCall call = (RexCall)rexNode;
        List<DruidExpression> functionArgs = TimeFloorOperatorConversion.toTimestampFloorOrCeilArgs(plannerContext, rowSignature, call.getOperands());
        if (functionArgs == null) {
            return null;
        }
        return DruidExpression.ofFunctionCall(Calcites.getColumnTypeForRelDataType(rexNode.getType()), "timestamp_floor", functionArgs);
    }
}

