/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.client.ServerView;
import org.apache.druid.client.TimelineServerView;
import org.apache.druid.client.selector.HighestPriorityTierSelectorStrategy;
import org.apache.druid.client.selector.HistoricalFilter;
import org.apache.druid.client.selector.RandomServerSelectorStrategy;
import org.apache.druid.client.selector.ServerSelector;
import org.apache.druid.client.selector.ServerSelectorStrategy;
import org.apache.druid.client.selector.TierSelectorStrategy;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.TimelineLookup;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.timeline.partition.SingleElementPartitionChunk;

public class TestTimelineServerView
implements TimelineServerView {
    private static final DruidServerMetadata DUMMY_SERVER = new DruidServerMetadata("dummy", "dummy:15723", null, 0L, ServerType.HISTORICAL, "dummy", 0);
    private static final DruidServerMetadata DUMMY_SERVER_REALTIME = new DruidServerMetadata("dummy2", "dummy2:15723", null, 0L, ServerType.REALTIME, "dummy", 0);
    private static final DruidServerMetadata DUMMY_BROKER = new DruidServerMetadata("dummy3", "dummy3:15723", null, 0L, ServerType.BROKER, "dummy", 0);
    private List<DataSegment> segments = new ArrayList<DataSegment>();
    private List<DataSegment> realtimeSegments = new ArrayList<DataSegment>();
    private List<DataSegment> brokerSegments = new ArrayList<DataSegment>();
    private List<Pair<Executor, ServerView.SegmentCallback>> segmentCallbackExecs = new ArrayList<Pair<Executor, ServerView.SegmentCallback>>();
    private List<Pair<Executor, TimelineServerView.TimelineCallback>> timelineCallbackExecs = new ArrayList<Pair<Executor, TimelineServerView.TimelineCallback>>();

    public TestTimelineServerView(List<DataSegment> segments) {
        this(segments, Collections.emptyList());
    }

    public TestTimelineServerView(List<DataSegment> segments, List<DataSegment> realtimeSegments) {
        this.segments.addAll(segments);
        this.realtimeSegments.addAll(realtimeSegments);
    }

    public Optional<? extends TimelineLookup<String, ServerSelector>> getTimeline(TableDataSource table) {
        for (DataSegment segment : this.segments) {
            if (!segment.getDataSource().equals(table.getName())) continue;
            VersionedIntervalTimeline timelineLookup = new VersionedIntervalTimeline(Comparator.naturalOrder());
            HighestPriorityTierSelectorStrategy st = new HighestPriorityTierSelectorStrategy((ServerSelectorStrategy)new RandomServerSelectorStrategy());
            ServerSelector sss = new ServerSelector(segment, (TierSelectorStrategy)st, HistoricalFilter.IDENTITY_FILTER);
            SingleElementPartitionChunk partitionChunk = new SingleElementPartitionChunk((Object)sss);
            timelineLookup.add(segment.getInterval(), (Object)segment.getVersion(), (PartitionChunk)partitionChunk);
            return Optional.of(timelineLookup);
        }
        return Optional.empty();
    }

    public List<ImmutableDruidServer> getDruidServers() {
        ImmutableDruidDataSource dataSource = new ImmutableDruidDataSource("DUMMY", Collections.emptyMap(), this.segments);
        ImmutableDruidServer server = new ImmutableDruidServer(DUMMY_SERVER, 0L, ImmutableMap.of((Object)"src", (Object)dataSource), 1);
        ImmutableDruidDataSource dataSource2 = new ImmutableDruidDataSource("DUMMY2", Collections.emptyMap(), this.realtimeSegments);
        ImmutableDruidServer realtimeServer = new ImmutableDruidServer(DUMMY_SERVER_REALTIME, 0L, ImmutableMap.of((Object)"src", (Object)dataSource2), 1);
        return ImmutableList.of((Object)server, (Object)realtimeServer);
    }

    public void registerSegmentCallback(Executor exec, ServerView.SegmentCallback callback) {
        for (DataSegment segment : this.segments) {
            exec.execute(() -> callback.segmentAdded(DUMMY_SERVER, segment));
        }
        for (DataSegment segment : this.realtimeSegments) {
            exec.execute(() -> callback.segmentAdded(DUMMY_SERVER_REALTIME, segment));
        }
        exec.execute(() -> ((ServerView.SegmentCallback)callback).segmentViewInitialized());
        this.segmentCallbackExecs.add((Pair<Executor, ServerView.SegmentCallback>)new Pair((Object)exec, (Object)callback));
    }

    public void registerTimelineCallback(Executor exec, TimelineServerView.TimelineCallback callback) {
        for (DataSegment segment : this.segments) {
            exec.execute(() -> callback.segmentAdded(DUMMY_SERVER, segment));
        }
        for (DataSegment segment : this.realtimeSegments) {
            exec.execute(() -> callback.segmentAdded(DUMMY_SERVER_REALTIME, segment));
        }
        exec.execute(() -> ((TimelineServerView.TimelineCallback)callback).timelineInitialized());
        this.timelineCallbackExecs.add((Pair<Executor, TimelineServerView.TimelineCallback>)new Pair((Object)exec, (Object)callback));
    }

    public <T> QueryRunner<T> getQueryRunner(DruidServer server) {
        throw new UnsupportedOperationException();
    }

    public void registerServerCallback(Executor exec, ServerView.ServerCallback callback) {
    }

    public void addSegment(DataSegment segment, ServerType serverType) {
        Pair<DruidServerMetadata, List<DataSegment>> whichServerAndSegments = this.getDummyServerAndSegmentsForType(serverType);
        DruidServerMetadata whichServer = (DruidServerMetadata)whichServerAndSegments.lhs;
        ((List)whichServerAndSegments.rhs).add(segment);
        this.segmentCallbackExecs.forEach(execAndCallback -> ((Executor)execAndCallback.lhs).execute(() -> ((ServerView.SegmentCallback)execAndCallback.rhs).segmentAdded(whichServer, segment)));
        this.timelineCallbackExecs.forEach(execAndCallback -> ((Executor)execAndCallback.lhs).execute(() -> ((TimelineServerView.TimelineCallback)execAndCallback.rhs).segmentAdded(whichServer, segment)));
    }

    public void removeSegment(DataSegment segment, ServerType serverType) {
        Pair<DruidServerMetadata, List<DataSegment>> whichServerAndSegments = this.getDummyServerAndSegmentsForType(serverType);
        DruidServerMetadata whichServer = (DruidServerMetadata)whichServerAndSegments.lhs;
        ((List)whichServerAndSegments.rhs).remove(segment);
        this.segmentCallbackExecs.forEach(execAndCallback -> ((Executor)execAndCallback.lhs).execute(() -> ((ServerView.SegmentCallback)execAndCallback.rhs).segmentRemoved(whichServer, segment)));
        this.timelineCallbackExecs.forEach(execAndCallback -> ((Executor)execAndCallback.lhs).execute(() -> {
            ((TimelineServerView.TimelineCallback)execAndCallback.rhs).serverSegmentRemoved(whichServer, segment);
            if (!(this.segments.contains(segment) || this.brokerSegments.contains(segment) || this.realtimeSegments.contains(segment))) {
                ((TimelineServerView.TimelineCallback)execAndCallback.rhs).segmentRemoved(segment);
            }
        }));
    }

    public void invokeSegmentSchemasAnnouncedDummy() {
        for (Pair<Executor, TimelineServerView.TimelineCallback> timelineCallbackExec : this.timelineCallbackExecs) {
            ((TimelineServerView.TimelineCallback)timelineCallbackExec.rhs).segmentSchemasAnnounced(null);
        }
    }

    private Pair<DruidServerMetadata, List<DataSegment>> getDummyServerAndSegmentsForType(ServerType serverType) {
        List<DataSegment> whichSegments;
        DruidServerMetadata whichServer;
        switch (serverType) {
            case BROKER: {
                whichServer = DUMMY_BROKER;
                whichSegments = this.brokerSegments;
                break;
            }
            case REALTIME: {
                whichServer = DUMMY_SERVER_REALTIME;
                whichSegments = this.realtimeSegments;
                break;
            }
            default: {
                whichServer = DUMMY_SERVER;
                whichSegments = this.segments;
            }
        }
        return new Pair((Object)whichServer, whichSegments);
    }
}

