/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.schema;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.client.InternalQueryConfig;
import org.apache.druid.client.TimelineServerView;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.client.coordinator.NoopCoordinatorClient;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.GlobalTableDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.druid.query.metadata.metadata.AllColumnIncluderator;
import org.apache.druid.query.metadata.metadata.ColumnIncluderator;
import org.apache.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.apache.druid.query.policy.NoRestrictionPolicy;
import org.apache.druid.query.spec.MultipleSpecificSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexCursorFactory;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.metadata.AbstractSegmentMetadataCache;
import org.apache.druid.segment.metadata.AvailableSegmentMetadata;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.segment.metadata.DataSourceInformation;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.server.QueryLifecycle;
import org.apache.druid.server.QueryLifecycleFactory;
import org.apache.druid.server.QueryResponse;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.server.security.AllowAllAuthenticator;
import org.apache.druid.server.security.AuthorizationResult;
import org.apache.druid.server.security.Escalator;
import org.apache.druid.server.security.NoopEscalator;
import org.apache.druid.sql.calcite.schema.BrokerSegmentMetadataCache;
import org.apache.druid.sql.calcite.schema.BrokerSegmentMetadataCacheConfig;
import org.apache.druid.sql.calcite.schema.BrokerSegmentMetadataCacheTestBase;
import org.apache.druid.sql.calcite.schema.PhysicalDatasourceMetadataFactory;
import org.apache.druid.sql.calcite.table.DatasourceTable;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.apache.druid.sql.calcite.util.TestTimelineServerView;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.TombstoneShardSpec;
import org.easymock.EasyMock;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class BrokerSegmentMetadataCacheTest
extends BrokerSegmentMetadataCacheTestBase {
    private static final BrokerSegmentMetadataCacheConfig SEGMENT_CACHE_CONFIG_DEFAULT = BrokerSegmentMetadataCacheConfig.create((String)"PT1S");
    private static final int WAIT_TIMEOUT_SECS = 6;
    private static final ObjectMapper MAPPER = TestHelper.makeJsonMapper();
    private BrokerSegmentMetadataCache runningSchema;
    private CountDownLatch buildTableLatch = new CountDownLatch(1);
    private CountDownLatch markDataSourceLatch = new CountDownLatch(1);
    private CountDownLatch refreshLatch = new CountDownLatch(1);

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.runningSchema != null) {
            this.runningSchema.stop();
        }
        this.walker.close();
    }

    public BrokerSegmentMetadataCache buildSchemaMarkAndTableLatch() throws InterruptedException {
        return this.buildSchemaMarkAndTableLatch(SEGMENT_CACHE_CONFIG_DEFAULT, (CoordinatorClient)new NoopCoordinatorClient());
    }

    public BrokerSegmentMetadataCache buildSchemaMarkAndTableLatch(BrokerSegmentMetadataCacheConfig config, CoordinatorClient coordinatorClient) throws InterruptedException {
        Preconditions.checkState((this.runningSchema == null ? 1 : 0) != 0);
        this.runningSchema = new BrokerSegmentMetadataCache(CalciteTests.createMockQueryLifecycleFactory((QuerySegmentWalker)this.walker, this.conglomerate), this.serverView, config, (Escalator)new NoopEscalator(), new InternalQueryConfig(), (ServiceEmitter)new NoopServiceEmitter(), new PhysicalDatasourceMetadataFactory(this.globalTableJoinable, this.segmentManager), coordinatorClient, CentralizedDatasourceSchemaConfig.create()){

            public RowSignature buildDataSourceRowSignature(String dataSource) {
                RowSignature table = super.buildDataSourceRowSignature(dataSource);
                BrokerSegmentMetadataCacheTest.this.buildTableLatch.countDown();
                return table;
            }

            public void markDataSourceAsNeedRebuild(String datasource) {
                super.markDataSourceAsNeedRebuild(datasource);
                BrokerSegmentMetadataCacheTest.this.markDataSourceLatch.countDown();
            }
        };
        this.runningSchema.start();
        this.runningSchema.awaitInitialization();
        return this.runningSchema;
    }

    public BrokerSegmentMetadataCache buildSchemaMarkAndRefreshLatch() throws InterruptedException {
        Preconditions.checkState((this.runningSchema == null ? 1 : 0) != 0);
        this.runningSchema = new BrokerSegmentMetadataCache(CalciteTests.createMockQueryLifecycleFactory((QuerySegmentWalker)this.walker, this.conglomerate), this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new InternalQueryConfig(), (ServiceEmitter)new NoopServiceEmitter(), new PhysicalDatasourceMetadataFactory(this.globalTableJoinable, this.segmentManager), (CoordinatorClient)new NoopCoordinatorClient(), CentralizedDatasourceSchemaConfig.create()){

            public void markDataSourceAsNeedRebuild(String datasource) {
                super.markDataSourceAsNeedRebuild(datasource);
                BrokerSegmentMetadataCacheTest.this.markDataSourceLatch.countDown();
            }

            @VisibleForTesting
            public void refresh(Set<SegmentId> segmentsToRefresh, Set<String> dataSourcesToRebuild) throws IOException {
                super.refresh(segmentsToRefresh, dataSourcesToRebuild);
                BrokerSegmentMetadataCacheTest.this.refreshLatch.countDown();
            }
        };
        this.runningSchema.start();
        this.runningSchema.awaitInitialization();
        return this.runningSchema;
    }

    @Test
    public void testCoordinatorReturnsAllDSSchema() throws InterruptedException {
        final RowSignature dataSource1RowSignature = new QueryableIndexCursorFactory(this.index1).getRowSignature();
        final RowSignature dataSource2RowSignature = new QueryableIndexCursorFactory(this.index2).getRowSignature();
        final RowSignature someDataSourceRowSignature = new QueryableIndexCursorFactory(this.indexAuto1).getRowSignature();
        final RowSignature foo3RowSignature = new QueryableIndexCursorFactory(this.indexAuto2).getRowSignature();
        NoopCoordinatorClient coordinatorClient = new NoopCoordinatorClient(){

            public ListenableFuture<List<DataSourceInformation>> fetchDataSourceInformation(Set<String> datasources) {
                HashMap<String, DataSourceInformation> dataSourceInformationMap = new HashMap<String, DataSourceInformation>();
                dataSourceInformationMap.put("foo", new DataSourceInformation("foo", dataSource1RowSignature));
                dataSourceInformationMap.put("foo2", new DataSourceInformation("foo2", dataSource2RowSignature));
                dataSourceInformationMap.put("some_datasource", new DataSourceInformation("some_datasource", someDataSourceRowSignature));
                dataSourceInformationMap.put("foo3", new DataSourceInformation("foo3", foo3RowSignature));
                return Futures.immediateFuture(new ArrayList(dataSourceInformationMap.values()));
            }
        };
        QueryLifecycleFactory factoryMock = (QueryLifecycleFactory)EasyMock.createMock(QueryLifecycleFactory.class);
        BrokerSegmentMetadataCache schema = new BrokerSegmentMetadataCache(factoryMock, (TimelineServerView)this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new InternalQueryConfig(), (ServiceEmitter)new NoopServiceEmitter(), new PhysicalDatasourceMetadataFactory(this.globalTableJoinable, this.segmentManager), (CoordinatorClient)coordinatorClient, CentralizedDatasourceSchemaConfig.create());
        schema.start();
        schema.awaitInitialization();
        Set tableNames = schema.getDatasourceNames();
        Assert.assertEquals((Object)ImmutableSet.of((Object)"foo", (Object)"foo2", (Object)"some_datasource", (Object)"foo3"), (Object)tableNames);
        Assert.assertEquals((Object)dataSource1RowSignature, (Object)((DatasourceTable.PhysicalDatasourceMetadata)schema.getDatasource("foo")).getRowSignature());
        Assert.assertEquals((Object)dataSource2RowSignature, (Object)((DatasourceTable.PhysicalDatasourceMetadata)schema.getDatasource("foo2")).getRowSignature());
        Assert.assertEquals((Object)someDataSourceRowSignature, (Object)((DatasourceTable.PhysicalDatasourceMetadata)schema.getDatasource("some_datasource")).getRowSignature());
        Assert.assertEquals((Object)foo3RowSignature, (Object)((DatasourceTable.PhysicalDatasourceMetadata)schema.getDatasource("foo3")).getRowSignature());
    }

    @Test
    public void testCoordinatorReturnsFewDSSchema() throws InterruptedException {
        final RowSignature dataSource1RowSignature = new QueryableIndexCursorFactory(this.index1).getRowSignature();
        final RowSignature dataSource2RowSignature = new QueryableIndexCursorFactory(this.index2).getRowSignature();
        final RowSignature someDataSourceRowSignature = new QueryableIndexCursorFactory(this.indexAuto1).getRowSignature();
        NoopCoordinatorClient coordinatorClient = new NoopCoordinatorClient(){

            public ListenableFuture<List<DataSourceInformation>> fetchDataSourceInformation(Set<String> datasources) {
                HashMap<String, DataSourceInformation> dataSourceInformationMap = new HashMap<String, DataSourceInformation>();
                dataSourceInformationMap.put("foo", new DataSourceInformation("foo", dataSource1RowSignature));
                dataSourceInformationMap.put("foo2", new DataSourceInformation("foo2", dataSource2RowSignature));
                dataSourceInformationMap.put("some_datasource", new DataSourceInformation("some_datasource", someDataSourceRowSignature));
                return Futures.immediateFuture(new ArrayList(dataSourceInformationMap.values()));
            }
        };
        SegmentMetadataQuery expectedMetadataQuery = new SegmentMetadataQuery((DataSource)new TableDataSource("foo3"), (QuerySegmentSpec)new MultipleSpecificSegmentSpec(Collections.singletonList(this.realtimeSegment1.getId().toDescriptor())), (ColumnIncluderator)new AllColumnIncluderator(), Boolean.valueOf(false), (Map)ImmutableMap.of((Object)"enableParallelMerge", (Object)false), EnumSet.noneOf(SegmentMetadataQuery.AnalysisType.class), Boolean.valueOf(false), null, null);
        QueryLifecycleFactory factoryMock = (QueryLifecycleFactory)EasyMock.createMock(QueryLifecycleFactory.class);
        QueryLifecycle lifecycleMock = (QueryLifecycle)EasyMock.createMock(QueryLifecycle.class);
        EasyMock.expect((Object)factoryMock.factorize()).andReturn((Object)lifecycleMock).once();
        EasyMock.expect((Object)lifecycleMock.runSimple((Query)expectedMetadataQuery, AllowAllAuthenticator.ALLOW_ALL_RESULT, AuthorizationResult.allowWithRestriction((Map)ImmutableMap.of((Object)"foo3", Optional.of(NoRestrictionPolicy.instance()))))).andReturn((Object)QueryResponse.withEmptyContext((Sequence)Sequences.empty()));
        BrokerSegmentMetadataCache schema = new BrokerSegmentMetadataCache(factoryMock, (TimelineServerView)this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new InternalQueryConfig(), (ServiceEmitter)new NoopServiceEmitter(), new PhysicalDatasourceMetadataFactory(this.globalTableJoinable, this.segmentManager), (CoordinatorClient)coordinatorClient, CentralizedDatasourceSchemaConfig.create());
        EasyMock.replay((Object[])new Object[]{factoryMock, lifecycleMock});
        schema.start();
        schema.awaitInitialization();
        EasyMock.verify((Object[])new Object[]{factoryMock, lifecycleMock});
    }

    @Test
    public void testBrokerPollsAllDSSchema() throws InterruptedException {
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(Set.class);
        CoordinatorClient coordinatorClient = (CoordinatorClient)Mockito.mock(CoordinatorClient.class);
        Mockito.when((Object)coordinatorClient.fetchDataSourceInformation((Set)argumentCaptor.capture())).thenReturn((Object)Futures.immediateFuture(null));
        HashSet datsources = Sets.newHashSet((Object[])new String[]{"foo", "foo2", "foo3", "some_datasource", "xyz", "coldDS"});
        Mockito.when((Object)coordinatorClient.fetchDataSourcesWithUsedSegments()).thenReturn((Object)Futures.immediateFuture((Object)datsources));
        BrokerSegmentMetadataCache schema = new BrokerSegmentMetadataCache(CalciteTests.createMockQueryLifecycleFactory((QuerySegmentWalker)this.walker, this.conglomerate), (TimelineServerView)this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new InternalQueryConfig(), (ServiceEmitter)new NoopServiceEmitter(), new PhysicalDatasourceMetadataFactory(this.globalTableJoinable, this.segmentManager), coordinatorClient, CentralizedDatasourceSchemaConfig.create());
        schema.start();
        schema.awaitInitialization();
        Assert.assertEquals((Object)datsources, (Object)argumentCaptor.getValue());
        this.refreshLatch = new CountDownLatch(1);
        this.serverView.addSegment(this.newSegment("xyz", 0), ServerType.HISTORICAL);
        this.refreshLatch.await(6L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)datsources, (Object)argumentCaptor.getValue());
    }

    @Test
    public void testRefreshOnEachCycleCentralizedDatasourceSchemaEnabled() throws InterruptedException {
        CentralizedDatasourceSchemaConfig config = CentralizedDatasourceSchemaConfig.enabled((boolean)true);
        this.serverView = new TestTimelineServerView(this.walker.getSegments(), Collections.emptyList());
        this.druidServers = this.serverView.getDruidServers();
        BrokerSegmentMetadataCacheConfig metadataCacheConfig = BrokerSegmentMetadataCacheConfig.create((String)"PT1S");
        metadataCacheConfig.setMetadataRefreshPeriod(Period.parse((String)"PT0.001S"));
        BrokerSegmentMetadataCache schema = new BrokerSegmentMetadataCache(CalciteTests.createMockQueryLifecycleFactory((QuerySegmentWalker)this.walker, this.conglomerate), this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new InternalQueryConfig(), (ServiceEmitter)new NoopServiceEmitter(), new PhysicalDatasourceMetadataFactory(this.globalTableJoinable, this.segmentManager), (CoordinatorClient)new NoopCoordinatorClient(), config){

            public void refresh(Set<SegmentId> segmentsToRefresh, Set<String> dataSourcesToRebuild) throws IOException {
                super.refresh(segmentsToRefresh, dataSourcesToRebuild);
                BrokerSegmentMetadataCacheTest.this.refreshLatch.countDown();
            }
        };
        this.refreshLatch = new CountDownLatch(3);
        schema.start();
        schema.awaitInitialization();
        this.refreshLatch.await(6L, TimeUnit.SECONDS);
        Assert.assertEquals((long)0L, (long)this.refreshLatch.getCount());
    }

    @Test
    public void testRefreshOnEachCycleCentralizedDatasourceSchemaDisabled() throws InterruptedException {
        BrokerSegmentMetadataCacheConfig metadataCacheConfig = BrokerSegmentMetadataCacheConfig.create((String)"PT1S");
        metadataCacheConfig.setMetadataRefreshPeriod(Period.parse((String)"PT0.001S"));
        this.serverView = new TestTimelineServerView(this.walker.getSegments(), Collections.emptyList());
        this.druidServers = this.serverView.getDruidServers();
        BrokerSegmentMetadataCache schema = new BrokerSegmentMetadataCache(CalciteTests.createMockQueryLifecycleFactory((QuerySegmentWalker)this.walker, this.conglomerate), this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new InternalQueryConfig(), (ServiceEmitter)new NoopServiceEmitter(), new PhysicalDatasourceMetadataFactory(this.globalTableJoinable, this.segmentManager), (CoordinatorClient)new NoopCoordinatorClient(), CentralizedDatasourceSchemaConfig.create()){

            public void refresh(Set<SegmentId> segmentsToRefresh, Set<String> dataSourcesToRebuild) throws IOException {
                super.refresh(segmentsToRefresh, dataSourcesToRebuild);
                BrokerSegmentMetadataCacheTest.this.refreshLatch.countDown();
            }
        };
        this.refreshLatch = new CountDownLatch(3);
        schema.start();
        schema.awaitInitialization();
        this.refreshLatch.await(6L, TimeUnit.SECONDS);
        Assert.assertEquals((long)2L, (long)this.refreshLatch.getCount());
    }

    @Test
    public void testGetTableMap() throws InterruptedException {
        BrokerSegmentMetadataCache schema = this.buildSchemaMarkAndTableLatch();
        Assert.assertEquals((Object)ImmutableSet.of((Object)"foo", (Object)"foo2", (Object)"some_datasource"), (Object)schema.getDatasourceNames());
    }

    @Test
    public void testGetTableMapFoo() throws InterruptedException {
        BrokerSegmentMetadataCache schema = this.buildSchemaMarkAndTableLatch();
        DatasourceTable.PhysicalDatasourceMetadata fooDs = (DatasourceTable.PhysicalDatasourceMetadata)schema.getDatasource("foo");
        DatasourceTable fooTable = new DatasourceTable(fooDs);
        RelDataType rowType = fooTable.getRowType((RelDataTypeFactory)new JavaTypeFactoryImpl());
        List fields = rowType.getFieldList();
        Assert.assertEquals((long)6L, (long)fields.size());
        Assert.assertEquals((Object)"__time", (Object)((RelDataTypeField)fields.get(0)).getName());
        Assert.assertEquals((Object)SqlTypeName.TIMESTAMP, (Object)((RelDataTypeField)fields.get(0)).getType().getSqlTypeName());
        Assert.assertEquals((Object)"dim2", (Object)((RelDataTypeField)fields.get(1)).getName());
        Assert.assertEquals((Object)SqlTypeName.VARCHAR, (Object)((RelDataTypeField)fields.get(1)).getType().getSqlTypeName());
        Assert.assertEquals((Object)"m1", (Object)((RelDataTypeField)fields.get(2)).getName());
        Assert.assertEquals((Object)SqlTypeName.DOUBLE, (Object)((RelDataTypeField)fields.get(2)).getType().getSqlTypeName());
        Assert.assertEquals((Object)"dim1", (Object)((RelDataTypeField)fields.get(3)).getName());
        Assert.assertEquals((Object)SqlTypeName.VARCHAR, (Object)((RelDataTypeField)fields.get(3)).getType().getSqlTypeName());
        Assert.assertEquals((Object)"cnt", (Object)((RelDataTypeField)fields.get(4)).getName());
        Assert.assertEquals((Object)SqlTypeName.BIGINT, (Object)((RelDataTypeField)fields.get(4)).getType().getSqlTypeName());
        Assert.assertEquals((Object)"unique_dim1", (Object)((RelDataTypeField)fields.get(5)).getName());
        Assert.assertEquals((Object)SqlTypeName.OTHER, (Object)((RelDataTypeField)fields.get(5)).getType().getSqlTypeName());
    }

    @Test
    public void testGetTableMapFoo2() throws InterruptedException {
        BrokerSegmentMetadataCache schema = this.buildSchemaMarkAndTableLatch();
        DatasourceTable.PhysicalDatasourceMetadata fooDs = (DatasourceTable.PhysicalDatasourceMetadata)schema.getDatasource("foo2");
        DatasourceTable fooTable = new DatasourceTable(fooDs);
        RelDataType rowType = fooTable.getRowType((RelDataTypeFactory)new JavaTypeFactoryImpl());
        List fields = rowType.getFieldList();
        Assert.assertEquals((long)3L, (long)fields.size());
        Assert.assertEquals((Object)"__time", (Object)((RelDataTypeField)fields.get(0)).getName());
        Assert.assertEquals((Object)SqlTypeName.TIMESTAMP, (Object)((RelDataTypeField)fields.get(0)).getType().getSqlTypeName());
        Assert.assertEquals((Object)"dim2", (Object)((RelDataTypeField)fields.get(1)).getName());
        Assert.assertEquals((Object)SqlTypeName.VARCHAR, (Object)((RelDataTypeField)fields.get(1)).getType().getSqlTypeName());
        Assert.assertEquals((Object)"m1", (Object)((RelDataTypeField)fields.get(2)).getName());
        Assert.assertEquals((Object)SqlTypeName.BIGINT, (Object)((RelDataTypeField)fields.get(2)).getType().getSqlTypeName());
    }

    @Test
    public void testGetTableMapSomeTable() throws InterruptedException {
        BrokerSegmentMetadataCache schema = this.buildSchemaMarkAndTableLatch(new BrokerSegmentMetadataCacheConfig(){

            public AbstractSegmentMetadataCache.ColumnTypeMergePolicy getMetadataColumnTypeMergePolicy() {
                return new AbstractSegmentMetadataCache.FirstTypeMergePolicy();
            }
        }, (CoordinatorClient)new NoopCoordinatorClient());
        DatasourceTable.PhysicalDatasourceMetadata fooDs = (DatasourceTable.PhysicalDatasourceMetadata)schema.getDatasource("some_datasource");
        DatasourceTable table = new DatasourceTable(fooDs);
        RelDataType rowType = table.getRowType((RelDataTypeFactory)new JavaTypeFactoryImpl());
        List fields = rowType.getFieldList();
        Assert.assertEquals((long)9L, (long)fields.size());
        Assert.assertEquals((Object)"__time", (Object)((RelDataTypeField)fields.get(0)).getName());
        Assert.assertEquals((Object)SqlTypeName.TIMESTAMP, (Object)((RelDataTypeField)fields.get(0)).getType().getSqlTypeName());
        Assert.assertEquals((Object)"numbery", (Object)((RelDataTypeField)fields.get(1)).getName());
        Assert.assertEquals((Object)SqlTypeName.BIGINT, (Object)((RelDataTypeField)fields.get(1)).getType().getSqlTypeName());
        Assert.assertEquals((Object)"numberyArrays", (Object)((RelDataTypeField)fields.get(2)).getName());
        Assert.assertEquals((Object)SqlTypeName.ARRAY, (Object)((RelDataTypeField)fields.get(2)).getType().getSqlTypeName());
        Assert.assertEquals((Object)SqlTypeName.DOUBLE, (Object)((RelDataTypeField)fields.get(2)).getType().getComponentType().getSqlTypeName());
        Assert.assertEquals((Object)"stringy", (Object)((RelDataTypeField)fields.get(3)).getName());
        Assert.assertEquals((Object)SqlTypeName.VARCHAR, (Object)((RelDataTypeField)fields.get(3)).getType().getSqlTypeName());
        Assert.assertEquals((Object)"array", (Object)((RelDataTypeField)fields.get(4)).getName());
        Assert.assertEquals((Object)SqlTypeName.ARRAY, (Object)((RelDataTypeField)fields.get(4)).getType().getSqlTypeName());
        Assert.assertEquals((Object)SqlTypeName.BIGINT, (Object)((RelDataTypeField)fields.get(4)).getType().getComponentType().getSqlTypeName());
        Assert.assertEquals((Object)"nested", (Object)((RelDataTypeField)fields.get(5)).getName());
        Assert.assertEquals((Object)SqlTypeName.OTHER, (Object)((RelDataTypeField)fields.get(5)).getType().getSqlTypeName());
        Assert.assertEquals((Object)"cnt", (Object)((RelDataTypeField)fields.get(6)).getName());
        Assert.assertEquals((Object)SqlTypeName.BIGINT, (Object)((RelDataTypeField)fields.get(6)).getType().getSqlTypeName());
        Assert.assertEquals((Object)"m1", (Object)((RelDataTypeField)fields.get(7)).getName());
        Assert.assertEquals((Object)SqlTypeName.DOUBLE, (Object)((RelDataTypeField)fields.get(7)).getType().getSqlTypeName());
        Assert.assertEquals((Object)"unique_dim1", (Object)((RelDataTypeField)fields.get(8)).getName());
        Assert.assertEquals((Object)SqlTypeName.OTHER, (Object)((RelDataTypeField)fields.get(8)).getType().getSqlTypeName());
    }

    @Test
    public void testGetTableMapSomeTableLeastRestrictiveTypeMerge() throws InterruptedException {
        BrokerSegmentMetadataCache schema = this.buildSchemaMarkAndTableLatch();
        DatasourceTable.PhysicalDatasourceMetadata fooDs = (DatasourceTable.PhysicalDatasourceMetadata)schema.getDatasource("some_datasource");
        DatasourceTable table = new DatasourceTable(fooDs);
        RelDataType rowType = table.getRowType((RelDataTypeFactory)new JavaTypeFactoryImpl());
        List fields = rowType.getFieldList();
        Assert.assertEquals((long)9L, (long)fields.size());
        Assert.assertEquals((Object)"__time", (Object)((RelDataTypeField)fields.get(0)).getName());
        Assert.assertEquals((Object)SqlTypeName.TIMESTAMP, (Object)((RelDataTypeField)fields.get(0)).getType().getSqlTypeName());
        Assert.assertEquals((Object)"numbery", (Object)((RelDataTypeField)fields.get(1)).getName());
        Assert.assertEquals((Object)SqlTypeName.DOUBLE, (Object)((RelDataTypeField)fields.get(1)).getType().getSqlTypeName());
        Assert.assertEquals((Object)"numberyArrays", (Object)((RelDataTypeField)fields.get(2)).getName());
        Assert.assertEquals((Object)SqlTypeName.ARRAY, (Object)((RelDataTypeField)fields.get(2)).getType().getSqlTypeName());
        Assert.assertEquals((Object)SqlTypeName.DOUBLE, (Object)((RelDataTypeField)fields.get(2)).getType().getComponentType().getSqlTypeName());
        Assert.assertEquals((Object)"stringy", (Object)((RelDataTypeField)fields.get(3)).getName());
        Assert.assertEquals((Object)SqlTypeName.ARRAY, (Object)((RelDataTypeField)fields.get(3)).getType().getSqlTypeName());
        Assert.assertEquals((Object)SqlTypeName.VARCHAR, (Object)((RelDataTypeField)fields.get(3)).getType().getComponentType().getSqlTypeName());
        Assert.assertEquals((Object)"array", (Object)((RelDataTypeField)fields.get(4)).getName());
        Assert.assertEquals((Object)SqlTypeName.ARRAY, (Object)((RelDataTypeField)fields.get(4)).getType().getSqlTypeName());
        Assert.assertEquals((Object)SqlTypeName.DOUBLE, (Object)((RelDataTypeField)fields.get(4)).getType().getComponentType().getSqlTypeName());
        Assert.assertEquals((Object)"nested", (Object)((RelDataTypeField)fields.get(5)).getName());
        Assert.assertEquals((Object)SqlTypeName.OTHER, (Object)((RelDataTypeField)fields.get(5)).getType().getSqlTypeName());
        Assert.assertEquals((Object)"cnt", (Object)((RelDataTypeField)fields.get(6)).getName());
        Assert.assertEquals((Object)SqlTypeName.BIGINT, (Object)((RelDataTypeField)fields.get(6)).getType().getSqlTypeName());
        Assert.assertEquals((Object)"m1", (Object)((RelDataTypeField)fields.get(7)).getName());
        Assert.assertEquals((Object)SqlTypeName.DOUBLE, (Object)((RelDataTypeField)fields.get(7)).getType().getSqlTypeName());
        Assert.assertEquals((Object)"unique_dim1", (Object)((RelDataTypeField)fields.get(8)).getName());
        Assert.assertEquals((Object)SqlTypeName.OTHER, (Object)((RelDataTypeField)fields.get(8)).getType().getSqlTypeName());
    }

    @Test
    public void testAvailableSegmentMetadataNumRows() throws InterruptedException {
        BrokerSegmentMetadataCache schema = this.buildSchemaMarkAndTableLatch();
        Map segmentsMetadata = schema.getSegmentMetadataSnapshot();
        List segments = segmentsMetadata.values().stream().map(AvailableSegmentMetadata::getSegment).collect(Collectors.toList());
        Assert.assertEquals((long)6L, (long)segments.size());
        DataSegment existingSegment = segments.stream().filter(segment -> segment.getDataSource().equals("foo2")).findFirst().orElse(null);
        Assert.assertNotNull((Object)existingSegment);
        AvailableSegmentMetadata existingMetadata = (AvailableSegmentMetadata)segmentsMetadata.get(existingSegment.getId());
        AvailableSegmentMetadata updatedMetadata = AvailableSegmentMetadata.from((AvailableSegmentMetadata)existingMetadata).withNumRows(5L).build();
        schema.setAvailableSegmentMetadata(existingSegment.getId(), updatedMetadata);
        Pair pair = this.druidServers.stream().flatMap(druidServer -> druidServer.iterateAllSegments().stream().filter(segment -> segment.getId().equals((Object)existingSegment.getId())).map(segment -> Pair.of((Object)druidServer, (Object)segment))).findAny().orElse(null);
        Assert.assertNotNull((Object)pair);
        ImmutableDruidServer server = (ImmutableDruidServer)pair.lhs;
        Assert.assertNotNull((Object)server);
        DruidServerMetadata druidServerMetadata = server.getMetadata();
        schema.addSegment(druidServerMetadata, existingSegment);
        segmentsMetadata = schema.getSegmentMetadataSnapshot();
        DataSegment currentSegment = segments.stream().filter(segment -> segment.getDataSource().equals("foo2")).findFirst().orElse(null);
        AvailableSegmentMetadata currentMetadata = (AvailableSegmentMetadata)segmentsMetadata.get(currentSegment.getId());
        Assert.assertEquals((Object)updatedMetadata.getSegment().getId(), (Object)currentMetadata.getSegment().getId());
        Assert.assertEquals((long)updatedMetadata.getNumRows(), (long)currentMetadata.getNumRows());
        Assert.assertEquals((long)updatedMetadata.getNumReplicas(), (long)currentMetadata.getNumReplicas());
    }

    @Test
    public void testNullDatasource() throws IOException, InterruptedException {
        BrokerSegmentMetadataCache schema = this.buildSchemaMarkAndTableLatch();
        Map segmentMetadatas = schema.getSegmentMetadataSnapshot();
        List segments = segmentMetadatas.values().stream().map(AvailableSegmentMetadata::getSegment).collect(Collectors.toList());
        Assert.assertEquals((long)6L, (long)segments.size());
        DataSegment segmentToRemove = segments.stream().filter(segment -> segment.getDataSource().equals("foo2")).findFirst().orElse(null);
        Assert.assertNotNull((Object)segmentToRemove);
        schema.removeSegment(segmentToRemove);
        schema.refreshSegments(segments.stream().map(DataSegment::getId).collect(Collectors.toSet()));
        Assert.assertEquals((long)5L, (long)schema.getSegmentMetadataSnapshot().size());
    }

    @Test
    public void testAllDatasourcesRebuiltOnDatasourceRemoval() throws IOException, InterruptedException {
        final CountDownLatch addSegmentLatch = new CountDownLatch(7);
        BrokerSegmentMetadataCache schema = new BrokerSegmentMetadataCache(CalciteTests.createMockQueryLifecycleFactory((QuerySegmentWalker)this.walker, this.conglomerate), this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new InternalQueryConfig(), (ServiceEmitter)new NoopServiceEmitter(), new PhysicalDatasourceMetadataFactory(this.globalTableJoinable, this.segmentManager), (CoordinatorClient)new NoopCoordinatorClient(), CentralizedDatasourceSchemaConfig.create()){

            public void addSegment(DruidServerMetadata server, DataSegment segment) {
                super.addSegment(server, segment);
                addSegmentLatch.countDown();
            }

            public void removeSegment(DataSegment segment) {
                super.removeSegment(segment);
            }

            public void markDataSourceAsNeedRebuild(String datasource) {
                super.markDataSourceAsNeedRebuild(datasource);
            }

            @VisibleForTesting
            public void refresh(Set<SegmentId> segmentsToRefresh, Set<String> dataSourcesToRebuild) throws IOException {
                super.refresh(segmentsToRefresh, dataSourcesToRebuild);
            }
        };
        schema.start();
        schema.awaitInitialization();
        Map segmentMetadatas = schema.getSegmentMetadataSnapshot();
        List segments = segmentMetadatas.values().stream().map(AvailableSegmentMetadata::getSegment).collect(Collectors.toList());
        Assert.assertEquals((long)6L, (long)segments.size());
        DatasourceTable.PhysicalDatasourceMetadata fooDs = (DatasourceTable.PhysicalDatasourceMetadata)schema.getDatasource("foo");
        Assert.assertTrue((boolean)fooDs.getRowSignature().getColumnNames().stream().noneMatch("dim3"::equals));
        DataSegment segmentToRemove = segments.stream().filter(segment -> segment.getDataSource().equals("foo2")).findFirst().orElse(null);
        Assert.assertNotNull((Object)segmentToRemove);
        schema.removeSegment(segmentToRemove);
        DataSegment newSegment = DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2002/P1Y")).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build();
        File tmpDir = this.temporaryFolder.newFolder();
        ImmutableList rows = ImmutableList.of((Object)this.createRow(ImmutableMap.of((Object)"t", (Object)"2002-01-01", (Object)"m1", (Object)"1.0", (Object)"dim1", (Object)"", (Object)"dim3", (Object)"c1")), (Object)this.createRow(ImmutableMap.of((Object)"t", (Object)"2002-01-02", (Object)"m1", (Object)"2.0", (Object)"dim1", (Object)"10.1", (Object)"dim3", (Object)"c2")), (Object)this.createRow(ImmutableMap.of((Object)"t", (Object)"2002-01-03", (Object)"m1", (Object)"3.0", (Object)"dim1", (Object)"2", (Object)"dim3", (Object)"c3")));
        QueryableIndex index = IndexBuilder.create().tmpDir(new File(tmpDir, "1")).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(new IncrementalIndexSchema.Builder().withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("cnt"), new DoubleSumAggregatorFactory("m1", "m1"), new HyperUniquesAggregatorFactory("unique_dim1", "dim1")}).withRollup(false).build()).rows((Iterable)rows).buildMMappedIndex();
        this.walker.add(newSegment, index);
        this.serverView.addSegment(newSegment, ServerType.HISTORICAL);
        Assert.assertTrue((boolean)addSegmentLatch.await(1L, TimeUnit.SECONDS));
        Set dataSources = segments.stream().map(DataSegment::getDataSource).collect(Collectors.toSet());
        dataSources.remove("foo2");
        LinkedHashSet<String> dataSourcesToRefresh = new LinkedHashSet<String>();
        dataSourcesToRefresh.add("foo2");
        dataSourcesToRefresh.addAll(dataSources);
        segments = schema.getSegmentMetadataSnapshot().values().stream().map(AvailableSegmentMetadata::getSegment).collect(Collectors.toList());
        schema.refresh(segments.stream().map(DataSegment::getId).collect(Collectors.toSet()), dataSourcesToRefresh);
        Assert.assertEquals((long)6L, (long)schema.getSegmentMetadataSnapshot().size());
        fooDs = (DatasourceTable.PhysicalDatasourceMetadata)schema.getDatasource("foo");
        Assert.assertTrue((boolean)fooDs.getRowSignature().getColumnNames().stream().anyMatch("dim3"::equals));
    }

    @Test
    public void testNullAvailableSegmentMetadata() throws IOException, InterruptedException {
        BrokerSegmentMetadataCache schema = this.buildSchemaMarkAndTableLatch();
        Map segmentMetadatas = schema.getSegmentMetadataSnapshot();
        List segments = segmentMetadatas.values().stream().map(AvailableSegmentMetadata::getSegment).collect(Collectors.toList());
        Assert.assertEquals((long)6L, (long)segments.size());
        DataSegment segmentToRemove = segments.stream().filter(segment -> segment.getDataSource().equals("foo")).findFirst().orElse(null);
        Assert.assertNotNull((Object)segmentToRemove);
        schema.removeSegment(segmentToRemove);
        schema.refreshSegments(segments.stream().map(DataSegment::getId).collect(Collectors.toSet()));
        Assert.assertEquals((long)5L, (long)schema.getSegmentMetadataSnapshot().size());
    }

    @Test
    public void testLocalSegmentCacheSetsDataSourceAsGlobalAndJoinable() throws InterruptedException {
        BrokerSegmentMetadataCache schema = this.buildSchemaMarkAndRefreshLatch();
        Assert.assertTrue((boolean)this.refreshLatch.await(6L, TimeUnit.SECONDS));
        DatasourceTable.PhysicalDatasourceMetadata fooTable = (DatasourceTable.PhysicalDatasourceMetadata)schema.getDatasource("foo");
        Assert.assertNotNull((Object)fooTable);
        Assert.assertTrue((boolean)(fooTable.dataSource() instanceof TableDataSource));
        Assert.assertFalse((boolean)(fooTable.dataSource() instanceof GlobalTableDataSource));
        Assert.assertFalse((boolean)fooTable.isJoinable());
        Assert.assertFalse((boolean)fooTable.isBroadcast());
        this.markDataSourceLatch = new CountDownLatch(1);
        this.refreshLatch = new CountDownLatch(1);
        DataSegment someNewBrokerSegment = DataSegment.builder((SegmentId)SegmentId.of((String)"foo", (Interval)Intervals.of((String)"2012/2013"), (String)"version1", null)).shardSpec((ShardSpec)new NumberedShardSpec(2, 3)).dimensions((List)ImmutableList.of((Object)"dim1", (Object)"dim2")).metrics((List)ImmutableList.of((Object)"met1", (Object)"met2")).projections((List)ImmutableList.of((Object)"proj1", (Object)"proj2")).binaryVersion(Integer.valueOf(1)).size(100L).build();
        this.segmentDataSourceNames.add("foo");
        this.joinableDataSourceNames.add("foo");
        this.serverView.addSegment(someNewBrokerSegment, ServerType.BROKER);
        Assert.assertTrue((boolean)this.markDataSourceLatch.await(6L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)this.refreshLatch.await(6L, TimeUnit.SECONDS));
        this.refreshLatch = new CountDownLatch(1);
        Assert.assertTrue((boolean)this.refreshLatch.await(6L, TimeUnit.SECONDS));
        fooTable = (DatasourceTable.PhysicalDatasourceMetadata)schema.getDatasource("foo");
        Assert.assertNotNull((Object)fooTable);
        Assert.assertTrue((boolean)(fooTable.dataSource() instanceof TableDataSource));
        Assert.assertTrue((boolean)(fooTable.dataSource() instanceof GlobalTableDataSource));
        Assert.assertTrue((boolean)fooTable.isJoinable());
        Assert.assertTrue((boolean)fooTable.isBroadcast());
        this.markDataSourceLatch = new CountDownLatch(1);
        this.refreshLatch = new CountDownLatch(1);
        this.joinableDataSourceNames.remove("foo");
        this.segmentDataSourceNames.remove("foo");
        this.serverView.removeSegment(someNewBrokerSegment, ServerType.BROKER);
        Assert.assertTrue((boolean)this.markDataSourceLatch.await(6L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)this.refreshLatch.await(6L, TimeUnit.SECONDS));
        this.refreshLatch = new CountDownLatch(1);
        Assert.assertTrue((boolean)this.refreshLatch.await(6L, TimeUnit.SECONDS));
        fooTable = (DatasourceTable.PhysicalDatasourceMetadata)schema.getDatasource("foo");
        Assert.assertNotNull((Object)fooTable);
        Assert.assertTrue((boolean)(fooTable.dataSource() instanceof TableDataSource));
        Assert.assertFalse((boolean)(fooTable.dataSource() instanceof GlobalTableDataSource));
        Assert.assertFalse((boolean)fooTable.isJoinable());
        Assert.assertFalse((boolean)fooTable.isBroadcast());
    }

    @Test
    public void testLocalSegmentCacheSetsDataSourceAsBroadcastButNotJoinable() throws InterruptedException {
        BrokerSegmentMetadataCache schema = this.buildSchemaMarkAndRefreshLatch();
        Assert.assertTrue((boolean)this.refreshLatch.await(6L, TimeUnit.SECONDS));
        DatasourceTable.PhysicalDatasourceMetadata fooTable = (DatasourceTable.PhysicalDatasourceMetadata)schema.getDatasource("foo");
        Assert.assertNotNull((Object)fooTable);
        Assert.assertNotNull((Object)fooTable);
        Assert.assertTrue((boolean)(fooTable.dataSource() instanceof TableDataSource));
        Assert.assertFalse((boolean)(fooTable.dataSource() instanceof GlobalTableDataSource));
        Assert.assertFalse((boolean)fooTable.isJoinable());
        Assert.assertFalse((boolean)fooTable.isBroadcast());
        this.markDataSourceLatch = new CountDownLatch(1);
        this.refreshLatch = new CountDownLatch(1);
        DataSegment someNewBrokerSegment = DataSegment.builder((SegmentId)SegmentId.of((String)"foo", (Interval)Intervals.of((String)"2012/2013"), (String)"version1", null)).shardSpec((ShardSpec)new NumberedShardSpec(2, 3)).dimensions((List)ImmutableList.of((Object)"dim1", (Object)"dim2")).metrics((List)ImmutableList.of((Object)"met1", (Object)"met2")).projections((List)ImmutableList.of((Object)"proj1", (Object)"proj2")).binaryVersion(Integer.valueOf(1)).size(100L).build();
        this.segmentDataSourceNames.add("foo");
        this.serverView.addSegment(someNewBrokerSegment, ServerType.BROKER);
        Assert.assertTrue((boolean)this.markDataSourceLatch.await(6L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)this.refreshLatch.await(6L, TimeUnit.SECONDS));
        this.refreshLatch = new CountDownLatch(1);
        Assert.assertTrue((boolean)this.refreshLatch.await(6L, TimeUnit.SECONDS));
        fooTable = (DatasourceTable.PhysicalDatasourceMetadata)schema.getDatasource("foo");
        Assert.assertNotNull((Object)fooTable);
        Assert.assertTrue((boolean)(fooTable.dataSource() instanceof TableDataSource));
        Assert.assertFalse((boolean)(fooTable.dataSource() instanceof GlobalTableDataSource));
        Assert.assertTrue((boolean)fooTable.isBroadcast());
        Assert.assertFalse((boolean)fooTable.isJoinable());
        this.markDataSourceLatch = new CountDownLatch(1);
        this.refreshLatch = new CountDownLatch(1);
        this.segmentDataSourceNames.remove("foo");
        this.serverView.removeSegment(someNewBrokerSegment, ServerType.BROKER);
        Assert.assertTrue((boolean)this.markDataSourceLatch.await(6L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)this.refreshLatch.await(6L, TimeUnit.SECONDS));
        this.refreshLatch = new CountDownLatch(1);
        Assert.assertTrue((boolean)this.refreshLatch.await(6L, TimeUnit.SECONDS));
        fooTable = (DatasourceTable.PhysicalDatasourceMetadata)schema.getDatasource("foo");
        Assert.assertNotNull((Object)fooTable);
        Assert.assertTrue((boolean)(fooTable.dataSource() instanceof TableDataSource));
        Assert.assertFalse((boolean)(fooTable.dataSource() instanceof GlobalTableDataSource));
        Assert.assertFalse((boolean)fooTable.isBroadcast());
        Assert.assertFalse((boolean)fooTable.isJoinable());
    }

    @Test
    public void testRunSegmentMetadataQueryWithContext() throws Exception {
        String brokerInternalQueryConfigJson = "{\"context\": { \"priority\": 5} }";
        TestHelper.makeJsonMapper();
        InternalQueryConfig internalQueryConfig = (InternalQueryConfig)MAPPER.readValue(MAPPER.writeValueAsString(MAPPER.readValue(brokerInternalQueryConfigJson, InternalQueryConfig.class)), InternalQueryConfig.class);
        QueryLifecycleFactory factoryMock = (QueryLifecycleFactory)EasyMock.createMock(QueryLifecycleFactory.class);
        QueryLifecycle lifecycleMock = (QueryLifecycle)EasyMock.createMock(QueryLifecycle.class);
        BrokerSegmentMetadataCache schema = new BrokerSegmentMetadataCache(factoryMock, (TimelineServerView)this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), internalQueryConfig, (ServiceEmitter)new NoopServiceEmitter(), new PhysicalDatasourceMetadataFactory(this.globalTableJoinable, this.segmentManager), (CoordinatorClient)new NoopCoordinatorClient(), CentralizedDatasourceSchemaConfig.create());
        ImmutableMap queryContext = ImmutableMap.of((Object)"priority", (Object)5, (Object)"enableParallelMerge", (Object)false);
        DataSegment segment = this.newSegment("test", 0);
        ImmutableList segmentIterable = ImmutableList.of((Object)segment.getId());
        SegmentMetadataQuery expectedMetadataQuery = new SegmentMetadataQuery((DataSource)new TableDataSource(segment.getDataSource()), (QuerySegmentSpec)new MultipleSpecificSegmentSpec(segmentIterable.stream().map(SegmentId::toDescriptor).collect(Collectors.toList())), (ColumnIncluderator)new AllColumnIncluderator(), Boolean.valueOf(false), (Map)queryContext, EnumSet.noneOf(SegmentMetadataQuery.AnalysisType.class), Boolean.valueOf(false), null, null);
        EasyMock.expect((Object)factoryMock.factorize()).andReturn((Object)lifecycleMock).once();
        EasyMock.expect((Object)lifecycleMock.runSimple((Query)expectedMetadataQuery, AllowAllAuthenticator.ALLOW_ALL_RESULT, AuthorizationResult.allowWithRestriction((Map)ImmutableMap.of((Object)"test", Optional.of(NoRestrictionPolicy.instance()))))).andReturn((Object)QueryResponse.withEmptyContext((Sequence)Sequences.empty()));
        EasyMock.replay((Object[])new Object[]{factoryMock, lifecycleMock});
        schema.runSegmentMetadataQuery((Iterable)segmentIterable);
        EasyMock.verify((Object[])new Object[]{factoryMock, lifecycleMock});
    }

    @Test
    public void testStaleDatasourceRefresh() throws IOException, InterruptedException {
        BrokerSegmentMetadataCache schema = this.buildSchemaMarkAndTableLatch();
        HashSet segments = new HashSet();
        HashSet<String> datasources = new HashSet<String>();
        datasources.add("wat");
        Assert.assertNull((Object)schema.getDatasource("wat"));
        schema.refresh(segments, datasources);
        Assert.assertNull((Object)schema.getDatasource("wat"));
    }

    @Test
    public void testRefreshShouldEmitMetrics() throws InterruptedException, IOException {
        final String dataSource = "xyz";
        final CountDownLatch addSegmentLatch = new CountDownLatch(2);
        StubServiceEmitter emitter = new StubServiceEmitter("broker", "host");
        BrokerSegmentMetadataCache schema = new BrokerSegmentMetadataCache(CalciteTests.createMockQueryLifecycleFactory((QuerySegmentWalker)this.walker, this.conglomerate), this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new InternalQueryConfig(), (ServiceEmitter)emitter, new PhysicalDatasourceMetadataFactory(this.globalTableJoinable, this.segmentManager), (CoordinatorClient)new NoopCoordinatorClient(), CentralizedDatasourceSchemaConfig.create()){

            public void addSegment(DruidServerMetadata server, DataSegment segment) {
                super.addSegment(server, segment);
                if (dataSource.equals(segment.getDataSource())) {
                    addSegmentLatch.countDown();
                }
            }

            public void removeSegment(DataSegment segment) {
                super.removeSegment(segment);
            }
        };
        ImmutableList segments = ImmutableList.of((Object)this.newSegment(dataSource, 1), (Object)this.newSegment(dataSource, 2));
        this.serverView.addSegment((DataSegment)segments.get(0), ServerType.HISTORICAL);
        this.serverView.addSegment((DataSegment)segments.get(1), ServerType.INDEXER_EXECUTOR);
        Assert.assertTrue((boolean)addSegmentLatch.await(1L, TimeUnit.SECONDS));
        schema.refresh(segments.stream().map(DataSegment::getId).collect(Collectors.toSet()), (Set)Sets.newHashSet((Object[])new String[]{dataSource}));
        emitter.verifyEmitted("segment/schemaCache/refresh/time", Map.of("dataSource", dataSource), 1);
        emitter.verifyEmitted("segment/schemaCache/refresh/count", Map.of("dataSource", dataSource), 1);
    }

    @Test
    public void testInvokeSegmentSchemaAnnounced() throws InterruptedException {
        this.buildSchemaMarkAndTableLatch();
        this.serverView.invokeSegmentSchemasAnnouncedDummy();
    }

    @Test
    public void testNoDatasourceSchemaWhenNoSegmentMetadata() throws InterruptedException, IOException {
        BrokerSegmentMetadataCacheConfig config = new BrokerSegmentMetadataCacheConfig();
        config.setDisableSegmentMetadataQueries(true);
        BrokerSegmentMetadataCache schema = this.buildSchemaMarkAndTableLatch(config, (CoordinatorClient)new NoopCoordinatorClient());
        schema.start();
        schema.awaitInitialization();
        List segments = schema.getSegmentMetadataSnapshot().values().stream().map(AvailableSegmentMetadata::getSegment).collect(Collectors.toList());
        schema.refresh(segments.stream().map(DataSegment::getId).collect(Collectors.toSet()), Collections.singleton("foo"));
        Assert.assertNull((Object)schema.getDatasource("foo"));
    }

    @Test
    public void testTombstoneSegmentIsNotRefreshed() throws IOException {
        String brokerInternalQueryConfigJson = "{\"context\": { \"priority\": 5} }";
        TestHelper.makeJsonMapper();
        InternalQueryConfig internalQueryConfig = (InternalQueryConfig)MAPPER.readValue(MAPPER.writeValueAsString(MAPPER.readValue(brokerInternalQueryConfigJson, InternalQueryConfig.class)), InternalQueryConfig.class);
        QueryLifecycleFactory factoryMock = (QueryLifecycleFactory)EasyMock.createMock(QueryLifecycleFactory.class);
        QueryLifecycle lifecycleMock = (QueryLifecycle)EasyMock.createMock(QueryLifecycle.class);
        BrokerSegmentMetadataCache schema = new BrokerSegmentMetadataCache(factoryMock, (TimelineServerView)this.serverView, SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), internalQueryConfig, (ServiceEmitter)new NoopServiceEmitter(), new PhysicalDatasourceMetadataFactory(this.globalTableJoinable, this.segmentManager), (CoordinatorClient)new NoopCoordinatorClient(), CentralizedDatasourceSchemaConfig.create());
        ImmutableMap queryContext = ImmutableMap.of((Object)"priority", (Object)5, (Object)"enableParallelMerge", (Object)false);
        DataSegment segment = this.newSegment("test", 0);
        DataSegment tombstone = DataSegment.builder().dataSource("test").interval(Intervals.of((String)"2012-01-01/2012-01-02")).version(DateTimes.of((String)"2012-01-01T11:22:33.444Z").toString()).shardSpec((ShardSpec)new TombstoneShardSpec()).loadSpec(Collections.singletonMap("type", "tombstone")).size(0L).build();
        ImmutableDruidServer historicalServer = this.druidServers.stream().filter(s -> s.getType().equals((Object)ServerType.HISTORICAL)).findAny().orElse(null);
        Assert.assertNotNull((Object)historicalServer);
        DruidServerMetadata historicalServerMetadata = historicalServer.getMetadata();
        schema.addSegment(historicalServerMetadata, segment);
        schema.addSegment(historicalServerMetadata, tombstone);
        Assert.assertFalse((boolean)schema.getSegmentsNeedingRefresh().contains(tombstone.getId()));
        ImmutableList segmentIterable = ImmutableList.of((Object)segment.getId(), (Object)tombstone.getId());
        SegmentMetadataQuery expectedMetadataQuery = new SegmentMetadataQuery((DataSource)new TableDataSource(segment.getDataSource()), (QuerySegmentSpec)new MultipleSpecificSegmentSpec(segmentIterable.stream().filter(id -> !id.equals((Object)tombstone.getId())).map(SegmentId::toDescriptor).collect(Collectors.toList())), (ColumnIncluderator)new AllColumnIncluderator(), Boolean.valueOf(false), (Map)queryContext, EnumSet.noneOf(SegmentMetadataQuery.AnalysisType.class), Boolean.valueOf(false), null, null);
        EasyMock.expect((Object)factoryMock.factorize()).andReturn((Object)lifecycleMock).once();
        EasyMock.expect((Object)lifecycleMock.runSimple((Query)expectedMetadataQuery, AllowAllAuthenticator.ALLOW_ALL_RESULT, AuthorizationResult.allowWithRestriction((Map)ImmutableMap.of((Object)"test", Optional.of(NoRestrictionPolicy.instance()))))).andReturn((Object)QueryResponse.withEmptyContext((Sequence)Sequences.empty()));
        EasyMock.replay((Object[])new Object[]{factoryMock, lifecycleMock});
        HashSet<SegmentId> segmentsToRefresh = new HashSet<SegmentId>();
        segmentsToRefresh.add(segment.getId());
        schema.refresh(segmentsToRefresh, Collections.singleton("test"));
        EasyMock.verify((Object[])new Object[]{factoryMock, lifecycleMock});
        Assert.assertFalse((boolean)schema.getSegmentsNeedingRefresh().contains(tombstone.getId()));
        AvailableSegmentMetadata availableSegmentMetadata = schema.getAvailableSegmentMetadata("test", tombstone.getId());
        Assert.assertNotNull((Object)availableSegmentMetadata);
        Assert.assertFalse((boolean)schema.getSegmentsNeedingRefresh().contains(tombstone.getId()));
        HashSet metadatas = new HashSet();
        schema.iterateSegmentMetadata().forEachRemaining(metadatas::add);
        Assert.assertEquals((long)1L, (long)metadatas.stream().filter(metadata -> metadata.getSegment().isTombstone()).count());
        Assert.assertFalse((boolean)schema.getSegmentsNeedingRefresh().contains(tombstone.getId()));
    }
}

