/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.filtration;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.druid.query.filter.AndDimFilter;
import org.apache.druid.query.filter.BoundDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.NotDimFilter;
import org.apache.druid.query.filter.OrDimFilter;
import org.apache.druid.query.filter.RangeFilter;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.sql.calcite.BaseCalciteQueryTest;
import org.apache.druid.sql.calcite.filtration.CombineAndSimplifyBounds;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.junit.Assert;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class CombineAndSimplifyBoundsTest
extends BaseCalciteQueryTest {
    public static List<Object[]> getParameters() {
        return ImmutableList.of((Object)new Object[]{RangeFilterType.BOUND}, (Object)new Object[]{RangeFilterType.RANGE});
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    public void testNotAZ(RangeFilterType rangeFilter) {
        String dim1 = "dim1";
        OrDimFilter inputFilter = CombineAndSimplifyBoundsTest.or(rangeFilter.lt(dim1, "a"), rangeFilter.gt(dim1, "z"));
        NotDimFilter expected = CombineAndSimplifyBoundsTest.not(rangeFilter.range("a", true, dim1, true, "z"));
        this.check((DimFilter)inputFilter, (DimFilter)expected);
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    public void testAZ(RangeFilterType rangeFilter) {
        String dim1 = "dim1";
        AndDimFilter inputFilter = CombineAndSimplifyBoundsTest.and(rangeFilter.gt(dim1, "a"), rangeFilter.lt(dim1, "z"));
        DimFilter expected = rangeFilter.range("a", false, dim1, false, "z");
        this.check((DimFilter)inputFilter, expected);
    }

    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    public void testNot2(RangeFilterType rangeFilter) {
        String dim1 = "dim1";
        OrDimFilter inputFilter = CombineAndSimplifyBoundsTest.or(rangeFilter.le(dim1, "a"), rangeFilter.range("f", true, dim1, false, "j"), rangeFilter.gt(dim1, "z"));
        NotDimFilter expected = CombineAndSimplifyBoundsTest.not((DimFilter)CombineAndSimplifyBoundsTest.or(rangeFilter.range("a", false, dim1, false, "f"), rangeFilter.range("j", true, dim1, true, "z")));
        this.check((DimFilter)inputFilter, (DimFilter)expected);
    }

    private void check(DimFilter inputFilter, DimFilter expected) {
        Filtration filt = Filtration.create((DimFilter)inputFilter, null);
        Filtration ret = CombineAndSimplifyBounds.instance().apply(filt);
        Assert.assertEquals((Object)expected, (Object)ret.getDimFilter());
    }

    static enum RangeFilterType {
        BOUND{

            @Override
            public DimFilter range(String lit1, boolean gte, String name, boolean lte, String lit2) {
                return new BoundDimFilter(name, lit1, lit2, Boolean.valueOf(!gte), Boolean.valueOf(!lte), Boolean.valueOf(true), null, null);
            }
        }
        ,
        RANGE{

            @Override
            public DimFilter range(String lit1, boolean gte, String name, boolean lte, String lit2) {
                return new RangeFilter(name, ColumnType.STRING, (Object)lit1, (Object)lit2, Boolean.valueOf(!gte), Boolean.valueOf(!lte), null);
            }
        };


        public final DimFilter lt(String name, String literal) {
            return this.range(null, false, name, false, literal);
        }

        public final DimFilter le(String name, String literal) {
            return this.range(null, false, name, true, literal);
        }

        public final DimFilter gt(String name, String literal) {
            return this.range(literal, false, name, false, null);
        }

        public final DimFilter ge(String name, String literal) {
            return this.range(literal, true, name, false, null);
        }

        public final DimFilter eq(String name, String literal) {
            return this.range(literal, true, name, true, literal);
        }

        public abstract DimFilter range(String var1, boolean var2, String var3, boolean var4, String var5);
    }
}

