/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexWindowBounds;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.RegexDimExtractionFn;
import org.apache.druid.query.extraction.SubstringDimExtractionFn;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.RegexDimFilter;
import org.apache.druid.query.filter.SearchQueryDimFilter;
import org.apache.druid.query.search.ContainsSearchQuerySpec;
import org.apache.druid.query.search.SearchQuerySpec;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.DruidLiteral;
import org.apache.druid.sql.calcite.expression.ExpressionTestHelper;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.SimpleExtraction;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ContainsOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.DateTruncOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.HumanReadableFormatOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.LPadOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.LeftOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ParseLongOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.RPadOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.RegexpExtractOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.RegexpLikeOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.RegexpReplaceOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.RepeatOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.ReverseOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.RightOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.StringFormatOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.StrposOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.SubstringOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.TimeCeilOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.TimeExtractOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.TimeFloorOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.TimeFormatOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.TimeParseOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.TimeShiftOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.TruncateOperatorConversion;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.DruidOperatorTable;
import org.apache.druid.sql.calcite.planner.DruidTypeSystem;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.CannotBuildQueryException;
import org.apache.druid.sql.calcite.util.CalciteTestBase;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.StringContains;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class ExpressionsTest
extends CalciteTestBase {
    private static final RowSignature ROW_SIGNATURE = RowSignature.builder().add("t", ColumnType.LONG).add("a", ColumnType.LONG).add("b", ColumnType.LONG).add("p", ColumnType.LONG).add("x", ColumnType.FLOAT).add("y", ColumnType.LONG).add("z", ColumnType.FLOAT).add("s", ColumnType.STRING).add("nan", ColumnType.DOUBLE).add("inf", ColumnType.DOUBLE).add("-inf", ColumnType.DOUBLE).add("fnan", ColumnType.FLOAT).add("finf", ColumnType.FLOAT).add("-finf", ColumnType.FLOAT).add("hexstr", ColumnType.STRING).add("intstr", ColumnType.STRING).add("spacey", ColumnType.STRING).add("newliney", ColumnType.STRING).add("tstr", ColumnType.STRING).add("dstr", ColumnType.STRING).add("timezone", ColumnType.STRING).build();
    private static final Map<String, Object> BINDINGS = ImmutableMap.builder().put((Object)"t", (Object)DateTimes.of((String)"2000-02-03T04:05:06").getMillis()).put((Object)"a", (Object)10).put((Object)"b", (Object)25).put((Object)"p", (Object)3).put((Object)"x", (Object)2.25).put((Object)"y", (Object)3.0).put((Object)"z", (Object)-2.25).put((Object)"o", (Object)0).put((Object)"nan", (Object)Double.NaN).put((Object)"inf", (Object)Double.POSITIVE_INFINITY).put((Object)"-inf", (Object)Double.NEGATIVE_INFINITY).put((Object)"fnan", (Object)Float.valueOf(Float.NaN)).put((Object)"finf", (Object)Float.valueOf(Float.POSITIVE_INFINITY)).put((Object)"-finf", (Object)Float.valueOf(Float.NEGATIVE_INFINITY)).put((Object)"s", (Object)"foo").put((Object)"hexstr", (Object)"EF").put((Object)"intstr", (Object)"-100").put((Object)"spacey", (Object)"  hey there  ").put((Object)"newliney", (Object)"beep\nboop").put((Object)"tstr", (Object)"2000-02-03 04:05:06").put((Object)"dstr", (Object)"2000-02-03").put((Object)"timezone", (Object)"America/Los_Angeles").build();
    private ExpressionTestHelper testHelper;
    final DruidOperatorTable operatorTable = new DruidOperatorTable(Collections.emptySet(), Collections.emptySet());

    @BeforeEach
    public void setUp() {
        this.testHelper = new ExpressionTestHelper(ROW_SIGNATURE, BINDINGS);
    }

    private SqlOperatorConversion getOperatorConversion(SqlFunction round) {
        return this.operatorTable.lookupOperatorConversion((SqlOperator)round);
    }

    @Test
    public void testConcat() {
        this.testHelper.testExpression(SqlTypeName.VARCHAR, (SqlOperator)SqlStdOperatorTable.CONCAT, (List<RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral("bar")), DruidExpression.ofExpression((ColumnType)ColumnType.STRING, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"concat"), (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.STRING, (String)"s"), (Object)DruidExpression.ofStringLiteral((String)"bar"))), "foobar");
    }

    @Test
    public void testCharacterLength() {
        this.testHelper.testExpression((SqlOperator)SqlStdOperatorTable.CHARACTER_LENGTH, this.testHelper.makeInputRef("s"), DruidExpression.ofExpression((ColumnType)ColumnType.LONG, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"strlen"), (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.STRING, (String)"s"))), (Object)3L);
    }

    @Test
    public void testSubstring() {
        this.testHelper.testExpressionString(new SubstringOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral(1), (Object)this.testHelper.makeLiteral(2)), ExpressionsTest.makeExpression(SimpleExtraction.of((String)"s", (ExtractionFn)new SubstringDimExtractionFn(0, Integer.valueOf(2))), "substring(\"s\", 0, 2)"), "fo");
        this.testHelper.testExpressionString(new SubstringOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral(2), (Object)this.testHelper.makeLiteral(1)), ExpressionsTest.makeExpression(SimpleExtraction.of((String)"s", (ExtractionFn)new SubstringDimExtractionFn(1, Integer.valueOf(1))), "substring(\"s\", 1, 1)"), "o");
        this.testHelper.testExpressionString(new SubstringOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral(1)), ExpressionsTest.makeExpression(SimpleExtraction.of((String)"s", (ExtractionFn)new SubstringDimExtractionFn(0, null)), "substring(\"s\", 0, -1)"), "foo");
        this.testHelper.testExpressionString(new SubstringOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral(2)), ExpressionsTest.makeExpression(SimpleExtraction.of((String)"s", (ExtractionFn)new SubstringDimExtractionFn(1, null)), "substring(\"s\", 1, -1)"), "oo");
        this.testHelper.testExpressionString(new SubstringOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral(1), (Object)this.testHelper.makeInputRef("p")), ExpressionsTest.makeExpression("substring(\"s\", 0, \"p\")"), "foo");
        this.testHelper.testExpressionString(new SubstringOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("spacey"), (Object)this.testHelper.makeInputRef("p")), ExpressionsTest.makeExpression("substring(\"spacey\", (\"p\" - 1), -1)"), "hey there  ");
        this.testHelper.testExpressionString(new SubstringOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("spacey"), (Object)this.testHelper.makeInputRef("p"), (Object)this.testHelper.makeInputRef("p")), ExpressionsTest.makeExpression("substring(\"spacey\", (\"p\" - 1), \"p\")"), "hey");
    }

    @Test
    public void testRegexpExtract() {
        this.testHelper.testExpressionString((SqlOperator)new RegexpExtractOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral("x(.)"), (Object)this.testHelper.makeLiteral(1)), ExpressionsTest.makeExpression(SimpleExtraction.of((String)"s", (ExtractionFn)new RegexDimExtractionFn("x(.)", Integer.valueOf(1), Boolean.valueOf(true), null)), "regexp_extract(\"s\",'x(.)',1)"), null);
        this.testHelper.testExpressionString((SqlOperator)new RegexpExtractOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral("(o)"), (Object)this.testHelper.makeLiteral(1)), ExpressionsTest.makeExpression(SimpleExtraction.of((String)"s", (ExtractionFn)new RegexDimExtractionFn("(o)", Integer.valueOf(1), Boolean.valueOf(true), null)), "regexp_extract(\"s\",'(o)',1)"), "o");
        this.testHelper.testExpressionString((SqlOperator)new RegexpExtractOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeCall((SqlOperator)SqlStdOperatorTable.CONCAT, new RexNode[]{this.testHelper.makeLiteral("Z"), this.testHelper.makeInputRef("s")}), (Object)this.testHelper.makeLiteral("Zf(.)")), ExpressionsTest.makeExpression("regexp_extract(concat('Z',\"s\"),'Zf(.)')"), "Zfo");
        this.testHelper.testExpressionString((SqlOperator)new RegexpExtractOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral("f(.)"), (Object)this.testHelper.makeLiteral(1)), ExpressionsTest.makeExpression(SimpleExtraction.of((String)"s", (ExtractionFn)new RegexDimExtractionFn("f(.)", Integer.valueOf(1), Boolean.valueOf(true), null)), "regexp_extract(\"s\",'f(.)',1)"), "o");
        this.testHelper.testExpressionString((SqlOperator)new RegexpExtractOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral("f(.)")), ExpressionsTest.makeExpression(SimpleExtraction.of((String)"s", (ExtractionFn)new RegexDimExtractionFn("f(.)", Integer.valueOf(0), Boolean.valueOf(true), null)), "regexp_extract(\"s\",'f(.)')"), "fo");
        this.testHelper.testExpressionString((SqlOperator)new RegexpExtractOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral("")), ExpressionsTest.makeExpression(SimpleExtraction.of((String)"s", (ExtractionFn)new RegexDimExtractionFn("", Integer.valueOf(0), Boolean.valueOf(true), null)), "regexp_extract(\"s\",'')"), "");
        this.testHelper.testExpressionString((SqlOperator)new RegexpExtractOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral("")), ExpressionsTest.makeExpression(SimpleExtraction.of((String)"s", (ExtractionFn)new RegexDimExtractionFn("", Integer.valueOf(0), Boolean.valueOf(true), null)), "regexp_extract(\"s\",'')"), "");
        this.testHelper.testExpressionString((SqlOperator)new RegexpExtractOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeNullLiteral(SqlTypeName.VARCHAR), (Object)this.testHelper.makeLiteral("(.)")), ExpressionsTest.makeExpression("regexp_extract(null,'(.)')"), null);
        this.testHelper.testExpressionString((SqlOperator)new RegexpExtractOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeNullLiteral(SqlTypeName.VARCHAR), (Object)this.testHelper.makeLiteral("")), ExpressionsTest.makeExpression("regexp_extract(null,'')"), null);
        this.testHelper.testExpressionString((SqlOperator)new RegexpExtractOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeNullLiteral(SqlTypeName.VARCHAR), (Object)this.testHelper.makeLiteral("null")), ExpressionsTest.makeExpression("regexp_extract(null,'null')"), null);
    }

    @Test
    public void testRegexpReplace() {
        this.testHelper.testExpressionString((SqlOperator)new RegexpReplaceOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral("x(.)"), (Object)this.testHelper.makeLiteral("z")), ExpressionsTest.makeExpression("regexp_replace(\"s\",'x(.)','z')"), "foo");
        this.testHelper.testExpressionString((SqlOperator)new RegexpReplaceOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral("(o)"), (Object)this.testHelper.makeLiteral("z")), ExpressionsTest.makeExpression("regexp_replace(\"s\",'(o)','z')"), "fzz");
        this.testHelper.testExpressionString((SqlOperator)new RegexpReplaceOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeCall((SqlOperator)SqlStdOperatorTable.CONCAT, new RexNode[]{this.testHelper.makeLiteral("Z"), this.testHelper.makeInputRef("s")}), (Object)this.testHelper.makeLiteral("Zf(.)"), (Object)this.testHelper.makeLiteral("z")), ExpressionsTest.makeExpression("regexp_replace(concat('Z',\"s\"),'Zf(.)','z')"), "zo");
        this.testHelper.testExpressionString((SqlOperator)new RegexpReplaceOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral("f(.)"), (Object)this.testHelper.makeLiteral("$1")), ExpressionsTest.makeExpression("regexp_replace(\"s\",'f(.)','$1')"), "oo");
    }

    @Test
    public void testRegexpLike() {
        this.testHelper.testExpressionString((SqlOperator)new RegexpLikeOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral("f.")), ExpressionsTest.makeExpression("regexp_like(\"s\",'f.')"), 1L);
        this.testHelper.testExpressionString((SqlOperator)new RegexpLikeOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral("o")), ExpressionsTest.makeExpression("regexp_like(\"s\",'o')"), 1L);
        this.testHelper.testExpressionString((SqlOperator)new RegexpLikeOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral("x.")), ExpressionsTest.makeExpression("regexp_like(\"s\",'x.')"), 0L);
        this.testHelper.testExpressionString((SqlOperator)new RegexpLikeOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral("")), ExpressionsTest.makeExpression("regexp_like(\"s\",'')"), 1L);
        this.testHelper.testExpressionString((SqlOperator)new RegexpLikeOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeLiteral("beep\nboop"), (Object)this.testHelper.makeLiteral("^beep$")), ExpressionsTest.makeExpression("regexp_like('beep\\u000Aboop','^beep$')"), 0L);
        this.testHelper.testExpressionString((SqlOperator)new RegexpLikeOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeLiteral("beep\nboop"), (Object)this.testHelper.makeLiteral("^beep\\nboop$")), ExpressionsTest.makeExpression("regexp_like('beep\\u000Aboop','^beep\\u005Cnboop$')"), 1L);
        this.testHelper.testExpressionString((SqlOperator)new RegexpLikeOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("newliney"), (Object)this.testHelper.makeLiteral("^beep$")), ExpressionsTest.makeExpression("regexp_like(\"newliney\",'^beep$')"), 0L);
        this.testHelper.testExpressionString((SqlOperator)new RegexpLikeOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("newliney"), (Object)this.testHelper.makeLiteral("^beep\\nboop$")), ExpressionsTest.makeExpression("regexp_like(\"newliney\",'^beep\\u005Cnboop$')"), 1L);
        this.testHelper.testExpressionString((SqlOperator)new RegexpLikeOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("newliney"), (Object)this.testHelper.makeLiteral("boo")), ExpressionsTest.makeExpression("regexp_like(\"newliney\",'boo')"), 1L);
        this.testHelper.testExpressionString((SqlOperator)new RegexpLikeOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("newliney"), (Object)this.testHelper.makeLiteral("^boo")), ExpressionsTest.makeExpression("regexp_like(\"newliney\",'^boo')"), 0L);
        this.testHelper.testExpressionString((SqlOperator)new RegexpLikeOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeCall((SqlOperator)SqlStdOperatorTable.CONCAT, new RexNode[]{this.testHelper.makeLiteral("Z"), this.testHelper.makeInputRef("s")}), (Object)this.testHelper.makeLiteral("x(.)")), ExpressionsTest.makeExpression("regexp_like(concat('Z',\"s\"),'x(.)')"), 0L);
        this.testHelper.testExpressionString((SqlOperator)new RegexpLikeOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeNullLiteral(SqlTypeName.VARCHAR), (Object)this.testHelper.makeLiteral("(.)")), ExpressionsTest.makeExpression("regexp_like(null,'(.)')"), null);
        this.testHelper.testExpressionString((SqlOperator)new RegexpLikeOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeNullLiteral(SqlTypeName.VARCHAR), (Object)this.testHelper.makeLiteral("")), ExpressionsTest.makeExpression("regexp_like(null,'')"), null);
        this.testHelper.testExpressionString((SqlOperator)new RegexpLikeOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeNullLiteral(SqlTypeName.VARCHAR), (Object)this.testHelper.makeLiteral("null")), ExpressionsTest.makeExpression("regexp_like(null,'null')"), null);
    }

    @Test
    public void testRegexpLikeAsFilter() {
        this.testHelper.testFilter((SqlOperator)new RegexpLikeOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral("f.")), Collections.emptyList(), (DimFilter)new RegexDimFilter("s", "f.", null), true);
        this.testHelper.testFilter((SqlOperator)new RegexpLikeOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral("o")), Collections.emptyList(), (DimFilter)new RegexDimFilter("s", "o", null), true);
        this.testHelper.testFilter((SqlOperator)new RegexpLikeOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral("x.")), Collections.emptyList(), (DimFilter)new RegexDimFilter("s", "x.", null), false);
        this.testHelper.testFilter((SqlOperator)new RegexpLikeOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral("")), Collections.emptyList(), (DimFilter)new RegexDimFilter("s", "", null), true);
        this.testHelper.testFilter((SqlOperator)new RegexpLikeOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("newliney"), (Object)this.testHelper.makeLiteral("^beep$")), Collections.emptyList(), (DimFilter)new RegexDimFilter("newliney", "^beep$", null), false);
        this.testHelper.testFilter((SqlOperator)new RegexpLikeOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("newliney"), (Object)this.testHelper.makeLiteral("^beep\\nboop$")), Collections.emptyList(), (DimFilter)new RegexDimFilter("newliney", "^beep\\nboop$", null), true);
        this.testHelper.testFilter((SqlOperator)new RegexpLikeOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeCall((SqlOperator)SqlStdOperatorTable.CONCAT, new RexNode[]{this.testHelper.makeLiteral("Z"), this.testHelper.makeInputRef("s")}), (Object)this.testHelper.makeLiteral("x(.)")), (List<VirtualColumn>)ImmutableList.of((Object)new ExpressionVirtualColumn("v0", "concat('Z',\"s\")", ColumnType.STRING, TestExprMacroTable.INSTANCE)), (DimFilter)new RegexDimFilter("v0", "x(.)", null), false);
    }

    @Test
    public void testStringFormat() {
        this.testHelper.testExpressionString(new StringFormatOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeLiteral("%x"), (Object)this.testHelper.makeInputRef("b")), ExpressionsTest.makeExpression("format('%x',\"b\")"), "19");
        this.testHelper.testExpressionString(new StringFormatOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeLiteral("%s %,d"), (Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral(1234)), ExpressionsTest.makeExpression("format('%s %,d',\"s\",1234)"), "foo 1,234");
        this.testHelper.testExpressionString(new StringFormatOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeLiteral("%s %,d"), (Object)this.testHelper.makeInputRef("s")), ExpressionsTest.makeExpression("format('%s %,d',\"s\")"), "%s %,d; foo");
        this.testHelper.testExpressionString(new StringFormatOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeLiteral("%s %,d"), (Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral(1234), (Object)this.testHelper.makeLiteral(6789)), ExpressionsTest.makeExpression("format('%s %,d',\"s\",1234,6789)"), "foo 1,234");
        this.testHelper.testExpressionString(new StringFormatOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeLiteral("%.2f %.2f %.2f"), (Object)this.testHelper.makeLiteral(1234.0), (Object)this.testHelper.makeLiteral(123.4), (Object)this.testHelper.makeLiteral(123.456789)), ExpressionsTest.makeExpression("format('%.2f %.2f %.2f',1234.0,123.4,123.456789)"), "1234.00 123.40 123.46");
    }

    @Test
    public void testStrpos() {
        this.testHelper.testExpressionString(new StrposOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral("oo")), ExpressionsTest.makeExpression("(strpos(\"s\",'oo') + 1)"), 2L);
        this.testHelper.testExpressionString(new StrposOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral("ax")), ExpressionsTest.makeExpression("(strpos(\"s\",'ax') + 1)"), 0L);
        this.testHelper.testExpressionString(new StrposOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeNullLiteral(SqlTypeName.VARCHAR), (Object)this.testHelper.makeLiteral("ax")), ExpressionsTest.makeExpression("(strpos(null,'ax') + 1)"), null);
    }

    @Test
    public void testParseLong() {
        this.testHelper.testExpression(new ParseLongOperatorConversion().calciteOperator(), this.testHelper.makeInputRef("intstr"), DruidExpression.ofExpression((ColumnType)ColumnType.LONG, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"parse_long"), (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.STRING, (String)"intstr"))), (Object)-100L);
        this.testHelper.testExpressionString(new ParseLongOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("hexstr"), (Object)this.testHelper.makeLiteral(BigDecimal.valueOf(16L))), DruidExpression.ofExpression((ColumnType)ColumnType.LONG, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"parse_long"), (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.STRING, (String)"hexstr"), (Object)DruidExpression.ofLiteral((ColumnType)ColumnType.LONG, (String)DruidExpression.longLiteral((long)16L)))), 239L);
        this.testHelper.testExpressionString(new ParseLongOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeCall((SqlOperator)SqlStdOperatorTable.CONCAT, new RexNode[]{this.testHelper.makeLiteral("0x"), this.testHelper.makeInputRef("hexstr")}), (Object)this.testHelper.makeLiteral(BigDecimal.valueOf(16L))), DruidExpression.ofExpression((ColumnType)ColumnType.LONG, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"parse_long"), (List)ImmutableList.of((Object)DruidExpression.ofExpression((ColumnType)ColumnType.STRING, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"concat"), (List)ImmutableList.of((Object)DruidExpression.ofStringLiteral((String)"0x"), (Object)DruidExpression.ofColumn((ColumnType)ColumnType.STRING, (String)"hexstr"))), (Object)DruidExpression.ofLiteral((ColumnType)ColumnType.LONG, (String)DruidExpression.longLiteral((long)16L)))), 239L);
        this.testHelper.testExpression(new ParseLongOperatorConversion().calciteOperator(), this.testHelper.makeInputRef("hexstr"), DruidExpression.ofExpression((ColumnType)ColumnType.LONG, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"parse_long"), (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.STRING, (String)"hexstr"))), null);
    }

    @Test
    public void testPosition() {
        this.testHelper.testExpressionString((SqlOperator)SqlStdOperatorTable.POSITION, (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeLiteral("oo"), (Object)this.testHelper.makeInputRef("s")), ExpressionsTest.makeExpression(ColumnType.LONG, "(strpos(\"s\",'oo',0) + 1)"), 2L);
        this.testHelper.testExpressionString((SqlOperator)SqlStdOperatorTable.POSITION, (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeLiteral("oo"), (Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral(BigDecimal.valueOf(2L))), ExpressionsTest.makeExpression(ColumnType.LONG, "(strpos(\"s\",'oo',(2 - 1)) + 1)"), 2L);
        this.testHelper.testExpressionString((SqlOperator)SqlStdOperatorTable.POSITION, (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeLiteral("oo"), (Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral(BigDecimal.valueOf(3L))), ExpressionsTest.makeExpression(ColumnType.LONG, "(strpos(\"s\",'oo',(3 - 1)) + 1)"), 0L);
    }

    @Test
    public void testPower() {
        this.testHelper.testExpressionString((SqlOperator)SqlStdOperatorTable.POWER, (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("a"), (Object)this.testHelper.makeLiteral(2)), ExpressionsTest.makeExpression(ColumnType.DOUBLE, "pow(\"a\",2)"), 100.0);
    }

    @Test
    public void testFloor() {
        this.testHelper.testExpression((SqlOperator)SqlStdOperatorTable.FLOOR, this.testHelper.makeInputRef("a"), DruidExpression.ofExpression((ColumnType)ColumnType.LONG, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"floor"), (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.LONG, (String)"a"))), (Object)10.0);
        this.testHelper.testExpression((SqlOperator)SqlStdOperatorTable.FLOOR, this.testHelper.makeInputRef("x"), DruidExpression.ofExpression((ColumnType)ColumnType.FLOAT, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"floor"), (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"x"))), (Object)2.0);
        this.testHelper.testExpression((SqlOperator)SqlStdOperatorTable.FLOOR, this.testHelper.makeInputRef("y"), DruidExpression.ofExpression((ColumnType)ColumnType.LONG, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"floor"), (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.LONG, (String)"y"))), (Object)3.0);
        this.testHelper.testExpression((SqlOperator)SqlStdOperatorTable.FLOOR, this.testHelper.makeInputRef("z"), DruidExpression.ofExpression((ColumnType)ColumnType.FLOAT, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"floor"), (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"z"))), (Object)-3.0);
    }

    @Test
    public void testCeil() {
        this.testHelper.testExpression((SqlOperator)SqlStdOperatorTable.CEIL, this.testHelper.makeInputRef("a"), DruidExpression.ofExpression((ColumnType)ColumnType.LONG, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"ceil"), (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.LONG, (String)"a"))), (Object)10.0);
        this.testHelper.testExpression((SqlOperator)SqlStdOperatorTable.CEIL, this.testHelper.makeInputRef("x"), DruidExpression.ofExpression((ColumnType)ColumnType.FLOAT, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"ceil"), (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"x"))), (Object)3.0);
        this.testHelper.testExpression((SqlOperator)SqlStdOperatorTable.CEIL, this.testHelper.makeInputRef("y"), DruidExpression.ofExpression((ColumnType)ColumnType.LONG, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"ceil"), (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.LONG, (String)"y"))), (Object)3.0);
        this.testHelper.testExpression((SqlOperator)SqlStdOperatorTable.CEIL, this.testHelper.makeInputRef("z"), DruidExpression.ofExpression((ColumnType)ColumnType.FLOAT, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"ceil"), (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"z"))), (Object)-2.0);
    }

    @Test
    public void testTruncate() {
        SqlFunction truncateFunction = new TruncateOperatorConversion().calciteOperator();
        this.testHelper.testExpression((SqlOperator)truncateFunction, this.testHelper.makeInputRef("a"), DruidExpression.ofExpression((ColumnType)ColumnType.LONG, args -> "(cast(cast(" + ((DruidExpression)args.get(0)).getExpression() + " * 1,'long'),'double') / 1)", (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.LONG, (String)"a"))), (Object)10.0);
        this.testHelper.testExpression((SqlOperator)truncateFunction, this.testHelper.makeInputRef("x"), DruidExpression.ofExpression((ColumnType)ColumnType.FLOAT, args -> "(cast(cast(" + ((DruidExpression)args.get(0)).getExpression() + " * 1,'long'),'double') / 1)", (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"x"))), (Object)2.0);
        this.testHelper.testExpression((SqlOperator)truncateFunction, this.testHelper.makeInputRef("y"), DruidExpression.ofExpression((ColumnType)ColumnType.LONG, args -> "(cast(cast(" + ((DruidExpression)args.get(0)).getExpression() + " * 1,'long'),'double') / 1)", (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.LONG, (String)"y"))), (Object)3.0);
        this.testHelper.testExpression((SqlOperator)truncateFunction, this.testHelper.makeInputRef("z"), DruidExpression.ofExpression((ColumnType)ColumnType.FLOAT, args -> "(cast(cast(" + ((DruidExpression)args.get(0)).getExpression() + " * 1,'long'),'double') / 1)", (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"z"))), (Object)-2.0);
        this.testHelper.testExpressionString((SqlOperator)truncateFunction, (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("x"), (Object)this.testHelper.makeLiteral(1)), DruidExpression.ofExpression((ColumnType)ColumnType.FLOAT, args -> "(cast(cast(" + ((DruidExpression)args.get(0)).getExpression() + " * 10.0,'long'),'double') / 10.0)", (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"x"), (Object)DruidExpression.ofLiteral((ColumnType)ColumnType.LONG, (String)DruidExpression.longLiteral((long)1L)))), 2.2);
        this.testHelper.testExpressionString((SqlOperator)truncateFunction, (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("z"), (Object)this.testHelper.makeLiteral(1)), DruidExpression.ofExpression((ColumnType)ColumnType.FLOAT, args -> "(cast(cast(" + ((DruidExpression)args.get(0)).getExpression() + " * 10.0,'long'),'double') / 10.0)", (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"z"), (Object)DruidExpression.ofLiteral((ColumnType)ColumnType.LONG, (String)DruidExpression.longLiteral((long)1L)))), -2.2);
        this.testHelper.testExpressionString((SqlOperator)truncateFunction, (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("b"), (Object)this.testHelper.makeLiteral(-1)), DruidExpression.ofExpression((ColumnType)ColumnType.LONG, args -> "(cast(cast(" + ((DruidExpression)args.get(0)).getExpression() + " * 0.1,'long'),'double') / 0.1)", (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.LONG, (String)"b"), (Object)DruidExpression.ofLiteral((ColumnType)ColumnType.LONG, (String)DruidExpression.longLiteral((long)-1L)))), 20.0);
        this.testHelper.testExpressionString((SqlOperator)truncateFunction, (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("z"), (Object)this.testHelper.makeLiteral(-1)), DruidExpression.ofExpression((ColumnType)ColumnType.FLOAT, args -> "(cast(cast(" + ((DruidExpression)args.get(0)).getExpression() + " * 0.1,'long'),'double') / 0.1)", (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"z"), (Object)DruidExpression.ofLiteral((ColumnType)ColumnType.LONG, (String)DruidExpression.longLiteral((long)-1L)))), 0.0);
    }

    @Test
    public void testRound() {
        SqlOperator roundFunction = this.getOperatorConversion(SqlStdOperatorTable.ROUND).calciteOperator();
        this.testHelper.testExpression(roundFunction, this.testHelper.makeInputRef("a"), DruidExpression.ofExpression((ColumnType)ColumnType.LONG, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"round"), (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.LONG, (String)"a"))), (Object)10L);
        this.testHelper.testExpression(roundFunction, this.testHelper.makeInputRef("b"), DruidExpression.ofExpression((ColumnType)ColumnType.LONG, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"round"), (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.LONG, (String)"b"))), (Object)25L);
        this.testHelper.testExpressionString(roundFunction, (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("b"), (Object)this.testHelper.makeLiteral(-1)), DruidExpression.ofExpression((ColumnType)ColumnType.LONG, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"round"), (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.LONG, (String)"b"), (Object)DruidExpression.ofLiteral((ColumnType)ColumnType.LONG, (String)DruidExpression.longLiteral((long)-1L)))), 30L);
        this.testHelper.testExpression(roundFunction, this.testHelper.makeInputRef("x"), DruidExpression.ofExpression((ColumnType)ColumnType.FLOAT, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"round"), (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"x"))), (Object)2.0);
        this.testHelper.testExpressionString(roundFunction, (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("x"), (Object)this.testHelper.makeLiteral(1)), DruidExpression.ofExpression((ColumnType)ColumnType.FLOAT, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"round"), (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"x"), (Object)DruidExpression.ofLiteral((ColumnType)ColumnType.LONG, (String)DruidExpression.longLiteral((long)1L)))), 2.3);
        this.testHelper.testExpression(roundFunction, this.testHelper.makeInputRef("y"), DruidExpression.ofExpression((ColumnType)ColumnType.LONG, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"round"), (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.LONG, (String)"y"))), (Object)3L);
        this.testHelper.testExpression(roundFunction, this.testHelper.makeInputRef("z"), DruidExpression.ofExpression((ColumnType)ColumnType.FLOAT, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"round"), (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"z"))), (Object)-2.0);
    }

    @Test
    public void testRoundWithInvalidSecondArgument() {
        SqlOperator roundFunction = this.getOperatorConversion(SqlStdOperatorTable.ROUND).calciteOperator();
        Throwable t = Assert.assertThrows(DruidException.class, () -> this.testHelper.testExpressionString(roundFunction, (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("x"), (Object)this.testHelper.makeLiteral("foo")), DruidExpression.ofExpression((ColumnType)ColumnType.FLOAT, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"round"), (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"x"), (Object)DruidExpression.ofStringLiteral((String)"foo"))), "IAE Exception"));
        Assert.assertEquals((Object)"Function[round] second argument should be a LONG but got STRING instead", (Object)t.getMessage());
    }

    @Test
    public void testRoundWithNanShouldRoundTo0() {
        SqlOperator roundFunction = this.getOperatorConversion(SqlStdOperatorTable.ROUND).calciteOperator();
        this.testHelper.testExpression(roundFunction, this.testHelper.makeInputRef("nan"), DruidExpression.ofExpression((ColumnType)ColumnType.DOUBLE, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"round"), (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.DOUBLE, (String)"nan"))), (Object)0.0);
        this.testHelper.testExpression(roundFunction, this.testHelper.makeInputRef("fnan"), DruidExpression.ofExpression((ColumnType)ColumnType.FLOAT, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"round"), (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"fnan"))), (Object)0.0);
    }

    @Test
    public void testRoundWithInfinityShouldRoundTo0() {
        SqlOperator roundFunction = this.getOperatorConversion(SqlStdOperatorTable.ROUND).calciteOperator();
        this.testHelper.testExpression(roundFunction, this.testHelper.makeInputRef("inf"), DruidExpression.ofExpression((ColumnType)ColumnType.DOUBLE, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"round"), (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.DOUBLE, (String)"inf"))), (Object)Double.MAX_VALUE);
        this.testHelper.testExpression(roundFunction, this.testHelper.makeInputRef("-inf"), DruidExpression.ofExpression((ColumnType)ColumnType.DOUBLE, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"round"), (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.DOUBLE, (String)"-inf"))), (Object)-1.7976931348623157E308);
        this.testHelper.testExpression(roundFunction, this.testHelper.makeInputRef("finf"), DruidExpression.ofExpression((ColumnType)ColumnType.FLOAT, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"round"), (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"finf"))), (Object)Double.MAX_VALUE);
        this.testHelper.testExpression(roundFunction, this.testHelper.makeInputRef("-finf"), DruidExpression.ofExpression((ColumnType)ColumnType.FLOAT, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"round"), (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"-finf"))), (Object)-1.7976931348623157E308);
    }

    @Test
    public void testDateTrunc() {
        this.testHelper.testExpressionString(new DateTruncOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeLiteral("hour"), (Object)this.testHelper.makeLiteral(DateTimes.of((String)"2000-02-03T04:05:06Z"))), ExpressionsTest.makeExpression(ColumnType.LONG, "timestamp_floor(949550706000,'PT1H',null,'UTC')"), DateTimes.of((String)"2000-02-03T04:00:00").getMillis());
        this.testHelper.testExpressionString(new DateTruncOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeLiteral("DAY"), (Object)this.testHelper.makeLiteral(DateTimes.of((String)"2000-02-03T04:05:06Z"))), ExpressionsTest.makeExpression(ColumnType.LONG, "timestamp_floor(949550706000,'P1D',null,'UTC')"), DateTimes.of((String)"2000-02-03T00:00:00").getMillis());
    }

    @Test
    public void testTrim() {
        this.testHelper.testExpressionString((SqlOperator)SqlStdOperatorTable.TRIM, (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeFlag((Enum)SqlTrimFunction.Flag.BOTH), (Object)this.testHelper.makeLiteral(" "), (Object)this.testHelper.makeInputRef("spacey")), ExpressionsTest.makeExpression("trim(\"spacey\",' ')"), "hey there");
        this.testHelper.testExpressionString((SqlOperator)SqlStdOperatorTable.TRIM, (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeFlag((Enum)SqlTrimFunction.Flag.LEADING), (Object)this.testHelper.makeLiteral(" h"), (Object)this.testHelper.makeInputRef("spacey")), ExpressionsTest.makeExpression("ltrim(\"spacey\",' h')"), "ey there  ");
        this.testHelper.testExpressionString((SqlOperator)SqlStdOperatorTable.TRIM, (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeFlag((Enum)SqlTrimFunction.Flag.TRAILING), (Object)this.testHelper.makeLiteral(" e"), (Object)this.testHelper.makeInputRef("spacey")), ExpressionsTest.makeExpression("rtrim(\"spacey\",' e')"), "  hey ther");
    }

    @Test
    public void testPad() {
        this.testHelper.testExpressionString(new LPadOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral(5), (Object)this.testHelper.makeLiteral("x")), ExpressionsTest.makeExpression("lpad(\"s\",5,'x')"), "xxfoo");
        this.testHelper.testExpressionString(new RPadOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral(5), (Object)this.testHelper.makeLiteral("x")), ExpressionsTest.makeExpression("rpad(\"s\",5,'x')"), "fooxx");
    }

    @Test
    public void testContains() {
        this.testHelper.testExpressionString(ContainsOperatorConversion.caseSensitive().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("spacey"), (Object)this.testHelper.makeLiteral("there")), ExpressionsTest.makeExpression("contains_string(\"spacey\",'there')"), 1L);
        this.testHelper.testExpressionString(ContainsOperatorConversion.caseSensitive().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("spacey"), (Object)this.testHelper.makeLiteral("There")), ExpressionsTest.makeExpression(ColumnType.LONG, "contains_string(\"spacey\",'There')"), 0L);
        this.testHelper.testExpressionString(ContainsOperatorConversion.caseInsensitive().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("spacey"), (Object)this.testHelper.makeLiteral("There")), ExpressionsTest.makeExpression(ColumnType.LONG, "icontains_string(\"spacey\",'There')"), 1L);
        this.testHelper.testExpressionString(ContainsOperatorConversion.caseSensitive().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeCall((SqlOperator)SqlStdOperatorTable.CONCAT, new RexNode[]{this.testHelper.makeLiteral("what is"), this.testHelper.makeInputRef("spacey")}), (Object)this.testHelper.makeLiteral("what")), ExpressionsTest.makeExpression(ColumnType.LONG, "contains_string(concat('what is',\"spacey\"),'what')"), 1L);
        this.testHelper.testExpressionString(ContainsOperatorConversion.caseSensitive().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeCall((SqlOperator)SqlStdOperatorTable.CONCAT, new RexNode[]{this.testHelper.makeLiteral("what is"), this.testHelper.makeInputRef("spacey")}), (Object)this.testHelper.makeLiteral("there")), ExpressionsTest.makeExpression(ColumnType.LONG, "contains_string(concat('what is',\"spacey\"),'there')"), 1L);
        this.testHelper.testExpressionString(ContainsOperatorConversion.caseInsensitive().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeCall((SqlOperator)SqlStdOperatorTable.CONCAT, new RexNode[]{this.testHelper.makeLiteral("what is"), this.testHelper.makeInputRef("spacey")}), (Object)this.testHelper.makeLiteral("There")), ExpressionsTest.makeExpression(ColumnType.LONG, "icontains_string(concat('what is',\"spacey\"),'There')"), 1L);
        this.testHelper.testExpressionString((SqlOperator)SqlStdOperatorTable.AND, (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeCall(ContainsOperatorConversion.caseSensitive().calciteOperator(), new RexNode[]{this.testHelper.makeInputRef("spacey"), this.testHelper.makeLiteral("there")}), (Object)this.testHelper.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.testHelper.makeLiteral("yes"), this.testHelper.makeLiteral("yes")})), ExpressionsTest.makeExpression(ColumnType.LONG, "(contains_string(\"spacey\",'there') && ('yes' == 'yes'))"), 1L);
        this.testHelper.testExpressionString((SqlOperator)SqlStdOperatorTable.AND, (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeCall(ContainsOperatorConversion.caseInsensitive().calciteOperator(), new RexNode[]{this.testHelper.makeInputRef("spacey"), this.testHelper.makeLiteral("There")}), (Object)this.testHelper.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.testHelper.makeLiteral("yes"), this.testHelper.makeLiteral("yes")})), ExpressionsTest.makeExpression(ColumnType.LONG, "(icontains_string(\"spacey\",'There') && ('yes' == 'yes'))"), 1L);
    }

    @Test
    public void testContainsAsFilter() {
        this.testHelper.testFilter(ContainsOperatorConversion.caseSensitive().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("spacey"), (Object)this.testHelper.makeLiteral("there")), Collections.emptyList(), (DimFilter)new SearchQueryDimFilter("spacey", (SearchQuerySpec)new ContainsSearchQuerySpec("there", true), null), true);
        this.testHelper.testFilter(ContainsOperatorConversion.caseSensitive().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("spacey"), (Object)this.testHelper.makeLiteral("There")), Collections.emptyList(), (DimFilter)new SearchQueryDimFilter("spacey", (SearchQuerySpec)new ContainsSearchQuerySpec("There", true), null), false);
        this.testHelper.testFilter(ContainsOperatorConversion.caseInsensitive().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("spacey"), (Object)this.testHelper.makeLiteral("There")), Collections.emptyList(), (DimFilter)new SearchQueryDimFilter("spacey", (SearchQuerySpec)new ContainsSearchQuerySpec("There", false), null), true);
        this.testHelper.testFilter(ContainsOperatorConversion.caseSensitive().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeCall((SqlOperator)SqlStdOperatorTable.CONCAT, new RexNode[]{this.testHelper.makeLiteral("what is"), this.testHelper.makeInputRef("spacey")}), (Object)this.testHelper.makeLiteral("what")), (List<VirtualColumn>)ImmutableList.of((Object)new ExpressionVirtualColumn("v0", "concat('what is',\"spacey\")", ColumnType.STRING, TestExprMacroTable.INSTANCE)), (DimFilter)new SearchQueryDimFilter("v0", (SearchQuerySpec)new ContainsSearchQuerySpec("what", true), null), true);
        this.testHelper.testFilter(ContainsOperatorConversion.caseSensitive().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeCall((SqlOperator)SqlStdOperatorTable.CONCAT, new RexNode[]{this.testHelper.makeLiteral("what is"), this.testHelper.makeInputRef("spacey")}), (Object)this.testHelper.makeLiteral("there")), (List<VirtualColumn>)ImmutableList.of((Object)new ExpressionVirtualColumn("v0", "concat('what is',\"spacey\")", ColumnType.STRING, TestExprMacroTable.INSTANCE)), (DimFilter)new SearchQueryDimFilter("v0", (SearchQuerySpec)new ContainsSearchQuerySpec("there", true), null), true);
        this.testHelper.testFilter(ContainsOperatorConversion.caseInsensitive().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeCall((SqlOperator)SqlStdOperatorTable.CONCAT, new RexNode[]{this.testHelper.makeLiteral("what is"), this.testHelper.makeInputRef("spacey")}), (Object)this.testHelper.makeLiteral("What")), (List<VirtualColumn>)ImmutableList.of((Object)new ExpressionVirtualColumn("v0", "concat('what is',\"spacey\")", ColumnType.STRING, TestExprMacroTable.INSTANCE)), (DimFilter)new SearchQueryDimFilter("v0", (SearchQuerySpec)new ContainsSearchQuerySpec("What", false), null), true);
        this.testHelper.testFilter(ContainsOperatorConversion.caseSensitive().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("spacey"), (Object)this.testHelper.makeLiteral("")), Collections.emptyList(), (DimFilter)new SearchQueryDimFilter("spacey", (SearchQuerySpec)new ContainsSearchQuerySpec("", true), null), true);
    }

    @Test
    public void testTimeFloor() {
        this.testHelper.testExpressionString(new TimeFloorOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeLiteral(DateTimes.of((String)"2000-02-03T04:05:06Z")), (Object)this.testHelper.makeLiteral("PT1H")), ExpressionsTest.makeExpression(ColumnType.LONG, "timestamp_floor(949550706000,'PT1H',null,'UTC')"), DateTimes.of((String)"2000-02-03T04:00:00").getMillis());
        this.testHelper.testExpressionString(new TimeFloorOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("t"), (Object)this.testHelper.makeLiteral("P1D"), (Object)this.testHelper.makeNullLiteral(SqlTypeName.TIMESTAMP), (Object)this.testHelper.makeLiteral("America/Los_Angeles")), ExpressionsTest.makeExpression(ColumnType.LONG, "timestamp_floor(\"t\",'P1D',null,'America/Los_Angeles')"), DateTimes.of((String)"2000-02-02T08:00:00").getMillis());
    }

    @Test
    public void testOtherTimeFloor() {
        this.testHelper.testExpressionString((SqlOperator)SqlStdOperatorTable.FLOOR, (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("t"), (Object)this.testHelper.makeFlag((Enum)TimeUnitRange.YEAR)), ExpressionsTest.makeExpression(ColumnType.LONG, "timestamp_floor(\"t\",'P1Y',null,'UTC')"), DateTimes.of((String)"2000").getMillis());
    }

    @Test
    public void testTimeCeil() {
        this.testHelper.testExpressionString(new TimeCeilOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeLiteral(DateTimes.of((String)"2000-02-03T04:05:06Z")), (Object)this.testHelper.makeLiteral("PT1H")), ExpressionsTest.makeExpression(ColumnType.LONG, "timestamp_ceil(949550706000,'PT1H',null,'UTC')"), DateTimes.of((String)"2000-02-03T05:00:00").getMillis());
        this.testHelper.testExpressionString(new TimeCeilOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("t"), (Object)this.testHelper.makeLiteral("P1D"), (Object)this.testHelper.makeNullLiteral(SqlTypeName.TIMESTAMP), (Object)this.testHelper.makeLiteral("America/Los_Angeles")), ExpressionsTest.makeExpression(ColumnType.LONG, "timestamp_ceil(\"t\",'P1D',null,'America/Los_Angeles')"), DateTimes.of((String)"2000-02-03T08:00:00").getMillis());
    }

    @Test
    public void testOtherTimeCeil() {
        this.testHelper.testExpressionString((SqlOperator)SqlStdOperatorTable.CEIL, (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("t"), (Object)this.testHelper.makeFlag((Enum)TimeUnitRange.YEAR)), ExpressionsTest.makeExpression(ColumnType.LONG, "timestamp_ceil(\"t\",'P1Y',null,'UTC')"), DateTimes.of((String)"2001").getMillis());
    }

    @Test
    public void testTimeShift() {
        this.testHelper.testExpressionString(new TimeShiftOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("t"), (Object)this.testHelper.makeLiteral("PT2H"), (Object)this.testHelper.makeLiteral(-3)), ExpressionsTest.makeExpression(ColumnType.LONG, "timestamp_shift(\"t\",'PT2H',-3,'UTC')"), DateTimes.of((String)"2000-02-02T22:05:06").getMillis());
        this.testHelper.testExpressionString(new TimeShiftOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("t"), (Object)this.testHelper.makeLiteral("PT2H"), (Object)this.testHelper.makeLiteral(-3), (Object)this.testHelper.makeLiteral("America/Los_Angeles")), ExpressionsTest.makeExpression(ColumnType.LONG, "timestamp_shift(\"t\",'PT2H',-3,'America/Los_Angeles')"), DateTimes.of((String)"2000-02-02T22:05:06").getMillis());
    }

    @Test
    public void testTimeExtract() {
        this.testHelper.testExpressionString((SqlOperator)new TimeExtractOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("t"), (Object)this.testHelper.makeLiteral("QUARTER")), ExpressionsTest.makeExpression(ColumnType.LONG, "timestamp_extract(\"t\",'QUARTER','UTC')"), 1L);
        this.testHelper.testExpressionString((SqlOperator)new TimeExtractOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("t"), (Object)this.testHelper.makeLiteral("DAY"), (Object)this.testHelper.makeLiteral("America/Los_Angeles")), ExpressionsTest.makeExpression(ColumnType.LONG, "timestamp_extract(\"t\",'DAY','America/Los_Angeles')"), 2L);
        this.testHelper.testExpressionString((SqlOperator)new TimeExtractOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("t"), (Object)this.testHelper.makeLiteral("DAY"), (Object)this.testHelper.makeInputRef("timezone")), ExpressionsTest.makeExpression(ColumnType.LONG, "timestamp_extract(\"t\",'DAY',\"timezone\")"), 2L);
    }

    @Test
    public void testTimePlusDayTimeInterval() {
        Period period = new Period((Object)"P1DT1H1M");
        this.testHelper.testExpressionString((SqlOperator)SqlStdOperatorTable.DATETIME_PLUS, (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("t"), (Object)this.testHelper.makeLiteral(new BigDecimal(period.toStandardDuration().getMillis()), new SqlIntervalQualifier(TimeUnit.DAY, TimeUnit.MINUTE, SqlParserPos.ZERO))), ExpressionsTest.makeExpression(ColumnType.LONG, "(\"t\" + 90060000)"), DateTimes.of((String)"2000-02-03T04:05:06").plus((ReadablePeriod)period).getMillis());
    }

    @Test
    public void testTimePlusYearMonthInterval() {
        Period period = new Period((Object)"P1Y1M");
        this.testHelper.testExpressionString((SqlOperator)SqlStdOperatorTable.DATETIME_PLUS, (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("t"), (Object)this.testHelper.makeLiteral(new BigDecimal(13), new SqlIntervalQualifier(TimeUnit.YEAR, TimeUnit.MONTH, SqlParserPos.ZERO))), ExpressionsTest.makeExpression(ColumnType.LONG, "timestamp_shift(\"t\",'P13M',1,'UTC')"), DateTimes.of((String)"2000-02-03T04:05:06").plus((ReadablePeriod)period).getMillis());
    }

    @Test
    public void testTimeMinusDayTimeInterval() {
        Period period = new Period((Object)"P1DT1H1M");
        this.testHelper.testExpression(SqlTypeName.TIMESTAMP, (SqlOperator)SqlStdOperatorTable.MINUS_DATE, (List<RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("t"), (Object)this.testHelper.makeLiteral(new BigDecimal(period.toStandardDuration().getMillis()), new SqlIntervalQualifier(TimeUnit.DAY, TimeUnit.MINUTE, SqlParserPos.ZERO))), DruidExpression.ofExpression((ColumnType)ColumnType.LONG, args -> "(" + ((DruidExpression)args.get(0)).getExpression() + " - " + ((DruidExpression)args.get(1)).getExpression() + ")", (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.LONG, (String)"t"), (Object)DruidExpression.ofLiteral((ColumnType)ColumnType.LONG, (String)"90060000"))), DateTimes.of((String)"2000-02-03T04:05:06").minus((ReadablePeriod)period).getMillis());
    }

    @Test
    public void testTimeMinusYearMonthInterval() {
        Period period = new Period((Object)"P1Y1M");
        this.testHelper.testExpression(SqlTypeName.TIMESTAMP, (SqlOperator)SqlStdOperatorTable.MINUS_DATE, (List<RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("t"), (Object)this.testHelper.makeLiteral(new BigDecimal(13), new SqlIntervalQualifier(TimeUnit.YEAR, TimeUnit.MONTH, SqlParserPos.ZERO))), DruidExpression.ofExpression((ColumnType)ColumnType.LONG, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"timestamp_shift"), (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.LONG, (String)"t"), (Object)DruidExpression.ofLiteral((ColumnType)ColumnType.STRING, (String)DruidExpression.stringLiteral((String)"P13M")), (Object)DruidExpression.ofLiteral((ColumnType)ColumnType.LONG, (String)DruidExpression.longLiteral((long)-1L)), (Object)DruidExpression.ofStringLiteral((String)"UTC"))), DateTimes.of((String)"2000-02-03T04:05:06").minus((ReadablePeriod)period).getMillis());
    }

    @Test
    public void testTimeParse() {
        this.testHelper.testExpressionString(new TimeParseOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("tstr"), (Object)this.testHelper.makeLiteral("yyyy-MM-dd HH:mm:ss")), ExpressionsTest.makeExpression(ColumnType.LONG, "timestamp_parse(\"tstr\",'yyyy-MM-dd HH:mm:ss','UTC')"), DateTimes.of((String)"2000-02-03T04:05:06").getMillis());
        this.testHelper.testExpressionString(new TimeParseOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("tstr"), (Object)this.testHelper.makeLiteral("yyyy-MM-dd HH:mm:ss"), (Object)this.testHelper.makeLiteral("America/Los_Angeles")), ExpressionsTest.makeExpression(ColumnType.LONG, "timestamp_parse(\"tstr\",'yyyy-MM-dd HH:mm:ss','America/Los_Angeles')"), DateTimes.of((String)"2000-02-03T04:05:06-08:00").getMillis());
    }

    @Test
    public void testTimeFormat() {
        this.testHelper.testExpressionString(new TimeFormatOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("t"), (Object)this.testHelper.makeLiteral("yyyy-MM-dd HH:mm:ss")), ExpressionsTest.makeExpression("timestamp_format(\"t\",'yyyy-MM-dd HH:mm:ss','UTC')"), "2000-02-03 04:05:06");
        this.testHelper.testExpressionString(new TimeFormatOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("t"), (Object)this.testHelper.makeLiteral("yyyy-MM-dd HH:mm:ss"), (Object)this.testHelper.makeLiteral("America/Los_Angeles")), ExpressionsTest.makeExpression("timestamp_format(\"t\",'yyyy-MM-dd HH:mm:ss','America/Los_Angeles')"), "2000-02-02 20:05:06");
    }

    @Test
    public void testExtract() {
        this.testHelper.testExpressionString((SqlOperator)SqlStdOperatorTable.EXTRACT, (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeFlag((Enum)TimeUnitRange.QUARTER), (Object)this.testHelper.makeInputRef("t")), ExpressionsTest.makeExpression(ColumnType.LONG, "timestamp_extract(\"t\",'QUARTER','UTC')"), 1L);
        this.testHelper.testExpressionString((SqlOperator)SqlStdOperatorTable.EXTRACT, (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeFlag((Enum)TimeUnitRange.DAY), (Object)this.testHelper.makeInputRef("t")), ExpressionsTest.makeExpression(ColumnType.LONG, "timestamp_extract(\"t\",'DAY','UTC')"), 3L);
    }

    @Test
    public void testCastAsTimestamp() {
        this.testHelper.testExpression(this.testHelper.makeAbstractCast(this.testHelper.createSqlType(SqlTypeName.TIMESTAMP), this.testHelper.makeInputRef("t")), DruidExpression.ofColumn((ColumnType)ColumnType.LONG, (String)"t", (SimpleExtraction)SimpleExtraction.of((String)"t", null)), DateTimes.of((String)"2000-02-03T04:05:06Z").getMillis());
        this.testHelper.testExpression(this.testHelper.makeAbstractCast(this.testHelper.createSqlType(SqlTypeName.TIMESTAMP), this.testHelper.makeInputRef("tstr")), DruidExpression.ofExpression((ColumnType)ColumnType.LONG, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"timestamp_parse"), (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.STRING, (String)"tstr"), (Object)DruidExpression.ofLiteral(null, (String)DruidExpression.nullLiteral()), (Object)DruidExpression.ofStringLiteral((String)"UTC"))), DateTimes.of((String)"2000-02-03T04:05:06Z").getMillis());
    }

    @Test
    public void testCastFromTimestamp() {
        this.testHelper.testExpression(this.testHelper.makeAbstractCast(this.testHelper.createSqlType(SqlTypeName.VARCHAR), this.testHelper.makeAbstractCast(this.testHelper.createSqlType(SqlTypeName.TIMESTAMP), this.testHelper.makeInputRef("t"))), DruidExpression.ofExpression((ColumnType)ColumnType.STRING, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"timestamp_format"), (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.LONG, (String)"t"), (Object)DruidExpression.ofStringLiteral((String)"yyyy-MM-dd HH:mm:ss"), (Object)DruidExpression.ofStringLiteral((String)"UTC"))), "2000-02-03 04:05:06");
        this.testHelper.testExpression(this.testHelper.makeAbstractCast(this.testHelper.createSqlType(SqlTypeName.BIGINT), this.testHelper.makeAbstractCast(this.testHelper.createSqlType(SqlTypeName.TIMESTAMP), this.testHelper.makeInputRef("t"))), DruidExpression.ofColumn((ColumnType)ColumnType.LONG, (String)"t", (SimpleExtraction)SimpleExtraction.of((String)"t", null)), DateTimes.of((String)"2000-02-03T04:05:06").getMillis());
    }

    @Test
    public void testCastAsDate() {
        this.testHelper.testExpression(this.testHelper.makeAbstractCast(this.testHelper.createSqlType(SqlTypeName.DATE), this.testHelper.makeInputRef("t")), DruidExpression.ofExpression((ColumnType)ColumnType.LONG, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"timestamp_floor"), (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.LONG, (String)"t"), (Object)DruidExpression.ofStringLiteral((String)"P1D"), (Object)DruidExpression.ofLiteral((ColumnType)ColumnType.LONG, (String)DruidExpression.nullLiteral()), (Object)DruidExpression.ofStringLiteral((String)"UTC"))), DateTimes.of((String)"2000-02-03").getMillis());
        this.testHelper.testExpression(this.testHelper.makeAbstractCast(this.testHelper.createSqlType(SqlTypeName.DATE), this.testHelper.makeInputRef("dstr")), DruidExpression.ofExpression((ColumnType)ColumnType.LONG, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"timestamp_floor"), (List)ImmutableList.of((Object)DruidExpression.ofExpression((ColumnType)ColumnType.LONG, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"timestamp_parse"), (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.STRING, (String)"dstr"), (Object)DruidExpression.ofLiteral(null, (String)DruidExpression.nullLiteral()), (Object)DruidExpression.ofStringLiteral((String)"UTC"))), (Object)DruidExpression.ofStringLiteral((String)"P1D"), (Object)DruidExpression.ofLiteral((ColumnType)ColumnType.LONG, (String)DruidExpression.nullLiteral()), (Object)DruidExpression.ofStringLiteral((String)"UTC"))), DateTimes.of((String)"2000-02-03").getMillis());
    }

    @Test
    public void testCastFromDate() {
        this.testHelper.testExpression(this.testHelper.makeAbstractCast(this.testHelper.createSqlType(SqlTypeName.VARCHAR), this.testHelper.makeAbstractCast(this.testHelper.createSqlType(SqlTypeName.DATE), this.testHelper.makeInputRef("t"))), DruidExpression.ofExpression((ColumnType)ColumnType.STRING, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"timestamp_format"), (List)ImmutableList.of((Object)DruidExpression.ofExpression((ColumnType)ColumnType.LONG, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"timestamp_floor"), (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.LONG, (String)"t"), (Object)DruidExpression.ofStringLiteral((String)"P1D"), (Object)DruidExpression.ofLiteral((ColumnType)ColumnType.LONG, (String)DruidExpression.nullLiteral()), (Object)DruidExpression.ofStringLiteral((String)"UTC"))), (Object)DruidExpression.ofStringLiteral((String)"yyyy-MM-dd"), (Object)DruidExpression.ofStringLiteral((String)"UTC"))), "2000-02-03");
        this.testHelper.testExpression(this.testHelper.makeAbstractCast(this.testHelper.createSqlType(SqlTypeName.BIGINT), this.testHelper.makeAbstractCast(this.testHelper.createSqlType(SqlTypeName.DATE), this.testHelper.makeInputRef("t"))), DruidExpression.ofExpression((ColumnType)ColumnType.LONG, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"timestamp_floor"), (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.LONG, (String)"t"), (Object)DruidExpression.ofStringLiteral((String)"P1D"), (Object)DruidExpression.ofLiteral((ColumnType)ColumnType.LONG, (String)DruidExpression.nullLiteral()), (Object)DruidExpression.ofStringLiteral((String)"UTC"))), DateTimes.of((String)"2000-02-03").getMillis());
    }

    @Test
    public void testReverse() {
        this.testHelper.testExpression(new ReverseOperatorConversion().calciteOperator(), this.testHelper.makeInputRef("s"), DruidExpression.ofExpression((ColumnType)ColumnType.STRING, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"reverse"), (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.STRING, (String)"s"))), (Object)"oof");
        this.testHelper.testExpression(new ReverseOperatorConversion().calciteOperator(), this.testHelper.makeInputRef("spacey"), DruidExpression.ofExpression((ColumnType)ColumnType.STRING, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"reverse"), (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.STRING, (String)"spacey"))), (Object)"  ereht yeh  ");
        this.testHelper.testExpression(new ReverseOperatorConversion().calciteOperator(), this.testHelper.makeInputRef("tstr"), DruidExpression.ofExpression((ColumnType)ColumnType.STRING, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"reverse"), (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.STRING, (String)"tstr"))), (Object)"60:50:40 30-20-0002");
        this.testHelper.testExpression(new ReverseOperatorConversion().calciteOperator(), this.testHelper.makeInputRef("dstr"), DruidExpression.ofExpression((ColumnType)ColumnType.STRING, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"reverse"), (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.STRING, (String)"dstr"))), (Object)"30-20-0002");
    }

    @Test
    public void testAbnormalReverseWithWrongType() {
        Throwable t = Assert.assertThrows(DruidException.class, () -> this.testHelper.testExpression(new ReverseOperatorConversion().calciteOperator(), this.testHelper.makeInputRef("a"), DruidExpression.ofExpression((ColumnType)ColumnType.STRING, (DruidExpression.ExpressionGenerator)DruidExpression.functionCall((String)"reverse"), (List)ImmutableList.of((Object)DruidExpression.ofColumn((ColumnType)ColumnType.LONG, (String)"a"))), null));
        Assert.assertEquals((Object)"Function[reverse] needs a STRING argument but got LONG instead", (Object)t.getMessage());
    }

    @Test
    public void testRight() {
        this.testHelper.testExpressionString(new RightOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral(1)), ExpressionsTest.makeExpression("right(\"s\",1)"), "o");
        this.testHelper.testExpressionString(new RightOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral(2)), ExpressionsTest.makeExpression("right(\"s\",2)"), "oo");
        this.testHelper.testExpressionString(new RightOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral(3)), ExpressionsTest.makeExpression("right(\"s\",3)"), "foo");
        this.testHelper.testExpressionString(new RightOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral(4)), ExpressionsTest.makeExpression("right(\"s\",4)"), "foo");
        this.testHelper.testExpressionString(new RightOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("tstr"), (Object)this.testHelper.makeLiteral(5)), ExpressionsTest.makeExpression("right(\"tstr\",5)"), "05:06");
    }

    @Test
    public void testAbnormalRightWithNegativeNumber() {
        Throwable t = Assert.assertThrows(DruidException.class, () -> this.testHelper.testExpressionString(new RightOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral(-1)), ExpressionsTest.makeExpression("right(\"s\",-1)"), null));
        Assert.assertEquals((Object)"Function[right] needs a positive integer as the second argument", (Object)t.getMessage());
    }

    @Test
    public void testLeft() {
        this.testHelper.testExpressionString(new LeftOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral(1)), ExpressionsTest.makeExpression("left(\"s\",1)"), "f");
        this.testHelper.testExpressionString(new LeftOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral(2)), ExpressionsTest.makeExpression("left(\"s\",2)"), "fo");
        this.testHelper.testExpressionString(new LeftOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral(3)), ExpressionsTest.makeExpression("left(\"s\",3)"), "foo");
        this.testHelper.testExpressionString(new LeftOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral(4)), ExpressionsTest.makeExpression("left(\"s\",4)"), "foo");
        this.testHelper.testExpressionString(new LeftOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("tstr"), (Object)this.testHelper.makeLiteral(10)), ExpressionsTest.makeExpression("left(\"tstr\",10)"), "2000-02-03");
    }

    @Test
    public void testAbnormalLeftWithNegativeNumber() {
        Throwable t = Assert.assertThrows(DruidException.class, () -> this.testHelper.testExpressionString(new LeftOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral(-1)), ExpressionsTest.makeExpression("left(\"s\",-1)"), null));
        Assert.assertEquals((Object)"Function[left] needs a positive integer as the second argument", (Object)t.getMessage());
    }

    @Test
    public void testRepeat() {
        this.testHelper.testExpressionString(new RepeatOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral(1)), ExpressionsTest.makeExpression("repeat(\"s\",1)"), "foo");
        this.testHelper.testExpressionString(new RepeatOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral(3)), ExpressionsTest.makeExpression("repeat(\"s\",3)"), "foofoofoo");
        this.testHelper.testExpressionString(new RepeatOperatorConversion().calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeLiteral(-1)), ExpressionsTest.makeExpression("repeat(\"s\",-1)"), null);
    }

    @Test
    public void testOperatorConversionsDruidUnaryLongFn() {
        this.testHelper.testExpressionString(OperatorConversions.druidUnaryLongFn((String)"BITWISE_COMPLEMENT", (String)"bitwiseComplement").calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("a")), ExpressionsTest.makeExpression(ColumnType.LONG, "bitwiseComplement(\"a\")"), -11L);
        this.testHelper.testExpressionString(OperatorConversions.druidUnaryLongFn((String)"BITWISE_COMPLEMENT", (String)"bitwiseComplement").calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("x")), ExpressionsTest.makeExpression(ColumnType.LONG, "bitwiseComplement(\"x\")"), -3L);
        this.testHelper.testExpressionString(OperatorConversions.druidUnaryLongFn((String)"BITWISE_COMPLEMENT", (String)"bitwiseComplement").calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s")), ExpressionsTest.makeExpression(ColumnType.LONG, "bitwiseComplement(\"s\")"), null);
    }

    @Test
    public void testOperatorConversionsDruidUnaryDoubleFn() {
        this.testHelper.testExpressionString(OperatorConversions.druidUnaryDoubleFn((String)"BITWISE_CONVERT_LONG_BITS_TO_DOUBLE", (String)"bitwiseConvertLongBitsToDouble").calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("a")), ExpressionsTest.makeExpression(ColumnType.LONG, "bitwiseConvertLongBitsToDouble(\"a\")"), 4.9E-323);
        this.testHelper.testExpressionString(OperatorConversions.druidUnaryDoubleFn((String)"BITWISE_CONVERT_LONG_BITS_TO_DOUBLE", (String)"bitwiseConvertLongBitsToDouble").calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("x")), ExpressionsTest.makeExpression(ColumnType.LONG, "bitwiseConvertLongBitsToDouble(\"x\")"), 9.9E-324);
        this.testHelper.testExpressionString(OperatorConversions.druidUnaryDoubleFn((String)"BITWISE_CONVERT_LONG_BITS_TO_DOUBLE", (String)"bitwiseConvertLongBitsToDouble").calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s")), ExpressionsTest.makeExpression(ColumnType.LONG, "bitwiseConvertLongBitsToDouble(\"s\")"), null);
    }

    @Test
    public void testOperatorConversionsDruidBinaryLongFn() {
        this.testHelper.testExpressionString(OperatorConversions.druidBinaryLongFn((String)"BITWISE_AND", (String)"bitwiseAnd").calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("a"), (Object)this.testHelper.makeInputRef("b")), ExpressionsTest.makeExpression(ColumnType.LONG, "bitwiseAnd(\"a\",\"b\")"), 8L);
        this.testHelper.testExpressionString(OperatorConversions.druidBinaryLongFn((String)"BITWISE_AND", (String)"bitwiseAnd").calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("x"), (Object)this.testHelper.makeInputRef("y")), ExpressionsTest.makeExpression(ColumnType.LONG, "bitwiseAnd(\"x\",\"y\")"), 2L);
        this.testHelper.testExpressionString(OperatorConversions.druidBinaryLongFn((String)"BITWISE_AND", (String)"bitwiseAnd").calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("s"), (Object)this.testHelper.makeInputRef("s")), ExpressionsTest.makeExpression(ColumnType.LONG, "bitwiseAnd(\"s\",\"s\")"), null);
    }

    @Test
    public void testHumanReadableBinaryByteFormat() {
        this.testHelper.testExpressionString(HumanReadableFormatOperatorConversion.BINARY_BYTE_FORMAT.calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeLiteral(1000)), ExpressionsTest.makeExpression("human_readable_binary_byte_format(1000)"), "1000 B");
        this.testHelper.testExpressionString(HumanReadableFormatOperatorConversion.BINARY_BYTE_FORMAT.calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeLiteral(1024)), ExpressionsTest.makeExpression("human_readable_binary_byte_format(1024)"), "1.00 KiB");
        this.testHelper.testExpressionString(HumanReadableFormatOperatorConversion.BINARY_BYTE_FORMAT.calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeLiteral(Long.MAX_VALUE)), ExpressionsTest.makeExpression("human_readable_binary_byte_format(9223372036854775807)"), "8.00 EiB");
        this.testHelper.testExpressionString(HumanReadableFormatOperatorConversion.BINARY_BYTE_FORMAT.calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeLiteral(Long.MIN_VALUE)), ExpressionsTest.makeExpression("human_readable_binary_byte_format(-9223372036854775808)"), "-8.00 EiB");
        this.testHelper.testExpressionString(HumanReadableFormatOperatorConversion.BINARY_BYTE_FORMAT.calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("b"), (Object)this.testHelper.makeInputRef("p")), ExpressionsTest.makeExpression("human_readable_binary_byte_format(\"b\",\"p\")"), "25 B");
        this.testHelper.testExpressionString(HumanReadableFormatOperatorConversion.BINARY_BYTE_FORMAT.calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeLiteral(45000), (Object)this.testHelper.makeLiteral(0)), ExpressionsTest.makeExpression("human_readable_binary_byte_format(45000,0)"), "44 KiB");
        this.testHelper.testExpressionString(HumanReadableFormatOperatorConversion.BINARY_BYTE_FORMAT.calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeLiteral(45000), (Object)this.testHelper.makeLiteral(1)), ExpressionsTest.makeExpression("human_readable_binary_byte_format(45000,1)"), "43.9 KiB");
        this.testHelper.testExpressionString(HumanReadableFormatOperatorConversion.BINARY_BYTE_FORMAT.calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeLiteral(45000), (Object)this.testHelper.makeLiteral(2)), ExpressionsTest.makeExpression("human_readable_binary_byte_format(45000,2)"), "43.95 KiB");
        this.testHelper.testExpressionString(HumanReadableFormatOperatorConversion.BINARY_BYTE_FORMAT.calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeLiteral(45000), (Object)this.testHelper.makeLiteral(3)), ExpressionsTest.makeExpression("human_readable_binary_byte_format(45000,3)"), "43.945 KiB");
    }

    @Test
    public void testHumanReadableDecimalByteFormat() {
        this.testHelper.testExpressionString(HumanReadableFormatOperatorConversion.DECIMAL_BYTE_FORMAT.calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeLiteral(999)), ExpressionsTest.makeExpression("human_readable_decimal_byte_format(999)"), "999 B");
        this.testHelper.testExpressionString(HumanReadableFormatOperatorConversion.DECIMAL_BYTE_FORMAT.calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeLiteral(1024)), ExpressionsTest.makeExpression("human_readable_decimal_byte_format(1024)"), "1.02 KB");
        this.testHelper.testExpressionString(HumanReadableFormatOperatorConversion.DECIMAL_BYTE_FORMAT.calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeLiteral(Long.MAX_VALUE)), ExpressionsTest.makeExpression("human_readable_decimal_byte_format(9223372036854775807)"), "9.22 EB");
        this.testHelper.testExpressionString(HumanReadableFormatOperatorConversion.DECIMAL_BYTE_FORMAT.calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeLiteral(Long.MIN_VALUE)), ExpressionsTest.makeExpression("human_readable_decimal_byte_format(-9223372036854775808)"), "-9.22 EB");
        this.testHelper.testExpressionString(HumanReadableFormatOperatorConversion.DECIMAL_BYTE_FORMAT.calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeInputRef("b"), (Object)this.testHelper.makeInputRef("p")), ExpressionsTest.makeExpression("human_readable_decimal_byte_format(\"b\",\"p\")"), "25 B");
        this.testHelper.testExpressionString(HumanReadableFormatOperatorConversion.DECIMAL_BYTE_FORMAT.calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeLiteral(45678), (Object)this.testHelper.makeLiteral(0)), ExpressionsTest.makeExpression("human_readable_decimal_byte_format(45678,0)"), "46 KB");
        this.testHelper.testExpressionString(HumanReadableFormatOperatorConversion.DECIMAL_BYTE_FORMAT.calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeLiteral(45678), (Object)this.testHelper.makeLiteral(1)), ExpressionsTest.makeExpression("human_readable_decimal_byte_format(45678,1)"), "45.7 KB");
        this.testHelper.testExpressionString(HumanReadableFormatOperatorConversion.DECIMAL_BYTE_FORMAT.calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeLiteral(45678), (Object)this.testHelper.makeLiteral(2)), ExpressionsTest.makeExpression("human_readable_decimal_byte_format(45678,2)"), "45.68 KB");
        this.testHelper.testExpressionString(HumanReadableFormatOperatorConversion.DECIMAL_BYTE_FORMAT.calciteOperator(), (List<? extends RexNode>)ImmutableList.of((Object)this.testHelper.makeLiteral(45678), (Object)this.testHelper.makeLiteral(3)), ExpressionsTest.makeExpression("human_readable_decimal_byte_format(45678,3)"), "45.678 KB");
    }

    @Test
    public void testPresenceOfOverIsInvalid() {
        RexBuilder rexBuilder = new RexBuilder(DruidTypeSystem.TYPE_FACTORY);
        PlannerContext plannerContext = (PlannerContext)Mockito.mock(PlannerContext.class);
        Mockito.when((Object)plannerContext.getTimeZone()).thenReturn((Object)DateTimeZone.UTC);
        RexNode rexNode = rexBuilder.makeOver(this.testHelper.createSqlType(SqlTypeName.BIGINT), SqlStdOperatorTable.SUM, Collections.emptyList(), Collections.emptyList(), ImmutableList.of(), RexWindowBounds.CURRENT_ROW, RexWindowBounds.CURRENT_ROW, false, true, false, false, false);
        CannotBuildQueryException t = (CannotBuildQueryException)Assert.assertThrows(CannotBuildQueryException.class, () -> this.testHelper.testExpression(rexNode, null, plannerContext));
        MatcherAssert.assertThat((Object)t.getMessage(), (Matcher)StringContains.containsString((String)"Unexpected OVER expression"));
    }

    @Test
    public void testCalciteLiteralToDruidLiteral() {
        RexBuilder rexBuilder = new RexBuilder(DruidTypeSystem.TYPE_FACTORY);
        PlannerContext plannerContext = (PlannerContext)Mockito.mock(PlannerContext.class);
        Mockito.when((Object)plannerContext.getTimeZone()).thenReturn((Object)DateTimeZone.UTC);
        this.assertDruidLiteral(new DruidLiteral(ExpressionType.STRING, null), Expressions.calciteLiteralToDruidLiteral((PlannerContext)plannerContext, (RexNode)rexBuilder.makeNullLiteral(rexBuilder.getTypeFactory().createSqlType(SqlTypeName.VARCHAR))));
        this.assertDruidLiteral(new DruidLiteral(ExpressionType.STRING, (Object)""), Expressions.calciteLiteralToDruidLiteral((PlannerContext)plannerContext, (RexNode)rexBuilder.makeLiteral("")));
        this.assertDruidLiteral(new DruidLiteral(ExpressionType.LONG, null), Expressions.calciteLiteralToDruidLiteral((PlannerContext)plannerContext, (RexNode)rexBuilder.makeNullLiteral(rexBuilder.getTypeFactory().createSqlType(SqlTypeName.BIGINT))));
        this.assertDruidLiteral(new DruidLiteral(ExpressionType.STRING, null), Expressions.calciteLiteralToDruidLiteral((PlannerContext)plannerContext, (RexNode)rexBuilder.makeNullLiteral(rexBuilder.getTypeFactory().createSqlType(SqlTypeName.NULL))));
        this.assertDruidLiteral(new DruidLiteral(ExpressionType.STRING, (Object)"abc"), Expressions.calciteLiteralToDruidLiteral((PlannerContext)plannerContext, (RexNode)rexBuilder.makeLiteral("abc")));
        this.assertDruidLiteral(new DruidLiteral(ExpressionType.LONG, (Object)1L), Expressions.calciteLiteralToDruidLiteral((PlannerContext)plannerContext, (RexNode)rexBuilder.makeLiteral(true)));
        this.assertDruidLiteral(new DruidLiteral(ExpressionType.LONG, (Object)123L), Expressions.calciteLiteralToDruidLiteral((PlannerContext)plannerContext, (RexNode)rexBuilder.makeExactLiteral(BigDecimal.valueOf(123L), rexBuilder.getTypeFactory().createSqlType(SqlTypeName.INTEGER))));
        this.assertDruidLiteral(new DruidLiteral(ExpressionType.DOUBLE, (Object)123.0), Expressions.calciteLiteralToDruidLiteral((PlannerContext)plannerContext, (RexNode)rexBuilder.makeExactLiteral(BigDecimal.valueOf(123L), rexBuilder.getTypeFactory().createSqlType(SqlTypeName.DECIMAL))));
        this.assertDruidLiteral(new DruidLiteral(ExpressionType.LONG, (Object)DateTimes.of((String)"2000").getMillis()), Expressions.calciteLiteralToDruidLiteral((PlannerContext)plannerContext, (RexNode)Calcites.jodaToCalciteTimestampLiteral((RexBuilder)rexBuilder, (DateTime)DateTimes.of((String)"2000"), (DateTimeZone)DateTimeZone.UTC, (int)3)));
        this.assertDruidLiteral(new DruidLiteral(ExpressionType.LONG, (Object)DateTimes.of((String)"2000").getMillis()), Expressions.calciteLiteralToDruidLiteral((PlannerContext)plannerContext, (RexNode)rexBuilder.makeDateLiteral(Calcites.jodaToCalciteDateString((DateTime)DateTimes.of((String)"2000"), (DateTimeZone)DateTimeZone.UTC))));
        this.assertDruidLiteral(new DruidLiteral(ExpressionType.LONG, (Object)3L), Expressions.calciteLiteralToDruidLiteral((PlannerContext)plannerContext, (RexNode)rexBuilder.makeIntervalLiteral(BigDecimal.valueOf(3L), new SqlIntervalQualifier(TimeUnit.DAY, TimeUnit.HOUR, SqlParserPos.ZERO))));
        this.assertDruidLiteral(new DruidLiteral(ExpressionType.LONG, (Object)3), Expressions.calciteLiteralToDruidLiteral((PlannerContext)plannerContext, (RexNode)rexBuilder.makeIntervalLiteral(BigDecimal.valueOf(3L), new SqlIntervalQualifier(TimeUnit.YEAR, TimeUnit.MONTH, SqlParserPos.ZERO))));
        this.assertDruidLiteral(new DruidLiteral(ExpressionType.STRING, (Object)"123"), Expressions.calciteLiteralToDruidLiteral((PlannerContext)plannerContext, (RexNode)rexBuilder.makeCast(rexBuilder.getTypeFactory().createSqlType(SqlTypeName.VARCHAR), (RexNode)rexBuilder.makeExactLiteral(BigDecimal.valueOf(123.7), rexBuilder.getTypeFactory().createSqlType(SqlTypeName.INTEGER)))));
        this.assertDruidLiteral(new DruidLiteral(ExpressionType.DOUBLE, (Object)123.0), Expressions.calciteLiteralToDruidLiteral((PlannerContext)plannerContext, (RexNode)rexBuilder.makeCast(rexBuilder.getTypeFactory().createSqlType(SqlTypeName.DOUBLE), (RexNode)rexBuilder.makeExactLiteral(BigDecimal.valueOf(123L), rexBuilder.getTypeFactory().createSqlType(SqlTypeName.INTEGER)))));
        Assert.assertNull((Object)Expressions.calciteLiteralToDruidLiteral((PlannerContext)plannerContext, (RexNode)rexBuilder.makeCast(rexBuilder.getTypeFactory().createSqlType(SqlTypeName.DATE), (RexNode)Calcites.jodaToCalciteTimestampLiteral((RexBuilder)rexBuilder, (DateTime)DateTimes.of((String)"2000-01-02T03:04:05"), (DateTimeZone)DateTimeZone.UTC, (int)3))));
    }

    private void assertDruidLiteral(DruidLiteral expected, DruidLiteral actual) {
        Assert.assertEquals((Object)StringUtils.format((String)"%s: %s", (Object[])new Object[]{expected.type(), expected.value()}), (Object)StringUtils.format((String)"%s: %s", (Object[])new Object[]{actual.type(), actual.value()}));
    }
}

