/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.error.DruidException;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.query.Query;
import org.apache.druid.query.operator.OperatorFactory;
import org.apache.druid.query.operator.WindowOperatorQuery;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.sql.calcite.BaseCalciteQueryTest;
import org.apache.druid.sql.calcite.QueryTestRunner;
import org.apache.druid.sql.calcite.QueryVerification;
import org.junit.Assert;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class CalciteWindowQueryTest
extends BaseCalciteQueryTest {
    public static final boolean DUMP_ACTUAL_RESULTS = Boolean.parseBoolean(System.getProperty("druid.tests.sql.dumpActualResults")) || CalciteWindowQueryTest.developerIDEdetected();
    private static final ObjectMapper YAML_JACKSON = new DefaultObjectMapper((JsonFactory)new YAMLFactory(), "tests");
    private static final Map<String, Object> DEFAULT_QUERY_CONTEXT = ImmutableMap.of((Object)"debug", (Object)true, (Object)"sqlStringifyArrays", (Object)false);
    private static final Map<String, Object> DEFAULT_QUERY_CONTEXT_WITH_SUBQUERY_BYTES = ImmutableMap.builder().putAll(DEFAULT_QUERY_CONTEXT).put((Object)"maxSubqueryBytes", (Object)"100000").put((Object)"maxSubqueryRows", (Object)"0").build();

    public static Object[] parametersForWindowQueryTest() throws Exception {
        URL windowFolderUrl = ClassLoader.getSystemResource("calcite/tests/window");
        File windowFolder = new File(windowFolderUrl.toURI());
        File[] listedFiles = windowFolder.listFiles(pathname -> pathname.getName().toLowerCase(Locale.ROOT).endsWith(".sqltest"));
        return Arrays.stream(Objects.requireNonNull(listedFiles)).map(File::getName).toArray();
    }

    @MethodSource(value={"parametersForWindowQueryTest"})
    @ParameterizedTest(name="{0}")
    public void windowQueryTest(String filename) throws Exception {
        TestCase testCase = new TestCase(filename);
        Assumptions.assumeTrue((testCase.getType() != WindowQueryTestInputClass.TestType.failingTest ? 1 : 0) != 0);
        if (testCase.getType() == WindowQueryTestInputClass.TestType.operatorValidation) {
            this.testBuilder().skipVectorize(true).sql(testCase.getSql()).queryContext((Map<String, Object>)ImmutableMap.builder().putAll(DEFAULT_QUERY_CONTEXT).putAll(testCase.getQueryContext()).build()).addCustomVerification(QueryVerification.ofResults(testCase)).run();
        }
    }

    @MethodSource(value={"parametersForWindowQueryTest"})
    @ParameterizedTest(name="{0}")
    public void windowQueryTestsWithSubqueryBytes(String filename) throws Exception {
        TestCase testCase = new TestCase(filename);
        Assumptions.assumeTrue((testCase.getType() != WindowQueryTestInputClass.TestType.failingTest ? 1 : 0) != 0);
        if (testCase.getType() == WindowQueryTestInputClass.TestType.operatorValidation) {
            this.testBuilder().skipVectorize(true).sql(testCase.getSql()).queryContext((Map<String, Object>)ImmutableMap.builder().putAll(DEFAULT_QUERY_CONTEXT_WITH_SUBQUERY_BYTES).putAll(testCase.getQueryContext()).build()).addCustomVerification(QueryVerification.ofResults(testCase)).run();
        }
    }

    @Test
    public void testWithArrayConcat() {
        this.testBuilder().sql("select countryName, cityName, channel, array_concat_agg(ARRAY['abc', channel], 10000) over (partition by cityName order by countryName) as c\nfrom wikipedia\nwhere countryName in ('Austria', 'Republic of Korea') and (cityName in ('Vienna', 'Seoul') or cityName is null)\ngroup by countryName, cityName, channel").queryContext(DEFAULT_QUERY_CONTEXT).expectedResults(BaseCalciteQueryTest.ResultMatchMode.RELAX_NULLS, (List<Object[]>)ImmutableList.of((Object)new Object[]{"Austria", null, "#de.wikipedia", ImmutableList.of((Object)"abc", (Object)"#de.wikipedia")}, (Object)new Object[]{"Republic of Korea", null, "#en.wikipedia", ImmutableList.of((Object)"abc", (Object)"#de.wikipedia", (Object)"abc", (Object)"#en.wikipedia", (Object)"abc", (Object)"#ja.wikipedia", (Object)"abc", (Object)"#ko.wikipedia")}, (Object)new Object[]{"Republic of Korea", null, "#ja.wikipedia", ImmutableList.of((Object)"abc", (Object)"#de.wikipedia", (Object)"abc", (Object)"#en.wikipedia", (Object)"abc", (Object)"#ja.wikipedia", (Object)"abc", (Object)"#ko.wikipedia")}, (Object)new Object[]{"Republic of Korea", null, "#ko.wikipedia", ImmutableList.of((Object)"abc", (Object)"#de.wikipedia", (Object)"abc", (Object)"#en.wikipedia", (Object)"abc", (Object)"#ja.wikipedia", (Object)"abc", (Object)"#ko.wikipedia")}, (Object)new Object[]{"Republic of Korea", "Seoul", "#ko.wikipedia", ImmutableList.of((Object)"abc", (Object)"#ko.wikipedia")}, (Object)new Object[]{"Austria", "Vienna", "#de.wikipedia", ImmutableList.of((Object)"abc", (Object)"#de.wikipedia", (Object)"abc", (Object)"#es.wikipedia", (Object)"abc", (Object)"#tr.wikipedia")}, (Object)new Object[]{"Austria", "Vienna", "#es.wikipedia", ImmutableList.of((Object)"abc", (Object)"#de.wikipedia", (Object)"abc", (Object)"#es.wikipedia", (Object)"abc", (Object)"#tr.wikipedia")}, (Object)new Object[]{"Austria", "Vienna", "#tr.wikipedia", ImmutableList.of((Object)"abc", (Object)"#de.wikipedia", (Object)"abc", (Object)"#es.wikipedia", (Object)"abc", (Object)"#tr.wikipedia")})).run();
    }

    @Test
    public void testFailure_partitionByMVD() {
        DruidException e = (DruidException)Assert.assertThrows(DruidException.class, () -> this.testBuilder().sql("select cityName, countryName, array_to_mv(array[1,length(cityName)]),\nrow_number() over (partition by  array_to_mv(array[1,length(cityName)]) order by countryName, cityName)\nfrom wikipedia\nwhere countryName in ('Austria', 'Republic of Korea') and cityName is not null\norder by 1, 2, 3").queryContext(DEFAULT_QUERY_CONTEXT).run());
        Assert.assertEquals((Object)"Encountered a multi value column [v0]. Window processing does not support MVDs. Consider using UNNEST or MV_TO_ARRAY.", (Object)e.getMessage());
        DruidException e1 = (DruidException)Assert.assertThrows(DruidException.class, () -> this.testBuilder().sql("select cityName, countryName, array_to_mv(array[1,length(cityName)]),\nrow_number() over (partition by  array_to_mv(array[1,length(cityName)]) order by countryName, cityName)\nfrom wikipedia\nwhere countryName in ('Austria', 'Republic of Korea') and cityName is not null\norder by 1, 2, 3").queryContext((Map<String, Object>)ImmutableMap.of((Object)"debug", (Object)true, (Object)"sqlStringifyArrays", (Object)false, (Object)"enableRACOverWire", (Object)true)).run());
        Assert.assertEquals((Object)"Encountered a multi value column. Window processing does not support MVDs. Consider using UNNEST or MV_TO_ARRAY.", (Object)e1.getMessage());
    }

    private WindowOperatorQuery getWindowOperatorQuery(List<Query<?>> queries) {
        Assert.assertEquals((long)1L, (long)queries.size());
        Query<?> query = queries.get(0);
        Assert.assertTrue((boolean)(query instanceof WindowOperatorQuery));
        return (WindowOperatorQuery)query;
    }

    class TestCase
    implements QueryVerification.QueryResultsVerifier {
        private WindowQueryTestInputClass input;
        private ObjectMapper queryJackson;

        public TestCase(String filename) throws Exception {
            URL systemResource = ClassLoader.getSystemResource("calcite/tests/window/" + filename);
            Object objectFromYaml = YAML_JACKSON.readValue(systemResource, Object.class);
            this.queryJackson = CalciteWindowQueryTest.this.queryFramework().queryJsonMapper();
            this.input = (WindowQueryTestInputClass)this.queryJackson.convertValue(objectFromYaml, WindowQueryTestInputClass.class);
        }

        public WindowQueryTestInputClass.TestType getType() {
            return this.input.type;
        }

        public String getSql() {
            return this.input.sql;
        }

        @Override
        public void verifyResults(QueryTestRunner.QueryResults results) throws Exception {
            if (results.exception != null) {
                throw new RE((Throwable)results.exception, "Failed to execute because of exception.", new Object[0]);
            }
            Assert.assertEquals((long)1L, (long)results.recordedQueries.size());
            this.maybeDumpActualResults(results.results);
            if (this.input.expectedOperators != null) {
                WindowOperatorQuery query = CalciteWindowQueryTest.this.getWindowOperatorQuery(results.recordedQueries);
                this.validateOperators(this.input.expectedOperators, query.getOperators());
            }
            RowSignature outputSignature = results.signature;
            ColumnType[] types = new ColumnType[outputSignature.size()];
            for (int i = 0; i < outputSignature.size(); ++i) {
                types[i] = (ColumnType)outputSignature.getColumnType(i).get();
                Assert.assertEquals((Object)types[i], results.signature.getColumnType(i).get());
            }
            for (Object[] result : this.input.expectedResults) {
                block7: for (int i = 0; i < result.length; ++i) {
                    if (result[i] == null || !(result[i] instanceof Number)) continue;
                    switch ((ValueType)types[i].getType()) {
                        case LONG: {
                            result[i] = ((Number)result[i]).longValue();
                            continue block7;
                        }
                        case DOUBLE: {
                            result[i] = ((Number)result[i]).doubleValue();
                            continue block7;
                        }
                        case FLOAT: {
                            result[i] = Float.valueOf(((Number)result[i]).floatValue());
                            continue block7;
                        }
                        default: {
                            throw new ISE("result[%s] was type[%s]!?  Expected it to be numerical", new Object[]{i, types[i].getType()});
                        }
                    }
                }
            }
            CalciteWindowQueryTest.this.assertResultsValid(BaseCalciteQueryTest.ResultMatchMode.RELAX_NULLS_EPS, this.input.expectedResults, results);
        }

        private void validateOperators(List<OperatorFactory> expectedOperators, List<OperatorFactory> currentOperators) throws Exception {
            for (int i = 0; i < expectedOperators.size(); ++i) {
                OperatorFactory actualOperator;
                OperatorFactory expectedOperator = expectedOperators.get(i);
                if (expectedOperator.validateEquivalent(actualOperator = currentOperators.get(i))) continue;
                Assert.assertEquals((String)("Operator Mismatch, index[" + i + "]"), (Object)this.queryJackson.writeValueAsString((Object)expectedOperator), (Object)this.queryJackson.writeValueAsString((Object)actualOperator));
                Assert.fail((String)"validateEquivalent failed; but textual comparision of operators didn't reported the mismatch!");
            }
            Assert.assertEquals((String)"Operator count mismatch!", (long)expectedOperators.size(), (long)currentOperators.size());
        }

        private void maybeDumpActualResults(List<Object[]> results) throws Exception {
            if (DUMP_ACTUAL_RESULTS) {
                StringBuilder sb = new StringBuilder();
                for (Object[] row : results) {
                    sb.append("  - ");
                    sb.append(this.queryJackson.writeValueAsString((Object)row));
                    sb.append("\n");
                }
                BaseCalciteQueryTest.log.info("Actual results:\n%s", new Object[]{sb.toString()});
            }
        }

        public Map<? extends String, ? extends Object> getQueryContext() {
            return this.input.queryContext == null ? Collections.emptyMap() : this.input.queryContext;
        }
    }

    public static class WindowQueryTestInputClass {
        @JsonProperty
        public TestType type;
        @JsonProperty
        public Map<String, String> queryContext;
        @JsonProperty
        public String sql;
        @JsonProperty
        public List<OperatorFactory> expectedOperators;
        @JsonProperty
        public List<Object[]> expectedResults;

        static enum TestType {
            failingTest,
            operatorValidation;

        }
    }
}

