/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.druid.sql.calcite.BaseCalciteQueryTest;
import org.apache.druid.sql.calcite.NotYetSupported;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class CalciteSysQueryTest
extends BaseCalciteQueryTest {
    @RegisterExtension
    NotYetSupported.NotYetSupportedProcessor notYetSupportedProcessor = new NotYetSupported.NotYetSupportedProcessor(NotYetSupported.Scope.BINDABLE);

    @Test
    public void testTasksSum() {
        this.msqIncompatible();
        this.testBuilder().sql("select datasource, sum(duration) from sys.tasks group by datasource").expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{"foo", 11L}, (Object)new Object[]{"foo2", 22L})).expectedLogicalPlan("LogicalAggregate(group=[{0}], EXPR$1=[SUM($1)])\n  LogicalProject(exprs=[[$3, $8]])\n    LogicalTableScan(table=[[sys, tasks]])\n").run();
    }

    @NotYetSupported(value=NotYetSupported.Modes.EXPRESSION_NOT_GROUPED)
    @Test
    public void testTasksSumOver() {
        this.msqIncompatible();
        this.testBuilder().sql("select datasource, sum(duration) over () from sys.tasks group by datasource").expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{"foo", 11L}, (Object)new Object[]{"foo2", 22L})).run();
    }

    @Test
    public void testRoundOnSysTableColumn() {
        this.msqIncompatible();
        this.testBuilder().sql("select round(duration, 1) from sys.tasks ").expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{10L}, (Object)new Object[]{1L}, (Object)new Object[]{20L}, (Object)new Object[]{2L})).expectedLogicalPlan("LogicalProject(exprs=[[ROUND($8, 1)]])\n  LogicalTableScan(table=[[sys, tasks]])\n").run();
    }

    @Test
    public void testRoundOnAvgOnSysTableColumn() {
        this.msqIncompatible();
        this.testBuilder().sql("select round(avg(duration), 1) from sys.tasks ").expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{8.3})).expectedLogicalPlan("LogicalProject(exprs=[[ROUND($0, 1)]])\n  LogicalAggregate(group=[{}], agg#0=[AVG($0)])\n    LogicalProject(exprs=[[$8]])\n      LogicalTableScan(table=[[sys, tasks]])\n").run();
    }
}

