/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.tools.ValidationException;
import org.apache.druid.query.Query;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.sql.SqlStatementFactory;
import org.apache.druid.sql.calcite.BaseCalciteQueryTest;
import org.apache.druid.sql.calcite.SqlTestFrameworkConfig;
import org.apache.druid.sql.calcite.TempDirProducer;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.run.EngineFeature;
import org.apache.druid.sql.calcite.run.NativeSqlEngine;
import org.apache.druid.sql.calcite.run.QueryMaker;
import org.apache.druid.sql.calcite.run.SqlEngine;
import org.apache.druid.sql.calcite.util.SqlTestFramework;
import org.apache.druid.sql.destination.IngestDestination;
import org.junit.jupiter.api.Test;

@SqlTestFrameworkConfig.ComponentSupplier(value=ScanSignatureComponentSupplier.class)
public class CalciteScanSignatureTest
extends BaseCalciteQueryTest {
    @Test
    public void testScanSignature() {
        HashMap<String, String> context = new HashMap<String, String>(QUERY_CONTEXT_DEFAULT);
        context.put("scanSignature", "[{\"name\":\"v0\",\"type\":\"STRING\"}]");
        this.testQuery("SELECT CONCAT(dim1, '-', dim1, '_', dim1) as dimX FROM foo", (List<Query<?>>)ImmutableList.of((Object)CalciteScanSignatureTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteScanSignatureTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteScanSignatureTest.expressionVirtualColumn("v0", "concat(\"dim1\",'-',\"dim1\",'_',\"dim1\")", ColumnType.STRING)}).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(context).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"-_"}, (Object)new Object[]{"10.1-10.1_10.1"}, (Object)new Object[]{"2-2_2"}, (Object)new Object[]{"1-1_1"}, (Object)new Object[]{"def-def_def"}, (Object)new Object[]{"abc-abc_abc"}));
    }

    @Test
    public void testScanSignatureWithDimAsValuePrimitiveByteArr() {
        HashMap context = new HashMap(QUERY_CONTEXT_DEFAULT);
        this.testQuery("SELECT CAST(dim1 AS BIGINT) as dimX FROM foo2 limit 2", (List<Query<?>>)ImmutableList.of((Object)CalciteScanSignatureTest.newScanQueryBuilder().dataSource("foo2").intervals(CalciteScanSignatureTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.LONG}).virtualColumns(new VirtualColumn[]{CalciteScanSignatureTest.expressionVirtualColumn("v0", "CAST(\"dim1\", 'LONG')", ColumnType.LONG)}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(context).limit(2L).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null}, (Object)new Object[]{null}));
    }

    static class ScanSignatureComponentSupplier
    extends SqlTestFramework.StandardComponentSupplier {
        public ScanSignatureComponentSupplier(TempDirProducer tempFolderProducer) {
            super(tempFolderProducer);
        }

        @Override
        public Class<? extends SqlEngine> getSqlEngineClass() {
            return ScanSignatureTestSqlEngine.class;
        }

        private static class ScanSignatureTestSqlEngine
        implements SqlEngine {
            private final SqlEngine parent;

            @Inject
            public ScanSignatureTestSqlEngine(NativeSqlEngine parent) {
                this.parent = parent;
            }

            public String name() {
                return this.getClass().getName();
            }

            public boolean featureAvailable(EngineFeature feature) {
                return feature == EngineFeature.SCAN_NEEDS_SIGNATURE || this.parent.featureAvailable(feature);
            }

            public void validateContext(Map<String, Object> queryContext) {
            }

            public RelDataType resultTypeForSelect(RelDataTypeFactory typeFactory, RelDataType validatedRowType, Map<String, Object> queryContext) {
                return validatedRowType;
            }

            public RelDataType resultTypeForInsert(RelDataTypeFactory typeFactory, RelDataType validatedRowType, Map<String, Object> queryContext) {
                throw new UnsupportedOperationException();
            }

            public QueryMaker buildQueryMakerForSelect(RelRoot relRoot, PlannerContext plannerContext) throws ValidationException {
                return this.parent.buildQueryMakerForSelect(relRoot, plannerContext);
            }

            public QueryMaker buildQueryMakerForInsert(IngestDestination destination, RelRoot relRoot, PlannerContext plannerContext) {
                throw new UnsupportedOperationException();
            }

            public SqlStatementFactory getSqlStatementFactory() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

