/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.DruidExceptionMatcher;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.FilteredDataSource;
import org.apache.druid.query.GlobalTableDataSource;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.JoinAlgorithm;
import org.apache.druid.query.JoinDataSource;
import org.apache.druid.query.LookupDataSource;
import org.apache.druid.query.Order;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.QueryException;
import org.apache.druid.query.RestrictedDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.UnionDataSource;
import org.apache.druid.query.UnnestDataSource;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.druid.query.aggregation.FloatMinAggregatorFactory;
import org.apache.druid.query.aggregation.LongMaxAggregatorFactory;
import org.apache.druid.query.aggregation.LongMinAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.any.StringAnyAggregatorFactory;
import org.apache.druid.query.aggregation.cardinality.CardinalityAggregatorFactory;
import org.apache.druid.query.aggregation.post.ArithmeticPostAggregator;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.dimension.ExtractionDimensionSpec;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.SubstringDimExtractionFn;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.LikeDimFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.druid.query.groupby.orderby.LimitSpec;
import org.apache.druid.query.groupby.orderby.NoopLimitSpec;
import org.apache.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.query.policy.Policy;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.topn.DimensionTopNMetricSpec;
import org.apache.druid.query.topn.InvertedTopNMetricSpec;
import org.apache.druid.query.topn.NumericTopNMetricSpec;
import org.apache.druid.query.topn.TopNMetricSpec;
import org.apache.druid.query.topn.TopNQueryBuilder;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.join.JoinType;
import org.apache.druid.segment.join.JoinableFactoryWrapper;
import org.apache.druid.segment.virtual.ListFilteredVirtualColumn;
import org.apache.druid.server.QueryLifecycle;
import org.apache.druid.server.security.AuthorizationResult;
import org.apache.druid.sql.calcite.BaseCalciteQueryTest;
import org.apache.druid.sql.calcite.DecoupledTestConfig;
import org.apache.druid.sql.calcite.NotYetSupported;
import org.apache.druid.sql.calcite.QueryTestRunner;
import org.apache.druid.sql.calcite.SqlTestFrameworkConfig;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.apache.druid.sql.calcite.run.EngineFeature;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.apache.druid.sql.http.SqlParameter;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class CalciteJoinQueryTest
extends BaseCalciteQueryTest {
    public boolean isSortBasedJoin() {
        return false;
    }

    @SqlTestFrameworkConfig.MinTopNThreshold(value=1)
    @Test
    public void testInnerJoinWithLimitAndAlias() {
        HashMap<String, Object> context = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
        context.put("useApproximateTopN", false);
        this.testQuery("select t1.b1 from (select __time as b1 from numfoo group by 1 order by 1) as t1 inner join (\n  select __time as b2 from foo group by 1 order by 1\n) as t2 on t1.b1 = t2.b2 ", (Map<String, Object>)context, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).dataSource((DataSource)JoinDataSource.create((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDataSource((DataSource)new TableDataSource("numfoo")).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("__time", "d0", ColumnType.LONG)}).setContext(context).build()), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDataSource((DataSource)new TableDataSource("foo")).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("__time", "d0", ColumnType.LONG)}).setContext(context).build()), (String)"j0.", (String)"(\"d0\" == \"j0.d0\")", (JoinType)JoinType.INNER, null, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)CalciteTests.createJoinableFactoryWrapper(), (JoinAlgorithm)JoinAlgorithm.BROADCAST)).columns(new String[]{"d0"}).columnTypes(new ColumnType[]{ColumnType.LONG}).context(context).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{946684800000L}, (Object)new Object[]{946771200000L}, (Object)new Object[]{946857600000L}, (Object)new Object[]{978307200000L}, (Object)new Object[]{978393600000L}, (Object)new Object[]{978480000000L}));
    }

    @SqlTestFrameworkConfig.MinTopNThreshold(value=1)
    @Test
    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.EQUIV_PLAN)
    public void testExactTopNOnInnerJoinWithLimit() {
        HashMap<String, Object> context = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
        context.put("useApproximateTopN", false);
        context.put("useLexicographicTopN", true);
        this.testQuery("select f1.\"dim4\", sum(\"m1\") from numfoo f1 inner join (\n  select \"dim4\" from numfoo where dim4 <> 'a' group by 1\n) f2 on f1.\"dim4\" = f2.\"dim4\" group by 1 limit 1", (Map<String, Object>)context, (List<Query<?>>)ImmutableList.of((Object)new TopNQueryBuilder().intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim4", "d0")).aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "m1")}).metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.LEXICOGRAPHIC)).threshold(1).dataSource((DataSource)JoinDataSource.create((DataSource)new TableDataSource("numfoo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)CalciteJoinQueryTest.not(CalciteJoinQueryTest.equality("dim4", "a", ColumnType.STRING))).setDataSource((DataSource)new TableDataSource("numfoo")).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim4", "d0")}).setContext(context).build()), (String)"j0.", (String)"(\"dim4\" == \"j0.d0\")", (JoinType)JoinType.INNER, null, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)CalciteTests.createJoinableFactoryWrapper(), (JoinAlgorithm)JoinAlgorithm.BROADCAST)).context(context).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"b", 15.0}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.EQUIV_PLAN_EXTRA_COLUMNS)
    @Test
    public void testJoinOuterGroupByAndSubqueryHasLimit() {
        this.cannotVectorize();
        this.testQuery("SELECT dim2, AVG(m2) FROM (SELECT * FROM foo AS t1 INNER JOIN foo AS t2 ON t1.m1 = t2.m1 LIMIT 10) AS t3 GROUP BY dim2", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns((List)ImmutableList.of((Object)"m1")).columnTypes(new ColumnType[]{ColumnType.FLOAT}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), "j0.", CalciteJoinQueryTest.equalsCondition(DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"m1"), DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"j0.m1")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).limit(10L).columns(new String[]{"dim2", "m2"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.DOUBLE}).context(QUERY_CONTEXT_DEFAULT).build()).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0", ColumnType.STRING)}).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0:sum", "m2"), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0:count"), CalciteJoinQueryTest.notNull("m2"))})).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ArithmeticPostAggregator("a0", "quotient", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, "a0:sum"), (Object)new FieldAccessPostAggregator(null, "a0:count"))))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 4.0}, (Object)new Object[]{"", 3.0}, (Object)new Object[]{"a", 2.5}, (Object)new Object[]{"abc", 5.0}));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testJoinOuterGroupByAndSubqueryNoLimit(Map<String, Object> queryContext) {
        if (!CalciteJoinQueryTest.isRewriteJoinToFilter(queryContext)) {
            this.cannotVectorize();
        }
        this.testQuery("SELECT dim2, AVG(m2) FROM (SELECT * FROM foo AS t1 INNER JOIN foo AS t2 ON t1.m1 = t2.m1) AS t3 GROUP BY dim2", queryContext, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns((List)ImmutableList.of((Object)"m1")).columnTypes(new ColumnType[]{ColumnType.FLOAT}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build().withOverriddenContext(queryContext)), "j0.", CalciteJoinQueryTest.equalsCondition(DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"m1"), DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"j0.m1")), JoinType.INNER)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0", ColumnType.STRING)}).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0:sum", "m2"), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0:count"), CalciteJoinQueryTest.notNull("m2"))})).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ArithmeticPostAggregator("a0", "quotient", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, "a0:sum"), (Object)new FieldAccessPostAggregator(null, "a0:count"))))).setContext(QUERY_CONTEXT_DEFAULT).build().withOverriddenContext(queryContext)), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 4.0}, (Object)new Object[]{"", 3.0}, (Object)new Object[]{"a", 2.5}, (Object)new Object[]{"abc", 5.0}));
    }

    @Test
    public void testJoinWithLimitBeforeJoining() {
        this.cannotVectorize();
        this.testQuery("SELECT t1.dim2, AVG(t1.m2) FROM (SELECT * FROM foo LIMIT 10) AS t1 INNER JOIN foo AS t2 ON t1.m1 = t2.m1 GROUP BY t1.dim2", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim2", "m1", "m2"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.FLOAT, ColumnType.DOUBLE}).context(QUERY_CONTEXT_DEFAULT).limit(10L).build()), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"m1"}).columnTypes(new ColumnType[]{ColumnType.FLOAT}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), "j0.", CalciteJoinQueryTest.equalsCondition(DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"m1"), DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"j0.m1")), JoinType.INNER)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0", ColumnType.STRING)}).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0:sum", "m2"), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0:count"), CalciteJoinQueryTest.notNull("m2"))})).setPostAggregatorSpecs((List)ImmutableList.of((Object)new ArithmeticPostAggregator("a0", "quotient", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, "a0:sum"), (Object)new FieldAccessPostAggregator(null, "a0:count"))))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 4.0}, (Object)new Object[]{"", 3.0}, (Object)new Object[]{"a", 2.5}, (Object)new Object[]{"abc", 5.0}));
    }

    @Test
    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.JOIN_FILTER_LOCATIONS)
    public void testJoinOnTimeseriesWithFloorOnTime() {
        this.cannotVectorize();
        this.testQuery("SELECT CAST(__time AS BIGINT), m1, ANY_VALUE(dim3, 100, true) FROM foo WHERE (TIME_FLOOR(__time, 'PT1H'), m1) IN\n   (\n     SELECT TIME_FLOOR(__time, 'PT1H') AS t1, MIN(m1) AS t2 FROM foo WHERE dim3 = 'b'\n         AND __time BETWEEN '1994-04-29 00:00:00' AND '2020-01-11 00:00:00' GROUP BY 1\n    )\nGROUP BY 1, 2\n", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Intervals.of((String)"1994-04-29/2020-01-11T00:00:00.001Z"))).filters(CalciteJoinQueryTest.equality("dim3", "b", ColumnType.STRING)).granularity((Granularity)new PeriodGranularity(Period.hours((int)1), null, DateTimeZone.UTC)).aggregators(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new FloatMinAggregatorFactory("a0", "m1")})).context(CalciteJoinQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_BY_GRAN, "d0")).build()), "j0.", "((timestamp_floor(\"__time\",'PT1H',null,'UTC') == \"j0.d0\") && (\"m1\" == \"j0.a0\"))", JoinType.INNER)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("__time", "d0", ColumnType.LONG), new DefaultDimensionSpec("m1", "d1", ColumnType.FLOAT)}).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new StringAnyAggregatorFactory("a0", "dim3", Integer.valueOf(100), Boolean.valueOf(true))})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{946684800000L, Float.valueOf(1.0f), "[a, b]"}, (Object)new Object[]{946771200000L, Float.valueOf(2.0f), "[b, c]"}));
    }

    @Test
    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.JOIN_FILTER_LOCATIONS)
    public void testJoinOnGroupByInsteadOfTimeseriesWithFloorOnTime() {
        this.cannotVectorize();
        this.testQuery("SELECT CAST(__time AS BIGINT), m1, ANY_VALUE(dim3, 100) FROM foo WHERE (CAST(TIME_FLOOR(__time, 'PT1H') AS BIGINT) + 1, m1) IN\n   (\n     SELECT CAST(TIME_FLOOR(__time, 'PT1H') AS BIGINT) + 1 AS t1, MIN(m1) AS t2 FROM foo WHERE dim3 = 'b'\n         AND __time BETWEEN '1994-04-29 00:00:00' AND '2020-01-11 00:00:00' GROUP BY 1\n    )\nGROUP BY 1, 2\n", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteJoinQueryTest.querySegmentSpec(Intervals.of((String)"1994-04-29/2020-01-11T00:00:00.001Z"))).setVirtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "(timestamp_floor(\"__time\",'PT1H',null,'UTC') + 1)", ColumnType.LONG)}).setDimFilter(CalciteJoinQueryTest.equality("dim3", "b", ColumnType.STRING)).setGranularity(Granularities.ALL).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new FloatMinAggregatorFactory("a0", "m1")})).setContext(QUERY_CONTEXT_DEFAULT).build()), "j0.", "(((timestamp_floor(\"__time\",'PT1H',null,'UTC') + 1) == \"j0.d0\") && (\"m1\" == \"j0.a0\"))", JoinType.INNER)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("__time", "d0", ColumnType.LONG), new DefaultDimensionSpec("m1", "d1", ColumnType.FLOAT)}).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new StringAnyAggregatorFactory("a0", "dim3", Integer.valueOf(100), Boolean.valueOf(true))})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{946684800000L, Float.valueOf(1.0f), "[a, b]"}, (Object)new Object[]{946771200000L, Float.valueOf(2.0f), "[b, c]"}));
    }

    @Test
    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.JOIN_FILTER_LOCATIONS)
    public void testJoinOnGroupByInsteadOfTimeseriesWithFloorOnTimeWithNoAggregateMultipleValues() {
        this.cannotVectorize();
        this.testQuery("SELECT CAST(__time AS BIGINT), m1, ANY_VALUE(dim3, 100, false) FROM foo WHERE (CAST(TIME_FLOOR(__time, 'PT1H') AS BIGINT) + 1, m1) IN\n   (\n     SELECT CAST(TIME_FLOOR(__time, 'PT1H') AS BIGINT) + 1 AS t1, MIN(m1) AS t2 FROM foo WHERE dim3 = 'b'\n         AND __time BETWEEN '1994-04-29 00:00:00' AND '2020-01-11 00:00:00' GROUP BY 1\n    )\nGROUP BY 1, 2\n", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteJoinQueryTest.querySegmentSpec(Intervals.of((String)"1994-04-29/2020-01-11T00:00:00.001Z"))).setVirtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "(timestamp_floor(\"__time\",'PT1H',null,'UTC') + 1)", ColumnType.LONG)}).setDimFilter(CalciteJoinQueryTest.equality("dim3", "b", ColumnType.STRING)).setGranularity(Granularities.ALL).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new FloatMinAggregatorFactory("a0", "m1")})).setContext(QUERY_CONTEXT_DEFAULT).build()), "j0.", "(((timestamp_floor(\"__time\",'PT1H',null,'UTC') + 1) == \"j0.d0\") && (\"m1\" == \"j0.a0\"))", JoinType.INNER)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("__time", "d0", ColumnType.LONG), new DefaultDimensionSpec("m1", "d1", ColumnType.FLOAT)}).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new StringAnyAggregatorFactory("a0", "dim3", Integer.valueOf(100), Boolean.valueOf(false))})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{946684800000L, Float.valueOf(1.0f), "a"}, (Object)new Object[]{946771200000L, Float.valueOf(2.0f), "b"}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.SLIGHTLY_WORSE_FILTER_PUSHED_TO_JOIN_OPERAND)
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testFilterAndGroupByLookupUsingJoinOperatorWithValueFilterPushdownMatchesNothing(Map<String, Object> queryContext) {
        this.cannotVectorize();
        this.testQuery("SELECT lookyloo.k, COUNT(*)\nFROM foo LEFT JOIN lookup.lookyloo ON foo.dim2 = lookyloo.k\nWHERE lookyloo.v = '123'\nGROUP BY lookyloo.k", queryContext, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.LEFT)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setDimFilter(CalciteJoinQueryTest.equality("j0.v", "123", ColumnType.STRING)).setGranularity(Granularities.ALL).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("j0.k", "d0")})).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of());
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testFilterAndGroupByLookupUsingJoinOperatorAllowNulls(Map<String, Object> queryContext) {
        this.cannotVectorize();
        this.testQuery("SELECT lookyloo.v, COUNT(*)\nFROM foo LEFT JOIN lookup.lookyloo ON foo.dim2 = lookyloo.k\nWHERE lookyloo.v <> 'xa' OR lookyloo.v IS NULL\nGROUP BY lookyloo.v", queryContext, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.LEFT)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)CalciteJoinQueryTest.or(new DimFilter[]{CalciteJoinQueryTest.isNull("j0.v"), CalciteJoinQueryTest.not(CalciteJoinQueryTest.equality("j0.v", "xa", ColumnType.STRING))})).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("j0.v", "d0")})).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 3L}, (Object)new Object[]{"xabc", 1L}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.SLIGHTLY_WORSE_FILTER_PUSHED_TO_JOIN_OPERAND)
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testFilterAndGroupByLookupUsingJoinOperatorBackwards(Map<String, Object> queryContext) {
        Assumptions.assumeFalse((this.isRunningMSQ() && !this.isSortBasedJoin() ? 1 : 0) != 0, (String)"MSQ refuses to do RIGHT join with broadcast.");
        this.cannotVectorize();
        this.testQuery("SELECT lookyloo.v, COUNT(*)\nFROM lookup.lookyloo RIGHT JOIN foo ON foo.dim2 = lookyloo.k\nWHERE lookyloo.v <> 'xa'\nGROUP BY lookyloo.v", queryContext, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new LookupDataSource("lookyloo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim2"}).columnTypes(new ColumnType[]{ColumnType.STRING}).context(QUERY_CONTEXT_DEFAULT).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("k"), CalciteJoinQueryTest.makeColumnExpression("j0.dim2")), JoinType.INNER)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setDimFilter((DimFilter)CalciteJoinQueryTest.not(CalciteJoinQueryTest.equality("v", "xa", ColumnType.STRING))).setGranularity(Granularities.ALL).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v", "d0")})).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"xabc", 1L}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.SLIGHTLY_WORSE_FILTER_PUSHED_TO_JOIN_OPERAND)
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testFilterAndGroupByLookupUsingJoinOperatorWithNotFilter(Map<String, Object> queryContext) {
        this.cannotVectorize();
        this.testQuery("SELECT lookyloo.v, COUNT(*)\nFROM foo LEFT JOIN lookup.lookyloo ON foo.dim2 = lookyloo.k\nWHERE lookyloo.v <> 'xa'\nGROUP BY lookyloo.v", queryContext, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.INNER)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setDimFilter((DimFilter)CalciteJoinQueryTest.not(CalciteJoinQueryTest.equality("j0.v", "xa", ColumnType.STRING))).setGranularity(Granularities.ALL).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("j0.v", "d0")})).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"xabc", 1L}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.SLIGHTLY_WORSE_FILTER_PUSHED_TO_JOIN_OPERAND)
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testJoinUnionTablesOnLookup(Map<String, Object> queryContext) {
        this.msqIncompatible();
        this.cannotVectorize();
        this.testQuery("SELECT lookyloo.v, COUNT(*)\nFROM\n  (SELECT dim2 FROM foo UNION ALL SELECT dim2 FROM numfoo) u\n  LEFT JOIN lookup.lookyloo ON u.dim2 = lookyloo.k\nWHERE lookyloo.v <> 'xa'\nGROUP BY lookyloo.v", queryContext, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new UnionDataSource((List)ImmutableList.of((Object)new TableDataSource("foo"), (Object)new TableDataSource("numfoo"))), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.INNER)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setDimFilter((DimFilter)CalciteJoinQueryTest.not(CalciteJoinQueryTest.equality("j0.v", "xa", ColumnType.STRING))).setGranularity(Granularities.ALL).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("j0.v", "d0")})).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"xabc", 2L}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.SLIGHTLY_WORSE_FILTER_PUSHED_TO_JOIN_OPERAND)
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testFilterAndGroupByLookupUsingJoinOperator(Map<String, Object> queryContext) {
        this.cannotVectorize();
        this.testQuery("SELECT lookyloo.k, COUNT(*)\nFROM foo LEFT JOIN lookup.lookyloo ON foo.dim2 = lookyloo.k\nWHERE lookyloo.v = 'xa'\nGROUP BY lookyloo.k", queryContext, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.LEFT)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setDimFilter(CalciteJoinQueryTest.equality("j0.v", "xa", ColumnType.STRING)).setGranularity(Granularities.ALL).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("j0.k", "d0")})).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a", 2L}));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testFilterAndGroupByLookupUsingPostAggregationJoinOperator(Map<String, Object> queryContext) {
        this.testQuery("SELECT base.dim2, lookyloo.v, base.cnt FROM (\n  SELECT dim2, COUNT(*) cnt FROM foo GROUP BY dim2\n) base\nLEFT JOIN lookup.lookyloo ON base.dim2 = lookyloo.k\nWHERE lookyloo.v <> 'xa' OR lookyloo.v IS NULL", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(queryContext).build()), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("d0"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.LEFT)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteJoinQueryTest.or(new DimFilter[]{CalciteJoinQueryTest.isNull("j0.v"), CalciteJoinQueryTest.not(CalciteJoinQueryTest.equality("j0.v", "xa", ColumnType.STRING))})).columns(new String[]{"d0", "j0.v", "a0"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.LONG}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, null, 2L}, (Object)new Object[]{"", null, 1L}, (Object)new Object[]{"abc", "xabc", 1L}));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testGroupByInnerJoinOnLookupUsingJoinOperator(Map<String, Object> queryContext) {
        this.cannotVectorize();
        this.testQuery("SELECT lookyloo.v, COUNT(*)\nFROM foo INNER JOIN lookup.lookyloo ON foo.dim1 = lookyloo.k\nGROUP BY lookyloo.v", queryContext, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim1"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.INNER)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("j0.v", "d0")})).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"xabc", 1L}));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testSelectOnLookupUsingInnerJoinOperator(Map<String, Object> queryContext) {
        this.testQuery("SELECT dim2, lookyloo.*\nFROM foo INNER JOIN lookup.lookyloo ON foo.dim2 = lookyloo.k\n", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim2", "j0.k", "j0.v"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.STRING}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a", "a", "xa"}, (Object)new Object[]{"a", "a", "xa"}, (Object)new Object[]{"abc", "abc", "xabc"}));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testLeftJoinTwoLookupsUsingJoinOperator(Map<String, Object> queryContext) {
        this.testQuery("SELECT dim1, dim2, l1.v, l2.v\nFROM foo\nLEFT JOIN lookup.lookyloo l1 ON foo.dim1 = l1.k\nLEFT JOIN lookup.lookyloo l2 ON foo.dim2 = l2.k\n", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim1"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.LEFT), (DataSource)new LookupDataSource("lookyloo"), "_j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("_j0.k")), JoinType.LEFT)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1", "dim2", "j0.v", "_j0.v"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING}).context(queryContext).build()), this.sortIfSortBased((List<Object[]>)ImmutableList.of((Object)new Object[]{"", "a", null, "xa"}, (Object)new Object[]{"10.1", null, null, null}, (Object)new Object[]{"2", "", null, null}, (Object)new Object[]{"1", "a", null, "xa"}, (Object)new Object[]{"def", "abc", null, "xabc"}, (Object)new Object[]{"abc", null, "xabc", null}), 1));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.SLIGHTLY_WORSE_FILTER_PUSHED_TO_JOIN_OPERAND)
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testInnerJoinTableLookupLookupWithFilterWithOuterLimit(Map<String, Object> queryContext) {
        this.testQuery("SELECT dim1\nFROM foo\nINNER JOIN lookup.lookyloo l ON foo.dim2 = l.k\nINNER JOIN lookup.lookyloo l2 ON foo.dim2 = l2.k\nWHERE l.v = 'xa'\nLIMIT 100\n", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "_j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("_j0.k")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).limit(100L).filters(CalciteJoinQueryTest.equality("j0.v", "xa", ColumnType.STRING)).columns(new String[]{"dim1"}).columnTypes(new ColumnType[]{ColumnType.STRING}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{""}, (Object)new Object[]{"1"}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.SLIGHTLY_WORSE_FILTER_PUSHED_TO_JOIN_OPERAND)
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testInnerJoinTableLookupLookupWithFilterWithoutLimit(Map<String, Object> queryContext) {
        this.testQuery("SELECT dim1\nFROM foo\nINNER JOIN lookup.lookyloo l ON foo.dim2 = l.k\nINNER JOIN lookup.lookyloo l2 ON foo.dim2 = l2.k\nWHERE l.v = 'xa'\n", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "_j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("_j0.k")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters(CalciteJoinQueryTest.equality("j0.v", "xa", ColumnType.STRING)).columns(new String[]{"dim1"}).columnTypes(new ColumnType[]{ColumnType.STRING}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{""}, (Object)new Object[]{"1"}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.SLIGHTLY_WORSE_FILTER_PUSHED_TO_JOIN_OPERAND)
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testInnerJoinTableLookupLookupWithFilterWithOuterLimitWithAllColumns(Map<String, Object> queryContext) {
        this.testQuery("SELECT __time, cnt, dim1, dim2, dim3, m1, m2, unique_dim1\nFROM foo\nINNER JOIN lookup.lookyloo l ON foo.dim2 = l.k\nINNER JOIN lookup.lookyloo l2 ON foo.dim2 = l2.k\nWHERE l.v = 'xa'\nLIMIT 100\n", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "_j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("_j0.k")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).limit(100L).filters(CalciteJoinQueryTest.equality("j0.v", "xa", ColumnType.STRING)).columns(new String[]{"__time", "cnt", "dim1", "dim2", "dim3", "m1", "m2", "unique_dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.LONG, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.FLOAT, ColumnType.DOUBLE, ColumnType.ofComplex((String)"hyperUnique")}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{946684800000L, 1L, "", "a", "[\"a\",\"b\"]", Float.valueOf(1.0f), 1.0, "\"AQAAAEAAAA==\""}, (Object)new Object[]{978307200000L, 1L, "1", "a", "", Float.valueOf(4.0f), 4.0, "\"AQAAAQAAAAFREA==\""}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.SLIGHTLY_WORSE_FILTER_PUSHED_TO_JOIN_OPERAND)
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testInnerJoinTableLookupLookupWithFilterWithoutLimitWithAllColumns(Map<String, Object> queryContext) {
        this.testQuery("SELECT __time, cnt, dim1, dim2, dim3, m1, m2, unique_dim1\nFROM foo\nINNER JOIN lookup.lookyloo l ON foo.dim2 = l.k\nINNER JOIN lookup.lookyloo l2 ON foo.dim2 = l2.k\nWHERE l.v = 'xa'\n", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "_j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("_j0.k")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters(CalciteJoinQueryTest.equality("j0.v", "xa", ColumnType.STRING)).columns(new String[]{"__time", "cnt", "dim1", "dim2", "dim3", "m1", "m2", "unique_dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.LONG, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.FLOAT, ColumnType.DOUBLE, ColumnType.ofComplex((String)"hyperUnique")}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{946684800000L, 1L, "", "a", "[\"a\",\"b\"]", Float.valueOf(1.0f), 1.0, "\"AQAAAEAAAA==\""}, (Object)new Object[]{978307200000L, 1L, "1", "a", "", Float.valueOf(4.0f), 4.0, "\"AQAAAQAAAAFREA==\""}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.IMPROVED_PLAN)
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testManyManyInnerJoinOnManyManyLookup(Map<String, Object> queryContext) {
        this.testQuery("SELECT dim1\nFROM foo\nINNER JOIN lookup.lookyloo l ON foo.dim2 = l.k\nINNER JOIN lookup.lookyloo l2 ON foo.dim2 = l2.k\nINNER JOIN lookup.lookyloo l3 ON foo.dim2 = l3.k\nINNER JOIN lookup.lookyloo l4 ON foo.dim2 = l4.k\nINNER JOIN lookup.lookyloo l5 ON foo.dim2 = l5.k\nINNER JOIN lookup.lookyloo l6 ON foo.dim2 = l6.k\nINNER JOIN lookup.lookyloo l7 ON foo.dim2 = l7.k\nINNER JOIN lookup.lookyloo l8 ON foo.dim2 = l8.k\nINNER JOIN lookup.lookyloo l9 ON foo.dim2 = l9.k\nINNER JOIN lookup.lookyloo l10 ON foo.dim2 = l10.k\nINNER JOIN lookup.lookyloo l11 ON foo.dim2 = l11.k\nINNER JOIN lookup.lookyloo l12 ON foo.dim2 = l12.k\nINNER JOIN lookup.lookyloo l13 ON foo.dim2 = l13.k\nINNER JOIN lookup.lookyloo l14 ON foo.dim2 = l14.k\nINNER JOIN lookup.lookyloo l15 ON foo.dim2 = l15.k\nINNER JOIN lookup.lookyloo l16 ON foo.dim2 = l16.k\nINNER JOIN lookup.lookyloo l17 ON foo.dim2 = l17.k\nINNER JOIN lookup.lookyloo l18 ON foo.dim2 = l18.k\nINNER JOIN lookup.lookyloo l19 ON foo.dim2 = l19.k\nWHERE l.v = 'xa'\n", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "_j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("_j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "__j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("__j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "___j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("___j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "____j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("____j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "_____j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("_____j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "______j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("______j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "_______j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("_______j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "________j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("________j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "_________j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("_________j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "__________j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("__________j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "___________j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("___________j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "____________j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("____________j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "_____________j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("_____________j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "______________j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("______________j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "_______________j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("_______________j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "________________j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("________________j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "_________________j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("_________________j0.k")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "__________________j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("__________________j0.k")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters(CalciteJoinQueryTest.equality("j0.v", "xa", ColumnType.STRING)).columns(new String[]{"dim1"}).columnTypes(new ColumnType[]{ColumnType.STRING}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{""}, (Object)new Object[]{"1"}));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testInnerJoinQueryOfLookup(Map<String, Object> queryContext) {
        this.cannotVectorize();
        this.testQuery("SELECT dim1, dim2, t1.v, t1.v\nFROM foo\nINNER JOIN \n  (SELECT SUBSTRING(k, 1, 1) k, ANY_VALUE(v, 10) v FROM lookup.lookyloo GROUP BY 1) t1\n  ON foo.dim2 = t1.k", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((DataSource)new LookupDataSource("lookyloo")).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new ExtractionDimensionSpec("k", "d0", (ExtractionFn)new SubstringDimExtractionFn(0, Integer.valueOf(1)))}).setAggregatorSpecs(new AggregatorFactory[]{new StringAnyAggregatorFactory("a0", "v", Integer.valueOf(10), Boolean.valueOf(true))}).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("j0.d0")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1", "dim2", "j0.a0"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.STRING}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", "a", "xabc", "xabc"}, (Object)new Object[]{"1", "a", "xabc", "xabc"}));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testTimeColumnAggregationsOnLookups(Map<String, Object> queryContext) {
        try {
            this.testQuery("SELECT k, LATEST(v) v FROM lookup.lookyloo GROUP BY k", queryContext, (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
            Assert.fail((String)"Expected exception to be thrown.");
        }
        catch (DruidException e) {
            MatcherAssert.assertThat((Object)((Object)e), (Matcher)new DruidExceptionMatcher(DruidException.Persona.ADMIN, DruidException.Category.INVALID_INPUT, "general").expectMessageIs("Query could not be planned. A possible reason is [LATEST and EARLIEST aggregators implicitly depend on the __time column, but the table queried doesn't contain a __time column.  Please use LATEST_BY or EARLIEST_BY and specify the column explicitly.]"));
        }
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.DEFINETLY_WORSE_PLAN)
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testInnerJoinQueryOfLookupRemovable(Map<String, Object> queryContext) {
        this.testQuery("SELECT dim1, dim2, t1.sk\nFROM foo\nINNER JOIN \n  (SELECT k, SUBSTRING(v, 1, 3) sk FROM lookup.lookyloo) t1\n  ON foo.dim2 = t1.k", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "substring(\"j0.v\", 0, 3)", ColumnType.STRING)}).columns(new String[]{"dim1", "dim2", "v0"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.STRING}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", "a", "xa"}, (Object)new Object[]{"1", "a", "xa"}, (Object)new Object[]{"def", "abc", "xab"}));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testInnerJoinTwoLookupsToTableUsingNumericColumn(Map<String, Object> queryContext) {
        this.cannotVectorize();
        this.testQuery("SELECT COUNT(*)\nFROM foo\nINNER JOIN lookup.lookyloo l1 ON l1.k = foo.m1\nINNER JOIN lookup.lookyloo l2 ON l2.k = l1.k", queryContext, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)new LookupDataSource("lookyloo")).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "CAST(\"k\", 'DOUBLE')", ColumnType.FLOAT)}).columns(new String[]{"k", "v0"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.FLOAT}).context(QUERY_CONTEXT_DEFAULT).build()), "j0.", CalciteJoinQueryTest.equalsCondition(DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"m1"), DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"j0.v0")), JoinType.INNER), (DataSource)new LookupDataSource("lookyloo"), "_j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("j0.k"), CalciteJoinQueryTest.makeColumnExpression("_j0.k")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.EQUIV_PLAN_CAST_MATERIALIZED_EARLIER)
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testInnerJoinTwoLookupsToTableUsingNumericColumnInReverse(Map<String, Object> queryContext) {
        this.cannotVectorize();
        this.testQuery("SELECT COUNT(*)\nFROM lookup.lookyloo l1\nINNER JOIN lookup.lookyloo l2 ON l1.k = l2.k\nINNER JOIN foo on l2.k = foo.m1", queryContext, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)new LookupDataSource("lookyloo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("k"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.INNER), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"m1"}).columnTypes(new ColumnType[]{ColumnType.FLOAT}).context(QUERY_CONTEXT_DEFAULT).build()), "_j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeExpression(ColumnType.DOUBLE, "CAST(\"j0.k\", 'DOUBLE')"), DruidExpression.ofColumn((ColumnType)ColumnType.DOUBLE, (String)"_j0.m1")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testInnerJoinLookupTableTable(Map<String, Object> queryContext) {
        this.cannotVectorize();
        this.testQuery("SELECT l.k, l.v, SUM(f.m1), SUM(nf.m1)\nFROM lookup.lookyloo l\nINNER JOIN druid.foo f on f.dim1 = l.k\nINNER JOIN druid.numfoo nf on nf.dim1 = l.k\nGROUP BY 1, 2 ORDER BY 2", queryContext, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)new LookupDataSource("lookyloo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1", "m1"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.FLOAT}).context(QUERY_CONTEXT_DEFAULT).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("k"), CalciteJoinQueryTest.makeColumnExpression("j0.dim1")), JoinType.INNER), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1", "m1"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.FLOAT}).context(QUERY_CONTEXT_DEFAULT).build()), "_j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("k"), CalciteJoinQueryTest.makeColumnExpression("_j0.dim1")), JoinType.INNER)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("k", "d0"), new DefaultDimensionSpec("v", "d1")})).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "j0.m1"), new DoubleSumAggregatorFactory("a1", "_j0.m1")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d1", OrderByColumnSpec.Direction.ASCENDING)), null)).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc", "xabc", 6.0, 6.0}));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testInnerJoinLookupTableTableChained(Map<String, Object> queryContext) {
        this.cannotVectorize();
        this.testQuery("SELECT l.k, l.v, SUM(f.m1), SUM(nf.m1)\nFROM lookup.lookyloo l\nINNER JOIN druid.foo f on f.dim1 = l.k\nINNER JOIN druid.numfoo nf on nf.dim1 = f.dim1\nGROUP BY 1, 2 ORDER BY 2", queryContext, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)new LookupDataSource("lookyloo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1", "m1"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.FLOAT}).context(QUERY_CONTEXT_DEFAULT).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("k"), CalciteJoinQueryTest.makeColumnExpression("j0.dim1")), JoinType.INNER), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1", "m1"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.FLOAT}).context(QUERY_CONTEXT_DEFAULT).build()), "_j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("j0.dim1"), CalciteJoinQueryTest.makeColumnExpression("_j0.dim1")), JoinType.INNER)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("k", "d0"), new DefaultDimensionSpec("v", "d1")})).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new DoubleSumAggregatorFactory("a0", "j0.m1"), new DoubleSumAggregatorFactory("a1", "_j0.m1")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d1", OrderByColumnSpec.Direction.ASCENDING)), null)).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc", "xabc", 6.0, 6.0}));
    }

    @Test
    public void testWhereInSelectNullFromLookup() {
        this.cannotVectorize();
        this.testQuery("SELECT * FROM foo where dim1 IN (SELECT NULL FROM lookup.lookyloo)", (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((DataSource)new LookupDataSource("lookyloo")).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setVirtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "null", ColumnType.STRING)}).setGranularity(Granularities.ALL).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim1"), CalciteJoinQueryTest.makeColumnExpression("j0.d0")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "null", ColumnType.STRING)}).columns(new String[]{"__time", "v0", "dim2", "dim3", "cnt", "m1", "m2", "unique_dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.LONG, ColumnType.FLOAT, ColumnType.DOUBLE, ColumnType.ofComplex((String)"hyperUnique")}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of());
    }

    @Test
    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.JOIN_FILTER_LOCATIONS)
    public void testCommaJoinLeftFunction() {
        this.testQuery("SELECT foo.dim1, foo.dim2, l.k, l.v\nFROM foo, lookup.lookyloo l\nWHERE SUBSTRING(foo.dim2, 1, 1) = l.k\n", (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeExpression("substring(\"dim2\", 0, 1)"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1", "dim2", "j0.k", "j0.v"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", "a", "a", "xa"}, (Object)new Object[]{"1", "a", "a", "xa"}, (Object)new Object[]{"def", "abc", "a", "xa"}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.IRRELEVANT_SCANQUERY)
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testCommaJoinTableLookupTableMismatchedTypes(Map<String, Object> queryContext) {
        this.msqIncompatible();
        this.cannotVectorize();
        this.testQuery("SELECT COUNT(*)\nFROM foo, lookup.lookyloo l, numfoo\nWHERE foo.cnt = l.k AND l.k = numfoo.cnt\n", queryContext, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", "1", JoinType.INNER), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).columns(new String[]{"cnt"}).columnTypes(new ColumnType[]{ColumnType.LONG}).context(QUERY_CONTEXT_DEFAULT).build()), "_j0.", CalciteJoinQueryTest.equalsCondition(DruidExpression.fromExpression((String)"CAST(\"j0.k\", 'LONG')"), DruidExpression.ofColumn((ColumnType)ColumnType.LONG, (String)"_j0.cnt")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).filters((DimFilter)CalciteJoinQueryTest.expressionFilter("(\"cnt\" == CAST(\"j0.k\", 'LONG'))")).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{0L}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.EQUIV_PLAN_CAST_MATERIALIZED_EARLIER)
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testJoinTableLookupTableMismatchedTypesWithoutComma(Map<String, Object> queryContext) {
        this.msqIncompatible();
        this.cannotVectorize();
        this.testQuery("SELECT COUNT(*)\nFROM foo\nINNER JOIN lookup.lookyloo l ON foo.cnt = l.k\nINNER JOIN numfoo ON l.k = numfoo.cnt\n", queryContext, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)new LookupDataSource("lookyloo")).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "CAST(\"k\", 'LONG')", ColumnType.LONG)}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).columns(new String[]{"k", "v0"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.LONG}).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(DruidExpression.ofColumn((ColumnType)ColumnType.LONG, (String)"cnt"), DruidExpression.ofColumn((ColumnType)ColumnType.LONG, (String)"j0.v0")), JoinType.INNER), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).columns(new String[]{"cnt"}).columnTypes(new ColumnType[]{ColumnType.LONG}).context(queryContext).build()), "_j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeExpression(ColumnType.LONG, "CAST(\"j0.k\", 'LONG')"), DruidExpression.ofColumn((ColumnType)ColumnType.LONG, (String)"_j0.cnt")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{0L}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.JOIN_FILTER_LOCATIONS)
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testInnerJoinCastLeft(Map<String, Object> queryContext) {
        this.testQuery("SELECT foo.m1, l.k, l.v\nFROM foo\nINNER JOIN lookup.lookyloo l ON CAST(foo.m1 AS VARCHAR) = l.k\n", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeExpression("CAST(\"m1\", 'STRING')"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"m1", "j0.k", "j0.v"}).columnTypes(new ColumnType[]{ColumnType.FLOAT, ColumnType.STRING, ColumnType.STRING}).context(queryContext).build()), (List<Object[]>)ImmutableList.of());
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testInnerJoinCastRight(Map<String, Object> queryContext) {
        this.testQuery("SELECT foo.m1, l.k, l.v\nFROM foo\nINNER JOIN lookup.lookyloo l ON foo.m1 = CAST(l.k AS FLOAT)\n", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)new LookupDataSource("lookyloo")).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "CAST(\"k\", 'DOUBLE')", ColumnType.FLOAT)}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).columns(new String[]{"k", "v", "v0"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.FLOAT}).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"m1"), DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"j0.v0")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"m1", "j0.k", "j0.v"}).columnTypes(new ColumnType[]{ColumnType.FLOAT, ColumnType.STRING, ColumnType.STRING}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{Float.valueOf(6.0f), "6", "x6"}));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testInnerJoinMismatchedTypes(Map<String, Object> queryContext) {
        this.testQuery("SELECT foo.m1, l.k, l.v\nFROM foo\nINNER JOIN lookup.lookyloo l ON foo.m1 = l.k\n", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)new LookupDataSource("lookyloo")).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "CAST(\"k\", 'DOUBLE')", ColumnType.FLOAT)}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).columns(new String[]{"k", "v", "v0"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.FLOAT}).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"m1"), DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"j0.v0")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"m1", "j0.k", "j0.v"}).columnTypes(new ColumnType[]{ColumnType.FLOAT, ColumnType.STRING, ColumnType.STRING}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{Float.valueOf(6.0f), "6", "x6"}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.JOIN_FILTER_LOCATIONS)
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testInnerJoinLeftFunction(Map<String, Object> queryContext) {
        this.testQuery("SELECT foo.dim1, foo.dim2, l.k, l.v\nFROM foo\nINNER JOIN lookup.lookyloo l ON SUBSTRING(foo.dim2, 1, 1) = l.k\n", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeExpression("substring(\"dim2\", 0, 1)"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1", "dim2", "j0.k", "j0.v"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", "a", "a", "xa"}, (Object)new Object[]{"1", "a", "a", "xa"}, (Object)new Object[]{"def", "abc", "a", "xa"}));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testInnerJoinRightFunction(Map<String, Object> queryContext) {
        this.testQuery("SELECT foo.dim1, foo.dim2, l.k, l.v\nFROM foo\nINNER JOIN lookup.lookyloo l ON foo.dim2 = SUBSTRING(l.k, 1, 2)\n", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)new LookupDataSource("lookyloo")).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "substring(\"k\", 0, 2)", ColumnType.STRING)}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).columns(new String[]{"k", "v", "v0"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.STRING}).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("j0.v0")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1", "dim2", "j0.k", "j0.v"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", "a", "a", "xa"}, (Object)new Object[]{"1", "a", "a", "xa"}));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testLeftJoinLookupOntoLookupUsingJoinOperator(Map<String, Object> queryContext) {
        this.testQuery("SELECT dim2, l1.v, l2.v\nFROM foo\nLEFT JOIN lookup.lookyloo l1 ON foo.dim2 = l1.k\nLEFT JOIN lookup.lookyloo l2 ON l1.k = l2.k", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.LEFT), (DataSource)new LookupDataSource("lookyloo"), "_j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("j0.k"), CalciteJoinQueryTest.makeColumnExpression("_j0.k")), JoinType.LEFT)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim2", "j0.v", "_j0.v"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.STRING}).context(queryContext).build()), this.sortIfSortBased((List<Object[]>)ImmutableList.of((Object)new Object[]{"a", "xa", "xa"}, (Object)new Object[]{null, null, null}, (Object)new Object[]{"", null, null}, (Object)new Object[]{"a", "xa", "xa"}, (Object)new Object[]{"abc", "xabc", "xabc"}, (Object)new Object[]{null, null, null}), 0));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testLeftJoinThreeLookupsUsingJoinOperator(Map<String, Object> queryContext) {
        this.testQuery("SELECT dim1, dim2, l1.v, l2.v, l3.v\nFROM foo\nLEFT JOIN lookup.lookyloo l1 ON foo.dim1 = l1.k\nLEFT JOIN lookup.lookyloo l2 ON foo.dim2 = l2.k\nLEFT JOIN lookup.lookyloo l3 ON l2.k = l3.k", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim1"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.LEFT), (DataSource)new LookupDataSource("lookyloo"), "_j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("_j0.k")), JoinType.LEFT), (DataSource)new LookupDataSource("lookyloo"), "__j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("_j0.k"), CalciteJoinQueryTest.makeColumnExpression("__j0.k")), JoinType.LEFT)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1", "dim2", "j0.v", "_j0.v", "__j0.v"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING}).context(queryContext).build()), this.sortIfSortBased((List<Object[]>)ImmutableList.of((Object)new Object[]{"", "a", null, "xa", "xa"}, (Object)new Object[]{"10.1", null, null, null, null}, (Object)new Object[]{"2", "", null, null, null}, (Object)new Object[]{"1", "a", null, "xa", "xa"}, (Object)new Object[]{"def", "abc", null, "xabc", "xabc"}, (Object)new Object[]{"abc", null, "xabc", null, null}), 1, 0));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testSelectOnLookupUsingLeftJoinOperator(Map<String, Object> queryContext) {
        this.testQuery("SELECT dim1, lookyloo.*\nFROM foo LEFT JOIN lookup.lookyloo ON foo.dim1 = lookyloo.k\nWHERE lookyloo.v <> 'xxx' OR lookyloo.v IS NULL", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim1"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.LEFT)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteJoinQueryTest.or(new DimFilter[]{CalciteJoinQueryTest.isNull("j0.v"), CalciteJoinQueryTest.not(CalciteJoinQueryTest.equality("j0.v", "xxx", ColumnType.STRING))})).columns(new String[]{"dim1", "j0.k", "j0.v"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.STRING}).context(queryContext).build()), this.sortIfSortBased((List<Object[]>)ImmutableList.of((Object)new Object[]{"", null, null}, (Object)new Object[]{"10.1", null, null}, (Object)new Object[]{"2", null, null}, (Object)new Object[]{"1", null, null}, (Object)new Object[]{"def", null, null}, (Object)new Object[]{"abc", "abc", "xabc"}), 0));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.SLIGHTLY_WORSE_FILTER_PUSHED_TO_JOIN_OPERAND)
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testSelectOnLookupUsingRightJoinOperator(Map<String, Object> queryContext) {
        this.msqIncompatible();
        this.testQuery("SELECT dim1, lookyloo.*\nFROM foo RIGHT JOIN lookup.lookyloo ON foo.dim1 = lookyloo.k\nWHERE lookyloo.v <> 'xxx' OR lookyloo.v IS NULL", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim1"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.RIGHT)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteJoinQueryTest.or(new DimFilter[]{CalciteJoinQueryTest.isNull("j0.v"), CalciteJoinQueryTest.not(CalciteJoinQueryTest.equality("j0.v", "xxx", ColumnType.STRING))})).columns(new String[]{"dim1", "j0.k", "j0.v"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.STRING}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc", "abc", "xabc"}, (Object)new Object[]{null, "6", "x6"}, (Object)new Object[]{null, "a", "xa"}, (Object)new Object[]{null, "nosuchkey", "mysteryvalue"}));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testSelectOnLookupUsingFullJoinOperator(Map<String, Object> queryContext) {
        this.msqIncompatible();
        this.testQuery("SELECT dim1, m1, cnt, lookyloo.*\nFROM foo FULL JOIN lookup.lookyloo ON foo.dim1 = lookyloo.k\nWHERE lookyloo.v <> 'xxx' OR lookyloo.v IS NULL", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim1"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.FULL)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteJoinQueryTest.or(new DimFilter[]{CalciteJoinQueryTest.isNull("j0.v"), CalciteJoinQueryTest.not(CalciteJoinQueryTest.equality("j0.v", "xxx", ColumnType.STRING))})).columns(new String[]{"dim1", "m1", "cnt", "j0.k", "j0.v"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.FLOAT, ColumnType.LONG, ColumnType.STRING, ColumnType.STRING}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", Float.valueOf(1.0f), 1L, null, null}, (Object)new Object[]{"10.1", Float.valueOf(2.0f), 1L, null, null}, (Object)new Object[]{"2", Float.valueOf(3.0f), 1L, null, null}, (Object)new Object[]{"1", Float.valueOf(4.0f), 1L, null, null}, (Object)new Object[]{"def", Float.valueOf(5.0f), 1L, null, null}, (Object)new Object[]{"abc", Float.valueOf(6.0f), 1L, "abc", "xabc"}, (Object)new Object[]{null, null, null, "6", "x6"}, (Object)new Object[]{null, null, null, "a", "xa"}, (Object)new Object[]{null, null, null, "nosuchkey", "mysteryvalue"}));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testInAggregationSubquery(Map<String, Object> queryContext) {
        if (!CalciteJoinQueryTest.isRewriteJoinToFilter(queryContext)) {
            this.cannotVectorize();
        }
        HashMap<String, Object> updatedQueryContext = new HashMap<String, Object>(queryContext);
        updatedQueryContext.put("enableTimeBoundaryPlanning", true);
        HashMap<String, Object> maxTimeQueryContext = new HashMap<String, Object>(queryContext);
        maxTimeQueryContext.put("maxTimeArrayOutputName", "a0");
        this.testQuery("SELECT DISTINCT __time FROM druid.foo WHERE __time IN (SELECT MAX(__time) FROM druid.foo)", (Map<String, Object>)updatedQueryContext, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)Druids.newTimeBoundaryQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).bound("maxTime").context(maxTimeQueryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(DruidExpression.ofColumn((ColumnType)ColumnType.LONG, (String)"__time"), DruidExpression.ofColumn((ColumnType)ColumnType.LONG, (String)"j0.a0")), JoinType.INNER)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("__time", "d0", ColumnType.LONG)})).setContext(QUERY_CONTEXT_DEFAULT).build().withOverriddenContext(queryContext)), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteJoinQueryTest.timestamp("2001-01-03")}));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testNotInAggregationSubquery(Map<String, Object> queryContext) {
        this.cannotVectorize();
        HashMap<String, Object> updatedQueryContext = new HashMap<String, Object>(queryContext);
        updatedQueryContext.put("enableTimeBoundaryPlanning", true);
        HashMap<String, Object> maxTimeQueryContext = new HashMap<String, Object>(queryContext);
        maxTimeQueryContext.put("maxTimeArrayOutputName", "a0");
        this.testQuery("SELECT DISTINCT __time FROM druid.foo WHERE __time NOT IN (SELECT MAX(__time) FROM druid.foo)", (Map<String, Object>)updatedQueryContext, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((Query)Druids.newTimeBoundaryQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).bound("maxTime").context(maxTimeQueryContext).build()).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("_a0"), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("_a1"), CalciteJoinQueryTest.notNull("a0"))}).setContext(queryContext).build()), "j0.", "1", JoinType.INNER), (DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(new AggregatorFactory[]{new LongMaxAggregatorFactory("a0", "__time")}).postAggregators(new PostAggregator[]{CalciteJoinQueryTest.expressionPostAgg("p0", "1", ColumnType.LONG)}).context(QUERY_CONTEXT_DEFAULT).build()), "_j0.", "(\"__time\" == \"_j0.a0\")", JoinType.LEFT)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)CalciteJoinQueryTest.or(new DimFilter[]{CalciteJoinQueryTest.equality("j0._a0", 0L, ColumnType.LONG), CalciteJoinQueryTest.and(new DimFilter[]{CalciteJoinQueryTest.isNull("_j0.p0"), CalciteJoinQueryTest.expressionFilter("(\"j0._a1\" >= \"j0._a0\")")})})).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("__time", "d0", ColumnType.LONG)})).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteJoinQueryTest.timestamp("2000-01-01")}, (Object)new Object[]{CalciteJoinQueryTest.timestamp("2000-01-02")}, (Object)new Object[]{CalciteJoinQueryTest.timestamp("2000-01-03")}, (Object)new Object[]{CalciteJoinQueryTest.timestamp("2001-01-01")}, (Object)new Object[]{CalciteJoinQueryTest.timestamp("2001-01-02")}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.JOIN_FILTER_LOCATIONS)
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testUsingSubqueryWithExtractionFns(Map<String, Object> queryContext) {
        this.cannotVectorize();
        this.testQuery("SELECT dim2, COUNT(*) FROM druid.foo WHERE substring(dim2, 1, 1) IN (SELECT substring(dim1, 1, 1) FROM druid.foo WHERE dim1 <> '')group by dim2", queryContext, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)CalciteJoinQueryTest.not(CalciteJoinQueryTest.equality("dim1", "", ColumnType.STRING))).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new ExtractionDimensionSpec("dim1", "d0", (ExtractionFn)new SubstringDimExtractionFn(0, Integer.valueOf(1)))})).setContext(QUERY_CONTEXT_DEFAULT).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeExpression("substring(\"dim2\", 0, 1)"), CalciteJoinQueryTest.makeColumnExpression("j0.d0")), JoinType.INNER)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a", 2L}, (Object)new Object[]{"abc", 1L}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.EQUIV_PLAN)
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testInnerJoinWithIsNullFilter(Map<String, Object> queryContext) {
        this.testQuery("SELECT dim1, l.v from druid.foo f inner join lookup.lookyloo l on f.dim1 = l.k where f.dim2 is null", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim1"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters(CalciteJoinQueryTest.isNull("dim2")).columns(new String[]{"dim1", "j0.v"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc", "xabc"}));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    @Disabled
    public void testInnerJoinOnMultiValueColumn(Map<String, Object> queryContext) {
        this.cannotVectorize();
        this.testQuery("SELECT dim3, l.v, count(*) from druid.foo f inner join lookup.lookyloo l on f.dim3 = l.k group by 1, 2", queryContext, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim3"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.INNER)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim3", "d0"), new DefaultDimensionSpec("j0.v", "d1")})).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"2", "x2", 1L}));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testLeftJoinOnTwoInlineDataSourcesWithTimeFilter(Map<String, Object> queryContext) {
        this.testQuery("with abc as\n(\n  SELECT dim1, \"__time\", m1 from foo WHERE \"dim1\" = '10.1' AND \"__time\" >= '1999'\n)\nSELECT t1.dim1, t1.\"__time\" from abc as t1 LEFT JOIN abc as t2 on t1.dim1 = t2.dim1 WHERE t1.dim1 = '10.1'\n", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Intervals.utc((long)DateTimes.of((String)"1999-01-01").getMillis(), (long)0x3FFFFFFFFFFFFFFFL))).filters(CalciteJoinQueryTest.equality("dim1", "10.1", ColumnType.STRING)).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "'10.1'", ColumnType.STRING)}).columns((List)ImmutableList.of((Object)"v0", (Object)"__time")).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.LONG}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Intervals.utc((long)DateTimes.of((String)"1999-01-01").getMillis(), (long)0x3FFFFFFFFFFFFFFFL))).filters(CalciteJoinQueryTest.equality("dim1", "10.1", ColumnType.STRING)).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "'10.1'", ColumnType.STRING)}).columns((List)ImmutableList.of((Object)"v0")).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("v0"), CalciteJoinQueryTest.makeColumnExpression("j0.v0")), JoinType.LEFT)).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("_v0", "'10.1'", ColumnType.STRING)}).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("_v0", "'10.1'", ColumnType.STRING)}).columns(new String[]{"_v0", "__time"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.LONG}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"10.1", 946771200000L}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.JOIN_LEFT_DIRECT_ACCESS)
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testLeftJoinOnTwoInlineDataSourcesWithTimeFilter_withLeftDirectAccess(Map<String, Object> queryContext) {
        queryContext = this.withLeftDirectAccessEnabled(queryContext);
        this.testQuery("with abc as\n(\n  SELECT dim1, \"__time\", m1 from foo WHERE \"dim1\" = '10.1' AND \"__time\" >= '1999'\n)\nSELECT t1.dim1, t1.\"__time\" from abc as t1 LEFT JOIN abc as t2 on t1.dim1 = t2.dim1 WHERE t1.dim1 = '10.1'\n", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Intervals.utc((long)DateTimes.of((String)"1999-01-01").getMillis(), (long)0x3FFFFFFFFFFFFFFFL))).filters(CalciteJoinQueryTest.equality("dim1", "10.1", ColumnType.STRING)).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "'10.1'", ColumnType.STRING)}).columns((List)ImmutableList.of((Object)"v0")).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeExpression("'10.1'"), CalciteJoinQueryTest.makeColumnExpression("j0.v0")), JoinType.LEFT, CalciteJoinQueryTest.equality("dim1", "10.1", ColumnType.STRING))).intervals(CalciteJoinQueryTest.querySegmentSpec(Intervals.utc((long)DateTimes.of((String)"1999-01-01").getMillis(), (long)0x3FFFFFFFFFFFFFFFL))).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "'10.1'", ColumnType.STRING)}).columns(new String[]{"v0", "__time"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.LONG}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"10.1", 946771200000L}));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testLeftJoinOnTwoInlineDataSourcesWithOuterWhere(Map<String, Object> queryContext) {
        this.testQuery("with abc as\n(\n  SELECT dim1, \"__time\", m1 from foo WHERE \"dim1\" = '10.1'\n)\nSELECT t1.dim1, t1.\"__time\" from abc as t1 LEFT JOIN abc as t2 on t1.dim1 = t2.dim1 WHERE t1.dim1 = '10.1'\n", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters(CalciteJoinQueryTest.equality("dim1", "10.1", ColumnType.STRING)).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "'10.1'", ColumnType.STRING)}).columns((List)ImmutableList.of((Object)"v0", (Object)"__time")).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.LONG}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters(CalciteJoinQueryTest.equality("dim1", "10.1", ColumnType.STRING)).columns((List)ImmutableList.of((Object)"dim1")).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("v0"), CalciteJoinQueryTest.makeColumnExpression("j0.dim1")), JoinType.LEFT)).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("_v0", "'10.1'", ColumnType.STRING)}).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"_v0", "__time"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.LONG}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"10.1", 946771200000L}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.JOIN_LEFT_DIRECT_ACCESS)
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testLeftJoinOnTwoInlineDataSourcesWithOuterWhere_withLeftDirectAccess(Map<String, Object> queryContext) {
        queryContext = this.withLeftDirectAccessEnabled(queryContext);
        this.testQuery("with abc as\n(\n  SELECT dim1, \"__time\", m1 from foo WHERE \"dim1\" = '10.1'\n)\nSELECT t1.dim1, t1.\"__time\" from abc as t1 LEFT JOIN abc as t2 on t1.dim1 = t2.dim1 WHERE t1.dim1 = '10.1'\n", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters(CalciteJoinQueryTest.equality("dim1", "10.1", ColumnType.STRING)).columns(new String[]{"dim1"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeExpression("'10.1'"), CalciteJoinQueryTest.makeColumnExpression("j0.dim1")), JoinType.LEFT, CalciteJoinQueryTest.equality("dim1", "10.1", ColumnType.STRING))).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "'10.1'", ColumnType.STRING)}).columns(new String[]{"v0", "__time"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.LONG}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"10.1", 946771200000L}));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testLeftJoinOnTwoInlineDataSources(Map<String, Object> queryContext) {
        this.testQuery("with abc as\n(\n  SELECT dim1, \"__time\", m1 from foo WHERE \"dim1\" = '10.1'\n)\nSELECT t1.dim1, t1.\"__time\" from abc as t1 LEFT JOIN abc as t2 on t1.dim1 = t2.dim1\n", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters(CalciteJoinQueryTest.equality("dim1", "10.1", ColumnType.STRING)).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "'10.1'", ColumnType.STRING)}).columns((List)ImmutableList.of((Object)"v0", (Object)"__time")).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.LONG}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters(CalciteJoinQueryTest.equality("dim1", "10.1", ColumnType.STRING)).columns((List)ImmutableList.of((Object)"dim1")).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("v0"), CalciteJoinQueryTest.makeColumnExpression("j0.dim1")), JoinType.LEFT)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("_v0", "'10.1'", ColumnType.STRING)}).columns(new String[]{"_v0", "__time"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.LONG}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"10.1", 946771200000L}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.JOIN_LEFT_DIRECT_ACCESS)
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testLeftJoinOnTwoInlineDataSources_withLeftDirectAccess(Map<String, Object> queryContext) {
        queryContext = this.withLeftDirectAccessEnabled(queryContext);
        this.testQuery("with abc as\n(\n  SELECT dim1, \"__time\", m1 from foo WHERE \"dim1\" = '10.1'\n)\nSELECT t1.dim1, t1.\"__time\" from abc as t1 LEFT JOIN abc as t2 on t1.dim1 = t2.dim1\n", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters(CalciteJoinQueryTest.equality("dim1", "10.1", ColumnType.STRING)).columns((List)ImmutableList.of((Object)"dim1")).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeExpression("'10.1'"), CalciteJoinQueryTest.makeColumnExpression("j0.dim1")), JoinType.LEFT, CalciteJoinQueryTest.equality("dim1", "10.1", ColumnType.STRING))).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "'10.1'", ColumnType.STRING)}).columns(new String[]{"v0", "__time"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.LONG}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"10.1", 946771200000L}));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testInnerJoinOnTwoInlineDataSourcesWithOuterWhere(Map<String, Object> queryContext) {
        Druids.ScanQueryBuilder baseScanBuilder = CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").eternityInterval().filters(CalciteJoinQueryTest.equality("dim1", "10.1", ColumnType.STRING)).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "'10.1'", ColumnType.STRING)}).columns(new String[]{"v0", "__time"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.LONG}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").eternityInterval().filters(CalciteJoinQueryTest.equality("dim1", "10.1", ColumnType.STRING)).columns(new String[]{"dim1"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("v0"), CalciteJoinQueryTest.makeColumnExpression("j0.dim1")), JoinType.INNER)).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("_v0", "'10.1'", ColumnType.STRING)}).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"_v0", "__time"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.LONG}).context(queryContext);
        this.testQuery("with abc as\n(\n  SELECT dim1, \"__time\", m1 from foo WHERE \"dim1\" = '10.1'\n)\nSELECT t1.dim1, t1.\"__time\" from abc as t1 INNER JOIN abc as t2 on t1.dim1 = t2.dim1 WHERE t1.dim1 = '10.1'\n", queryContext, (List<Query<?>>)ImmutableList.of((Object)baseScanBuilder.build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"10.1", 946771200000L}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.JOIN_LEFT_DIRECT_ACCESS)
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testInnerJoinOnTwoInlineDataSourcesWithOuterWhere_withLeftDirectAccess(Map<String, Object> queryContext) {
        queryContext = this.withLeftDirectAccessEnabled(queryContext);
        this.testQuery("with abc as\n(\n  SELECT dim1, \"__time\", m1 from foo WHERE \"dim1\" = '10.1'\n)\nSELECT t1.dim1, t1.\"__time\" from abc as t1 INNER JOIN abc as t2 on t1.dim1 = t2.dim1 WHERE t1.dim1 = '10.1'\n", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters(CalciteJoinQueryTest.equality("dim1", "10.1", ColumnType.STRING)).columns((List)ImmutableList.of((Object)"dim1")).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeExpression("'10.1'"), CalciteJoinQueryTest.makeColumnExpression("j0.dim1")), JoinType.INNER, CalciteJoinQueryTest.equality("dim1", "10.1", ColumnType.STRING))).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "'10.1'", ColumnType.STRING)}).columns(new String[]{"v0", "__time"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.LONG}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"10.1", 946771200000L}));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testInnerJoinOnTwoInlineDataSources(Map<String, Object> queryContext) {
        this.testQuery("with abc as\n(\n  SELECT dim1, \"__time\", m1 from foo WHERE \"dim1\" = '10.1'\n)\nSELECT t1.dim1, t1.\"__time\" from abc as t1 INNER JOIN abc as t2 on t1.dim1 = t2.dim1\n", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters(CalciteJoinQueryTest.equality("dim1", "10.1", ColumnType.STRING)).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "'10.1'", ColumnType.STRING)}).columns((List)ImmutableList.of((Object)"v0", (Object)"__time")).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.LONG}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters(CalciteJoinQueryTest.equality("dim1", "10.1", ColumnType.STRING)).columns((List)ImmutableList.of((Object)"dim1")).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("v0"), CalciteJoinQueryTest.makeColumnExpression("j0.dim1")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("_v0", "'10.1'", ColumnType.STRING)}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.LONG}).columns(new String[]{"_v0", "__time"}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"10.1", 946771200000L}));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.EQUIV_PLAN)
    public void testGroupByOverGroupByOverInnerJoinOnTwoInlineDataSources(Map<String, Object> queryContext) {
        this.cannotVectorize();
        this.testQuery("with abc as\n(\n  SELECT dim1, \"__time\", m1 from foo WHERE \"dim1\" = '10.1'\n)\nSELECT dim1 from (SELECT dim1,__time FROM (SELECT t1.dim1, t1.\"__time\" from abc as t1 INNER JOIN abc as t2 on t1.dim1 = t2.dim1) GROUP BY 1,2) GROUP BY dim1\n", queryContext, (List<Query<?>>)ImmutableList.of((Object)new GroupByQuery.Builder().setDataSource((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters(CalciteJoinQueryTest.equality("dim1", "10.1", ColumnType.STRING)).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "'10.1'", ColumnType.STRING)}).columns((List)ImmutableList.of((Object)"v0", (Object)"__time")).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.LONG}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters(CalciteJoinQueryTest.equality("dim1", "10.1", ColumnType.STRING)).columns((List)ImmutableList.of((Object)"dim1")).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("v0"), CalciteJoinQueryTest.makeColumnExpression("j0.dim1")), JoinType.INNER)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setVirtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("_v0", "'10.1'", ColumnType.STRING)}).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("_v0", "d0", ColumnType.STRING), new DefaultDimensionSpec("__time", "d1", ColumnType.LONG)}).setContext(queryContext).build())).setVirtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "'10.1'", ColumnType.STRING)}).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "_d0", ColumnType.STRING)}).setContext(queryContext).setGranularity(Granularities.ALL).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"10.1"}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.JOIN_LEFT_DIRECT_ACCESS)
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testInnerJoinOnTwoInlineDataSources_withLeftDirectAccess(Map<String, Object> queryContext) {
        queryContext = this.withLeftDirectAccessEnabled(queryContext);
        this.testQuery("with abc as\n(\n  SELECT dim1, \"__time\", m1 from foo WHERE \"dim1\" = '10.1'\n)\nSELECT t1.dim1, t1.\"__time\" from abc as t1 INNER JOIN abc as t2 on t1.dim1 = t2.dim1\n", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters(CalciteJoinQueryTest.equality("dim1", "10.1", ColumnType.STRING)).columns((List)ImmutableList.of((Object)"dim1")).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeExpression("'10.1'"), CalciteJoinQueryTest.makeColumnExpression("j0.dim1")), JoinType.INNER, CalciteJoinQueryTest.equality("dim1", "10.1", ColumnType.STRING))).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "'10.1'", ColumnType.STRING)}).columns(new String[]{"v0", "__time"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.LONG}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"10.1", 946771200000L}));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testJoinOnConstantShouldFail(Map<String, Object> queryContext) {
        this.assertQueryIsUnplannable("SELECT t1.dim1 from foo as t1 LEFT JOIN foo as t2 on t1.dim1 = '10.1'", "SQL is resulting in a join that has unsupported operand types.");
    }

    @Test
    public void testLeftJoinRightTableCanBeEmpty() {
        this.cannotVectorize();
        QueryDataSource rightTable = new QueryDataSource((Query)Druids.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).filters(CalciteJoinQueryTest.equality("m2", "1000", ColumnType.DOUBLE)).columns(new String[]{"dim2"}).columnTypes(new ColumnType[]{ColumnType.STRING}).build());
        this.testQuery("SELECT v1.dim2, count(1) FROM (SELECT * FROM foo where m1 > 2) v1 LEFT OUTER JOIN (  select dim2 from (select * from foo where m2 = 1000)) sm ON v1.dim2 = sm.dim2 group by 1", (List<Query<?>>)ImmutableList.of((Object)new GroupByQuery.Builder().setDataSource((DataSource)JoinDataSource.create((DataSource)new QueryDataSource((Query)Druids.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).filters(CalciteJoinQueryTest.range("m1", ColumnType.LONG, 2L, null, true, false)).columns(new String[]{"dim2"}).columnTypes(new ColumnType[]{ColumnType.STRING}).build()), (DataSource)rightTable, (String)"j0.", (String)"(\"dim2\" == \"j0.dim2\")", (JoinType)JoinType.LEFT, null, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)CalciteTests.createJoinableFactoryWrapper(), (JoinAlgorithm)JoinAlgorithm.BROADCAST)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0", ColumnType.STRING)}).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 1L}, (Object)new Object[]{"", 1L}, (Object)new Object[]{"a", 1L}, (Object)new Object[]{"abc", 1L}));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testLeftJoinSubqueryWithNullKeyFilter(Map<String, Object> queryContext) {
        this.cannotVectorize();
        boolean isJoinFilterRewriteEnabled = queryContext.getOrDefault("enableJoinFilterRewrite", true).toString().equals("true");
        this.testQuery("SELECT dim1, l1.k\nFROM foo\nLEFT JOIN (select k || '' as k from lookup.lookyloo group by 1) l1 ON foo.dim1 = l1.k\nWHERE l1.k IS NOT NULL\n", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((DataSource)new LookupDataSource("lookyloo")).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "concat(\"k\",'')", ColumnType.STRING)}).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0")}).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim1"), CalciteJoinQueryTest.makeColumnExpression("j0.d0")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1", "j0.d0"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc", "abc"}));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.IMPROVED_PLAN)
    public void testLeftJoinSubqueryWithSelectorFilter(Map<String, Object> queryContext) {
        this.cannotVectorize();
        queryContext = QueryContexts.override(queryContext, (Map)ImmutableMap.of((Object)"computeInnerJoinCostAsFilter", (Object)"false"));
        this.testQuery("SELECT dim1, l1.k\nFROM foo\nLEFT JOIN (select k || '' as k from lookup.lookyloo group by 1) l1 ON foo.dim1 = l1.k\nWHERE l1.k = 'abc'\n", (Map<String, Object>)queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((DataSource)new LookupDataSource("lookyloo")).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "concat(\"k\",'')", ColumnType.STRING)}).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0")}).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim1"), CalciteJoinQueryTest.makeColumnExpression("j0.d0")), JoinType.LEFT)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1", "j0.d0"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING}).filters(CalciteJoinQueryTest.equality("j0.d0", "abc", ColumnType.STRING)).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc", "abc"}));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testLeftJoinWithNotNullFilter(Map<String, Object> queryContext) {
        this.testQuery("SELECT s.dim1, t.dim1\nFROM foo as s\nLEFT JOIN foo as t ON s.dim1 = t.dim1 and s.dim1 IS NOT NULL\n", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns((List)ImmutableList.of((Object)"dim1")).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim1"), CalciteJoinQueryTest.makeColumnExpression("j0.dim1")), JoinType.LEFT)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1", "j0.dim1"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING}).context(queryContext).build()), this.sortIfSortBased((List<Object[]>)ImmutableList.of((Object)new Object[]{"", ""}, (Object)new Object[]{"10.1", "10.1"}, (Object)new Object[]{"2", "2"}, (Object)new Object[]{"1", "1"}, (Object)new Object[]{"def", "def"}, (Object)new Object[]{"abc", "abc"}), 0));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testInnerJoin(Map<String, Object> queryContext) {
        this.testQuery("SELECT s.dim1, t.dim1\nFROM foo as s\nINNER JOIN foo as t ON s.dim1 = t.dim1", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns((List)ImmutableList.of((Object)"dim1")).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), "j0.", "(\"dim1\" == \"j0.dim1\")", JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1", "j0.dim1"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING}).context(queryContext).build()), this.sortIfSortBased((List<Object[]>)ImmutableList.of((Object)new Object[]{"", ""}, (Object)new Object[]{"10.1", "10.1"}, (Object)new Object[]{"2", "2"}, (Object)new Object[]{"1", "1"}, (Object)new Object[]{"def", "def"}, (Object)new Object[]{"abc", "abc"}), 0));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testJoinWithExplicitIsNotDistinctFromCondition(Map<String, Object> queryContext) {
        this.testQuery("SELECT s.dim1, t.dim1\nFROM foo as s\nINNER JOIN foo as t ON s.dim1 IS NOT DISTINCT FROM t.dim1", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns((List)ImmutableList.of((Object)"dim1")).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), "j0.", "notdistinctfrom(\"dim1\",\"j0.dim1\")", JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1", "j0.dim1"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING}).context(queryContext).build()), this.sortIfSortBased((List<Object[]>)ImmutableList.of((Object)new Object[]{"", ""}, (Object)new Object[]{"10.1", "10.1"}, (Object)new Object[]{"2", "2"}, (Object)new Object[]{"1", "1"}, (Object)new Object[]{"def", "def"}, (Object)new Object[]{"abc", "abc"}), 0));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.FILTER_PUSHED_DOWN_FROM_JOIN_CAN_BE_MORE)
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testInnerJoinSubqueryWithSelectorFilter(Map<String, Object> queryContext) {
        this.cannotVectorize();
        this.testQuery("SELECT dim1, l1.k FROM foo INNER JOIN (select k || '' as k from lookup.lookyloo group by 1) l1 ON foo.dim1 = l1.k and l1.k = 'abc'", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((DataSource)new LookupDataSource("lookyloo")).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "concat(\"k\",'')", ColumnType.STRING)}).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0")}).build()), "j0.", StringUtils.format((String)"(%s && %s)", (Object[])new Object[]{CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim1"), CalciteJoinQueryTest.makeColumnExpression("j0.d0")), CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeExpression("'abc'"), CalciteJoinQueryTest.makeColumnExpression("j0.d0"))}), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1", "j0.d0"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc", "abc"}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.SLIGHTLY_WORSE_FILTER_PUSHED_TO_JOIN_OPERAND)
    @Test
    public void testSemiJoinWithOuterTimeExtractScan() {
        this.testQuery("SELECT dim1, EXTRACT(MONTH FROM __time) FROM druid.foo\n WHERE dim2 IN (\n   SELECT dim2\n   FROM druid.foo\n   WHERE dim1 = 'def'\n ) AND dim1 <> ''", (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setDimFilter(CalciteJoinQueryTest.equality("dim1", "def", ColumnType.STRING)).setContext(QUERY_CONTEXT_DEFAULT).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("j0.d0")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "timestamp_extract(\"__time\",'MONTH','UTC')", ColumnType.LONG)}).filters((DimFilter)CalciteJoinQueryTest.not(CalciteJoinQueryTest.equality("dim1", "", ColumnType.STRING))).columns(new String[]{"dim1", "v0"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.LONG}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"def", 1L}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.SLIGHTLY_WORSE_FILTER_PUSHED_TO_JOIN_OPERAND)
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testTwoSemiJoinsSimultaneously(Map<String, Object> queryContext) {
        this.cannotVectorize();
        HashMap<String, Object> updatedQueryContext = new HashMap<String, Object>(queryContext);
        updatedQueryContext.put("enableTimeBoundaryPlanning", true);
        HashMap<String, Object> maxTimeQueryContext = new HashMap<String, Object>(queryContext);
        maxTimeQueryContext.put("maxTimeArrayOutputName", "a0");
        this.testQuery("SELECT dim1, COUNT(*) FROM foo\nWHERE dim1 IN ('abc', 'def')AND __time IN (SELECT MAX(__time) FROM foo WHERE cnt = 1)\nAND __time IN (SELECT MAX(__time) FROM foo WHERE cnt <> 2)\nGROUP BY 1", (Map<String, Object>)updatedQueryContext, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)Druids.newTimeBoundaryQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).bound("maxTime").filters(CalciteJoinQueryTest.equality("cnt", 1L, ColumnType.LONG)).context(maxTimeQueryContext).build()), "j0.", "(\"__time\" == \"j0.a0\")", JoinType.INNER), (DataSource)new QueryDataSource((Query)Druids.newTimeBoundaryQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).bound("maxTime").filters((DimFilter)CalciteJoinQueryTest.not(CalciteJoinQueryTest.equality("cnt", 2L, ColumnType.LONG))).context(maxTimeQueryContext).build()), "_j0.", "(\"__time\" == \"_j0.a0\")", JoinType.INNER)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter(CalciteJoinQueryTest.in("dim1", (Collection<String>)ImmutableList.of((Object)"abc", (Object)"def"))).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc", 1L}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.SLIGHTLY_WORSE_FILTER_PUSHED_TO_JOIN_OPERAND)
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testSemiAndAntiJoinSimultaneouslyUsingWhereInSubquery(Map<String, Object> queryContext) {
        this.cannotVectorize();
        HashMap<String, Object> updatedQueryContext = new HashMap<String, Object>(queryContext);
        updatedQueryContext.put("enableTimeBoundaryPlanning", true);
        HashMap<String, Object> minTimeQueryContext = new HashMap<String, Object>(queryContext);
        minTimeQueryContext.put("minTimeArrayOutputName", "a0");
        HashMap<String, Object> maxTimeQueryContext = new HashMap<String, Object>(queryContext);
        maxTimeQueryContext.put("maxTimeArrayOutputName", "a0");
        this.testQuery("SELECT dim1, COUNT(*) FROM foo\nWHERE dim1 IN ('abc', 'def')\nAND __time IN (SELECT MAX(__time) FROM foo)\nAND __time NOT IN (SELECT MIN(__time) FROM foo)\nGROUP BY 1", (Map<String, Object>)updatedQueryContext, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)Druids.newTimeBoundaryQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).bound("maxTime").context(maxTimeQueryContext).build()), "j0.", "(\"__time\" == \"j0.a0\")", JoinType.INNER), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)Druids.newTimeBoundaryQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).bound("minTime").context(minTimeQueryContext).build())).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("_a0"), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("_a1"), CalciteJoinQueryTest.notNull("a0"))}).setContext(QUERY_CONTEXT_DEFAULT).build()), "_j0.", "1", JoinType.INNER), (DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(new AggregatorFactory[]{new LongMinAggregatorFactory("a0", "__time")}).postAggregators(new PostAggregator[]{CalciteJoinQueryTest.expressionPostAgg("p0", "1", ColumnType.LONG)}).context(QUERY_CONTEXT_DEFAULT).build()), "__j0.", "(\"__time\" == \"__j0.a0\")", JoinType.LEFT)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)CalciteJoinQueryTest.and(new DimFilter[]{CalciteJoinQueryTest.in("dim1", (Collection<String>)ImmutableList.of((Object)"abc", (Object)"def")), CalciteJoinQueryTest.or(new DimFilter[]{CalciteJoinQueryTest.equality("_j0._a0", 0L, ColumnType.LONG), CalciteJoinQueryTest.and(new DimFilter[]{CalciteJoinQueryTest.isNull("__j0.p0"), CalciteJoinQueryTest.expressionFilter("(\"_j0._a1\" >= \"_j0._a0\")")})})})).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc", 1L}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.SLIGHTLY_WORSE_FILTER_PUSHED_TO_JOIN_OPERAND)
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testSemiAndAntiJoinSimultaneouslyUsingExplicitJoins(Map<String, Object> queryContext) {
        this.cannotVectorize();
        HashMap<String, Object> updatedQueryContext = new HashMap<String, Object>(queryContext);
        updatedQueryContext.put("enableTimeBoundaryPlanning", true);
        HashMap<String, Object> minTimeQueryContext = new HashMap<String, Object>(queryContext);
        minTimeQueryContext.put("minTimeArrayOutputName", "a0");
        HashMap<String, Object> maxTimeQueryContext = new HashMap<String, Object>(queryContext);
        maxTimeQueryContext.put("maxTimeArrayOutputName", "a0");
        this.testQuery("SELECT dim1, COUNT(*) FROM\nfoo\nINNER JOIN (SELECT MAX(__time) t FROM foo) t0 on t0.t = foo.__time\nLEFT JOIN (SELECT MIN(__time) t FROM foo) t1 on t1.t = foo.__time\nWHERE dim1 IN ('abc', 'def') AND t1.t is null\nGROUP BY 1", (Map<String, Object>)updatedQueryContext, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)Druids.newTimeBoundaryQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).bound("maxTime").context(maxTimeQueryContext).build()), "j0.", "(\"__time\" == \"j0.a0\")", JoinType.INNER), (DataSource)new QueryDataSource((Query)Druids.newTimeBoundaryQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).bound("minTime").context(minTimeQueryContext).build()), "_j0.", "(\"__time\" == \"_j0.a0\")", JoinType.LEFT)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)CalciteJoinQueryTest.and(CalciteJoinQueryTest.in("dim1", (Collection<String>)ImmutableList.of((Object)"abc", (Object)"def")), CalciteJoinQueryTest.isNull("_j0.a0"))).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0", ColumnType.STRING)})).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc", 1L}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.SLIGHTLY_WORSE_FILTER_PUSHED_TO_JOIN_OPERAND)
    @Test
    public void testSemiJoinWithOuterTimeExtractAggregateWithOrderBy() {
        this.cannotVectorizeUnlessFallback();
        this.testQuery("SELECT COUNT(DISTINCT dim1), EXTRACT(MONTH FROM __time) FROM druid.foo\n WHERE dim2 IN (\n   SELECT dim2\n   FROM druid.foo\n   WHERE dim1 = 'def'\n ) AND dim1 <> ''GROUP BY EXTRACT(MONTH FROM __time)\nORDER BY EXTRACT(MONTH FROM __time)", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0")})).setDimFilter(CalciteJoinQueryTest.equality("dim1", "def", ColumnType.STRING)).setContext(QUERY_CONTEXT_DEFAULT).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("j0.d0")), JoinType.INNER)).setVirtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "timestamp_extract(\"__time\",'MONTH','UTC')", ColumnType.LONG)}).setDimFilter((DimFilter)CalciteJoinQueryTest.not(CalciteJoinQueryTest.equality("dim1", "", ColumnType.STRING))).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)})).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CardinalityAggregatorFactory("a0", null, (List)ImmutableList.of((Object)new DefaultDimensionSpec("dim1", "dim1", ColumnType.STRING)), false, true)})).setLimitSpec((LimitSpec)(this.queryFramework().engine().featureAvailable(EngineFeature.GROUPBY_IMPLICITLY_SORTS) ? NoopLimitSpec.instance() : new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)), Integer.valueOf(Integer.MAX_VALUE)))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L, 1L}));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testJoinOnMultiValuedColumnShouldThrowException(Map<String, Object> queryContext) {
        this.msqIncompatible();
        Assertions.assertThrows(QueryException.class, () -> {
            String query = "SELECT dim3, l.v from druid.foo f inner join lookup.lookyloo l on f.dim3 = l.k\n";
            this.testQuery("SELECT dim3, l.v from druid.foo f inner join lookup.lookyloo l on f.dim3 = l.k\n", queryContext, (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
        });
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.UNION_ALL_QUERY)
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testUnionAllTwoQueriesLeftQueryIsJoin(Map<String, Object> queryContext) {
        this.msqIncompatible();
        if (!CalciteJoinQueryTest.isRewriteJoinToFilter(queryContext)) {
            this.cannotVectorize();
        }
        this.testQuery("(SELECT COUNT(*) FROM foo INNER JOIN lookup.lookyloo ON foo.dim1 = lookyloo.k)  UNION ALL SELECT SUM(cnt) FROM foo", queryContext, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim1"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build().withOverriddenContext(queryContext), (Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).context(QUERY_CONTEXT_DEFAULT).build().withOverriddenContext(queryContext)), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}, (Object)new Object[]{6L}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.UNION_ALL_QUERY)
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testUnionAllTwoQueriesRightQueryIsJoin(Map<String, Object> queryContext) {
        this.msqIncompatible();
        if (!CalciteJoinQueryTest.isRewriteJoinToFilter(queryContext)) {
            this.cannotVectorize();
        }
        this.testQuery("(SELECT SUM(cnt) FROM foo UNION ALL SELECT COUNT(*) FROM foo INNER JOIN lookup.lookyloo ON foo.dim1 = lookyloo.k) ", queryContext, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).context(QUERY_CONTEXT_DEFAULT).build().withOverriddenContext(queryContext), (Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim1"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build().withOverriddenContext(queryContext)), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}, (Object)new Object[]{1L}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.UNION_ALL_QUERY)
    @Test
    public void testUnionAllTwoQueriesBothQueriesAreJoin() {
        this.msqIncompatible();
        this.cannotVectorize();
        this.testQuery("(SELECT COUNT(*) FROM foo LEFT JOIN lookup.lookyloo ON foo.dim1 = lookyloo.k                                UNION ALL                                       SELECT COUNT(*) FROM foo INNER JOIN lookup.lookyloo ON foo.dim1 = lookyloo.k) ", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim1"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.LEFT)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build(), (Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim1"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}, (Object)new Object[]{1L}));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testTopNFilterJoin(Map<String, Object> queryContext) {
        if (!CalciteJoinQueryTest.isRewriteJoinToFilter(queryContext)) {
            this.cannotVectorize();
        }
        this.testQuery("SELECT t1.dim1, SUM(t1.cnt)\nFROM druid.foo t1\n  INNER JOIN (\n  SELECT\n    SUM(cnt) AS sum_cnt,\n    dim2\n  FROM druid.foo\n  GROUP BY dim2\n  ORDER BY 1 DESC\n  LIMIT 2\n) t2 ON (t1.dim2 = t2.dim2)\nGROUP BY t1.dim1\nORDER BY 1\n", queryContext, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)new TopNQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim2", "d0")).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")}).metric("a0").threshold(2).context(QUERY_CONTEXT_DEFAULT).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("j0.d0")), JoinType.INNER)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)NoopLimitSpec.instance()).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", 1L}, (Object)new Object[]{"1", 1L}));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testTopNFilterJoinWithProjection(Map<String, Object> queryContext) {
        this.cannotVectorize();
        this.testQuery("SELECT SUBSTRING(t1.dim1, 1, 10), SUM(t1.cnt)\nFROM druid.foo t1\n  INNER JOIN (\n  SELECT\n    SUM(cnt) AS sum_cnt,\n    dim2\n  FROM druid.foo\n  GROUP BY dim2\n  ORDER BY 1 DESC\n  LIMIT 2\n) t2 ON (t1.dim2 = t2.dim2)\nGROUP BY SUBSTRING(t1.dim1, 1, 10)", queryContext, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)new TopNQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim2", "d0")).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")}).metric("a0").threshold(2).context(QUERY_CONTEXT_DEFAULT).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("j0.d0")), JoinType.INNER)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new ExtractionDimensionSpec("dim1", "d0", ColumnType.STRING, (ExtractionFn)new SubstringDimExtractionFn(0, Integer.valueOf(10)))})).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, 1L}, (Object)new Object[]{"1", 1L}));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    @Disabled(value="Stopped working after the ability to join on subqueries was added to DruidJoinRule")
    public void testRemovableLeftJoin(Map<String, Object> queryContext) {
        this.testQuery("SELECT t1.dim1, SUM(t1.cnt)\nFROM druid.foo t1\n  LEFT JOIN (\n  SELECT\n    SUM(cnt) AS sum_cnt,\n    dim2\n  FROM druid.foo\n  GROUP BY dim2\n  ORDER BY 1 DESC\n  LIMIT 2\n) t2 ON (t1.dim2 = t2.dim2)\nGROUP BY t1.dim1\nORDER BY 1\n", queryContext, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)NoopLimitSpec.instance()).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"", 1L}, (Object)new Object[]{"1", 1L}, (Object)new Object[]{"10.1", 1L}, (Object)new Object[]{"2", 1L}, (Object)new Object[]{"abc", 1L}, (Object)new Object[]{"def", 1L}));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testCountDistinctOfLookupUsingJoinOperator(Map<String, Object> queryContext) {
        this.cannotVectorize();
        this.testQuery("SELECT COUNT(DISTINCT lookyloo.v)\nFROM foo LEFT JOIN lookup.lookyloo ON foo.dim1 = lookyloo.k", queryContext, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new LookupDataSource("lookyloo"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim1"), CalciteJoinQueryTest.makeColumnExpression("j0.k")), JoinType.LEFT)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CardinalityAggregatorFactory("a0", null, (List)ImmutableList.of((Object)DefaultDimensionSpec.of((String)"j0.v")), false, true)})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testJoinWithNonEquiCondition(Map<String, Object> queryContext) {
        this.testQuery("SELECT x.m1, y.m1 FROM foo x INNER JOIN foo y ON x.m1 > y.m1", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"m1"}).columnTypes(new ColumnType[]{ColumnType.FLOAT}).context(queryContext).build()), "j0.", "1", JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteJoinQueryTest.expressionFilter("(\"m1\" > \"j0.m1\")")).columns(new String[]{"m1", "j0.m1"}).columnTypes(new ColumnType[]{ColumnType.FLOAT, ColumnType.FLOAT}).context(queryContext).build()), this.sortIfSortBased((List<Object[]>)ImmutableList.of((Object)new Object[]{Float.valueOf(2.0f), Float.valueOf(1.0f)}, (Object)new Object[]{Float.valueOf(3.0f), Float.valueOf(1.0f)}, (Object)new Object[]{Float.valueOf(3.0f), Float.valueOf(2.0f)}, (Object)new Object[]{Float.valueOf(4.0f), Float.valueOf(1.0f)}, (Object)new Object[]{Float.valueOf(4.0f), Float.valueOf(2.0f)}, (Object)new Object[]{Float.valueOf(4.0f), Float.valueOf(3.0f)}, (Object)new Object[]{Float.valueOf(5.0f), Float.valueOf(1.0f)}, (Object)new Object[]{Float.valueOf(5.0f), Float.valueOf(2.0f)}, (Object)new Object[]{Float.valueOf(5.0f), Float.valueOf(3.0f)}, (Object)new Object[]{Float.valueOf(5.0f), Float.valueOf(4.0f)}, (Object)new Object[]{Float.valueOf(6.0f), Float.valueOf(1.0f)}, (Object)new Object[]{Float.valueOf(6.0f), Float.valueOf(2.0f)}, (Object[])new Object[][]{{Float.valueOf(6.0f), Float.valueOf(3.0f)}, {Float.valueOf(6.0f), Float.valueOf(4.0f)}, {Float.valueOf(6.0f), Float.valueOf(5.0f)}}), 1, 0));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testJoinWithEquiAndNonEquiCondition(Map<String, Object> queryContext) {
        this.testQuery("SELECT x.m1, y.m1 FROM foo x INNER JOIN foo y ON x.m1 = y.m1 AND x.m1 + y.m1 = 6.0", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"m1"}).columnTypes(new ColumnType[]{ColumnType.FLOAT}).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("m1"), CalciteJoinQueryTest.makeColumnExpression("j0.m1")), JoinType.INNER)).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "(\"m1\" + \"j0.m1\")", ColumnType.DOUBLE)}).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters(CalciteJoinQueryTest.equality("v0", 6.0, ColumnType.DOUBLE)).columns(new String[]{"m1", "j0.m1"}).columnTypes(new ColumnType[]{ColumnType.FLOAT, ColumnType.FLOAT}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{Float.valueOf(3.0f), Float.valueOf(3.0f)}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.SLIGHTLY_WORSE_FILTER_PUSHED_TO_JOIN_OPERAND)
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testUsingSubqueryAsPartOfAndFilter(Map<String, Object> queryContext) {
        if (!CalciteJoinQueryTest.isRewriteJoinToFilter(queryContext)) {
            this.cannotVectorize();
        }
        this.testQuery("SELECT dim1, dim2, COUNT(*) FROM druid.foo\nWHERE dim2 IN (SELECT dim1 FROM druid.foo WHERE dim1 <> '')\nAND dim1 <> 'xxx'\ngroup by dim1, dim2 ORDER BY dim2", queryContext, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)CalciteJoinQueryTest.not(CalciteJoinQueryTest.equality("dim1", "", ColumnType.STRING))).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setContext(QUERY_CONTEXT_DEFAULT).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("j0.d0")), JoinType.INNER)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)CalciteJoinQueryTest.not(CalciteJoinQueryTest.equality("dim1", "xxx", ColumnType.STRING))).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("dim2", "d1")})).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d1", OrderByColumnSpec.Direction.ASCENDING)), Integer.valueOf(Integer.MAX_VALUE))).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"def", "abc", 1L}));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testUsingSubqueryAsPartOfOrFilter(Map<String, Object> queryContext) {
        this.cannotVectorize();
        this.testQuery("SELECT dim1, dim2, COUNT(*) FROM druid.foo\nWHERE dim1 = 'xxx' OR dim2 IN (SELECT dim1 FROM druid.foo WHERE dim1 LIKE '%bc')\ngroup by dim1, dim2 ORDER BY dim2", queryContext, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)new LikeDimFilter("dim1", "%bc", null, null)).granularity(Granularities.ALL).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).context(QUERY_CONTEXT_DEFAULT).build()), "j0.", "1", JoinType.INNER), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)new LikeDimFilter("dim1", "%bc", null, null)).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setPostAggregatorSpecs(new PostAggregator[]{CalciteJoinQueryTest.expressionPostAgg("a0", "1", ColumnType.LONG)}).setContext(queryContext).build()), "_j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim2"), CalciteJoinQueryTest.makeColumnExpression("_j0.d0")), JoinType.LEFT)).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimFilter((DimFilter)CalciteJoinQueryTest.or(new DimFilter[]{CalciteJoinQueryTest.equality("dim1", "xxx", ColumnType.STRING), CalciteJoinQueryTest.and(new DimFilter[]{CalciteJoinQueryTest.not(CalciteJoinQueryTest.equality("j0.a0", 0L, ColumnType.LONG)), CalciteJoinQueryTest.notNull("_j0.a0"), CalciteJoinQueryTest.notNull("dim2")})})).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0"), new DefaultDimensionSpec("dim2", "d1")})).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d1", OrderByColumnSpec.Direction.ASCENDING)), Integer.valueOf(Integer.MAX_VALUE))).setContext(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"def", "abc", 1L}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.SCAN_QUERY_ON_FILTERED_DS_DOING_FILTERING)
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testNestedGroupByOnInlineDataSourceWithFilter(Map<String, Object> queryContext) {
        this.cannotVectorize();
        this.testQuery("with abc as(  SELECT dim1, m2 from druid.foo where \"__time\" >= '2001-01-02'), def as(  SELECT t1.dim1, SUM(t2.m2) as \"metricSum\"   from abc as t1 inner join abc as t2 on t1.dim1 = t2.dim1  where t1.dim1='def'  group by 1)SELECT count(*) from def", queryContext, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Intervals.of((String)"2001-01-02T00:00:00.000Z/146140482-04-24T15:36:27.903Z"))).columns(new String[]{"dim1"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Intervals.of((String)"2001-01-02T00:00:00.000Z/146140482-04-24T15:36:27.903Z"))).columns(new String[]{"dim1", "m2"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.DOUBLE}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim1"), CalciteJoinQueryTest.makeColumnExpression("j0.dim1")), JoinType.INNER)).setGranularity(Granularities.ALL).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setDimFilter(CalciteJoinQueryTest.equality("dim1", "def", ColumnType.STRING)).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0")})).setVirtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "'def'", ColumnType.STRING)}).build()).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setGranularity(Granularities.ALL).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testGroupByJoinAsNativeQueryWithUnoptimizedFilter(Map<String, Object> queryContext) {
        GroupByQuery query = GroupByQuery.builder().setDataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Intervals.of((String)"2001-01-02T00:00:00.000Z/146140482-04-24T15:36:27.903Z"))).columns(new String[]{"dim1"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Intervals.of((String)"2001-01-02T00:00:00.000Z/146140482-04-24T15:36:27.903Z"))).columns(new String[]{"dim1", "m2"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.LONG}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim1"), CalciteJoinQueryTest.makeColumnExpression("j0.dim1")), JoinType.INNER)).setGranularity(Granularities.ALL).setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setDimFilter(CalciteJoinQueryTest.in("dim1", Collections.singletonList("def"))).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0")})).setVirtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "'def'", ColumnType.STRING)}).build();
        QueryLifecycle ql = this.queryFramework().queryLifecycle();
        Sequence seq = ql.runSimple((Query)query, CalciteTests.SUPER_USER_AUTH_RESULT, AuthorizationResult.ALLOW_NO_RESTRICTION).getResults();
        List results = seq.toList();
        Assert.assertEquals((Object)ImmutableList.of((Object)ResultRow.of((Object[])new Object[]{"def"})), (Object)results);
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testCountOnSemiJoinSingleColumn(Map<String, Object> queryContext) {
        this.testQuery("SELECT dim1 FROM foo WHERE dim1 IN (SELECT dim1 FROM foo WHERE dim1 = '10.1')\n", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setDimFilter(CalciteJoinQueryTest.equality("dim1", "10.1", ColumnType.STRING)).setGranularity(Granularities.ALL).setDimensions(CalciteJoinQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setContext(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim1"), CalciteJoinQueryTest.makeColumnExpression("j0.d0")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "'10.1'", ColumnType.STRING)}).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.STRING}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"10.1"}));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testJoinOnRestrictedBroadcast(Map<String, Object> queryContext) {
        String sql = "SELECT druid.restrictedBroadcastDatasource_m1_is_6.dim4, COUNT(*)\nFROM druid.numfoo\nINNER JOIN druid.restrictedBroadcastDatasource_m1_is_6 ON numfoo.dim4 = restrictedBroadcastDatasource_m1_is_6.dim4\nGROUP BY 1 ORDER BY 2 LIMIT 4";
        this.testQuery(PLANNER_CONFIG_DEFAULT, sql, CalciteTests.SUPER_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("numfoo"), (DataSource)RestrictedDataSource.create((DataSource)new GlobalTableDataSource("restrictedBroadcastDatasource_m1_is_6"), (Policy)CalciteTests.POLICY_NO_RESTRICTION_SUPERUSER), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim4"), CalciteJoinQueryTest.makeColumnExpression("j0.dim4")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).dimension((DimensionSpec)new DefaultDimensionSpec("j0.dim4", "d0", ColumnType.STRING)).threshold(4).aggregators(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(queryContext).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new NumericTopNMetricSpec("a0"))).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a", 9L}, (Object)new Object[]{"b", 9L}));
        Exception e = (Exception)Assert.assertThrows(Exception.class, () -> this.testQuery(PLANNER_CONFIG_DEFAULT, sql, CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of()));
        Assert.assertTrue((boolean)e.getMessage().contains("Restricted data source [GlobalTableDataSource{name='restrictedBroadcastDatasource_m1_is_6'}] with policy [RowFilterPolicy{rowFilter=m1 = 6 (LONG)}] is not supported"));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.EQUIV_PLAN)
    public void testTopNOnStringWithNonSortedOrUniqueDictionary(Map<String, Object> queryContext) {
        this.testQuery("SELECT druid.broadcast.dim4, COUNT(*)\nFROM druid.numfoo\nINNER JOIN druid.broadcast ON numfoo.dim4 = broadcast.dim4\nGROUP BY 1 ORDER BY 2 LIMIT 4", queryContext, (List<Query<?>>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("numfoo"), (DataSource)new GlobalTableDataSource("broadcast"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim4"), CalciteJoinQueryTest.makeColumnExpression("j0.dim4")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).dimension((DimensionSpec)new DefaultDimensionSpec("j0.dim4", "d0", ColumnType.STRING)).threshold(4).aggregators(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(queryContext).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new NumericTopNMetricSpec("a0"))).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a", 9L}, (Object)new Object[]{"b", 9L}));
    }

    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.EQUIV_PLAN)
    public void testTopNOnStringWithNonSortedOrUniqueDictionaryOrderByDim(Map<String, Object> queryContext) {
        Map contextWithLexicographicTopN = QueryContexts.override(queryContext, (String)"useLexicographicTopN", (Object)true);
        this.testQuery("SELECT druid.broadcast.dim4, COUNT(*)\nFROM druid.numfoo\nINNER JOIN druid.broadcast ON numfoo.dim4 = broadcast.dim4\nGROUP BY 1 ORDER BY 1 DESC LIMIT 4", (Map<String, Object>)contextWithLexicographicTopN, (List<Query<?>>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("numfoo"), (DataSource)new GlobalTableDataSource("broadcast"), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("dim4"), CalciteJoinQueryTest.makeColumnExpression("j0.dim4")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).dimension((DimensionSpec)new DefaultDimensionSpec("j0.dim4", "d0", ColumnType.STRING)).threshold(4).aggregators(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(contextWithLexicographicTopN).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.LEXICOGRAPHIC))).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"b", 9L}, (Object)new Object[]{"a", 9L}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.SLIGHTLY_WORSE_FILTER_PUSHED_TO_JOIN_OPERAND)
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testVirtualColumnOnMVFilterJoinExpression(Map<String, Object> queryContext) {
        this.msqIncompatible();
        this.testQuery("SELECT foo1.dim3, foo2.dim3 FROM druid.numfoo as foo1 INNER JOIN druid.numfoo as foo2 ON MV_FILTER_ONLY(foo1.dim3, ARRAY['a']) = MV_FILTER_ONLY(foo2.dim3, ARRAY['a'])\n", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("numfoo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteJoinQueryTest.querySegmentSpec(Intervals.of((String)"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z"))).virtualColumns(new VirtualColumn[]{new ListFilteredVirtualColumn("v0", (DimensionSpec)new DefaultDimensionSpec("dim3", "dim3", ColumnType.STRING), (Set)ImmutableSet.of((Object)"a"), Boolean.valueOf(true))}).columns(new String[]{"dim3", "v0"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("v0"), CalciteJoinQueryTest.makeColumnExpression("j0.v0")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{new ListFilteredVirtualColumn("v0", (DimensionSpec)new DefaultDimensionSpec("dim3", "dim3", ColumnType.STRING), (Set)ImmutableSet.of((Object)"a"), Boolean.valueOf(true))}).columns(new String[]{"dim3", "j0.dim3"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\"]", "[\"a\",\"b\"]"}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.DEFINETLY_WORSE_PLAN)
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testVirtualColumnOnMVFilterMultiJoinExpression(Map<String, Object> queryContext) {
        this.msqIncompatible();
        this.testQuery("SELECT foo1.dim3, foo2.dim3 FROM druid.numfoo as foo1 INNER JOIN (SELECT foo3.dim3 FROM druid.numfoo as foo3 INNER JOIN druid.numfoo as foo4    ON MV_FILTER_ONLY(foo3.dim3, ARRAY['a']) = MV_FILTER_ONLY(foo4.dim3, ARRAY['a'])) as foo2 ON MV_FILTER_ONLY(foo1.dim3, ARRAY['a']) = MV_FILTER_ONLY(foo2.dim3, ARRAY['a'])\n", queryContext, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("numfoo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("numfoo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteJoinQueryTest.querySegmentSpec(Intervals.of((String)"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z"))).virtualColumns(new VirtualColumn[]{new ListFilteredVirtualColumn("v0", (DimensionSpec)new DefaultDimensionSpec("dim3", "dim3", ColumnType.STRING), (Set)ImmutableSet.of((Object)"a"), Boolean.valueOf(true))}).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("v0"), CalciteJoinQueryTest.makeColumnExpression("j0.v0")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{new ListFilteredVirtualColumn("v0", (DimensionSpec)new DefaultDimensionSpec("dim3", "dim3", ColumnType.STRING), (Set)ImmutableSet.of((Object)"a"), Boolean.valueOf(true))}).columns(new String[]{"dim3", "v0"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING}).context(queryContext).build()), "_j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("v0"), CalciteJoinQueryTest.makeColumnExpression("_j0.v0")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{new ListFilteredVirtualColumn("v0", (DimensionSpec)new DefaultDimensionSpec("dim3", "dim3", ColumnType.STRING), (Set)ImmutableSet.of((Object)"a"), Boolean.valueOf(true))}).columns(new String[]{"dim3", "_j0.dim3"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\"]", "[\"a\",\"b\"]"}));
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.SLIGHTLY_WORSE_FILTER_PUSHED_TO_JOIN_OPERAND)
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testInnerJoinWithFilterPushdownAndManyFiltersEmptyResults(Map<String, Object> queryContext) {
        ScanQuery query = CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)new TableDataSource("foo")).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).columns(new String[]{"m1"}).columnTypes(new ColumnType[]{ColumnType.FLOAT}).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"m1"), DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"j0.m1")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"m1", "j0.m1"}).columnTypes(new ColumnType[]{ColumnType.FLOAT, ColumnType.FLOAT}).filters((DimFilter)CalciteJoinQueryTest.or(new DimFilter[]{CalciteJoinQueryTest.and(CalciteJoinQueryTest.equality("dim2", "D", ColumnType.STRING), CalciteJoinQueryTest.in("dim1", (Collection<String>)ImmutableList.of((Object)"A", (Object)"C"))), CalciteJoinQueryTest.and(CalciteJoinQueryTest.equality("dim2", "C", ColumnType.STRING), CalciteJoinQueryTest.in("dim1", (Collection<String>)ImmutableList.of((Object)"A", (Object)"B"))), CalciteJoinQueryTest.and(CalciteJoinQueryTest.equality("dim2", "E", ColumnType.STRING), CalciteJoinQueryTest.in("dim1", (Collection<String>)ImmutableList.of((Object)"C", (Object)"H"))), CalciteJoinQueryTest.and(CalciteJoinQueryTest.equality("dim2", "Q", ColumnType.STRING), CalciteJoinQueryTest.in("dim1", (Collection<String>)ImmutableList.of((Object)"P", (Object)"S"))), CalciteJoinQueryTest.and(CalciteJoinQueryTest.equality("dim1", "A", ColumnType.STRING), CalciteJoinQueryTest.equality("dim2", "B", ColumnType.STRING)), CalciteJoinQueryTest.and(CalciteJoinQueryTest.equality("dim1", "D", ColumnType.STRING), CalciteJoinQueryTest.equality("dim2", "H", ColumnType.STRING)), CalciteJoinQueryTest.and(CalciteJoinQueryTest.equality("dim1", "I", ColumnType.STRING), CalciteJoinQueryTest.equality("dim2", "J", ColumnType.STRING)), CalciteJoinQueryTest.and(CalciteJoinQueryTest.equality("dim1", "I", ColumnType.STRING), CalciteJoinQueryTest.equality("dim2", "K", ColumnType.STRING)), CalciteJoinQueryTest.and(CalciteJoinQueryTest.equality("dim1", "J", ColumnType.STRING), CalciteJoinQueryTest.equality("dim2", "I", ColumnType.STRING)), CalciteJoinQueryTest.and(CalciteJoinQueryTest.equality("dim1", "Q", ColumnType.STRING), CalciteJoinQueryTest.equality("dim2", "R", ColumnType.STRING)), CalciteJoinQueryTest.and(CalciteJoinQueryTest.equality("dim1", "Q", ColumnType.STRING), CalciteJoinQueryTest.equality("dim2", "S", ColumnType.STRING)), CalciteJoinQueryTest.and(CalciteJoinQueryTest.equality("dim1", "X", ColumnType.STRING), CalciteJoinQueryTest.equality("dim2", "Y", ColumnType.STRING)), CalciteJoinQueryTest.and(CalciteJoinQueryTest.equality("dim1", "Z", ColumnType.STRING), CalciteJoinQueryTest.equality("dim2", "U", ColumnType.STRING)), CalciteJoinQueryTest.and(CalciteJoinQueryTest.equality("dim1", "U", ColumnType.STRING), CalciteJoinQueryTest.equality("dim2", "Z", ColumnType.STRING)), CalciteJoinQueryTest.and(CalciteJoinQueryTest.equality("dim1", "X", ColumnType.STRING), CalciteJoinQueryTest.equality("dim2", "A", ColumnType.STRING))})).context(queryContext).build();
        Assert.assertTrue((String)"filter pushdown must be enabled", (boolean)query.context().getEnableJoinFilterPushDown());
        this.testQuery("SELECT f1.m1, f2.m1\nFROM foo f1\nINNER JOIN foo f2 ON f1.m1 = f2.m1 where (f1.dim1, f1.dim2) in (('A', 'B'), ('C', 'D'), ('A', 'C'), ('C', 'E'), ('D', 'H'), ('A', 'D'), ('B', 'C'), \n('H', 'E'), ('I', 'J'), ('I', 'K'), ('J', 'I'), ('Q', 'R'), ('Q', 'S'), ('S', 'Q'), ('X', 'Y'), ('Z', 'U'), ('U', 'Z'), ('P', 'Q'), ('X', 'A'))\n", queryContext, (List<Query<?>>)ImmutableList.of((Object)query), (List<Object[]>)ImmutableList.of());
    }

    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.SLIGHTLY_WORSE_FILTER_PUSHED_TO_JOIN_OPERAND)
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testInnerJoinWithFilterPushdownAndManyFiltersNonEmptyResults(Map<String, Object> queryContext) {
        ScanQuery query = CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)new TableDataSource("foo")).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).columns(new String[]{"m1"}).columnTypes(new ColumnType[]{ColumnType.FLOAT}).context(queryContext).build()), "j0.", CalciteJoinQueryTest.equalsCondition(DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"m1"), DruidExpression.ofColumn((ColumnType)ColumnType.FLOAT, (String)"j0.m1")), JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"m1", "j0.m1"}).columnTypes(new ColumnType[]{ColumnType.FLOAT, ColumnType.FLOAT}).filters((DimFilter)CalciteJoinQueryTest.or(new DimFilter[]{CalciteJoinQueryTest.and(CalciteJoinQueryTest.equality("dim2", "D", ColumnType.STRING), CalciteJoinQueryTest.in("dim1", (Collection<String>)ImmutableList.of((Object)"A", (Object)"C"))), CalciteJoinQueryTest.and(CalciteJoinQueryTest.equality("dim2", "C", ColumnType.STRING), CalciteJoinQueryTest.in("dim1", (Collection<String>)ImmutableList.of((Object)"A", (Object)"B"))), CalciteJoinQueryTest.and(CalciteJoinQueryTest.equality("dim2", "E", ColumnType.STRING), CalciteJoinQueryTest.in("dim1", (Collection<String>)ImmutableList.of((Object)"C", (Object)"H"))), CalciteJoinQueryTest.and(CalciteJoinQueryTest.equality("dim2", "Q", ColumnType.STRING), CalciteJoinQueryTest.in("dim1", (Collection<String>)ImmutableList.of((Object)"P", (Object)"S"))), CalciteJoinQueryTest.and(CalciteJoinQueryTest.equality("dim1", "1", ColumnType.STRING), CalciteJoinQueryTest.equality("dim2", "a", ColumnType.STRING)), CalciteJoinQueryTest.and(CalciteJoinQueryTest.equality("dim1", "D", ColumnType.STRING), CalciteJoinQueryTest.equality("dim2", "H", ColumnType.STRING)), CalciteJoinQueryTest.and(CalciteJoinQueryTest.equality("dim1", "I", ColumnType.STRING), CalciteJoinQueryTest.equality("dim2", "J", ColumnType.STRING)), CalciteJoinQueryTest.and(CalciteJoinQueryTest.equality("dim1", "I", ColumnType.STRING), CalciteJoinQueryTest.equality("dim2", "K", ColumnType.STRING)), CalciteJoinQueryTest.and(CalciteJoinQueryTest.equality("dim1", "J", ColumnType.STRING), CalciteJoinQueryTest.equality("dim2", "I", ColumnType.STRING)), CalciteJoinQueryTest.and(CalciteJoinQueryTest.equality("dim1", "Q", ColumnType.STRING), CalciteJoinQueryTest.equality("dim2", "R", ColumnType.STRING)), CalciteJoinQueryTest.and(CalciteJoinQueryTest.equality("dim1", "Q", ColumnType.STRING), CalciteJoinQueryTest.equality("dim2", "S", ColumnType.STRING)), CalciteJoinQueryTest.and(CalciteJoinQueryTest.equality("dim1", "X", ColumnType.STRING), CalciteJoinQueryTest.equality("dim2", "Y", ColumnType.STRING)), CalciteJoinQueryTest.and(CalciteJoinQueryTest.equality("dim1", "Z", ColumnType.STRING), CalciteJoinQueryTest.equality("dim2", "U", ColumnType.STRING)), CalciteJoinQueryTest.and(CalciteJoinQueryTest.equality("dim1", "U", ColumnType.STRING), CalciteJoinQueryTest.equality("dim2", "Z", ColumnType.STRING)), CalciteJoinQueryTest.and(CalciteJoinQueryTest.equality("dim1", "X", ColumnType.STRING), CalciteJoinQueryTest.equality("dim2", "A", ColumnType.STRING))})).context(queryContext).build();
        Assert.assertTrue((String)"filter pushdown must be enabled", (boolean)query.context().getEnableJoinFilterPushDown());
        this.testQuery("SELECT f1.m1, f2.m1\nFROM foo f1\nINNER JOIN foo f2 ON f1.m1 = f2.m1 where (f1.dim1, f1.dim2) in (('1', 'a'), ('C', 'D'), ('A', 'C'), ('C', 'E'), ('D', 'H'), ('A', 'D'), ('B', 'C'), \n('H', 'E'), ('I', 'J'), ('I', 'K'), ('J', 'I'), ('Q', 'R'), ('Q', 'S'), ('S', 'Q'), ('X', 'Y'), ('Z', 'U'), ('U', 'Z'), ('P', 'Q'), ('X', 'A'))\n", queryContext, (List<Query<?>>)ImmutableList.of((Object)query), (List<Object[]>)ImmutableList.of((Object)new Object[]{Float.valueOf(4.0f), Float.valueOf(4.0f)}));
    }

    @Test
    public void testPlanWithInFilterMoreThanInSubQueryThreshold() {
        String query = "SELECT l1 FROM numfoo WHERE l1 IN (4842, 4844, 4845, 14905, 4853, 29064)";
        HashMap<String, Object> queryContext = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
        queryContext.put("inSubQueryThreshold", 3);
        this.testQuery(PLANNER_CONFIG_DEFAULT, (Map<String, Object>)queryContext, (List<SqlParameter>)DEFAULT_PARAMETERS, query, CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)JoinDataSource.create((DataSource)new TableDataSource("numfoo"), (DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{4842L}, (Object)new Object[]{4844L}, (Object)new Object[]{4845L}, (Object)new Object[]{14905L}, (Object)new Object[]{4853L}, (Object)new Object[]{29064L}), (RowSignature)RowSignature.builder().add("ROW_VALUE", ColumnType.LONG).build()), (String)"j0.", (String)"(\"l1\" == \"j0.ROW_VALUE\")", (JoinType)JoinType.INNER, null, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)CalciteTests.createJoinableFactoryWrapper(), (JoinAlgorithm)JoinAlgorithm.BROADCAST)).columns(new String[]{"l1"}).columnTypes(new ColumnType[]{ColumnType.LONG}).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).context(queryContext).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()), (String sql, QueryTestRunner.QueryResults result) -> {});
    }

    @NotYetSupported(value=NotYetSupported.Modes.SORT_REMOVE_TROUBLE)
    @MethodSource(value={"provideQueryContexts"})
    @ParameterizedTest(name="{0}")
    public void testRegressionFilteredAggregatorsSubqueryJoins(Map<String, Object> queryContext) {
        this.cannotVectorize();
        Map contextWithLexicographicTopN = QueryContexts.override(queryContext, (String)"useLexicographicTopN", (Object)true);
        this.testQuery("select\ncount(*) filter (where trim(both from dim1) in (select dim2 from foo)),\nmin(m1) filter (where 'A' not in (select m2 from foo))\nfrom foo as t0\nwhere __time in (select __time from foo)", (Map<String, Object>)contextWithLexicographicTopN, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("__time", "d0", ColumnType.LONG)}).setGranularity(Granularities.ALL).setLimitSpec((LimitSpec)NoopLimitSpec.instance()).build()), "j0.", CalciteJoinQueryTest.equalsCondition(CalciteJoinQueryTest.makeColumnExpression("__time"), CalciteJoinQueryTest.makeColumnExpression("j0.d0")), JoinType.INNER), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0", ColumnType.STRING)}).setPostAggregatorSpecs(new PostAggregator[]{CalciteJoinQueryTest.expressionPostAgg("a0", "1", ColumnType.LONG)}).setGranularity(Granularities.ALL).setLimitSpec((LimitSpec)NoopLimitSpec.instance()).build()), "_j0.", "(trim(\"dim1\",' ') == \"_j0.d0\")", JoinType.LEFT), (DataSource)new QueryDataSource((Query)new TopNQueryBuilder().dataSource("foo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).filters(CalciteJoinQueryTest.isNull("m2")).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "0", ColumnType.LONG)}).dimension((DimensionSpec)new DefaultDimensionSpec("v0", "d0", ColumnType.LONG)).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.NUMERIC))).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).threshold(1).context(contextWithLexicographicTopN).build()), "__j0.", "1", JoinType.LEFT)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), (DimFilter)CalciteJoinQueryTest.and(CalciteJoinQueryTest.notNull("_j0.a0"), CalciteJoinQueryTest.notNull("dim1")), "a0"), new FilteredAggregatorFactory((AggregatorFactory)new FloatMinAggregatorFactory("a1", "m1"), (DimFilter)CalciteJoinQueryTest.or(new DimFilter[]{CalciteJoinQueryTest.isNull("__j0.a0"), CalciteJoinQueryTest.not((DimFilter)CalciteJoinQueryTest.istrue((DimFilter)CalciteJoinQueryTest.or(new DimFilter[]{CalciteJoinQueryTest.not((DimFilter)CalciteJoinQueryTest.expressionFilter("\"__j0.d0\"")), CalciteJoinQueryTest.notNull("__j0.d0")})))}), "a1")}).context(queryContext).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2L, Float.valueOf(1.0f)}));
    }

    @SqlTestFrameworkConfig.MinTopNThreshold(value=1)
    @Test
    public void testJoinWithAliasAndOrderByNoGroupBy() {
        HashMap<String, Object> context = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
        context.put("useApproximateTopN", false);
        this.testQuery("select t1.__time from druid.foo as t1 join\n  druid.numfoo as t2 on t1.dim2 = t2.dim2\n order by t1.__time ASC ", (Map<String, Object>)context, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).dataSource((DataSource)JoinDataSource.create((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim2"}).columnTypes(new ColumnType[]{ColumnType.STRING}).context(context).build()), (String)"j0.", (String)"(\"dim2\" == \"j0.dim2\")", (JoinType)JoinType.INNER, null, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)CalciteTests.createJoinableFactoryWrapper(), (JoinAlgorithm)JoinAlgorithm.BROADCAST)).columns(new String[]{"__time"}).columnTypes(new ColumnType[]{ColumnType.LONG}).order(Order.ASCENDING).context(context).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{946684800000L}, (Object)new Object[]{946684800000L}, (Object)new Object[]{946857600000L}, (Object)new Object[]{978307200000L}, (Object)new Object[]{978307200000L}, (Object)new Object[]{978393600000L}));
    }

    private List<Object[]> sortIfSortBased(List<Object[]> results, int ... keyColumns) {
        if (this.isSortBasedJoin()) {
            ArrayList<Object[]> retVal = new ArrayList<Object[]>(results);
            retVal.sort((a, b) -> {
                for (int keyColumn : keyColumns) {
                    int cmp = Comparators.naturalNullsFirst().compare((Object)((Comparable)a[keyColumn]), (Object)((Comparable)b[keyColumn]));
                    if (cmp == 0) continue;
                    return cmp;
                }
                return 0;
            });
            return retVal;
        }
        return results;
    }

    @Test
    public void testJoinsWithTwoConditions() {
        HashMap<String, Object> context = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
        this.testQuery("SELECT t1.__time, t1.m1\nFROM foo t1\nJOIN (SELECT m1, MAX(__time) as latest_time FROM foo WHERE m1 IN (1,2) GROUP BY m1) t2\nON t1.m1 = t2.m1 AND t1.__time = t2.latest_time\n", (Map<String, Object>)context, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDataSource((DataSource)new TableDataSource("foo")).setDimFilter(CalciteJoinQueryTest.in("m1", ColumnType.FLOAT, ImmutableList.of((Object)Float.valueOf(1.0f), (Object)Float.valueOf(2.0f)))).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("m1", "d0", ColumnType.FLOAT)}).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new LongMaxAggregatorFactory("a0", "__time")})).setContext(context).build()), "j0.", "((\"m1\" == \"j0.d0\") && (\"__time\" == \"j0.a0\"))", JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "m1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.FLOAT}).context(context).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{946684800000L, Float.valueOf(1.0f)}, (Object)new Object[]{946771200000L, Float.valueOf(2.0f)}));
    }

    @Test
    public void testJoinsWithThreeConditions() {
        HashMap<String, Object> context = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
        this.testQuery("SELECT t1.__time, t1.m1, t1.m2\nFROM foo t1\nJOIN (SELECT m1, m2, MAX(__time) as latest_time FROM foo WHERE m1 IN (1,2) AND m2 IN (1,2) GROUP by m1,m2) t2\nON t1.m1 = t2.m1 AND t1.m2 = t2.m2 AND t1.__time = t2.latest_time\n", (Map<String, Object>)context, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDataSource((DataSource)new TableDataSource("foo")).setDimFilter((DimFilter)CalciteJoinQueryTest.and(CalciteJoinQueryTest.in("m1", ColumnType.FLOAT, ImmutableList.of((Object)Float.valueOf(1.0f), (Object)Float.valueOf(2.0f))), CalciteJoinQueryTest.in("m2", ColumnType.DOUBLE, ImmutableList.of((Object)1.0, (Object)2.0)))).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("m1", "d0", ColumnType.FLOAT), new DefaultDimensionSpec("m2", "d1", ColumnType.DOUBLE)}).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new LongMaxAggregatorFactory("a0", "__time")})).setContext(context).build()), "j0.", "((\"m1\" == \"j0.d0\") && (\"m2\" == \"j0.d1\") && (\"__time\" == \"j0.a0\"))", JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "m1", "m2"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.FLOAT, ColumnType.DOUBLE}).context(context).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{946684800000L, Float.valueOf(1.0f), 1.0}, (Object)new Object[]{946771200000L, Float.valueOf(2.0f), 2.0}));
    }

    @Test
    @DecoupledTestConfig(quidemReason=DecoupledTestConfig.QuidemTestCaseReason.JOIN_FILTER_LOCATIONS)
    public void testJoinWithInputRefCondition() {
        this.cannotVectorize();
        HashMap<String, Object> context = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
        TimeseriesQuery expectedQuery = Druids.newTimeseriesQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)Druids.newTimeseriesQueryBuilder().dataSource("foo").aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0"), new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a1"), CalciteJoinQueryTest.notNull("m1"), "a1")}).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).context(context).build()), "j0.", "1", JoinType.INNER), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDataSource((DataSource)new TableDataSource("foo")).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("m1", "d0", ColumnType.FLOAT)}).setPostAggregatorSpecs(new PostAggregator[]{CalciteJoinQueryTest.expressionPostAgg("a0", "1", ColumnType.LONG)}).build()), "_j0.", "(CAST(floor(100), 'DOUBLE') == \"_j0.d0\")", JoinType.LEFT)).granularity(Granularities.ALL).aggregators(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), (DimFilter)CalciteJoinQueryTest.or(new DimFilter[]{CalciteJoinQueryTest.equality("j0.a0", 0L, ColumnType.LONG), CalciteJoinQueryTest.and(new DimFilter[]{CalciteJoinQueryTest.isNull("_j0.a0"), CalciteJoinQueryTest.expressionFilter("(\"j0.a1\" >= \"j0.a0\")")})}))})).context(CalciteJoinQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_BY_GRAN, "d0")).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).context(context).build();
        this.testQuery("SELECT COUNT(*) FILTER (WHERE FLOOR(100) NOT IN (SELECT m1 FROM foo)) FROM foo", (Map<String, Object>)context, (List<Query<?>>)ImmutableList.of((Object)expectedQuery), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}));
    }

    @Test
    public void testJoinsWithUnnestOnLeft() {
        HashMap<String, Object> context = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
        this.testQuery("with t1 as (\nselect * from foo, unnest(MV_TO_ARRAY(\"dim3\")) as u(d3)\n)\nselect t1.dim3, t1.d3, t2.dim2 from t1 JOIN numfoo as t2\nON t1.d3 = t2.\"dim2\"", (Map<String, Object>)context, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("foo"), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), null), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).dataSource("numfoo").columns(new String[]{"dim2"}).columnTypes(new ColumnType[]{ColumnType.STRING}).context(context).build()), "_j0.", "(\"j0.unnest\" == \"_j0.dim2\")", JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim3", "j0.unnest", "_j0.dim2"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.STRING}).context(context).build()), this.sortIfSortBased((List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\"]", "a", "a"}, (Object)new Object[]{"[\"a\",\"b\"]", "a", "a"}, (Object)new Object[]{"", "", ""}), 0));
    }

    @DecoupledTestConfig(ignoreExpectedQueriesReason=DecoupledTestConfig.IgnoreQueriesReason.UNNEST_EXTRA_SCANQUERY)
    @Test
    public void testJoinsWithUnnestOverFilteredDSOnLeft() {
        HashMap<String, Object> context = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
        this.testQuery("with t1 as (\nselect * from foo, unnest(MV_TO_ARRAY(\"dim3\")) as u(d3) where dim2='a'\n)\nselect t1.dim3, t1.d3, t2.dim2 from t1 JOIN numfoo as t2\nON t1.d3 = t2.\"dim2\"", (Map<String, Object>)context, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)UnnestDataSource.create((DataSource)FilteredDataSource.create((DataSource)new TableDataSource("foo"), (DimFilter)CalciteJoinQueryTest.equality("dim2", "a", ColumnType.STRING)), (VirtualColumn)CalciteJoinQueryTest.expressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), null), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).dataSource("numfoo").columns(new String[]{"dim2"}).columnTypes(new ColumnType[]{ColumnType.STRING}).context(context).build()), "_j0.", "(\"j0.unnest\" == \"_j0.dim2\")", JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim3", "j0.unnest", "_j0.dim2"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.STRING}).context(context).build()), this.sortIfSortBased((List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\"]", "a", "a"}, (Object)new Object[]{"[\"a\",\"b\"]", "a", "a"}, (Object)new Object[]{"", "", ""}), 0));
    }

    @Test
    public void testJoinsWithUnnestOverJoin() {
        HashMap<String, Object> context = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
        this.testQuery("with t1 as (\nselect * from (SELECT * from foo JOIN (select dim2 as t from foo where dim2 IN ('a','b','ab','abc')) ON dim2=t),  unnest(MV_TO_ARRAY(\"dim3\")) as u(d3) \n)\nselect t1.dim3, t1.d3, t2.dim2 from t1 JOIN numfoo as t2\nON t1.d3 = t2.\"dim2\"", (Map<String, Object>)context, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)UnnestDataSource.create((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).dataSource("foo").filters(CalciteJoinQueryTest.in("dim2", (Collection<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"ab", (Object)"abc"))).context(context).columns(new String[]{"dim2"}).columnTypes(new ColumnType[]{ColumnType.STRING}).build()), "j0.", "(\"dim2\" == \"j0.dim2\")", JoinType.INNER), (VirtualColumn)this.nestedExpressionVirtualColumn("_j0.unnest", "\"dim3\"", ColumnType.STRING), null), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).dataSource("numfoo").columns(new String[]{"dim2"}).columnTypes(new ColumnType[]{ColumnType.STRING}).context(context).build()), "__j0.", "(\"_j0.unnest\" == \"__j0.dim2\")", JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim3", "_j0.unnest", "__j0.dim2"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.STRING}).context(context).build()), this.sortIfSortBased((List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\"]", "a", "a"}, (Object)new Object[]{"[\"a\",\"b\"]", "a", "a"}, (Object)new Object[]{"[\"a\",\"b\"]", "a", "a"}, (Object)new Object[]{"[\"a\",\"b\"]", "a", "a"}, (Object)new Object[]{"", "", ""}, (Object)new Object[]{"", "", ""}), 0));
    }

    @Test
    public void testSelfJoinsWithUnnestOnLeftAndRight() {
        HashMap<String, Object> context = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
        this.testQuery("with t1 as (\nselect * from foo, unnest(MV_TO_ARRAY(\"dim3\")) as u(d3)\n)\nselect t1.dim3, t1.d3, t2.dim2 from t1 JOIN t1 as t2\nON t1.d3 = t2.d3", (Map<String, Object>)context, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("foo"), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), null), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).dataSource((DataSource)UnnestDataSource.create((DataSource)new TableDataSource("foo"), (VirtualColumn)this.nestedExpressionVirtualColumn("j0.unnest", "\"dim3\"", ColumnType.STRING), null)).columns(new String[]{"dim2", "j0.unnest"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING}).context(context).build()), "_j0.", "(\"j0.unnest\" == \"_j0.j0.unnest\")", JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim3", "j0.unnest", "_j0.dim2"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.STRING}).context(context).build()), this.sortIfSortBased((List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\"]", "a", "a"}, (Object)new Object[]{"[\"a\",\"b\"]", "b", "a"}, (Object)new Object[]{"[\"a\",\"b\"]", "b", null}, (Object)new Object[]{"[\"b\",\"c\"]", "b", "a"}, (Object)new Object[]{"[\"b\",\"c\"]", "b", null}, (Object)new Object[]{"[\"b\",\"c\"]", "c", null}, (Object)new Object[]{"d", "d", ""}, (Object)new Object[]{"", "", "a"}), 0));
    }

    @DecoupledTestConfig(ignoreExpectedQueriesReason=DecoupledTestConfig.IgnoreQueriesReason.UNNEST_EXTRA_SCANQUERY)
    @Test
    public void testJoinsOverUnnestOverFilterDSOverJoin() {
        HashMap<String, Object> context = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
        this.testQuery("with t1 as (\nselect * from (SELECT * from foo JOIN (select dim2 as t from foo where dim2 IN ('a','b','ab','abc')) ON dim2=t),\nunnest(MV_TO_ARRAY(\"dim3\")) as u(d3) where m1 IN (1,4) and d3='a'\n)\nselect t1.dim3, t1.d3, t2.dim2, t1.m1 from t1 JOIN numfoo as t2\nON t1.d3 = t2.\"dim2\"", (Map<String, Object>)context, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)UnnestDataSource.create((DataSource)FilteredDataSource.create((DataSource)CalciteJoinQueryTest.join((DataSource)new TableDataSource("foo"), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).dataSource("foo").columns(new String[]{"dim2"}).columnTypes(new ColumnType[]{ColumnType.STRING}).filters(CalciteJoinQueryTest.in("dim2", (Collection<String>)ImmutableList.of((Object)"a", (Object)"ab", (Object)"abc", (Object)"b"))).context(context).build()), "j0.", "(\"dim2\" == \"j0.dim2\")", JoinType.INNER), (DimFilter)CalciteJoinQueryTest.in("m1", ColumnType.FLOAT, ImmutableList.of((Object)1.0, (Object)4.0))), (VirtualColumn)CalciteJoinQueryTest.expressionVirtualColumn("_j0.unnest", "\"dim3\"", ColumnType.STRING), (DimFilter)CalciteJoinQueryTest.equality("_j0.unnest", "a", ColumnType.STRING)), (DataSource)new QueryDataSource((Query)CalciteJoinQueryTest.newScanQueryBuilder().intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).dataSource("numfoo").columns(new String[]{"dim2"}).columnTypes(new ColumnType[]{ColumnType.STRING}).context(context).build()), "__j0.", "(\"_j0.unnest\" == \"__j0.dim2\")", JoinType.INNER)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim3", "_j0.unnest", "__j0.dim2", "m1"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.FLOAT}).context(context).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"a\",\"b\"]", "a", "a", Float.valueOf(1.0f)}, (Object)new Object[]{"[\"a\",\"b\"]", "a", "a", Float.valueOf(1.0f)}, (Object)new Object[]{"[\"a\",\"b\"]", "a", "a", Float.valueOf(1.0f)}, (Object)new Object[]{"[\"a\",\"b\"]", "a", "a", Float.valueOf(1.0f)}));
    }

    @Test
    public void testLeftJoinsOnTwoWithTables() {
        HashMap<String, Object> context = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
        this.testQuery("with raw1 as (\n  select\n  dim1,\n  count(*)/2 as c\n  from foo\n  GROUP BY 1\n),\n raw2 as (\n  select \n  dim1,\n  count(*)/2 as c\n  from foo\n  GROUP BY 1\n)\nselect\n  r1.c-r2.c\nfrom raw1 r1\nleft join raw2 r2\non r1.dim1 = r2.dim1", (Map<String, Object>)context, (List<Query<?>>)ImmutableList.of((Object)CalciteJoinQueryTest.newScanQueryBuilder().dataSource((DataSource)CalciteJoinQueryTest.join((DataSource)new QueryDataSource((Query)GroupByQuery.builder().setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDataSource((DataSource)new TableDataSource("foo")).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0", ColumnType.STRING)}).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setPostAggregatorSpecs(new PostAggregator[]{CalciteJoinQueryTest.expressionPostAgg("p0", "(\"a0\" / 2)", ColumnType.LONG)}).setContext(context).build()), (DataSource)new QueryDataSource((Query)GroupByQuery.builder().setInterval(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDataSource((DataSource)new TableDataSource("foo")).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0", ColumnType.STRING)}).setAggregatorSpecs(CalciteJoinQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).setPostAggregatorSpecs(new PostAggregator[]{CalciteJoinQueryTest.expressionPostAgg("p0", "(\"a0\" / 2)", ColumnType.LONG)}).setContext(context).build()), "j0.", "(\"d0\" == \"j0.d0\")", JoinType.LEFT)).intervals(CalciteJoinQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.LONG}).virtualColumns(new VirtualColumn[]{CalciteJoinQueryTest.expressionVirtualColumn("v0", "(\"p0\" - \"j0.p0\")", ColumnType.LONG)}).context(context).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{0L}, (Object)new Object[]{0L}, (Object)new Object[]{0L}, (Object)new Object[]{0L}, (Object)new Object[]{0L}, (Object)new Object[]{0L}));
    }
}

