/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.catalog.model.ColumnSpec;
import org.apache.druid.catalog.model.Columns;
import org.apache.druid.catalog.model.ResolvedTable;
import org.apache.druid.catalog.model.TableDefn;
import org.apache.druid.catalog.model.TableSpec;
import org.apache.druid.catalog.model.facade.DatasourceFacade;
import org.apache.druid.catalog.model.table.ClusterKeySpec;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.impl.CsvInputFormat;
import org.apache.druid.data.input.impl.InlineInputSource;
import org.apache.druid.error.DruidException;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.OrderBy;
import org.apache.druid.query.Query;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.cardinality.CardinalityAggregatorFactory;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.CalciteIngestionDmlTest;
import org.apache.druid.sql.calcite.SqlTestFrameworkConfig;
import org.apache.druid.sql.calcite.TempDirProducer;
import org.apache.druid.sql.calcite.external.ExternalDataSource;
import org.apache.druid.sql.calcite.external.Externals;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.apache.druid.sql.calcite.planner.CatalogResolver;
import org.apache.druid.sql.calcite.run.EngineFeature;
import org.apache.druid.sql.calcite.table.DatasourceMetadata;
import org.apache.druid.sql.calcite.table.DatasourceTable;
import org.apache.druid.sql.calcite.table.DruidTable;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

@SqlTestFrameworkConfig.ComponentSupplier(value=CatalogIngestionDmlComponentSupplier.class)
public abstract class CalciteCatalogIngestionDmlTest
extends CalciteIngestionDmlTest {
    private static final Map<String, Object> CONTEXT_WITH_VALIDATION_DISABLED = new HashMap<String, Object>(DEFAULT_CONTEXT);
    private final String operationName = this.getOperationName();
    private final String dmlPrefixPattern = this.getDmlPrefixPattern();

    public abstract String getOperationName();

    public abstract String getDmlPrefixPattern();

    @Test
    public void testInsertHourGrainPartitonedByFromCatalog() {
        this.testIngestionQuery().sql(StringUtils.format((String)this.dmlPrefixPattern, (Object[])new Object[]{"hourDs"}) + "\nSELECT * FROM foo").authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("hourDs", FOO_TABLE_SIGNATURE).expectResources(CalciteCatalogIngestionDmlTest.dataSourceWrite("hourDs"), CalciteCatalogIngestionDmlTest.dataSourceRead("foo")).expectQuery((Query)CalciteCatalogIngestionDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteCatalogIngestionDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "dim1", "dim2", "dim3", "cnt", "m1", "m2", "unique_dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.LONG, ColumnType.FLOAT, ColumnType.DOUBLE, ColumnType.ofComplex((String)"hyperUnique")}).context(this.queryContextWithGranularity(Granularities.HOUR)).build()).verify();
    }

    @Test
    public void testInsertHourGrainWithDayPartitonedByFromQuery() {
        this.testIngestionQuery().sql(StringUtils.format((String)this.dmlPrefixPattern, (Object[])new Object[]{"hourDs"}) + "\nSELECT * FROM foo\nPARTITIONED BY day").authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("hourDs", FOO_TABLE_SIGNATURE).expectResources(CalciteCatalogIngestionDmlTest.dataSourceWrite("hourDs"), CalciteCatalogIngestionDmlTest.dataSourceRead("foo")).expectQuery((Query)CalciteCatalogIngestionDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteCatalogIngestionDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "dim1", "dim2", "dim3", "cnt", "m1", "m2", "unique_dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.LONG, ColumnType.FLOAT, ColumnType.DOUBLE, ColumnType.ofComplex((String)"hyperUnique")}).context(this.queryContextWithGranularity(Granularities.DAY)).build()).verify();
    }

    @Test
    public void testInsertNoPartitonedByFromCatalog() {
        this.testIngestionQuery().sql(StringUtils.format((String)this.dmlPrefixPattern, (Object[])new Object[]{"noPartitonedBy"}) + "\nSELECT * FROM foo").authentication(CalciteTests.SUPER_USER_AUTH_RESULT).authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectValidationError(DruidException.class, StringUtils.format((String)"Operation [%s] requires a PARTITIONED BY to be explicitly defined, but none was found.", (Object[])new Object[]{this.operationName})).verify();
    }

    @Test
    public void testInsertNoPartitonedByWithDayPartitonedByFromQuery() {
        this.testIngestionQuery().sql(StringUtils.format((String)this.dmlPrefixPattern, (Object[])new Object[]{"noPartitonedBy"}) + "\nSELECT * FROM foo\nPARTITIONED BY day").authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("noPartitonedBy", FOO_TABLE_SIGNATURE).expectResources(CalciteCatalogIngestionDmlTest.dataSourceWrite("noPartitonedBy"), CalciteCatalogIngestionDmlTest.dataSourceRead("foo")).expectQuery((Query)CalciteCatalogIngestionDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteCatalogIngestionDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "dim1", "dim2", "dim3", "cnt", "m1", "m2", "unique_dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.LONG, ColumnType.FLOAT, ColumnType.DOUBLE, ColumnType.ofComplex((String)"hyperUnique")}).context(this.queryContextWithGranularity(Granularities.DAY)).build()).verify();
    }

    @Test
    public void testInsertAddNonDefinedColumnIntoNonSealedCatalogTable() {
        ExternalDataSource externalDataSource = new ExternalDataSource((InputSource)new InlineInputSource("2022-12-26T12:34:56,extra,10,\"20\",foo\n"), (InputFormat)new CsvInputFormat((List)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e"), null, Boolean.valueOf(false), Boolean.valueOf(false), 0, null), RowSignature.builder().add("a", ColumnType.STRING).add("b", ColumnType.STRING).add("c", ColumnType.LONG).add("d", ColumnType.STRING).add("e", ColumnType.STRING).build());
        RowSignature signature = RowSignature.builder().add("__time", ColumnType.LONG).add("dim1", ColumnType.STRING).add("cnt", ColumnType.LONG).add("m2", ColumnType.DOUBLE).add("extra2", ColumnType.LONG).add("extra3", ColumnType.STRING).build();
        this.testIngestionQuery().sql(StringUtils.format((String)this.dmlPrefixPattern, (Object[])new Object[]{"foo"}) + "\nSELECT\n  TIME_PARSE(a) AS __time,\n  b AS dim1,\n  1 AS cnt,\n  c AS m2,\n  CAST(d AS BIGINT) AS extra2,\n  e AS extra3\nFROM TABLE(inline(\n  data => ARRAY['2022-12-26T12:34:56,extra,10,\"20\",foo'],\n  format => 'csv'))\n  (a VARCHAR, b VARCHAR, c BIGINT, d VARCHAR, e VARCHAR)\nPARTITIONED BY ALL TIME").authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("foo", signature).expectResources(CalciteCatalogIngestionDmlTest.dataSourceWrite("foo"), Externals.externalRead((String)"EXTERNAL")).expectQuery((Query)CalciteCatalogIngestionDmlTest.newScanQueryBuilder().dataSource((DataSource)externalDataSource).intervals(CalciteCatalogIngestionDmlTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteCatalogIngestionDmlTest.expressionVirtualColumn("v0", "timestamp_parse(\"a\",null,'UTC')", ColumnType.LONG), CalciteCatalogIngestionDmlTest.expressionVirtualColumn("v1", "1", ColumnType.LONG), CalciteCatalogIngestionDmlTest.expressionVirtualColumn("v2", "CAST(\"c\", 'DOUBLE')", ColumnType.DOUBLE), CalciteCatalogIngestionDmlTest.expressionVirtualColumn("v3", "CAST(\"d\", 'LONG')", ColumnType.LONG)}).columns(new String[]{"v0", "b", "v1", "v2", "v3", "e"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.LONG, ColumnType.DOUBLE, ColumnType.LONG, ColumnType.STRING}).context(CalciteIngestionDmlTest.PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).verify();
    }

    @Test
    public void testInsertTableWithClusteringWithClusteringFromCatalog() {
        ExternalDataSource externalDataSource = new ExternalDataSource((InputSource)new InlineInputSource("2022-12-26T12:34:56,extra,10,\"20\",foo\n"), (InputFormat)new CsvInputFormat((List)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e"), null, Boolean.valueOf(false), Boolean.valueOf(false), 0, null), RowSignature.builder().add("a", ColumnType.STRING).add("b", ColumnType.STRING).add("c", ColumnType.LONG).add("d", ColumnType.STRING).add("e", ColumnType.STRING).build());
        RowSignature signature = RowSignature.builder().add("__time", ColumnType.LONG).add("dim1", ColumnType.STRING).add("dim2", ColumnType.STRING).add("cnt", ColumnType.LONG).build();
        this.testIngestionQuery().sql(StringUtils.format((String)this.dmlPrefixPattern, (Object[])new Object[]{"tableWithClustering"}) + "\nSELECT\n  TIME_PARSE(a) AS __time,\n  b AS dim1,\n  d AS dim2,\n  1 AS cnt\nFROM TABLE(inline(\n  data => ARRAY['2022-12-26T12:34:56,extra,10,\"20\",foo'],\n  format => 'csv'))\n  (a VARCHAR, b VARCHAR, c BIGINT, d VARCHAR, e VARCHAR)\nPARTITIONED BY ALL TIME").authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("tableWithClustering", signature).expectResources(CalciteCatalogIngestionDmlTest.dataSourceWrite("tableWithClustering"), Externals.externalRead((String)"EXTERNAL")).expectQuery((Query)CalciteCatalogIngestionDmlTest.newScanQueryBuilder().dataSource((DataSource)externalDataSource).intervals(CalciteCatalogIngestionDmlTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteCatalogIngestionDmlTest.expressionVirtualColumn("v0", "timestamp_parse(\"a\",null,'UTC')", ColumnType.LONG), CalciteCatalogIngestionDmlTest.expressionVirtualColumn("v1", "1", ColumnType.LONG)}).orderBy((List)ImmutableList.of((Object)OrderBy.ascending((String)"b"), (Object)OrderBy.ascending((String)"d"))).columns(new String[]{"v0", "b", "d", "v1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.STRING, ColumnType.LONG}).context(CalciteIngestionDmlTest.PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).verify();
    }

    @Test
    public void testInsertTableWithClusteringWithClusteringFromQuery() {
        ExternalDataSource externalDataSource = new ExternalDataSource((InputSource)new InlineInputSource("2022-12-26T12:34:56,extra,10,\"20\",foo\n"), (InputFormat)new CsvInputFormat((List)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e"), null, Boolean.valueOf(false), Boolean.valueOf(false), 0, null), RowSignature.builder().add("a", ColumnType.STRING).add("b", ColumnType.STRING).add("c", ColumnType.LONG).add("d", ColumnType.STRING).add("e", ColumnType.STRING).build());
        RowSignature signature = RowSignature.builder().add("__time", ColumnType.LONG).add("dim1", ColumnType.STRING).add("dim2", ColumnType.STRING).add("cnt", ColumnType.LONG).build();
        this.testIngestionQuery().sql(StringUtils.format((String)this.dmlPrefixPattern, (Object[])new Object[]{"tableWithClustering"}) + "\nSELECT\n  TIME_PARSE(a) AS __time,\n  b AS dim1,\n  d AS dim2,\n  1 AS cnt\nFROM TABLE(inline(\n  data => ARRAY['2022-12-26T12:34:56,extra,10,\"20\",foo'],\n  format => 'csv'))\n  (a VARCHAR, b VARCHAR, c BIGINT, d VARCHAR, e VARCHAR)\nCLUSTERED BY dim1").authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("tableWithClustering", signature).expectResources(CalciteCatalogIngestionDmlTest.dataSourceWrite("tableWithClustering"), Externals.externalRead((String)"EXTERNAL")).expectQuery((Query)CalciteCatalogIngestionDmlTest.newScanQueryBuilder().dataSource((DataSource)externalDataSource).intervals(CalciteCatalogIngestionDmlTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteCatalogIngestionDmlTest.expressionVirtualColumn("v0", "timestamp_parse(\"a\",null,'UTC')", ColumnType.LONG), CalciteCatalogIngestionDmlTest.expressionVirtualColumn("v1", "1", ColumnType.LONG)}).orderBy((List)ImmutableList.of((Object)OrderBy.ascending((String)"b"))).columns(new String[]{"v0", "b", "d", "v1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.STRING, ColumnType.LONG}).context(CalciteIngestionDmlTest.PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).verify();
    }

    @Test
    public void testInsertTableWithClusteringWithClusteringOnNewColumnFromQuery() {
        ExternalDataSource externalDataSource = new ExternalDataSource((InputSource)new InlineInputSource("2022-12-26T12:34:56,extra,10,\"20\",foo\n"), (InputFormat)new CsvInputFormat((List)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e"), null, Boolean.valueOf(false), Boolean.valueOf(false), 0, null), RowSignature.builder().add("a", ColumnType.STRING).add("b", ColumnType.STRING).add("c", ColumnType.LONG).add("d", ColumnType.STRING).add("e", ColumnType.STRING).build());
        RowSignature signature = RowSignature.builder().add("__time", ColumnType.LONG).add("dim1", ColumnType.STRING).add("dim2", ColumnType.STRING).add("dim3", ColumnType.STRING).add("cnt", ColumnType.LONG).build();
        this.testIngestionQuery().sql(StringUtils.format((String)this.dmlPrefixPattern, (Object[])new Object[]{"tableWithClustering"}) + "\nSELECT\n  TIME_PARSE(a) AS __time,\n  b AS dim1,\n  d AS dim2,\n  e AS dim3,\n  1 AS cnt\nFROM TABLE(inline(\n  data => ARRAY['2022-12-26T12:34:56,extra,10,\"20\",foo'],\n  format => 'csv'))\n  (a VARCHAR, b VARCHAR, c BIGINT, d VARCHAR, e VARCHAR)\nPARTITIONED BY ALL TIME\nCLUSTERED BY dim3").authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("tableWithClustering", signature).expectResources(CalciteCatalogIngestionDmlTest.dataSourceWrite("tableWithClustering"), Externals.externalRead((String)"EXTERNAL")).expectQuery((Query)CalciteCatalogIngestionDmlTest.newScanQueryBuilder().dataSource((DataSource)externalDataSource).intervals(CalciteCatalogIngestionDmlTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteCatalogIngestionDmlTest.expressionVirtualColumn("v0", "timestamp_parse(\"a\",null,'UTC')", ColumnType.LONG), CalciteCatalogIngestionDmlTest.expressionVirtualColumn("v1", "1", ColumnType.LONG)}).orderBy((List)ImmutableList.of((Object)OrderBy.ascending((String)"e"))).columns(new String[]{"v0", "b", "d", "e", "v1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.LONG}).context(CalciteIngestionDmlTest.PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).verify();
    }

    @Test
    public void testInsertTableWithQueryDefinedClusteringOnNonSelectedColumn() {
        this.testIngestionQuery().sql(StringUtils.format((String)this.dmlPrefixPattern, (Object[])new Object[]{"tableWithClustering"}) + "\nSELECT\n  TIME_PARSE(a) AS __time,\n  b AS dim1,\n  d AS dim2,\n  e AS dim3,\n  1 AS cnt\nFROM TABLE(inline(\n  data => ARRAY['2022-12-26T12:34:56,extra,10,\"20\",foo'],\n  format => 'csv'))\n  (a VARCHAR, b VARCHAR, c BIGINT, d VARCHAR, e VARCHAR)\nPARTITIONED BY ALL TIME\nCLUSTERED BY blah").expectValidationError(DruidException.class, "Column 'blah' not found in any table (line [13], column [14])").verify();
    }

    @Test
    public void testInsertTableWithCatalogDefinedClusteringOnNonSelectedColumn() {
        this.testIngestionQuery().sql(StringUtils.format((String)this.dmlPrefixPattern, (Object[])new Object[]{"tableWithClustering"}) + "\nSELECT\n  TIME_PARSE(a) AS __time,\n  b AS dim1,\n  e AS dim3,\n  1 AS cnt\nFROM TABLE(inline(\n  data => ARRAY['2022-12-26T12:34:56,extra,10,\"20\",foo'],\n  format => 'csv'))\n  (a VARCHAR, b VARCHAR, c BIGINT, d VARCHAR, e VARCHAR)\nPARTITIONED BY ALL TIME").expectValidationError(DruidException.class, "Column 'dim2' not found in any table (line [0], column [0])").verify();
    }

    @Test
    public void testInsertTableWithCatalogDefinedClusteringDesc() {
        this.testIngestionQuery().sql(StringUtils.format((String)this.dmlPrefixPattern, (Object[])new Object[]{"tableWithClusteringDesc"}) + "\nSELECT\n  TIME_PARSE(a) AS __time,\n  b AS dim1,\n  d AS dim2,\n  e AS dim3,\n  1 AS cnt\nFROM TABLE(inline(\n  data => ARRAY['2022-12-26T12:34:56,extra,10,\"20\",foo'],\n  format => 'csv'))\n  (a VARCHAR, b VARCHAR, c BIGINT, d VARCHAR, e VARCHAR)\nPARTITIONED BY ALL TIME").expectValidationError(DruidException.class, "Invalid CLUSTERED BY clause [`dim2` DESC]: cannot sort in descending order.").verify();
    }

    @Test
    public void testInsertTableWithQueryDefinedClusteringDesc() {
        this.testIngestionQuery().sql(StringUtils.format((String)this.dmlPrefixPattern, (Object[])new Object[]{"tableWithClusteringDesc"}) + "\nSELECT\n  TIME_PARSE(a) AS __time,\n  b AS dim1,\n  d AS dim2,\n  e AS dim3,\n  1 AS cnt\nFROM TABLE(inline(\n  data => ARRAY['2022-12-26T12:34:56,extra,10,\"20\",foo'],\n  format => 'csv'))\n  (a VARCHAR, b VARCHAR, c BIGINT, d VARCHAR, e VARCHAR)\nPARTITIONED BY ALL TIME\nCLUSTERED BY dim1 DESC").expectValidationError(DruidException.class, "Invalid CLUSTERED BY clause [`dim1` DESC]: cannot sort in descending order.").verify();
    }

    @Test
    public void testGroupByInsertAddNonDefinedColumnIntoNonSealedCatalogTable() {
        ExternalDataSource externalDataSource = new ExternalDataSource((InputSource)new InlineInputSource("2022-12-26T12:34:56,extra,10,\"20\",foo\n"), (InputFormat)new CsvInputFormat((List)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e"), null, Boolean.valueOf(false), Boolean.valueOf(false), 0, null), RowSignature.builder().add("a", ColumnType.STRING).add("b", ColumnType.STRING).add("c", ColumnType.LONG).add("d", ColumnType.STRING).add("e", ColumnType.STRING).build());
        RowSignature signature = RowSignature.builder().add("__time", ColumnType.LONG).add("dim1", ColumnType.STRING).add("cnt", ColumnType.LONG).add("m2", ColumnType.DOUBLE).add("extra2", ColumnType.LONG).add("extra3", ColumnType.STRING).add("extra4_complex", ColumnType.LONG).build();
        this.testIngestionQuery().sql(StringUtils.format((String)this.dmlPrefixPattern, (Object[])new Object[]{"foo"}) + "\nSELECT\n  TIME_PARSE(a) AS __time,\n  b AS dim1,\n  1 AS cnt,\n  c AS m2,\n  CAST(d AS BIGINT) AS extra2,\n  e AS extra3,\n  APPROX_COUNT_DISTINCT_BUILTIN(c) as extra4_complex\nFROM TABLE(inline(\n  data => ARRAY['2022-12-26T12:34:56,extra,10,\"20\",foo'],\n  format => 'csv'))\n  (a VARCHAR, b VARCHAR, c BIGINT, d VARCHAR, e VARCHAR)\nGROUP BY 1,2,3,4,5,6\nPARTITIONED BY ALL TIME").authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("foo", signature).expectResources(CalciteCatalogIngestionDmlTest.dataSourceWrite("foo"), Externals.externalRead((String)"EXTERNAL")).expectQuery((Query)GroupByQuery.builder().setDataSource((DataSource)externalDataSource).setGranularity(Granularities.ALL).setInterval(CalciteCatalogIngestionDmlTest.querySegmentSpec(Filtration.eternity())).setVirtualColumns(new VirtualColumn[]{CalciteCatalogIngestionDmlTest.expressionVirtualColumn("v0", "timestamp_parse(\"a\",null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteCatalogIngestionDmlTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG), new DefaultDimensionSpec("b", "d1", ColumnType.STRING), new DefaultDimensionSpec("c", "d3", ColumnType.LONG), new DefaultDimensionSpec("d", "d4", ColumnType.LONG), new DefaultDimensionSpec("e", "d5", ColumnType.STRING)})).setAggregatorSpecs(new AggregatorFactory[]{new CardinalityAggregatorFactory("a0", null, (List)ImmutableList.of((Object)new DefaultDimensionSpec("c", "c", ColumnType.LONG)), false, true)}).setPostAggregatorSpecs(new PostAggregator[]{CalciteCatalogIngestionDmlTest.expressionPostAgg("p0", "1", ColumnType.LONG), CalciteCatalogIngestionDmlTest.expressionPostAgg("p1", "CAST(\"d3\", 'DOUBLE')", ColumnType.DOUBLE)}).setContext(CalciteIngestionDmlTest.PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).verify();
    }

    @Test
    public void testInsertAddNonDefinedColumnIntoSealedCatalogTable() {
        this.testIngestionQuery().sql(StringUtils.format((String)this.dmlPrefixPattern, (Object[])new Object[]{"fooSealed"}) + "\nSELECT\n  TIME_PARSE(a) AS __time,\n  b AS dim1,\n  1 AS cnt,\n  c AS m2,\n  d AS extra2\nFROM TABLE(inline(\n  data => ARRAY['2022-12-26T12:34:56,extra,10,\"20\",foo'],\n  format => 'csv'))\n  (a VARCHAR, b VARCHAR, c BIGINT, d VARCHAR, e VARCHAR)\nPARTITIONED BY ALL TIME").authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectValidationError(DruidException.class, "Column [extra2] is not defined in the target table [druid.fooSealed] strict schema").verify();
    }

    @Test
    public void testInsertAddNonDefinedColumnIntoSealedCatalogTableAndValidationDisabled() {
        ExternalDataSource externalDataSource = new ExternalDataSource((InputSource)new InlineInputSource("2022-12-26T12:34:56,extra,10,\"20\",foo\n"), (InputFormat)new CsvInputFormat((List)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e"), null, Boolean.valueOf(false), Boolean.valueOf(false), 0, null), RowSignature.builder().add("a", ColumnType.STRING).add("b", ColumnType.STRING).add("c", ColumnType.LONG).add("d", ColumnType.STRING).add("e", ColumnType.STRING).build());
        RowSignature signature = RowSignature.builder().add("__time", ColumnType.LONG).add("dim1", ColumnType.STRING).add("cnt", ColumnType.LONG).add("m2", ColumnType.LONG).add("extra2", ColumnType.STRING).build();
        this.testIngestionQuery().context(CONTEXT_WITH_VALIDATION_DISABLED).sql(StringUtils.format((String)this.dmlPrefixPattern, (Object[])new Object[]{"fooSealed"}) + "\nSELECT\n  TIME_PARSE(a) AS __time,\n  b AS dim1,\n  1 AS cnt,\n  c AS m2,\n  d AS extra2\nFROM TABLE(inline(\n  data => ARRAY['2022-12-26T12:34:56,extra,10,\"20\",foo'],\n  format => 'csv'))\n  (a VARCHAR, b VARCHAR, c BIGINT, d VARCHAR, e VARCHAR)\nPARTITIONED BY ALL TIME").authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("fooSealed", signature).expectResources(CalciteCatalogIngestionDmlTest.dataSourceWrite("fooSealed"), Externals.externalRead((String)"EXTERNAL")).expectQuery((Query)CalciteCatalogIngestionDmlTest.newScanQueryBuilder().dataSource((DataSource)externalDataSource).intervals(CalciteCatalogIngestionDmlTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteCatalogIngestionDmlTest.expressionVirtualColumn("v0", "timestamp_parse(\"a\",null,'UTC')", ColumnType.LONG), CalciteCatalogIngestionDmlTest.expressionVirtualColumn("v1", "1", ColumnType.LONG)}).columns(new String[]{"v0", "b", "v1", "c", "d"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.LONG, ColumnType.LONG, ColumnType.STRING}).context(CalciteIngestionDmlTest.PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).verify();
    }

    @Test
    public void testInsertWithSourceIntoCatalogTable() {
        ExternalDataSource externalDataSource = new ExternalDataSource((InputSource)new InlineInputSource("2022-12-26T12:34:56,extra,10,\"20\",foo\n"), (InputFormat)new CsvInputFormat((List)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e"), null, Boolean.valueOf(false), Boolean.valueOf(false), 0, null), RowSignature.builder().add("a", ColumnType.STRING).add("b", ColumnType.STRING).add("c", ColumnType.LONG).add("d", ColumnType.STRING).add("e", ColumnType.STRING).build());
        RowSignature signature = RowSignature.builder().add("__time", ColumnType.LONG).add("dim1", ColumnType.STRING).add("cnt", ColumnType.LONG).add("m2", ColumnType.DOUBLE).add("extra2", ColumnType.LONG).add("extra3", ColumnType.STRING).build();
        this.testIngestionQuery().sql(StringUtils.format((String)this.dmlPrefixPattern, (Object[])new Object[]{"foo"}) + "\nWITH \"ext\" AS (\n  SELECT *\nFROM TABLE(inline(\n  data => ARRAY['2022-12-26T12:34:56,extra,10,\"20\",foo'],\n  format => 'csv'))\n  (a VARCHAR, b VARCHAR, c BIGINT, d VARCHAR, e VARCHAR)\n)\nSELECT\n  TIME_PARSE(a) AS __time,\n  b AS dim1,\n  1 AS cnt,\n  c AS m2,\n  CAST(d AS BIGINT) AS extra2,\n  e AS extra3\nFROM \"ext\"\nPARTITIONED BY ALL TIME").authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("foo", signature).expectResources(CalciteCatalogIngestionDmlTest.dataSourceWrite("foo"), Externals.externalRead((String)"EXTERNAL")).expectQuery((Query)CalciteCatalogIngestionDmlTest.newScanQueryBuilder().dataSource((DataSource)externalDataSource).intervals(CalciteCatalogIngestionDmlTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteCatalogIngestionDmlTest.expressionVirtualColumn("v0", "timestamp_parse(\"a\",null,'UTC')", ColumnType.LONG), CalciteCatalogIngestionDmlTest.expressionVirtualColumn("v1", "1", ColumnType.LONG), CalciteCatalogIngestionDmlTest.expressionVirtualColumn("v2", "CAST(\"c\", 'DOUBLE')", ColumnType.DOUBLE), CalciteCatalogIngestionDmlTest.expressionVirtualColumn("v3", "CAST(\"d\", 'LONG')", ColumnType.LONG)}).columns(new String[]{"v0", "b", "v1", "v2", "v3", "e"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.LONG, ColumnType.DOUBLE, ColumnType.LONG, ColumnType.STRING}).context(CalciteIngestionDmlTest.PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).verify();
    }

    @Test
    public void testGroupByInsertWithSourceIntoCatalogTable() {
        ExternalDataSource externalDataSource = new ExternalDataSource((InputSource)new InlineInputSource("2022-12-26T12:34:56,extra,10,\"20\",foo\n"), (InputFormat)new CsvInputFormat((List)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e"), null, Boolean.valueOf(false), Boolean.valueOf(false), 0, null), RowSignature.builder().add("a", ColumnType.STRING).add("b", ColumnType.STRING).add("c", ColumnType.LONG).add("d", ColumnType.STRING).add("e", ColumnType.STRING).build());
        RowSignature signature = RowSignature.builder().add("__time", ColumnType.LONG).add("dim1", ColumnType.STRING).add("cnt", ColumnType.LONG).add("m2", ColumnType.DOUBLE).add("extra2", ColumnType.LONG).add("extra3", ColumnType.STRING).add("extra4_complex", ColumnType.LONG).build();
        this.testIngestionQuery().sql(StringUtils.format((String)this.dmlPrefixPattern, (Object[])new Object[]{"foo"}) + "\nWITH \"ext\" AS (\n  SELECT *\nFROM TABLE(inline(\n  data => ARRAY['2022-12-26T12:34:56,extra,10,\"20\",foo'],\n  format => 'csv'))\n  (a VARCHAR, b VARCHAR, c BIGINT, d VARCHAR, e VARCHAR)\n)\nSELECT\n  TIME_PARSE(a) AS __time,\n  b AS dim1,\n  1 AS cnt,\n  c AS m2,\n  CAST(d AS BIGINT) AS extra2,\n  e AS extra3,\n  APPROX_COUNT_DISTINCT_BUILTIN(c) as extra4_complex\nFROM \"ext\"\nGROUP BY 1,2,3,4,5,6\nPARTITIONED BY ALL TIME").authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("foo", signature).expectResources(CalciteCatalogIngestionDmlTest.dataSourceWrite("foo"), Externals.externalRead((String)"EXTERNAL")).expectQuery((Query)GroupByQuery.builder().setDataSource((DataSource)externalDataSource).setGranularity(Granularities.ALL).setInterval(CalciteCatalogIngestionDmlTest.querySegmentSpec(Filtration.eternity())).setVirtualColumns(new VirtualColumn[]{CalciteCatalogIngestionDmlTest.expressionVirtualColumn("v0", "timestamp_parse(\"a\",null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteCatalogIngestionDmlTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG), new DefaultDimensionSpec("b", "d1", ColumnType.STRING), new DefaultDimensionSpec("c", "d3", ColumnType.LONG), new DefaultDimensionSpec("d", "d4", ColumnType.LONG), new DefaultDimensionSpec("e", "d5", ColumnType.STRING)})).setAggregatorSpecs(new AggregatorFactory[]{new CardinalityAggregatorFactory("a0", null, (List)ImmutableList.of((Object)new DefaultDimensionSpec("c", "c", ColumnType.LONG)), false, true)}).setPostAggregatorSpecs(new PostAggregator[]{CalciteCatalogIngestionDmlTest.expressionPostAgg("p0", "1", ColumnType.LONG), CalciteCatalogIngestionDmlTest.expressionPostAgg("p1", "CAST(\"d3\", 'DOUBLE')", ColumnType.DOUBLE)}).setContext(CalciteIngestionDmlTest.PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).verify();
    }

    @Test
    public void testInsertIntoExistingStrictNoDefinedSchema() {
        this.testIngestionQuery().sql(StringUtils.format((String)this.dmlPrefixPattern, (Object[])new Object[]{"strictTableWithNoDefinedSchema"}) + " SELECT __time AS __time FROM foo PARTITIONED BY ALL TIME").expectValidationError(DruidException.class, "Column [__time] is not defined in the target table [druid.strictTableWithNoDefinedSchema] strict schema").verify();
    }

    @Test
    public void testInsertIntoExistingWithIncompatibleTypeAssignment() {
        this.testIngestionQuery().sql(StringUtils.format((String)this.dmlPrefixPattern, (Object[])new Object[]{"foo"}) + "\nSELECT\n  __time AS __time,\n  ARRAY[dim1] AS dim1\nFROM foo\nPARTITIONED BY ALL TIME").expectValidationError(DruidException.class, "Cannot assign to target field 'dim1' of type VARCHAR from source field 'dim1' of type VARCHAR ARRAY (line [4], column [3])").verify();
    }

    @Test
    public void testInsertIntoExistingWithIncompatibleTypeAssignmentAndValidationDisabled() {
        RowSignature signature = RowSignature.builder().add("__time", ColumnType.LONG).add("dim1", ColumnType.STRING_ARRAY).build();
        this.testIngestionQuery().context(CONTEXT_WITH_VALIDATION_DISABLED).sql(StringUtils.format((String)this.dmlPrefixPattern, (Object[])new Object[]{"foo"}) + "\nSELECT\n  __time AS __time,\n  ARRAY[dim1] AS dim1\nFROM foo\nPARTITIONED BY ALL TIME").authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("foo", signature).expectResources(CalciteCatalogIngestionDmlTest.dataSourceRead("foo"), CalciteCatalogIngestionDmlTest.dataSourceWrite("foo")).expectQuery((Query)CalciteCatalogIngestionDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteCatalogIngestionDmlTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteCatalogIngestionDmlTest.expressionVirtualColumn("v0", "array(\"dim1\")", ColumnType.STRING_ARRAY)}).columns(new String[]{"__time", "v0"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING_ARRAY}).context(CalciteIngestionDmlTest.PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).verify();
    }

    @Test
    public void testGroupByInsertIntoExistingWithIncompatibleTypeAssignment() {
        this.testIngestionQuery().sql(StringUtils.format((String)this.dmlPrefixPattern, (Object[])new Object[]{"foo"}) + "\nSELECT\n  __time AS __time,\n  ARRAY[dim1] AS unique_dim1\nFROM foo\nPARTITIONED BY ALL TIME").expectValidationError(DruidException.class, "Cannot assign to target field 'unique_dim1' of type COMPLEX<hyperUnique> from source field 'unique_dim1' of type VARCHAR ARRAY (line [4], column [3])").verify();
    }

    @Test
    public void testGroupByInsertIntoExistingWithIncompatibleTypeAssignmentAndValidationDisabled() {
        RowSignature signature = RowSignature.builder().add("__time", ColumnType.LONG).add("unique_dim1", ColumnType.STRING_ARRAY).build();
        this.testIngestionQuery().context(CONTEXT_WITH_VALIDATION_DISABLED).sql(StringUtils.format((String)this.dmlPrefixPattern, (Object[])new Object[]{"foo"}) + "\nSELECT\n  __time AS __time,\n  ARRAY[dim1] AS unique_dim1\nFROM foo\nPARTITIONED BY ALL TIME").authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("foo", signature).expectResources(CalciteCatalogIngestionDmlTest.dataSourceRead("foo"), CalciteCatalogIngestionDmlTest.dataSourceWrite("foo")).expectQuery((Query)CalciteCatalogIngestionDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteCatalogIngestionDmlTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteCatalogIngestionDmlTest.expressionVirtualColumn("v0", "array(\"dim1\")", ColumnType.STRING_ARRAY)}).columns(new String[]{"__time", "v0"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING_ARRAY}).context(CalciteIngestionDmlTest.PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).verify();
    }

    @Test
    public void testWindowingErrorWithEngineFeatureOff() {
        Assumptions.assumeFalse((boolean)this.queryFramework().engine().featureAvailable(EngineFeature.WINDOW_FUNCTIONS));
        this.testIngestionQuery().sql(StringUtils.format((String)this.dmlPrefixPattern, (Object[])new Object[]{"foo"}) + "\nSELECT dim1, ROW_NUMBER() OVER () from foo\nPARTITIONED BY ALL TIME").expectValidationError(DruidException.class, "The query contains window functions; They are not supported on engine[ingestion-test]. (line [2], column [14])").verify();
    }

    static {
        CONTEXT_WITH_VALIDATION_DISABLED.put("catalogValidationEnabled", false);
    }

    public static class CatalogIngestionDmlComponentSupplier
    extends CalciteIngestionDmlTest.IngestionDmlComponentSupplier {
        private static final ObjectMapper MAPPER = new DefaultObjectMapper();
        public static ImmutableMap<String, DatasourceTable> RESOLVED_TABLES = ImmutableMap.of((Object)"hourDs", (Object)new DatasourceTable(RowSignature.builder().addTimeColumn().build(), (DatasourceMetadata)new DatasourceTable.PhysicalDatasourceMetadata(new TableDataSource("hourDs"), RowSignature.builder().addTimeColumn().build(), false, false), new DatasourceTable.EffectiveMetadata(new DatasourceFacade(new ResolvedTable(new TableDefn("hourDs", "datasource", null, null), new TableSpec("datasource", (Map)ImmutableMap.of((Object)"segmentGranularity", (Object)"PT1H"), (List)ImmutableList.of((Object)new ColumnSpec("__time", "__time", null))), MAPPER)), DatasourceTable.EffectiveMetadata.toEffectiveColumns((RowSignature)RowSignature.builder().addTimeColumn().build()), false)), (Object)"noPartitonedBy", (Object)new DatasourceTable(RowSignature.builder().addTimeColumn().build(), (DatasourceMetadata)new DatasourceTable.PhysicalDatasourceMetadata(new TableDataSource("noPartitonedBy"), RowSignature.builder().addTimeColumn().build(), false, false), new DatasourceTable.EffectiveMetadata(new DatasourceFacade(new ResolvedTable(new TableDefn("noPartitonedBy", "datasource", null, null), new TableSpec("datasource", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)new ColumnSpec("__time", "__time", null))), MAPPER)), DatasourceTable.EffectiveMetadata.toEffectiveColumns((RowSignature)RowSignature.builder().addTimeColumn().build()), false)), (Object)"strictTableWithNoDefinedSchema", (Object)new DatasourceTable(RowSignature.builder().build(), (DatasourceMetadata)new DatasourceTable.PhysicalDatasourceMetadata(new TableDataSource("strictTableWithNoDefinedSchema"), RowSignature.builder().build(), false, false), new DatasourceTable.EffectiveMetadata(new DatasourceFacade(new ResolvedTable(new TableDefn("strictTableWithNoDefinedSchema", "datasource", null, null), new TableSpec("datasource", (Map)ImmutableMap.of((Object)"sealed", (Object)true), null), MAPPER)), DatasourceTable.EffectiveMetadata.toEffectiveColumns((RowSignature)RowSignature.builder().build()), false)), (Object)"foo", (Object)new DatasourceTable(CalciteIngestionDmlTest.FOO_TABLE_SIGNATURE, (DatasourceMetadata)new DatasourceTable.PhysicalDatasourceMetadata(new TableDataSource("foo"), CalciteIngestionDmlTest.FOO_TABLE_SIGNATURE, false, false), new DatasourceTable.EffectiveMetadata(new DatasourceFacade(new ResolvedTable(new TableDefn("foo", "datasource", null, null), new TableSpec("datasource", (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)new ColumnSpec("__time", "__time", null), (Object)new ColumnSpec("dim1", Columns.STRING, null), (Object)new ColumnSpec("dim2", Columns.STRING, null), (Object)new ColumnSpec("dim3", Columns.STRING, null), (Object)new ColumnSpec("cnt", Columns.LONG, null), (Object)new ColumnSpec("m1", Columns.FLOAT, null), (Object)new ColumnSpec("m2", Columns.DOUBLE, null), (Object)new ColumnSpec("unique_dim1", HyperUniquesAggregatorFactory.TYPE.asTypeString(), null))), MAPPER)), DatasourceTable.EffectiveMetadata.toEffectiveColumns((RowSignature)CalciteIngestionDmlTest.FOO_TABLE_SIGNATURE), false)), (Object)"fooSealed", (Object)new DatasourceTable(CalciteIngestionDmlTest.FOO_TABLE_SIGNATURE, (DatasourceMetadata)new DatasourceTable.PhysicalDatasourceMetadata(new TableDataSource("fooSealed"), CalciteIngestionDmlTest.FOO_TABLE_SIGNATURE, false, false), new DatasourceTable.EffectiveMetadata(new DatasourceFacade(new ResolvedTable(new TableDefn("fooSealed", "datasource", null, null), new TableSpec("datasource", (Map)ImmutableMap.of((Object)"sealed", (Object)true), (List)ImmutableList.of((Object)new ColumnSpec("__time", "__time", null), (Object)new ColumnSpec("dim1", Columns.STRING, null), (Object)new ColumnSpec("dim2", Columns.STRING, null), (Object)new ColumnSpec("dim3", Columns.STRING, null), (Object)new ColumnSpec("cnt", Columns.LONG, null), (Object)new ColumnSpec("m1", Columns.FLOAT, null), (Object)new ColumnSpec("m2", Columns.DOUBLE, null))), MAPPER)), DatasourceTable.EffectiveMetadata.toEffectiveColumns((RowSignature)CalciteIngestionDmlTest.FOO_TABLE_SIGNATURE), false)), (Object)"tableWithClustering", (Object)new DatasourceTable(CalciteIngestionDmlTest.FOO_TABLE_SIGNATURE, (DatasourceMetadata)new DatasourceTable.PhysicalDatasourceMetadata(new TableDataSource("tableWithClustering"), RowSignature.builder().addTimeColumn().add("dim1", ColumnType.STRING).add("dim2", ColumnType.STRING).add("cnt", ColumnType.LONG).build(), false, false), new DatasourceTable.EffectiveMetadata(new DatasourceFacade(new ResolvedTable(new TableDefn("tableWithClustering", "datasource", null, null), new TableSpec("datasource", (Map)ImmutableMap.of((Object)"segmentGranularity", (Object)"ALL", (Object)"clusterKeys", (Object)ImmutableList.of((Object)new ClusterKeySpec("dim1", Boolean.valueOf(false)), (Object)new ClusterKeySpec("dim2", Boolean.valueOf(false)))), (List)ImmutableList.of((Object)new ColumnSpec("__time", "__time", null), (Object)new ColumnSpec("dim1", Columns.STRING, null), (Object)new ColumnSpec("dim2", Columns.STRING, null), (Object)new ColumnSpec("cnt", Columns.LONG, null))), MAPPER)), DatasourceTable.EffectiveMetadata.toEffectiveColumns((RowSignature)RowSignature.builder().addTimeColumn().add("dim1", ColumnType.STRING).add("dim2", ColumnType.STRING).add("cnt", ColumnType.LONG).build()), false)), (Object)"tableWithClusteringDesc", (Object)new DatasourceTable(CalciteIngestionDmlTest.FOO_TABLE_SIGNATURE, (DatasourceMetadata)new DatasourceTable.PhysicalDatasourceMetadata(new TableDataSource("tableWithClusteringDesc"), RowSignature.builder().addTimeColumn().add("dim1", ColumnType.STRING).add("dim2", ColumnType.STRING).add("cnt", ColumnType.LONG).build(), false, false), new DatasourceTable.EffectiveMetadata(new DatasourceFacade(new ResolvedTable(new TableDefn("tableWithClusteringDesc", "datasource", null, null), new TableSpec("datasource", (Map)ImmutableMap.of((Object)"clusterKeys", (Object)ImmutableList.of((Object)new ClusterKeySpec("dim1", Boolean.valueOf(false)), (Object)new ClusterKeySpec("dim2", Boolean.valueOf(true)))), (List)ImmutableList.of((Object)new ColumnSpec("__time", "__time", null), (Object)new ColumnSpec("dim1", Columns.STRING, null), (Object)new ColumnSpec("dim2", Columns.STRING, null), (Object)new ColumnSpec("cnt", Columns.LONG, null))), MAPPER)), DatasourceTable.EffectiveMetadata.toEffectiveColumns((RowSignature)RowSignature.builder().addTimeColumn().add("dim1", ColumnType.STRING).add("dim2", ColumnType.STRING).add("cnt", ColumnType.LONG).build()), false)));

        public CatalogIngestionDmlComponentSupplier(TempDirProducer tempFolderProducer) {
            super(tempFolderProducer);
        }

        @Override
        public CatalogResolver createCatalogResolver() {
            return new CatalogResolver.NullCatalogResolver(){

                @Nullable
                public DruidTable resolveDatasource(String tableName, DatasourceTable.PhysicalDatasourceMetadata dsMetadata) {
                    if (RESOLVED_TABLES.get((Object)tableName) != null) {
                        return (DruidTable)RESOLVED_TABLES.get((Object)tableName);
                    }
                    return dsMetadata == null ? null : new DatasourceTable(dsMetadata);
                }
            };
        }
    }
}

