/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.avatica;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.InetSocketAddress;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.calcite.avatica.AvaticaClientRuntimeException;
import org.apache.calcite.avatica.AvaticaSqlException;
import org.apache.calcite.avatica.BuiltInConnectionProperty;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.MissingResultsException;
import org.apache.calcite.avatica.NoSuchStatementException;
import org.apache.calcite.avatica.server.AbstractAvaticaHandler;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.StartupInjectorBuilder;
import org.apache.druid.guice.security.PolicyModule;
import org.apache.druid.initialization.CoreInjectorBuilder;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.DefaultQueryConfig;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.policy.NoopPolicyEnforcer;
import org.apache.druid.query.policy.PolicyEnforcer;
import org.apache.druid.segment.join.JoinableFactoryWrapper;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.QueryLifecycleFactory;
import org.apache.druid.server.QueryScheduler;
import org.apache.druid.server.QuerySchedulerProvider;
import org.apache.druid.server.QueryStackTests;
import org.apache.druid.server.RequestLogLine;
import org.apache.druid.server.SpecificSegmentsQuerySegmentWalker;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.log.RequestLogger;
import org.apache.druid.server.log.TestRequestLogger;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthTestUtils;
import org.apache.druid.server.security.AuthenticatorMapper;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.Escalator;
import org.apache.druid.sql.SqlStatementFactory;
import org.apache.druid.sql.avatica.AvaticaMonitor;
import org.apache.druid.sql.avatica.AvaticaServerConfig;
import org.apache.druid.sql.avatica.DruidAvaticaJsonHandler;
import org.apache.druid.sql.avatica.DruidJdbcResultSet;
import org.apache.druid.sql.avatica.DruidMeta;
import org.apache.druid.sql.avatica.ErrorHandler;
import org.apache.druid.sql.calcite.planner.CalciteRulesManager;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.CatalogResolver;
import org.apache.druid.sql.calcite.planner.DruidOperatorTable;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.planner.PlannerFactory;
import org.apache.druid.sql.calcite.run.SqlEngine;
import org.apache.druid.sql.calcite.schema.DruidSchemaCatalog;
import org.apache.druid.sql.calcite.schema.DruidSchemaName;
import org.apache.druid.sql.calcite.schema.NamedSchema;
import org.apache.druid.sql.calcite.util.CalciteTestBase;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.apache.druid.sql.calcite.util.QueryFrameworkUtils;
import org.apache.druid.sql.guice.SqlModule;
import org.apache.druid.sql.hook.DruidHookDispatcher;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.Assert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.io.TempDir;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.ResultIterator;

public class DruidAvaticaHandlerTest
extends CalciteTestBase {
    private static final int CONNECTION_LIMIT = 4;
    private static final int STATEMENT_LIMIT = 4;
    private static final AvaticaServerConfig AVATICA_CONFIG = new AvaticaServerConfig();
    private static final String DUMMY_SQL_QUERY_ID = "dummy";
    private static QueryRunnerFactoryConglomerate conglomerate;
    private static SpecificSegmentsQuerySegmentWalker walker;
    private static Closer resourceCloser;
    private final PlannerConfig plannerConfig = new PlannerConfig();
    private final DruidOperatorTable operatorTable = CalciteTests.createOperatorTable();
    private final ExprMacroTable macroTable = CalciteTests.createExprMacroTable();
    private ServerWrapper server;
    private Connection client;
    private Connection clientNoTrailingSlash;
    private Connection superuserClient;
    private Connection clientLosAngeles;
    private Connection clientLosAngelesUsingUrl;
    private Injector injector;
    private TestRequestLogger testRequestLogger;

    @BeforeAll
    public static void setUpClass(@TempDir File tempDir) {
        resourceCloser = Closer.create();
        conglomerate = QueryStackTests.createQueryRunnerFactoryConglomerate((Closer)resourceCloser);
        walker = CalciteTests.createMockWalker(conglomerate, tempDir);
        resourceCloser.register((Closeable)walker);
    }

    @AfterAll
    public static void tearDownClass() throws IOException {
        resourceCloser.close();
    }

    private DruidSchemaCatalog makeRootSchema() {
        return CalciteTests.createMockRootSchema(conglomerate, walker, this.plannerConfig, CalciteTests.TEST_AUTHORIZER_MAPPER);
    }

    protected String getJdbcUrlTail() {
        return "/druid/v2/sql/avatica/";
    }

    protected AbstractAvaticaHandler getAvaticaHandler(DruidMeta druidMeta) {
        return new DruidAvaticaJsonHandler(druidMeta, new DruidNode(DUMMY_SQL_QUERY_ID, DUMMY_SQL_QUERY_ID, false, Integer.valueOf(1), null, true, false), new AvaticaMonitor());
    }

    @BeforeEach
    public void setUp() throws Exception {
        DruidSchemaCatalog rootSchema = this.makeRootSchema();
        this.testRequestLogger = new TestRequestLogger();
        this.injector = new CoreInjectorBuilder(new StartupInjectorBuilder().build()).addModule(binder -> {
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("test");
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(0);
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(-1);
            binder.bind(AuthenticatorMapper.class).toInstance((Object)CalciteTests.TEST_AUTHENTICATOR_MAPPER);
            binder.bind(AuthorizerMapper.class).toInstance((Object)CalciteTests.TEST_AUTHORIZER_MAPPER);
            binder.bind(Escalator.class).toInstance((Object)CalciteTests.TEST_AUTHENTICATOR_ESCALATOR);
            binder.install((Module)new PolicyModule());
            binder.bind(RequestLogger.class).toInstance((Object)this.testRequestLogger);
            binder.bind(DruidSchemaCatalog.class).toInstance((Object)rootSchema);
            for (NamedSchema schema : rootSchema.getNamedSchemas().values()) {
                Multibinder.newSetBinder((Binder)binder, NamedSchema.class).addBinding().toInstance((Object)schema);
            }
            binder.bind(QueryLifecycleFactory.class).toInstance((Object)CalciteTests.createMockQueryLifecycleFactory((QuerySegmentWalker)walker, conglomerate));
            binder.bind(DruidOperatorTable.class).toInstance((Object)this.operatorTable);
            binder.bind(ExprMacroTable.class).toInstance((Object)this.macroTable);
            binder.bind(PlannerConfig.class).toInstance((Object)this.plannerConfig);
            binder.bind(String.class).annotatedWith(DruidSchemaName.class).toInstance((Object)"druid");
            binder.bind(AvaticaServerConfig.class).toInstance((Object)AVATICA_CONFIG);
            binder.bind(ServiceEmitter.class).to(NoopServiceEmitter.class);
            binder.bind(QuerySchedulerProvider.class).in(LazySingleton.class);
            binder.bind(QueryScheduler.class).toProvider(QuerySchedulerProvider.class).in(LazySingleton.class);
            binder.install((Module)new SqlModule.SqlStatementFactoryModule());
            binder.bind((TypeLiteral)new TypeLiteral<Supplier<DefaultQueryConfig>>(){}).toInstance((Object)Suppliers.ofInstance((Object)new DefaultQueryConfig((Map)ImmutableMap.of())));
            binder.bind(CalciteRulesManager.class).toInstance((Object)new CalciteRulesManager((Set)ImmutableSet.of()));
            binder.bind(JoinableFactoryWrapper.class).toInstance((Object)CalciteTests.createJoinableFactoryWrapper());
            binder.bind(CatalogResolver.class).toInstance((Object)CatalogResolver.NULL_RESOLVER);
        }).build();
        DruidMeta druidMeta = (DruidMeta)this.injector.getInstance(DruidMeta.class);
        this.server = new ServerWrapper(druidMeta);
        this.client = this.server.getUserConnection();
        this.superuserClient = this.server.getConnection("testSuperuser", "druid");
        this.clientNoTrailingSlash = DriverManager.getConnection(StringUtils.maybeRemoveTrailingSlash((String)this.server.url), "testSuperuser", "druid");
        Properties propertiesLosAngeles = new Properties();
        propertiesLosAngeles.setProperty("sqlTimeZone", "America/Los_Angeles");
        propertiesLosAngeles.setProperty("user", "regularUserLA");
        propertiesLosAngeles.setProperty("sqlQueryId", DUMMY_SQL_QUERY_ID);
        this.clientLosAngeles = DriverManager.getConnection(this.server.url, propertiesLosAngeles);
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.server != null) {
            this.client.close();
            this.clientLosAngeles.close();
            this.clientNoTrailingSlash.close();
            this.server.close();
            this.client = null;
            this.clientLosAngeles = null;
            this.clientNoTrailingSlash = null;
            this.server = null;
        }
    }

    @Test
    public void testSelectCount() throws SQLException {
        try (Statement stmt = this.client.createStatement();){
            ResultSet resultSet = stmt.executeQuery("SELECT COUNT(*) AS cnt FROM druid.foo;");
            List<Map<String, Object>> rows = DruidAvaticaHandlerTest.getRows(resultSet);
            Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"cnt", (Object)6L)), rows);
        }
    }

    @Test
    public void testSelectCountNoTrailingSlash() throws SQLException {
        try (Statement stmt = this.clientNoTrailingSlash.createStatement();){
            ResultSet resultSet = stmt.executeQuery("SELECT COUNT(*) AS cnt FROM druid.foo");
            List<Map<String, Object>> rows = DruidAvaticaHandlerTest.getRows(resultSet);
            Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"cnt", (Object)6L)), rows);
        }
    }

    @Test
    public void testSelectCountAlternateStyle() throws SQLException {
        try (PreparedStatement stmt = this.client.prepareStatement("SELECT COUNT(*) AS cnt FROM druid.foo");){
            ResultSet resultSet = stmt.executeQuery();
            List<Map<String, Object>> rows = DruidAvaticaHandlerTest.getRows(resultSet);
            Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"cnt", (Object)6L)), rows);
        }
    }

    @Test
    public void testTimestampsInResponse() throws SQLException {
        try (Statement stmt = this.client.createStatement();){
            ResultSet resultSet = stmt.executeQuery("SELECT __time, CAST(__time AS DATE) AS t2 FROM druid.foo LIMIT 1");
            Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"__time", (Object)new Timestamp(DateTimes.of((String)"2000-01-01T00:00:00.000Z").getMillis()), (Object)"t2", (Object)new Date(DateTimes.of((String)"2000-01-01").getMillis()))), DruidAvaticaHandlerTest.getRows(resultSet));
        }
    }

    @Test
    public void testTimestampsInResponseLosAngelesTimeZone() throws SQLException {
        try (Statement stmt = this.clientLosAngeles.createStatement();){
            ResultSet resultSet = stmt.executeQuery("SELECT __time, CAST(__time AS DATE) AS t2 FROM druid.foo LIMIT 1");
            DateTimeZone timeZone = DateTimes.inferTzFromString((String)"America/Los_Angeles");
            DateTime localDateTime = new DateTime((Object)"2000-01-01T00Z", timeZone);
            List<Map<String, Object>> resultRows = DruidAvaticaHandlerTest.getRows(resultSet);
            Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"__time", (Object)new Timestamp(Calcites.jodaToCalciteTimestamp((DateTime)localDateTime, (DateTimeZone)timeZone)), (Object)"t2", (Object)new Date(Calcites.jodaToCalciteTimestamp((DateTime)localDateTime.dayOfMonth().roundFloorCopy(), (DateTimeZone)timeZone)))), resultRows);
        }
    }

    @Test
    public void testFieldAliasingSelect() throws SQLException {
        try (Statement stmt = this.client.createStatement();){
            ResultSet resultSet = stmt.executeQuery("SELECT dim2 AS \"x\", dim2 AS \"y\" FROM druid.foo LIMIT 1");
            Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"x", (Object)"a", (Object)"y", (Object)"a")), DruidAvaticaHandlerTest.getRows(resultSet));
        }
    }

    @Test
    public void testSelectBoolean() throws SQLException {
        try (Statement stmt = this.client.createStatement();){
            ResultSet resultSet = stmt.executeQuery("SELECT dim2, dim2 IS NULL AS isnull FROM druid.foo LIMIT 1");
            Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"dim2", (Object)"a", (Object)"isnull", (Object)false)), DruidAvaticaHandlerTest.getRows(resultSet));
        }
    }

    @Test
    public void testExplainSelectCount() throws SQLException {
        try (Statement stmt = this.clientLosAngeles.createStatement();){
            ResultSet resultSet = stmt.executeQuery("EXPLAIN PLAN FOR SELECT COUNT(*) AS cnt FROM druid.foo");
            Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"PLAN", (Object)StringUtils.format((String)"[{\"query\":{\"queryType\":\"timeseries\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"granularity\":{\"type\":\"all\"},\"aggregations\":[{\"type\":\"count\",\"name\":\"a0\"}],\"context\":{\"sqlQueryId\":\"%s\",\"sqlStringifyArrays\":false,\"sqlTimeZone\":\"America/Los_Angeles\"}},\"signature\":[{\"name\":\"a0\",\"type\":\"LONG\"}],\"columnMappings\":[{\"queryColumn\":\"a0\",\"outputColumn\":\"cnt\"}]}]", (Object[])new Object[]{DUMMY_SQL_QUERY_ID}), (Object)"RESOURCES", (Object)"[{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]", (Object)"ATTRIBUTES", (Object)"{\"statementType\":\"SELECT\"}")), DruidAvaticaHandlerTest.getRows(resultSet));
        }
    }

    @Test
    public void testDatabaseMetaDataCatalogs() throws SQLException {
        DatabaseMetaData metaData = this.client.getMetaData();
        Assert.assertEquals((Object)ImmutableList.of(DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"))), DruidAvaticaHandlerTest.getRows(metaData.getCatalogs()));
    }

    @Test
    public void testDatabaseMetaDataSchemas() throws SQLException {
        DatabaseMetaData metaData = this.client.getMetaData();
        Assert.assertEquals((Object)ImmutableList.of(DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CATALOG", (Object)"druid"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"))), DruidAvaticaHandlerTest.getRows(metaData.getSchemas(null, "druid")));
    }

    @Test
    public void testDatabaseMetaDataTables() throws SQLException {
        DatabaseMetaData metaData = this.client.getMetaData();
        Assert.assertEquals((Object)ImmutableList.of(DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"arrays"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"broadcast"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"foo"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"foo2"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"foo4"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"lotsocolumns"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"numfoo"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"restrictedBroadcastDatasource_m1_is_6"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"restrictedDatasource_m1_is_6"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"some_datasource"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"somexdatasource"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"visits"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), (Object[])new Map[]{DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"wikipedia"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"wikipedia_first_last"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE"))}), DruidAvaticaHandlerTest.getRows(metaData.getTables(null, "druid", "%", null), (Set<String>)ImmutableSet.of((Object)"TABLE_CAT", (Object)"TABLE_NAME", (Object)"TABLE_SCHEM", (Object)"TABLE_TYPE")));
    }

    @Test
    public void testDatabaseMetaDataTablesAsSuperuser() throws SQLException {
        DatabaseMetaData metaData = this.superuserClient.getMetaData();
        Assert.assertEquals((Object)ImmutableList.of(DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"arrays"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"broadcast"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"foo"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"foo2"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"foo4"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"forbiddenDatasource"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"lotsocolumns"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"numfoo"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"restrictedBroadcastDatasource_m1_is_6"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"restrictedDatasource_m1_is_6"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"some_datasource"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"somexdatasource"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), (Object[])new Map[]{DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"visits"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"wikipedia"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_CAT", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"wikipedia_first_last"), Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_TYPE", (Object)"TABLE"))}), DruidAvaticaHandlerTest.getRows(metaData.getTables(null, "druid", "%", null), (Set<String>)ImmutableSet.of((Object)"TABLE_CAT", (Object)"TABLE_NAME", (Object)"TABLE_SCHEM", (Object)"TABLE_TYPE")));
    }

    @Test
    public void testDatabaseMetaDataColumns() throws SQLException {
        DatabaseMetaData metaData = this.client.getMetaData();
        Assert.assertEquals((Object)ImmutableList.of(DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"foo"), Pair.of((Object)"COLUMN_NAME", (Object)"__time"), Pair.of((Object)"DATA_TYPE", (Object)93), Pair.of((Object)"TYPE_NAME", (Object)"TIMESTAMP"), Pair.of((Object)"IS_NULLABLE", (Object)"NO")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"foo"), Pair.of((Object)"COLUMN_NAME", (Object)"dim1"), Pair.of((Object)"DATA_TYPE", (Object)12), Pair.of((Object)"TYPE_NAME", (Object)"VARCHAR"), Pair.of((Object)"IS_NULLABLE", (Object)"YES")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"foo"), Pair.of((Object)"COLUMN_NAME", (Object)"dim2"), Pair.of((Object)"DATA_TYPE", (Object)12), Pair.of((Object)"TYPE_NAME", (Object)"VARCHAR"), Pair.of((Object)"IS_NULLABLE", (Object)"YES")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"foo"), Pair.of((Object)"COLUMN_NAME", (Object)"dim3"), Pair.of((Object)"DATA_TYPE", (Object)12), Pair.of((Object)"TYPE_NAME", (Object)"VARCHAR"), Pair.of((Object)"IS_NULLABLE", (Object)"YES")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"foo"), Pair.of((Object)"COLUMN_NAME", (Object)"cnt"), Pair.of((Object)"DATA_TYPE", (Object)-5), Pair.of((Object)"TYPE_NAME", (Object)"BIGINT"), Pair.of((Object)"IS_NULLABLE", (Object)"YES")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"foo"), Pair.of((Object)"COLUMN_NAME", (Object)"m1"), Pair.of((Object)"DATA_TYPE", (Object)6), Pair.of((Object)"TYPE_NAME", (Object)"FLOAT"), Pair.of((Object)"IS_NULLABLE", (Object)"YES")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"foo"), Pair.of((Object)"COLUMN_NAME", (Object)"m2"), Pair.of((Object)"DATA_TYPE", (Object)8), Pair.of((Object)"TYPE_NAME", (Object)"DOUBLE"), Pair.of((Object)"IS_NULLABLE", (Object)"YES")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"foo"), Pair.of((Object)"COLUMN_NAME", (Object)"unique_dim1"), Pair.of((Object)"DATA_TYPE", (Object)1111), Pair.of((Object)"TYPE_NAME", (Object)"COMPLEX<hyperUnique>"), Pair.of((Object)"IS_NULLABLE", (Object)"YES"))), DruidAvaticaHandlerTest.getRows(metaData.getColumns(null, "dr_id", "foo", null), (Set<String>)ImmutableSet.of((Object)"IS_NULLABLE", (Object)"TABLE_NAME", (Object)"TABLE_SCHEM", (Object)"COLUMN_NAME", (Object)"DATA_TYPE", (Object)"TYPE_NAME", (Object[])new String[0])));
    }

    @Test
    public void testDatabaseMetaDataColumnsOnForbiddenDatasource() throws SQLException {
        DatabaseMetaData metaData = this.client.getMetaData();
        Assert.assertEquals((Object)ImmutableList.of(), DruidAvaticaHandlerTest.getRows(metaData.getColumns(null, "dr_id", "forbiddenDatasource", null), (Set<String>)ImmutableSet.of((Object)"IS_NULLABLE", (Object)"TABLE_NAME", (Object)"TABLE_SCHEM", (Object)"COLUMN_NAME", (Object)"DATA_TYPE", (Object)"TYPE_NAME", (Object[])new String[0])));
    }

    @Test
    public void testDatabaseMetaDataColumnsWithSuperuser() throws SQLException {
        DatabaseMetaData metaData = this.superuserClient.getMetaData();
        Assert.assertEquals((Object)ImmutableList.of(DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"forbiddenDatasource"), Pair.of((Object)"COLUMN_NAME", (Object)"__time"), Pair.of((Object)"DATA_TYPE", (Object)93), Pair.of((Object)"TYPE_NAME", (Object)"TIMESTAMP"), Pair.of((Object)"IS_NULLABLE", (Object)"NO")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"forbiddenDatasource"), Pair.of((Object)"COLUMN_NAME", (Object)"dim1"), Pair.of((Object)"DATA_TYPE", (Object)12), Pair.of((Object)"TYPE_NAME", (Object)"VARCHAR"), Pair.of((Object)"IS_NULLABLE", (Object)"YES")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"forbiddenDatasource"), Pair.of((Object)"COLUMN_NAME", (Object)"dim2"), Pair.of((Object)"DATA_TYPE", (Object)12), Pair.of((Object)"TYPE_NAME", (Object)"VARCHAR"), Pair.of((Object)"IS_NULLABLE", (Object)"YES")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"forbiddenDatasource"), Pair.of((Object)"COLUMN_NAME", (Object)"cnt"), Pair.of((Object)"DATA_TYPE", (Object)-5), Pair.of((Object)"TYPE_NAME", (Object)"BIGINT"), Pair.of((Object)"IS_NULLABLE", (Object)"YES")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"forbiddenDatasource"), Pair.of((Object)"COLUMN_NAME", (Object)"m1"), Pair.of((Object)"DATA_TYPE", (Object)6), Pair.of((Object)"TYPE_NAME", (Object)"FLOAT"), Pair.of((Object)"IS_NULLABLE", (Object)"YES")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"forbiddenDatasource"), Pair.of((Object)"COLUMN_NAME", (Object)"m2"), Pair.of((Object)"DATA_TYPE", (Object)8), Pair.of((Object)"TYPE_NAME", (Object)"DOUBLE"), Pair.of((Object)"IS_NULLABLE", (Object)"YES")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"forbiddenDatasource"), Pair.of((Object)"COLUMN_NAME", (Object)"unique_dim1"), Pair.of((Object)"DATA_TYPE", (Object)1111), Pair.of((Object)"TYPE_NAME", (Object)"COMPLEX<hyperUnique>"), Pair.of((Object)"IS_NULLABLE", (Object)"YES"))), DruidAvaticaHandlerTest.getRows(metaData.getColumns(null, "dr_id", "forbiddenDatasource", null), (Set<String>)ImmutableSet.of((Object)"IS_NULLABLE", (Object)"TABLE_NAME", (Object)"TABLE_SCHEM", (Object)"COLUMN_NAME", (Object)"DATA_TYPE", (Object)"TYPE_NAME", (Object[])new String[0])));
    }

    @Test
    @Timeout(value=90000L, unit=TimeUnit.MILLISECONDS)
    public void testConcurrentQueries() {
        List integers;
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
        ListeningExecutorService exec = MoreExecutors.listeningDecorator((ExecutorService)Execs.multiThreaded((int)AVATICA_CONFIG.getMaxStatementsPerConnection(), (String)"DruidAvaticaHandlerTest-%d"));
        for (int i = 0; i < 2000; ++i) {
            String query = StringUtils.format((String)"SELECT COUNT(*) + %s AS ci FROM foo", (Object[])new Object[]{i});
            futures.add(exec.submit(() -> {
                try (Statement statement = this.client.createStatement();){
                    Integer n;
                    block14: {
                        ResultSet resultSet = statement.executeQuery(query);
                        try {
                            List<Map<String, Object>> rows = DruidAvaticaHandlerTest.getRows(resultSet);
                            n = ((Number)((Map)Iterables.getOnlyElement(rows)).get("ci")).intValue();
                            if (resultSet == null) break block14;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return n;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }));
        }
        try {
            integers = (List)Futures.allAsList(futures).get();
        }
        catch (InterruptedException e) {
            throw new RE((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new RE((Throwable)e);
        }
        for (int i = 0; i < 2000; ++i) {
            Assert.assertEquals((long)(i + 6), (long)((Integer)integers.get(i)).intValue());
        }
        exec.shutdown();
    }

    @Test
    public void testTooManyStatements() throws SQLException {
        for (int i = 0; i < 4; ++i) {
            this.client.createStatement();
        }
        AvaticaClientRuntimeException ex = (AvaticaClientRuntimeException)Assert.assertThrows(AvaticaClientRuntimeException.class, () -> this.client.createStatement());
        Assert.assertTrue((boolean)ex.getMessage().contains("Too many open statements, limit is 4"));
    }

    @Test
    public void testNotTooManyStatementsWhenYouCloseThem() throws SQLException {
        for (int i = 0; i < 8; ++i) {
            this.client.createStatement().close();
        }
    }

    @Test
    public void testManyUsesOfTheSameStatement() throws SQLException {
        try (Statement statement = this.client.createStatement();){
            for (int i = 0; i < 50; ++i) {
                ResultSet resultSet = statement.executeQuery("SELECT COUNT(*) AS cnt FROM druid.foo");
                Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"cnt", (Object)6L)), DruidAvaticaHandlerTest.getRows(resultSet));
            }
        }
    }

    @Test
    public void tesErrorsDoNotCloseStatements() throws SQLException {
        try (Statement statement = this.client.createStatement();){
            try {
                statement.executeQuery("SELECT SUM(nonexistent) FROM druid.foo");
                Assert.fail();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ResultSet resultSet = statement.executeQuery("SELECT COUNT(*) AS cnt FROM druid.foo");
            Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"cnt", (Object)6L)), DruidAvaticaHandlerTest.getRows(resultSet));
        }
    }

    @Test
    public void testNotTooManyStatementsWhenClosed() {
        for (int i = 0; i < 50; ++i) {
            try (Statement statement = this.client.createStatement();){
                statement.executeQuery("SELECT SUM(nonexistent) FROM druid.foo");
                Assert.fail();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Test
    public void testAutoReconnectOnNoSuchConnection() throws SQLException {
        for (int i = 0; i < 50; ++i) {
            ResultSet resultSet = this.client.createStatement().executeQuery("SELECT COUNT(*) AS cnt FROM druid.foo");
            Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"cnt", (Object)6L)), DruidAvaticaHandlerTest.getRows(resultSet));
            this.server.druidMeta.closeAllConnections();
        }
    }

    @Test
    public void testTooManyConnections() throws SQLException {
        this.client.createStatement();
        this.clientLosAngeles.createStatement();
        this.superuserClient.createStatement();
        this.clientNoTrailingSlash.createStatement();
        AvaticaClientRuntimeException ex = (AvaticaClientRuntimeException)Assert.assertThrows(AvaticaClientRuntimeException.class, () -> this.server.getUserConnection());
        Assert.assertTrue((boolean)ex.getMessage().contains("Too many connections"));
    }

    @Test
    public void testNotTooManyConnectionsWhenTheyAreClosed() throws SQLException {
        for (int i = 0; i < 8; ++i) {
            Connection connection = this.server.getUserConnection();
            if (connection == null) continue;
            connection.close();
        }
    }

    @Test
    public void testConnectionsCloseStatements() throws SQLException {
        for (int i = 0; i < 8; ++i) {
            try (Connection connection = this.server.getUserConnection();){
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery("SELECT COUNT(*) AS cnt FROM druid.foo");
                Assert.assertTrue((boolean)resultSet.next());
                continue;
            }
        }
    }

    private SqlStatementFactory makeStatementFactory() {
        return QueryFrameworkUtils.createSqlStatementFactory((SqlEngine)CalciteTests.createMockSqlEngine((QuerySegmentWalker)walker, conglomerate), new PlannerFactory(this.makeRootSchema(), this.operatorTable, this.macroTable, this.plannerConfig, AuthTestUtils.TEST_AUTHORIZER_MAPPER, CalciteTests.getJsonMapper(), "druid", new CalciteRulesManager((Set)ImmutableSet.of()), CalciteTests.createJoinableFactoryWrapper(), CatalogResolver.NULL_RESOLVER, new AuthConfig(), (PolicyEnforcer)NoopPolicyEnforcer.instance(), new DruidHookDispatcher()));
    }

    @Test
    public void testMaxRowsPerFrame() throws Exception {
        AvaticaServerConfig config = new AvaticaServerConfig();
        config.maxConnections = 2;
        config.maxStatementsPerConnection = 4;
        config.maxRowsPerFrame = 2;
        final ArrayList frames = new ArrayList();
        ScheduledExecutorService exec = Execs.scheduledSingleThreaded((String)"testMaxRowsPerFrame");
        DruidMeta smallFrameDruidMeta = new DruidMeta(this.makeStatementFactory(), config, new ErrorHandler(new ServerConfig()), exec, ((AuthenticatorMapper)this.injector.getInstance(AuthenticatorMapper.class)).getAuthenticatorChain(), new DruidJdbcResultSet.ResultFetcherFactory(config.fetchTimeoutMs)){

            public Meta.Frame fetch(Meta.StatementHandle statement, long offset, int fetchMaxRowCount) throws NoSuchStatementException, MissingResultsException {
                Meta.Frame frame = super.fetch(statement, offset, fetchMaxRowCount);
                frames.add(frame);
                return frame;
            }
        };
        ServerWrapper server = new ServerWrapper(smallFrameDruidMeta);
        Connection smallFrameClient = server.getUserConnection();
        ResultSet resultSet = smallFrameClient.createStatement().executeQuery("SELECT dim1 FROM druid.foo");
        List<Map<String, Object>> rows = DruidAvaticaHandlerTest.getRows(resultSet);
        Assert.assertEquals((long)2L, (long)frames.size());
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"dim1", (Object)""), (Object)ImmutableMap.of((Object)"dim1", (Object)"10.1"), (Object)ImmutableMap.of((Object)"dim1", (Object)"2"), (Object)ImmutableMap.of((Object)"dim1", (Object)"1"), (Object)ImmutableMap.of((Object)"dim1", (Object)"def"), (Object)ImmutableMap.of((Object)"dim1", (Object)"abc")), rows);
        resultSet.close();
        smallFrameClient.close();
        exec.shutdown();
        server.close();
    }

    @Test
    public void testMinRowsPerFrame() throws Exception {
        final AvaticaServerConfig config = new AvaticaServerConfig();
        config.maxConnections = 2;
        config.maxStatementsPerConnection = 4;
        config.minRowsPerFrame = 1000;
        final ArrayList frames = new ArrayList();
        ScheduledExecutorService exec = Execs.scheduledSingleThreaded((String)"testMaxRowsPerFrame");
        DruidMeta smallFrameDruidMeta = new DruidMeta(this.makeStatementFactory(), config, new ErrorHandler(new ServerConfig()), exec, ((AuthenticatorMapper)this.injector.getInstance(AuthenticatorMapper.class)).getAuthenticatorChain(), new DruidJdbcResultSet.ResultFetcherFactory(config.fetchTimeoutMs)){

            public Meta.Frame fetch(Meta.StatementHandle statement, long offset, int fetchMaxRowCount) throws NoSuchStatementException, MissingResultsException {
                Assert.assertEquals((long)config.minRowsPerFrame, (long)fetchMaxRowCount);
                Meta.Frame frame = super.fetch(statement, offset, fetchMaxRowCount);
                frames.add(frame);
                return frame;
            }
        };
        ServerWrapper server = new ServerWrapper(smallFrameDruidMeta);
        Connection smallFrameClient = server.getUserConnection();
        PreparedStatement statement = smallFrameClient.prepareStatement("SELECT dim1 FROM druid.foo");
        statement.setFetchSize(2);
        ResultSet resultSet = statement.executeQuery();
        List<Map<String, Object>> rows = DruidAvaticaHandlerTest.getRows(resultSet);
        Assert.assertEquals((long)0L, (long)frames.size());
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"dim1", (Object)""), (Object)ImmutableMap.of((Object)"dim1", (Object)"10.1"), (Object)ImmutableMap.of((Object)"dim1", (Object)"2"), (Object)ImmutableMap.of((Object)"dim1", (Object)"1"), (Object)ImmutableMap.of((Object)"dim1", (Object)"def"), (Object)ImmutableMap.of((Object)"dim1", (Object)"abc")), rows);
        resultSet.close();
        smallFrameClient.close();
        exec.shutdown();
        server.close();
    }

    @Test
    public void testSqlRequestLog() throws SQLException {
        Statement stmt3;
        this.testRequestLogger.clear();
        for (int i = 0; i < 3; ++i) {
            try (Statement stmt2 = this.client.createStatement();){
                stmt2.executeQuery("SELECT COUNT(*) AS cnt FROM druid.foo");
                continue;
            }
        }
        Assert.assertEquals((long)3L, (long)this.testRequestLogger.getSqlQueryLogs().size());
        for (RequestLogLine logLine : this.testRequestLogger.getSqlQueryLogs()) {
            Map stats = logLine.getQueryStats().getStats();
            Assert.assertEquals((Object)true, stats.get("success"));
            Assert.assertEquals((Object)"regularUser", stats.get("identity"));
            Assert.assertTrue((boolean)stats.containsKey("sqlQuery/time"));
            Assert.assertTrue((boolean)stats.containsKey("sqlQuery/planningTimeMs"));
            Assert.assertTrue((boolean)stats.containsKey("sqlQuery/bytes"));
        }
        this.testRequestLogger.clear();
        try {
            stmt3 = this.client.createStatement();
            try {
                stmt3.executeQuery("SELECT notexist FROM druid.foo");
                Assert.fail((String)"invalid SQL should throw SQLException");
            }
            finally {
                if (stmt3 != null) {
                    stmt3.close();
                }
            }
        }
        catch (SQLException stmt3) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)this.testRequestLogger.getSqlQueryLogs().size());
        Map stats = ((RequestLogLine)this.testRequestLogger.getSqlQueryLogs().get(0)).getQueryStats().getStats();
        Assert.assertEquals((Object)false, stats.get("success"));
        Assert.assertEquals((Object)"regularUser", stats.get("identity"));
        Assert.assertTrue((boolean)stats.containsKey("exception"));
        this.testRequestLogger.clear();
        try {
            stmt3 = this.client.createStatement();
            try {
                stmt3.executeQuery("SELECT count(*) FROM druid.forbiddenDatasource");
                Assert.fail((String)"unauthorzed SQL should throw SQLException");
            }
            finally {
                if (stmt3 != null) {
                    stmt3.close();
                }
            }
        }
        catch (SQLException stmt4) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)this.testRequestLogger.getSqlQueryLogs().size());
        stats = ((RequestLogLine)this.testRequestLogger.getSqlQueryLogs().get(0)).getQueryStats().getStats();
        Assert.assertEquals((Object)false, stats.get("success"));
        Assert.assertEquals((Object)"regularUser", stats.get("identity"));
        Assert.assertTrue((boolean)stats.containsKey("exception"));
    }

    @Test
    public void testSqlRequestLogPrepared() throws SQLException {
        PreparedStatement stmt3;
        this.testRequestLogger.clear();
        for (int i = 0; i < 3; ++i) {
            try (PreparedStatement stmt2 = this.client.prepareStatement("SELECT COUNT(*) AS cnt FROM druid.foo");){
                stmt2.execute();
                continue;
            }
        }
        Assert.assertEquals((long)6L, (long)this.testRequestLogger.getSqlQueryLogs().size());
        for (RequestLogLine logLine : this.testRequestLogger.getSqlQueryLogs()) {
            Map stats = logLine.getQueryStats().getStats();
            Assert.assertEquals((Object)true, stats.get("success"));
            Assert.assertEquals((Object)"regularUser", stats.get("identity"));
            Assert.assertTrue((boolean)stats.containsKey("sqlQuery/time"));
            Assert.assertTrue((boolean)stats.containsKey("sqlQuery/planningTimeMs"));
            Assert.assertTrue((boolean)stats.containsKey("sqlQuery/bytes"));
        }
        this.testRequestLogger.clear();
        try {
            stmt3 = this.client.prepareStatement("SELECT notexist FROM druid.foo");
            try {
                Assert.fail((String)"invalid SQL should throw SQLException");
            }
            finally {
                if (stmt3 != null) {
                    stmt3.close();
                }
            }
        }
        catch (SQLException stmt3) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)this.testRequestLogger.getSqlQueryLogs().size());
        Map stats = ((RequestLogLine)this.testRequestLogger.getSqlQueryLogs().get(0)).getQueryStats().getStats();
        Assert.assertEquals((Object)false, stats.get("success"));
        Assert.assertEquals((Object)"regularUser", stats.get("identity"));
        Assert.assertTrue((boolean)stats.containsKey("exception"));
        this.testRequestLogger.clear();
        try {
            stmt3 = this.client.prepareStatement("SELECT count(*) FROM druid.forbiddenDatasource");
            try {
                Assert.fail((String)"unauthorzed SQL should throw SQLException");
            }
            finally {
                if (stmt3 != null) {
                    stmt3.close();
                }
            }
        }
        catch (SQLException stmt4) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)this.testRequestLogger.getSqlQueryLogs().size());
        stats = ((RequestLogLine)this.testRequestLogger.getSqlQueryLogs().get(0)).getQueryStats().getStats();
        Assert.assertEquals((Object)false, stats.get("success"));
        Assert.assertEquals((Object)"regularUser", stats.get("identity"));
        Assert.assertTrue((boolean)stats.containsKey("exception"));
    }

    @Test
    public void testParameterBinding() throws SQLException {
        try (PreparedStatement statement = this.client.prepareStatement("SELECT COUNT(*) AS cnt FROM druid.foo WHERE dim1 = ? OR dim1 = ?");){
            statement.setString(1, "abc");
            statement.setString(2, "def");
            ResultSet resultSet = statement.executeQuery();
            List<Map<String, Object>> rows = DruidAvaticaHandlerTest.getRows(resultSet);
            Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"cnt", (Object)2L)), rows);
        }
    }

    @Test
    public void testSysTableParameterBindingRegularUser() throws SQLException {
        try (PreparedStatement statement = this.client.prepareStatement("SELECT COUNT(*) AS cnt FROM sys.servers WHERE servers.host = ?");){
            statement.setString(1, DUMMY_SQL_QUERY_ID);
            Assert.assertThrows((String)"Insufficient permission to view servers", AvaticaSqlException.class, statement::executeQuery);
        }
    }

    @Test
    public void testSysTableParameterBindingSuperUser() throws SQLException {
        try (PreparedStatement statement = this.superuserClient.prepareStatement("SELECT COUNT(*) AS cnt FROM sys.servers WHERE servers.host = ?");){
            statement.setString(1, DUMMY_SQL_QUERY_ID);
            Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"cnt", (Object)1L)), DruidAvaticaHandlerTest.getRows(statement.executeQuery()));
        }
    }

    @Test
    public void testExecuteMany() throws SQLException {
        try (PreparedStatement statement = this.superuserClient.prepareStatement("SELECT COUNT(*) AS cnt FROM sys.servers WHERE servers.host = ?");){
            statement.setString(1, DUMMY_SQL_QUERY_ID);
            Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"cnt", (Object)1L)), DruidAvaticaHandlerTest.getRows(statement.executeQuery()));
            statement.setString(1, "foo");
            Assert.assertEquals(Collections.emptyList(), DruidAvaticaHandlerTest.getRows(statement.executeQuery()));
            statement.setString(1, DUMMY_SQL_QUERY_ID);
            Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"cnt", (Object)1L)), DruidAvaticaHandlerTest.getRows(statement.executeQuery()));
        }
    }

    @Test
    public void testExtendedCharacters() throws SQLException {
        List<Map<String, Object>> rows;
        try (Statement stmt = this.client.createStatement();){
            ResultSet resultSet = stmt.executeQuery("SELECT COUNT(*) AS cnt FROM druid.lotsocolumns WHERE dimMultivalEnumerated = '\u3151 \u3153 \u3155 \u3157 \u315b \u315c \u3160 \u3161 \u3163'");
            rows = DruidAvaticaHandlerTest.getRows(resultSet);
            Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"cnt", (Object)1L)), rows);
        }
        try (PreparedStatement statement = this.client.prepareStatement("SELECT COUNT(*) AS cnt FROM druid.lotsocolumns WHERE dimMultivalEnumerated = ?");){
            statement.setString(1, "\u3151 \u3153 \u3155 \u3157 \u315b \u315c \u3160 \u3161 \u3163");
            ResultSet resultSet2 = statement.executeQuery();
            rows = DruidAvaticaHandlerTest.getRows(resultSet2);
            Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"cnt", (Object)1L)), rows);
        }
    }

    @Test
    public void testEscapingForGetColumns() throws SQLException {
        DatabaseMetaData metaData = this.client.getMetaData();
        ImmutableList someDatasourceColumns = ImmutableList.of(DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"some_datasource"), Pair.of((Object)"COLUMN_NAME", (Object)"__time")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"some_datasource"), Pair.of((Object)"COLUMN_NAME", (Object)"dim1")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"some_datasource"), Pair.of((Object)"COLUMN_NAME", (Object)"dim2")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"some_datasource"), Pair.of((Object)"COLUMN_NAME", (Object)"dim3")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"some_datasource"), Pair.of((Object)"COLUMN_NAME", (Object)"cnt")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"some_datasource"), Pair.of((Object)"COLUMN_NAME", (Object)"m1")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"some_datasource"), Pair.of((Object)"COLUMN_NAME", (Object)"m2")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"some_datasource"), Pair.of((Object)"COLUMN_NAME", (Object)"unique_dim1")));
        Assert.assertEquals((Object)someDatasourceColumns, DruidAvaticaHandlerTest.getRows(metaData.getColumns(null, "dr_id", "some\\_datasource", null), (Set<String>)ImmutableSet.of((Object)"TABLE_NAME", (Object)"TABLE_SCHEM", (Object)"COLUMN_NAME")));
        ImmutableList someXDatasourceColumns = ImmutableList.of(DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"somexdatasource"), Pair.of((Object)"COLUMN_NAME", (Object)"__time")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"somexdatasource"), Pair.of((Object)"COLUMN_NAME", (Object)"cnt_x")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"somexdatasource"), Pair.of((Object)"COLUMN_NAME", (Object)"m1_x")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"somexdatasource"), Pair.of((Object)"COLUMN_NAME", (Object)"m2_x")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"somexdatasource"), Pair.of((Object)"COLUMN_NAME", (Object)"unique_dim1_x")));
        Assert.assertEquals((Object)someXDatasourceColumns, DruidAvaticaHandlerTest.getRows(metaData.getColumns(null, "dr_id", "somexdatasource", null), (Set<String>)ImmutableSet.of((Object)"TABLE_NAME", (Object)"TABLE_SCHEM", (Object)"COLUMN_NAME")));
        ArrayList columnsOfBothTables = new ArrayList(someDatasourceColumns);
        columnsOfBothTables.addAll(someXDatasourceColumns);
        Assert.assertEquals(columnsOfBothTables, DruidAvaticaHandlerTest.getRows(metaData.getColumns(null, "dr_id", "some_datasource", null), (Set<String>)ImmutableSet.of((Object)"TABLE_NAME", (Object)"TABLE_SCHEM", (Object)"COLUMN_NAME")));
        Assert.assertEquals((Object)ImmutableList.of(DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"somexdatasource"), Pair.of((Object)"COLUMN_NAME", (Object)"m1_x")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"somexdatasource"), Pair.of((Object)"COLUMN_NAME", (Object)"m2_x"))), DruidAvaticaHandlerTest.getRows(metaData.getColumns("druid", "dr_id", "somexdatasource", "m_\\_x"), (Set<String>)ImmutableSet.of((Object)"TABLE_NAME", (Object)"TABLE_SCHEM", (Object)"COLUMN_NAME")));
        Assert.assertEquals((Object)ImmutableList.of(DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"some_datasource"), Pair.of((Object)"COLUMN_NAME", (Object)"m1")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"some_datasource"), Pair.of((Object)"COLUMN_NAME", (Object)"m2")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"somexdatasource"), Pair.of((Object)"COLUMN_NAME", (Object)"m1_x")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"somexdatasource"), Pair.of((Object)"COLUMN_NAME", (Object)"m2_x"))), DruidAvaticaHandlerTest.getRows(metaData.getColumns("druid", "dr_id", "some_datasource", "m%"), (Set<String>)ImmutableSet.of((Object)"TABLE_NAME", (Object)"TABLE_SCHEM", (Object)"COLUMN_NAME")));
    }

    @Test
    public void testEscapingForGetTables() throws SQLException {
        DatabaseMetaData metaData = this.client.getMetaData();
        Assert.assertEquals((Object)ImmutableList.of(DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"some_datasource"))), DruidAvaticaHandlerTest.getRows(metaData.getTables("druid", "dr_id", "some\\_datasource", null), (Set<String>)ImmutableSet.of((Object)"TABLE_SCHEM", (Object)"TABLE_NAME")));
        Assert.assertEquals((Object)ImmutableList.of(DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"somexdatasource"))), DruidAvaticaHandlerTest.getRows(metaData.getTables("druid", "dr_id", "somexdatasource", null), (Set<String>)ImmutableSet.of((Object)"TABLE_SCHEM", (Object)"TABLE_NAME")));
        Assert.assertEquals((Object)ImmutableList.of(DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"some_datasource")), DruidAvaticaHandlerTest.row(Pair.of((Object)"TABLE_SCHEM", (Object)"druid"), Pair.of((Object)"TABLE_NAME", (Object)"somexdatasource"))), DruidAvaticaHandlerTest.getRows(metaData.getTables("druid", "dr_id", "some_datasource", null), (Set<String>)ImmutableSet.of((Object)"TABLE_SCHEM", (Object)"TABLE_NAME")));
    }

    @Test
    public void testArrayStuff() throws SQLException {
        try (PreparedStatement statement = this.client.prepareStatement("SELECT ARRAY_AGG(dim2) AS arr1, ARRAY_AGG(l1) AS arr2, ARRAY_AGG(dbl1)  AS arr3, ARRAY_AGG(f1) AS arr4 FROM druid.numfoo");){
            ResultSet resultSet = statement.executeQuery();
            List<Map<String, Object>> rows = DruidAvaticaHandlerTest.getRows(resultSet);
            Assert.assertEquals((long)1L, (long)rows.size());
            Assert.assertTrue((boolean)rows.get(0).containsKey("arr1"));
            Assert.assertTrue((boolean)rows.get(0).containsKey("arr2"));
            Assert.assertTrue((boolean)rows.get(0).containsKey("arr3"));
            Assert.assertTrue((boolean)rows.get(0).containsKey("arr4"));
            Assert.assertArrayEquals((Object[])new Object[]{"a", null, "", "a", "abc", null}, (Object[])((Object[])rows.get(0).get("arr1")));
            Assert.assertArrayEquals((Object[])new Object[]{7L, 325323L, 0L, null, null, null}, (Object[])((Object[])rows.get(0).get("arr2")));
            Assert.assertArrayEquals((Object[])new Object[]{1.0, 1.7, 0.0, null, null, null}, (Object[])((Object[])rows.get(0).get("arr3")));
            Assert.assertArrayEquals((Object[])new Object[]{1.0, (double)0.1f, 0.0, null, null, null}, (Object[])((Object[])rows.get(0).get("arr4")));
        }
    }

    @Test
    public void testUnauthorizedTable() {
        String query = "SELECT * FROM forbiddenDatasource";
        String expectedError = "Error 2 (00002) : Error while executing SQL \"SELECT * FROM forbiddenDatasource\": Remote driver error: Unauthorized";
        try (Statement statement = this.client.createStatement();){
            statement.executeQuery("SELECT * FROM forbiddenDatasource");
        }
        catch (SQLException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"Error 2 (00002) : Error while executing SQL \"SELECT * FROM forbiddenDatasource\": Remote driver error: Unauthorized");
            return;
        }
        Assert.fail((String)"Test failed, did not get SQLException");
    }

    @Test
    public void testAsync() throws Exception {
        final AvaticaServerConfig config = new AvaticaServerConfig();
        config.maxConnections = 4;
        config.maxStatementsPerConnection = 4;
        config.maxRowsPerFrame = 2;
        config.fetchTimeoutMs = 1;
        final ArrayList frames = new ArrayList();
        ScheduledExecutorService exec = Execs.scheduledSingleThreaded((String)"testMaxRowsPerFrame");
        final CountDownLatch startLatch = new CountDownLatch(1);
        final CountDownLatch resultsLatch = new CountDownLatch(1);
        DruidMeta druidMeta = new DruidMeta(this.makeStatementFactory(), config, new ErrorHandler(new ServerConfig()), exec, ((AuthenticatorMapper)this.injector.getInstance(AuthenticatorMapper.class)).getAuthenticatorChain(), new DruidJdbcResultSet.ResultFetcherFactory(config.fetchTimeoutMs){

            public int fetchTimeoutMs() {
                return config.fetchTimeoutMs;
            }

            public DruidJdbcResultSet.ResultFetcher newFetcher(int limit, Yielder<Object[]> yielder) {
                return new DruidJdbcResultSet.ResultFetcher(limit, yielder){

                    public Meta.Frame call() {
                        try {
                            if (this.offset() == 0) {
                                startLatch.await();
                            }
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                        Meta.Frame retVal = super.call();
                        resultsLatch.countDown();
                        return retVal;
                    }
                };
            }
        }){

            public Meta.Frame fetch(Meta.StatementHandle statement, long offset, int fetchMaxRowCount) throws NoSuchStatementException, MissingResultsException {
                if (frames.size() == 3) {
                    startLatch.countDown();
                    try {
                        resultsLatch.await();
                    }
                    catch (InterruptedException e) {
                        throw new RE((Throwable)e);
                    }
                }
                Meta.Frame frame = super.fetch(statement, offset, fetchMaxRowCount);
                frames.add(frame);
                return frame;
            }
        };
        ServerWrapper server = new ServerWrapper(druidMeta);
        try (Connection conn = server.getUserConnection();
             ResultSet resultSet = conn.createStatement().executeQuery("SELECT dim1 FROM druid.foo");){
            List<Map<String, Object>> rows = DruidAvaticaHandlerTest.getRows(resultSet);
            Assert.assertEquals((long)6L, (long)rows.size());
            Assert.assertEquals((long)6L, (long)frames.size());
            Assert.assertFalse((boolean)((Meta.Frame)frames.get((int)0)).rows.iterator().hasNext());
            Assert.assertFalse((boolean)((Meta.Frame)frames.get((int)1)).rows.iterator().hasNext());
            Assert.assertFalse((boolean)((Meta.Frame)frames.get((int)2)).rows.iterator().hasNext());
            Assert.assertTrue((boolean)((Meta.Frame)frames.get((int)3)).rows.iterator().hasNext());
            Assert.assertTrue((boolean)((Meta.Frame)frames.get((int)4)).rows.iterator().hasNext());
            Assert.assertTrue((boolean)((Meta.Frame)frames.get((int)5)).rows.iterator().hasNext());
        }
        this.testWithJDBI(server.url);
        exec.shutdown();
        server.close();
    }

    @Test
    public void testMultiStatementFails() throws SQLException {
        try (Statement stmt = this.client.createStatement();){
            Throwable t = Assert.assertThrows(AvaticaSqlException.class, () -> stmt.executeQuery("SET useApproxCountDistinct = true; SELECT COUNT(DISTINCT dim1) AS cnt FROM druid.foo"));
            Assert.assertEquals((Object)"Error -1 (00000) : Error while executing SQL \"SET useApproxCountDistinct = true; SELECT COUNT(DISTINCT dim1) AS cnt FROM druid.foo\": Remote driver error: QueryInterruptedException: SQL query string must contain only a single statement -> DruidException: SQL query string must contain only a single statement", (Object)t.getMessage());
        }
    }

    @Test
    public void testMultiPreparedStatementFails() throws SQLException {
        Throwable t = Assert.assertThrows(AvaticaSqlException.class, () -> this.client.prepareStatement("SET vectorize = 'force'; SELECT COUNT(*) AS cnt FROM druid.foo"));
        Assert.assertEquals((Object)"Error -1 (00000) : while preparing SQL: SET vectorize = 'force'; SELECT COUNT(*) AS cnt FROM druid.foo", (Object)t.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testWithJDBI(String baseUrl) {
        String url = baseUrl + "?user=regularUser&password=druid" + this.getJdbcUrlTail();
        System.out.println(url);
        DBI dbi = new DBI(url);
        try (Handle handle = dbi.open();){
            ResultIterator iter = handle.createQuery("SELECT __time, dim1 FROM druid.foo").map((index, row, ctx) -> new Pair((Object)row.getLong(1), (Object)row.getString(2))).iterator();
            int count = 0;
            while (iter.hasNext()) {
                Pair row2 = (Pair)iter.next();
                Assert.assertNotNull((Object)row2.lhs);
                Assert.assertNotNull((Object)row2.rhs);
                ++count;
            }
            Assert.assertEquals((long)6L, (long)count);
        }
    }

    private static List<Map<String, Object>> getRows(ResultSet resultSet) throws SQLException {
        return DruidAvaticaHandlerTest.getRows(resultSet, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Map<String, Object>> getRows(ResultSet resultSet, Set<String> returnKeys) throws SQLException {
        try {
            ResultSetMetaData metaData = resultSet.getMetaData();
            ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
            while (resultSet.next()) {
                HashMap<String, Object> row = new HashMap<String, Object>();
                for (int i = 0; i < metaData.getColumnCount(); ++i) {
                    if (returnKeys != null && !returnKeys.contains(metaData.getColumnLabel(i + 1))) continue;
                    Object result = resultSet.getObject(i + 1);
                    if (result instanceof Array) {
                        row.put(metaData.getColumnLabel(i + 1), ((Array)result).getArray());
                        continue;
                    }
                    row.put(metaData.getColumnLabel(i + 1), result);
                }
                rows.add(row);
            }
            ArrayList<Map<String, Object>> arrayList = rows;
            return arrayList;
        }
        finally {
            resultSet.close();
        }
    }

    @SafeVarargs
    private static Map<String, Object> row(Pair<String, ?> ... entries) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (Pair<String, ?> entry : entries) {
            m.put((String)entry.lhs, entry.rhs);
        }
        return m;
    }

    static {
        DruidAvaticaHandlerTest.AVATICA_CONFIG.maxConnections = 4;
        DruidAvaticaHandlerTest.AVATICA_CONFIG.maxStatementsPerConnection = 4;
        System.setProperty("user.timezone", "UTC");
    }

    private class ServerWrapper {
        final DruidMeta druidMeta;
        final Server server;
        final String url;

        ServerWrapper(DruidMeta druidMeta) throws Exception {
            this.druidMeta = druidMeta;
            this.server = new Server(new InetSocketAddress("localhost", 0));
            this.server.setHandler((Handler)DruidAvaticaHandlerTest.this.getAvaticaHandler(druidMeta));
            this.server.start();
            this.url = StringUtils.format((String)"jdbc:avatica:remote:url=%s%s", (Object[])new Object[]{this.server.getURI().toString(), StringUtils.maybeRemoveLeadingSlash((String)DruidAvaticaHandlerTest.this.getJdbcUrlTail())});
        }

        public Connection getConnection(String user, String password) throws SQLException {
            Properties props = new Properties();
            props.setProperty("user", user);
            props.setProperty("password", password);
            props.setProperty(BuiltInConnectionProperty.TRANSPARENT_RECONNECTION.camelName(), "true");
            return DriverManager.getConnection(this.url, props);
        }

        public Connection getUserConnection() throws SQLException {
            return this.getConnection("regularUser", "druid");
        }

        public void close() throws Exception {
            this.druidMeta.closeAllConnections();
            this.server.stop();
        }
    }

    private static class TestResultFetcher
    extends DruidJdbcResultSet.ResultFetcher {
        public TestResultFetcher(int limit, Yielder<Object[]> yielder) {
            super(limit, yielder);
        }

        public Meta.Frame call() {
            try {
                if (this.offset() == 0) {
                    System.out.println("Taking a nap now...");
                    Thread.sleep(3000L);
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return super.call();
        }
    }
}

