/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.avatica;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import java.util.Properties;
import java.util.Set;
import javax.validation.Validation;
import javax.validation.Validator;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.JsonConfigurator;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.jackson.JacksonModule;
import org.apache.druid.java.util.metrics.Monitor;
import org.apache.druid.server.DruidNode;
import org.apache.druid.sql.avatica.AvaticaModule;
import org.apache.druid.sql.avatica.AvaticaMonitor;
import org.apache.druid.sql.avatica.AvaticaServerConfig;
import org.apache.druid.sql.avatica.DruidAvaticaJsonHandler;
import org.apache.druid.sql.avatica.DruidAvaticaProtobufHandler;
import org.apache.druid.sql.avatica.DruidMeta;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.Mock;
import org.eclipse.jetty.server.Handler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class AvaticaModuleTest {
    private static final String HOST_AND_PORT = "HOST_AND_PORT";
    @Mock
    private DruidNode druidNode;
    @Mock
    private DruidMeta druidMeta;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private AvaticaModule target;
    private Injector injector;

    @Before
    public void setUp() {
        EasyMock.expect((Object)this.druidNode.getHostAndPortToUse()).andStubReturn((Object)HOST_AND_PORT);
        EasyMock.replay((Object[])new Object[]{this.druidNode});
        this.target = new AvaticaModule();
        this.injector = Guice.createInjector((Module[])new Module[]{new JacksonModule(), binder -> {
            binder.bind(Validator.class).toInstance((Object)Validation.buildDefaultValidatorFactory().getValidator());
            binder.bindScope(LazySingleton.class, Scopes.SINGLETON);
            binder.bind(DruidNode.class).annotatedWith(Self.class).toInstance((Object)this.druidNode);
            binder.bind(DruidMeta.class).toInstance((Object)this.druidMeta);
        }, this.target});
    }

    @Test
    public void testAvaticaMonitorIsInjectedAsSingleton() {
        AvaticaMonitor monitor = (AvaticaMonitor)this.injector.getInstance(AvaticaMonitor.class);
        Assert.assertNotNull((Object)monitor);
        AvaticaMonitor other = (AvaticaMonitor)this.injector.getInstance(AvaticaMonitor.class);
        Assert.assertSame((Object)monitor, (Object)other);
    }

    @Test
    public void testAvaticaMonitorIsRegisterdWithMetricsModule() {
        Set monitors = (Set)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<Class<? extends Monitor>>>(){}));
        Assert.assertTrue((boolean)monitors.contains(AvaticaMonitor.class));
    }

    @Test
    public void testAvaticaServerConfigIsInjectable() {
        AvaticaServerConfig config = (AvaticaServerConfig)this.injector.getInstance(AvaticaServerConfig.class);
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((long)AvaticaServerConfig.DEFAULT_MAX_CONNECTIONS, (long)config.getMaxConnections());
        Assert.assertEquals((long)AvaticaServerConfig.DEFAULT_MAX_STATEMENTS_PER_CONNECTION, (long)config.getMaxStatementsPerConnection());
        Assert.assertEquals((Object)AvaticaServerConfig.DEFAULT_CONNECTION_IDLE_TIMEOUT, (Object)config.getConnectionIdleTimeout());
        Assert.assertEquals((long)AvaticaServerConfig.DEFAULT_MIN_ROWS_PER_FRAME, (long)config.getMinRowsPerFrame());
        Assert.assertEquals((long)AvaticaServerConfig.DEFAULT_MAX_ROWS_PER_FRAME, (long)config.getMaxRowsPerFrame());
    }

    @Test
    public void testAvaticaServerConfigProperties() {
        Properties properties = new Properties();
        JsonConfigProvider provider = JsonConfigProvider.of((String)"druid.sql.avatica", AvaticaServerConfig.class);
        properties.setProperty("druid.sql.avatica.maxRowsPerFrame", "50000");
        properties.setProperty("druid.sql.avatica.minRowsPerFrame", "10000");
        provider.inject(properties, (JsonConfigurator)this.injector.getInstance(JsonConfigurator.class));
        AvaticaServerConfig config = (AvaticaServerConfig)provider.get();
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((long)AvaticaServerConfig.DEFAULT_MAX_CONNECTIONS, (long)config.getMaxConnections());
        Assert.assertEquals((long)AvaticaServerConfig.DEFAULT_MAX_STATEMENTS_PER_CONNECTION, (long)config.getMaxStatementsPerConnection());
        Assert.assertEquals((Object)AvaticaServerConfig.DEFAULT_CONNECTION_IDLE_TIMEOUT, (Object)config.getConnectionIdleTimeout());
        Assert.assertEquals((long)10000L, (long)config.getMinRowsPerFrame());
        Assert.assertEquals((long)50000L, (long)config.getMaxRowsPerFrame());
    }

    @Test
    public void testAvaticaServerConfigPropertiesSmallerMaxIsAlsoMin() {
        Properties properties = new Properties();
        JsonConfigProvider provider = JsonConfigProvider.of((String)"druid.sql.avatica", AvaticaServerConfig.class);
        properties.setProperty("druid.sql.avatica.maxRowsPerFrame", "50");
        provider.inject(properties, (JsonConfigurator)this.injector.getInstance(JsonConfigurator.class));
        AvaticaServerConfig config = (AvaticaServerConfig)provider.get();
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((long)AvaticaServerConfig.DEFAULT_MAX_CONNECTIONS, (long)config.getMaxConnections());
        Assert.assertEquals((long)AvaticaServerConfig.DEFAULT_MAX_STATEMENTS_PER_CONNECTION, (long)config.getMaxStatementsPerConnection());
        Assert.assertEquals((Object)AvaticaServerConfig.DEFAULT_CONNECTION_IDLE_TIMEOUT, (Object)config.getConnectionIdleTimeout());
        Assert.assertEquals((long)50L, (long)config.getMinRowsPerFrame());
        Assert.assertEquals((long)50L, (long)config.getMaxRowsPerFrame());
    }

    @Test
    public void testAvaticaServerConfigPropertiesBadMinRowsPerFrame() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("'druid.sql.avatica.minRowsPerFrame' must be set to a value greater than 0");
        Properties properties = new Properties();
        JsonConfigProvider provider = JsonConfigProvider.of((String)"druid.sql.avatica", AvaticaServerConfig.class);
        properties.setProperty("druid.sql.avatica.minRowsPerFrame", "-1");
        provider.inject(properties, (JsonConfigurator)this.injector.getInstance(JsonConfigurator.class));
        AvaticaServerConfig config = (AvaticaServerConfig)provider.get();
        Assert.assertNotNull((Object)config);
        config.getMinRowsPerFrame();
    }

    @Test
    public void testDruidAvaticaJsonHandlerIsInjected() {
        DruidAvaticaJsonHandler handler = (DruidAvaticaJsonHandler)this.injector.getInstance(DruidAvaticaJsonHandler.class);
        Assert.assertNotNull((Object)handler);
        DruidAvaticaJsonHandler other = (DruidAvaticaJsonHandler)this.injector.getInstance(DruidAvaticaJsonHandler.class);
        Assert.assertNotSame((Object)handler, (Object)other);
    }

    @Test
    public void testDruidAvaticaProtobufHandlerIsInjected() {
        DruidAvaticaProtobufHandler handler = (DruidAvaticaProtobufHandler)this.injector.getInstance(DruidAvaticaProtobufHandler.class);
        Assert.assertNotNull((Object)handler);
        DruidAvaticaProtobufHandler other = (DruidAvaticaProtobufHandler)this.injector.getInstance(DruidAvaticaProtobufHandler.class);
        Assert.assertNotSame((Object)handler, (Object)other);
    }

    @Test
    public void testDruidAvaticaJsonHandlerIsRegisterdWithJerseyModule() {
        Set handlers = (Set)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<Handler>>(){}));
        Assert.assertTrue((boolean)handlers.stream().anyMatch(h -> DruidAvaticaJsonHandler.class.equals(h.getClass())));
    }

    @Test
    public void testDruidAvaticaProtobufHandlerIsRegisterdWithJerseyModule() {
        Set handlers = (Set)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<Handler>>(){}));
        Assert.assertTrue((boolean)handlers.stream().anyMatch(h -> DruidAvaticaProtobufHandler.class.equals(h.getClass())));
    }
}

