/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql;

import org.apache.druid.error.DruidException;
import org.apache.druid.error.DruidExceptionMatcher;
import org.apache.druid.sql.SqlQueryPlus;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class SqlQueryPlusTest {
    @Test
    public void testSyntaxError() {
        DruidException e = (DruidException)Assert.assertThrows(DruidException.class, () -> SqlQueryPlus.builder((String)"SELECT COUNT(*) AS cnt, 'foo' AS").auth(CalciteTests.REGULAR_USER_AUTH_RESULT).build());
        MatcherAssert.assertThat((Object)e, (Matcher)DruidExceptionMatcher.invalidSqlInput().expectMessageContains("Incorrect syntax near the keyword 'AS' at line 1, column 31"));
    }

    @Test
    public void testSyntaxErrorJdbc() {
        SqlQueryPlus sqlQueryPlus = SqlQueryPlus.builder((String)"SELECT COUNT(*) AS cnt, 'foo' AS").auth(CalciteTests.REGULAR_USER_AUTH_RESULT).buildJdbc();
        DruidException e = (DruidException)Assert.assertThrows(DruidException.class, () -> ((SqlQueryPlus)sqlQueryPlus).freshCopy());
        MatcherAssert.assertThat((Object)e, (Matcher)DruidExceptionMatcher.invalidSqlInput().expectMessageContains("Incorrect syntax near the keyword 'AS' at line 1, column 31"));
    }
}

