/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.quidem;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.name.Named;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.calcite.avatica.server.AbstractAvaticaHandler;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.quidem.DruidConnectionExtras;
import org.apache.druid.quidem.DynamicComposite;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.SpecificSegmentsQuerySegmentWalker;
import org.apache.druid.sql.avatica.AvaticaMonitor;
import org.apache.druid.sql.avatica.DruidAvaticaJsonHandler;
import org.apache.druid.sql.avatica.DruidMeta;
import org.apache.druid.sql.calcite.SqlTestFrameworkConfig;
import org.apache.druid.sql.calcite.util.DruidModuleCollection;
import org.apache.druid.sql.calcite.util.SqlTestFramework;
import org.apache.druid.sql.hook.DruidHookDispatcher;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;

public class DruidAvaticaTestDriver
implements Driver {
    public static final String SCHEME = "druidtest";
    public static final String URI_PREFIX = "druidtest://";
    public static final String DEFAULT_URI = "druidtest:///";
    static final SqlTestFrameworkConfig.SqlTestFrameworkConfigStore CONFIG_STORE;

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        try {
            SqlTestFrameworkConfig config = SqlTestFrameworkConfig.fromURL(url);
            SqlTestFrameworkConfig.ConfigurationInstance ci = CONFIG_STORE.getConfigurationInstance(config);
            AvaticaJettyServer server = (AvaticaJettyServer)ci.framework.injector().getInstance(AvaticaJettyServer.class);
            return server.getConnection(info);
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw new Error("Can't create testconnection", e);
        }
    }

    protected File createTempFolder(String prefix) {
        final File tempDir = FileUtils.createTempDir((String)prefix);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    FileUtils.deleteDirectory((File)tempDir);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        });
        return tempDir;
    }

    private void register() {
        try {
            DriverManager.registerDriver(this);
        }
        catch (SQLException e) {
            System.out.println("Error occurred while registering JDBC driver " + this.getClass().getName() + ": " + String.valueOf(e));
        }
    }

    @Override
    public boolean acceptsURL(String url) {
        return url.startsWith(URI_PREFIX);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        throw new RuntimeException("Unimplemented method!");
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() {
        return Logger.getLogger("");
    }

    static {
        new DruidAvaticaTestDriver().register();
        CONFIG_STORE = new SqlTestFrameworkConfig.SqlTestFrameworkConfigStore(x -> new AvaticaBasedTestConnectionSupplier((SqlTestFramework.QueryComponentSupplier)x));
    }

    static class AvaticaJettyServer
    implements Closeable {
        final DruidMeta druidMeta;
        final Server server;
        final String url;
        final DruidConnectionExtras connectionExtras;

        AvaticaJettyServer(DruidMeta druidMeta, DruidConnectionExtras druidConnectionExtras) throws Exception {
            this.druidMeta = druidMeta;
            this.server = new Server(new InetSocketAddress("localhost", 0));
            this.server.setHandler((Handler)this.getAvaticaHandler(druidMeta));
            this.server.start();
            this.url = StringUtils.format((String)"jdbc:avatica:remote:url=%s", (Object[])new Object[]{new URIBuilder(this.server.getURI()).setPath("/druid/v2/sql/avatica/").build()});
            this.connectionExtras = druidConnectionExtras;
        }

        public Connection getConnection(Properties info) throws SQLException {
            Connection realConnection = DriverManager.getConnection(this.url, info);
            Connection proxyConnection = DynamicComposite.make(realConnection, Connection.class, this.connectionExtras, DruidConnectionExtras.class);
            return proxyConnection;
        }

        @Override
        public void close() {
            this.druidMeta.closeAllConnections();
            try {
                this.server.stop();
            }
            catch (Exception e) {
                throw new RuntimeException("Can't stop server", e);
            }
        }

        protected AbstractAvaticaHandler getAvaticaHandler(DruidMeta druidMeta) {
            return new DruidAvaticaJsonHandler(druidMeta, new DruidNode("dummy", "dummy", false, Integer.valueOf(1), null, true, false), new AvaticaMonitor());
        }
    }

    static class AvaticaBasedTestConnectionSupplier
    extends SqlTestFramework.QueryComponentSupplierDelegate {
        private AvaticaBasedConnectionModule connectionModule = new AvaticaBasedConnectionModule();

        public AvaticaBasedTestConnectionSupplier(SqlTestFramework.QueryComponentSupplier delegate) {
            super(delegate);
        }

        @Override
        public DruidModule getOverrideModule() {
            return DruidModuleCollection.of(new Module[]{super.getOverrideModule(), this.connectionModule});
        }

        @Override
        public void close() throws IOException {
            this.connectionModule.close();
            super.close();
        }
    }

    static class AvaticaBasedConnectionModule
    implements DruidModule,
    Closeable {
        Closer closer = Closer.create();

        AvaticaBasedConnectionModule() {
        }

        @Provides
        @LazySingleton
        public DruidConnectionExtras getConnectionExtras(ObjectMapper objectMapper, DruidHookDispatcher druidHookDispatcher, @Named(value="isExplainSupported") Boolean isExplainSupported, SpecificSegmentsQuerySegmentWalker walker, Injector injector) {
            return new DruidConnectionExtras.DruidConnectionExtrasImpl(objectMapper, druidHookDispatcher, isExplainSupported, walker, injector);
        }

        @Provides
        @LazySingleton
        public AvaticaJettyServer getAvaticaServer(DruidMeta druidMeta, DruidConnectionExtras druidConnectionExtras) throws Exception {
            AvaticaJettyServer avaticaJettyServer = new AvaticaJettyServer(druidMeta, druidConnectionExtras);
            this.closer.register((Closeable)avaticaJettyServer);
            return avaticaJettyServer;
        }

        public void configure(Binder binder) {
        }

        @Override
        public void close() throws IOException {
            this.closer.close();
        }
    }
}

