/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.operator.OperatorFactory;
import org.apache.druid.query.operator.WindowOperatorQuery;
import org.apache.druid.query.spec.LegacySegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.column.RowSignature;

public class WindowOperatorQueryBuilder {
    private DataSource dataSource;
    private QuerySegmentSpec intervals = new LegacySegmentSpec((Object)Intervals.ETERNITY);
    private Map<String, Object> context;
    private RowSignature rowSignature;
    private List<OperatorFactory> operators;
    private List<OperatorFactory> leafOperators;

    public static WindowOperatorQueryBuilder builder() {
        return new WindowOperatorQueryBuilder();
    }

    public WindowOperatorQueryBuilder setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public WindowOperatorQueryBuilder setDataSource(String dataSource) {
        return this.setDataSource((DataSource)new TableDataSource(dataSource));
    }

    public WindowOperatorQueryBuilder setDataSource(Query<?> query) {
        return this.setDataSource((DataSource)new QueryDataSource(query));
    }

    public WindowOperatorQueryBuilder setSignature(RowSignature rowSignature) {
        this.rowSignature = rowSignature;
        return this;
    }

    public Query<?> build() {
        return new WindowOperatorQuery(this.dataSource, this.intervals, this.context, this.rowSignature, this.operators, this.leafOperators);
    }

    public WindowOperatorQueryBuilder setOperators(OperatorFactory ... operators) {
        this.operators = Lists.newArrayList((Object[])operators);
        return this;
    }

    public WindowOperatorQueryBuilder setLeafOperators(OperatorFactory ... operators) {
        this.leafOperators = Lists.newArrayList((Object[])operators);
        return this;
    }
}

