/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.expression.TimestampFloorExprMacro;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.TimeFormatExtractionFn;
import org.apache.druid.query.filter.AndDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.ExpressionDimFilter;
import org.apache.druid.query.filter.IsFalseDimFilter;
import org.apache.druid.query.filter.IsTrueDimFilter;
import org.apache.druid.query.filter.NotDimFilter;
import org.apache.druid.query.filter.NullFilter;
import org.apache.druid.query.filter.OrDimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.ordering.StringComparator;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.Types;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.DruidLiteral;
import org.apache.druid.sql.calcite.expression.ExtractionFns;
import org.apache.druid.sql.calcite.expression.PostAggregatorVisitor;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.filtration.BoundRefKey;
import org.apache.druid.sql.calcite.filtration.Bounds;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.apache.druid.sql.calcite.filtration.RangeRefKey;
import org.apache.druid.sql.calcite.filtration.Ranges;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.ExpressionParser;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.CannotBuildQueryException;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;
import org.apache.druid.sql.calcite.table.RowSignatures;
import org.joda.time.Interval;

public class Expressions {
    private Expressions() {
    }

    @Deprecated
    public static RexNode fromFieldAccess(RowSignature rowSignature, @Nullable Project project, int fieldNumber) {
        return Expressions.fromFieldAccess((RelDataTypeFactory)(project == null ? new JavaTypeFactoryImpl() : null), rowSignature, project, fieldNumber);
    }

    public static RexNode fromFieldAccess(RelDataTypeFactory typeFactory, RowSignature rowSignature, @Nullable Project project, int fieldNumber) {
        if (project == null) {
            return RexInputRef.of((int)fieldNumber, (RelDataType)RowSignatures.toRelDataType(rowSignature, typeFactory));
        }
        return (RexNode)project.getProjects().get(fieldNumber);
    }

    @Nullable
    public static List<DruidExpression> toDruidExpressions(PlannerContext plannerContext, RowSignature rowSignature, List<RexNode> rexNodes) {
        ArrayList<DruidExpression> retVal = new ArrayList<DruidExpression>(rexNodes.size());
        for (RexNode rexNode : rexNodes) {
            DruidExpression druidExpression = Expressions.toDruidExpression(plannerContext, rowSignature, rexNode);
            if (druidExpression == null) {
                return null;
            }
            retVal.add(druidExpression);
        }
        return retVal;
    }

    @Nullable
    public static List<DruidExpression> toDruidExpressionsWithPostAggOperands(PlannerContext plannerContext, RowSignature rowSignature, List<RexNode> rexNodes, PostAggregatorVisitor postAggregatorVisitor) {
        ArrayList<DruidExpression> retVal = new ArrayList<DruidExpression>(rexNodes.size());
        for (RexNode rexNode : rexNodes) {
            DruidExpression druidExpression = Expressions.toDruidExpressionWithPostAggOperands(plannerContext, rowSignature, rexNode, postAggregatorVisitor);
            if (druidExpression == null) {
                return null;
            }
            retVal.add(druidExpression);
        }
        return retVal;
    }

    @Nullable
    public static DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        return Expressions.toDruidExpressionWithPostAggOperands(plannerContext, rowSignature, rexNode, null);
    }

    @Nullable
    public static DruidExpression toDruidExpressionWithPostAggOperands(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode, @Nullable PostAggregatorVisitor postAggregatorVisitor) {
        SqlKind kind = rexNode.getKind();
        if (kind == SqlKind.INPUT_REF) {
            return Expressions.inputRefToDruidExpression(rowSignature, rexNode);
        }
        if (rexNode instanceof RexOver) {
            throw new CannotBuildQueryException(StringUtils.format((String)"Unexpected OVER expression during translation [%s]", (Object[])new Object[]{rexNode}));
        }
        if (rexNode instanceof RexCall) {
            return Expressions.rexCallToDruidExpression(plannerContext, rowSignature, rexNode, postAggregatorVisitor);
        }
        if (kind == SqlKind.LITERAL) {
            DruidLiteral eval = Expressions.calciteLiteralToDruidLiteral(plannerContext, rexNode);
            return eval != null ? DruidExpression.ofLiteral(eval) : null;
        }
        return null;
    }

    private static DruidExpression inputRefToDruidExpression(RowSignature rowSignature, RexNode rexNode) {
        RexInputRef ref = (RexInputRef)rexNode;
        String columnName = rowSignature.getColumnName(ref.getIndex());
        Optional columnType = rowSignature.getColumnType(ref.getIndex());
        if (columnName == null) {
            throw new ISE("Expression referred to nonexistent index[%d]", new Object[]{ref.getIndex()});
        }
        return DruidExpression.ofColumn(columnType.orElse(null), columnName);
    }

    private static DruidExpression rexCallToDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode, PostAggregatorVisitor postAggregatorVisitor) {
        PostAggregator postAggregator;
        SqlOperator operator = ((RexCall)rexNode).getOperator();
        SqlOperatorConversion conversion = plannerContext.getPlannerToolbox().operatorTable().lookupOperatorConversion(operator);
        if (conversion == null) {
            plannerContext.setPlanningError("SQL query requires '%s' operator that is not supported.", operator.getName());
            return null;
        }
        if (postAggregatorVisitor != null && (postAggregator = conversion.toPostAggregator(plannerContext, rowSignature, rexNode, postAggregatorVisitor)) != null) {
            postAggregatorVisitor.addPostAgg(postAggregator);
            String exprName = postAggregator.getName();
            return DruidExpression.ofColumn(postAggregator.getType((ColumnInspector)rowSignature), exprName);
        }
        DruidExpression expression = conversion.toDruidExpressionWithPostAggOperands(plannerContext, rowSignature, rexNode, postAggregatorVisitor);
        return expression;
    }

    @Nullable
    public static DruidLiteral calciteLiteralToDruidLiteral(PlannerContext plannerContext, RexNode rexNode) {
        DruidLiteral retVal;
        if (rexNode.isA(SqlKind.CAST)) {
            if (SqlTypeFamily.DATE.contains(rexNode.getType())) {
                return null;
            }
            DruidLiteral innerLiteral = Expressions.calciteLiteralToDruidLiteral(plannerContext, (RexNode)((RexCall)rexNode).getOperands().get(0));
            if (innerLiteral == null) {
                return null;
            }
            ColumnType castToColumnType = Calcites.getColumnTypeForRelDataType(rexNode.getType());
            if (castToColumnType == null) {
                return null;
            }
            ExpressionType castToExprType = ExpressionType.fromColumnType((TypeSignature)castToColumnType);
            if (castToExprType == null) {
                return null;
            }
            return innerLiteral.castTo(castToExprType);
        }
        SqlTypeName sqlTypeName = rexNode.getType().getSqlTypeName();
        if (RexLiteral.isNullLiteral((RexNode)rexNode)) {
            ColumnType columnType = Calcites.getColumnTypeForRelDataType(rexNode.getType());
            ExpressionType expressionType = columnType == null ? null : ExpressionType.fromColumnTypeStrict((TypeSignature)columnType);
            retVal = new DruidLiteral(expressionType, null);
        } else if (SqlTypeName.INT_TYPES.contains(sqlTypeName)) {
            Number number = (Number)((Object)RexLiteral.value((RexNode)rexNode));
            retVal = new DruidLiteral(ExpressionType.LONG, number == null ? null : Long.valueOf(number.longValue()));
        } else if (SqlTypeName.NUMERIC_TYPES.contains(sqlTypeName)) {
            Number number = (Number)((Object)RexLiteral.value((RexNode)rexNode));
            retVal = new DruidLiteral(ExpressionType.DOUBLE, number == null ? null : Double.valueOf(number.doubleValue()));
        } else if (SqlTypeFamily.INTERVAL_DAY_TIME == sqlTypeName.getFamily()) {
            long milliseconds = ((Number)((Object)RexLiteral.value((RexNode)rexNode))).longValue();
            retVal = new DruidLiteral(ExpressionType.LONG, milliseconds);
        } else if (SqlTypeFamily.INTERVAL_YEAR_MONTH == sqlTypeName.getFamily()) {
            long months = ((Number)((Object)RexLiteral.value((RexNode)rexNode))).longValue();
            retVal = new DruidLiteral(ExpressionType.LONG, months);
        } else if (SqlTypeName.STRING_TYPES.contains(sqlTypeName)) {
            String s = RexLiteral.stringValue((RexNode)rexNode);
            retVal = new DruidLiteral(ExpressionType.STRING, s);
        } else if (SqlTypeName.TIMESTAMP == sqlTypeName || SqlTypeName.DATE == sqlTypeName) {
            retVal = new DruidLiteral(ExpressionType.LONG, Calcites.calciteDateTimeLiteralToJoda(rexNode, plannerContext.getTimeZone()).getMillis());
        } else if (SqlTypeName.BOOLEAN == sqlTypeName) {
            retVal = new DruidLiteral(ExpressionType.LONG, RexLiteral.booleanValue((RexNode)rexNode) ? 1L : 0L);
        } else {
            return null;
        }
        return retVal;
    }

    @Nullable
    public static DimFilter toFilter(PlannerContext plannerContext, RowSignature rowSignature, @Nullable VirtualColumnRegistry virtualColumnRegistry, RexNode expression) {
        SqlKind kind = expression.getKind();
        if (kind == SqlKind.IS_TRUE || kind == SqlKind.IS_NOT_TRUE || kind == SqlKind.IS_FALSE || kind == SqlKind.IS_NOT_FALSE) {
            DimFilter baseFilter = Expressions.toFilter(plannerContext, rowSignature, virtualColumnRegistry, (RexNode)Iterables.getOnlyElement((Iterable)((RexCall)expression).getOperands()));
            if (kind == SqlKind.IS_TRUE) {
                return IsTrueDimFilter.of((DimFilter)baseFilter);
            }
            if (kind == SqlKind.IS_NOT_TRUE) {
                return NotDimFilter.of((DimFilter)IsTrueDimFilter.of((DimFilter)baseFilter));
            }
            if (kind == SqlKind.IS_FALSE) {
                return IsFalseDimFilter.of((DimFilter)baseFilter);
            }
            return NotDimFilter.of((DimFilter)IsFalseDimFilter.of((DimFilter)baseFilter));
        }
        if (kind == SqlKind.CAST && expression.getType().getSqlTypeName() == SqlTypeName.BOOLEAN) {
            return Expressions.toFilter(plannerContext, rowSignature, virtualColumnRegistry, (RexNode)Iterables.getOnlyElement((Iterable)((RexCall)expression).getOperands()));
        }
        if (kind == SqlKind.AND || kind == SqlKind.OR || kind == SqlKind.NOT) {
            ArrayList<DimFilter> filters = new ArrayList<DimFilter>();
            for (RexNode rexNode : ((RexCall)expression).getOperands()) {
                DimFilter nextFilter = Expressions.toFilter(plannerContext, rowSignature, virtualColumnRegistry, rexNode);
                if (nextFilter == null) {
                    return null;
                }
                filters.add(nextFilter);
            }
            if (kind == SqlKind.AND) {
                return new AndDimFilter(filters);
            }
            if (kind == SqlKind.OR) {
                return new OrDimFilter(filters);
            }
            return new NotDimFilter((DimFilter)Iterables.getOnlyElement(filters));
        }
        return Expressions.toLeafFilter(plannerContext, rowSignature, virtualColumnRegistry, expression);
    }

    @Nullable
    private static DimFilter toLeafFilter(PlannerContext plannerContext, RowSignature rowSignature, @Nullable VirtualColumnRegistry virtualColumnRegistry, RexNode rexNode) {
        if (rexNode.isAlwaysTrue()) {
            return Filtration.matchEverything();
        }
        if (rexNode.isAlwaysFalse()) {
            return Filtration.matchNothing();
        }
        DimFilter simpleFilter = Expressions.toSimpleLeafFilter(plannerContext, rowSignature, virtualColumnRegistry, rexNode);
        return simpleFilter != null ? simpleFilter : Expressions.toExpressionLeafFilter(plannerContext, rowSignature, rexNode);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static DimFilter toSimpleLeafFilter(PlannerContext plannerContext, RowSignature rowSignature, @Nullable VirtualColumnRegistry virtualColumnRegistry, RexNode rexNode) {
        block48: {
            Granularity granularity;
            ExtractionFn extractionFn;
            String column;
            void var7_24;
            SqlKind flippedKind;
            RexNode rhs;
            block50: {
                SqlKind kind;
                block49: {
                    kind = rexNode.getKind();
                    if (kind == SqlKind.IS_TRUE) return Expressions.toExpressionLeafFilter(plannerContext, rowSignature, rexNode);
                    if (kind == SqlKind.IS_NOT_FALSE) return Expressions.toExpressionLeafFilter(plannerContext, rowSignature, rexNode);
                    if (kind == SqlKind.IS_FALSE) return Expressions.toExpressionLeafFilter(plannerContext, rowSignature, rexNode);
                    if (kind == SqlKind.IS_NOT_TRUE) {
                        return Expressions.toExpressionLeafFilter(plannerContext, rowSignature, rexNode);
                    }
                    if (kind == SqlKind.IS_NULL || kind == SqlKind.IS_NOT_NULL) {
                        void var7_21;
                        RexNode operand = (RexNode)Iterables.getOnlyElement((Iterable)((RexCall)rexNode).getOperands());
                        DruidExpression druidExpression = Expressions.toDruidExpression(plannerContext, rowSignature, operand);
                        if (druidExpression == null) {
                            return null;
                        }
                        ColumnType outputType = druidExpression.getDruidType();
                        boolean isOutputNumeric = Types.isNumeric((TypeSignature)outputType);
                        if (druidExpression.isSimpleExtraction() && (!isOutputNumeric || rowSignature.isNumeric(druidExpression.getDirectColumn()))) {
                            if (plannerContext.isUseBoundsAndSelectors()) {
                                SelectorDimFilter selectorDimFilter = new SelectorDimFilter(druidExpression.getSimpleExtraction().getColumn(), null, druidExpression.getSimpleExtraction().getExtractionFn());
                                return kind == SqlKind.IS_NOT_NULL ? new NotDimFilter((DimFilter)var7_21) : var7_21;
                            } else if (druidExpression.getSimpleExtraction().getExtractionFn() != null) {
                                if (virtualColumnRegistry == null) return null;
                                String column2 = virtualColumnRegistry.getOrCreateVirtualColumnForExpression(druidExpression, druidExpression.getDruidType());
                                NullFilter nullFilter = NullFilter.forColumn((String)column2);
                                return kind == SqlKind.IS_NOT_NULL ? new NotDimFilter((DimFilter)var7_21) : var7_21;
                            } else {
                                NullFilter nullFilter = NullFilter.forColumn((String)druidExpression.getDirectColumn());
                            }
                            return kind == SqlKind.IS_NOT_NULL ? new NotDimFilter((DimFilter)var7_21) : var7_21;
                        } else {
                            if (virtualColumnRegistry == null) return null;
                            String virtualColumn = virtualColumnRegistry.getOrCreateVirtualColumnForExpression(druidExpression, operand.getType());
                            if (plannerContext.isUseBoundsAndSelectors()) {
                                SelectorDimFilter selectorDimFilter = new SelectorDimFilter(virtualColumn, null, null);
                                return kind == SqlKind.IS_NOT_NULL ? new NotDimFilter((DimFilter)var7_21) : var7_21;
                            } else {
                                NullFilter nullFilter = NullFilter.forColumn((String)virtualColumn);
                            }
                        }
                        return kind == SqlKind.IS_NOT_NULL ? new NotDimFilter((DimFilter)var7_21) : var7_21;
                    }
                    if (kind != SqlKind.EQUALS && kind != SqlKind.NOT_EQUALS && kind != SqlKind.IS_NOT_DISTINCT_FROM && kind != SqlKind.IS_DISTINCT_FROM && kind != SqlKind.GREATER_THAN && kind != SqlKind.GREATER_THAN_OR_EQUAL && kind != SqlKind.LESS_THAN && kind != SqlKind.LESS_THAN_OR_EQUAL) break block48;
                    List operands = ((RexCall)rexNode).getOperands();
                    Preconditions.checkState((operands.size() == 2 ? 1 : 0) != 0, (String)"Expected 2 operands, got[%s]", (int)operands.size());
                    boolean flip = false;
                    RexNode rexNode2 = (RexNode)operands.get(0);
                    rhs = (RexNode)operands.get(1);
                    if (rexNode2.getKind() == SqlKind.LITERAL && rhs.getKind() != SqlKind.LITERAL) {
                        RexNode x = rexNode2;
                        RexNode rexNode3 = rhs;
                        rhs = x;
                        flip = true;
                    }
                    if (!flip) break block49;
                    switch (kind) {
                        case EQUALS: 
                        case NOT_EQUALS: 
                        case IS_NOT_DISTINCT_FROM: 
                        case IS_DISTINCT_FROM: {
                            flippedKind = kind;
                            break block50;
                        }
                        case GREATER_THAN: {
                            flippedKind = SqlKind.LESS_THAN;
                            break block50;
                        }
                        case GREATER_THAN_OR_EQUAL: {
                            flippedKind = SqlKind.LESS_THAN_OR_EQUAL;
                            break block50;
                        }
                        case LESS_THAN: {
                            flippedKind = SqlKind.GREATER_THAN;
                            break block50;
                        }
                        case LESS_THAN_OR_EQUAL: {
                            flippedKind = SqlKind.GREATER_THAN_OR_EQUAL;
                            break block50;
                        }
                        default: {
                            throw new ISE("Kind[%s] not expected here", new Object[]{kind});
                        }
                    }
                }
                flippedKind = kind;
            }
            DruidExpression rhsExpression = Expressions.toDruidExpression(plannerContext, rowSignature, rhs);
            if (rhsExpression == null) return null;
            Expr expr = plannerContext.parseExpression(rhsExpression.getExpression());
            Expr rhsParsed = expr;
            if (rhsParsed == null) return null;
            if (!rhsParsed.isLiteral()) {
                return null;
            }
            DruidExpression lhsExpression = Expressions.toDruidExpression(plannerContext, rowSignature, (RexNode)var7_24);
            if (lhsExpression == null) {
                return null;
            }
            Granularity queryGranularity = Expressions.toQueryGranularity(lhsExpression, plannerContext.getExpressionParser());
            if (queryGranularity != null) {
                long rhsMillis = Calcites.calciteDateTimeLiteralToJoda(rhs, plannerContext.getTimeZone()).getMillis();
                return Expressions.buildTimeFloorFilter("__time", queryGranularity, flippedKind, rhsMillis, plannerContext);
            }
            if (lhsExpression.isSimpleExtraction()) {
                column = lhsExpression.getSimpleExtraction().getColumn();
                extractionFn = lhsExpression.getSimpleExtraction().getExtractionFn();
            } else {
                if (virtualColumnRegistry == null) return null;
                column = virtualColumnRegistry.getOrCreateVirtualColumnForExpression(lhsExpression, var7_24.getType());
                extractionFn = null;
            }
            if (column.equals("__time") && extractionFn instanceof TimeFormatExtractionFn && (granularity = ExtractionFns.toQueryGranularity(extractionFn)) != null) {
                long rhsMillis = Calcites.calciteDateTimeLiteralToJoda(rhs, plannerContext.getTimeZone()).getMillis();
                return Expressions.buildTimeFloorFilter(column, granularity, flippedKind, rhsMillis, plannerContext);
            }
            ColumnType matchValueType = Calcites.getColumnTypeForRelDataType(rhs.getType());
            if (plannerContext.isUseBoundsAndSelectors()) {
                if (matchValueType == null) return null;
                if (!matchValueType.isPrimitive()) {
                    return null;
                }
                if (rhsParsed.getLiteralValue() == null) {
                    return null;
                }
                String stringVal = RexUtil.isLiteral((RexNode)rhs, (boolean)true) && SqlTypeName.NUMERIC_TYPES.contains(rhs.getType().getSqlTypeName()) ? String.valueOf(RexLiteral.value((RexNode)rhs)) : String.valueOf(rhsParsed.getLiteralValue());
                if (stringVal == null) {
                    return null;
                }
                StringComparator comparator = Calcites.getStringComparatorForRelDataType(var7_24.getType());
                if (comparator == null) {
                    return null;
                }
                BoundRefKey boundRefKey = new BoundRefKey(column, extractionFn, comparator);
                switch (flippedKind) {
                    case EQUALS: 
                    case IS_NOT_DISTINCT_FROM: {
                        return Bounds.equalTo(boundRefKey, stringVal);
                    }
                    case NOT_EQUALS: 
                    case IS_DISTINCT_FROM: {
                        return new NotDimFilter((DimFilter)Bounds.equalTo(boundRefKey, stringVal));
                    }
                    case GREATER_THAN: {
                        return Bounds.greaterThan(boundRefKey, stringVal);
                    }
                    case GREATER_THAN_OR_EQUAL: {
                        return Bounds.greaterThanOrEqualTo(boundRefKey, stringVal);
                    }
                    case LESS_THAN: {
                        return Bounds.lessThan(boundRefKey, stringVal);
                    }
                    case LESS_THAN_OR_EQUAL: {
                        return Bounds.lessThanOrEqualTo(boundRefKey, stringVal);
                    }
                    default: {
                        throw new IllegalStateException("Shouldn't have got here");
                    }
                }
            }
            Object val = rhsParsed.getLiteralValue();
            if (val == null) {
                return null;
            }
            if (extractionFn != null) {
                if (virtualColumnRegistry == null) return null;
                column = virtualColumnRegistry.getOrCreateVirtualColumnForExpression(lhsExpression, var7_24.getType());
            }
            RangeRefKey rangeRefKey = new RangeRefKey(column, matchValueType);
            switch (flippedKind) {
                case EQUALS: 
                case IS_NOT_DISTINCT_FROM: {
                    return Ranges.equalTo(rangeRefKey, val);
                }
                case NOT_EQUALS: 
                case IS_DISTINCT_FROM: {
                    return new NotDimFilter((DimFilter)Ranges.equalTo(rangeRefKey, val));
                }
                case GREATER_THAN: {
                    return Ranges.greaterThan(rangeRefKey, val);
                }
                case GREATER_THAN_OR_EQUAL: {
                    return Ranges.greaterThanOrEqualTo(rangeRefKey, val);
                }
                case LESS_THAN: {
                    return Ranges.lessThan(rangeRefKey, val);
                }
                case LESS_THAN_OR_EQUAL: {
                    return Ranges.lessThanOrEqualTo(rangeRefKey, val);
                }
                default: {
                    throw new IllegalStateException("Shouldn't have got here");
                }
            }
        }
        if (!(rexNode instanceof RexCall)) return null;
        SqlOperator operator = ((RexCall)rexNode).getOperator();
        SqlOperatorConversion conversion = plannerContext.getPlannerToolbox().operatorTable().lookupOperatorConversion(operator);
        if (conversion != null) return conversion.toDruidFilter(plannerContext, rowSignature, virtualColumnRegistry, rexNode);
        return null;
    }

    @Nullable
    private static DimFilter toExpressionLeafFilter(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        DruidExpression druidExpression = Expressions.toDruidExpression(plannerContext, rowSignature, rexNode);
        if (druidExpression != null) {
            return new ExpressionDimFilter(druidExpression.getExpression(), plannerContext.parseExpression(druidExpression.getExpression()), null);
        }
        return null;
    }

    @Nullable
    public static Granularity toQueryGranularity(DruidExpression expression, ExpressionParser parser) {
        TimestampFloorExprMacro.TimestampFloorExpr expr = Expressions.asTimestampFloorExpr(expression, parser);
        if (expr == null) {
            return null;
        }
        Expr arg = expr.getArg();
        PeriodGranularity granularity = expr.getGranularity();
        if ("__time".equals(arg.getBindingIfIdentifier())) {
            return granularity;
        }
        return null;
    }

    @Nullable
    public static TimestampFloorExprMacro.TimestampFloorExpr asTimestampFloorExpr(DruidExpression expression, ExpressionParser parser) {
        Expr expr = parser.parse(expression.getExpression());
        if (expr instanceof TimestampFloorExprMacro.TimestampFloorExpr) {
            return (TimestampFloorExprMacro.TimestampFloorExpr)expr;
        }
        return null;
    }

    private static DimFilter buildTimeFloorFilter(String column, Granularity granularity, SqlKind operatorKind, long rhsMillis, PlannerContext plannerContext) {
        boolean rhsAligned;
        Interval rhsInterval = granularity.bucket(DateTimes.utc((long)rhsMillis));
        boolean bl = rhsAligned = rhsInterval.getStartMillis() == rhsMillis;
        if (plannerContext.isUseBoundsAndSelectors()) {
            BoundRefKey boundRefKey = new BoundRefKey(column, null, StringComparators.NUMERIC);
            return Expressions.getBoundTimeDimFilter(operatorKind, boundRefKey, rhsInterval, rhsAligned);
        }
        RangeRefKey rangeRefKey = new RangeRefKey(column, ColumnType.LONG);
        return Expressions.getRangeTimeDimFilter(operatorKind, rangeRefKey, rhsInterval, rhsAligned);
    }

    private static DimFilter getBoundTimeDimFilter(SqlKind operatorKind, BoundRefKey boundRefKey, Interval interval, boolean isAligned) {
        switch (operatorKind) {
            case EQUALS: {
                return isAligned ? Bounds.interval(boundRefKey, interval) : Filtration.matchNothing();
            }
            case NOT_EQUALS: {
                return isAligned ? new NotDimFilter((DimFilter)Bounds.interval(boundRefKey, interval)) : Filtration.matchEverything();
            }
            case GREATER_THAN: {
                return Bounds.greaterThanOrEqualTo(boundRefKey, String.valueOf(interval.getEndMillis()));
            }
            case GREATER_THAN_OR_EQUAL: {
                return isAligned ? Bounds.greaterThanOrEqualTo(boundRefKey, String.valueOf(interval.getStartMillis())) : Bounds.greaterThanOrEqualTo(boundRefKey, String.valueOf(interval.getEndMillis()));
            }
            case LESS_THAN: {
                return isAligned ? Bounds.lessThan(boundRefKey, String.valueOf(interval.getStartMillis())) : Bounds.lessThan(boundRefKey, String.valueOf(interval.getEndMillis()));
            }
            case LESS_THAN_OR_EQUAL: {
                return Bounds.lessThan(boundRefKey, String.valueOf(interval.getEndMillis()));
            }
        }
        throw new IllegalStateException("Shouldn't have got here");
    }

    private static DimFilter getRangeTimeDimFilter(SqlKind operatorKind, RangeRefKey rangeRefKey, Interval interval, boolean isAligned) {
        switch (operatorKind) {
            case EQUALS: {
                return isAligned ? Ranges.interval(rangeRefKey, interval) : Filtration.matchNothing();
            }
            case NOT_EQUALS: {
                return isAligned ? new NotDimFilter((DimFilter)Ranges.interval(rangeRefKey, interval)) : Filtration.matchEverything();
            }
            case GREATER_THAN: {
                return Ranges.greaterThanOrEqualTo(rangeRefKey, interval.getEndMillis());
            }
            case GREATER_THAN_OR_EQUAL: {
                return isAligned ? Ranges.greaterThanOrEqualTo(rangeRefKey, interval.getStartMillis()) : Ranges.greaterThanOrEqualTo(rangeRefKey, interval.getEndMillis());
            }
            case LESS_THAN: {
                return isAligned ? Ranges.lessThan(rangeRefKey, interval.getStartMillis()) : Ranges.lessThan(rangeRefKey, interval.getEndMillis());
            }
            case LESS_THAN_OR_EQUAL: {
                return Ranges.lessThan(rangeRefKey, interval.getEndMillis());
            }
        }
        throw new IllegalStateException("Shouldn't have got here");
    }
}

