/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.calcite.avatica.SqlType;
import org.apache.druid.common.exception.AllowedRegexErrorResponseTransformStrategy;
import org.apache.druid.common.exception.ErrorResponseTransformStrategy;
import org.apache.druid.common.guava.SettableSupplier;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.DruidExceptionMatcher;
import org.apache.druid.error.ErrorResponse;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.NonnullPair;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.guava.LazySequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.BadQueryContextException;
import org.apache.druid.query.DefaultQueryConfig;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryCapacityExceededException;
import org.apache.druid.query.QueryException;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.QueryTimeoutException;
import org.apache.druid.query.QueryUnsupportedException;
import org.apache.druid.query.ResourceLimitExceededException;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.QueryLaningStrategy;
import org.apache.druid.server.QueryResponse;
import org.apache.druid.server.QueryScheduler;
import org.apache.druid.server.QueryStackTests;
import org.apache.druid.server.RequestLogLine;
import org.apache.druid.server.ResponseContextConfig;
import org.apache.druid.server.SpecificSegmentsQuerySegmentWalker;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.log.RequestLogger;
import org.apache.druid.server.log.TestRequestLogger;
import org.apache.druid.server.mocks.MockHttpServletRequest;
import org.apache.druid.server.mocks.MockHttpServletResponse;
import org.apache.druid.server.scheduling.HiLoQueryLaningStrategy;
import org.apache.druid.server.scheduling.ManualQueryPrioritizationStrategy;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.AuthorizationResult;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.DirectStatement;
import org.apache.druid.sql.HttpStatement;
import org.apache.druid.sql.PreparedStatement;
import org.apache.druid.sql.SqlLifecycleManager;
import org.apache.druid.sql.SqlQueryPlus;
import org.apache.druid.sql.SqlStatementFactory;
import org.apache.druid.sql.SqlToolbox;
import org.apache.druid.sql.calcite.planner.CalciteRulesManager;
import org.apache.druid.sql.calcite.planner.CatalogResolver;
import org.apache.druid.sql.calcite.planner.DruidOperatorTable;
import org.apache.druid.sql.calcite.planner.DruidPlanner;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.planner.PlannerFactory;
import org.apache.druid.sql.calcite.planner.PlannerResult;
import org.apache.druid.sql.calcite.run.NativeSqlEngine;
import org.apache.druid.sql.calcite.run.SqlEngine;
import org.apache.druid.sql.calcite.schema.DruidSchemaCatalog;
import org.apache.druid.sql.calcite.util.CalciteTestBase;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.apache.druid.sql.hook.DruidHookDispatcher;
import org.apache.druid.sql.http.ResultFormat;
import org.apache.druid.sql.http.SqlParameter;
import org.apache.druid.sql.http.SqlQuery;
import org.apache.druid.sql.http.SqlResource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class SqlResourceTest
extends CalciteTestBase {
    public static final DruidNode DUMMY_DRUID_NODE = new DruidNode("dummy", "dummy", false, Integer.valueOf(1), null, true, false);
    public static final ResponseContextConfig TEST_RESPONSE_CONTEXT_CONFIG = ResponseContextConfig.newConfig((boolean)false);
    private static final ObjectMapper JSON_MAPPER = new DefaultObjectMapper();
    private static final String DUMMY_SQL_QUERY_ID = "dummy";
    private static final int WAIT_TIMEOUT_SECS = 60;
    private static final Consumer<DirectStatement> NULL_ACTION = s -> {};
    private static final List<String> EXPECTED_COLUMNS_FOR_RESULT_FORMAT_TESTS = Arrays.asList("__time", "dim1", "dim2", "dim3", "cnt", "m1", "m2", "unique_dim1", "EXPR$8");
    private static final List<String> EXPECTED_TYPES_FOR_RESULT_FORMAT_TESTS = Arrays.asList("LONG", "STRING", "STRING", "STRING", "LONG", "FLOAT", "DOUBLE", "COMPLEX<hyperUnique>", "STRING");
    private static final List<String> EXPECTED_SQL_TYPES_FOR_RESULT_FORMAT_TESTS = Arrays.asList("TIMESTAMP", "VARCHAR", "VARCHAR", "VARCHAR", "BIGINT", "FLOAT", "DOUBLE", "OTHER", "VARCHAR");
    private static Closer staticCloser = Closer.create();
    private static QueryRunnerFactoryConglomerate conglomerate;
    private static SpecificSegmentsQuerySegmentWalker walker;
    private static QueryScheduler scheduler;
    private Closer resourceCloser;
    private TestRequestLogger testRequestLogger;
    private SqlResource resource;
    private MockHttpServletRequest req;
    private ListeningExecutorService executorService;
    private SqlLifecycleManager lifecycleManager;
    private NativeSqlEngine engine;
    private SqlStatementFactory sqlStatementFactory;
    private StubServiceEmitter stubServiceEmitter;
    private CountDownLatch lifecycleAddLatch;
    private final SettableSupplier<NonnullPair<CountDownLatch, Boolean>> validateAndAuthorizeLatchSupplier = new SettableSupplier();
    private final SettableSupplier<NonnullPair<CountDownLatch, Boolean>> planLatchSupplier = new SettableSupplier();
    private final SettableSupplier<NonnullPair<CountDownLatch, Boolean>> executeLatchSupplier = new SettableSupplier();
    private final SettableSupplier<Function<Sequence<Object[]>, Sequence<Object[]>>> sequenceMapFnSupplier = new SettableSupplier();
    private final SettableSupplier<ResponseContext> responseContextSupplier = new SettableSupplier();
    private Consumer<DirectStatement> onExecute = NULL_ACTION;
    private static final AtomicReference<Supplier<Void>> SCHEDULER_BAGGAGE;

    @BeforeAll
    public static void setupClass(@TempDir File tempDir) {
        conglomerate = QueryStackTests.createQueryRunnerFactoryConglomerate((Closer)staticCloser);
        scheduler = new QueryScheduler(5, ManualQueryPrioritizationStrategy.INSTANCE, (QueryLaningStrategy)new HiLoQueryLaningStrategy(Integer.valueOf(40)), new ServerConfig(false)){

            public <T> Sequence<T> run(Query<?> query, Sequence<T> resultSequence) {
                return super.run(query, (Sequence)new LazySequence(() -> {
                    SCHEDULER_BAGGAGE.get().get();
                    return resultSequence;
                }));
            }
        };
        walker = CalciteTests.createMockWalker(conglomerate, tempDir, scheduler);
        staticCloser.register((Closeable)walker);
    }

    @AfterAll
    public static void teardownClass() throws Exception {
        staticCloser.close();
    }

    @BeforeEach
    public void setUp() throws Exception {
        SCHEDULER_BAGGAGE.set(() -> null);
        this.resourceCloser = Closer.create();
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)Execs.multiThreaded((int)8, (String)"test_sql_resource_%s"));
        PlannerConfig plannerConfig = PlannerConfig.builder().build();
        DruidSchemaCatalog rootSchema = CalciteTests.createMockRootSchema(conglomerate, walker, plannerConfig, CalciteTests.TEST_AUTHORIZER_MAPPER);
        DruidOperatorTable operatorTable = CalciteTests.createOperatorTable();
        ExprMacroTable macroTable = CalciteTests.createExprMacroTable();
        this.req = this.request();
        this.testRequestLogger = new TestRequestLogger();
        PlannerFactory plannerFactory = new PlannerFactory(rootSchema, operatorTable, macroTable, plannerConfig, CalciteTests.TEST_AUTHORIZER_MAPPER, CalciteTests.getJsonMapper(), "druid", new CalciteRulesManager((Set)ImmutableSet.of()), CalciteTests.createJoinableFactoryWrapper(), CatalogResolver.NULL_RESOLVER, new AuthConfig(), new DruidHookDispatcher());
        this.lifecycleManager = new SqlLifecycleManager(){

            public void add(String sqlQueryId, SqlLifecycleManager.Cancelable lifecycle) {
                super.add(sqlQueryId, lifecycle);
                if (SqlResourceTest.this.lifecycleAddLatch != null) {
                    SqlResourceTest.this.lifecycleAddLatch.countDown();
                }
            }
        };
        this.stubServiceEmitter = new StubServiceEmitter("test", "test");
        AuthConfig authConfig = new AuthConfig();
        DefaultQueryConfig defaultQueryConfig = new DefaultQueryConfig((Map)ImmutableMap.of());
        this.engine = CalciteTests.createMockSqlEngine((QuerySegmentWalker)walker, conglomerate);
        final SqlToolbox sqlToolbox = new SqlToolbox((SqlEngine)this.engine, plannerFactory, (ServiceEmitter)this.stubServiceEmitter, (RequestLogger)this.testRequestLogger, scheduler, defaultQueryConfig, this.lifecycleManager);
        this.sqlStatementFactory = new SqlStatementFactory(null){

            public HttpStatement httpStatement(SqlQuery sqlQuery, HttpServletRequest req) {
                TestHttpStatement stmt = new TestHttpStatement(sqlToolbox, sqlQuery, req, SqlResourceTest.this.validateAndAuthorizeLatchSupplier, SqlResourceTest.this.planLatchSupplier, SqlResourceTest.this.executeLatchSupplier, SqlResourceTest.this.sequenceMapFnSupplier, SqlResourceTest.this.responseContextSupplier, SqlResourceTest.this.onExecute);
                SqlResourceTest.this.onExecute = NULL_ACTION;
                return stmt;
            }

            public DirectStatement directStatement(SqlQueryPlus sqlRequest) {
                throw new UnsupportedOperationException();
            }

            public PreparedStatement preparedStatement(SqlQueryPlus sqlRequest) {
                throw new UnsupportedOperationException();
            }
        };
        this.resource = new SqlResource(JSON_MAPPER, CalciteTests.TEST_AUTHORIZER_MAPPER, this.sqlStatementFactory, this.lifecycleManager, new ServerConfig(), TEST_RESPONSE_CONTEXT_CONFIG, DUMMY_DRUID_NODE);
    }

    MockHttpServletRequest request() {
        return this.makeExpectedReq(CalciteTests.REGULAR_USER_AUTH_RESULT);
    }

    @AfterEach
    public void tearDown() throws Exception {
        SCHEDULER_BAGGAGE.set(() -> null);
        this.executorService.shutdownNow();
        this.executorService.awaitTermination(2L, TimeUnit.SECONDS);
        this.resourceCloser.close();
    }

    @Test
    public void testUnauthorized() {
        ForbiddenException e = (ForbiddenException)Assert.assertThrows(ForbiddenException.class, () -> this.postForAsyncResponse(SqlResourceTest.createSimpleQueryWithId("id", "select count(*) from forbiddenDatasource"), this.request()));
        Assert.assertEquals((Object)"Unauthorized", (Object)e.getMessage());
        Assert.assertEquals((long)1L, (long)this.testRequestLogger.getSqlQueryLogs().size());
        Assert.assertTrue((boolean)this.lifecycleManager.getAll("id").isEmpty());
    }

    @Test
    public void testRestricted() throws Exception {
        this.req = this.makeSuperUserReq();
        List resultAsSuperUser = (List)this.doPost((SqlQuery)SqlResourceTest.createSimpleQueryWithId((String)"id", (String)"select count(*) as cnt from restrictedDatasource_m1_is_6")).rhs;
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"cnt", (Object)6)), (Object)resultAsSuperUser);
        this.checkSqlRequestLog(true, "testSuperuser");
        this.testRequestLogger.clear();
        Assert.assertTrue((boolean)this.lifecycleManager.getAll("id").isEmpty());
        this.req = this.makeRegularUserReq();
        List resultAsRegularUser = (List)this.doPost((SqlQuery)SqlResourceTest.createSimpleQueryWithId((String)"id", (String)"select count(*) as cnt from restrictedDatasource_m1_is_6")).rhs;
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"cnt", (Object)1)), (Object)resultAsRegularUser);
        this.checkSqlRequestLog(true);
        this.testRequestLogger.clear();
        Assert.assertTrue((boolean)this.lifecycleManager.getAll("id").isEmpty());
    }

    @Test
    public void testCountStar() throws Exception {
        List rows = (List)this.doPost((SqlQuery)SqlResourceTest.createSimpleQueryWithId((String)"id", (String)"SELECT COUNT(*) AS cnt, 'foo' AS TheFoo FROM druid.foo")).rhs;
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"cnt", (Object)6, (Object)"TheFoo", (Object)"foo")), (Object)rows);
        this.checkSqlRequestLog(true);
        Assert.assertTrue((boolean)this.lifecycleManager.getAll("id").isEmpty());
    }

    @Test
    public void testCountStarWithMissingIntervalsContext() throws Exception {
        SqlQuery sqlQuery = new SqlQuery("SELECT COUNT(*) AS cnt, 'foo' AS TheFoo FROM druid.foo", null, false, false, false, (Map)ImmutableMap.of((Object)"sqlQueryId", (Object)"id", (Object)"uncoveredIntervalsLimit", (Object)1), null);
        ResponseContext mockRespContext = ResponseContext.createEmpty();
        mockRespContext.put(ResponseContext.Keys.instance().keyOf("uncoveredIntervals"), (Object)"2030-01-01/78149827981274-01-01");
        mockRespContext.put(ResponseContext.Keys.instance().keyOf("uncoveredIntervalsOverflowed"), (Object)"true");
        this.responseContextSupplier.set((Object)mockRespContext);
        MockHttpServletResponse response = this.postForAsyncResponse(sqlQuery, this.makeRegularUserReq());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"uncoveredIntervals", (Object)"2030-01-01/78149827981274-01-01", (Object)"uncoveredIntervalsOverflowed", (Object)"true"), (Object)JSON_MAPPER.readValue((String)Iterables.getOnlyElement((Iterable)response.headers.get((Object)"X-Druid-Response-Context")), Map.class));
        Object results = JSON_MAPPER.readValue(response.baos.toByteArray(), Object.class);
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"cnt", (Object)6, (Object)"TheFoo", (Object)"foo")), (Object)results);
        this.checkSqlRequestLog(true);
        Assert.assertTrue((boolean)this.lifecycleManager.getAll("id").isEmpty());
    }

    @Test
    public void testSqlLifecycleMetrics() throws Exception {
        List rows = (List)this.doPost((SqlQuery)SqlResourceTest.createSimpleQueryWithId((String)"id", (String)"SELECT COUNT(*) AS cnt, 'foo' AS TheFoo FROM druid.foo")).rhs;
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"cnt", (Object)6, (Object)"TheFoo", (Object)"foo")), (Object)rows);
        this.checkSqlRequestLog(true);
        Assert.assertTrue((boolean)this.lifecycleManager.getAll("id").isEmpty());
        this.stubServiceEmitter.verifyEmitted("sqlQuery/time", 1);
        this.stubServiceEmitter.verifyValue("sqlQuery/bytes", (Number)27L);
        this.stubServiceEmitter.verifyEmitted("sqlQuery/planningTimeMs", 1);
    }

    @Test
    public void testCountStarExtendedCharacters() throws Exception {
        List rows = (List)this.doPost((SqlQuery)SqlResourceTest.createSimpleQueryWithId((String)"id", (String)"SELECT COUNT(*) AS cnt FROM druid.lotsocolumns WHERE dimMultivalEnumerated = '\u3151 \u3153 \u3155 \u3157 \u315b \u315c \u3160 \u3161 \u3163'")).rhs;
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"cnt", (Object)1)), (Object)rows);
        this.checkSqlRequestLog(true);
        Assert.assertTrue((boolean)this.lifecycleManager.getAll("id").isEmpty());
    }

    @Test
    public void testTimestampsInResponse() throws Exception {
        List rows = (List)this.doPost((SqlQuery)new SqlQuery((String)"SELECT __time, CAST(__time AS DATE) AS t2 FROM druid.foo LIMIT 1", (ResultFormat)ResultFormat.OBJECT, (boolean)false, (boolean)false, (boolean)false, null, null)).rhs;
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"__time", (Object)"2000-01-01T00:00:00.000Z", (Object)"t2", (Object)"2000-01-01T00:00:00.000Z")), (Object)rows);
    }

    @Test
    public void testTimestampsInResponseWithParameterizedLimit() throws Exception {
        List rows = (List)this.doPost((SqlQuery)new SqlQuery((String)"SELECT __time, CAST(__time AS DATE) AS t2 FROM druid.foo LIMIT ?", (ResultFormat)ResultFormat.OBJECT, (boolean)false, (boolean)false, (boolean)false, null, (List)ImmutableList.of((Object)new SqlParameter((SqlType)SqlType.INTEGER, (Object)Integer.valueOf((int)1))))).rhs;
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"__time", (Object)"2000-01-01T00:00:00.000Z", (Object)"t2", (Object)"2000-01-01T00:00:00.000Z")), (Object)rows);
    }

    @Test
    public void testTimestampsInResponseLosAngelesTimeZone() throws Exception {
        List rows = (List)this.doPost((SqlQuery)new SqlQuery((String)"SELECT __time, CAST(__time AS DATE) AS t2 FROM druid.foo LIMIT 1", (ResultFormat)ResultFormat.OBJECT, (boolean)false, (boolean)false, (boolean)false, (Map)ImmutableMap.of((Object)"sqlTimeZone", (Object)"America/Los_Angeles"), null)).rhs;
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"__time", (Object)"1999-12-31T16:00:00.000-08:00", (Object)"t2", (Object)"1999-12-31T00:00:00.000-08:00")), (Object)rows);
    }

    @Test
    public void testTimestampsInResponseWithNulls() throws Exception {
        List rows = (List)this.doPost((SqlQuery)new SqlQuery((String)"SELECT MAX(__time) as t1, MAX(__time) FILTER(WHERE dim1 = 'non_existing') as t2 FROM druid.foo", (ResultFormat)ResultFormat.OBJECT, (boolean)false, (boolean)false, (boolean)false, null, null)).rhs;
        Assert.assertEquals((Object)ImmutableList.of((Object)Maps.transformValues((Map)ImmutableMap.of((Object)"t1", (Object)"2001-01-03T00:00:00.000Z", (Object)"t2", (Object)""), val -> "".equals(val) ? null : val)), (Object)rows);
    }

    @Test
    public void testFieldAliasingSelect() throws Exception {
        List rows = (List)this.doPost((SqlQuery)new SqlQuery((String)"SELECT dim2 \"x\", dim2 \"y\" FROM druid.foo LIMIT 1", (ResultFormat)ResultFormat.OBJECT, (boolean)false, (boolean)false, (boolean)false, null, null)).rhs;
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"x", (Object)"a", (Object)"y", (Object)"a")), (Object)rows);
    }

    @Test
    public void testFieldAliasingGroupBy() throws Exception {
        List rows = (List)this.doPost((SqlQuery)new SqlQuery((String)"SELECT dim2 \"x\", dim2 \"y\" FROM druid.foo GROUP BY dim2", (ResultFormat)ResultFormat.OBJECT, (boolean)false, (boolean)false, (boolean)false, null, null)).rhs;
        Assert.assertEquals((Object)ImmutableList.of((Object)Maps.transformValues((Map)ImmutableMap.of((Object)"x", (Object)"", (Object)"y", (Object)""), val -> null), (Object)ImmutableMap.of((Object)"x", (Object)"", (Object)"y", (Object)""), (Object)ImmutableMap.of((Object)"x", (Object)"a", (Object)"y", (Object)"a"), (Object)ImmutableMap.of((Object)"x", (Object)"abc", (Object)"y", (Object)"abc")), (Object)rows);
    }

    @Test
    public void testArrayResultFormat() throws Exception {
        String query = "SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo LIMIT 2";
        Assert.assertEquals((Object)ImmutableList.of(Arrays.asList("2000-01-01T00:00:00.000Z", "", "a", "[\"a\",\"b\"]", 1, 1.0, 1.0, "\"AQAAAEAAAA==\"", null), Arrays.asList("2000-01-02T00:00:00.000Z", "10.1", null, "[\"b\",\"c\"]", 1, 2.0, 2.0, "\"AQAAAQAAAAHNBA==\"", null)), (Object)this.doPost((SqlQuery)new SqlQuery((String)"SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo LIMIT 2", (ResultFormat)ResultFormat.ARRAY, (boolean)false, (boolean)false, (boolean)false, null, null), new TypeReference<List<List<Object>>>(){}).rhs);
    }

    @Test
    public void testArrayResultFormatWithErrorAfterSecondRow() throws Exception {
        this.sequenceMapFnSupplier.set(SqlResourceTest.errorAfterSecondRowMapFn());
        String query = "SELECT cnt FROM foo";
        Pair<ErrorResponse, String> response = this.doPostRaw(new SqlQuery("SELECT cnt FROM foo", ResultFormat.ARRAY, false, false, false, null, null), this.req);
        Assert.assertNull((Object)response.lhs);
        Assert.assertEquals((Object)"[[1],[1]", (Object)response.rhs);
    }

    @Test
    public void testObjectResultFormatWithErrorAfterFirstRow() throws Exception {
        this.sequenceMapFnSupplier.set(SqlResourceTest.errorAfterSecondRowMapFn());
        String query = "SELECT cnt FROM foo";
        Pair<ErrorResponse, String> response = this.doPostRaw(new SqlQuery("SELECT cnt FROM foo", ResultFormat.OBJECT, false, false, false, null, null), this.req);
        Assert.assertNull((Object)response.lhs);
        Assert.assertEquals((Object)"[{\"cnt\":1},{\"cnt\":1}", (Object)response.rhs);
    }

    @Test
    public void testArrayLinesResultFormatWithErrorAfterFirstRow() throws Exception {
        this.sequenceMapFnSupplier.set(SqlResourceTest.errorAfterSecondRowMapFn());
        String query = "SELECT cnt FROM foo";
        Pair<ErrorResponse, String> response = this.doPostRaw(new SqlQuery("SELECT cnt FROM foo", ResultFormat.ARRAYLINES, false, false, false, null, null), this.req);
        Assert.assertNull((Object)response.lhs);
        Assert.assertEquals((Object)"[1]\n[1]", (Object)response.rhs);
    }

    @Test
    public void testObjectLinesResultFormatWithErrorAfterFirstRow() throws Exception {
        this.sequenceMapFnSupplier.set(SqlResourceTest.errorAfterSecondRowMapFn());
        String query = "SELECT cnt FROM foo";
        Pair<ErrorResponse, String> response = this.doPostRaw(new SqlQuery("SELECT cnt FROM foo", ResultFormat.OBJECTLINES, false, false, false, null, null), this.req);
        Assert.assertNull((Object)response.lhs);
        Assert.assertEquals((Object)"{\"cnt\":1}\n{\"cnt\":1}", (Object)response.rhs);
    }

    @Test
    public void testCsvResultFormatWithErrorAfterFirstRow() throws Exception {
        this.sequenceMapFnSupplier.set(SqlResourceTest.errorAfterSecondRowMapFn());
        String query = "SELECT cnt FROM foo";
        Pair<ErrorResponse, String> response = this.doPostRaw(new SqlQuery("SELECT cnt FROM foo", ResultFormat.CSV, false, false, false, null, null), this.req);
        Assert.assertNull((Object)response.lhs);
        Assert.assertEquals((Object)"1\n1\n", (Object)response.rhs);
    }

    @Test
    public void testArrayResultFormatWithHeader() throws Exception {
        String query = "SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo LIMIT 2";
        List[] expectedQueryResults = new List[]{Arrays.asList("2000-01-01T00:00:00.000Z", "", "a", "[\"a\",\"b\"]", 1, 1.0, 1.0, "\"AQAAAEAAAA==\"", null), Arrays.asList("2000-01-02T00:00:00.000Z", "10.1", null, "[\"b\",\"c\"]", 1, 2.0, 2.0, "\"AQAAAQAAAAHNBA==\"", null)};
        MockHttpServletResponse response = this.postForAsyncResponse(new SqlQuery("SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo LIMIT 2", ResultFormat.ARRAY, true, true, true, null, null), this.req.mimic());
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"yes", (Object)response.getHeader("X-Druid-SQL-Header-Included"));
        Assert.assertEquals((Object)ImmutableList.builder().add(EXPECTED_COLUMNS_FOR_RESULT_FORMAT_TESTS).add(EXPECTED_TYPES_FOR_RESULT_FORMAT_TESTS).add(EXPECTED_SQL_TYPES_FOR_RESULT_FORMAT_TESTS).addAll(Arrays.asList(expectedQueryResults)).build(), (Object)JSON_MAPPER.readValue(response.baos.toByteArray(), Object.class));
        MockHttpServletResponse responseNoSqlTypesHeader = this.postForAsyncResponse(new SqlQuery("SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo LIMIT 2", ResultFormat.ARRAY, true, true, false, null, null), this.req.mimic());
        Assert.assertEquals((long)200L, (long)responseNoSqlTypesHeader.getStatus());
        Assert.assertEquals((Object)"yes", (Object)responseNoSqlTypesHeader.getHeader("X-Druid-SQL-Header-Included"));
        Assert.assertEquals((Object)ImmutableList.builder().add(EXPECTED_COLUMNS_FOR_RESULT_FORMAT_TESTS).add(EXPECTED_TYPES_FOR_RESULT_FORMAT_TESTS).addAll(Arrays.asList(expectedQueryResults)).build(), (Object)JSON_MAPPER.readValue(responseNoSqlTypesHeader.baos.toByteArray(), Object.class));
        MockHttpServletResponse responseNoTypesHeader = this.postForAsyncResponse(new SqlQuery("SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo LIMIT 2", ResultFormat.ARRAY, true, false, true, null, null), this.req.mimic());
        Assert.assertEquals((long)200L, (long)responseNoTypesHeader.getStatus());
        Assert.assertEquals((Object)"yes", (Object)responseNoTypesHeader.getHeader("X-Druid-SQL-Header-Included"));
        Assert.assertEquals((Object)ImmutableList.builder().add(EXPECTED_COLUMNS_FOR_RESULT_FORMAT_TESTS).add(EXPECTED_SQL_TYPES_FOR_RESULT_FORMAT_TESTS).addAll(Arrays.asList(expectedQueryResults)).build(), (Object)JSON_MAPPER.readValue(responseNoTypesHeader.baos.toByteArray(), Object.class));
        MockHttpServletResponse responseNoTypes = this.postForAsyncResponse(new SqlQuery("SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo LIMIT 2", ResultFormat.ARRAY, true, false, false, null, null), this.req.mimic());
        Assert.assertEquals((long)200L, (long)responseNoTypes.getStatus());
        Assert.assertEquals((Object)"yes", (Object)responseNoTypes.getHeader("X-Druid-SQL-Header-Included"));
        Assert.assertEquals((Object)ImmutableList.builder().add(EXPECTED_COLUMNS_FOR_RESULT_FORMAT_TESTS).addAll(Arrays.asList(expectedQueryResults)).build(), (Object)JSON_MAPPER.readValue(responseNoTypes.baos.toByteArray(), Object.class));
        MockHttpServletResponse responseNoHeader = this.postForAsyncResponse(new SqlQuery("SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo LIMIT 2", ResultFormat.ARRAY, false, false, false, null, null), this.req.mimic());
        Assert.assertEquals((long)200L, (long)responseNoHeader.getStatus());
        Assert.assertNull((Object)responseNoHeader.getHeader("X-Druid-SQL-Header-Included"));
        Assert.assertEquals(Arrays.asList(expectedQueryResults), (Object)JSON_MAPPER.readValue(responseNoHeader.baos.toByteArray(), Object.class));
    }

    @Test
    public void testArrayResultFormatWithHeader_nullColumnType() throws Exception {
        String query = "SELECT (1, 2) FROM INFORMATION_SCHEMA.COLUMNS LIMIT 1";
        MockHttpServletResponse response = this.postForAsyncResponse(new SqlQuery("SELECT (1, 2) FROM INFORMATION_SCHEMA.COLUMNS LIMIT 1", ResultFormat.ARRAY, true, true, true, null, null), this.req);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"yes", (Object)response.getHeader("X-Druid-SQL-Header-Included"));
        Assert.assertEquals((Object)ImmutableList.of(Collections.singletonList("EXPR$0"), Collections.singletonList(null), Collections.singletonList("ROW"), Collections.singletonList(Arrays.asList(1, 2))), (Object)JSON_MAPPER.readValue(response.baos.toByteArray(), Object.class));
    }

    @Test
    public void testArrayLinesResultFormat() throws Exception {
        String query = "SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo LIMIT 2";
        Pair<ErrorResponse, String> pair = this.doPostRaw(new SqlQuery("SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo LIMIT 2", ResultFormat.ARRAYLINES, false, false, false, null, null));
        Assert.assertNull((Object)pair.lhs);
        String response = (String)pair.rhs;
        List lines = Splitter.on((char)'\n').splitToList((CharSequence)response);
        Assert.assertEquals((long)4L, (long)lines.size());
        Assert.assertEquals(Arrays.asList("2000-01-01T00:00:00.000Z", "", "a", "[\"a\",\"b\"]", 1, 1.0, 1.0, "\"AQAAAEAAAA==\"", null), (Object)JSON_MAPPER.readValue((String)lines.get(0), List.class));
        Assert.assertEquals(Arrays.asList("2000-01-02T00:00:00.000Z", "10.1", null, "[\"b\",\"c\"]", 1, 2.0, 2.0, "\"AQAAAQAAAAHNBA==\"", null), (Object)JSON_MAPPER.readValue((String)lines.get(1), List.class));
        Assert.assertEquals((Object)"", lines.get(2));
        Assert.assertEquals((Object)"", lines.get(3));
    }

    @Test
    public void testArrayLinesResultFormatWithHeader() throws Exception {
        String query = "SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo LIMIT 2";
        Pair<ErrorResponse, String> pair = this.doPostRaw(new SqlQuery("SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo LIMIT 2", ResultFormat.ARRAYLINES, true, true, true, null, null));
        Assert.assertNull((Object)pair.lhs);
        String response = (String)pair.rhs;
        List lines = Splitter.on((char)'\n').splitToList((CharSequence)response);
        Assert.assertEquals((long)7L, (long)lines.size());
        Assert.assertEquals(EXPECTED_COLUMNS_FOR_RESULT_FORMAT_TESTS, (Object)JSON_MAPPER.readValue((String)lines.get(0), List.class));
        Assert.assertEquals(EXPECTED_TYPES_FOR_RESULT_FORMAT_TESTS, (Object)JSON_MAPPER.readValue((String)lines.get(1), List.class));
        Assert.assertEquals(EXPECTED_SQL_TYPES_FOR_RESULT_FORMAT_TESTS, (Object)JSON_MAPPER.readValue((String)lines.get(2), List.class));
        Assert.assertEquals(Arrays.asList("2000-01-01T00:00:00.000Z", "", "a", "[\"a\",\"b\"]", 1, 1.0, 1.0, "\"AQAAAEAAAA==\"", null), (Object)JSON_MAPPER.readValue((String)lines.get(3), List.class));
        Assert.assertEquals(Arrays.asList("2000-01-02T00:00:00.000Z", "10.1", null, "[\"b\",\"c\"]", 1, 2.0, 2.0, "\"AQAAAQAAAAHNBA==\"", null), (Object)JSON_MAPPER.readValue((String)lines.get(4), List.class));
        Assert.assertEquals((Object)"", lines.get(5));
        Assert.assertEquals((Object)"", lines.get(6));
    }

    @Test
    public void testArrayLinesResultFormatWithHeader_nullColumnType() throws Exception {
        String query = "SELECT (1, 2) FROM INFORMATION_SCHEMA.COLUMNS LIMIT 1";
        Pair<ErrorResponse, String> pair = this.doPostRaw(new SqlQuery("SELECT (1, 2) FROM INFORMATION_SCHEMA.COLUMNS LIMIT 1", ResultFormat.ARRAYLINES, true, true, true, null, null));
        Assert.assertNull((Object)pair.lhs);
        String response = (String)pair.rhs;
        List lines = Splitter.on((char)'\n').splitToList((CharSequence)response);
        Assert.assertEquals((long)6L, (long)lines.size());
        Assert.assertEquals(Collections.singletonList("EXPR$0"), (Object)JSON_MAPPER.readValue((String)lines.get(0), List.class));
        Assert.assertEquals(Collections.singletonList(null), (Object)JSON_MAPPER.readValue((String)lines.get(1), List.class));
        Assert.assertEquals(Collections.singletonList("ROW"), (Object)JSON_MAPPER.readValue((String)lines.get(2), List.class));
        Assert.assertEquals(Collections.singletonList(Arrays.asList(1, 2)), (Object)JSON_MAPPER.readValue((String)lines.get(3), List.class));
        Assert.assertEquals((Object)"", lines.get(4));
        Assert.assertEquals((Object)"", lines.get(5));
    }

    @Test
    public void testObjectResultFormat() throws Exception {
        String query = "SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo  LIMIT 2";
        Function<Map, Map> transformer = m -> Maps.transformEntries((Map)m, (k, v) -> "EXPR$8".equals(k) || "dim2".equals(k) && v.toString().isEmpty() ? null : v);
        Assert.assertEquals(ImmutableList.of((Object)ImmutableMap.builder().put((Object)"__time", (Object)"2000-01-01T00:00:00.000Z").put((Object)"cnt", (Object)1).put((Object)"dim1", (Object)"").put((Object)"dim2", (Object)"a").put((Object)"dim3", (Object)"[\"a\",\"b\"]").put((Object)"m1", (Object)1.0).put((Object)"m2", (Object)1.0).put((Object)"unique_dim1", (Object)"\"AQAAAEAAAA==\"").put((Object)"EXPR$8", (Object)"").build(), (Object)ImmutableMap.builder().put((Object)"__time", (Object)"2000-01-02T00:00:00.000Z").put((Object)"cnt", (Object)1).put((Object)"dim1", (Object)"10.1").put((Object)"dim2", (Object)"").put((Object)"dim3", (Object)"[\"b\",\"c\"]").put((Object)"m1", (Object)2.0).put((Object)"m2", (Object)2.0).put((Object)"unique_dim1", (Object)"\"AQAAAQAAAAHNBA==\"").put((Object)"EXPR$8", (Object)"").build()).stream().map(transformer).collect(Collectors.toList()), (Object)this.doPost((SqlQuery)new SqlQuery((String)"SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo  LIMIT 2", (ResultFormat)ResultFormat.OBJECT, (boolean)false, (boolean)false, (boolean)false, null, null), new TypeReference<List<Map<String, Object>>>(){}).rhs);
    }

    @Test
    public void testObjectLinesResultFormat() throws Exception {
        String query = "SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo LIMIT 2";
        Pair<ErrorResponse, String> pair = this.doPostRaw(new SqlQuery("SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo LIMIT 2", ResultFormat.OBJECTLINES, false, false, false, null, null));
        Assert.assertNull((Object)pair.lhs);
        String response = (String)pair.rhs;
        Function<Map, Map> transformer = m -> Maps.transformEntries((Map)m, (k, v) -> "EXPR$8".equals(k) || "dim2".equals(k) && v.toString().isEmpty() ? null : v);
        List lines = Splitter.on((char)'\n').splitToList((CharSequence)response);
        Assert.assertEquals((long)4L, (long)lines.size());
        Assert.assertEquals((Object)transformer.apply((Map)ImmutableMap.builder().put((Object)"__time", (Object)"2000-01-01T00:00:00.000Z").put((Object)"cnt", (Object)1).put((Object)"dim1", (Object)"").put((Object)"dim2", (Object)"a").put((Object)"dim3", (Object)"[\"a\",\"b\"]").put((Object)"m1", (Object)1.0).put((Object)"m2", (Object)1.0).put((Object)"unique_dim1", (Object)"\"AQAAAEAAAA==\"").put((Object)"EXPR$8", (Object)"").build()), (Object)JSON_MAPPER.readValue((String)lines.get(0), Object.class));
        Assert.assertEquals((Object)transformer.apply((Map)ImmutableMap.builder().put((Object)"__time", (Object)"2000-01-02T00:00:00.000Z").put((Object)"cnt", (Object)1).put((Object)"dim1", (Object)"10.1").put((Object)"dim2", (Object)"").put((Object)"dim3", (Object)"[\"b\",\"c\"]").put((Object)"m1", (Object)2.0).put((Object)"m2", (Object)2.0).put((Object)"unique_dim1", (Object)"\"AQAAAQAAAAHNBA==\"").put((Object)"EXPR$8", (Object)"").build()), (Object)JSON_MAPPER.readValue((String)lines.get(1), Object.class));
        Assert.assertEquals((Object)"", lines.get(2));
        Assert.assertEquals((Object)"", lines.get(3));
    }

    @Test
    public void testObjectLinesResultFormatWithMinimalHeader() throws Exception {
        String query = "SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo LIMIT 2";
        Pair<ErrorResponse, String> pair = this.doPostRaw(new SqlQuery("SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo LIMIT 2", ResultFormat.OBJECTLINES, true, false, false, null, null));
        Assert.assertNull((Object)pair.lhs);
        String response = (String)pair.rhs;
        Function<Map, Map> transformer = m -> Maps.transformEntries((Map)m, (k, v) -> "EXPR$8".equals(k) || "dim2".equals(k) && v.toString().isEmpty() ? null : v);
        List lines = Splitter.on((char)'\n').splitToList((CharSequence)response);
        HashMap<String, Object> expectedHeader = new HashMap<String, Object>();
        for (String column : EXPECTED_COLUMNS_FOR_RESULT_FORMAT_TESTS) {
            expectedHeader.put(column, null);
        }
        Assert.assertEquals((long)5L, (long)lines.size());
        Assert.assertEquals(expectedHeader, (Object)JSON_MAPPER.readValue((String)lines.get(0), Object.class));
        Assert.assertEquals((Object)transformer.apply((Map)ImmutableMap.builder().put((Object)"__time", (Object)"2000-01-01T00:00:00.000Z").put((Object)"cnt", (Object)1).put((Object)"dim1", (Object)"").put((Object)"dim2", (Object)"a").put((Object)"dim3", (Object)"[\"a\",\"b\"]").put((Object)"m1", (Object)1.0).put((Object)"m2", (Object)1.0).put((Object)"unique_dim1", (Object)"\"AQAAAEAAAA==\"").put((Object)"EXPR$8", (Object)"").build()), (Object)JSON_MAPPER.readValue((String)lines.get(1), Object.class));
        Assert.assertEquals((Object)transformer.apply((Map)ImmutableMap.builder().put((Object)"__time", (Object)"2000-01-02T00:00:00.000Z").put((Object)"cnt", (Object)1).put((Object)"dim1", (Object)"10.1").put((Object)"dim2", (Object)"").put((Object)"dim3", (Object)"[\"b\",\"c\"]").put((Object)"m1", (Object)2.0).put((Object)"m2", (Object)2.0).put((Object)"unique_dim1", (Object)"\"AQAAAQAAAAHNBA==\"").put((Object)"EXPR$8", (Object)"").build()), (Object)JSON_MAPPER.readValue((String)lines.get(2), Object.class));
        Assert.assertEquals((Object)"", lines.get(3));
        Assert.assertEquals((Object)"", lines.get(4));
    }

    @Test
    public void testObjectLinesResultFormatWithFullHeader() throws Exception {
        String query = "SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo LIMIT 2";
        Pair<ErrorResponse, String> pair = this.doPostRaw(new SqlQuery("SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo LIMIT 2", ResultFormat.OBJECTLINES, true, true, true, null, null));
        Assert.assertNull((Object)pair.lhs);
        String response = (String)pair.rhs;
        Function<Map, Map> transformer = m -> Maps.transformEntries((Map)m, (k, v) -> "EXPR$8".equals(k) || "dim2".equals(k) && v.toString().isEmpty() ? null : v);
        List lines = Splitter.on((char)'\n').splitToList((CharSequence)response);
        HashMap<String, ImmutableMap> expectedHeader = new HashMap<String, ImmutableMap>();
        for (int i = 0; i < EXPECTED_COLUMNS_FOR_RESULT_FORMAT_TESTS.size(); ++i) {
            expectedHeader.put(EXPECTED_COLUMNS_FOR_RESULT_FORMAT_TESTS.get(i), ImmutableMap.of((Object)"type", (Object)EXPECTED_TYPES_FOR_RESULT_FORMAT_TESTS.get(i), (Object)"sqlType", (Object)EXPECTED_SQL_TYPES_FOR_RESULT_FORMAT_TESTS.get(i)));
        }
        Assert.assertEquals((long)5L, (long)lines.size());
        Assert.assertEquals(expectedHeader, (Object)JSON_MAPPER.readValue((String)lines.get(0), Object.class));
        Assert.assertEquals((Object)transformer.apply((Map)ImmutableMap.builder().put((Object)"__time", (Object)"2000-01-01T00:00:00.000Z").put((Object)"cnt", (Object)1).put((Object)"dim1", (Object)"").put((Object)"dim2", (Object)"a").put((Object)"dim3", (Object)"[\"a\",\"b\"]").put((Object)"m1", (Object)1.0).put((Object)"m2", (Object)1.0).put((Object)"unique_dim1", (Object)"\"AQAAAEAAAA==\"").put((Object)"EXPR$8", (Object)"").build()), (Object)JSON_MAPPER.readValue((String)lines.get(1), Object.class));
        Assert.assertEquals((Object)transformer.apply((Map)ImmutableMap.builder().put((Object)"__time", (Object)"2000-01-02T00:00:00.000Z").put((Object)"cnt", (Object)1).put((Object)"dim1", (Object)"10.1").put((Object)"dim2", (Object)"").put((Object)"dim3", (Object)"[\"b\",\"c\"]").put((Object)"m1", (Object)2.0).put((Object)"m2", (Object)2.0).put((Object)"unique_dim1", (Object)"\"AQAAAQAAAAHNBA==\"").put((Object)"EXPR$8", (Object)"").build()), (Object)JSON_MAPPER.readValue((String)lines.get(2), Object.class));
        Assert.assertEquals((Object)"", lines.get(3));
        Assert.assertEquals((Object)"", lines.get(4));
    }

    @Test
    public void testObjectLinesResultFormatWithFullHeader_nullColumnType() throws Exception {
        String query = "SELECT (1, 2) FROM INFORMATION_SCHEMA.COLUMNS LIMIT 1";
        Pair<ErrorResponse, String> pair = this.doPostRaw(new SqlQuery("SELECT (1, 2) FROM INFORMATION_SCHEMA.COLUMNS LIMIT 1", ResultFormat.OBJECTLINES, true, true, true, null, null));
        Assert.assertNull((Object)pair.lhs);
        String response = (String)pair.rhs;
        List lines = Splitter.on((char)'\n').splitToList((CharSequence)response);
        HashMap<String, String> typeMap = new HashMap<String, String>();
        typeMap.put("type", null);
        typeMap.put("sqlType", "ROW");
        ImmutableMap expectedHeader = ImmutableMap.of((Object)"EXPR$0", typeMap);
        Assert.assertEquals((long)4L, (long)lines.size());
        Assert.assertEquals((Object)expectedHeader, (Object)JSON_MAPPER.readValue((String)lines.get(0), Object.class));
        Assert.assertEquals((Object)ImmutableMap.builder().put((Object)"EXPR$0", Arrays.asList(1, 2)).build(), (Object)JSON_MAPPER.readValue((String)lines.get(1), Object.class));
        Assert.assertEquals((Object)"", lines.get(2));
        Assert.assertEquals((Object)"", lines.get(3));
    }

    @Test
    public void testCsvResultFormat() throws Exception {
        String query = "SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo LIMIT 2";
        Pair<ErrorResponse, String> pair = this.doPostRaw(new SqlQuery("SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo LIMIT 2", ResultFormat.CSV, false, false, false, null, null));
        Assert.assertNull((Object)pair.lhs);
        String response = (String)pair.rhs;
        List lines = Splitter.on((char)'\n').splitToList((CharSequence)response);
        Assert.assertEquals((Object)ImmutableList.of((Object)"2000-01-01T00:00:00.000Z,,a,\"[\"\"a\"\",\"\"b\"\"]\",1,1.0,1.0,\"\"\"AQAAAEAAAA==\"\"\",", (Object)"2000-01-02T00:00:00.000Z,10.1,,\"[\"\"b\"\",\"\"c\"\"]\",1,2.0,2.0,\"\"\"AQAAAQAAAAHNBA==\"\"\",", (Object)"", (Object)""), (Object)lines);
    }

    @Test
    public void testCsvResultFormatWithHeaders() throws Exception {
        String query = "SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo LIMIT 2";
        Pair<ErrorResponse, String> pair = this.doPostRaw(new SqlQuery("SELECT *, CASE dim2 WHEN '' THEN dim2 END FROM foo LIMIT 2", ResultFormat.CSV, true, true, true, null, null));
        Assert.assertNull((Object)pair.lhs);
        String response = (String)pair.rhs;
        List lines = Splitter.on((char)'\n').splitToList((CharSequence)response);
        Assert.assertEquals((Object)ImmutableList.of((Object)String.join((CharSequence)",", EXPECTED_COLUMNS_FOR_RESULT_FORMAT_TESTS), (Object)String.join((CharSequence)",", EXPECTED_TYPES_FOR_RESULT_FORMAT_TESTS), (Object)String.join((CharSequence)",", EXPECTED_SQL_TYPES_FOR_RESULT_FORMAT_TESTS), (Object)"2000-01-01T00:00:00.000Z,,a,\"[\"\"a\"\",\"\"b\"\"]\",1,1.0,1.0,\"\"\"AQAAAEAAAA==\"\"\",", (Object)"2000-01-02T00:00:00.000Z,10.1,,\"[\"\"b\"\",\"\"c\"\"]\",1,2.0,2.0,\"\"\"AQAAAQAAAAHNBA==\"\"\",", (Object)"", (Object)""), (Object)lines);
    }

    @Test
    public void testCsvResultFormatWithHeaders_nullColumnType() throws Exception {
        String query = "SELECT (1, 2) FROM INFORMATION_SCHEMA.COLUMNS LIMIT 1";
        Pair<ErrorResponse, String> pair = this.doPostRaw(new SqlQuery("SELECT (1, 2) FROM INFORMATION_SCHEMA.COLUMNS LIMIT 1", ResultFormat.CSV, true, true, true, null, null));
        Assert.assertNull((Object)pair.lhs);
        String response = (String)pair.rhs;
        List lines = Splitter.on((char)'\n').splitToList((CharSequence)response);
        Assert.assertEquals((Object)ImmutableList.of((Object)"EXPR$0", (Object)"", (Object)"ROW"), lines.subList(0, 3));
    }

    @Test
    public void testExplainCountStar() throws Exception {
        ImmutableMap queryContext = ImmutableMap.of((Object)"sqlQueryId", (Object)DUMMY_SQL_QUERY_ID, (Object)"useNativeQueryExplain", (Object)"false");
        List rows = (List)this.doPost((SqlQuery)new SqlQuery((String)"EXPLAIN PLAN FOR SELECT COUNT(*) AS cnt FROM druid.foo", (ResultFormat)ResultFormat.OBJECT, (boolean)false, (boolean)false, (boolean)false, (Map)queryContext, null)).rhs;
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"PLAN", (Object)StringUtils.format((String)"DruidQueryRel(query=[{\"queryType\":\"timeseries\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"granularity\":{\"type\":\"all\"},\"aggregations\":[{\"type\":\"count\",\"name\":\"a0\"}],\"context\":{\"sqlQueryId\":\"%s\",\"%s\":\"%s\"}}], signature=[{a0:LONG}])\n", (Object[])new Object[]{DUMMY_SQL_QUERY_ID, "useNativeQueryExplain", "false"}), (Object)"RESOURCES", (Object)"[{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]", (Object)"ATTRIBUTES", (Object)"{\"statementType\":\"SELECT\"}")), (Object)rows);
    }

    @Test
    public void testCannotParse() throws Exception {
        ErrorResponse errorResponse = this.postSyncForException("FROM druid.foo", Response.Status.BAD_REQUEST.getStatusCode());
        this.validateInvalidSqlError(errorResponse, "Incorrect syntax near the keyword 'FROM' at line 1, column 1");
        this.checkSqlRequestLog(false);
        Assert.assertTrue((boolean)this.lifecycleManager.getAll("id").isEmpty());
    }

    @Test
    public void testCannotValidate() throws Exception {
        ErrorResponse errorResponse = this.postSyncForException("SELECT dim4 FROM druid.foo", Response.Status.BAD_REQUEST.getStatusCode());
        this.validateInvalidSqlError(errorResponse, "Column 'dim4' not found in any table");
        this.checkSqlRequestLog(false);
        Assert.assertTrue((boolean)this.lifecycleManager.getAll("id").isEmpty());
    }

    @Test
    public void testCannotConvert() throws Exception {
        SqlQuery unsupportedQuery = SqlResourceTest.createSimpleQueryWithId("id", "SELECT dim1 FROM druid.foo ORDER BY dim1");
        ErrorResponse exception = this.postSyncForException(unsupportedQuery, Response.Status.BAD_REQUEST.getStatusCode());
        Assert.assertTrue((boolean)((Boolean)this.req.getAttribute("Druid-Authorization-Checked")));
        this.validateErrorResponse(exception, "general", DruidException.Persona.USER, DruidException.Category.INVALID_INPUT, "Query could not be planned. A possible reason is [SQL query requires ordering a table by non-time column [[dim1]], which is not supported.]");
        this.checkSqlRequestLog(false);
        Assert.assertTrue((boolean)this.lifecycleManager.getAll("id").isEmpty());
    }

    @Test
    public void testCannotConvert_InvalidSQL() throws Exception {
        ErrorResponse errorResponse = this.postSyncForException("SELECT max(dim1) FROM druid.foo", Response.Status.BAD_REQUEST.getStatusCode());
        this.validateInvalidSqlError(errorResponse, "Aggregation [MAX] does not support type [STRING], column [v0]");
        this.checkSqlRequestLog(false);
        Assert.assertTrue((boolean)this.lifecycleManager.getAll("id").isEmpty());
    }

    @Test
    public void testResourceLimitExceeded() throws Exception {
        ErrorResponse errorResponse = (ErrorResponse)this.doPost((SqlQuery)new SqlQuery((String)"SELECT DISTINCT dim1 FROM foo", (ResultFormat)ResultFormat.OBJECT, (boolean)false, (boolean)false, (boolean)false, (Map)ImmutableMap.of((Object)"bufferGrouperMaxSize", (Object)Integer.valueOf((int)1), (Object)"sqlQueryId", (Object)"id"), null)).lhs;
        this.validateLegacyQueryExceptionErrorResponse(errorResponse, "Resource limit exceeded", ResourceLimitExceededException.class.getName(), "");
        Assert.assertTrue((boolean)this.lifecycleManager.getAll("id").isEmpty());
    }

    private void failOnExecute(String errorMessage) {
        this.onExecute = s -> {
            throw new QueryUnsupportedException(errorMessage);
        };
    }

    @Test
    public void testUnsupportedQueryThrowsException() throws Exception {
        String errorMessage = "This will be supported in Druid 9999";
        this.failOnExecute(errorMessage);
        ErrorResponse exception = this.postSyncForException(new SqlQuery("SELECT ANSWER TO LIFE", ResultFormat.OBJECT, false, false, false, (Map)ImmutableMap.of((Object)"sqlQueryId", (Object)"id"), null), 501);
        this.validateLegacyQueryExceptionErrorResponse(exception, "Unsupported query", QueryUnsupportedException.class.getName(), "");
        Assert.assertTrue((boolean)this.lifecycleManager.getAll("id").isEmpty());
    }

    @Test
    public void testErrorResponseReturnSameQueryIdWhenSetInContext() {
        String queryId = "id123";
        String errorMessage = "This will be supported in Druid 9999";
        this.failOnExecute(errorMessage);
        Response response = this.postForSyncResponse(new SqlQuery("SELECT ANSWER TO LIFE", ResultFormat.OBJECT, false, false, false, (Map)ImmutableMap.of((Object)"sqlQueryId", (Object)queryId), null), this.req);
        this.assertStatusAndCommonHeaders(response, 501);
        Assert.assertEquals((Object)queryId, (Object)this.getHeader(response, "X-Druid-Query-Id"));
        Assert.assertEquals((Object)queryId, (Object)this.getHeader(response, "X-Druid-SQL-Query-Id"));
    }

    @Test
    public void testErrorResponseReturnNewQueryIdWhenNotSetInContext() {
        String errorMessage = "This will be supported in Druid 9999";
        this.failOnExecute(errorMessage);
        Response response = this.postForSyncResponse(new SqlQuery("SELECT ANSWER TO LIFE", ResultFormat.OBJECT, false, false, false, (Map)ImmutableMap.of(), null), this.req);
        this.assertStatusAndCommonHeaders(response, 501);
    }

    @Test
    public void testUnsupportedQueryThrowsExceptionWithFilterResponse() throws Exception {
        this.resource = new SqlResource(JSON_MAPPER, CalciteTests.TEST_AUTHORIZER_MAPPER, this.sqlStatementFactory, this.lifecycleManager, new ServerConfig(){

            public boolean isShowDetailedJettyErrors() {
                return true;
            }

            public ErrorResponseTransformStrategy getErrorResponseTransformStrategy() {
                return new AllowedRegexErrorResponseTransformStrategy((List)ImmutableList.of());
            }
        }, TEST_RESPONSE_CONTEXT_CONFIG, DUMMY_DRUID_NODE);
        String errorMessage = "This will be supported in Druid 9999";
        this.failOnExecute(errorMessage);
        ErrorResponse exception = this.postSyncForException(new SqlQuery("SELECT ANSWER TO LIFE", ResultFormat.OBJECT, false, false, false, (Map)ImmutableMap.of((Object)"sqlQueryId", (Object)"id"), null), 501);
        this.validateLegacyQueryExceptionErrorResponse(exception, "Unsupported query", "org.apache.druid.query.QueryUnsupportedException", "This will be supported in Druid 9999");
        Assert.assertTrue((boolean)this.lifecycleManager.getAll("id").isEmpty());
    }

    @Test
    public void testAssertionErrorThrowsErrorWithFilterResponse() throws Exception {
        ErrorResponse exception = this.postSyncForException(new SqlQuery("SELECT assertion_error() FROM foo LIMIT 2", ResultFormat.OBJECT, false, false, false, (Map)ImmutableMap.of((Object)"sqlQueryId", (Object)"id"), null), Response.Status.BAD_REQUEST.getStatusCode());
        MatcherAssert.assertThat((Object)((Object)exception.getUnderlyingException()), (Matcher)DruidExceptionMatcher.invalidSqlInput().expectMessageIs("Calcite assertion violated: [not a literal: assertion_error()]"));
        Assert.assertTrue((boolean)this.lifecycleManager.getAll("id").isEmpty());
    }

    @Test
    public void testTooManyRequestsAfterTotalLaning() throws Exception {
        int numQueries = 3;
        CountDownLatch queriesScheduledLatch = new CountDownLatch(2);
        CountDownLatch runQueryLatch = new CountDownLatch(1);
        SCHEDULER_BAGGAGE.set(() -> {
            queriesScheduledLatch.countDown();
            try {
                runQueryLatch.await();
            }
            catch (InterruptedException e) {
                throw new RE((Throwable)e);
            }
            return null;
        });
        String sqlQueryId = "tooManyRequestsTest";
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>(3);
        for (int i = 0; i < 2; ++i) {
            futures.add(this.executorService.submit(() -> {
                try {
                    return this.postForAsyncResponse(new SqlQuery("SELECT COUNT(*) AS cnt, 'foo' AS TheFoo FROM druid.foo", null, false, false, false, (Map)ImmutableMap.of((Object)"priority", (Object)-5, (Object)"sqlQueryId", (Object)"tooManyRequestsTest"), null), this.makeRegularUserReq());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }));
        }
        queriesScheduledLatch.await();
        SCHEDULER_BAGGAGE.set(() -> null);
        futures.add(this.executorService.submit(() -> {
            try {
                Response retVal = this.postForSyncResponse(new SqlQuery("SELECT COUNT(*) AS cnt, 'foo' AS TheFoo FROM druid.foo", null, false, false, false, (Map)ImmutableMap.of((Object)"priority", (Object)-5, (Object)"sqlQueryId", (Object)"tooManyRequestsTest"), null), this.makeRegularUserReq());
                runQueryLatch.countDown();
                return retVal;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
        int success = 0;
        int limited = 0;
        for (int i = 0; i < 3; ++i) {
            Response response;
            if (i == 2) {
                response = (Response)((Future)futures.get(i)).get();
                this.assertStatusAndCommonHeaders(response, 429);
                QueryException interruped = this.deserializeResponse(response, QueryException.class);
                Assert.assertEquals((Object)"Query capacity exceeded", (Object)interruped.getErrorCode());
                Assert.assertEquals((Object)QueryCapacityExceededException.makeLaneErrorMessage((String)"low", (int)2), (Object)interruped.getMessage());
                ++limited;
                continue;
            }
            response = (MockHttpServletResponse)((Future)futures.get(i)).get();
            this.assertStatusAndCommonHeaders((MockHttpServletResponse)response, 200);
            Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"cnt", (Object)6, (Object)"TheFoo", (Object)"foo")), (Object)this.deserializeResponse((MockHttpServletResponse)response, Object.class));
            ++success;
        }
        Assert.assertEquals((long)2L, (long)success);
        Assert.assertEquals((long)1L, (long)limited);
        Assert.assertEquals((long)3L, (long)this.testRequestLogger.getSqlQueryLogs().size());
        Assert.assertTrue((boolean)this.lifecycleManager.getAll("tooManyRequestsTest").isEmpty());
    }

    @Test
    public void testQueryTimeoutException() throws Exception {
        String sqlQueryId = "timeoutTest";
        ImmutableMap queryContext = ImmutableMap.of((Object)"timeout", (Object)1, (Object)"sqlQueryId", (Object)"timeoutTest");
        ErrorResponse exception = this.postSyncForException(new SqlQuery("SELECT CAST(__time AS DATE), dim1, dim2, dim3 FROM druid.foo GROUP by __time, dim1, dim2, dim3 ORDER BY dim2 DESC", ResultFormat.OBJECT, false, false, false, (Map)queryContext, null), 504);
        this.validateLegacyQueryExceptionErrorResponse(exception, "Query timeout", QueryTimeoutException.class.getName(), "");
        Assert.assertTrue((boolean)this.lifecycleManager.getAll("timeoutTest").isEmpty());
    }

    @Test
    public void testCancelBetweenValidateAndPlan() throws Exception {
        String sqlQueryId = "toCancel";
        this.lifecycleAddLatch = new CountDownLatch(1);
        CountDownLatch validateAndAuthorizeLatch = new CountDownLatch(1);
        this.validateAndAuthorizeLatchSupplier.set((Object)new NonnullPair((Object)validateAndAuthorizeLatch, (Object)true));
        CountDownLatch planLatch = new CountDownLatch(1);
        this.planLatchSupplier.set((Object)new NonnullPair((Object)planLatch, (Object)false));
        ListenableFuture future = this.executorService.submit(() -> this.postForSyncResponse(SqlResourceTest.createSimpleQueryWithId("toCancel", "SELECT DISTINCT dim1 FROM foo"), this.makeRegularUserReq()));
        Assert.assertTrue((boolean)validateAndAuthorizeLatch.await(60L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)this.lifecycleAddLatch.await(60L, TimeUnit.SECONDS));
        Response cancelResponse = this.resource.cancelQuery("toCancel", (HttpServletRequest)this.makeRequestForCancel());
        planLatch.countDown();
        Assert.assertEquals((long)Response.Status.ACCEPTED.getStatusCode(), (long)cancelResponse.getStatus());
        Assert.assertTrue((boolean)this.lifecycleManager.getAll("toCancel").isEmpty());
        Response queryResponse = (Response)future.get();
        this.assertStatusAndCommonHeaders(queryResponse, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        ErrorResponse exception = this.deserializeResponse(queryResponse, ErrorResponse.class);
        this.validateLegacyQueryExceptionErrorResponse(exception, "Query cancelled", null, "");
    }

    @Test
    public void testCancelBetweenPlanAndExecute() throws Exception {
        String sqlQueryId = "toCancel";
        CountDownLatch planLatch = new CountDownLatch(1);
        this.planLatchSupplier.set((Object)new NonnullPair((Object)planLatch, (Object)true));
        CountDownLatch execLatch = new CountDownLatch(1);
        this.executeLatchSupplier.set((Object)new NonnullPair((Object)execLatch, (Object)false));
        ListenableFuture future = this.executorService.submit(() -> this.postForSyncResponse(SqlResourceTest.createSimpleQueryWithId("toCancel", "SELECT DISTINCT dim1 FROM foo"), this.makeRegularUserReq()));
        Assert.assertTrue((boolean)planLatch.await(60L, TimeUnit.SECONDS));
        Response cancelResponse = this.resource.cancelQuery("toCancel", (HttpServletRequest)this.makeRequestForCancel());
        execLatch.countDown();
        Assert.assertEquals((long)Response.Status.ACCEPTED.getStatusCode(), (long)cancelResponse.getStatus());
        Assert.assertTrue((boolean)this.lifecycleManager.getAll("toCancel").isEmpty());
        Response queryResponse = (Response)future.get();
        this.assertStatusAndCommonHeaders(queryResponse, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        ErrorResponse exception = this.deserializeResponse(queryResponse, ErrorResponse.class);
        this.validateLegacyQueryExceptionErrorResponse(exception, "Query cancelled", null, "");
    }

    @Test
    public void testCancelInvalidQuery() throws Exception {
        String sqlQueryId = "validQuery";
        CountDownLatch planLatch = new CountDownLatch(1);
        this.planLatchSupplier.set((Object)new NonnullPair((Object)planLatch, (Object)true));
        CountDownLatch execLatch = new CountDownLatch(1);
        this.executeLatchSupplier.set((Object)new NonnullPair((Object)execLatch, (Object)false));
        ListenableFuture future = this.executorService.submit(() -> this.postForAsyncResponse(SqlResourceTest.createSimpleQueryWithId("validQuery", "SELECT DISTINCT dim1 FROM foo"), this.makeRegularUserReq()));
        Assert.assertTrue((boolean)planLatch.await(60L, TimeUnit.SECONDS));
        Response cancelResponse = this.resource.cancelQuery("invalidQuery", (HttpServletRequest)this.makeRequestForCancel());
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)cancelResponse.getStatus());
        Assert.assertFalse((boolean)this.lifecycleManager.getAll("validQuery").isEmpty());
        execLatch.countDown();
        MockHttpServletResponse queryResponse = (MockHttpServletResponse)future.get();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)queryResponse.getStatus());
    }

    @Test
    public void testCancelForbidden() throws Exception {
        String sqlQueryId = "toCancel";
        CountDownLatch planLatch = new CountDownLatch(1);
        this.planLatchSupplier.set((Object)new NonnullPair((Object)planLatch, (Object)true));
        CountDownLatch execLatch = new CountDownLatch(1);
        this.executeLatchSupplier.set((Object)new NonnullPair((Object)execLatch, (Object)false));
        ListenableFuture future = this.executorService.submit(() -> this.postForAsyncResponse(SqlResourceTest.createSimpleQueryWithId("toCancel", "SELECT DISTINCT dim1 FROM forbiddenDatasource"), this.makeSuperUserReq()));
        Assert.assertTrue((boolean)planLatch.await(3L, TimeUnit.SECONDS));
        Response cancelResponse = this.resource.cancelQuery("toCancel", (HttpServletRequest)this.makeRequestForCancel());
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)cancelResponse.getStatus());
        Assert.assertFalse((boolean)this.lifecycleManager.getAll("toCancel").isEmpty());
        execLatch.countDown();
        MockHttpServletResponse queryResponse = (MockHttpServletResponse)future.get();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)queryResponse.getStatus());
    }

    @Test
    public void testQueryContextException() throws Exception {
        String sqlQueryId = "badQueryContextTimeout";
        ImmutableMap queryContext = ImmutableMap.of((Object)"timeout", (Object)"2000'", (Object)"sqlQueryId", (Object)"badQueryContextTimeout");
        ErrorResponse errorResponse = (ErrorResponse)this.doPost((SqlQuery)new SqlQuery((String)"SELECT 1337", (ResultFormat)ResultFormat.OBJECT, (boolean)false, (boolean)false, (boolean)false, (Map)queryContext, null)).lhs;
        this.validateLegacyQueryExceptionErrorResponse(errorResponse, "Query context parse failed", BadQueryContextException.ERROR_CLASS, "2000'");
        this.checkSqlRequestLog(false);
        Assert.assertTrue((boolean)this.lifecycleManager.getAll("badQueryContextTimeout").isEmpty());
    }

    @Test
    public void testQueryContextKeyNotAllowed() throws Exception {
        ImmutableMap queryContext = ImmutableMap.of((Object)"sqlInsertSegmentGranularity", (Object)"all");
        ErrorResponse exception = this.postSyncForException(new SqlQuery("SELECT 1337", ResultFormat.OBJECT, false, false, false, (Map)queryContext, null), Response.Status.BAD_REQUEST.getStatusCode());
        this.validateInvalidInputError(exception, "Query context parameter [sqlInsertSegmentGranularity] is not allowed");
        this.checkSqlRequestLog(false);
    }

    private void checkSqlRequestLog(boolean success) {
        this.checkSqlRequestLog(success, CalciteTests.REGULAR_USER_AUTH_RESULT.getIdentity());
    }

    private void checkSqlRequestLog(boolean success, String user) {
        Assert.assertEquals((long)1L, (long)this.testRequestLogger.getSqlQueryLogs().size());
        Map stats = ((RequestLogLine)this.testRequestLogger.getSqlQueryLogs().get(0)).getQueryStats().getStats();
        Map queryContext = ((RequestLogLine)this.testRequestLogger.getSqlQueryLogs().get(0)).getSqlQueryContext();
        Assert.assertEquals((Object)success, stats.get("success"));
        Assert.assertEquals((Object)user, stats.get("identity"));
        Assert.assertTrue((boolean)stats.containsKey("sqlQuery/time"));
        Assert.assertTrue((boolean)stats.containsKey("sqlQuery/planningTimeMs"));
        Assert.assertTrue((boolean)queryContext.containsKey("sqlQueryId"));
        if (success) {
            Assert.assertTrue((boolean)stats.containsKey("sqlQuery/bytes"));
        } else {
            Assert.assertTrue((boolean)stats.containsKey("exception"));
        }
    }

    private static SqlQuery createSimpleQueryWithId(String sqlQueryId, String sql) {
        return new SqlQuery(sql, null, false, false, false, (Map)ImmutableMap.of((Object)"sqlQueryId", (Object)sqlQueryId), null);
    }

    private Pair<ErrorResponse, List<Map<String, Object>>> doPost(SqlQuery query) throws Exception {
        return this.doPost(query, new TypeReference<List<Map<String, Object>>>(){});
    }

    private <T> Pair<ErrorResponse, T> doPost(SqlQuery query, TypeReference<T> typeReference) throws Exception {
        return this.doPost(query, this.req, typeReference);
    }

    private Pair<ErrorResponse, String> doPostRaw(SqlQuery query) throws Exception {
        return this.doPostRaw(query, this.req);
    }

    private <T> Pair<ErrorResponse, T> doPost(SqlQuery query, MockHttpServletRequest req, TypeReference<T> typeReference) throws Exception {
        Pair<ErrorResponse, String> pair = this.doPostRaw(query, req);
        if (pair.rhs == null) {
            return pair;
        }
        return Pair.of((Object)((ErrorResponse)pair.lhs), (Object)JSON_MAPPER.readValue((String)pair.rhs, typeReference));
    }

    private Pair<ErrorResponse, String> doPostRaw(SqlQuery query, MockHttpServletRequest req) throws Exception {
        MockHttpServletResponse response = this.postForAsyncResponse(query, req);
        if (response.getStatus() == 200) {
            return Pair.of(null, (Object)new String(response.baos.toByteArray(), StandardCharsets.UTF_8));
        }
        return Pair.of((Object)((ErrorResponse)JSON_MAPPER.readValue(response.baos.toByteArray(), ErrorResponse.class)), null);
    }

    @Nonnull
    private MockHttpServletResponse postForAsyncResponse(SqlQuery query, MockHttpServletRequest req) {
        MockHttpServletResponse response = MockHttpServletResponse.forRequest((MockHttpServletRequest)req);
        Object explicitQueryId = query.getContext().get("queryId");
        Object explicitSqlQueryId = query.getContext().get("sqlQueryId");
        Assert.assertNull((Object)this.resource.doPost(query, (HttpServletRequest)req));
        String actualQueryId = response.getHeader("X-Druid-Query-Id");
        String actualSqlQueryId = response.getHeader("X-Druid-SQL-Query-Id");
        this.validateQueryIds(explicitQueryId, explicitSqlQueryId, actualQueryId, actualSqlQueryId);
        return response;
    }

    private void assertStatusAndCommonHeaders(MockHttpServletResponse queryResponse, int statusCode) {
        Assert.assertEquals((long)statusCode, (long)queryResponse.getStatus());
        Assert.assertEquals((Object)"application/json", (Object)queryResponse.getContentType());
        Assert.assertNotNull((Object)queryResponse.getHeader("X-Druid-Query-Id"));
        Assert.assertNotNull((Object)queryResponse.getHeader("X-Druid-SQL-Query-Id"));
    }

    private <T> T deserializeResponse(MockHttpServletResponse resp, Class<T> clazz) throws IOException {
        return (T)JSON_MAPPER.readValue(resp.baos.toByteArray(), clazz);
    }

    private Response postForSyncResponse(SqlQuery query, MockHttpServletRequest req) {
        Object explicitQueryId = query.getContext().get("queryId");
        Object explicitSqlQueryId = query.getContext().get("sqlQueryId");
        Response response = this.resource.doPost(query, (HttpServletRequest)req);
        Object actualQueryId = this.getHeader(response, "X-Druid-Query-Id");
        Object actualSqlQueryId = this.getHeader(response, "X-Druid-SQL-Query-Id");
        this.validateQueryIds(explicitQueryId, explicitSqlQueryId, actualQueryId, actualSqlQueryId);
        return response;
    }

    private ErrorResponse postSyncForException(String s, int expectedStatus) throws IOException {
        return this.postSyncForException(SqlResourceTest.createSimpleQueryWithId("id", s), expectedStatus);
    }

    private ErrorResponse postSyncForException(SqlQuery query, int expectedStatus) throws IOException {
        Response response = this.postForSyncResponse(query, this.req);
        this.assertStatusAndCommonHeaders(response, expectedStatus);
        return this.deserializeResponse(response, ErrorResponse.class);
    }

    private <T> T deserializeResponse(Response resp, Class<T> clazz) throws IOException {
        return (T)JSON_MAPPER.readValue(SqlResourceTest.responseToByteArray(resp), clazz);
    }

    public static byte[] responseToByteArray(Response resp) throws IOException {
        if (resp.getEntity() instanceof StreamingOutput) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ((StreamingOutput)resp.getEntity()).write((OutputStream)baos);
            return baos.toByteArray();
        }
        return JSON_MAPPER.writeValueAsBytes(resp.getEntity());
    }

    private String getContentType(Response resp) {
        return this.getHeader(resp, "Content-Type").toString();
    }

    @Nullable
    private Object getHeader(Response resp, String header) {
        List objects = (List)resp.getMetadata().get((Object)header);
        if (objects == null) {
            return null;
        }
        return Iterables.getOnlyElement((Iterable)objects);
    }

    private void assertStatusAndCommonHeaders(Response queryResponse, int statusCode) {
        Assert.assertEquals((long)statusCode, (long)queryResponse.getStatus());
        Assert.assertEquals((Object)"application/json", (Object)this.getContentType(queryResponse));
        Assert.assertNotNull((Object)this.getHeader(queryResponse, "X-Druid-Query-Id"));
        Assert.assertNotNull((Object)this.getHeader(queryResponse, "X-Druid-SQL-Query-Id"));
    }

    private void validateQueryIds(Object explicitQueryId, Object explicitSqlQueryId, Object actualQueryId, Object actualSqlQueryId) {
        if (explicitQueryId == null) {
            if (null != explicitSqlQueryId) {
                Assert.assertEquals((Object)explicitSqlQueryId, (Object)actualQueryId);
                Assert.assertEquals((Object)explicitSqlQueryId, (Object)actualSqlQueryId);
            } else {
                Assert.assertNotNull((Object)actualQueryId);
                Assert.assertNotNull((Object)actualSqlQueryId);
            }
        } else if (explicitSqlQueryId == null) {
            Assert.assertEquals((Object)explicitQueryId, (Object)actualQueryId);
            Assert.assertEquals((Object)explicitQueryId, (Object)actualSqlQueryId);
        } else {
            Assert.assertEquals((Object)explicitQueryId, (Object)actualQueryId);
            Assert.assertEquals((Object)explicitSqlQueryId, (Object)actualSqlQueryId);
        }
    }

    private MockHttpServletRequest makeSuperUserReq() {
        return this.makeExpectedReq(CalciteTests.SUPER_USER_AUTH_RESULT);
    }

    private MockHttpServletRequest makeRegularUserReq() {
        return this.makeExpectedReq(CalciteTests.REGULAR_USER_AUTH_RESULT);
    }

    private MockHttpServletRequest makeExpectedReq(AuthenticationResult authenticationResult) {
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.attributes.put("Druid-Authentication-Result", authenticationResult);
        req.remoteAddr = "1.2.3.4";
        return req;
    }

    private MockHttpServletRequest makeRequestForCancel() {
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.attributes.put("Druid-Authentication-Result", CalciteTests.REGULAR_USER_AUTH_RESULT);
        return req;
    }

    private static Function<Sequence<Object[]>, Sequence<Object[]>> errorAfterSecondRowMapFn() {
        return results -> {
            AtomicLong rows = new AtomicLong();
            return results.flatMap(row -> Sequences.simple((Iterable)new AbstractList<Object[]>(){

                @Override
                public Object[] get(int index) {
                    return row;
                }

                @Override
                public int size() {
                    return 1000;
                }
            })).map(row -> {
                if (rows.incrementAndGet() == 3L) {
                    throw new ISE("Oh no!", new Object[0]);
                }
                return row;
            });
        };
    }

    private DruidException validateErrorResponse(ErrorResponse errorResponse, String errorCode, DruidException.Persona targetPersona, DruidException.Category category, String messageContainsString) {
        Assert.assertNotNull((Object)errorResponse);
        DruidException exception = errorResponse.getUnderlyingException();
        Assert.assertEquals((Object)errorCode, (Object)exception.getErrorCode());
        Assert.assertEquals((Object)targetPersona, (Object)exception.getTargetPersona());
        Assert.assertEquals((Object)category, (Object)exception.getCategory());
        if (messageContainsString == null) {
            Assert.assertNull((Object)exception.getMessage());
        } else {
            MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.containsString((String)messageContainsString));
        }
        return exception;
    }

    private DruidException validateInvalidSqlError(ErrorResponse response, String containsString) {
        DruidException exception = this.validateInvalidInputError(response, containsString);
        Assert.assertEquals((Object)"sql", (Object)exception.getContextValue("sourceType"));
        return exception;
    }

    @Nonnull
    private DruidException validateInvalidInputError(ErrorResponse response, String containsString) {
        return this.validateErrorResponse(response, "invalidInput", DruidException.Persona.USER, DruidException.Category.INVALID_INPUT, containsString);
    }

    private DruidException validateLegacyQueryExceptionErrorResponse(ErrorResponse errorResponse, String legacyCode, String errorClass, String messageContainsString) {
        DruidException exception = this.validateErrorResponse(errorResponse, "legacyQueryException", DruidException.Persona.OPERATOR, SqlResourceTest.convertToCategory(legacyCode), messageContainsString);
        Assert.assertEquals((Object)legacyCode, (Object)exception.getContextValue("legacyErrorCode"));
        Assert.assertEquals((Object)errorClass, (Object)exception.getContextValue("errorClass"));
        return exception;
    }

    private static DruidException.Category convertToCategory(String legacyErrorCode) {
        switch (QueryException.fromErrorCode((String)legacyErrorCode)) {
            case USER_ERROR: {
                return DruidException.Category.INVALID_INPUT;
            }
            case UNAUTHORIZED: {
                return DruidException.Category.UNAUTHORIZED;
            }
            case CAPACITY_EXCEEDED: {
                return DruidException.Category.CAPACITY_EXCEEDED;
            }
            case QUERY_RUNTIME_FAILURE: {
                return DruidException.Category.RUNTIME_FAILURE;
            }
            case CANCELED: {
                return DruidException.Category.CANCELED;
            }
            case UNKNOWN: {
                return DruidException.Category.UNCATEGORIZED;
            }
            case UNSUPPORTED: {
                return DruidException.Category.UNSUPPORTED;
            }
            case TIMEOUT: {
                return DruidException.Category.TIMEOUT;
            }
        }
        return DruidException.Category.UNCATEGORIZED;
    }

    static {
        SCHEDULER_BAGGAGE = new AtomicReference();
    }

    private static class TestHttpStatement
    extends HttpStatement {
        private final SettableSupplier<NonnullPair<CountDownLatch, Boolean>> validateAndAuthorizeLatchSupplier;
        private final SettableSupplier<NonnullPair<CountDownLatch, Boolean>> planLatchSupplier;
        private final SettableSupplier<NonnullPair<CountDownLatch, Boolean>> executeLatchSupplier;
        private final SettableSupplier<Function<Sequence<Object[]>, Sequence<Object[]>>> sequenceMapFnSupplier;
        private final SettableSupplier<ResponseContext> responseContextSupplier;
        private final Consumer<DirectStatement> onExecute;

        private TestHttpStatement(SqlToolbox lifecycleContext, SqlQuery sqlQuery, HttpServletRequest req, SettableSupplier<NonnullPair<CountDownLatch, Boolean>> validateAndAuthorizeLatchSupplier, SettableSupplier<NonnullPair<CountDownLatch, Boolean>> planLatchSupplier, SettableSupplier<NonnullPair<CountDownLatch, Boolean>> executeLatchSupplier, SettableSupplier<Function<Sequence<Object[]>, Sequence<Object[]>>> sequenceMapFnSupplier, SettableSupplier<ResponseContext> responseContextSupplier, Consumer<DirectStatement> onAuthorize) {
            super(lifecycleContext, sqlQuery, req);
            this.validateAndAuthorizeLatchSupplier = validateAndAuthorizeLatchSupplier;
            this.planLatchSupplier = planLatchSupplier;
            this.executeLatchSupplier = executeLatchSupplier;
            this.sequenceMapFnSupplier = sequenceMapFnSupplier;
            this.responseContextSupplier = responseContextSupplier;
            this.onExecute = onAuthorize;
        }

        protected void authorize(DruidPlanner planner, Function<Set<ResourceAction>, AuthorizationResult> authorizer) {
            if (this.validateAndAuthorizeLatchSupplier.get() != null) {
                if (((Boolean)((NonnullPair)this.validateAndAuthorizeLatchSupplier.get()).rhs).booleanValue()) {
                    super.authorize(planner, authorizer);
                    ((CountDownLatch)((NonnullPair)this.validateAndAuthorizeLatchSupplier.get()).lhs).countDown();
                } else {
                    try {
                        if (!((CountDownLatch)((NonnullPair)this.validateAndAuthorizeLatchSupplier.get()).lhs).await(60L, TimeUnit.SECONDS)) {
                            throw new RuntimeException("Latch timed out");
                        }
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    super.authorize(planner, authorizer);
                }
            } else {
                super.authorize(planner, authorizer);
            }
        }

        public PlannerResult createPlan(DruidPlanner planner) {
            NonnullPair planLatch = (NonnullPair)this.planLatchSupplier.get();
            if (planLatch != null) {
                if (((Boolean)planLatch.rhs).booleanValue()) {
                    PlannerResult result = super.createPlan(planner);
                    ((CountDownLatch)planLatch.lhs).countDown();
                    return result;
                }
                try {
                    if (!((CountDownLatch)planLatch.lhs).await(60L, TimeUnit.SECONDS)) {
                        throw new RuntimeException("Latch timed out");
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                return super.createPlan(planner);
            }
            return super.createPlan(planner);
        }

        public DirectStatement.ResultSet plan() {
            this.onExecute.accept((DirectStatement)this);
            return super.plan();
        }

        public DirectStatement.ResultSet createResultSet(PlannerResult plannerResult) {
            return new DirectStatement.ResultSet(plannerResult){

                public QueryResponse<Object[]> run() {
                    Function<Sequence, Sequence> sequenceMapFn = Optional.ofNullable((Function)sequenceMapFnSupplier.get()).orElse(Function.identity());
                    NonnullPair executeLatch = (NonnullPair)executeLatchSupplier.get();
                    if (executeLatch != null) {
                        if (((Boolean)executeLatch.rhs).booleanValue()) {
                            QueryResponse resp = super.run();
                            Sequence sequence = (Sequence)sequenceMapFn.apply(resp.getResults());
                            ((CountDownLatch)executeLatch.lhs).countDown();
                            ResponseContext respContext = resp.getResponseContext();
                            respContext.merge((ResponseContext)responseContextSupplier.get());
                            return new QueryResponse(sequence, respContext);
                        }
                        try {
                            if (!((CountDownLatch)executeLatch.lhs).await(60L, TimeUnit.SECONDS)) {
                                throw new RuntimeException("Latch timed out");
                            }
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    QueryResponse resp = super.run();
                    Sequence sequence = (Sequence)sequenceMapFn.apply(resp.getResults());
                    ResponseContext respContext = resp.getResponseContext();
                    respContext.merge((ResponseContext)responseContextSupplier.get());
                    return new QueryResponse(sequence, respContext);
                }
            };
        }
    }
}

