/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.destination;

import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.InjectableValues;
import java.io.IOException;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.sql.destination.ExportDestination;
import org.apache.druid.storage.ExportStorageProvider;
import org.apache.druid.storage.StorageConfig;
import org.apache.druid.storage.StorageConnectorModule;
import org.apache.druid.storage.local.LocalFileExportStorageProvider;
import org.junit.Assert;
import org.junit.Test;

public class ExportDestinationTest {
    @Test
    public void testSerde() throws IOException {
        ExportDestination exportDestination = new ExportDestination((ExportStorageProvider)new LocalFileExportStorageProvider("/basepath/export"));
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        objectMapper.registerModules((Iterable)new StorageConnectorModule().getJacksonModules());
        objectMapper.setInjectableValues(new InjectableValues(){

            public Object findInjectableValue(Object valueId, DeserializationContext ctxt, BeanProperty forProperty, Object beanInstance) {
                if (((String)valueId).contains("StorageConfig")) {
                    return new StorageConfig("/");
                }
                throw new RuntimeException();
            }
        });
        byte[] bytes = objectMapper.writeValueAsBytes((Object)exportDestination);
        ExportDestination deserialized = (ExportDestination)objectMapper.readValue(bytes, ExportDestination.class);
        Assert.assertEquals((Object)exportDestination, (Object)deserialized);
    }
}

