/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.inject.Injector;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.ResourceInputSource;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.DoubleDimensionSchema;
import org.apache.druid.data.input.impl.JsonInputFormat;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.GlobalTableDataSource;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.NestedDataTestUtils;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.first.DoubleFirstAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.first.LongFirstAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.first.StringFirstAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.last.DoubleLastAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.last.FloatLastAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.last.LongLastAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.last.StringLastAggregatorFactory;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.druid.segment.AutoTypeColumnSchema;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.SegmentWrangler;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.column.StringEncodingStrategy;
import org.apache.druid.segment.generator.GeneratorBasicSchemas;
import org.apache.druid.segment.generator.GeneratorSchemaInfo;
import org.apache.druid.segment.generator.SegmentGenerator;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.join.JoinableFactoryWrapper;
import org.apache.druid.segment.join.table.RowBasedIndexedTable;
import org.apache.druid.segment.transform.TransformSpec;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.server.QueryScheduler;
import org.apache.druid.server.QueryStackTests;
import org.apache.druid.server.SpecificSegmentsQuerySegmentWalker;
import org.apache.druid.sql.calcite.util.QueryFrameworkUtils;
import org.apache.druid.sql.calcite.util.datasets.TestDataSet;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;

public class TestDataBuilder {
    private static final ObjectMapper MAPPER;
    public static final String TIMESTAMP_COLUMN = "t";
    public static final GlobalTableDataSource CUSTOM_TABLE;
    public static QueryableIndex QUERYABLE_INDEX_FOR_BENCHMARK_DATASOURCE;
    public static final JoinableFactory CUSTOM_ROW_TABLE_JOINABLE;
    public static final JsonInputFormat DEFAULT_JSON_INPUT_FORMAT;
    private static final InputRowSchema FOO_SCHEMA;
    private static final InputRowSchema LOTS_OF_COLUMNS_SCHEMA;
    public static final IncrementalIndexSchema INDEX_SCHEMA;
    private static final IncrementalIndexSchema INDEX_SCHEMA_DIFFERENT_DIM3_M1_TYPES;
    private static final IncrementalIndexSchema INDEX_SCHEMA_WITH_X_COLUMNS;
    public static final IncrementalIndexSchema INDEX_SCHEMA_NUMERIC_DIMS;
    public static final IncrementalIndexSchema INDEX_SCHEMA_LOTS_O_COLUMNS;
    private static final List<String> USER_VISIT_DIMS;
    public static final List<ImmutableMap<String, Object>> RAW_ROWS1;
    public static final List<InputRow> RAW_ROWS1_X;
    public static final List<InputRow> ROWS1;
    public static final List<ImmutableMap<String, Object>> RAW_ROWS1_WITH_NUMERIC_DIMS;
    public static final List<InputRow> ROWS1_WITH_NUMERIC_DIMS;
    public static final List<ImmutableMap<String, Object>> RAW_ROWS2;
    public static final List<InputRow> ROWS2;
    public static final List<ImmutableMap<String, Object>> RAW_ROWS1_WITH_FULL_TIMESTAMP;
    public static final List<InputRow> ROWS1_WITH_FULL_TIMESTAMP;
    public static final List<InputRow> FORBIDDEN_ROWS;
    public static final List<InputRow> ROWS_LOTS_OF_COLUMNS;
    public static List<InputRow> USER_VISIT_ROWS;
    private static final InlineDataSource JOINABLE_BACKING_DATA;
    private static final Set<String> KEY_COLUMNS;
    private static final RowBasedIndexedTable JOINABLE_TABLE;

    public static QueryableIndex makeWikipediaIndex(File tmpDir) {
        try {
            File directory = new File(tmpDir, StringUtils.format((String)"wikipedia-index-%s", (Object[])new Object[]{UUID.randomUUID()}));
            IncrementalIndex index = TestIndex.makeWikipediaIncrementalIndex();
            TestIndex.INDEX_MERGER.persist(index, directory, IndexSpec.DEFAULT, null);
            return TestIndex.INDEX_IO.loadIndex(directory);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static QueryableIndex makeWikipediaIndexWithAggregation(File tmpDir) {
        List<DimensionSchema> dimensions = Arrays.asList(new StringDimensionSchema("channel"), new StringDimensionSchema("cityName"), new StringDimensionSchema("comment"), new StringDimensionSchema("countryIsoCode"), new StringDimensionSchema("countryName"), new StringDimensionSchema("isAnonymous"), new StringDimensionSchema("isMinor"), new StringDimensionSchema("isNew"), new StringDimensionSchema("isRobot"), new StringDimensionSchema("isUnpatrolled"), new StringDimensionSchema("metroCode"), new StringDimensionSchema("namespace"), new StringDimensionSchema("page"), new StringDimensionSchema("regionIsoCode"), new StringDimensionSchema("regionName"), new StringDimensionSchema("user"));
        return IndexBuilder.create().tmpDir(new File(tmpDir, "wikipedia1")).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(new IncrementalIndexSchema.Builder().withRollup(true).withTimestampSpec(new TimestampSpec("time", null, null)).withDimensionsSpec(new DimensionsSpec(dimensions)).withMetrics(new AggregatorFactory[]{new LongLastAggregatorFactory("long_last_added", "added", "__time"), new LongFirstAggregatorFactory("long_first_added", "added", "__time"), new FloatLastAggregatorFactory("float_last_added", "added", "__time"), new FloatLastAggregatorFactory("float_first_added", "added", "__time"), new DoubleLastAggregatorFactory("double_last_added", "added", "__time"), new DoubleFirstAggregatorFactory("double_first_added", "added", "__time"), new StringFirstAggregatorFactory("string_first_added", "comment", "__time", Integer.valueOf(1000)), new StringLastAggregatorFactory("string_last_added", "comment", "__time", Integer.valueOf(1000))}).build()).inputSource((InputSource)ResourceInputSource.of((ClassLoader)TestIndex.class.getClassLoader(), (String)"wikipedia/wikiticker-2015-09-12-sampled.json.gz")).inputFormat((InputFormat)DEFAULT_JSON_INPUT_FORMAT).inputTmpDir(new File(tmpDir, "tmpWikipedia1")).buildMMappedIndex();
    }

    public static SpecificSegmentsQuerySegmentWalker createMockWalker(Injector injector, QueryRunnerFactoryConglomerate conglomerate, File tmpDir) {
        return TestDataBuilder.createMockWalker(injector, conglomerate, tmpDir, QueryStackTests.DEFAULT_NOOP_SCHEDULER, QueryFrameworkUtils.createDefaultJoinableFactory(injector));
    }

    public static SpecificSegmentsQuerySegmentWalker createMockWalker(Injector injector, QueryRunnerFactoryConglomerate conglomerate, File tmpDir, QueryScheduler scheduler) {
        return TestDataBuilder.createMockWalker(injector, conglomerate, tmpDir, scheduler, (JoinableFactory)null);
    }

    public static SpecificSegmentsQuerySegmentWalker createMockWalker(Injector injector, QueryRunnerFactoryConglomerate conglomerate, File tmpDir, QueryScheduler scheduler, JoinableFactory joinableFactory) {
        JoinableFactory joinableFactoryToUse = joinableFactory == null ? QueryStackTests.makeJoinableFactoryForLookup((LookupExtractorFactoryContainerProvider)((LookupExtractorFactoryContainerProvider)injector.getInstance(LookupExtractorFactoryContainerProvider.class))) : joinableFactory;
        return TestDataBuilder.createMockWalker(injector, conglomerate, tmpDir, scheduler, new JoinableFactoryWrapper(joinableFactoryToUse));
    }

    public static SpecificSegmentsQuerySegmentWalker createMockWalker(Injector injector, QueryRunnerFactoryConglomerate conglomerate, File tmpDir, QueryScheduler scheduler, JoinableFactoryWrapper joinableFactoryWrapper) {
        SpecificSegmentsQuerySegmentWalker walker = SpecificSegmentsQuerySegmentWalker.createWalker((Injector)injector, (QueryRunnerFactoryConglomerate)conglomerate, (SegmentWrangler)((SegmentWrangler)injector.getInstance(SegmentWrangler.class)), (JoinableFactoryWrapper)joinableFactoryWrapper, (QueryScheduler)scheduler);
        return TestDataBuilder.addDataSetsToWalker(tmpDir, walker);
    }

    public static SpecificSegmentsQuerySegmentWalker addDataSetsToWalker(File tmpDir, SpecificSegmentsQuerySegmentWalker walker) {
        QueryableIndex index1 = IndexBuilder.create().tmpDir(new File(tmpDir, "1")).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(INDEX_SCHEMA).rows(ROWS1).buildMMappedIndex();
        QueryableIndex index2 = IndexBuilder.create().tmpDir(new File(tmpDir, "2")).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(INDEX_SCHEMA_DIFFERENT_DIM3_M1_TYPES).rows(ROWS2).buildMMappedIndex();
        QueryableIndex forbiddenIndex = IndexBuilder.create().tmpDir(new File(tmpDir, "forbidden")).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(INDEX_SCHEMA).rows(FORBIDDEN_ROWS).buildMMappedIndex();
        QueryableIndex index4 = IndexBuilder.create().tmpDir(new File(tmpDir, "4")).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(INDEX_SCHEMA).rows(ROWS1_WITH_FULL_TIMESTAMP).buildMMappedIndex();
        QueryableIndex indexLotsOfColumns = IndexBuilder.create().tmpDir(new File(tmpDir, "5")).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(INDEX_SCHEMA_LOTS_O_COLUMNS).rows(ROWS_LOTS_OF_COLUMNS).buildMMappedIndex();
        QueryableIndex someDatasourceIndex = IndexBuilder.create().tmpDir(new File(tmpDir, "6")).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(INDEX_SCHEMA).rows(ROWS1).buildMMappedIndex();
        QueryableIndex someXDatasourceIndex = IndexBuilder.create().tmpDir(new File(tmpDir, "7")).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(INDEX_SCHEMA_WITH_X_COLUMNS).rows(RAW_ROWS1_X).buildMMappedIndex();
        QueryableIndex userVisitIndex = IndexBuilder.create().tmpDir(new File(tmpDir, "8")).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(INDEX_SCHEMA).rows(USER_VISIT_ROWS).buildMMappedIndex();
        QueryableIndex arraysIndex = IndexBuilder.create().tmpDir(new File(tmpDir, "9")).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(new IncrementalIndexSchema.Builder().withTimestampSpec(NestedDataTestUtils.AUTO_SCHEMA.getTimestampSpec()).withDimensionsSpec(NestedDataTestUtils.AUTO_SCHEMA.getDimensionsSpec()).withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("cnt")}).withRollup(false).build()).inputSource((InputSource)ResourceInputSource.of((ClassLoader)NestedDataTestUtils.class.getClassLoader(), (String)"nested-array-test-data.json")).inputFormat((InputFormat)DEFAULT_JSON_INPUT_FORMAT).inputTmpDir(new File(tmpDir, "9-input")).buildMMappedIndex();
        return walker.add(DataSegment.builder().dataSource("foo").interval(index1.getDataInterval()).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build(), index1).add(DataSegment.builder().dataSource("foo2").interval(index2.getDataInterval()).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build(), index2).add(DataSegment.builder().dataSource("restrictedDatasource_m1_is_6").interval(index1.getDataInterval()).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build(), index1).add(DataSegment.builder().dataSource("forbiddenDatasource").interval(forbiddenIndex.getDataInterval()).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build(), forbiddenIndex).add((TestDataSet)TestDataSet.NUMFOO, new File(tmpDir, "3")).add(DataSegment.builder().dataSource("foo4").interval(index4.getDataInterval()).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build(), index4).add(DataSegment.builder().dataSource("lotsocolumns").interval(indexLotsOfColumns.getDataInterval()).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build(), indexLotsOfColumns).add(DataSegment.builder().dataSource("some_datasource").interval(indexLotsOfColumns.getDataInterval()).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build(), someDatasourceIndex).add(DataSegment.builder().dataSource("somexdatasource").interval(indexLotsOfColumns.getDataInterval()).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build(), someXDatasourceIndex).add((TestDataSet)TestDataSet.BROADCAST, new File(tmpDir, "3a")).add(DataSegment.builder().dataSource("visits").interval(userVisitIndex.getDataInterval()).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build(), userVisitIndex).add(DataSegment.builder().dataSource("wikipedia").interval(Intervals.of((String)"2015-09-12/2015-09-13")).version("1").shardSpec((ShardSpec)new NumberedShardSpec(0, 0)).size(0L).build(), TestDataBuilder.makeWikipediaIndex(tmpDir)).add(DataSegment.builder().dataSource("wikipedia_first_last").interval(Intervals.of((String)"2015-09-12/2015-09-13")).version("1").shardSpec((ShardSpec)new NumberedShardSpec(0, 0)).size(0L).build(), TestDataBuilder.makeWikipediaIndexWithAggregation(tmpDir)).add(DataSegment.builder().dataSource("arrays").version("1").interval(arraysIndex.getDataInterval()).shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(1))).size(0L).build(), arraysIndex);
    }

    public static void attachIndexesForDrillTestDatasources(SpecificSegmentsQuerySegmentWalker segmentWalker, File tmpDir) {
        TestDataBuilder.attachIndexForDrillTestDatasource(segmentWalker, "tblWnulls.parquet", tmpDir);
        TestDataBuilder.attachIndexForDrillTestDatasource(segmentWalker, "smlTbl.parquet", tmpDir);
        TestDataBuilder.attachIndexForDrillTestDatasource(segmentWalker, "allTypsUniq.parquet", tmpDir);
        TestDataBuilder.attachIndexForDrillTestDatasource(segmentWalker, "fewRowsAllData.parquet", tmpDir);
        TestDataBuilder.attachIndexForDrillTestDatasource(segmentWalker, "t_alltype.parquet", tmpDir);
    }

    public static void attachIndexesForBenchmarkDatasource(SpecificSegmentsQuerySegmentWalker segmentWalker) {
        QueryableIndex queryableIndex = TestDataBuilder.getQueryableIndexForBenchmarkDatasource();
        segmentWalker.add(DataSegment.builder().dataSource("benchmark_ds").interval(Intervals.ETERNITY).version("1").shardSpec((ShardSpec)new NumberedShardSpec(0, 0)).size(0L).build(), queryableIndex);
    }

    private static void attachIndexForDrillTestDatasource(SpecificSegmentsQuerySegmentWalker segmentWalker, String dataSource, File tmpDir) {
        QueryableIndex queryableIndex = TestDataBuilder.getQueryableIndexForDrillDatasource(dataSource, tmpDir);
        segmentWalker.add(DataSegment.builder().dataSource(dataSource).interval(Intervals.ETERNITY).version("1").shardSpec((ShardSpec)new NumberedShardSpec(0, 0)).size(0L).build(), queryableIndex);
    }

    public static QueryableIndex getQueryableIndexForDrillDatasource(String datasource, File parentTempDir) {
        IncrementalIndexSchema indexSchema = new IncrementalIndexSchema.Builder().withDimensionsSpec(TestDataBuilder.getDimensionSpecForDrillDatasource(datasource)).withRollup(false).build();
        Iterable<InputRow> inputRowsForDrillDatasource = TestDataBuilder.getInputRowsForDrillDatasource(datasource);
        return IndexBuilder.create().tmpDir(new File(parentTempDir, datasource)).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(indexSchema).rows(inputRowsForDrillDatasource).buildMMappedIndex();
    }

    public static QueryableIndex getQueryableIndexForBenchmarkDatasource() {
        if (QUERYABLE_INDEX_FOR_BENCHMARK_DATASOURCE == null) {
            throw new RuntimeException("Queryable index was not populated for benchmark datasource.");
        }
        return QUERYABLE_INDEX_FOR_BENCHMARK_DATASOURCE;
    }

    public static void makeQueryableIndexForBenchmarkDatasource(Closer closer, int rowsPerSegment) {
        if (closer == null) {
            throw new RuntimeException("Closer not supplied for generating segments, exiting.");
        }
        GeneratorSchemaInfo schemaInfo = (GeneratorSchemaInfo)GeneratorBasicSchemas.SCHEMA_MAP.get("basic");
        DataSegment dataSegment = schemaInfo.makeSegmentDescriptor("benchmark_ds");
        SegmentGenerator segmentGenerator = (SegmentGenerator)closer.register((Closeable)new SegmentGenerator());
        List columnSchemas = schemaInfo.getDimensionsSpec().getDimensions().stream().map(x -> new AutoTypeColumnSchema(x.getName(), null)).collect(Collectors.toList());
        QUERYABLE_INDEX_FOR_BENCHMARK_DATASOURCE = segmentGenerator.generate(dataSegment, schemaInfo, DimensionsSpec.builder().setDimensions(columnSchemas).build(), TransformSpec.NONE, IndexSpec.builder().withStringDictionaryEncoding((StringEncodingStrategy)new StringEncodingStrategy.Utf8()).build(), Granularities.NONE, rowsPerSegment);
    }

    private static DimensionsSpec getDimensionSpecForDrillDatasource(String datasource) {
        switch (datasource) {
            case "tblWnulls.parquet": {
                return new DimensionsSpec((List)ImmutableList.of((Object)new LongDimensionSchema("c1"), (Object)new StringDimensionSchema("c2")));
            }
            case "smlTbl.parquet": {
                return new DimensionsSpec((List)ImmutableList.of((Object)new LongDimensionSchema("col_int"), (Object)new LongDimensionSchema("col_bgint"), (Object)new StringDimensionSchema("col_char_2"), (Object)new StringDimensionSchema("col_vchar_52"), (Object)new LongDimensionSchema("col_tmstmp"), (Object)new LongDimensionSchema("col_dt"), (Object)new StringDimensionSchema("col_booln"), (Object)new DoubleDimensionSchema("col_dbl"), (Object)new LongDimensionSchema("col_tm")));
            }
            case "allTypsUniq.parquet": {
                return new DimensionsSpec((List)ImmutableList.of((Object)new LongDimensionSchema("col0"), (Object)new LongDimensionSchema("col1"), (Object)new DoubleDimensionSchema("col2"), (Object)new DoubleDimensionSchema("col3"), (Object)new LongDimensionSchema("col4"), (Object)new LongDimensionSchema("col5"), (Object)new LongDimensionSchema("col6"), (Object)new StringDimensionSchema("col7"), (Object)new StringDimensionSchema("col8"), (Object)new StringDimensionSchema("col9")));
            }
            case "fewRowsAllData.parquet": {
                return new DimensionsSpec((List)ImmutableList.of((Object)new LongDimensionSchema("col0"), (Object)new LongDimensionSchema("col1"), (Object)new StringDimensionSchema("col2"), (Object)new StringDimensionSchema("col3"), (Object)new LongDimensionSchema("col4"), (Object)new LongDimensionSchema("col5"), (Object)new StringDimensionSchema("col6"), (Object)new DoubleDimensionSchema("col7"), (Object)new LongDimensionSchema("col8")));
            }
            case "t_alltype.parquet": {
                return new DimensionsSpec((List)ImmutableList.of((Object)new LongDimensionSchema("c1"), (Object)new LongDimensionSchema("c2"), (Object)new LongDimensionSchema("c3"), (Object)new StringDimensionSchema("c4"), (Object)new StringDimensionSchema("c5"), (Object)new LongDimensionSchema("c6"), (Object)new LongDimensionSchema("c7"), (Object)new StringDimensionSchema("c8"), (Object)new DoubleDimensionSchema("c9")));
            }
        }
        throw new RuntimeException("Invalid datasource supplied for drill tests");
    }

    private static Iterable<InputRow> getInputRowsForDrillDatasource(String datasource) {
        DimensionsSpec dimensionSpecForDrillDatasource = TestDataBuilder.getDimensionSpecForDrillDatasource(datasource);
        return () -> {
            try {
                return Iterators.transform((Iterator)MAPPER.readerFor(Map.class).readValues(ClassLoader.getSystemResource("drill/window/datasources/" + datasource + ".json")), input -> new MapBasedInputRow(0L, dimensionSpecForDrillDatasource.getDimensionNames(), input));
            }
            catch (IOException e) {
                throw new RE((Throwable)e, "problem reading file", new Object[0]);
            }
        };
    }

    private static MapBasedInputRow toRow(String time, List<String> dimensions, Map<String, Object> event) {
        return new MapBasedInputRow(DateTimes.ISO_DATE_OPTIONAL_TIME.parse(time), dimensions, event);
    }

    public static InputRow createRow(Map<String, ?> map) {
        return MapInputRowParser.parse((InputRowSchema)FOO_SCHEMA, map);
    }

    public static InputRow createRow(Map<String, ?> map, InputRowSchema inputRowSchema) {
        return MapInputRowParser.parse((InputRowSchema)inputRowSchema, map);
    }

    public static InputRow createRow(Object t, String dim1, String dim2, double m1) {
        return MapInputRowParser.parse((InputRowSchema)FOO_SCHEMA, (Map)ImmutableMap.of((Object)TIMESTAMP_COLUMN, (Object)new DateTime(t, (Chronology)ISOChronology.getInstanceUTC()).getMillis(), (Object)"dim1", (Object)dim1, (Object)"dim2", (Object)dim2, (Object)"m1", (Object)m1));
    }

    /*
     * Exception decompiling
     */
    static {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

