/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.util;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Injector;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.druid.client.InternalQueryConfig;
import org.apache.druid.client.TimelineServerView;
import org.apache.druid.java.util.emitter.core.Emitter;
import org.apache.druid.java.util.emitter.core.NoopEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.DefaultGenericQueryMetricsFactory;
import org.apache.druid.query.DefaultQueryConfig;
import org.apache.druid.query.GenericQueryMetricsFactory;
import org.apache.druid.query.GlobalTableDataSource;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.loading.SegmentCacheManager;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.server.QueryLifecycleFactory;
import org.apache.druid.server.QueryStackTests;
import org.apache.druid.server.SegmentManager;
import org.apache.druid.server.SpecificSegmentsQuerySegmentWalker;
import org.apache.druid.server.log.NoopRequestLogger;
import org.apache.druid.server.log.RequestLogger;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.sql.SqlLifecycleManager;
import org.apache.druid.sql.SqlStatementFactory;
import org.apache.druid.sql.SqlToolbox;
import org.apache.druid.sql.calcite.planner.CatalogResolver;
import org.apache.druid.sql.calcite.planner.DruidOperatorTable;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.planner.PlannerFactory;
import org.apache.druid.sql.calcite.run.SqlEngine;
import org.apache.druid.sql.calcite.schema.BrokerSegmentMetadataCache;
import org.apache.druid.sql.calcite.schema.BrokerSegmentMetadataCacheConfig;
import org.apache.druid.sql.calcite.schema.DruidSchema;
import org.apache.druid.sql.calcite.schema.DruidSchemaCatalog;
import org.apache.druid.sql.calcite.schema.DruidSchemaManager;
import org.apache.druid.sql.calcite.schema.InformationSchema;
import org.apache.druid.sql.calcite.schema.LookupSchema;
import org.apache.druid.sql.calcite.schema.NamedDruidSchema;
import org.apache.druid.sql.calcite.schema.NamedLookupSchema;
import org.apache.druid.sql.calcite.schema.NamedSchema;
import org.apache.druid.sql.calcite.schema.NamedSystemSchema;
import org.apache.druid.sql.calcite.schema.NamedViewSchema;
import org.apache.druid.sql.calcite.schema.NoopDruidSchemaManager;
import org.apache.druid.sql.calcite.schema.PhysicalDatasourceMetadataFactory;
import org.apache.druid.sql.calcite.schema.SystemSchema;
import org.apache.druid.sql.calcite.schema.ViewSchema;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.apache.druid.sql.calcite.util.TestDataBuilder;
import org.apache.druid.sql.calcite.util.TestTimelineServerView;
import org.apache.druid.sql.calcite.view.ViewManager;
import org.easymock.EasyMock;

public class QueryFrameworkUtils {
    public static final String INFORMATION_SCHEMA_NAME = "INFORMATION_SCHEMA";

    public static QueryLifecycleFactory createMockQueryLifecycleFactory(QuerySegmentWalker walker, QueryRunnerFactoryConglomerate conglomerate, AuthorizerMapper authorizerMapper) {
        return new QueryLifecycleFactory(conglomerate, walker, (GenericQueryMetricsFactory)new DefaultGenericQueryMetricsFactory(), new ServiceEmitter("dummy", "dummy", (Emitter)new NoopEmitter()), (RequestLogger)new NoopRequestLogger(), new AuthConfig(), authorizerMapper, Suppliers.ofInstance((Object)new DefaultQueryConfig((Map)ImmutableMap.of())));
    }

    public static SqlStatementFactory createSqlStatementFactory(SqlEngine engine, PlannerFactory plannerFactory, AuthConfig authConfig) {
        SqlToolbox toolbox = new SqlToolbox(engine, plannerFactory, new ServiceEmitter("dummy", "dummy", (Emitter)new NoopEmitter()), (RequestLogger)new NoopRequestLogger(), QueryStackTests.DEFAULT_NOOP_SCHEDULER, new DefaultQueryConfig((Map)ImmutableMap.of()), new SqlLifecycleManager());
        return new SqlStatementFactory(toolbox);
    }

    public static DruidSchemaCatalog createMockRootSchema(Injector injector, QueryRunnerFactoryConglomerate conglomerate, SpecificSegmentsQuerySegmentWalker walker, PlannerConfig plannerConfig, @Nullable ViewManager viewManager, DruidSchemaManager druidSchemaManager, AuthorizerMapper authorizerMapper, CatalogResolver catalogResolver) {
        TestTimelineServerView timelineServerView = new TestTimelineServerView(walker.getSegments());
        return QueryFrameworkUtils.createMockRootSchema(injector, conglomerate, walker, plannerConfig, viewManager, druidSchemaManager, authorizerMapper, catalogResolver, timelineServerView);
    }

    public static DruidSchemaCatalog createMockRootSchema(Injector injector, QueryRunnerFactoryConglomerate conglomerate, SpecificSegmentsQuerySegmentWalker walker, PlannerConfig plannerConfig, @Nullable ViewManager viewManager, DruidSchemaManager druidSchemaManager, AuthorizerMapper authorizerMapper, CatalogResolver catalogResolver, TimelineServerView timelineServerView) {
        DruidSchema druidSchema = QueryFrameworkUtils.createMockSchema(injector, conglomerate, walker, druidSchemaManager, catalogResolver, timelineServerView);
        SystemSchema systemSchema = CalciteTests.createMockSystemSchema(druidSchema, timelineServerView, authorizerMapper);
        LookupSchema lookupSchema = QueryFrameworkUtils.createMockLookupSchema(injector);
        DruidOperatorTable createOperatorTable = QueryFrameworkUtils.createOperatorTable(injector);
        return QueryFrameworkUtils.createMockRootSchema(plannerConfig, viewManager, authorizerMapper, druidSchema, systemSchema, lookupSchema, createOperatorTable);
    }

    public static DruidSchemaCatalog createMockRootSchema(PlannerConfig plannerConfig, ViewManager viewManager, AuthorizerMapper authorizerMapper, DruidSchema druidSchema, SystemSchema systemSchema, LookupSchema lookupSchema, DruidOperatorTable createOperatorTable) {
        ViewSchema viewSchema = viewManager != null ? new ViewSchema(viewManager) : null;
        SchemaPlus rootSchema = CalciteSchema.createRootSchema((boolean)false, (boolean)false).plus();
        HashSet<Object> namedSchemas = new HashSet<Object>();
        namedSchemas.add(new NamedDruidSchema(druidSchema, "druid"));
        namedSchemas.add(new NamedSystemSchema(plannerConfig, systemSchema));
        namedSchemas.add(new NamedLookupSchema(lookupSchema));
        if (viewSchema != null) {
            namedSchemas.add(new NamedViewSchema(viewSchema));
        }
        DruidSchemaCatalog catalog = new DruidSchemaCatalog(rootSchema, namedSchemas.stream().collect(Collectors.toMap(NamedSchema::getSchemaName, x -> x)));
        InformationSchema informationSchema = new InformationSchema(catalog, authorizerMapper, createOperatorTable);
        rootSchema.add("druid", (Schema)druidSchema);
        rootSchema.add(INFORMATION_SCHEMA_NAME, (Schema)informationSchema);
        rootSchema.add("sys", (Schema)systemSchema);
        rootSchema.add("lookup", (Schema)lookupSchema);
        if (viewSchema != null) {
            rootSchema.add("view", (Schema)viewSchema);
        }
        return catalog;
    }

    public static DruidSchemaCatalog createMockRootSchema(Injector injector, QueryRunnerFactoryConglomerate conglomerate, SpecificSegmentsQuerySegmentWalker walker, PlannerConfig plannerConfig, AuthorizerMapper authorizerMapper) {
        return QueryFrameworkUtils.createMockRootSchema(injector, conglomerate, walker, plannerConfig, null, (DruidSchemaManager)new NoopDruidSchemaManager(), authorizerMapper, CatalogResolver.NULL_RESOLVER);
    }

    public static DruidSchema createMockSchema(Injector injector, QueryRunnerFactoryConglomerate conglomerate, SpecificSegmentsQuerySegmentWalker walker, DruidSchemaManager druidSchemaManager, CatalogResolver catalog, TimelineServerView timelineServerView) {
        BrokerSegmentMetadataCache cache = new BrokerSegmentMetadataCache(QueryFrameworkUtils.createMockQueryLifecycleFactory((QuerySegmentWalker)walker, conglomerate, CalciteTests.TEST_AUTHORIZER_MAPPER), timelineServerView, BrokerSegmentMetadataCacheConfig.create(), CalciteTests.TEST_AUTHENTICATOR_ESCALATOR, new InternalQueryConfig(), (ServiceEmitter)new NoopServiceEmitter(), new PhysicalDatasourceMetadataFactory(QueryFrameworkUtils.createDefaultJoinableFactory(injector), new SegmentManager((SegmentCacheManager)EasyMock.createMock(SegmentCacheManager.class)){

            public Set<String> getDataSourceNames() {
                return ImmutableSet.of((Object)"broadcast");
            }
        }), null, CentralizedDatasourceSchemaConfig.create());
        try {
            cache.start();
            cache.awaitInitialization();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        cache.stop();
        return new DruidSchema(cache, druidSchemaManager, catalog);
    }

    public static JoinableFactory createDefaultJoinableFactory(Injector injector) {
        return QueryStackTests.makeJoinableFactoryFromDefault((LookupExtractorFactoryContainerProvider)((LookupExtractorFactoryContainerProvider)injector.getInstance(LookupExtractorFactoryContainerProvider.class)), (Set)ImmutableSet.of((Object)TestDataBuilder.CUSTOM_ROW_TABLE_JOINABLE), (Map)ImmutableMap.of(TestDataBuilder.CUSTOM_ROW_TABLE_JOINABLE.getClass(), GlobalTableDataSource.class));
    }

    public static DruidOperatorTable createOperatorTable(Injector injector) {
        try {
            return (DruidOperatorTable)injector.getInstance(DruidOperatorTable.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static LookupSchema createMockLookupSchema(Injector injector) {
        return new LookupSchema((LookupExtractorFactoryContainerProvider)injector.getInstance(LookupExtractorFactoryContainerProvider.class));
    }
}

