/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.util;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import java.io.File;
import java.io.IOException;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.impl.LocalInputSource;
import org.apache.druid.quidem.ProjectPathUtils;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.IOConfig;
import org.apache.druid.segment.indexing.IngestionSpec;
import org.apache.druid.segment.indexing.TuningConfig;
import org.apache.druid.sql.calcite.util.datasets.InputSourceBasedTestDataset;
import org.apache.druid.sql.calcite.util.datasets.TestDataSet;

public class FakeIndexTaskUtil {
    public static TestDataSet makeDS(ObjectMapper objectMapper, File src) {
        try {
            ObjectMapper om = objectMapper.copy();
            om.registerSubtypes(new NamedType[]{new NamedType(MyIOConfigType.class, "index_parallel")});
            FakeIndexTask indexTask = (FakeIndexTask)om.readValue(src, FakeIndexTask.class);
            FakeIngestionSpec spec = indexTask.spec;
            InputSource inputSource = FakeIndexTaskUtil.relativizeLocalInputSource(((MyIOConfigType)spec.getIOConfig()).inputSource, ProjectPathUtils.PROJECT_ROOT);
            InputSourceBasedTestDataset dataset = new InputSourceBasedTestDataset(spec.getDataSchema(), ((MyIOConfigType)spec.getIOConfig()).inputFormat, inputSource);
            return dataset;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static InputSource relativizeLocalInputSource(InputSource inputSource, File projectRoot) {
        if (!(inputSource instanceof LocalInputSource)) {
            return inputSource;
        }
        LocalInputSource localInputSource = (LocalInputSource)inputSource;
        if (localInputSource.getBaseDir().isAbsolute()) {
            return inputSource;
        }
        File newBaseDir = projectRoot.toPath().resolve(localInputSource.getBaseDir().toPath()).toFile();
        return new LocalInputSource(newBaseDir, localInputSource.getFilter(), localInputSource.getFiles(), localInputSource.getSystemFields());
    }

    static class MyIOConfigType
    implements IOConfig {
        @JsonProperty
        public InputSource inputSource;
        @JsonProperty
        public InputFormat inputFormat;

        MyIOConfigType() {
        }
    }

    static class FakeIndexTask {
        @JsonProperty
        public FakeIngestionSpec spec;

        FakeIndexTask() {
        }
    }

    static class FakeIngestionSpec
    extends IngestionSpec<MyIOConfigType, TuningConfig> {
        @JsonCreator
        public FakeIngestionSpec(@JsonProperty(value="dataSchema") DataSchema dataSchema, @JsonProperty(value="ioConfig") MyIOConfigType ioConfig) {
            super(dataSchema, (IOConfig)ioConfig, null);
        }
    }
}

