/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import java.util.Collections;
import java.util.Set;
import org.apache.druid.catalog.MetadataCatalog;
import org.apache.druid.catalog.NullMetadataCatalog;
import org.apache.druid.sql.calcite.planner.CatalogResolver;
import org.apache.druid.sql.calcite.table.DatasourceTable;
import org.apache.druid.sql.calcite.table.DruidTable;
import org.junit.Assert;

public class TrivialTest {
    public void testResolver() {
        DummyCatalogResolver resolver = new DummyCatalogResolver();
        Assert.assertTrue((boolean)resolver.ingestRequiresExistingTable());
        Assert.assertNull((Object)resolver.resolveDatasource("foo", null));
        Assert.assertTrue((boolean)resolver.getTableNames(Collections.emptySet()).isEmpty());
    }

    private static class DummyCatalogResolver
    implements CatalogResolver {
        private DummyCatalogResolver() {
        }

        public boolean ingestRequiresExistingTable() {
            return true;
        }

        public MetadataCatalog getMetadataCatalog() {
            return NullMetadataCatalog.INSTANCE;
        }

        public DruidTable resolveDatasource(String tableName, DatasourceTable.PhysicalDatasourceMetadata dsMetadata) {
            Assert.assertTrue((boolean)"foo".equals(tableName));
            return null;
        }

        public Set<String> getTableNames(Set<String> datasourceNames) {
            return Collections.emptySet();
        }
    }
}

