/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.google.common.collect.ImmutableSortedSet;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.DruidTypeSystem;
import org.apache.druid.sql.calcite.table.RowSignatures;
import org.apache.druid.sql.calcite.util.CalciteTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CalcitesTest
extends CalciteTestBase {
    @Test
    public void testEscapeStringLiteral() {
        Assertions.assertEquals((Object)"''", (Object)Calcites.escapeStringLiteral((String)""));
        Assertions.assertEquals((Object)"'foo'", (Object)Calcites.escapeStringLiteral((String)"foo"));
        Assertions.assertEquals((Object)"'foo bar'", (Object)Calcites.escapeStringLiteral((String)"foo bar"));
        Assertions.assertEquals((Object)"U&'fo\u00f6 bar'", (Object)Calcites.escapeStringLiteral((String)"fo\u00f6 bar"));
        Assertions.assertEquals((Object)"U&'foo \\0026\\0026 bar'", (Object)Calcites.escapeStringLiteral((String)"foo && bar"));
        Assertions.assertEquals((Object)"U&'foo \\005C bar'", (Object)Calcites.escapeStringLiteral((String)"foo \\ bar"));
        Assertions.assertEquals((Object)"U&'foo\\0027s bar'", (Object)Calcites.escapeStringLiteral((String)"foo's bar"));
        Assertions.assertEquals((Object)"U&'\u0434\u0440\u0443\u0438\u0434'", (Object)Calcites.escapeStringLiteral((String)"\u0434\u0440\u0443\u0438\u0434"));
    }

    @Test
    public void testFindUnusedPrefix() {
        Assertions.assertEquals((Object)"x", (Object)Calcites.findUnusedPrefixForDigits((String)"x", (Iterable)ImmutableSortedSet.of((Comparable)((Object)"foo"), (Comparable)((Object)"bar"))));
        Assertions.assertEquals((Object)"x", (Object)Calcites.findUnusedPrefixForDigits((String)"x", (Iterable)ImmutableSortedSet.of((Comparable)((Object)"foo"), (Comparable)((Object)"bar"), (Comparable)((Object)"x"))));
        Assertions.assertEquals((Object)"_x", (Object)Calcites.findUnusedPrefixForDigits((String)"x", (Iterable)ImmutableSortedSet.of((Comparable)((Object)"foo"), (Comparable)((Object)"bar"), (Comparable)((Object)"x0"))));
        Assertions.assertEquals((Object)"_x", (Object)Calcites.findUnusedPrefixForDigits((String)"x", (Iterable)ImmutableSortedSet.of((Comparable)((Object)"foo"), (Comparable)((Object)"bar"), (Comparable)((Object)"x4"))));
        Assertions.assertEquals((Object)"__x", (Object)Calcites.findUnusedPrefixForDigits((String)"x", (Iterable)ImmutableSortedSet.of((Comparable)((Object)"foo"), (Comparable)((Object)"xa"), (Comparable)((Object)"_x2xx"), (Comparable)((Object)"x0"))));
        Assertions.assertEquals((Object)"x", (Object)Calcites.findUnusedPrefixForDigits((String)"x", (Iterable)ImmutableSortedSet.of((Comparable)((Object)"foo"), (Comparable)((Object)"xa"), (Comparable)((Object)"_x2xx"), (Comparable)((Object)" x"))));
        Assertions.assertEquals((Object)"x", (Object)Calcites.findUnusedPrefixForDigits((String)"x", (Iterable)ImmutableSortedSet.of((Comparable)((Object)"foo"), (Comparable)((Object)"_xbxx"))));
        Assertions.assertEquals((Object)"x", (Object)Calcites.findUnusedPrefixForDigits((String)"x", (Iterable)ImmutableSortedSet.of((Comparable)((Object)"foo"), (Comparable)((Object)"xa"), (Comparable)((Object)"_x"))));
        Assertions.assertEquals((Object)"__x", (Object)Calcites.findUnusedPrefixForDigits((String)"x", (Iterable)ImmutableSortedSet.of((Comparable)((Object)"foo"), (Comparable)((Object)"x1a"), (Comparable)((Object)"_x90"))));
    }

    @Test
    public void testGetStringComparatorForRelDataType() {
        RelDataType type;
        for (SqlTypeName typeName : SqlTypeFamily.CHARACTER.getTypeNames()) {
            type = DruidTypeSystem.TYPE_FACTORY.createSqlType(typeName);
            Assertions.assertEquals((Object)StringComparators.LEXICOGRAPHIC, (Object)Calcites.getStringComparatorForRelDataType((RelDataType)type), (String)type.getFullTypeString());
        }
        for (SqlTypeName typeName : SqlTypeFamily.NUMERIC.getTypeNames()) {
            type = DruidTypeSystem.TYPE_FACTORY.createSqlType(typeName);
            Assertions.assertEquals((Object)StringComparators.NUMERIC, (Object)Calcites.getStringComparatorForRelDataType((RelDataType)type), (String)type.getFullTypeString());
        }
        Assertions.assertEquals((Object)StringComparators.NATURAL, (Object)Calcites.getStringComparatorForRelDataType((RelDataType)RowSignatures.makeComplexType((RelDataTypeFactory)DruidTypeSystem.TYPE_FACTORY, (ColumnType)ColumnType.UNKNOWN_COMPLEX, (boolean)false)), (String)ColumnType.UNKNOWN_COMPLEX.toString());
        Assertions.assertEquals((Object)StringComparators.NATURAL, (Object)Calcites.getStringComparatorForRelDataType((RelDataType)RowSignatures.makeComplexType((RelDataTypeFactory)DruidTypeSystem.TYPE_FACTORY, (ColumnType)ColumnType.NESTED_DATA, (boolean)false)), (String)ColumnType.NESTED_DATA.toString());
        RelDataType timestampType = DruidTypeSystem.TYPE_FACTORY.createSqlType(SqlTypeName.TIMESTAMP);
        Assertions.assertEquals((Object)StringComparators.NUMERIC, (Object)Calcites.getStringComparatorForRelDataType((RelDataType)timestampType), (String)timestampType.getFullTypeString());
        RelDataType dateType = DruidTypeSystem.TYPE_FACTORY.createSqlType(SqlTypeName.DATE);
        Assertions.assertEquals((Object)StringComparators.NUMERIC, (Object)Calcites.getStringComparatorForRelDataType((RelDataType)dateType), (String)dateType.getFullTypeString());
        RelDataType bigintArrayType = DruidTypeSystem.TYPE_FACTORY.createArrayType(DruidTypeSystem.TYPE_FACTORY.createSqlType(SqlTypeName.BIGINT), -1L);
        Assertions.assertEquals((Object)StringComparators.NATURAL, (Object)Calcites.getStringComparatorForRelDataType((RelDataType)bigintArrayType), (String)bigintArrayType.getFullTypeString());
        RelDataType booleanType = DruidTypeSystem.TYPE_FACTORY.createSqlType(SqlTypeName.BOOLEAN);
        Assertions.assertEquals((Object)StringComparators.NUMERIC, (Object)Calcites.getStringComparatorForRelDataType((RelDataType)booleanType), (String)booleanType.getFullTypeString());
        RelDataType otherType = DruidTypeSystem.TYPE_FACTORY.createSqlType(SqlTypeName.OTHER);
        Assertions.assertEquals((Object)StringComparators.NATURAL, (Object)Calcites.getStringComparatorForRelDataType((RelDataType)otherType), (String)otherType.getFullTypeString());
        RelDataType nullType = DruidTypeSystem.TYPE_FACTORY.createSqlType(SqlTypeName.NULL);
        Assertions.assertEquals((Object)StringComparators.NATURAL, (Object)Calcites.getStringComparatorForRelDataType((RelDataType)nullType), (String)nullType.getFullTypeString());
    }

    @Test
    public void testGetStringComparatorForColumnType() {
        Assertions.assertEquals((Object)StringComparators.LEXICOGRAPHIC, (Object)Calcites.getStringComparatorForValueType((ColumnType)ColumnType.STRING));
        Assertions.assertEquals((Object)StringComparators.NUMERIC, (Object)Calcites.getStringComparatorForValueType((ColumnType)ColumnType.LONG));
        Assertions.assertEquals((Object)StringComparators.NUMERIC, (Object)Calcites.getStringComparatorForValueType((ColumnType)ColumnType.FLOAT));
        Assertions.assertEquals((Object)StringComparators.NUMERIC, (Object)Calcites.getStringComparatorForValueType((ColumnType)ColumnType.DOUBLE));
        Assertions.assertEquals((Object)StringComparators.NATURAL, (Object)Calcites.getStringComparatorForValueType((ColumnType)ColumnType.STRING_ARRAY));
        Assertions.assertEquals((Object)StringComparators.NATURAL, (Object)Calcites.getStringComparatorForValueType((ColumnType)ColumnType.LONG_ARRAY));
        Assertions.assertEquals((Object)StringComparators.NATURAL, (Object)Calcites.getStringComparatorForValueType((ColumnType)ColumnType.DOUBLE_ARRAY));
        Assertions.assertEquals((Object)StringComparators.NATURAL, (Object)Calcites.getStringComparatorForValueType((ColumnType)ColumnType.NESTED_DATA));
        Assertions.assertEquals((Object)StringComparators.NATURAL, (Object)Calcites.getStringComparatorForValueType((ColumnType)ColumnType.UNKNOWN_COMPLEX));
    }
}

