/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.calcite.avatica.SqlType;
import org.apache.druid.query.http.ClientSqlParameter;
import org.apache.druid.query.http.ClientSqlQuery;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.sql.calcite.util.CalciteTestBase;
import org.apache.druid.sql.http.ResultFormat;
import org.apache.druid.sql.http.SqlParameter;
import org.apache.druid.sql.http.SqlQuery;
import org.junit.Assert;
import org.junit.jupiter.api.Test;

public class SqlQueryTest
extends CalciteTestBase {
    private static final ObjectMapper JSON_MAPPER = TestHelper.makeJsonMapper();

    @Test
    public void testSerde() throws Exception {
        SqlQuery query = new SqlQuery("SELECT ?", ResultFormat.ARRAY, true, true, true, (Map)ImmutableMap.of((Object)"useCache", (Object)false), (List)ImmutableList.of((Object)new SqlParameter(SqlType.INTEGER, (Object)1)));
        Assert.assertEquals((Object)query, (Object)JSON_MAPPER.readValue(JSON_MAPPER.writeValueAsString((Object)query), SqlQuery.class));
    }

    @Test
    public void testClientSqlQueryToSqlQueryConversion() throws JsonProcessingException {
        ClientSqlQuery givenClientSqlQuery = new ClientSqlQuery("SELECT ?", "array", true, true, true, (Map)ImmutableMap.of((Object)"useCache", (Object)false), null);
        SqlQuery expectedSqlQuery = new SqlQuery("SELECT ?", ResultFormat.ARRAY, true, true, true, (Map)ImmutableMap.of((Object)"useCache", (Object)false), null);
        SqlQuery observedSqlQuery = (SqlQuery)JSON_MAPPER.readValue(JSON_MAPPER.writeValueAsString((Object)givenClientSqlQuery), SqlQuery.class);
        Assert.assertEquals((Object)expectedSqlQuery, (Object)observedSqlQuery);
    }

    @Test
    public void testClientSqlQueryToSqlQueryConversion2() throws JsonProcessingException {
        ClientSqlQuery givenClientSqlQuery = new ClientSqlQuery("SELECT ?", "arrayLines", false, false, false, (Map)ImmutableMap.of((Object)"useCache", (Object)false), (List)ImmutableList.of((Object)new ClientSqlParameter("INTEGER", (Object)1), (Object)new ClientSqlParameter("VARCHAR", (Object)"foo")));
        SqlQuery expectedSqlQuery = new SqlQuery("SELECT ?", ResultFormat.ARRAYLINES, false, false, false, (Map)ImmutableMap.of((Object)"useCache", (Object)false), (List)ImmutableList.of((Object)new SqlParameter(SqlType.INTEGER, (Object)1), (Object)new SqlParameter(SqlType.VARCHAR, (Object)"foo")));
        SqlQuery observedSqlQuery = (SqlQuery)JSON_MAPPER.readValue(JSON_MAPPER.writeValueAsString((Object)givenClientSqlQuery), SqlQuery.class);
        Assert.assertEquals((Object)expectedSqlQuery, (Object)observedSqlQuery);
    }

    @Test
    public void testEquals() {
        EqualsVerifier.forClass(SqlQuery.class).withNonnullFields(new String[]{"query"}).usingGetClass().verify();
        EqualsVerifier.forClass(SqlParameter.class).withNonnullFields(new String[]{"type"}).usingGetClass().verify();
    }
}

