/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.generator.GeneratorBasicSchemas;
import org.apache.druid.segment.generator.GeneratorSchemaInfo;
import org.apache.druid.segment.generator.SegmentGenerator;
import org.apache.druid.segment.join.JoinableFactoryWrapper;
import org.apache.druid.server.QueryStackTests;
import org.apache.druid.server.SpecificSegmentsQuerySegmentWalker;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthTestUtils;
import org.apache.druid.sql.calcite.planner.CalciteRulesManager;
import org.apache.druid.sql.calcite.planner.CatalogResolver;
import org.apache.druid.sql.calcite.planner.DruidPlanner;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.planner.PlannerFactory;
import org.apache.druid.sql.calcite.planner.PlannerResult;
import org.apache.druid.sql.calcite.run.SqlEngine;
import org.apache.druid.sql.calcite.schema.DruidSchemaCatalog;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.apache.druid.sql.hook.DruidHookDispatcher;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SqlVectorizedExpressionSanityTest
extends InitializedNullHandlingTest {
    private static final Logger log = new Logger(SqlVectorizedExpressionSanityTest.class);
    private static final List<String> QUERIES = ImmutableList.of((Object)"SELECT SUM(long1 * long2) FROM foo", (Object)"SELECT SUM((long1 * long2) / double1) FROM foo", (Object)"SELECT SUM(float3 + ((long1 * long4)/double1)) FROM foo", (Object)"SELECT SUM(long5 - (float3 + ((long1 * long4)/double1))) FROM foo", (Object)"SELECT cos(double2) FROM foo", (Object)"SELECT SUM(-long4) FROM foo", (Object)"SELECT SUM(PARSE_LONG(string1)) FROM foo", (Object)"SELECT SUM(PARSE_LONG(string3)) FROM foo", (Object)"SELECT TIME_FLOOR(__time, 'PT1H'), string2, SUM(long1 * double4) FROM foo GROUP BY 1,2 ORDER BY 3", (Object)"SELECT TIME_FLOOR(__time, 'PT1H'), string2, SUM(long1 * double4) FROM foo WHERE string2 = '10' GROUP BY 1,2 ORDER BY 3", (Object)"SELECT TIME_FLOOR(__time, 'PT1H'), SUM(long1 * long4) FROM foo GROUP BY 1 ORDER BY 1", (Object)"SELECT TIME_FLOOR(__time, 'PT1H'), SUM(long1 * long4) FROM foo GROUP BY 1 ORDER BY 2", (Object[])new String[]{"SELECT TIME_FLOOR(TIMESTAMPADD(DAY, -1, __time), 'PT1H'), SUM(long1 * long4) FROM foo GROUP BY 1 ORDER BY 1", "SELECT TIME_SHIFT(__time, 'PT1H', 3), string2, SUM(long1 * double4) FROM foo GROUP BY 1,2 ORDER BY 3", "SELECT TIME_SHIFT(__time, 'PT1H', 4), string2, SUM(long1 * double4) FROM foo WHERE string2 = '10' GROUP BY 1,2 ORDER BY 3", "SELECT TIME_SHIFT(__time, 'PT1H', 3), SUM(long1 * long4) FROM foo GROUP BY 1 ORDER BY 1", "SELECT TIME_SHIFT(__time, 'PT1H', 4), SUM(long1 * long4) FROM foo GROUP BY 1 ORDER BY 2", "SELECT TIME_SHIFT(TIMESTAMPADD(DAY, -1, __time), 'PT1H', 3), SUM(long1 * long4) FROM foo GROUP BY 1 ORDER BY 1", "SELECT (long1 * long2), SUM(double1) FROM foo GROUP BY 1 ORDER BY 2", "SELECT string2, SUM(long1 * long4) FROM foo GROUP BY 1 ORDER BY 2", "SELECT string1 + string2, COUNT(*) FROM foo GROUP BY 1 ORDER BY 2", "SELECT CONCAT(string1, '-', 'foo'), COUNT(*) FROM foo GROUP BY 1 ORDER BY 2", "SELECT CONCAT(string1, '-', string2), string3, COUNT(*) FROM foo GROUP BY 1,2 ORDER BY 3", "SELECT CONCAT(string1, '-', string2, '-', long1, '-', double1, '-', float1) FROM foo GROUP BY 1", "SELECT CAST(long1 as BOOLEAN) AND CAST (long2 as BOOLEAN), COUNT(*) FROM foo GROUP BY 1 ORDER BY 2", "SELECT long5 IS NULL, long3 IS NOT NULL, count(*) FROM foo GROUP BY 1,2 ORDER BY 3"});
    private static final int ROWS_PER_SEGMENT = 10000;
    private static QueryableIndex INDEX;
    private static Closer CLOSER;
    private static QueryRunnerFactoryConglomerate CONGLOMERATE;
    private static SpecificSegmentsQuerySegmentWalker WALKER;
    private static SqlEngine ENGINE;
    @Nullable
    private static PlannerFactory PLANNER_FACTORY;
    private String query;

    @BeforeClass
    public static void setupClass() {
        CLOSER = Closer.create();
        GeneratorSchemaInfo schemaInfo = (GeneratorSchemaInfo)GeneratorBasicSchemas.SCHEMA_MAP.get("expression-testbench");
        DataSegment dataSegment = DataSegment.builder().dataSource("foo").interval(schemaInfo.getDataInterval()).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build();
        SegmentGenerator segmentGenerator = (SegmentGenerator)CLOSER.register((Closeable)new SegmentGenerator());
        INDEX = (QueryableIndex)CLOSER.register((Closeable)segmentGenerator.generate(dataSegment, schemaInfo, Granularities.HOUR, 10000));
        CONGLOMERATE = QueryStackTests.createQueryRunnerFactoryConglomerate((Closer)CLOSER);
        WALKER = SpecificSegmentsQuerySegmentWalker.createWalker((QueryRunnerFactoryConglomerate)CONGLOMERATE).add(dataSegment, INDEX);
        CLOSER.register((Closeable)WALKER);
        PlannerConfig plannerConfig = new PlannerConfig();
        DruidSchemaCatalog rootSchema = CalciteTests.createMockRootSchema(CONGLOMERATE, WALKER, plannerConfig, AuthTestUtils.TEST_AUTHORIZER_MAPPER);
        JoinableFactoryWrapper joinableFactoryWrapper = CalciteTests.createJoinableFactoryWrapper();
        ENGINE = CalciteTests.createMockSqlEngine((QuerySegmentWalker)WALKER, CONGLOMERATE);
        PLANNER_FACTORY = new PlannerFactory(rootSchema, CalciteTests.createOperatorTable(), CalciteTests.createExprMacroTable(), plannerConfig, AuthTestUtils.TEST_AUTHORIZER_MAPPER, CalciteTests.getJsonMapper(), "druid", new CalciteRulesManager((Set)ImmutableSet.of()), joinableFactoryWrapper, CatalogResolver.NULL_RESOLVER, new AuthConfig(), new DruidHookDispatcher());
    }

    @AfterClass
    public static void teardownClass() throws IOException {
        CLOSER.close();
    }

    /*
     * Exception decompiling
     */
    @Parameterized.Parameters(name="query = {0}")
    public static Iterable<?> constructorFeeder() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public SqlVectorizedExpressionSanityTest(String query) {
        this.query = query;
    }

    @Test
    public void testQuery() {
        SqlVectorizedExpressionSanityTest.sanityTestVectorizedSqlQueries(ENGINE, PLANNER_FACTORY, this.query);
    }

    public static void sanityTestVectorizedSqlQueries(SqlEngine engine, PlannerFactory plannerFactory, String query) {
        ImmutableMap vector = ImmutableMap.of((Object)"vectorize", (Object)"force", (Object)"vectorizeVirtualColumns", (Object)"force");
        ImmutableMap nonvector = ImmutableMap.of((Object)"vectorize", (Object)"false", (Object)"vectorizeVirtualColumns", (Object)"false");
        try (DruidPlanner vectorPlanner = plannerFactory.createPlannerForTesting(engine, query, (Map)vector);
             DruidPlanner nonVectorPlanner = plannerFactory.createPlannerForTesting(engine, query, (Map)nonvector);){
            PlannerResult vectorPlan = vectorPlanner.plan();
            PlannerResult nonVectorPlan = nonVectorPlanner.plan();
            Sequence vectorSequence = vectorPlan.run().getResults();
            Sequence nonVectorSequence = nonVectorPlan.run().getResults();
            Yielder vectorizedYielder = Yielders.each((Sequence)vectorSequence);
            Yielder nonVectorizedYielder = Yielders.each((Sequence)nonVectorSequence);
            int row = 0;
            int misMatch = 0;
            while (!vectorizedYielder.isDone() && !nonVectorizedYielder.isDone()) {
                Object[] vectorGet = (Object[])vectorizedYielder.get();
                Object[] nonVectorizedGet = (Object[])nonVectorizedYielder.get();
                try {
                    Assert.assertEquals((long)vectorGet.length, (long)nonVectorizedGet.length);
                    for (int i = 0; i < vectorGet.length; ++i) {
                        Object nonVectorObject = nonVectorizedGet[i];
                        Object vectorObject = vectorGet[i];
                        if (vectorObject instanceof Float || vectorObject instanceof Double) {
                            Assert.assertEquals((String)StringUtils.format((String)"Double results differed at row %s (%s : %s)", (Object[])new Object[]{row, nonVectorObject, vectorObject}), (double)((Double)nonVectorObject), (double)((Double)vectorObject), (double)0.01);
                            continue;
                        }
                        Assert.assertEquals((String)StringUtils.format((String)"Results differed at row %s (%s : %s)", (Object[])new Object[]{row, nonVectorObject, vectorObject}), (Object)nonVectorObject, (Object)vectorObject);
                    }
                }
                catch (Throwable t) {
                    log.warn(t.getMessage(), new Object[0]);
                    ++misMatch;
                }
                vectorizedYielder = vectorizedYielder.next((Object)vectorGet);
                nonVectorizedYielder = nonVectorizedYielder.next((Object)nonVectorizedGet);
                ++row;
            }
            Assert.assertEquals((String)"Expected no mismatched results", (long)0L, (long)misMatch);
            Assert.assertTrue((boolean)vectorizedYielder.isDone());
            Assert.assertTrue((boolean)nonVectorizedYielder.isDone());
        }
    }
}

