/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlExplainFormat;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlInsert;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.Query;
import org.apache.druid.quidem.DruidQTestInfo;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.DirectStatement;
import org.apache.druid.sql.PreparedStatement;
import org.apache.druid.sql.SqlQueryPlus;
import org.apache.druid.sql.SqlStatementFactory;
import org.apache.druid.sql.calcite.BaseCalciteQueryTest;
import org.apache.druid.sql.calcite.QTestCase;
import org.apache.druid.sql.calcite.QueryTestBuilder;
import org.apache.druid.sql.calcite.SqlSchema;
import org.apache.druid.sql.calcite.parser.DruidSqlIngest;
import org.apache.druid.sql.calcite.planner.PlannerCaptureHook;
import org.apache.druid.sql.calcite.planner.PlannerHook;
import org.apache.druid.sql.calcite.planner.PrepareResult;
import org.apache.druid.sql.calcite.table.RowSignatures;
import org.apache.druid.sql.calcite.util.QueryLogHook;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.internal.matchers.ThrowableMessageMatcher;

public class QueryTestRunner {
    private final List<QueryRunStep> runSteps = new ArrayList<QueryRunStep>();
    private final List<QueryVerifyStep> verifySteps = new ArrayList<QueryVerifyStep>();

    public QueryTestRunner(QueryTestBuilder builder) {
        QueryTestBuilder.QueryTestConfig config = builder.config;
        DruidQTestInfo iqTestInfo = config.getQTestInfo();
        if (iqTestInfo != null) {
            QTestCase qt = new QTestCase(iqTestInfo);
            ImmutableSortedMap queryContext = ImmutableSortedMap.naturalOrder().putAll(builder.getQueryContext()).putAll(builder.plannerConfig.getNonDefaultAsQueryContext()).build();
            for (Map.Entry entry : queryContext.entrySet()) {
                qt.println(StringUtils.format((String)"!set %s %s", (Object[])new Object[]{entry.getKey(), entry.getValue()}));
            }
            qt.println("!set outputformat mysql");
            qt.println("!use " + String.valueOf(builder.config.queryFramework().getDruidTestURI()));
            qt.println(builder.sql + ";");
            if (builder.expectedResults != null) {
                qt.println("!ok");
            }
            qt.println("!logicalPlan");
            qt.println("!druidPlan");
            if (builder.expectedQueries != null) {
                qt.println("!nativePlan");
            }
            this.runSteps.add(qt.toRunner());
            return;
        }
        if (builder.expectedResultsVerifier == null && builder.expectedResults != null) {
            builder.expectedResultsVerifier = config.defaultResultsVerifier(builder.expectedResults, builder.expectedResultMatchMode, builder.expectedResultSignature);
        }
        if (builder.skipVectorize && builder.queryCannotVectorize) {
            throw new IAE("Do not set both skipVectorize and cannotVectorize. Use cannotVectorize if a query is not currently able to vectorize, but may be able to in the future. Use skipVectorize if a query *can* vectorize, but for some reason we need to skip the test on the vectorized code path. In most situations, cannotVectorize is the one you want.", new Object[0]);
        }
        if (builder.expectedResources != null) {
            Preconditions.checkArgument((builder.expectedResultsVerifier == null ? 1 : 0) != 0, (Object)"Cannot check both results and resources");
            PrepareQuery execStep = new PrepareQuery(builder);
            this.runSteps.add(execStep);
            this.verifySteps.add(new VerifyResources(execStep));
            if (builder.expectedSqlSchema != null) {
                this.verifySteps.add(new VerifyPrepareSignature(execStep));
            }
        } else {
            ExecuteQuery execStep = new ExecuteQuery(builder);
            this.runSteps.add(execStep);
            if (!builder.customRunners.isEmpty()) {
                for (QueryRunStepFactory factory : builder.customRunners) {
                    this.runSteps.add(factory.make(builder, (BaseExecuteQuery)this.runSteps.get(this.runSteps.size() - 1)));
                }
            }
            BaseExecuteQuery finalExecStep = (BaseExecuteQuery)this.runSteps.get(this.runSteps.size() - 1);
            if (builder.expectedLogicalPlan != null) {
                this.verifySteps.add(new VerifyLogicalPlan(finalExecStep));
            }
            if (builder.expectedSqlSchema != null) {
                this.verifySteps.add(new VerifyExecuteSignature(finalExecStep));
            }
            if (builder.expectedQueries != null && builder.verifyNativeQueries.test(builder.expectedQueries)) {
                this.verifySteps.add(new VerifyNativeQueries(finalExecStep));
            }
            if (builder.expectedResultsVerifier != null) {
                this.verifySteps.add(new VerifyResults(finalExecStep));
            }
            if (!builder.customVerifications.isEmpty()) {
                for (QueryVerifyStepFactory customVerification : builder.customVerifications) {
                    this.verifySteps.add(customVerification.make(finalExecStep));
                }
            }
            this.verifySteps.add(new VerifyExpectedException(finalExecStep));
        }
    }

    public void run() {
        for (QueryRunStep runStep : this.runSteps) {
            runStep.run();
        }
        for (QueryVerifyStep verifyStep : this.verifySteps) {
            verifyStep.verify();
        }
    }

    public QueryResults resultsOnly() {
        for (QueryRunStep runStep : this.runSteps) {
            runStep.run();
        }
        BaseExecuteQuery execStep = (BaseExecuteQuery)this.runSteps.get(this.runSteps.size() - 1);
        return execStep.results().get(0);
    }

    public static abstract class QueryRunStep {
        protected final QueryTestBuilder builder;

        public QueryRunStep(QueryTestBuilder builder) {
            this.builder = builder;
        }

        public final QueryTestBuilder builder() {
            return this.builder;
        }

        public abstract void run();
    }

    public static class PrepareQuery
    extends QueryRunStep {
        public Set<ResourceAction> resourceActions;
        public RelDataType sqlSignature;

        public PrepareQuery(QueryTestBuilder builder) {
            super(builder);
        }

        public Set<ResourceAction> resourceActions() {
            return this.resourceActions;
        }

        @Override
        public void run() {
            QueryTestBuilder builder = this.builder();
            SqlQueryPlus sqlQuery = SqlQueryPlus.builder((String)builder.sql).context(builder.queryContext).sqlParameters(builder.parameters).auth(builder.authenticationResult).build();
            SqlStatementFactory sqlStatementFactory = builder.statementFactory();
            PreparedStatement stmt = sqlStatementFactory.preparedStatement(sqlQuery);
            PrepareResult prepareResult = stmt.prepare();
            this.resourceActions = stmt.allResources();
            this.sqlSignature = prepareResult.getReturnedRowType();
        }
    }

    public static class VerifyResources
    implements QueryVerifyStep {
        private final PrepareQuery prepareStep;

        public VerifyResources(PrepareQuery prepareStep) {
            this.prepareStep = prepareStep;
        }

        @Override
        public void verify() {
            QueryTestBuilder builder = this.prepareStep.builder();
            Assert.assertEquals((Object)ImmutableSet.copyOf(builder.expectedResources), this.prepareStep.resourceActions());
        }
    }

    public static class VerifyPrepareSignature
    implements QueryVerifyStep {
        private final PrepareQuery prepareStep;

        public VerifyPrepareSignature(PrepareQuery prepareStep) {
            this.prepareStep = prepareStep;
        }

        @Override
        public void verify() {
            QueryTestBuilder builder = this.prepareStep.builder();
            Assert.assertEquals((Object)builder.expectedSqlSchema, (Object)SqlSchema.of(this.prepareStep.sqlSignature));
        }
    }

    public static class ExecuteQuery
    extends BaseExecuteQuery {
        public ExecuteQuery(QueryTestBuilder builder) {
            super(builder);
        }

        @Override
        public void run() {
            QueryTestBuilder builder = this.builder();
            BaseCalciteQueryTest.log.info("SQL: %s", new Object[]{builder.sql});
            SqlStatementFactory sqlStatementFactory = builder.statementFactory();
            SqlQueryPlus sqlQuery = SqlQueryPlus.builder((String)builder.sql).sqlParameters(builder.parameters).auth(builder.authenticationResult).build();
            ArrayList<String> vectorizeValues = new ArrayList<String>();
            vectorizeValues.add("false");
            if (!builder.skipVectorize) {
                vectorizeValues.add("force");
            }
            for (String vectorize : vectorizeValues) {
                HashMap<String, Object> theQueryContext = new HashMap<String, Object>(builder.queryContext);
                theQueryContext.put("vectorize", vectorize);
                theQueryContext.put("vectorizeVirtualColumns", vectorize);
                if (!"false".equals(vectorize)) {
                    theQueryContext.put("vectorSize", 2);
                }
                this.results.add(this.runQuery(sqlStatementFactory, sqlQuery.withContext(theQueryContext), vectorize));
            }
        }

        public QueryResults runQuery(SqlStatementFactory sqlStatementFactory, SqlQueryPlus query, String vectorize) {
            try {
                PlannerCaptureHook capture = this.getCaptureHook();
                DirectStatement stmt = sqlStatementFactory.directStatement(query);
                stmt.setHook((PlannerHook)capture);
                AtomicReference resultListRef = new AtomicReference();
                QueryLogHook queryLogHook = new QueryLogHook(this.builder().config.jsonMapper());
                queryLogHook.logQueriesFor(() -> resultListRef.set(stmt.execute().getResults().toList()));
                return new QueryResults((Map<String, Object>)query.context(), vectorize, stmt.prepareResult().getReturnedRowType(), (List<Object[]>)((List)resultListRef.get()), queryLogHook.getRecordedQueries(), capture);
            }
            catch (RuntimeException e) {
                return new QueryResults(query.context(), vectorize, e);
            }
        }

        private PlannerCaptureHook getCaptureHook() {
            if (this.builder.getQueryContext().containsKey("need_capture_hook") || this.builder.expectedLogicalPlan != null) {
                return new PlannerCaptureHook();
            }
            return null;
        }

        public static Pair<RowSignature, List<Object[]>> getResults(SqlStatementFactory sqlStatementFactory, SqlQueryPlus query) {
            DirectStatement stmt = sqlStatementFactory.directStatement(query);
            Sequence results = stmt.execute().getResults();
            RelDataType rowType = stmt.prepareResult().getReturnedRowType();
            return new Pair((Object)RowSignatures.fromRelDataType((List)rowType.getFieldNames(), (RelDataType)rowType), (Object)results.toList());
        }
    }

    public static interface QueryRunStepFactory {
        public QueryRunStep make(QueryTestBuilder var1, BaseExecuteQuery var2);
    }

    public static abstract class BaseExecuteQuery
    extends QueryRunStep {
        protected final List<QueryResults> results = new ArrayList<QueryResults>();

        public BaseExecuteQuery(QueryTestBuilder builder) {
            super(builder);
        }

        public List<QueryResults> results() {
            return this.results;
        }
    }

    public static class VerifyLogicalPlan
    implements QueryVerifyStep {
        private final BaseExecuteQuery execStep;

        public VerifyLogicalPlan(BaseExecuteQuery execStep) {
            this.execStep = execStep;
        }

        @Override
        public void verify() {
            for (QueryResults queryResults : this.execStep.results()) {
                this.verifyLogicalPlan(queryResults);
            }
        }

        private void verifyLogicalPlan(QueryResults queryResults) {
            String expectedPlan = this.execStep.builder().expectedLogicalPlan;
            String actualPlan = this.visualizePlan(queryResults.capture);
            Assert.assertEquals((Object)expectedPlan, (Object)actualPlan);
        }

        private String visualizePlan(PlannerCaptureHook hook) {
            Object plan;
            String queryPlan = RelOptUtil.dumpPlan((String)"", (RelNode)hook.relRoot().rel, (SqlExplainFormat)SqlExplainFormat.TEXT, (SqlExplainLevel)SqlExplainLevel.DIGEST_ATTRIBUTES);
            SqlInsert insertNode = hook.insertNode();
            if (insertNode == null) {
                plan = queryPlan;
            } else {
                DruidSqlIngest druidInsertNode = (DruidSqlIngest)insertNode;
                plan = StringUtils.format((String)"LogicalInsert(target=[%s], partitionedBy=[%s], clusteredBy=[%s])\n", (Object[])new Object[]{druidInsertNode.getTargetTable(), druidInsertNode.getPartitionedBy() == null ? "<none>" : druidInsertNode.getPartitionedBy(), druidInsertNode.getClusteredBy() == null ? "<none>" : druidInsertNode.getClusteredBy()}) + "  " + StringUtils.replace((String)queryPlan, (String)"\n ", (String)"\n   ");
            }
            return plan;
        }
    }

    public static class VerifyExecuteSignature
    implements QueryVerifyStep {
        private final BaseExecuteQuery execStep;

        public VerifyExecuteSignature(BaseExecuteQuery execStep) {
            this.execStep = execStep;
        }

        @Override
        public void verify() {
            QueryTestBuilder builder = this.execStep.builder();
            for (QueryResults queryResults : this.execStep.results()) {
                Assert.assertEquals((Object)builder.expectedSqlSchema, (Object)SqlSchema.of(queryResults.sqlSignature));
            }
        }
    }

    public static class VerifyNativeQueries
    implements QueryVerifyStep {
        protected final BaseExecuteQuery execStep;

        public VerifyNativeQueries(BaseExecuteQuery execStep) {
            this.execStep = execStep;
        }

        @Override
        public void verify() {
            for (QueryResults queryResults : this.execStep.results()) {
                this.verifyQuery(queryResults);
            }
        }

        private void verifyQuery(QueryResults queryResults) {
            if (queryResults.exception != null) {
                return;
            }
            QueryTestBuilder builder = this.execStep.builder();
            ArrayList expectedQueries = new ArrayList();
            ObjectMapper queryJsonMapper = builder.config.jsonMapper();
            for (Query<?> query : builder.expectedQueries) {
                expectedQueries.add(BaseCalciteQueryTest.recursivelyClearContext(query, queryJsonMapper));
            }
            List recordedQueries = queryResults.recordedQueries.stream().map(q -> BaseCalciteQueryTest.recursivelyClearContext(q, queryJsonMapper)).collect(Collectors.toList());
            Assert.assertEquals((String)StringUtils.format((String)"query count: %s", (Object[])new Object[]{builder.sql}), (long)expectedQueries.size(), (long)recordedQueries.size());
            for (int i = 0; i < expectedQueries.size(); ++i) {
                Query expectedQuery = (Query)expectedQueries.get(i);
                Query actualQuery = (Query)recordedQueries.get(i);
                Assert.assertEquals((String)StringUtils.format((String)"query #%d: %s", (Object[])new Object[]{i + 1, builder.sql}), (Object)expectedQuery, (Object)actualQuery);
                try {
                    String recordedString = queryJsonMapper.writeValueAsString((Object)actualQuery);
                    Query stringAndBack = (Query)queryJsonMapper.readValue(recordedString, Query.class);
                    String expectedString = queryJsonMapper.writeValueAsString((Object)expectedQuery);
                    Query expectedStringAndBack = (Query)queryJsonMapper.readValue(expectedString, Query.class);
                    Assert.assertEquals((Object)expectedStringAndBack, (Object)stringAndBack);
                    continue;
                }
                catch (JsonProcessingException e) {
                    Assert.fail((String)e.getMessage());
                }
            }
        }
    }

    public static class VerifyResults
    implements QueryVerifyStep {
        protected final BaseExecuteQuery execStep;

        public VerifyResults(BaseExecuteQuery execStep) {
            this.execStep = execStep;
        }

        @Override
        public void verify() {
            for (QueryResults queryResults : this.execStep.results()) {
                this.verifyResults(queryResults);
            }
        }

        private void verifyResults(QueryResults queryResults) {
            if (queryResults.exception != null) {
                return;
            }
            List<Object[]> results = queryResults.results;
            for (int i = 0; i < results.size(); ++i) {
                BaseCalciteQueryTest.log.info("row #%d: %s", new Object[]{i, Arrays.toString(results.get(i))});
            }
            QueryTestBuilder builder = this.execStep.builder();
            builder.expectedResultsVerifier.verifyRowSignature(queryResults.signature);
            builder.expectedResultsVerifier.verify(builder.sql, queryResults);
        }
    }

    public static interface QueryVerifyStepFactory {
        public QueryVerifyStep make(BaseExecuteQuery var1);
    }

    public static interface QueryVerifyStep {
        public void verify();
    }

    public static class VerifyExpectedException
    implements QueryVerifyStep {
        protected final BaseExecuteQuery execStep;

        public VerifyExpectedException(BaseExecuteQuery execStep) {
            this.execStep = execStep;
        }

        @Override
        public void verify() {
            QueryTestBuilder builder = this.execStep.builder();
            for (QueryResults queryResults : this.execStep.results()) {
                if (builder.queryCannotVectorize && "force".equals(queryResults.vectorizeOption)) {
                    if (queryResults.exception == null) {
                        Assert.fail((String)"Expected vectorized execution to fail, but it did not. Please remove cannotVectorize() from this test case.");
                    }
                    MatcherAssert.assertThat((Object)queryResults.exception, (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.instanceOf(RuntimeException.class), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Cannot vectorize!"))));
                    continue;
                }
                if (queryResults.exception == null) continue;
                throw queryResults.exception;
            }
        }
    }

    public static class QueryResults {
        public final Map<String, Object> queryContext;
        public final String vectorizeOption;
        public final RelDataType sqlSignature;
        public final RowSignature signature;
        public final List<Object[]> results;
        public final List<Query<?>> recordedQueries;
        public final Set<ResourceAction> resourceActions;
        public final RuntimeException exception;
        public final PlannerCaptureHook capture;

        public QueryResults(Map<String, Object> queryContext, String vectorizeOption, RelDataType sqlSignature, List<Object[]> results, List<Query<?>> recordedQueries, PlannerCaptureHook capture) {
            this.queryContext = queryContext;
            this.vectorizeOption = vectorizeOption;
            this.sqlSignature = sqlSignature;
            this.signature = RowSignatures.fromRelDataType((List)sqlSignature.getFieldNames(), (RelDataType)sqlSignature);
            this.results = results;
            this.recordedQueries = recordedQueries;
            this.resourceActions = null;
            this.exception = null;
            this.capture = capture;
        }

        public QueryResults(Map<String, Object> queryContext, String vectorizeOption, RowSignature rowSignature, List<Object[]> results, List<Query<?>> recordedQueries, PlannerCaptureHook capture) {
            this.queryContext = queryContext;
            this.vectorizeOption = vectorizeOption;
            this.sqlSignature = null;
            this.signature = rowSignature;
            this.results = results;
            this.recordedQueries = recordedQueries;
            this.resourceActions = null;
            this.exception = null;
            this.capture = capture;
        }

        public QueryResults(Map<String, Object> queryContext, String vectorizeOption, RuntimeException exception) {
            this.queryContext = queryContext;
            this.vectorizeOption = vectorizeOption;
            this.signature = null;
            this.results = null;
            this.recordedQueries = null;
            this.resourceActions = null;
            this.exception = exception;
            this.capture = null;
            this.sqlSignature = null;
        }

        public QueryResults withSignatureAndResults(RowSignature rowSignature, List<Object[]> newResults) {
            return new QueryResults(this.queryContext, this.vectorizeOption, rowSignature, newResults, this.recordedQueries, this.capture);
        }
    }
}

