/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.druid.sql.calcite.NotYetSupported;
import org.junit.Assert;
import org.junit.Test;
import org.reflections.Reflections;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.Scanner;

public class NotYetSupportedUsageTest {
    @Test
    public void ensureAllModesUsed() {
        Set<Method> methodsAnnotatedWith = this.getAnnotatedMethods();
        HashSet<NotYetSupported.Modes> modes = new HashSet<NotYetSupported.Modes>(Arrays.asList(NotYetSupported.Modes.values()));
        for (Method method : methodsAnnotatedWith) {
            NotYetSupported annot = method.getAnnotation(NotYetSupported.class);
            modes.remove((Object)annot.value());
        }
        Assert.assertEquals((String)"There are unused modes which should be removed", Collections.emptySet(), modes);
    }

    private Set<Method> getAnnotatedMethods() {
        return new Reflections("org.apache.druid.sql", new Scanner[]{new MethodAnnotationsScanner()}).getMethodsAnnotatedWith(NotYetSupported.class);
    }

    @Test
    public void createReport() {
        Set<Method> methodsAnnotatedWith = this.getAnnotatedMethods();
        HashMap<List<Object>, ReportEntry> mentryMap = new HashMap<List<Object>, ReportEntry>();
        for (Method method : methodsAnnotatedWith) {
            ReportEntry entry = new ReportEntry(method.getDeclaringClass().getSimpleName(), method.getName(), this.getAnnotation(method));
            ReportEntry existing = (ReportEntry)mentryMap.get(entry.getKey());
            if (existing != null) {
                existing.merge(entry);
                continue;
            }
            mentryMap.put(entry.getKey(), entry);
        }
        ArrayList results = new ArrayList(mentryMap.values());
        results.sort(ReportEntry.CLASS_NCASES_MODE_COMPARATOR);
        for (ReportEntry reportEntry : results) {
            System.out.println(reportEntry);
        }
    }

    private NotYetSupported.Modes getAnnotation(Method method) {
        NotYetSupported annotation = method.getAnnotation(NotYetSupported.class);
        if (annotation == null) {
            return null;
        }
        return annotation.value();
    }

    static class ReportEntry {
        public static final Comparator<ReportEntry> CLASS_NCASES_MODE_COMPARATOR = new Comparator<ReportEntry>(){

            @Override
            public int compare(ReportEntry l, ReportEntry r) {
                int res = l.className.compareTo(r.className);
                if (res != 0) {
                    return res;
                }
                res = -Integer.compare(l.methodNames.size(), r.methodNames.size());
                if (res != 0) {
                    return res;
                }
                return 0;
            }
        };
        public String className;
        private List<String> methodNames;
        private NotYetSupported.Modes mode;

        public ReportEntry(String className, String methodName, NotYetSupported.Modes mode) {
            this.className = className;
            this.mode = mode;
            this.methodNames = new ArrayList<String>();
            this.methodNames.add(methodName);
        }

        public List<Object> getKey() {
            return ImmutableList.of((Object)this.className, (Object)((Object)this.mode));
        }

        public void merge(ReportEntry entry) {
            this.methodNames.addAll(entry.methodNames);
        }

        public String toString() {
            return " | " + this.className + " | " + this.methodNames.size() + " | " + String.valueOf((Object)this.mode) + " | " + this.mode.regex + " | ";
        }
    }
}

