/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.google.common.base.Throwables;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.druid.error.DruidException;
import org.apache.druid.sql.calcite.rel.CannotBuildQueryException;
import org.junit.Assert;
import org.junit.AssumptionViolatedException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.opentest4j.IncompleteExecutionException;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
public @interface NotYetSupported {
    public Modes value();

    public static class NotYetSupportedProcessor
    implements InvocationInterceptor {
        public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
            Method method = (Method)extensionContext.getTestMethod().get();
            NotYetSupported annotation = method.getAnnotation(NotYetSupported.class);
            if (annotation == null) {
                invocation.proceed();
                return;
            }
            Modes ignoreMode = annotation.value();
            Throwable e = null;
            try {
                invocation.proceed();
            }
            catch (Throwable t) {
                e = t;
            }
            if (e instanceof AssumptionViolatedException) {
                throw (AssumptionViolatedException)e;
            }
            if (e instanceof IncompleteExecutionException) {
                throw (IncompleteExecutionException)e;
            }
            Throwable finalE = e;
            Assert.assertThrows((String)"Expected that this testcase will fail - it might got fixed; or failure have changed?", ignoreMode.throwableClass, () -> {
                if (finalE != null) {
                    throw finalE;
                }
            });
            String trace = Throwables.getStackTraceAsString((Throwable)e);
            Matcher m = annotation.value().getPattern().matcher(trace);
            if (!m.find()) {
                throw new AssertionError("Exception stacktrace doesn't match regex: " + annotation.value().regex, e);
            }
            throw new AssumptionViolatedException("Test is not-yet supported; ignored with:" + String.valueOf(annotation));
        }

        public void interceptTestTemplateMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
            this.interceptTestMethod(invocation, invocationContext, extensionContext);
        }
    }

    public static enum Modes {
        NOT_ENOUGH_RULES(DruidException.class, "There are not enough rules to produce a node"),
        DISTINCT_AGGREGATE_NOT_SUPPORTED(DruidException.class, "DISTINCT is not supported"),
        EXPRESSION_NOT_GROUPED(DruidException.class, "Expression '[a-z]+' is not being grouped"),
        NULLS_FIRST_LAST(DruidException.class, "NULLS (FIRST|LAST)"),
        BIGINT_TO_DATE(DruidException.class, "BIGINT to type (DATE|TIME)"),
        AGGREGATION_NOT_SUPPORT_TYPE(DruidException.class, "Aggregation \\[(MIN|MAX)\\] does not support type \\[STRING\\]"),
        ALLDATA_CSV(DruidException.class, "allData.csv"),
        BIGINT_TIME_COMPARE(DruidException.class, "Cannot apply '.' to arguments of type"),
        VIEWS_NOT_SUPPORTED(DruidException.class, "Incorrect syntax near the keyword 'CREATE'"),
        RESULT_MISMATCH(AssertionError.class, "(assertResulEquals|AssertionError: column content mismatch)"),
        LONG_CASTING(AssertionError.class, "expected: java.lang.Long"),
        UNSUPPORTED_NULL_ORDERING(DruidException.class, "(A|DE)SCENDING ordering with NULLS (LAST|FIRST)"),
        SORT_REMOVE_TROUBLE(DruidException.class, "Calcite assertion violated.*Sort\\.<init>"),
        SORT_REMOVE_CONSTANT_KEYS_CONFLICT(DruidException.class, "not enough rules"),
        REQUIRE_TIME_CONDITION(CannotBuildQueryException.class, "requireTimeCondition is enabled"),
        UNNEST_INLINED(Exception.class, "Missing conversion is Uncollect"),
        UNNEST_RESULT_MISMATCH(AssertionError.class, "(Result count mismatch|column content mismatch)");

        public Class<? extends Throwable> throwableClass;
        public String regex;

        private Modes(Class<? extends Throwable> cl, String regex) {
            this.throwableClass = cl;
            this.regex = regex;
        }

        Pattern getPattern() {
            return Pattern.compile(this.regex, 40);
        }

        public String toString() {
            return this.name() + "{" + this.regex + "}";
        }
    }
}

