/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Binder;
import com.google.inject.Module;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.avatica.SqlType;
import org.apache.druid.catalog.model.Columns;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.impl.CsvInputFormat;
import org.apache.druid.data.input.impl.HttpInputSource;
import org.apache.druid.data.input.impl.HttpInputSourceConfig;
import org.apache.druid.data.input.impl.JsonInputFormat;
import org.apache.druid.data.input.impl.LocalInputSource;
import org.apache.druid.data.input.impl.systemfield.SystemFields;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.metadata.DefaultPasswordProvider;
import org.apache.druid.metadata.PasswordProvider;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.sql.calcite.CalciteIngestionDmlTest;
import org.apache.druid.sql.calcite.SqlTestFrameworkConfig;
import org.apache.druid.sql.calcite.TempDirProducer;
import org.apache.druid.sql.calcite.external.ExternalDataSource;
import org.apache.druid.sql.calcite.external.Externals;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.apache.druid.sql.calcite.util.DruidModuleCollection;
import org.apache.druid.sql.http.SqlParameter;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@SqlTestFrameworkConfig.ComponentSupplier(value=ExportComponentSupplier.class)
public class IngestTableFunctionTest
extends CalciteIngestionDmlTest {
    protected final ExternalDataSource httpDataSource = new ExternalDataSource((InputSource)new HttpInputSource(Collections.singletonList(IngestTableFunctionTest.toURI("http://foo.com/bar.csv")), "bob", (PasswordProvider)new DefaultPasswordProvider("secret"), SystemFields.none(), null, new HttpInputSourceConfig(null, null)), (InputFormat)new CsvInputFormat((List)ImmutableList.of((Object)"x", (Object)"y", (Object)"z"), null, Boolean.valueOf(false), Boolean.valueOf(false), 0, null), RowSignature.builder().add("x", ColumnType.STRING).add("y", ColumnType.STRING).add("z", ColumnType.LONG).build());
    protected final ExternalDataSource localDataSource = new ExternalDataSource((InputSource)new LocalInputSource(null, null, Arrays.asList(new File("/tmp/foo.csv"), new File("/tmp/bar.csv")), SystemFields.none()), (InputFormat)new CsvInputFormat((List)ImmutableList.of((Object)"x", (Object)"y", (Object)"z"), null, Boolean.valueOf(false), Boolean.valueOf(false), 0, null), RowSignature.builder().add("x", ColumnType.STRING).add("y", ColumnType.STRING).add("z", ColumnType.LONG).build());

    protected static URI toURI(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new ISE("Bad URI: %s", new Object[]{uri});
        }
    }

    @Test
    public void testHttpExtern() {
        this.testIngestionQuery().sql("INSERT INTO dst SELECT * FROM %s PARTITIONED BY ALL TIME", this.externSql(this.httpDataSource), new Object[0]).authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("dst", this.httpDataSource.getSignature()).expectResources(IngestTableFunctionTest.dataSourceWrite("dst"), Externals.EXTERNAL_RESOURCE_ACTION).expectQuery((Query)IngestTableFunctionTest.newScanQueryBuilder().dataSource((DataSource)this.httpDataSource).intervals(IngestTableFunctionTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"x", "y", "z"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.LONG}).context(CalciteIngestionDmlTest.PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).expectLogicalPlanFrom("httpExtern").verify();
    }

    @Test
    public void testHttpFunction() {
        String extern = "TABLE(http(userName => 'bob',password => 'secret',uris => ARRAY['http://foo.com/bar.csv'],format => 'csv'))  (x VARCHAR, y VARCHAR, z BIGINT)";
        this.testIngestionQuery().sql("INSERT INTO dst SELECT * FROM %s PARTITIONED BY ALL TIME", extern, new Object[0]).authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("dst", this.httpDataSource.getSignature()).expectResources(IngestTableFunctionTest.dataSourceWrite("dst"), Externals.EXTERNAL_RESOURCE_ACTION).expectQuery((Query)IngestTableFunctionTest.newScanQueryBuilder().dataSource((DataSource)this.httpDataSource).intervals(IngestTableFunctionTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"x", "y", "z"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.LONG}).context(CalciteIngestionDmlTest.PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).expectLogicalPlanFrom("httpExtern").verify();
    }

    @Test
    public void testHttpFunctionWithInputsourceSecurity() {
        String extern = "TABLE(http(userName => 'bob',password => 'secret',uris => ARRAY['http://foo.com/bar.csv'],format => 'csv'))  (x VARCHAR, y VARCHAR, z BIGINT)";
        this.testIngestionQuery().sql("INSERT INTO dst SELECT * FROM %s PARTITIONED BY ALL TIME", extern, new Object[0]).authConfig(AuthConfig.newBuilder().setEnableInputSourceSecurity(true).build()).authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("dst", this.httpDataSource.getSignature()).expectResources(IngestTableFunctionTest.dataSourceWrite("dst"), IngestTableFunctionTest.externalRead("http")).expectQuery((Query)IngestTableFunctionTest.newScanQueryBuilder().dataSource((DataSource)this.httpDataSource).intervals(IngestTableFunctionTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"x", "y", "z"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.LONG}).context(CalciteIngestionDmlTest.PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).expectLogicalPlanFrom("httpExtern").verify();
    }

    protected String externSqlByName(ExternalDataSource externalDataSource) {
        ObjectMapper queryJsonMapper = this.queryFramework().queryJsonMapper();
        try {
            return StringUtils.format((String)"TABLE(extern(inputSource => %s,\n             inputFormat => %s,\n             signature => %s))", (Object[])new Object[]{Calcites.escapeStringLiteral((String)queryJsonMapper.writeValueAsString((Object)externalDataSource.getInputSource())), Calcites.escapeStringLiteral((String)queryJsonMapper.writeValueAsString((Object)externalDataSource.getInputFormat())), Calcites.escapeStringLiteral((String)queryJsonMapper.writeValueAsString((Object)externalDataSource.getSignature()))});
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testHttpExternByName() {
        this.testIngestionQuery().sql("INSERT INTO dst SELECT *\nFROM %s\nPARTITIONED BY ALL TIME", this.externSqlByName(this.httpDataSource), new Object[0]).authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("dst", this.httpDataSource.getSignature()).expectResources(IngestTableFunctionTest.dataSourceWrite("dst"), Externals.EXTERNAL_RESOURCE_ACTION).expectQuery((Query)IngestTableFunctionTest.newScanQueryBuilder().dataSource((DataSource)this.httpDataSource).intervals(IngestTableFunctionTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"x", "y", "z"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.LONG}).context(CalciteIngestionDmlTest.PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).expectLogicalPlanFrom("httpExtern").verify();
    }

    @Test
    public void testHttpFn() {
        this.testIngestionQuery().sql("INSERT INTO dst SELECT x, y, z\nFROM TABLE(http(userName => 'bob',\n                password => 'secret',\n                uris => ARRAY['http://foo.com/bar.csv'],\n                format => 'csv'))\n     EXTEND (x VARCHAR, y VARCHAR, z BIGINT)\nPARTITIONED BY ALL TIME").authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("dst", this.httpDataSource.getSignature()).expectResources(IngestTableFunctionTest.dataSourceWrite("dst"), Externals.EXTERNAL_RESOURCE_ACTION).expectQuery((Query)IngestTableFunctionTest.newScanQueryBuilder().dataSource((DataSource)this.httpDataSource).intervals(IngestTableFunctionTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"x", "y", "z"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.LONG}).context(CalciteIngestionDmlTest.PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).expectLogicalPlanFrom("httpExtern").verify();
    }

    @Test
    public void testHttpFn2() {
        ExternalDataSource httpDataSource = new ExternalDataSource((InputSource)new HttpInputSource(Arrays.asList(IngestTableFunctionTest.toURI("http://example.com/foo.csv"), IngestTableFunctionTest.toURI("http://example.com/bar.csv")), "bob", (PasswordProvider)new DefaultPasswordProvider("secret"), SystemFields.none(), (Map)ImmutableMap.of((Object)"Accept", (Object)"application/ndjson", (Object)"a", (Object)"b"), new HttpInputSourceConfig(null, (Set)Sets.newHashSet((Object[])new String[]{"Accept", "a"}))), (InputFormat)new CsvInputFormat((List)ImmutableList.of((Object)"timestamp", (Object)"isRobot"), null, Boolean.valueOf(false), Boolean.valueOf(false), 0, null), RowSignature.builder().add("timestamp", ColumnType.STRING).add("isRobot", ColumnType.STRING).build());
        RowSignature expectedSig = RowSignature.builder().add("__time", ColumnType.LONG).add("isRobot", ColumnType.STRING).build();
        this.testIngestionQuery().sql("INSERT INTO w000\nSELECT\n  TIME_PARSE(\"timestamp\") AS __time,\n  isRobot\nFROM TABLE(http(\n  userName => 'bob',\n  password => 'secret',\n  uris => ARRAY['http://example.com/foo.csv', 'http://example.com/bar.csv'],\n  format => 'csv',\n  headers=> '{\"Accept\":\"application/ndjson\", \"a\": \"b\" }'\n  )\n) EXTEND (\"timestamp\" VARCHAR, isRobot VARCHAR)\nPARTITIONED BY HOUR").authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("w000", expectedSig).expectResources(IngestTableFunctionTest.dataSourceWrite("w000"), Externals.EXTERNAL_RESOURCE_ACTION).expectQuery((Query)IngestTableFunctionTest.newScanQueryBuilder().dataSource((DataSource)httpDataSource).intervals(IngestTableFunctionTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{IngestTableFunctionTest.expressionVirtualColumn("v0", "timestamp_parse(\"timestamp\",null,'UTC')", ColumnType.LONG)}).columns(new String[]{"v0", "isRobot"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING}).build()).verify();
    }

    @Test
    public void testExplainHttpFn() {
        this.skipVectorize();
        String query = "EXPLAIN PLAN FOR\nINSERT INTO dst SELECT x, y, z\nFROM TABLE(http(userName => 'bob',\n                password => 'secret',\n                uris => ARRAY['http://foo.com/bar.csv'],\n                format => 'csv'))\n     EXTEND (x VARCHAR, y VARCHAR, z BIGINT)\nPARTITIONED BY ALL TIME";
        String explanation = "[{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"external\",\"inputSource\":{\"type\":\"http\",\"uris\":[\"http://foo.com/bar.csv\"],\"httpAuthenticationUsername\":\"bob\",\"httpAuthenticationPassword\":{\"type\":\"default\",\"password\":\"secret\"},\"requestHeaders\":{}},\"inputFormat\":{\"type\":\"csv\",\"columns\":[\"x\",\"y\",\"z\"]},\"signature\":[{\"name\":\"x\",\"type\":\"STRING\"},{\"name\":\"y\",\"type\":\"STRING\"},{\"name\":\"z\",\"type\":\"LONG\"}]},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"resultFormat\":\"compactedList\",\"columns\":[\"x\",\"y\",\"z\"],\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlInsertSegmentGranularity\":\"{\\\"type\\\":\\\"all\\\"}\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"columnTypes\":[\"STRING\",\"STRING\",\"LONG\"],\"granularity\":{\"type\":\"all\"},\"legacy\":false},\"signature\":[{\"name\":\"x\",\"type\":\"STRING\"},{\"name\":\"y\",\"type\":\"STRING\"},{\"name\":\"z\",\"type\":\"LONG\"}],\"columnMappings\":[{\"queryColumn\":\"x\",\"outputColumn\":\"x\"},{\"queryColumn\":\"y\",\"outputColumn\":\"y\"},{\"queryColumn\":\"z\",\"outputColumn\":\"z\"}]}]";
        String resources = "[{\"name\":\"EXTERNAL\",\"type\":\"EXTERNAL\"},{\"name\":\"dst\",\"type\":\"DATASOURCE\"}]";
        String attributes = "{\"statementType\":\"INSERT\",\"targetDataSource\":\"dst\",\"partitionedBy\":{\"type\":\"all\"}}";
        this.testQuery(PLANNER_CONFIG_NATIVE_QUERY_EXPLAIN, "EXPLAIN PLAN FOR\nINSERT INTO dst SELECT x, y, z\nFROM TABLE(http(userName => 'bob',\n                password => 'secret',\n                uris => ARRAY['http://foo.com/bar.csv'],\n                format => 'csv'))\n     EXTEND (x VARCHAR, y VARCHAR, z BIGINT)\nPARTITIONED BY ALL TIME", CalciteTests.SUPER_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"external\",\"inputSource\":{\"type\":\"http\",\"uris\":[\"http://foo.com/bar.csv\"],\"httpAuthenticationUsername\":\"bob\",\"httpAuthenticationPassword\":{\"type\":\"default\",\"password\":\"secret\"},\"requestHeaders\":{}},\"inputFormat\":{\"type\":\"csv\",\"columns\":[\"x\",\"y\",\"z\"]},\"signature\":[{\"name\":\"x\",\"type\":\"STRING\"},{\"name\":\"y\",\"type\":\"STRING\"},{\"name\":\"z\",\"type\":\"LONG\"}]},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"resultFormat\":\"compactedList\",\"columns\":[\"x\",\"y\",\"z\"],\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlInsertSegmentGranularity\":\"{\\\"type\\\":\\\"all\\\"}\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"columnTypes\":[\"STRING\",\"STRING\",\"LONG\"],\"granularity\":{\"type\":\"all\"},\"legacy\":false},\"signature\":[{\"name\":\"x\",\"type\":\"STRING\"},{\"name\":\"y\",\"type\":\"STRING\"},{\"name\":\"z\",\"type\":\"LONG\"}],\"columnMappings\":[{\"queryColumn\":\"x\",\"outputColumn\":\"x\"},{\"queryColumn\":\"y\",\"outputColumn\":\"y\"},{\"queryColumn\":\"z\",\"outputColumn\":\"z\"}]}]", "[{\"name\":\"EXTERNAL\",\"type\":\"EXTERNAL\"},{\"name\":\"dst\",\"type\":\"DATASOURCE\"}]", "{\"statementType\":\"INSERT\",\"targetDataSource\":\"dst\",\"partitionedBy\":{\"type\":\"all\"}}"}));
        this.didTest = true;
    }

    @Test
    public void testExplainHttpFnUnauthorized() {
        String query = "EXPLAIN PLAN FOR\nINSERT INTO dst SELECT x, y, z\nFROM TABLE(http(userName => 'bob',\n                password => 'secret',\n                uris => ARRAY['http://foo.com/bar.csv'],\n                format => 'csv'))\n     EXTEND (x VARCHAR, y VARCHAR, z BIGINT)\nPARTITIONED BY ALL TIME";
        this.didTest = true;
        ForbiddenException e = (ForbiddenException)Assertions.assertThrows(ForbiddenException.class, () -> this.testBuilder().plannerConfig(PLANNER_CONFIG_NATIVE_QUERY_EXPLAIN).sql("EXPLAIN PLAN FOR\nINSERT INTO dst SELECT x, y, z\nFROM TABLE(http(userName => 'bob',\n                password => 'secret',\n                uris => ARRAY['http://foo.com/bar.csv'],\n                format => 'csv'))\n     EXTEND (x VARCHAR, y VARCHAR, z BIGINT)\nPARTITIONED BY ALL TIME").authResult(CalciteTests.REGULAR_USER_AUTH_RESULT).run());
        MatcherAssert.assertThat((Object)((Object)e), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.equalTo((Object)"Unauthorized")));
    }

    @Test
    public void testHttpFnWithParameters() {
        this.testIngestionQuery().sql("INSERT INTO dst SELECT *\nFROM TABLE(http(userName => 'bob',\n                 password => 'secret',\n                uris => ?,\n                format => 'csv'))\n     EXTEND (x VARCHAR, y VARCHAR, z BIGINT)\nPARTITIONED BY ALL TIME").authentication(CalciteTests.SUPER_USER_AUTH_RESULT).parameters(Collections.singletonList(new SqlParameter(SqlType.ARRAY, (Object)new String[]{"http://foo.com/bar.csv"}))).expectTarget("dst", this.httpDataSource.getSignature()).expectResources(IngestTableFunctionTest.dataSourceWrite("dst"), Externals.EXTERNAL_RESOURCE_ACTION).expectQuery((Query)IngestTableFunctionTest.newScanQueryBuilder().dataSource((DataSource)this.httpDataSource).intervals(IngestTableFunctionTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"x", "y", "z"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.LONG}).context(CalciteIngestionDmlTest.PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).expectLogicalPlanFrom("httpExtern").verify();
    }

    @Test
    public void testHttpJson() {
        ExternalDataSource httpDataSource = new ExternalDataSource((InputSource)new HttpInputSource(Collections.singletonList(IngestTableFunctionTest.toURI("http://foo.com/bar.json")), "bob", (PasswordProvider)new DefaultPasswordProvider("secret"), SystemFields.none(), null, new HttpInputSourceConfig(null, null)), (InputFormat)new JsonInputFormat(null, null, null, null, null), RowSignature.builder().add("x", ColumnType.STRING).add("y", ColumnType.STRING).add("z", ColumnType.NESTED_DATA).add("a", ColumnType.STRING_ARRAY).add("b", ColumnType.LONG_ARRAY).add("c", ColumnType.FLOAT_ARRAY).add("d", ColumnType.DOUBLE_ARRAY).build());
        this.testIngestionQuery().sql("INSERT INTO dst SELECT *\nFROM TABLE(http(userName => 'bob',\n                 password => 'secret',\n                uris => ARRAY['http://foo.com/bar.json'],\n                format => 'json'))\n     EXTEND (x VARCHAR, y VARCHAR, z TYPE('COMPLEX<json>'), a VARCHAR ARRAY, b BIGINT ARRAY, c FLOAT ARRAY, d DOUBLE ARRAY)\nPARTITIONED BY ALL TIME").authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("dst", httpDataSource.getSignature()).expectResources(IngestTableFunctionTest.dataSourceWrite("dst"), Externals.EXTERNAL_RESOURCE_ACTION).expectQuery((Query)IngestTableFunctionTest.newScanQueryBuilder().dataSource((DataSource)httpDataSource).intervals(IngestTableFunctionTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"x", "y", "z", "a", "b", "c", "d"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.ofComplex((String)"json"), ColumnType.ofArray((ColumnType)ColumnType.STRING), ColumnType.ofArray((ColumnType)ColumnType.LONG), ColumnType.ofArray((ColumnType)ColumnType.FLOAT), ColumnType.ofArray((ColumnType)ColumnType.DOUBLE)}).context(CalciteIngestionDmlTest.PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).verify();
    }

    @Test
    public void testInlineExtern() {
        this.testIngestionQuery().sql("INSERT INTO dst SELECT * FROM %s PARTITIONED BY ALL TIME", this.externSql(this.externalDataSource), new Object[0]).authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("dst", this.externalDataSource.getSignature()).expectResources(IngestTableFunctionTest.dataSourceWrite("dst"), Externals.EXTERNAL_RESOURCE_ACTION).expectQuery((Query)IngestTableFunctionTest.newScanQueryBuilder().dataSource((DataSource)this.externalDataSource).intervals(IngestTableFunctionTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"x", "y", "z"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.LONG}).context(CalciteIngestionDmlTest.PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).expectLogicalPlanFrom("insertFromExternal").verify();
    }

    protected String externSqlByNameNoSig(ExternalDataSource externalDataSource) {
        ObjectMapper queryJsonMapper = this.queryFramework().queryJsonMapper();
        try {
            return StringUtils.format((String)"TABLE(extern(inputSource => %s, inputFormat => %s))", (Object[])new Object[]{Calcites.escapeStringLiteral((String)queryJsonMapper.writeValueAsString((Object)externalDataSource.getInputSource())), Calcites.escapeStringLiteral((String)queryJsonMapper.writeValueAsString((Object)externalDataSource.getInputFormat()))});
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    protected String externClauseFromSig(ExternalDataSource externalDataSource) {
        RowSignature sig = externalDataSource.getSignature();
        StringBuilder buf = new StringBuilder("(");
        for (int i = 0; i < sig.size(); ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(sig.getColumnName(i)).append(" ");
            ColumnType type = (ColumnType)sig.getColumnType(i).get();
            if (type == ColumnType.STRING) {
                buf.append("VARCHAR");
                continue;
            }
            if (type == ColumnType.LONG) {
                buf.append("BIGINT");
                continue;
            }
            if (type == ColumnType.DOUBLE) {
                buf.append(Columns.DOUBLE);
                continue;
            }
            if (type == ColumnType.FLOAT) {
                buf.append(Columns.FLOAT);
                continue;
            }
            throw new UOE("Unsupported native type %s", new Object[]{type});
        }
        return buf.append(")").toString();
    }

    @Test
    public void testInlineExternWithExtend() {
        this.testIngestionQuery().sql("INSERT INTO dst SELECT *\n  FROM %s\n  %s\n  PARTITIONED BY ALL TIME", this.externSqlByNameNoSig(this.externalDataSource), this.externClauseFromSig(this.externalDataSource)).authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("dst", this.externalDataSource.getSignature()).expectResources(IngestTableFunctionTest.dataSourceWrite("dst"), Externals.EXTERNAL_RESOURCE_ACTION).expectQuery((Query)IngestTableFunctionTest.newScanQueryBuilder().dataSource((DataSource)this.externalDataSource).intervals(IngestTableFunctionTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"x", "y", "z"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.LONG}).context(CalciteIngestionDmlTest.PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).expectLogicalPlanFrom("insertFromExternal").verify();
    }

    @Test
    public void testInlineFn() {
        this.testIngestionQuery().sql("INSERT INTO dst SELECT *\nFROM TABLE(inline(data => ARRAY['a,b,1', 'c,d,2'],\n                  format => 'csv'))\n     EXTEND (x VARCHAR, y VARCHAR, z BIGINT)\nPARTITIONED BY ALL TIME").authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("dst", this.externalDataSource.getSignature()).expectResources(IngestTableFunctionTest.dataSourceWrite("dst"), Externals.EXTERNAL_RESOURCE_ACTION).expectQuery((Query)IngestTableFunctionTest.newScanQueryBuilder().dataSource((DataSource)this.externalDataSource).intervals(IngestTableFunctionTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"x", "y", "z"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.LONG}).context(CalciteIngestionDmlTest.PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).expectLogicalPlanFrom("insertFromExternal").verify();
    }

    @Test
    public void testLocalExtern() {
        this.testIngestionQuery().sql("INSERT INTO dst SELECT * FROM %s PARTITIONED BY ALL TIME", this.externSql(this.localDataSource), new Object[0]).authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("dst", this.localDataSource.getSignature()).expectResources(IngestTableFunctionTest.dataSourceWrite("dst"), Externals.EXTERNAL_RESOURCE_ACTION).expectQuery((Query)IngestTableFunctionTest.newScanQueryBuilder().dataSource((DataSource)this.localDataSource).intervals(IngestTableFunctionTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"x", "y", "z"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.LONG}).context(CalciteIngestionDmlTest.PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).expectLogicalPlanFrom("localExtern").verify();
    }

    @Test
    public void testLocalFilesFn() {
        this.testIngestionQuery().sql("INSERT INTO dst SELECT *\nFROM TABLE(localfiles(files => ARRAY['/tmp/foo.csv', '/tmp/bar.csv'],\n                  format => 'csv'))\n     EXTEND (x VARCHAR, y VARCHAR, z BIGINT)\nPARTITIONED BY ALL TIME").authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("dst", this.localDataSource.getSignature()).expectResources(IngestTableFunctionTest.dataSourceWrite("dst"), Externals.EXTERNAL_RESOURCE_ACTION).expectQuery((Query)IngestTableFunctionTest.newScanQueryBuilder().dataSource((DataSource)this.localDataSource).intervals(IngestTableFunctionTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"x", "y", "z"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.LONG}).context(CalciteIngestionDmlTest.PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).expectLogicalPlanFrom("localExtern").verify();
    }

    @Test
    public void testLocalFnOmitExtend() {
        this.testIngestionQuery().sql("INSERT INTO dst SELECT *\nFROM TABLE(localfiles(files => ARRAY['/tmp/foo.csv', '/tmp/bar.csv'],\n                  format => 'csv'))\n     (x VARCHAR, y VARCHAR, z BIGINT)\nPARTITIONED BY ALL TIME").authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("dst", this.localDataSource.getSignature()).expectResources(IngestTableFunctionTest.dataSourceWrite("dst"), Externals.EXTERNAL_RESOURCE_ACTION).expectQuery((Query)IngestTableFunctionTest.newScanQueryBuilder().dataSource((DataSource)this.localDataSource).intervals(IngestTableFunctionTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"x", "y", "z"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.LONG}).context(CalciteIngestionDmlTest.PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).expectLogicalPlanFrom("localExtern").verify();
    }

    @Test
    public void testLocalFnWithAlias() {
        this.testIngestionQuery().sql("INSERT INTO dst\nSELECT myTable.x, myTable.y, myTable.z\nFROM TABLE(localfiles(files => ARRAY['/tmp/foo.csv', '/tmp/bar.csv'],\n                  format => 'csv'))\n     (x VARCHAR, y VARCHAR, z BIGINT)\n     As myTable\nPARTITIONED BY ALL TIME").authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("dst", this.localDataSource.getSignature()).expectResources(IngestTableFunctionTest.dataSourceWrite("dst"), Externals.EXTERNAL_RESOURCE_ACTION).expectQuery((Query)IngestTableFunctionTest.newScanQueryBuilder().dataSource((DataSource)this.localDataSource).intervals(IngestTableFunctionTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"x", "y", "z"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.LONG}).context(CalciteIngestionDmlTest.PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).expectLogicalPlanFrom("localExtern").verify();
    }

    @Test
    public void testLocalFnNotNull() {
        this.testIngestionQuery().sql("INSERT INTO dst\nSELECT myTable.x, myTable.y, myTable.z\nFROM TABLE(localfiles(files => ARRAY['/tmp/foo.csv', '/tmp/bar.csv'],\n                  format => 'csv'))\n     (x VARCHAR NOT NULL, y VARCHAR NOT NULL, z BIGINT NOT NULL)\n     As myTable\nPARTITIONED BY ALL TIME").authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("dst", this.localDataSource.getSignature()).expectResources(IngestTableFunctionTest.dataSourceWrite("dst"), Externals.EXTERNAL_RESOURCE_ACTION).expectQuery((Query)IngestTableFunctionTest.newScanQueryBuilder().dataSource((DataSource)this.localDataSource).intervals(IngestTableFunctionTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"x", "y", "z"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.LONG}).context(CalciteIngestionDmlTest.PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).expectLogicalPlanFrom("localExtern").verify();
    }

    protected static class ExportComponentSupplier
    extends CalciteIngestionDmlTest.IngestionDmlComponentSupplier {
        public ExportComponentSupplier(TempDirProducer tempFolderProducer) {
            super(tempFolderProducer);
        }

        @Override
        public DruidModule getOverrideModule() {
            return DruidModuleCollection.of(new Module[]{super.getOverrideModule(), new LocalOverrideModule()});
        }

        public static class LocalOverrideModule
        implements DruidModule {
            public void configure(Binder binder) {
                binder.bind(HttpInputSourceConfig.class).toInstance((Object)new HttpInputSourceConfig(null, (Set)ImmutableSet.of((Object)"Accept", (Object)"a")));
            }
        }
    }
}

