/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.commons.io.FileUtils;
import org.apache.druid.java.util.common.Numbers;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.TimestampParser;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.server.SpecificSegmentsQuerySegmentWalker;
import org.apache.druid.sql.calcite.BaseCalciteQueryTest;
import org.apache.druid.sql.calcite.NotYetSupported;
import org.apache.druid.sql.calcite.QueryTestRunner;
import org.apache.druid.sql.calcite.SqlTestFrameworkConfig;
import org.apache.druid.sql.calcite.TempDirProducer;
import org.apache.druid.sql.calcite.util.SqlTestFramework;
import org.apache.druid.sql.calcite.util.TestDataBuilder;
import org.joda.time.DateTime;
import org.joda.time.LocalTime;
import org.junit.Assert;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.RegisterExtension;

@SqlTestFrameworkConfig.ComponentSupplier(value=DrillComponentSupplier.class)
public class DrillWindowQueryTest
extends BaseCalciteQueryTest {
    @RegisterExtension
    public NotYetSupported.NotYetSupportedProcessor ignoreProcessor = new NotYetSupported.NotYetSupportedProcessor();
    @RegisterExtension
    public DrillTestCaseLoaderRule drillTestCaseRule = new DrillTestCaseLoaderRule();

    @Test
    public void ensureAllDeclared() throws Exception {
        Assumptions.assumeTrue((boolean)DrillWindowQueryTest.class.equals(this.getClass()));
        URL windowQueriesUrl = ClassLoader.getSystemResource("drill/window/queries/");
        Path windowFolder = new File(windowQueriesUrl.toURI()).toPath();
        Set allCases = FileUtils.streamFiles((File)windowFolder.toFile(), (boolean)true, (String[])new String[]{"q"}).map(file -> windowFolder.relativize(file.toPath()).toString()).sorted().collect(Collectors.toSet());
        for (Method method : DrillWindowQueryTest.class.getDeclaredMethods()) {
            DrillTest ann = method.getAnnotation(DrillTest.class);
            if (method.getAnnotation(Test.class) == null || ann == null || allCases.remove(ann.value() + ".q")) continue;
            Assert.fail((String)String.format(Locale.ENGLISH, "Testcase [%s] references invalid file [%s].", method.getName(), ann.value()));
        }
        for (String string : allCases) {
            string = string.substring(0, string.lastIndexOf(46));
            System.out.printf(Locale.ENGLISH, "@%s( \"%s\" )\n@Test\npublic void test_%s() {\n    windowQueryTest();\n}\n", DrillTest.class.getSimpleName(), string, string.replace('/', '_'));
        }
        Assert.assertEquals((String)"Found some non-declared testcases; please add the new testcases printed to the console!", (long)0L, (long)allCases.size());
    }

    private static List<Object[]> parseResults(RowSignature rs, List<String[]> results) {
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        for (String[] row : results) {
            Object[] newRow = new Object[row.length];
            List cc = rs.getColumnNames();
            for (int i = 0; i < cc.size(); ++i) {
                ColumnType type = (ColumnType)rs.getColumnType(i).get();
                Assert.assertNull((Object)type.getComplexTypeName());
                newRow[i] = DrillWindowQueryTest.parseElement(row[i], (ValueType)type.getType());
            }
            ret.add(newRow);
        }
        return ret;
    }

    private static Object parseElement(String element, ValueType elementType) {
        if ("null".equals(element)) {
            return null;
        }
        switch (elementType) {
            case STRING: {
                return element;
            }
            case LONG: {
                return DrillWindowQueryTest.parseLongValue(element);
            }
            case DOUBLE: {
                return Numbers.parseDoubleObject((String)element);
            }
            case ARRAY: {
                String[] elements = element.substring(1, element.length() - 1).split(",");
                ArrayList<String> arrayElements = new ArrayList<String>();
                for (String s : elements) {
                    arrayElements.add(DrillWindowQueryTest.parseElement(s.trim(), ValueType.STRING).toString());
                }
                return "[" + String.join((CharSequence)",", arrayElements) + "]";
            }
        }
        throw new RuntimeException("unimplemented type: " + String.valueOf(elementType));
    }

    private static Object parseLongValue(String val) {
        if ("".equals(val)) {
            return null;
        }
        try {
            return Long.parseLong(val);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                double d = Double.parseDouble(val);
                return (long)d;
            }
            catch (NumberFormatException d) {
                try {
                    LocalTime v = LocalTime.parse((String)val);
                    Long l = v.getMillisOfDay();
                    return l;
                }
                catch (Exception v) {
                    Function parser = TimestampParser.createTimestampParser((String)"auto");
                    try {
                        DateTime v2 = (DateTime)parser.apply((Object)val);
                        return v2.getMillis();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new RuntimeException("Can't parse input!");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void windowQueryTest() {
        Thread thread = null;
        String oldName = null;
        try {
            thread = Thread.currentThread();
            oldName = thread.getName();
            DrillTestCase testCase = this.drillTestCaseRule.testCase;
            thread.setName("drillWindowQuery-" + testCase.filename);
            HashMap<String, Object> queryContext = new HashMap<String, Object>(this.testBuilder().getQueryContext());
            queryContext.putAll(this.getQueryContext());
            this.testBuilder().skipVectorize(true).queryContext(queryContext).sql(testCase.getQueryString()).expectedResults(new TextualResultsVerifier(testCase.getExpectedResults(), null)).run();
        }
        finally {
            if (thread != null && oldName != null) {
                thread.setName(oldName);
            }
        }
    }

    protected Map<String, Object> getQueryContext() {
        return ImmutableMap.of((Object)"need_capture_hook", (Object)true, (Object)"debug", (Object)true);
    }

    @DrillTest(value="aggregates/aggOWnFn_11")
    @Test
    public void test_aggregates_aggOWnFn_11() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_13")
    @Test
    public void test_aggregates_aggOWnFn_13() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_16")
    @Test
    public void test_aggregates_aggOWnFn_16() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_1")
    @Test
    public void test_aggregates_aggOWnFn_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_20")
    @Test
    public void test_aggregates_aggOWnFn_20() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_21")
    @Test
    public void test_aggregates_aggOWnFn_21() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_2")
    @Test
    public void test_aggregates_aggOWnFn_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_30")
    @Test
    public void test_aggregates_aggOWnFn_30() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_31")
    @Test
    public void test_aggregates_aggOWnFn_31() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_32")
    @Test
    public void test_aggregates_aggOWnFn_32() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_33")
    @Test
    public void test_aggregates_aggOWnFn_33() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_34")
    @Test
    public void test_aggregates_aggOWnFn_34() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_35")
    @Test
    public void test_aggregates_aggOWnFn_35() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_36")
    @Test
    public void test_aggregates_aggOWnFn_36() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_37")
    @Test
    public void test_aggregates_aggOWnFn_37() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_38")
    @Test
    public void test_aggregates_aggOWnFn_38() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_41")
    @Test
    public void test_aggregates_aggOWnFn_41() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_42")
    @Test
    public void test_aggregates_aggOWnFn_42() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_43")
    @Test
    public void test_aggregates_aggOWnFn_43() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_44")
    @Test
    public void test_aggregates_aggOWnFn_44() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_45")
    @Test
    public void test_aggregates_aggOWnFn_45() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_46")
    @Test
    public void test_aggregates_aggOWnFn_46() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_47")
    @Test
    public void test_aggregates_aggOWnFn_47() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_48")
    @Test
    public void test_aggregates_aggOWnFn_48() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_49")
    @Test
    public void test_aggregates_aggOWnFn_49() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_51")
    @Test
    public void test_aggregates_aggOWnFn_51() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_5")
    @Test
    public void test_aggregates_aggOWnFn_5() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_6")
    @Test
    public void test_aggregates_aggOWnFn_6() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_7")
    @Test
    public void test_aggregates_aggOWnFn_7() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_8")
    @Test
    public void test_aggregates_aggOWnFn_8() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_9")
    @Test
    public void test_aggregates_aggOWnFn_9() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/mtyOvrCluse_01")
    @Test
    public void test_aggregates_mtyOvrCluse_01() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/mtyOvrCluse_02")
    @Test
    public void test_aggregates_mtyOvrCluse_02() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/mtyOvrCluse_03")
    @Test
    public void test_aggregates_mtyOvrCluse_03() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/mtyOvrCluse_04")
    @Test
    public void test_aggregates_mtyOvrCluse_04() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/mtyOvrCluse_05")
    @Test
    public void test_aggregates_mtyOvrCluse_05() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_11")
    @Test
    public void test_aggregates_winFnQry_11() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_14")
    @Test
    public void test_aggregates_winFnQry_14() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_19")
    @Test
    public void test_aggregates_winFnQry_19() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_22")
    @Test
    public void test_aggregates_winFnQry_22() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_24")
    @Test
    public void test_aggregates_winFnQry_24() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_29")
    @Test
    public void test_aggregates_winFnQry_29() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_56")
    @Test
    public void test_aggregates_winFnQry_56() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_57")
    @Test
    public void test_aggregates_winFnQry_57() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_58")
    @Test
    public void test_aggregates_winFnQry_58() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_59")
    @Test
    public void test_aggregates_winFnQry_59() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_60")
    @Test
    public void test_aggregates_winFnQry_60() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/wo_OrdrBy_10")
    @Test
    public void test_aggregates_wo_OrdrBy_10() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/wo_OrdrBy_11")
    @Test
    public void test_aggregates_wo_OrdrBy_11() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/wo_OrdrBy_12")
    @Test
    public void test_aggregates_wo_OrdrBy_12() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/wo_OrdrBy_13")
    @Test
    public void test_aggregates_wo_OrdrBy_13() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/wo_OrdrBy_14")
    @Test
    public void test_aggregates_wo_OrdrBy_14() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/wo_OrdrBy_15")
    @Test
    public void test_aggregates_wo_OrdrBy_15() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/wo_OrdrBy_16")
    @Test
    public void test_aggregates_wo_OrdrBy_16() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/wo_OrdrBy_1")
    @Test
    public void test_aggregates_wo_OrdrBy_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/wo_OrdrBy_2")
    @Test
    public void test_aggregates_wo_OrdrBy_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/wo_OrdrBy_3")
    @Test
    public void test_aggregates_wo_OrdrBy_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/wo_OrdrBy_4")
    @Test
    public void test_aggregates_wo_OrdrBy_4() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/wo_OrdrBy_5")
    @Test
    public void test_aggregates_wo_OrdrBy_5() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/wo_OrdrBy_6")
    @Test
    public void test_aggregates_wo_OrdrBy_6() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/wo_OrdrBy_7")
    @Test
    public void test_aggregates_wo_OrdrBy_7() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/wo_OrdrBy_8")
    @Test
    public void test_aggregates_wo_OrdrBy_8() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/wo_OrdrBy_9")
    @Test
    public void test_aggregates_wo_OrdrBy_9() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_11")
    @Test
    public void test_aggregates_woPrtnBy_11() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_16")
    @Test
    public void test_aggregates_woPrtnBy_16() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_1")
    @Test
    public void test_aggregates_woPrtnBy_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_21")
    @Test
    public void test_aggregates_woPrtnBy_21() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_22")
    @Test
    public void test_aggregates_woPrtnBy_22() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_23")
    @Test
    public void test_aggregates_woPrtnBy_23() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_24")
    @Test
    public void test_aggregates_woPrtnBy_24() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_26")
    @Test
    public void test_aggregates_woPrtnBy_26() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_27")
    @Test
    public void test_aggregates_woPrtnBy_27() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_28")
    @Test
    public void test_aggregates_woPrtnBy_28() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_29")
    @Test
    public void test_aggregates_woPrtnBy_29() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_2")
    @Test
    public void test_aggregates_woPrtnBy_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_30")
    @Test
    public void test_aggregates_woPrtnBy_30() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_31")
    @Test
    public void test_aggregates_woPrtnBy_31() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_32")
    @Test
    public void test_aggregates_woPrtnBy_32() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_33")
    @Test
    public void test_aggregates_woPrtnBy_33() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_34")
    @Test
    public void test_aggregates_woPrtnBy_34() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_35")
    @Test
    public void test_aggregates_woPrtnBy_35() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_36")
    @Test
    public void test_aggregates_woPrtnBy_36() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_37")
    @Test
    public void test_aggregates_woPrtnBy_37() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_38")
    @Test
    public void test_aggregates_woPrtnBy_38() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_39")
    @Test
    public void test_aggregates_woPrtnBy_39() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_40")
    @Test
    public void test_aggregates_woPrtnBy_40() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_41")
    @Test
    public void test_aggregates_woPrtnBy_41() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_42")
    @Test
    public void test_aggregates_woPrtnBy_42() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_43")
    @Test
    public void test_aggregates_woPrtnBy_43() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_44")
    @Test
    public void test_aggregates_woPrtnBy_44() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_45")
    @Test
    public void test_aggregates_woPrtnBy_45() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_46")
    @Test
    public void test_aggregates_woPrtnBy_46() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_47")
    @Test
    public void test_aggregates_woPrtnBy_47() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_48")
    @Test
    public void test_aggregates_woPrtnBy_48() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_49")
    @Test
    public void test_aggregates_woPrtnBy_49() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_50")
    @Test
    public void test_aggregates_woPrtnBy_50() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/wPrtnOrdrBy_10")
    @Test
    public void test_aggregates_wPrtnOrdrBy_10() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/wPrtnOrdrBy_1")
    @Test
    public void test_aggregates_wPrtnOrdrBy_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/wPrtnOrdrBy_2")
    @Test
    public void test_aggregates_wPrtnOrdrBy_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/wPrtnOrdrBy_3")
    @Test
    public void test_aggregates_wPrtnOrdrBy_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/wPrtnOrdrBy_4")
    @Test
    public void test_aggregates_wPrtnOrdrBy_4() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/wPrtnOrdrBy_5")
    @Test
    public void test_aggregates_wPrtnOrdrBy_5() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/wPrtnOrdrBy_6")
    @Test
    public void test_aggregates_wPrtnOrdrBy_6() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/wPrtnOrdrBy_7")
    @Test
    public void test_aggregates_wPrtnOrdrBy_7() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/wPrtnOrdrBy_8")
    @Test
    public void test_aggregates_wPrtnOrdrBy_8() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/wPrtnOrdrBy_9")
    @Test
    public void test_aggregates_wPrtnOrdrBy_9() {
        this.windowQueryTest();
    }

    @DrillTest(value="first_val/firstValFn_10")
    @Test
    public void test_first_val_firstValFn_10() {
        this.windowQueryTest();
    }

    @DrillTest(value="first_val/firstValFn_11")
    @Test
    public void test_first_val_firstValFn_11() {
        this.windowQueryTest();
    }

    @DrillTest(value="first_val/firstValFn_12")
    @Test
    public void test_first_val_firstValFn_12() {
        this.windowQueryTest();
    }

    @DrillTest(value="first_val/firstValFn_13")
    @Test
    public void test_first_val_firstValFn_13() {
        this.windowQueryTest();
    }

    @DrillTest(value="first_val/firstValFn_14")
    @Test
    public void test_first_val_firstValFn_14() {
        this.windowQueryTest();
    }

    @DrillTest(value="first_val/firstValFn_15")
    @Test
    public void test_first_val_firstValFn_15() {
        this.windowQueryTest();
    }

    @DrillTest(value="first_val/firstValFn_16")
    @Test
    public void test_first_val_firstValFn_16() {
        this.windowQueryTest();
    }

    @DrillTest(value="first_val/firstValFn_1")
    @Test
    public void test_first_val_firstValFn_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="first_val/firstValFn_20")
    @Test
    public void test_first_val_firstValFn_20() {
        this.windowQueryTest();
    }

    @DrillTest(value="first_val/firstValFn_26")
    @Test
    public void test_first_val_firstValFn_26() {
        this.windowQueryTest();
    }

    @DrillTest(value="first_val/firstValFn_27")
    @Test
    public void test_first_val_firstValFn_27() {
        this.windowQueryTest();
    }

    @DrillTest(value="first_val/firstValFn_28")
    @Test
    public void test_first_val_firstValFn_28() {
        this.windowQueryTest();
    }

    @DrillTest(value="first_val/firstValFn_2")
    @Test
    public void test_first_val_firstValFn_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="first_val/firstValFn_30")
    @Test
    public void test_first_val_firstValFn_30() {
        this.windowQueryTest();
    }

    @DrillTest(value="first_val/firstValFn_31")
    @Test
    public void test_first_val_firstValFn_31() {
        this.windowQueryTest();
    }

    @DrillTest(value="first_val/firstValFn_3")
    @Test
    public void test_first_val_firstValFn_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="first_val/firstValFn_4")
    @Test
    public void test_first_val_firstValFn_4() {
        this.windowQueryTest();
    }

    @DrillTest(value="first_val/firstValFn_6")
    @Test
    public void test_first_val_firstValFn_6() {
        this.windowQueryTest();
    }

    @DrillTest(value="first_val/firstValFn_7")
    @Test
    public void test_first_val_firstValFn_7() {
        this.windowQueryTest();
    }

    @DrillTest(value="first_val/firstValFn_8")
    @Test
    public void test_first_val_firstValFn_8() {
        this.windowQueryTest();
    }

    @DrillTest(value="first_val/firstValFn_9")
    @Test
    public void test_first_val_firstValFn_9() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_bgint_5")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_bgint_5() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_bln_1")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_bln_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_bln_2")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_bln_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_bln_3")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_bln_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_chr_4")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_chr_4() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_dbl_4")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_dbl_4() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_dbl_5")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_dbl_5() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_dt_3")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_dt_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_int11")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_int11() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_int12")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_int12() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_int1")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_int1() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_int2")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_int2() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_int3")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_int3() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_int4")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_int4() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_int5")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_int5() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_int6")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_int6() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_vchr_4")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_vchr_4() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_bgint_1")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_bgint_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_bgint_2")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_bgint_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_bgint_3")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_bgint_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_bgint_4")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_bgint_4() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_bgint_5")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_bgint_5() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_bln_1")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_bln_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_bln_2")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_bln_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_bln_3")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_bln_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_dbl_1")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_dbl_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_dbl_2")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_dbl_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_dbl_3")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_dbl_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_dbl_4")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_dbl_4() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_dbl_5")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_dbl_5() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_dt_3")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_dt_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_int_10")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_int_10() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_int_11")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_int_11() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_int_12")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_int_12() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_int_1")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_int_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_int_2")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_int_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_int_3")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_int_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_int_4")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_int_4() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_int_5")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_int_5() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_int_8")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_int_8() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_int_9")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_int_9() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_bgint_5")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_bgint_5() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_bln_1")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_bln_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_bln_2")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_bln_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_bln_3")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_bln_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_chr_4")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_chr_4() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_dbl_4")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_dbl_4() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_dbl_5")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_dbl_5() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_dt_3")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_dt_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_int11")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_int11() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_int12")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_int12() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_int1")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_int1() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_int2")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_int2() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_int3")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_int3() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_int4")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_int4() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_int5")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_int5() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_int6")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_int6() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_vchr_4")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_vchr_4() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_bgint_1")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_bgint_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_bgint_2")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_bgint_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_bgint_3")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_bgint_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_bgint_5")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_bgint_5() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_bgint_7")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_bgint_7() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_bln_1")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_bln_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_bln_2")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_bln_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_bln_3")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_bln_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_char_4")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_char_4() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_char_5")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_char_5() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_dbl_1")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_dbl_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_dbl_2")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_dbl_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_dbl_3")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_dbl_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_dbl_4")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_dbl_4() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_dbl_5")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_dbl_5() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_dt_3")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_dt_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_int_10")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_int_10() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_int_11")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_int_11() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_int_12")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_int_12() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_int_14")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_int_14() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_int_1")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_int_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_int_2")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_int_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_int_3")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_int_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_int_4")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_int_4() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_int_5")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_int_5() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_int_6")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_int_6() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_int_7")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_int_7() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_int_8")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_int_8() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_int_9")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_int_9() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_vchar_4")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_vchar_4() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_vchar_5")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_vchar_5() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_01")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_01() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_02")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_02() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_03")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_03() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_04")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_04() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_05")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_05() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_06")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_06() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_07")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_07() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_08")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_08() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_09")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_09() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_10")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_10() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_11")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_11() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_12")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_12() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_13")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_13() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_14")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_14() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_15")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_15() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_16")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_16() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_18")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_18() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_19")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_19() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_21")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_21() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_29")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_29() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_31")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_31() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_32")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_32() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_33")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_33() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_34")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_34() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_35")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_35() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_36")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_36() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_37")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_37() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_38")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_38() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_39")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_39() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_40")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_40() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_50")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_50() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_51")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_51() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_52")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_52() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_56")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_56() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_104")
    @Test
    public void test_lag_func_lag_Fn_104() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_105")
    @Test
    public void test_lag_func_lag_Fn_105() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_106")
    @Test
    public void test_lag_func_lag_Fn_106() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_107")
    @Test
    public void test_lag_func_lag_Fn_107() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_110")
    @Test
    public void test_lag_func_lag_Fn_110() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_111")
    @Test
    public void test_lag_func_lag_Fn_111() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_112")
    @Test
    public void test_lag_func_lag_Fn_112() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_1")
    @Test
    public void test_lag_func_lag_Fn_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_28")
    @Test
    public void test_lag_func_lag_Fn_28() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_29")
    @Test
    public void test_lag_func_lag_Fn_29() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_2")
    @Test
    public void test_lag_func_lag_Fn_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_30")
    @Test
    public void test_lag_func_lag_Fn_30() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_31")
    @Test
    public void test_lag_func_lag_Fn_31() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_32")
    @Test
    public void test_lag_func_lag_Fn_32() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_34")
    @Test
    public void test_lag_func_lag_Fn_34() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_35")
    @Test
    public void test_lag_func_lag_Fn_35() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_37")
    @Test
    public void test_lag_func_lag_Fn_37() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_38")
    @Test
    public void test_lag_func_lag_Fn_38() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_39")
    @Test
    public void test_lag_func_lag_Fn_39() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_3")
    @Test
    public void test_lag_func_lag_Fn_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_40")
    @Test
    public void test_lag_func_lag_Fn_40() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_43")
    @Test
    public void test_lag_func_lag_Fn_43() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_44")
    @Test
    public void test_lag_func_lag_Fn_44() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_46")
    @Test
    public void test_lag_func_lag_Fn_46() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_47")
    @Test
    public void test_lag_func_lag_Fn_47() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_48")
    @Test
    public void test_lag_func_lag_Fn_48() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_49")
    @Test
    public void test_lag_func_lag_Fn_49() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_4")
    @Test
    public void test_lag_func_lag_Fn_4() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_50")
    @Test
    public void test_lag_func_lag_Fn_50() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_52")
    @Test
    public void test_lag_func_lag_Fn_52() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_53")
    @Test
    public void test_lag_func_lag_Fn_53() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_55")
    @Test
    public void test_lag_func_lag_Fn_55() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_56")
    @Test
    public void test_lag_func_lag_Fn_56() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_57")
    @Test
    public void test_lag_func_lag_Fn_57() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_58")
    @Test
    public void test_lag_func_lag_Fn_58() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_59")
    @Test
    public void test_lag_func_lag_Fn_59() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_5")
    @Test
    public void test_lag_func_lag_Fn_5() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_61")
    @Test
    public void test_lag_func_lag_Fn_61() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_62")
    @Test
    public void test_lag_func_lag_Fn_62() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_70")
    @Test
    public void test_lag_func_lag_Fn_70() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_73")
    @Test
    public void test_lag_func_lag_Fn_73() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_74")
    @Test
    public void test_lag_func_lag_Fn_74() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_75")
    @Test
    public void test_lag_func_lag_Fn_75() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_76")
    @Test
    public void test_lag_func_lag_Fn_76() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_78")
    @Test
    public void test_lag_func_lag_Fn_78() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_79")
    @Test
    public void test_lag_func_lag_Fn_79() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_7")
    @Test
    public void test_lag_func_lag_Fn_7() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_80")
    @Test
    public void test_lag_func_lag_Fn_80() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_81")
    @Test
    public void test_lag_func_lag_Fn_81() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_83")
    @Test
    public void test_lag_func_lag_Fn_83() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_84")
    @Test
    public void test_lag_func_lag_Fn_84() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_85")
    @Test
    public void test_lag_func_lag_Fn_85() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_86")
    @Test
    public void test_lag_func_lag_Fn_86() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_87")
    @Test
    public void test_lag_func_lag_Fn_87() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_88")
    @Test
    public void test_lag_func_lag_Fn_88() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_89")
    @Test
    public void test_lag_func_lag_Fn_89() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_8")
    @Test
    public void test_lag_func_lag_Fn_8() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_90")
    @Test
    public void test_lag_func_lag_Fn_90() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_91")
    @Test
    public void test_lag_func_lag_Fn_91() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_92")
    @Test
    public void test_lag_func_lag_Fn_92() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_93")
    @Test
    public void test_lag_func_lag_Fn_93() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_94")
    @Test
    public void test_lag_func_lag_Fn_94() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_98")
    @Test
    public void test_lag_func_lag_Fn_98() {
        this.windowQueryTest();
    }

    @DrillTest(value="last_val/lastValFn_26")
    @Test
    public void test_last_val_lastValFn_26() {
        this.windowQueryTest();
    }

    @DrillTest(value="last_val/lastValFn_27")
    @Test
    public void test_last_val_lastValFn_27() {
        this.windowQueryTest();
    }

    @DrillTest(value="last_val/lastValFn_28")
    @Test
    public void test_last_val_lastValFn_28() {
        this.windowQueryTest();
    }

    @DrillTest(value="last_val/lastValFn_30")
    @Test
    public void test_last_val_lastValFn_30() {
        this.windowQueryTest();
    }

    @DrillTest(value="last_val/lastValFn_31")
    @Test
    public void test_last_val_lastValFn_31() {
        this.windowQueryTest();
    }

    @DrillTest(value="last_val/lastValFn_37")
    @Test
    public void test_last_val_lastValFn_37() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_100")
    @Test
    public void test_lead_func_lead_Fn_100() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_101")
    @Test
    public void test_lead_func_lead_Fn_101() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_102")
    @Test
    public void test_lead_func_lead_Fn_102() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_105")
    @Test
    public void test_lead_func_lead_Fn_105() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_106")
    @Test
    public void test_lead_func_lead_Fn_106() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_107")
    @Test
    public void test_lead_func_lead_Fn_107() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_1")
    @Test
    public void test_lead_func_lead_Fn_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_28")
    @Test
    public void test_lead_func_lead_Fn_28() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_29")
    @Test
    public void test_lead_func_lead_Fn_29() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_2")
    @Test
    public void test_lead_func_lead_Fn_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_30")
    @Test
    public void test_lead_func_lead_Fn_30() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_31")
    @Test
    public void test_lead_func_lead_Fn_31() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_32")
    @Test
    public void test_lead_func_lead_Fn_32() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_34")
    @Test
    public void test_lead_func_lead_Fn_34() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_35")
    @Test
    public void test_lead_func_lead_Fn_35() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_37")
    @Test
    public void test_lead_func_lead_Fn_37() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_38")
    @Test
    public void test_lead_func_lead_Fn_38() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_39")
    @Test
    public void test_lead_func_lead_Fn_39() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_3")
    @Test
    public void test_lead_func_lead_Fn_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_40")
    @Test
    public void test_lead_func_lead_Fn_40() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_41")
    @Test
    public void test_lead_func_lead_Fn_41() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_43")
    @Test
    public void test_lead_func_lead_Fn_43() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_44")
    @Test
    public void test_lead_func_lead_Fn_44() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_46")
    @Test
    public void test_lead_func_lead_Fn_46() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_47")
    @Test
    public void test_lead_func_lead_Fn_47() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_48")
    @Test
    public void test_lead_func_lead_Fn_48() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_49")
    @Test
    public void test_lead_func_lead_Fn_49() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_4")
    @Test
    public void test_lead_func_lead_Fn_4() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_50")
    @Test
    public void test_lead_func_lead_Fn_50() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_52")
    @Test
    public void test_lead_func_lead_Fn_52() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_53")
    @Test
    public void test_lead_func_lead_Fn_53() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_55")
    @Test
    public void test_lead_func_lead_Fn_55() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_56")
    @Test
    public void test_lead_func_lead_Fn_56() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_57")
    @Test
    public void test_lead_func_lead_Fn_57() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_58")
    @Test
    public void test_lead_func_lead_Fn_58() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_59")
    @Test
    public void test_lead_func_lead_Fn_59() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_5")
    @Test
    public void test_lead_func_lead_Fn_5() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_61")
    @Test
    public void test_lead_func_lead_Fn_61() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_62")
    @Test
    public void test_lead_func_lead_Fn_62() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_70")
    @Test
    public void test_lead_func_lead_Fn_70() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_73")
    @Test
    public void test_lead_func_lead_Fn_73() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_74")
    @Test
    public void test_lead_func_lead_Fn_74() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_75")
    @Test
    public void test_lead_func_lead_Fn_75() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_76")
    @Test
    public void test_lead_func_lead_Fn_76() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_78")
    @Test
    public void test_lead_func_lead_Fn_78() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_79")
    @Test
    public void test_lead_func_lead_Fn_79() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_7")
    @Test
    public void test_lead_func_lead_Fn_7() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_80")
    @Test
    public void test_lead_func_lead_Fn_80() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_81")
    @Test
    public void test_lead_func_lead_Fn_81() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_82")
    @Test
    public void test_lead_func_lead_Fn_82() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_83")
    @Test
    public void test_lead_func_lead_Fn_83() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_84")
    @Test
    public void test_lead_func_lead_Fn_84() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_85")
    @Test
    public void test_lead_func_lead_Fn_85() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_86")
    @Test
    public void test_lead_func_lead_Fn_86() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_87")
    @Test
    public void test_lead_func_lead_Fn_87() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_88")
    @Test
    public void test_lead_func_lead_Fn_88() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_89")
    @Test
    public void test_lead_func_lead_Fn_89() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_8")
    @Test
    public void test_lead_func_lead_Fn_8() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_93")
    @Test
    public void test_lead_func_lead_Fn_93() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_99")
    @Test
    public void test_lead_func_lead_Fn_99() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/basic_1")
    @Test
    public void test_nestedAggs_basic_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/basic_2")
    @Test
    public void test_nestedAggs_basic_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/basic_4")
    @Test
    public void test_nestedAggs_basic_4() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/basic_6")
    @Test
    public void test_nestedAggs_basic_6() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/basic_8")
    @Test
    public void test_nestedAggs_basic_8() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/basic_9")
    @Test
    public void test_nestedAggs_basic_9() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/emtyOvrCls_10")
    @Test
    public void test_nestedAggs_emtyOvrCls_10() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/emtyOvrCls_11")
    @Test
    public void test_nestedAggs_emtyOvrCls_11() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/emtyOvrCls_12")
    @Test
    public void test_nestedAggs_emtyOvrCls_12() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/emtyOvrCls_1")
    @Test
    public void test_nestedAggs_emtyOvrCls_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/emtyOvrCls_2")
    @Test
    public void test_nestedAggs_emtyOvrCls_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/emtyOvrCls_3")
    @Test
    public void test_nestedAggs_emtyOvrCls_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/emtyOvrCls_4")
    @Test
    public void test_nestedAggs_emtyOvrCls_4() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/emtyOvrCls_5")
    @Test
    public void test_nestedAggs_emtyOvrCls_5() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/emtyOvrCls_6")
    @Test
    public void test_nestedAggs_emtyOvrCls_6() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/emtyOvrCls_9")
    @Test
    public void test_nestedAggs_emtyOvrCls_9() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/frmclause01")
    @Test
    public void test_nestedAggs_frmclause01() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/frmclause02")
    @Test
    public void test_nestedAggs_frmclause02() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/frmclause06")
    @Test
    public void test_nestedAggs_frmclause06() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/frmclause14")
    @Test
    public void test_nestedAggs_frmclause14() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/frmclause19")
    @Test
    public void test_nestedAggs_frmclause19() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/multiWin_1")
    @Test
    public void test_nestedAggs_multiWin_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/nstdagg01")
    @Test
    public void test_nestedAggs_nstdagg01() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/nstdagg02")
    @Test
    public void test_nestedAggs_nstdagg02() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/nstdagg03")
    @Test
    public void test_nestedAggs_nstdagg03() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/nstdagg04")
    @Test
    public void test_nestedAggs_nstdagg04() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/nstdagg05")
    @Test
    public void test_nestedAggs_nstdagg05() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/nstdagg06")
    @Test
    public void test_nestedAggs_nstdagg06() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/nstdagg07")
    @Test
    public void test_nestedAggs_nstdagg07() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/nstdagg08")
    @Test
    public void test_nestedAggs_nstdagg08() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/nstdagg09")
    @Test
    public void test_nestedAggs_nstdagg09() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/nstdagg10")
    @Test
    public void test_nestedAggs_nstdagg10() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/nstdagg11")
    @Test
    public void test_nestedAggs_nstdagg11() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/nstdagg12")
    @Test
    public void test_nestedAggs_nstdagg12() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/nstdagg13")
    @Test
    public void test_nestedAggs_nstdagg13() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/nstdagg14")
    @Test
    public void test_nestedAggs_nstdagg14() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/nstdagg15")
    @Test
    public void test_nestedAggs_nstdagg15() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/nstdagg16")
    @Test
    public void test_nestedAggs_nstdagg16() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/nstdagg17")
    @Test
    public void test_nestedAggs_nstdagg17() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/nstdagg18")
    @Test
    public void test_nestedAggs_nstdagg18() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/nstdagg19")
    @Test
    public void test_nestedAggs_nstdagg19() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/nstdagg20")
    @Test
    public void test_nestedAggs_nstdagg20() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/nstdagg21")
    @Test
    public void test_nestedAggs_nstdagg21() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/nstdagg22")
    @Test
    public void test_nestedAggs_nstdagg22() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/nstdagg23")
    @Test
    public void test_nestedAggs_nstdagg23() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/nstdagg25")
    @Test
    public void test_nestedAggs_nstdagg25() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/nstdagg26")
    @Test
    public void test_nestedAggs_nstdagg26() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/woutOby_1")
    @Test
    public void test_nestedAggs_woutOby_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/woutOby_2")
    @Test
    public void test_nestedAggs_woutOby_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/woutOby_3")
    @Test
    public void test_nestedAggs_woutOby_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/woutOby_4")
    @Test
    public void test_nestedAggs_woutOby_4() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/woutOby_5")
    @Test
    public void test_nestedAggs_woutOby_5() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/woutOby_8")
    @Test
    public void test_nestedAggs_woutOby_8() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/wPbOb_10")
    @Test
    public void test_nestedAggs_wPbOb_10() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/wPbOb_11")
    @Test
    public void test_nestedAggs_wPbOb_11() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/wPbOb_12")
    @Test
    public void test_nestedAggs_wPbOb_12() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/wPbOb_13")
    @Test
    public void test_nestedAggs_wPbOb_13() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/wPbOb_14")
    @Test
    public void test_nestedAggs_wPbOb_14() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/wPbOb_15")
    @Test
    public void test_nestedAggs_wPbOb_15() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/wPbOb_16")
    @Test
    public void test_nestedAggs_wPbOb_16() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/wPbOb_17")
    @Test
    public void test_nestedAggs_wPbOb_17() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/wPbOb_18")
    @Test
    public void test_nestedAggs_wPbOb_18() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/wPbOb_19")
    @Test
    public void test_nestedAggs_wPbOb_19() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/wPbOb_1")
    @Test
    public void test_nestedAggs_wPbOb_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/wPbOb_20")
    @Test
    public void test_nestedAggs_wPbOb_20() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/wPbOb_21")
    @Test
    public void test_nestedAggs_wPbOb_21() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/wPbOb_22")
    @Test
    public void test_nestedAggs_wPbOb_22() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/wPbOb_23")
    @Test
    public void test_nestedAggs_wPbOb_23() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/wPbOb_24")
    @Test
    public void test_nestedAggs_wPbOb_24() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/wPbOb_25")
    @Test
    public void test_nestedAggs_wPbOb_25() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/wPbOb_26")
    @Test
    public void test_nestedAggs_wPbOb_26() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/wPbOb_2")
    @Test
    public void test_nestedAggs_wPbOb_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/wPbOb_3")
    @Test
    public void test_nestedAggs_wPbOb_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/wPbOb_4")
    @Test
    public void test_nestedAggs_wPbOb_4() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/wPbOb_5")
    @Test
    public void test_nestedAggs_wPbOb_5() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/wPbOb_6")
    @Test
    public void test_nestedAggs_wPbOb_6() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/wPbOb_7")
    @Test
    public void test_nestedAggs_wPbOb_7() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/wPbOb_8")
    @Test
    public void test_nestedAggs_wPbOb_8() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/wPbOb_9")
    @Test
    public void test_nestedAggs_wPbOb_9() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_10")
    @Test
    public void test_ntile_func_ntileFn_10() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_11")
    @Test
    public void test_ntile_func_ntileFn_11() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_12")
    @Test
    public void test_ntile_func_ntileFn_12() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_13")
    @Test
    public void test_ntile_func_ntileFn_13() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_14")
    @Test
    public void test_ntile_func_ntileFn_14() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_16")
    @Test
    public void test_ntile_func_ntileFn_16() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_18")
    @Test
    public void test_ntile_func_ntileFn_18() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_19")
    @Test
    public void test_ntile_func_ntileFn_19() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_1")
    @Test
    public void test_ntile_func_ntileFn_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_20")
    @Test
    public void test_ntile_func_ntileFn_20() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_21")
    @Test
    public void test_ntile_func_ntileFn_21() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_22")
    @Test
    public void test_ntile_func_ntileFn_22() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_23")
    @Test
    public void test_ntile_func_ntileFn_23() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_24")
    @Test
    public void test_ntile_func_ntileFn_24() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_25")
    @Test
    public void test_ntile_func_ntileFn_25() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_26")
    @Test
    public void test_ntile_func_ntileFn_26() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_28")
    @Test
    public void test_ntile_func_ntileFn_28() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_29")
    @Test
    public void test_ntile_func_ntileFn_29() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_2")
    @Test
    public void test_ntile_func_ntileFn_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_30")
    @Test
    public void test_ntile_func_ntileFn_30() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_31")
    @Test
    public void test_ntile_func_ntileFn_31() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_32")
    @Test
    public void test_ntile_func_ntileFn_32() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_35")
    @Test
    public void test_ntile_func_ntileFn_35() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_36")
    @Test
    public void test_ntile_func_ntileFn_36() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_37")
    @Test
    public void test_ntile_func_ntileFn_37() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_38")
    @Test
    public void test_ntile_func_ntileFn_38() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_39")
    @Test
    public void test_ntile_func_ntileFn_39() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_3")
    @Test
    public void test_ntile_func_ntileFn_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_40")
    @Test
    public void test_ntile_func_ntileFn_40() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_41")
    @Test
    public void test_ntile_func_ntileFn_41() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_42")
    @Test
    public void test_ntile_func_ntileFn_42() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_43")
    @Test
    public void test_ntile_func_ntileFn_43() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_44")
    @Test
    public void test_ntile_func_ntileFn_44() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_46")
    @Test
    public void test_ntile_func_ntileFn_46() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_4")
    @Test
    public void test_ntile_func_ntileFn_4() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_5")
    @Test
    public void test_ntile_func_ntileFn_5() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_6")
    @Test
    public void test_ntile_func_ntileFn_6() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_8")
    @Test
    public void test_ntile_func_ntileFn_8() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_9")
    @Test
    public void test_ntile_func_ntileFn_9() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="nestedAggs/cte_win_02")
    @Test
    public void test_nestedAggs_cte_win_02() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="nestedAggs/cte_win_03")
    @Test
    public void test_nestedAggs_cte_win_03() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="nestedAggs/cte_win_04")
    @Test
    public void test_nestedAggs_cte_win_04() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="nestedAggs/frmclause04")
    @Test
    public void test_nestedAggs_frmclause04() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="nestedAggs/frmclause05")
    @Test
    public void test_nestedAggs_frmclause05() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="nestedAggs/frmclause07")
    @Test
    public void test_nestedAggs_frmclause07() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="nestedAggs/frmclause08")
    @Test
    public void test_nestedAggs_frmclause08() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="nestedAggs/frmclause09")
    @Test
    public void test_nestedAggs_frmclause09() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="nestedAggs/frmclause10")
    @Test
    public void test_nestedAggs_frmclause10() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="nestedAggs/frmclause11")
    @Test
    public void test_nestedAggs_frmclause11() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="nestedAggs/frmclause13")
    @Test
    public void test_nestedAggs_frmclause13() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="nestedAggs/frmclause15")
    @Test
    public void test_nestedAggs_frmclause15() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="nestedAggs/frmclause17")
    @Test
    public void test_nestedAggs_frmclause17() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="nestedAggs/frmclause18")
    @Test
    public void test_nestedAggs_frmclause18() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="nestedAggs/woutOby_10")
    @Test
    public void test_nestedAggs_woutOby_10() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="nestedAggs/woutOby_11")
    @Test
    public void test_nestedAggs_woutOby_11() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="nestedAggs/woutOby_12")
    @Test
    public void test_nestedAggs_woutOby_12() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="nestedAggs/woutOby_13")
    @Test
    public void test_nestedAggs_woutOby_13() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="nestedAggs/woutOby_6")
    @Test
    public void test_nestedAggs_woutOby_6() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="nestedAggs/woutOby_7")
    @Test
    public void test_nestedAggs_woutOby_7() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="nestedAggs/woutOby_9")
    @Test
    public void test_nestedAggs_woutOby_9() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="nestedAggs/woutPrtnBy_6")
    @Test
    public void test_nestedAggs_woutPrtnBy_6() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="nestedAggs/woutPrtnBy_7")
    @Test
    public void test_nestedAggs_woutPrtnBy_7() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.ALLDATA_CSV)
    @DrillTest(value="aggregates/winFnQry_17")
    @Test
    public void test_aggregates_winFnQry_17() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.BIGINT_TIME_COMPARE)
    @DrillTest(value="lead_func/lead_Fn_27")
    @Test
    public void test_lead_func_lead_Fn_27() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.BIGINT_TO_DATE)
    @DrillTest(value="aggregates/winFnQry_15")
    @Test
    public void test_aggregates_winFnQry_15() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.BIGINT_TO_DATE)
    @DrillTest(value="aggregates/winFnQry_23")
    @Test
    public void test_aggregates_winFnQry_23() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.BIGINT_TO_DATE)
    @DrillTest(value="aggregates/winFnQry_32")
    @Test
    public void test_aggregates_winFnQry_32() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.BIGINT_TO_DATE)
    @DrillTest(value="aggregates/winFnQry_33")
    @Test
    public void test_aggregates_winFnQry_33() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.BIGINT_TO_DATE)
    @DrillTest(value="aggregates/winFnQry_34")
    @Test
    public void test_aggregates_winFnQry_34() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.BIGINT_TO_DATE)
    @DrillTest(value="aggregates/winFnQry_35")
    @Test
    public void test_aggregates_winFnQry_35() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.BIGINT_TO_DATE)
    @DrillTest(value="aggregates/winFnQry_36")
    @Test
    public void test_aggregates_winFnQry_36() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.BIGINT_TO_DATE)
    @DrillTest(value="aggregates/winFnQry_37")
    @Test
    public void test_aggregates_winFnQry_37() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.BIGINT_TO_DATE)
    @DrillTest(value="aggregates/winFnQry_38")
    @Test
    public void test_aggregates_winFnQry_38() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.BIGINT_TO_DATE)
    @DrillTest(value="aggregates/winFnQry_39")
    @Test
    public void test_aggregates_winFnQry_39() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.BIGINT_TO_DATE)
    @DrillTest(value="aggregates/winFnQry_40")
    @Test
    public void test_aggregates_winFnQry_40() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.BIGINT_TO_DATE)
    @DrillTest(value="aggregates/winFnQry_41")
    @Test
    public void test_aggregates_winFnQry_41() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.BIGINT_TO_DATE)
    @DrillTest(value="aggregates/winFnQry_42")
    @Test
    public void test_aggregates_winFnQry_42() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.BIGINT_TO_DATE)
    @DrillTest(value="aggregates/winFnQry_43")
    @Test
    public void test_aggregates_winFnQry_43() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.BIGINT_TO_DATE)
    @DrillTest(value="aggregates/winFnQry_44")
    @Test
    public void test_aggregates_winFnQry_44() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.BIGINT_TO_DATE)
    @DrillTest(value="aggregates/winFnQry_45")
    @Test
    public void test_aggregates_winFnQry_45() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.BIGINT_TO_DATE)
    @DrillTest(value="aggregates/winFnQry_6")
    @Test
    public void test_aggregates_winFnQry_6() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.BIGINT_TO_DATE)
    @DrillTest(value="aggregates/winFnQry_9")
    @Test
    public void test_aggregates_winFnQry_9() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/multiWin_5")
    @Test
    public void test_nestedAggs_multiWin_5() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="frameclause/subQueries/frmInSubQry_25")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_25() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.VIEWS_NOT_SUPPORTED)
    @DrillTest(value="nestedAggs/nstdWinView01")
    @Test
    public void test_nestedAggs_nstdWinView01() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="aggregates/winFnQry_63")
    @Test
    public void test_aggregates_winFnQry_63() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_83")
    @Test
    public void test_aggregates_winFnQry_83() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="frameclause/multipl_wnwds/mulwind_01")
    @Test
    public void test_frameclause_multipl_wnwds_mulwind_01() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="frameclause/multipl_wnwds/mulwind_06")
    @Test
    public void test_frameclause_multipl_wnwds_mulwind_06() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="frameclause/multipl_wnwds/mulwind_07")
    @Test
    public void test_frameclause_multipl_wnwds_mulwind_07() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_108")
    @Test
    public void test_lag_func_lag_Fn_108() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_109")
    @Test
    public void test_lag_func_lag_Fn_109() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_69")
    @Test
    public void test_lag_func_lag_Fn_69() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_103")
    @Test
    public void test_lead_func_lead_Fn_103() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_104")
    @Test
    public void test_lead_func_lead_Fn_104() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_69")
    @Test
    public void test_lead_func_lead_Fn_69() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="nestedAggs/multiWin_7")
    @Test
    public void test_nestedAggs_multiWin_7() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_3")
    @Test
    public void test_aggregates_aggOWnFn_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_4")
    @Test
    public void test_aggregates_aggOWnFn_4() {
        this.windowQueryTest();
    }

    @DrillTest(value="first_val/firstValFn_29")
    @Test
    public void test_first_val_firstValFn_29() {
        this.windowQueryTest();
    }

    @DrillTest(value="first_val/firstValFn_32")
    @Test
    public void test_first_val_firstValFn_32() {
        this.windowQueryTest();
    }

    @DrillTest(value="first_val/firstValFn_33")
    @Test
    public void test_first_val_firstValFn_33() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_int7")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_int7() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_9")
    @Test
    public void test_lag_func_lag_Fn_9() {
        this.windowQueryTest();
    }

    @DrillTest(value="last_val/lastValFn_29")
    @Test
    public void test_last_val_lastValFn_29() {
        this.windowQueryTest();
    }

    @DrillTest(value="last_val/lastValFn_34")
    @Test
    public void test_last_val_lastValFn_34() {
        this.windowQueryTest();
    }

    @DrillTest(value="last_val/lastValFn_35")
    @Test
    public void test_last_val_lastValFn_35() {
        this.windowQueryTest();
    }

    @DrillTest(value="last_val/lastValFn_38")
    @Test
    public void test_last_val_lastValFn_38() {
        this.windowQueryTest();
    }

    @DrillTest(value="last_val/lastValFn_39")
    @Test
    public void test_last_val_lastValFn_39() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.DISTINCT_AGGREGATE_NOT_SUPPORTED)
    @DrillTest(value="nestedAggs/emtyOvrCls_7")
    @Test
    public void test_nestedAggs_emtyOvrCls_7() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_33")
    @Test
    public void test_ntile_func_ntileFn_33() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_34")
    @Test
    public void test_ntile_func_ntileFn_34() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_47")
    @Test
    public void test_ntile_func_ntileFn_47() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_48")
    @Test
    public void test_ntile_func_ntileFn_48() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_49")
    @Test
    public void test_ntile_func_ntileFn_49() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_50")
    @Test
    public void test_ntile_func_ntileFn_50() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_51")
    @Test
    public void test_ntile_func_ntileFn_51() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_52")
    @Test
    public void test_ntile_func_ntileFn_52() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_53")
    @Test
    public void test_ntile_func_ntileFn_53() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_54")
    @Test
    public void test_ntile_func_ntileFn_54() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_55")
    @Test
    public void test_ntile_func_ntileFn_55() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_56")
    @Test
    public void test_ntile_func_ntileFn_56() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_57")
    @Test
    public void test_ntile_func_ntileFn_57() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_58")
    @Test
    public void test_ntile_func_ntileFn_58() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="aggregates/winFnQry_12")
    @Test
    public void test_aggregates_winFnQry_12() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="aggregates/winFnQry_13")
    @Test
    public void test_aggregates_winFnQry_13() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="aggregates/winFnQry_20")
    @Test
    public void test_aggregates_winFnQry_20() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="aggregates/winFnQry_21")
    @Test
    public void test_aggregates_winFnQry_21() {
        this.windowQueryTest();
    }

    @DrillTest(value="first_val/firstValFn_5")
    @Test
    public void test_first_val_firstValFn_5() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="frameclause/defaultFrame/RBUPACR_chr_1")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_chr_1() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="frameclause/defaultFrame/RBUPACR_chr_2")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_chr_2() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="frameclause/defaultFrame/RBUPACR_vchr_1")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_vchr_1() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="frameclause/defaultFrame/RBUPACR_vchr_2")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_vchr_2() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="frameclause/multipl_wnwds/max_mulwds")
    @Test
    public void test_frameclause_multipl_wnwds_max_mulwds() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="frameclause/multipl_wnwds/min_mulwds")
    @Test
    public void test_frameclause_multipl_wnwds_min_mulwds() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="frameclause/RBCRACR/RBCRACR_char_1")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_char_1() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="frameclause/RBCRACR/RBCRACR_char_2")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_char_2() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="frameclause/RBCRACR/RBCRACR_vchar_1")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_vchar_1() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="frameclause/RBCRACR/RBCRACR_vchar_2")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_vchar_2() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="frameclause/RBUPACR/RBUPACR_chr_1")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_chr_1() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="frameclause/RBUPACR/RBUPACR_chr_2")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_chr_2() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="frameclause/RBUPACR/RBUPACR_vchr_1")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_vchr_1() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="frameclause/RBUPACR/RBUPACR_vchr_2")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_vchr_2() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_char_1")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_char_1() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_char_2")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_char_2() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_vchar_1")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_vchar_1() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_vchar_2")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_vchar_2() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="frameclause/subQueries/frmInSubQry_22")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_22() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="frameclause/subQueries/frmInSubQry_23")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_23() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="frameclause/subQueries/frmInSubQry_24")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_24() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="frameclause/subQueries/frmInSubQry_41")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_41() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="frameclause/subQueries/frmInSubQry_42")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_42() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="frameclause/subQueries/frmInSubQry_43")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_43() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="frameclause/subQueries/frmInSubQry_44")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_44() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="frameclause/subQueries/frmInSubQry_45")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_45() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="frameclause/subQueries/frmInSubQry_46")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_46() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_82")
    @Test
    public void test_lag_func_lag_Fn_82() {
        this.windowQueryTest();
    }

    @DrillTest(value="last_val/lastValFn_5")
    @Test
    public void test_last_val_lastValFn_5() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="nestedAggs/basic_10")
    @Test
    public void test_nestedAggs_basic_10() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.AGGREGATION_NOT_SUPPORT_TYPE)
    @DrillTest(value="nestedAggs/cte_win_01")
    @Test
    public void test_nestedAggs_cte_win_01() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_7")
    @Test
    public void test_aggregates_winFnQry_7() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/testW_Nulls_10")
    @Test
    public void test_aggregates_testW_Nulls_10() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/testW_Nulls_11")
    @Test
    public void test_aggregates_testW_Nulls_11() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="aggregates/testW_Nulls_12")
    @Test
    public void test_aggregates_testW_Nulls_12() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="aggregates/testW_Nulls_13")
    @Test
    public void test_aggregates_testW_Nulls_13() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="aggregates/testW_Nulls_14")
    @Test
    public void test_aggregates_testW_Nulls_14() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="aggregates/testW_Nulls_15")
    @Test
    public void test_aggregates_testW_Nulls_15() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="aggregates/testW_Nulls_16")
    @Test
    public void test_aggregates_testW_Nulls_16() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="aggregates/testW_Nulls_17")
    @Test
    public void test_aggregates_testW_Nulls_17() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="aggregates/testW_Nulls_18")
    @Test
    public void test_aggregates_testW_Nulls_18() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="aggregates/testW_Nulls_19")
    @Test
    public void test_aggregates_testW_Nulls_19() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="aggregates/testW_Nulls_20")
    @Test
    public void test_aggregates_testW_Nulls_20() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="aggregates/testW_Nulls_21")
    @Test
    public void test_aggregates_testW_Nulls_21() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="aggregates/testW_Nulls_22")
    @Test
    public void test_aggregates_testW_Nulls_22() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="aggregates/testW_Nulls_23")
    @Test
    public void test_aggregates_testW_Nulls_23() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="aggregates/testW_Nulls_24")
    @Test
    public void test_aggregates_testW_Nulls_24() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="aggregates/testW_Nulls_25")
    @Test
    public void test_aggregates_testW_Nulls_25() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="aggregates/testW_Nulls_26")
    @Test
    public void test_aggregates_testW_Nulls_26() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="aggregates/testW_Nulls_27")
    @Test
    public void test_aggregates_testW_Nulls_27() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="aggregates/testW_Nulls_28")
    @Test
    public void test_aggregates_testW_Nulls_28() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="aggregates/testW_Nulls_29")
    @Test
    public void test_aggregates_testW_Nulls_29() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/testW_Nulls_2")
    @Test
    public void test_aggregates_testW_Nulls_2() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="aggregates/testW_Nulls_30")
    @Test
    public void test_aggregates_testW_Nulls_30() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="aggregates/testW_Nulls_31")
    @Test
    public void test_aggregates_testW_Nulls_31() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="aggregates/testW_Nulls_32")
    @Test
    public void test_aggregates_testW_Nulls_32() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="aggregates/testW_Nulls_33")
    @Test
    public void test_aggregates_testW_Nulls_33() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="aggregates/testW_Nulls_34")
    @Test
    public void test_aggregates_testW_Nulls_34() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="aggregates/testW_Nulls_35")
    @Test
    public void test_aggregates_testW_Nulls_35() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="aggregates/testW_Nulls_36")
    @Test
    public void test_aggregates_testW_Nulls_36() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="aggregates/testW_Nulls_37")
    @Test
    public void test_aggregates_testW_Nulls_37() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="aggregates/testW_Nulls_38")
    @Test
    public void test_aggregates_testW_Nulls_38() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="aggregates/testW_Nulls_39")
    @Test
    public void test_aggregates_testW_Nulls_39() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/testW_Nulls_3")
    @Test
    public void test_aggregates_testW_Nulls_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/testW_Nulls_4")
    @Test
    public void test_aggregates_testW_Nulls_4() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/testW_Nulls_5")
    @Test
    public void test_aggregates_testW_Nulls_5() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/testW_Nulls_6")
    @Test
    public void test_aggregates_testW_Nulls_6() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/testW_Nulls_7")
    @Test
    public void test_aggregates_testW_Nulls_7() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/testW_Nulls_8")
    @Test
    public void test_aggregates_testW_Nulls_8() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/testW_Nulls_9")
    @Test
    public void test_aggregates_testW_Nulls_9() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_61")
    @Test
    public void test_aggregates_winFnQry_61() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_62")
    @Test
    public void test_aggregates_winFnQry_62() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_64")
    @Test
    public void test_aggregates_winFnQry_64() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_65")
    @Test
    public void test_aggregates_winFnQry_65() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="aggregates/winFnQry_66")
    @Test
    public void test_aggregates_winFnQry_66() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="aggregates/winFnQry_67")
    @Test
    public void test_aggregates_winFnQry_67() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="aggregates/winFnQry_68")
    @Test
    public void test_aggregates_winFnQry_68() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="aggregates/winFnQry_69")
    @Test
    public void test_aggregates_winFnQry_69() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="aggregates/winFnQry_70")
    @Test
    public void test_aggregates_winFnQry_70() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="aggregates/winFnQry_71")
    @Test
    public void test_aggregates_winFnQry_71() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="aggregates/winFnQry_72")
    @Test
    public void test_aggregates_winFnQry_72() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="aggregates/winFnQry_73")
    @Test
    public void test_aggregates_winFnQry_73() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="aggregates/winFnQry_74")
    @Test
    public void test_aggregates_winFnQry_74() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="aggregates/winFnQry_75")
    @Test
    public void test_aggregates_winFnQry_75() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_76")
    @Test
    public void test_aggregates_winFnQry_76() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_77")
    @Test
    public void test_aggregates_winFnQry_77() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_78")
    @Test
    public void test_aggregates_winFnQry_78() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_79")
    @Test
    public void test_aggregates_winFnQry_79() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_80")
    @Test
    public void test_aggregates_winFnQry_80() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_81")
    @Test
    public void test_aggregates_winFnQry_81() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_82")
    @Test
    public void test_aggregates_winFnQry_82() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_10")
    @Test
    public void test_lag_func_lag_Fn_10() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_11")
    @Test
    public void test_lag_func_lag_Fn_11() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_12")
    @Test
    public void test_lag_func_lag_Fn_12() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_13")
    @Test
    public void test_lag_func_lag_Fn_13() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_14")
    @Test
    public void test_lag_func_lag_Fn_14() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_15")
    @Test
    public void test_lag_func_lag_Fn_15() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_16")
    @Test
    public void test_lag_func_lag_Fn_16() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_17")
    @Test
    public void test_lag_func_lag_Fn_17() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_18")
    @Test
    public void test_lag_func_lag_Fn_18() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.UNSUPPORTED_NULL_ORDERING)
    @DrillTest(value="lag_func/lag_Fn_19")
    @Test
    public void test_lag_func_lag_Fn_19() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.UNSUPPORTED_NULL_ORDERING)
    @DrillTest(value="lag_func/lag_Fn_20")
    @Test
    public void test_lag_func_lag_Fn_20() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.UNSUPPORTED_NULL_ORDERING)
    @DrillTest(value="lag_func/lag_Fn_21")
    @Test
    public void test_lag_func_lag_Fn_21() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.UNSUPPORTED_NULL_ORDERING)
    @DrillTest(value="lag_func/lag_Fn_22")
    @Test
    public void test_lag_func_lag_Fn_22() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="lag_func/lag_Fn_23")
    @Test
    public void test_lag_func_lag_Fn_23() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.UNSUPPORTED_NULL_ORDERING)
    @DrillTest(value="lag_func/lag_Fn_24")
    @Test
    public void test_lag_func_lag_Fn_24() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.UNSUPPORTED_NULL_ORDERING)
    @DrillTest(value="lag_func/lag_Fn_25")
    @Test
    public void test_lag_func_lag_Fn_25() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.UNSUPPORTED_NULL_ORDERING)
    @DrillTest(value="lag_func/lag_Fn_26")
    @Test
    public void test_lag_func_lag_Fn_26() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.UNSUPPORTED_NULL_ORDERING)
    @DrillTest(value="lag_func/lag_Fn_54")
    @Test
    public void test_lag_func_lag_Fn_54() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_64")
    @Test
    public void test_lag_func_lag_Fn_64() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_65")
    @Test
    public void test_lag_func_lag_Fn_65() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_66")
    @Test
    public void test_lag_func_lag_Fn_66() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_67")
    @Test
    public void test_lag_func_lag_Fn_67() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.UNSUPPORTED_NULL_ORDERING)
    @DrillTest(value="lag_func/lag_Fn_68")
    @Test
    public void test_lag_func_lag_Fn_68() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_71")
    @Test
    public void test_lag_func_lag_Fn_71() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.UNSUPPORTED_NULL_ORDERING)
    @DrillTest(value="lag_func/lag_Fn_72")
    @Test
    public void test_lag_func_lag_Fn_72() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_10")
    @Test
    public void test_lead_func_lead_Fn_10() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_11")
    @Test
    public void test_lead_func_lead_Fn_11() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_12")
    @Test
    public void test_lead_func_lead_Fn_12() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_13")
    @Test
    public void test_lead_func_lead_Fn_13() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_14")
    @Test
    public void test_lead_func_lead_Fn_14() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_15")
    @Test
    public void test_lead_func_lead_Fn_15() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_16")
    @Test
    public void test_lead_func_lead_Fn_16() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_17")
    @Test
    public void test_lead_func_lead_Fn_17() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_18")
    @Test
    public void test_lead_func_lead_Fn_18() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.UNSUPPORTED_NULL_ORDERING)
    @DrillTest(value="lead_func/lead_Fn_19")
    @Test
    public void test_lead_func_lead_Fn_19() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="lead_func/lead_Fn_20")
    @Test
    public void test_lead_func_lead_Fn_20() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.UNSUPPORTED_NULL_ORDERING)
    @DrillTest(value="lead_func/lead_Fn_21")
    @Test
    public void test_lead_func_lead_Fn_21() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.UNSUPPORTED_NULL_ORDERING)
    @DrillTest(value="lead_func/lead_Fn_22")
    @Test
    public void test_lead_func_lead_Fn_22() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="lead_func/lead_Fn_23")
    @Test
    public void test_lead_func_lead_Fn_23() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="lead_func/lead_Fn_24")
    @Test
    public void test_lead_func_lead_Fn_24() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.NULLS_FIRST_LAST)
    @DrillTest(value="lead_func/lead_Fn_25")
    @Test
    public void test_lead_func_lead_Fn_25() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_64")
    @Test
    public void test_lead_func_lead_Fn_64() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_65")
    @Test
    public void test_lead_func_lead_Fn_65() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_66")
    @Test
    public void test_lead_func_lead_Fn_66() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_67")
    @Test
    public void test_lead_func_lead_Fn_67() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.UNSUPPORTED_NULL_ORDERING)
    @DrillTest(value="lead_func/lead_Fn_68")
    @Test
    public void test_lead_func_lead_Fn_68() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_71")
    @Test
    public void test_lead_func_lead_Fn_71() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.UNSUPPORTED_NULL_ORDERING)
    @DrillTest(value="lead_func/lead_Fn_72")
    @Test
    public void test_lead_func_lead_Fn_72() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/testW_Nulls_1")
    @Test
    public void test_aggregates_testW_Nulls_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="first_val/firstValFn_18")
    @Test
    public void test_first_val_firstValFn_18() {
        this.windowQueryTest();
    }

    @DrillTest(value="first_val/firstValFn_19")
    @Test
    public void test_first_val_firstValFn_19() {
        this.windowQueryTest();
    }

    @DrillTest(value="first_val/firstValFn_21")
    @Test
    public void test_first_val_firstValFn_21() {
        this.windowQueryTest();
    }

    @DrillTest(value="first_val/firstValFn_22")
    @Test
    public void test_first_val_firstValFn_22() {
        this.windowQueryTest();
    }

    @DrillTest(value="first_val/firstValFn_24")
    @Test
    public void test_first_val_firstValFn_24() {
        this.windowQueryTest();
    }

    @DrillTest(value="first_val/firstValFn_25")
    @Test
    public void test_first_val_firstValFn_25() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_17")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_17() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_20")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_20() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_26")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_26() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_27")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_27() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_28")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_28() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_30")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_30() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_47")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_47() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_48")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_48() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_49")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_49() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_100")
    @Test
    public void test_lag_func_lag_Fn_100() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_102")
    @Test
    public void test_lag_func_lag_Fn_102() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_103")
    @Test
    public void test_lag_func_lag_Fn_103() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_41")
    @Test
    public void test_lag_func_lag_Fn_41() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_42")
    @Test
    public void test_lag_func_lag_Fn_42() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_45")
    @Test
    public void test_lag_func_lag_Fn_45() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_63")
    @Test
    public void test_lag_func_lag_Fn_63() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_96")
    @Test
    public void test_lag_func_lag_Fn_96() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_97")
    @Test
    public void test_lag_func_lag_Fn_97() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_99")
    @Test
    public void test_lag_func_lag_Fn_99() {
        this.windowQueryTest();
    }

    @DrillTest(value="last_val/lastValFn_18")
    @Test
    public void test_last_val_lastValFn_18() {
        this.windowQueryTest();
    }

    @DrillTest(value="last_val/lastValFn_19")
    @Test
    public void test_last_val_lastValFn_19() {
        this.windowQueryTest();
    }

    @DrillTest(value="last_val/lastValFn_21")
    @Test
    public void test_last_val_lastValFn_21() {
        this.windowQueryTest();
    }

    @DrillTest(value="last_val/lastValFn_22")
    @Test
    public void test_last_val_lastValFn_22() {
        this.windowQueryTest();
    }

    @DrillTest(value="last_val/lastValFn_24")
    @Test
    public void test_last_val_lastValFn_24() {
        this.windowQueryTest();
    }

    @DrillTest(value="last_val/lastValFn_25")
    @Test
    public void test_last_val_lastValFn_25() {
        this.windowQueryTest();
    }

    @DrillTest(value="last_val/lastValFn_33")
    @Test
    public void test_last_val_lastValFn_33() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_36")
    @Test
    public void test_lead_func_lead_Fn_36() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_45")
    @Test
    public void test_lead_func_lead_Fn_45() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_91")
    @Test
    public void test_lead_func_lead_Fn_91() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_92")
    @Test
    public void test_lead_func_lead_Fn_92() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_94")
    @Test
    public void test_lead_func_lead_Fn_94() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_95")
    @Test
    public void test_lead_func_lead_Fn_95() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_97")
    @Test
    public void test_lead_func_lead_Fn_97() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_98")
    @Test
    public void test_lead_func_lead_Fn_98() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_10")
    @Test
    public void test_aggregates_aggOWnFn_10() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_12")
    @Test
    public void test_aggregates_aggOWnFn_12() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_14")
    @Test
    public void test_aggregates_aggOWnFn_14() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_15")
    @Test
    public void test_aggregates_aggOWnFn_15() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_17")
    @Test
    public void test_aggregates_aggOWnFn_17() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_18")
    @Test
    public void test_aggregates_aggOWnFn_18() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_19")
    @Test
    public void test_aggregates_aggOWnFn_19() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_22")
    @Test
    public void test_aggregates_aggOWnFn_22() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_23")
    @Test
    public void test_aggregates_aggOWnFn_23() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_39")
    @Test
    public void test_aggregates_aggOWnFn_39() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_40")
    @Test
    public void test_aggregates_aggOWnFn_40() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/aggOWnFn_50")
    @Test
    public void test_aggregates_aggOWnFn_50() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.LONG_CASTING)
    @DrillTest(value="aggregates/winFnQry_10")
    @Test
    public void test_aggregates_winFnQry_10() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_16")
    @Test
    public void test_aggregates_winFnQry_16() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.LONG_CASTING)
    @DrillTest(value="aggregates/winFnQry_18")
    @Test
    public void test_aggregates_winFnQry_18() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_1")
    @Test
    public void test_aggregates_winFnQry_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_26")
    @Test
    public void test_aggregates_winFnQry_26() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_28")
    @Test
    public void test_aggregates_winFnQry_28() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_2")
    @Test
    public void test_aggregates_winFnQry_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_31")
    @Test
    public void test_aggregates_winFnQry_31() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_3")
    @Test
    public void test_aggregates_winFnQry_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_46")
    @Test
    public void test_aggregates_winFnQry_46() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_47")
    @Test
    public void test_aggregates_winFnQry_47() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_48")
    @Test
    public void test_aggregates_winFnQry_48() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_49")
    @Test
    public void test_aggregates_winFnQry_49() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_4")
    @Test
    public void test_aggregates_winFnQry_4() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_50")
    @Test
    public void test_aggregates_winFnQry_50() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_51")
    @Test
    public void test_aggregates_winFnQry_51() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_52")
    @Test
    public void test_aggregates_winFnQry_52() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_53")
    @Test
    public void test_aggregates_winFnQry_53() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_54")
    @Test
    public void test_aggregates_winFnQry_54() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_55")
    @Test
    public void test_aggregates_winFnQry_55() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_5")
    @Test
    public void test_aggregates_winFnQry_5() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_84")
    @Test
    public void test_aggregates_winFnQry_84() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_85")
    @Test
    public void test_aggregates_winFnQry_85() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/winFnQry_8")
    @Test
    public void test_aggregates_winFnQry_8() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/wo_OrdrBy_17")
    @Test
    public void test_aggregates_wo_OrdrBy_17() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/wo_OrdrBy_18")
    @Test
    public void test_aggregates_wo_OrdrBy_18() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/wo_OrdrBy_19")
    @Test
    public void test_aggregates_wo_OrdrBy_19() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/wo_OrdrBy_20")
    @Test
    public void test_aggregates_wo_OrdrBy_20() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/wo_OrdrBy_21")
    @Test
    public void test_aggregates_wo_OrdrBy_21() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/wo_OrdrBy_22")
    @Test
    public void test_aggregates_wo_OrdrBy_22() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/wo_OrdrBy_23")
    @Test
    public void test_aggregates_wo_OrdrBy_23() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/wo_OrdrBy_24")
    @Test
    public void test_aggregates_wo_OrdrBy_24() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/wo_OrdrBy_25")
    @Test
    public void test_aggregates_wo_OrdrBy_25() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/wo_OrdrBy_26")
    @Test
    public void test_aggregates_wo_OrdrBy_26() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_10")
    @Test
    public void test_aggregates_woPrtnBy_10() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_12")
    @Test
    public void test_aggregates_woPrtnBy_12() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_13")
    @Test
    public void test_aggregates_woPrtnBy_13() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_14")
    @Test
    public void test_aggregates_woPrtnBy_14() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_15")
    @Test
    public void test_aggregates_woPrtnBy_15() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_17")
    @Test
    public void test_aggregates_woPrtnBy_17() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_18")
    @Test
    public void test_aggregates_woPrtnBy_18() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_19")
    @Test
    public void test_aggregates_woPrtnBy_19() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_20")
    @Test
    public void test_aggregates_woPrtnBy_20() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_25")
    @Test
    public void test_aggregates_woPrtnBy_25() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_3")
    @Test
    public void test_aggregates_woPrtnBy_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_4")
    @Test
    public void test_aggregates_woPrtnBy_4() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_5")
    @Test
    public void test_aggregates_woPrtnBy_5() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_6")
    @Test
    public void test_aggregates_woPrtnBy_6() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_7")
    @Test
    public void test_aggregates_woPrtnBy_7() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_8")
    @Test
    public void test_aggregates_woPrtnBy_8() {
        this.windowQueryTest();
    }

    @DrillTest(value="aggregates/woPrtnBy_9")
    @Test
    public void test_aggregates_woPrtnBy_9() {
        this.windowQueryTest();
    }

    @DrillTest(value="first_val/firstValFn_17")
    @Test
    public void test_first_val_firstValFn_17() {
        this.windowQueryTest();
    }

    @DrillTest(value="first_val/firstValFn_23")
    @Test
    public void test_first_val_firstValFn_23() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_bgint_1")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_bgint_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_bgint_2")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_bgint_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_bgint_3")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_bgint_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_bgint_4")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_bgint_4() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_bgint_6")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_bgint_6() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_bgint_7")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_bgint_7() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_chr_3")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_chr_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_chr_5")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_chr_5() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_dbl_1")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_dbl_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_dbl_2")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_dbl_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_dbl_3")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_dbl_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_dbl_6")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_dbl_6() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_dbl_7")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_dbl_7() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_dt_1")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_dt_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_dt_2")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_dt_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_dt_4")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_dt_4() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_dt_5")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_dt_5() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_int10")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_int10() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_int13")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_int13() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_int14")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_int14() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_int8")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_int8() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_int9")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_int9() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_vchr_3")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_vchr_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/defaultFrame/RBUPACR_vchr_5")
    @Test
    public void test_frameclause_defaultFrame_RBUPACR_vchr_5() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/multipl_wnwds/avg_mulwds")
    @Test
    public void test_frameclause_multipl_wnwds_avg_mulwds() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/multipl_wnwds/count_mulwds")
    @Test
    public void test_frameclause_multipl_wnwds_count_mulwds() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/multipl_wnwds/fval_mulwds")
    @Test
    public void test_frameclause_multipl_wnwds_fval_mulwds() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/multipl_wnwds/lval_mulwds")
    @Test
    public void test_frameclause_multipl_wnwds_lval_mulwds() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/multipl_wnwds/mulwind_08")
    @Test
    public void test_frameclause_multipl_wnwds_mulwind_08() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/multipl_wnwds/mulwind_09")
    @Test
    public void test_frameclause_multipl_wnwds_mulwind_09() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/multipl_wnwds/sum_mulwds")
    @Test
    public void test_frameclause_multipl_wnwds_sum_mulwds() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_bgint_6")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_bgint_6() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_bgint_7")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_bgint_7() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_char_3")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_char_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_char_4")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_char_4() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_char_5")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_char_5() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_dbl_6")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_dbl_6() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_dbl_7")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_dbl_7() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_dt_1")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_dt_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_dt_2")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_dt_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_dt_4")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_dt_4() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_dt_5")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_dt_5() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_int_13")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_int_13() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_int_14")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_int_14() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_int_6")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_int_6() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_int_7")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_int_7() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_vchar_3")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_vchar_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_vchar_4")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_vchar_4() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBCRACR/RBCRACR_vchar_5")
    @Test
    public void test_frameclause_RBCRACR_RBCRACR_vchar_5() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_bgint_1")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_bgint_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_bgint_2")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_bgint_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_bgint_3")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_bgint_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_bgint_4")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_bgint_4() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_bgint_6")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_bgint_6() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_bgint_7")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_bgint_7() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_chr_3")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_chr_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_chr_5")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_chr_5() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_dbl_1")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_dbl_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_dbl_2")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_dbl_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_dbl_3")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_dbl_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_dbl_6")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_dbl_6() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_dbl_7")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_dbl_7() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_int10")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_int10() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_int13")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_int13() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_int14")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_int14() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_vchr_3")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_vchr_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_vchr_5")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_vchr_5() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_bgint_4")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_bgint_4() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_bgint_6")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_bgint_6() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_char_3")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_char_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_dbl_6")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_dbl_6() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_dbl_7")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_dbl_7() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_dt_1")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_dt_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_dt_2")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_dt_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_dt_4")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_dt_4() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_dt_5")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_dt_5() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_int_13")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_int_13() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPAUF/RBUPAUF_vchar_3")
    @Test
    public void test_frameclause_RBUPAUF_RBUPAUF_vchar_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_53")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_53() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_54")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_54() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_55")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_55() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_57")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_57() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_58")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_58() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_59")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_59() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_60")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_60() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_61")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_61() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_62")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_62() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_63")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_63() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/subQueries/frmInSubQry_64")
    @Test
    public void test_frameclause_subQueries_frmInSubQry_64() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_101")
    @Test
    public void test_lag_func_lag_Fn_101() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_6")
    @Test
    public void test_lag_func_lag_Fn_6() {
        this.windowQueryTest();
    }

    @DrillTest(value="last_val/lastValFn_10")
    @Test
    public void test_last_val_lastValFn_10() {
        this.windowQueryTest();
    }

    @DrillTest(value="last_val/lastValFn_11")
    @Test
    public void test_last_val_lastValFn_11() {
        this.windowQueryTest();
    }

    @DrillTest(value="last_val/lastValFn_12")
    @Test
    public void test_last_val_lastValFn_12() {
        this.windowQueryTest();
    }

    @DrillTest(value="last_val/lastValFn_13")
    @Test
    public void test_last_val_lastValFn_13() {
        this.windowQueryTest();
    }

    @DrillTest(value="last_val/lastValFn_14")
    @Test
    public void test_last_val_lastValFn_14() {
        this.windowQueryTest();
    }

    @DrillTest(value="last_val/lastValFn_15")
    @Test
    public void test_last_val_lastValFn_15() {
        this.windowQueryTest();
    }

    @DrillTest(value="last_val/lastValFn_16")
    @Test
    public void test_last_val_lastValFn_16() {
        this.windowQueryTest();
    }

    @DrillTest(value="last_val/lastValFn_17")
    @Test
    public void test_last_val_lastValFn_17() {
        this.windowQueryTest();
    }

    @DrillTest(value="last_val/lastValFn_1")
    @Test
    public void test_last_val_lastValFn_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="last_val/lastValFn_20")
    @Test
    public void test_last_val_lastValFn_20() {
        this.windowQueryTest();
    }

    @DrillTest(value="last_val/lastValFn_23")
    @Test
    public void test_last_val_lastValFn_23() {
        this.windowQueryTest();
    }

    @DrillTest(value="last_val/lastValFn_2")
    @Test
    public void test_last_val_lastValFn_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="last_val/lastValFn_32")
    @Test
    public void test_last_val_lastValFn_32() {
        this.windowQueryTest();
    }

    @DrillTest(value="last_val/lastValFn_36")
    @Test
    public void test_last_val_lastValFn_36() {
        this.windowQueryTest();
    }

    @DrillTest(value="last_val/lastValFn_3")
    @Test
    public void test_last_val_lastValFn_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="last_val/lastValFn_4")
    @Test
    public void test_last_val_lastValFn_4() {
        this.windowQueryTest();
    }

    @DrillTest(value="last_val/lastValFn_6")
    @Test
    public void test_last_val_lastValFn_6() {
        this.windowQueryTest();
    }

    @DrillTest(value="last_val/lastValFn_7")
    @Test
    public void test_last_val_lastValFn_7() {
        this.windowQueryTest();
    }

    @DrillTest(value="last_val/lastValFn_8")
    @Test
    public void test_last_val_lastValFn_8() {
        this.windowQueryTest();
    }

    @DrillTest(value="last_val/lastValFn_9")
    @Test
    public void test_last_val_lastValFn_9() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_33")
    @Test
    public void test_lead_func_lead_Fn_33() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_42")
    @Test
    public void test_lead_func_lead_Fn_42() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_51")
    @Test
    public void test_lead_func_lead_Fn_51() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_54")
    @Test
    public void test_lead_func_lead_Fn_54() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_60")
    @Test
    public void test_lead_func_lead_Fn_60() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_63")
    @Test
    public void test_lead_func_lead_Fn_63() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_6")
    @Test
    public void test_lead_func_lead_Fn_6() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_77")
    @Test
    public void test_lead_func_lead_Fn_77() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_90")
    @Test
    public void test_lead_func_lead_Fn_90() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_96")
    @Test
    public void test_lead_func_lead_Fn_96() {
        this.windowQueryTest();
    }

    @DrillTest(value="lead_func/lead_Fn_9")
    @Test
    public void test_lead_func_lead_Fn_9() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.RESULT_MISMATCH)
    @DrillTest(value="nestedAggs/basic_3")
    @Test
    public void test_nestedAggs_basic_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/basic_5")
    @Test
    public void test_nestedAggs_basic_5() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/basic_7")
    @Test
    public void test_nestedAggs_basic_7() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/cte_win_05")
    @Test
    public void test_nestedAggs_cte_win_05() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/emtyOvrCls_13")
    @Test
    public void test_nestedAggs_emtyOvrCls_13() {
        this.windowQueryTest();
    }

    @NotYetSupported(value=NotYetSupported.Modes.DISTINCT_AGGREGATE_NOT_SUPPORTED)
    @DrillTest(value="nestedAggs/emtyOvrCls_8")
    @Test
    public void test_nestedAggs_emtyOvrCls_8() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/nstdagg24")
    @Test
    public void test_nestedAggs_nstdagg24() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/woutPrtnBy_1")
    @Test
    public void test_nestedAggs_woutPrtnBy_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/woutPrtnBy_2")
    @Test
    public void test_nestedAggs_woutPrtnBy_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/woutPrtnBy_3")
    @Test
    public void test_nestedAggs_woutPrtnBy_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/woutPrtnBy_4")
    @Test
    public void test_nestedAggs_woutPrtnBy_4() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/woutPrtnBy_5")
    @Test
    public void test_nestedAggs_woutPrtnBy_5() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_15")
    @Test
    public void test_ntile_func_ntileFn_15() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_17")
    @Test
    public void test_ntile_func_ntileFn_17() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_27")
    @Test
    public void test_ntile_func_ntileFn_27() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_45")
    @Test
    public void test_ntile_func_ntileFn_45() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_59")
    @Test
    public void test_ntile_func_ntileFn_59() {
        this.windowQueryTest();
    }

    @DrillTest(value="ntile_func/ntileFn_7")
    @Test
    public void test_ntile_func_ntileFn_7() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/multipl_wnwds/rnkNoFrm01")
    @Test
    public void test_frameclause_multipl_wnwds_rnkNoFrm01() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/multipl_wnwds/rnkNoFrm02")
    @Test
    public void test_frameclause_multipl_wnwds_rnkNoFrm02() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/multipl_wnwds/rnkNoFrm03")
    @Test
    public void test_frameclause_multipl_wnwds_rnkNoFrm03() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/multipl_wnwds/rnkNoFrm04")
    @Test
    public void test_frameclause_multipl_wnwds_rnkNoFrm04() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/multipl_wnwds/rnkNoFrm05")
    @Test
    public void test_frameclause_multipl_wnwds_rnkNoFrm05() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/multipl_wnwds/rnkNoFrm06")
    @Test
    public void test_frameclause_multipl_wnwds_rnkNoFrm06() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_dt_1")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_dt_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_dt_2")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_dt_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_dt_4")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_dt_4() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_dt_5")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_dt_5() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_int7")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_int7() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_int8")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_int8() {
        this.windowQueryTest();
    }

    @DrillTest(value="frameclause/RBUPACR/RBUPACR_int9")
    @Test
    public void test_frameclause_RBUPACR_RBUPACR_int9() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_33")
    @Test
    public void test_lag_func_lag_Fn_33() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_51")
    @Test
    public void test_lag_func_lag_Fn_51() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_60")
    @Test
    public void test_lag_func_lag_Fn_60() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_77")
    @Test
    public void test_lag_func_lag_Fn_77() {
        this.windowQueryTest();
    }

    @DrillTest(value="lag_func/lag_Fn_95")
    @Test
    public void test_lag_func_lag_Fn_95() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/frmclause03")
    @Test
    public void test_nestedAggs_frmclause03() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/frmclause12")
    @Test
    public void test_nestedAggs_frmclause12() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/frmclause16")
    @Test
    public void test_nestedAggs_frmclause16() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/multiWin_6")
    @Test
    public void test_nestedAggs_multiWin_6() {
        this.windowQueryTest();
    }

    @DrillTest(value="nestedAggs/multiWin_8")
    @Test
    public void test_nestedAggs_multiWin_8() {
        this.windowQueryTest();
    }

    @DrillTest(value="druid_queries/same_window_across_columns/wikipedia_query_1")
    @Test
    public void test_same_window_wikipedia_query_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="druid_queries/same_window_across_columns/wikipedia_query_1_named_window")
    @Test
    public void test_same_window_wikipedia_query_1_named_window() {
        this.windowQueryTest();
    }

    @DrillTest(value="druid_queries/multiple_windows/wikipedia_query_1")
    @Test
    public void test_multiple_windows_wikipedia_query_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="druid_queries/multiple_windows/wikipedia_query_1_named_windows")
    @Test
    public void test_multiple_windows_wikipedia_query_1_named_windows() {
        this.windowQueryTest();
    }

    @DrillTest(value="druid_queries/shuffle_columns/wikipedia_query_1")
    @Test
    public void test_shuffle_columns_wikipedia_query_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="druid_queries/shuffle_columns/wikipedia_query_1_shuffle_1")
    @Test
    public void test_shuffle_columns_wikipedia_query_1_shuffle_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="druid_queries/shuffle_columns/wikipedia_query_2")
    @Test
    public void test_shuffle_columns_wikipedia_query_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="druid_queries/shuffle_columns/wikipedia_query_2_shuffle_1")
    @Test
    public void test_shuffle_columns_wikipedia_query_2_shuffle_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="druid_queries/partition_by_multiple_columns/wikipedia_query_1")
    @Test
    public void test_partition_by_multiple_columns_wikipedia_query_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="druid_queries/partition_by_multiple_columns/wikipedia_query_2")
    @Test
    public void test_partition_by_multiple_columns_wikipedia_query_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="druid_queries/empty_over_clause/single_empty_over_1")
    @Test
    public void test_empty_over_single_empty_over_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="druid_queries/empty_over_clause/single_empty_over_2")
    @Test
    public void test_empty_over_single_empty_over_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="druid_queries/empty_over_clause/single_empty_over_3")
    @Test
    public void test_empty_over_single_empty_over_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="druid_queries/empty_over_clause/multiple_empty_over_1")
    @Test
    public void test_empty_over_multiple_empty_over_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="druid_queries/over_clause_only_sorting/single_over_1")
    @Test
    public void test_over_clause_with_only_sorting_single_over_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="druid_queries/over_clause_only_sorting/single_over_2")
    @Test
    public void test_over_clause_with_only_sorting_single_over_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="druid_queries/over_clause_only_sorting/single_over_multiple_sort_columns")
    @Test
    public void test_over_clause_with_only_sorting_single_over_multiple_sort_columns() {
        this.windowQueryTest();
    }

    @DrillTest(value="druid_queries/over_clause_only_sorting/multiple_over_same_sort_column")
    @Test
    public void test_over_clause_with_only_sorting_multiple_over_same_sort_column() {
        this.windowQueryTest();
    }

    @DrillTest(value="druid_queries/over_clause_only_sorting/multiple_over_different_sort_column")
    @Test
    public void test_over_clause_with_only_sorting_multiple_over_different_sort_column() {
        this.windowQueryTest();
    }

    @DrillTest(value="druid_queries/over_clause_only_sorting/multiple_over_multiple_sort_columns_1")
    @Test
    public void test_over_clause_with_only_sorting_multiple_over_multiple_sort_columns_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="druid_queries/over_clause_only_sorting/multiple_over_multiple_sort_columns_2")
    @Test
    public void test_over_clause_with_only_sorting_multiple_over_multiple_sort_columns_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="druid_queries/over_clause_only_partitioning/single_over_1")
    @Test
    public void test_over_clause_with_only_partitioning_single_over_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="druid_queries/over_clause_only_partitioning/single_over_2")
    @Test
    public void test_over_clause_with_only_partitioning_single_over_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="druid_queries/over_clause_only_partitioning/single_over_multiple_partition_columns")
    @Test
    public void test_over_clause_with_only_partitioning_single_over_multiple_partition_columns() {
        this.windowQueryTest();
    }

    @DrillTest(value="druid_queries/over_clause_only_partitioning/multiple_over_same_partition_column")
    @Test
    public void test_over_clause_with_only_partitioning_multiple_over_same_partition_column() {
        this.windowQueryTest();
    }

    @DrillTest(value="druid_queries/over_clause_only_partitioning/multiple_over_different_partition_column")
    @Test
    public void test_over_clause_with_only_partitioning_multiple_over_different_partition_column() {
        this.windowQueryTest();
    }

    @DrillTest(value="druid_queries/over_clause_only_partitioning/multiple_over_multiple_partition_columns_1")
    @Test
    public void test_over_clause_with_only_partitioning_multiple_over_multiple_partition_columns_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="druid_queries/over_clause_only_partitioning/multiple_over_multiple_partition_columns_2")
    @Test
    public void test_over_clause_with_only_partitioning_multiple_over_multiple_partition_columns_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="druid_queries/empty_and_non_empty_over/wikipedia_query_1")
    @Test
    public void test_empty_and_non_empty_over_wikipedia_query_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="druid_queries/empty_and_non_empty_over/wikipedia_query_2")
    @Test
    public void test_empty_and_non_empty_over_wikipedia_query_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="druid_queries/empty_and_non_empty_over/wikipedia_query_3")
    @Test
    public void test_empty_and_non_empty_over_wikipedia_query_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="druid_queries/partition_by_array/wikipedia_query_1")
    @Test
    public void test_partition_by_array_wikipedia_query_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="druid_queries/partition_by_array/wikipedia_query_2")
    @Test
    public void test_partition_by_array_wikipedia_query_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="druid_queries/partition_by_array/wikipedia_query_3")
    @Test
    public void test_partition_by_array_wikipedia_query_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="druid_queries/array_concat_agg/single_partition_column_1")
    @Test
    public void test_array_concat_agg_with_single_partition_column_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="druid_queries/array_concat_agg/single_partition_column_2")
    @Test
    public void test_array_concat_agg_with_single_partition_column_2() {
        this.windowQueryTest();
    }

    @DrillTest(value="druid_queries/array_concat_agg/single_partition_column_3")
    @Test
    public void test_array_concat_agg_with_single_partition_column_3() {
        this.windowQueryTest();
    }

    @DrillTest(value="druid_queries/array_concat_agg/multiple_partition_columns_1")
    @Test
    public void test_array_concat_agg_with_multiple_partition_columns_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="druid_queries/array_concat_agg/only_sorting_column_1")
    @Test
    public void test_array_concat_agg_with_only_sorting_column_1() {
        this.windowQueryTest();
    }

    @DrillTest(value="druid_queries/array_concat_agg/empty_over_1")
    @Test
    public void test_array_concat_agg_with_empty_over_1() {
        this.windowQueryTest();
    }

    static class DrillTestCaseLoaderRule
    implements BeforeEachCallback {
        public DrillTestCase testCase = null;

        DrillTestCaseLoaderRule() {
        }

        public void beforeEach(ExtensionContext context) {
            Method method = (Method)context.getTestMethod().get();
            DrillTest annotation = method.getAnnotation(DrillTest.class);
            this.testCase = annotation == null ? null : new DrillTestCase(annotation.value());
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface DrillTest {
        public String value();
    }

    static class DrillTestCase {
        private final String query;
        private final List<String[]> results;
        private String filename;

        public DrillTestCase(String filename) {
            try {
                this.filename = filename;
                this.query = this.readStringFromResource(".q");
                String resultsStr = this.readStringFromResource(".e");
                String[] lines = resultsStr.split("\n");
                this.results = new ArrayList<String[]>();
                if (resultsStr.length() > 0) {
                    for (String string : lines) {
                        String[] cols = string.split("\t");
                        this.results.add(cols);
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(String.format(Locale.ENGLISH, "Encountered exception while loading testcase [%s]", filename), e);
            }
        }

        @Nonnull
        private String getQueryString() {
            return this.query;
        }

        @Nonnull
        private List<String[]> getExpectedResults() {
            return this.results;
        }

        @Nonnull
        private String readStringFromResource(String s) throws IOException {
            String query;
            try (InputStream queryIn = ClassLoader.getSystemResourceAsStream("drill/window/queries/" + this.filename + s);){
                query = new String(ByteStreams.toByteArray((InputStream)queryIn), StandardCharsets.UTF_8);
            }
            return query;
        }
    }

    public class TextualResultsVerifier
    implements BaseCalciteQueryTest.ResultsVerifier {
        protected final List<String[]> expectedResultsText;
        @Nullable
        protected final RowSignature expectedResultRowSignature;
        private RowSignature currentRowSignature;

        public TextualResultsVerifier(List<String[]> expectedResultsString, RowSignature expectedSignature) {
            this.expectedResultsText = expectedResultsString;
            this.expectedResultRowSignature = expectedSignature;
        }

        @Override
        public void verifyRowSignature(RowSignature rowSignature) {
            if (this.expectedResultRowSignature != null) {
                Assert.assertEquals((Object)this.expectedResultRowSignature, (Object)rowSignature);
            }
            this.currentRowSignature = rowSignature;
        }

        @Override
        public void verify(String sql, QueryTestRunner.QueryResults queryResults) {
            List<Object[]> results = queryResults.results;
            List<Object[]> expectedResults = DrillWindowQueryTest.parseResults(this.currentRowSignature, this.expectedResultsText);
            try {
                Assert.assertEquals((String)StringUtils.format((String)"result count: %s", (Object[])new Object[]{sql}), (long)this.expectedResultsText.size(), (long)results.size());
                if (!this.isOrdered(queryResults)) {
                    results.sort(new ArrayRowCmp());
                    expectedResults.sort(new ArrayRowCmp());
                }
                DrillWindowQueryTest.this.assertResultsValid(BaseCalciteQueryTest.ResultMatchMode.EQUALS_RELATIVE_1000_ULPS, expectedResults, queryResults);
            }
            catch (AssertionError e) {
                BaseCalciteQueryTest.log.info("query: %s", new Object[]{sql});
                BaseCalciteQueryTest.log.info(BaseCalciteQueryTest.resultsToString("Expected", expectedResults), new Object[0]);
                BaseCalciteQueryTest.log.info(BaseCalciteQueryTest.resultsToString("Actual", results), new Object[0]);
                throw new AssertionError(StringUtils.format((String)"%s while processing: %s", (Object[])new Object[]{((Throwable)((Object)e)).getMessage(), sql}), (Throwable)((Object)e));
            }
        }

        private boolean isOrdered(QueryTestRunner.QueryResults queryResults) {
            SqlNode sqlNode = queryResults.capture.getSqlNode();
            return SqlToRelConverter.isOrdered((SqlNode)sqlNode);
        }
    }

    static class ArrayRowCmp
    implements Comparator<Object[]> {
        ArrayRowCmp() {
        }

        @Override
        public int compare(Object[] arg0, Object[] arg1) {
            String s0 = Arrays.toString(arg0);
            String s1 = Arrays.toString(arg1);
            return s0.compareTo(s1);
        }
    }

    protected static class DrillComponentSupplier
    extends SqlTestFramework.StandardComponentSupplier {
        public DrillComponentSupplier(TempDirProducer tempFolderProducer) {
            super(tempFolderProducer);
        }

        @Override
        public SpecificSegmentsQuerySegmentWalker addSegmentsToWalker(SpecificSegmentsQuerySegmentWalker walker) {
            super.addSegmentsToWalker(walker);
            File tmpFolder = this.tempDirProducer.newTempFolder();
            TestDataBuilder.attachIndexesForDrillTestDatasources(walker, tmpFolder);
            return walker;
        }
    }
}

