/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.Query;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.first.StringFirstAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.last.StringLastAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.LikeDimFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.druid.query.groupby.orderby.LimitSpec;
import org.apache.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.sql.calcite.BaseCalciteQueryTest;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.junit.jupiter.api.Test;

public class CalciteSimpleQueryTest
extends BaseCalciteQueryTest {
    @Test
    public void testGroupByTimeAndDim() {
        this.testQuery("SELECT FLOOR(__time TO MONTH), dim2, SUM(cnt)\nFROM druid.foo\nGROUP BY 1, 2", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteSimpleQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteSimpleQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteSimpleQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG), new DefaultDimensionSpec("dim2", "d1")})).setAggregatorSpecs(CalciteSimpleQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d0", 0, Granularities.MONTH)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteSimpleQueryTest.timestamp("2000-01-01"), null, 1L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2000-01-01"), "", 1L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2000-01-01"), "a", 1L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2001-01-01"), null, 1L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2001-01-01"), "a", 1L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2001-01-01"), "abc", 1L}));
    }

    @Test
    public void testGroupByDimAndTime() {
        this.testQuery("SELECT dim2, FLOOR(__time TO MONTH), SUM(cnt)\nFROM druid.foo\nGROUP BY 1, 2", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteSimpleQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteSimpleQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteSimpleQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0"), new DefaultDimensionSpec("v0", "d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteSimpleQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d1", 1, Granularities.MONTH)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, CalciteSimpleQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{null, CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"", CalciteSimpleQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"abc", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}));
    }

    @Test
    public void testGroupByDimAndTimeWhereOnTime() {
        this.testQuery("SELECT dim2, FLOOR(__time TO MONTH), SUM(cnt)\nFROM druid.foo\nWHERE FLOOR(__time TO MONTH) = TIMESTAMP '2001-01-01'\nGROUP BY 1, 2", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteSimpleQueryTest.querySegmentSpec(Intervals.of((String)"2001-01-01/P1M"))).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteSimpleQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteSimpleQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0"), new DefaultDimensionSpec("v0", "d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteSimpleQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d1", 1, Granularities.MONTH)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"abc", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}));
    }

    @Test
    public void testGroupByDimAndTimeOnDim() {
        this.testQuery("SELECT dim2, FLOOR(__time TO MONTH), SUM(cnt)\nFROM druid.foo\nWHERE dim2 LIKE 'a%'\nGROUP BY 1, 2", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteSimpleQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteSimpleQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteSimpleQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0"), new DefaultDimensionSpec("v0", "d1", ColumnType.LONG)})).setDimFilter((DimFilter)new LikeDimFilter("dim2", "a%", null, null)).setAggregatorSpecs(CalciteSimpleQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d1", 1, Granularities.MONTH)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"abc", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}));
    }

    @Test
    public void testGroupByTimeAndDimOrderByDim() {
        this.testQuery("SELECT FLOOR(__time TO MONTH), dim2, SUM(cnt)\nFROM druid.foo\nGROUP BY 1, 2\nORDER BY dim2", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteSimpleQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteSimpleQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteSimpleQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG), new DefaultDimensionSpec("dim2", "d1")})).setAggregatorSpecs(CalciteSimpleQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d1", OrderByColumnSpec.Direction.ASCENDING)), null)).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d0", 0, Granularities.MONTH)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteSimpleQueryTest.timestamp("2000-01-01"), null, 1L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2001-01-01"), null, 1L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2000-01-01"), "", 1L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2000-01-01"), "a", 1L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2001-01-01"), "a", 1L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2001-01-01"), "abc", 1L}));
    }

    @Test
    public void testGroupByTimeAndDimOrderByDimDesc() {
        this.testQuery("SELECT FLOOR(__time TO MONTH), dim2, SUM(cnt)\nFROM druid.foo\nGROUP BY 1, 2\nORDER BY dim2 DESC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteSimpleQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteSimpleQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteSimpleQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.LONG), new DefaultDimensionSpec("dim2", "d1")})).setAggregatorSpecs(CalciteSimpleQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d1", OrderByColumnSpec.Direction.DESCENDING)), null)).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d0", 0, Granularities.MONTH)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteSimpleQueryTest.timestamp("2001-01-01"), "abc", 1L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2000-01-01"), "a", 1L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2001-01-01"), "a", 1L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2000-01-01"), "", 1L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2000-01-01"), null, 1L}, (Object)new Object[]{CalciteSimpleQueryTest.timestamp("2001-01-01"), null, 1L}));
    }

    @Test
    public void testGroupByDimAndTimeOrderByTime() {
        this.testQuery("SELECT dim2, FLOOR(__time TO MONTH), SUM(cnt)\nFROM druid.foo\nGROUP BY 1, 2\nORDER BY FLOOR(__time TO MONTH)", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteSimpleQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteSimpleQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteSimpleQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0"), new DefaultDimensionSpec("v0", "d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteSimpleQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d1", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC)), null)).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d1", 1, Granularities.MONTH)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, CalciteSimpleQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"", CalciteSimpleQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{null, CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"abc", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}));
    }

    @Test
    public void testGroupByDimAndTimeOrderByTimeDesc() {
        this.testQuery("SELECT dim2, FLOOR(__time TO MONTH), SUM(cnt)\nFROM druid.foo\nGROUP BY 1, 2\nORDER BY FLOOR(__time TO MONTH) DESC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteSimpleQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteSimpleQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteSimpleQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0"), new DefaultDimensionSpec("v0", "d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteSimpleQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d1", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), null)).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d1", 1, Granularities.MONTH)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"abc", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{null, CalciteSimpleQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"", CalciteSimpleQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2000-01-01"), 1L}));
    }

    @Test
    public void testGroupByDimAndTimeOrderByTimeAndDim() {
        this.testQuery("SELECT dim2, FLOOR(__time TO MONTH), SUM(cnt)\nFROM druid.foo\nGROUP BY 1, 2\nORDER BY FLOOR(__time TO MONTH), dim2 DESC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteSimpleQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteSimpleQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteSimpleQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0"), new DefaultDimensionSpec("v0", "d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteSimpleQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d1", OrderByColumnSpec.Direction.ASCENDING, StringComparators.NUMERIC), (Object)new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.DESCENDING)), null)).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d1", 1, Granularities.MONTH)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"", CalciteSimpleQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{null, CalciteSimpleQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"abc", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{null, CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}));
    }

    @Test
    public void testGroupByDimAndTimeOrderByDimAndTime() {
        this.testQuery("SELECT dim2, FLOOR(__time TO MONTH), SUM(cnt)\nFROM druid.foo\nGROUP BY 1, 2\nORDER BY dim2, FLOOR(__time TO MONTH) DESC", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteSimpleQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteSimpleQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteSimpleQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0"), new DefaultDimensionSpec("v0", "d1", ColumnType.LONG)})).setAggregatorSpecs(CalciteSimpleQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.ASCENDING), (Object)new OrderByColumnSpec("d1", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC)), null)).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d1", 1, Granularities.MONTH)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{null, CalciteSimpleQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"", CalciteSimpleQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}, (Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2000-01-01"), 1L}, (Object)new Object[]{"abc", CalciteSimpleQueryTest.timestamp("2001-01-01"), 1L}));
    }

    @Test
    public void testGroupByDimAndTimeAndDimOrderByDimAndTimeDim() {
        this.testQuery("SELECT dim2, FLOOR(__time TO MONTH), dim1, SUM(cnt)\nFROM druid.foo\nGROUP BY 1, 2, 3\nORDER BY dim2 DESC, FLOOR(__time TO MONTH) DESC, dim1", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteSimpleQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteSimpleQueryTest.expressionVirtualColumn("v0", "timestamp_floor(\"__time\",'P1M',null,'UTC')", ColumnType.LONG)}).setDimensions(CalciteSimpleQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim2", "d0"), new DefaultDimensionSpec("v0", "d1", ColumnType.LONG), new DefaultDimensionSpec("dim1", "d2")})).setAggregatorSpecs(CalciteSimpleQueryTest.aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "cnt")})).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("d0", OrderByColumnSpec.Direction.DESCENDING), (Object)new OrderByColumnSpec("d1", OrderByColumnSpec.Direction.DESCENDING, StringComparators.NUMERIC), (Object)new OrderByColumnSpec("d2", OrderByColumnSpec.Direction.ASCENDING)), null)).setContext(this.withTimestampResultContext(QUERY_CONTEXT_DEFAULT, "d1", 1, Granularities.MONTH)).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc", CalciteSimpleQueryTest.timestamp("2001-01-01"), "def", 1L}, (Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2001-01-01"), "1", 1L}, (Object)new Object[]{"a", CalciteSimpleQueryTest.timestamp("2000-01-01"), "", 1L}, (Object)new Object[]{"", CalciteSimpleQueryTest.timestamp("2000-01-01"), "2", 1L}, (Object)new Object[]{null, CalciteSimpleQueryTest.timestamp("2001-01-01"), "abc", 1L}, (Object)new Object[]{null, CalciteSimpleQueryTest.timestamp("2000-01-01"), "10.1", 1L}));
    }

    @Test
    public void testEarliestByLatestByWithExpression() {
        this.testBuilder().sql("SELECT\n  channel\n ,cityName\n ,EARLIEST_BY(\"cityName\", MILLIS_TO_TIMESTAMP(17), 125) as latest_by_time_page\n ,LATEST_BY(\"cityName\", MILLIS_TO_TIMESTAMP(17), 126) as latest_by_time_page\n ,EARLIEST_BY(\"cityName\", TIMESTAMPADD(HOUR, 1, \"__time\"), 127) as latest_by_time_page\n ,LATEST_BY(\"cityName\", TIMESTAMPADD(HOUR, 1, \"__time\"), 128) as latest_by_time_page\nFROM druid.wikipedia\nwhere channel < '#b' and cityName < 'B'\nGROUP BY 1,2").expectedQueries((List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("wikipedia").setInterval(CalciteSimpleQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteSimpleQueryTest.expressionVirtualColumn("v0", "17", ColumnType.LONG), CalciteSimpleQueryTest.expressionVirtualColumn("v1", "(\"__time\" + 3600000)", ColumnType.LONG)}).setDimensions(CalciteSimpleQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("channel", "d0"), new DefaultDimensionSpec("cityName", "d1")})).setDimFilter((DimFilter)CalciteSimpleQueryTest.and(CalciteSimpleQueryTest.range("channel", ColumnType.STRING, null, "#b", false, true), CalciteSimpleQueryTest.range("cityName", ColumnType.STRING, null, "B", false, true))).setAggregatorSpecs((List)ImmutableList.of((Object)new StringFirstAggregatorFactory("a0", "cityName", "v0", Integer.valueOf(125)), (Object)new StringLastAggregatorFactory("a1", "cityName", "v0", Integer.valueOf(126)), (Object)new StringFirstAggregatorFactory("a2", "cityName", "v1", Integer.valueOf(127)), (Object)new StringLastAggregatorFactory("a3", "cityName", "v1", Integer.valueOf(128)))).setContext(QUERY_CONTEXT_DEFAULT).build())).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{"#ar.wikipedia", "Amman", "Amman", "Amman", "Amman", "Amman"})).run();
    }
}

