/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.RelNode;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.DruidExceptionMatcher;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.LookupDataSource;
import org.apache.druid.query.Order;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.RestrictedDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.having.HavingSpec;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.query.policy.Policy;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.query.topn.DimensionTopNMetricSpec;
import org.apache.druid.query.topn.InvertedTopNMetricSpec;
import org.apache.druid.query.topn.TopNMetricSpec;
import org.apache.druid.query.topn.TopNQueryBuilder;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.sql.calcite.BaseCalciteQueryTest;
import org.apache.druid.sql.calcite.SqlTestFrameworkConfig;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.apache.druid.sql.calcite.util.CacheTestHelperModule;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.hamcrest.Matcher;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CalciteSelectQueryTest
extends BaseCalciteQueryTest {
    @Test
    public void testSelectConstantExpression() {
        this.testQuery("SELECT REGEXP_EXTRACT('foo', '^(.)')", (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{0L}), (RowSignature)RowSignature.builder().add("ZERO", ColumnType.LONG).build())).intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "'f'", ColumnType.STRING, ExprMacroTable.nil())}).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"f"}));
    }

    @Test
    public void testExpressionContainingNull() {
        this.testQuery("SELECT ARRAY ['Hello', NULL]", (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{0L}), (RowSignature)RowSignature.builder().add("ZERO", ColumnType.LONG).build())).intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v0", "array('Hello',null)", ColumnType.STRING_ARRAY, ExprMacroTable.nil())}).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.STRING_ARRAY}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[\"Hello\",null]"}));
    }

    @Test
    public void testTimeCeilExpressionContainingInvalidPeriod() {
        this.testQueryThrows("SELECT TIME_CEIL(__time, 'PT1Y') FROM foo", DruidExceptionMatcher.invalidInput().expectMessageContains("Invalid period['PT1Y'] specified for expression[timestamp_ceil(\"__time\", 'PT1Y', null, 'UTC')]"));
    }

    @Test
    public void testTimeFloorExpressionContainingInvalidPeriod() {
        this.testQueryThrows("SELECT TIME_FLOOR(TIMESTAMPADD(DAY, -1, __time), 'PT1D') FROM foo", DruidExceptionMatcher.invalidInput().expectMessageContains("Invalid period['PT1D'] specified for expression[timestamp_floor((\"__time\" + -86400000), 'PT1D', null, 'UTC')]"));
    }

    @Test
    public void testValuesContainingNull() {
        this.testQuery("SELECT * FROM (VALUES (NULL, 'United States'))", (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{null, "United States"}), (RowSignature)RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.STRING).build())).intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"EXPR$0", "EXPR$1"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, "United States"}));
    }

    @Test
    public void testMultipleValuesContainingNull() {
        this.testQuery("SELECT * FROM (VALUES (NULL, 'United States'), ('Delhi', 'India'))", (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{null, "United States"}, (Object)new Object[]{"Delhi", "India"}), (RowSignature)RowSignature.builder().add("EXPR$0", ColumnType.STRING).add("EXPR$1", ColumnType.STRING).build())).intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"EXPR$0", "EXPR$1"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, "United States"}, (Object)new Object[]{"Delhi", "India"}));
    }

    @Test
    public void testMultipleValuesContainingNullAndIntegerValues() {
        this.testQuery("SELECT * FROM (VALUES (NULL, 'United States'), (50, 'India'))", (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{null, "United States"}, (Object)new Object[]{50L, "India"}), (RowSignature)RowSignature.builder().add("EXPR$0", ColumnType.LONG).add("EXPR$1", ColumnType.STRING).build())).intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"EXPR$0", "EXPR$1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, "United States"}, (Object)new Object[]{50, "India"}));
    }

    @Test
    public void testSelectNonNumericNumberLiterals() {
        this.testQuery("SELECT CAST(1 / 0.0 AS BIGINT), CAST(1 / -0.0 AS BIGINT), CAST(-1 / 0.0 AS BIGINT), CAST(-1 / -0.0 AS BIGINT), CAST(0/ 0.0 AS BIGINT)", (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{Long.MAX_VALUE, Long.MAX_VALUE, Long.MIN_VALUE, Long.MIN_VALUE, 0L}), (RowSignature)RowSignature.builder().add("EXPR$0", ColumnType.LONG).add("EXPR$1", ColumnType.LONG).add("EXPR$2", ColumnType.LONG).add("EXPR$3", ColumnType.LONG).add("EXPR$4", ColumnType.LONG).build())).intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"EXPR$0", "EXPR$1", "EXPR$2", "EXPR$3", "EXPR$4"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.LONG, ColumnType.LONG, ColumnType.LONG, ColumnType.LONG}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{Long.MAX_VALUE, Long.MAX_VALUE, Long.MIN_VALUE, Long.MIN_VALUE, 0L}));
    }

    @Test
    public void testDruidLogicalValuesRule() {
        this.testQuery("SELECT FLOOR(123), CEIL(123), CAST(123.0 AS INTEGER)", (List<Query<?>>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{123L, 123L, 123L}), (RowSignature)RowSignature.builder().add("EXPR$0", ColumnType.LONG).add("EXPR$1", ColumnType.LONG).add("EXPR$2", ColumnType.LONG).build())).intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.ETERNITY))).columns(new String[]{"EXPR$0", "EXPR$1", "EXPR$2"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.LONG, ColumnType.LONG}).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{123, 123, 123}));
    }

    @Test
    public void testSelectConstantExpressionFromTable() {
        this.testQuery("SELECT 1 + 1, dim1 FROM foo LIMIT 1", (List<Query<?>>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteSelectQueryTest.expressionVirtualColumn("v0", "2", ColumnType.LONG)}).columns(new String[]{"v0", "dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).limit(1L).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{2, ""}));
    }

    @Test
    public void testSelectConstantExpressionEquivalentToNaN() {
        this.testQueryThrows("SELECT log10(0) - log10(0), dim1 FROM foo LIMIT 1", CalciteSelectQueryTest.invalidSqlIs("Expression [(log10(0) - log10(0))] evaluates to an unsupported value [NaN], expected something that can be a Double.  Consider casting with 'CAST(<col> AS BIGINT)'"));
    }

    @Test
    public void testSelectConstantExpressionEquivalentToInfinity() {
        this.testQueryThrows("SELECT log10(0), dim1 FROM foo LIMIT 1", CalciteSelectQueryTest.invalidSqlIs("Expression [log10(0)] evaluates to an unsupported value [-Infinity], expected something that can be a Double.  Consider casting with 'CAST(<col> AS BIGINT)'"));
    }

    @Test
    public void testSelectTrimFamily() {
        this.testQuery("SELECT\nTRIM(BOTH 'x' FROM 'xfoox'),\nTRIM(TRAILING 'x' FROM 'xfoox'),\nTRIM(' ' FROM ' foo '),\nTRIM(TRAILING FROM ' foo '),\nTRIM(' foo '),\nBTRIM(' foo '),\nBTRIM('xfoox', 'x'),\nLTRIM(' foo '),\nLTRIM('xfoox', 'x'),\nRTRIM(' foo '),\nRTRIM('xfoox', 'x'),\nCOUNT(*)\nFROM foo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteSelectQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).postAggregators(new PostAggregator[]{CalciteSelectQueryTest.expressionPostAgg("p0", "'foo'", ColumnType.STRING), CalciteSelectQueryTest.expressionPostAgg("p1", "'xfoo'", ColumnType.STRING), CalciteSelectQueryTest.expressionPostAgg("p2", "'foo'", ColumnType.STRING), CalciteSelectQueryTest.expressionPostAgg("p3", "' foo'", ColumnType.STRING), CalciteSelectQueryTest.expressionPostAgg("p4", "'foo'", ColumnType.STRING), CalciteSelectQueryTest.expressionPostAgg("p5", "'foo'", ColumnType.STRING), CalciteSelectQueryTest.expressionPostAgg("p6", "'foo'", ColumnType.STRING), CalciteSelectQueryTest.expressionPostAgg("p7", "'foo '", ColumnType.STRING), CalciteSelectQueryTest.expressionPostAgg("p8", "'foox'", ColumnType.STRING), CalciteSelectQueryTest.expressionPostAgg("p9", "' foo'", ColumnType.STRING), CalciteSelectQueryTest.expressionPostAgg("p10", "'xfoo'", ColumnType.STRING)}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"foo", "xfoo", "foo", " foo", "foo", "foo", "foo", "foo ", "foox", " foo", "xfoo", 6L}));
    }

    @Test
    public void testSelectPadFamily() {
        this.testQuery("SELECT\nLPAD('foo', 5, 'x'),\nLPAD('foo', 2, 'x'),\nLPAD('foo', 5),\nRPAD('foo', 5, 'x'),\nRPAD('foo', 2, 'x'),\nRPAD('foo', 5),\nCOUNT(*)\nFROM foo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteSelectQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).postAggregators(new PostAggregator[]{CalciteSelectQueryTest.expressionPostAgg("p0", "'xxfoo'", ColumnType.STRING), CalciteSelectQueryTest.expressionPostAgg("p1", "'fo'", ColumnType.STRING), CalciteSelectQueryTest.expressionPostAgg("p2", "'  foo'", ColumnType.STRING), CalciteSelectQueryTest.expressionPostAgg("p3", "'fooxx'", ColumnType.STRING), CalciteSelectQueryTest.expressionPostAgg("p4", "'fo'", ColumnType.STRING), CalciteSelectQueryTest.expressionPostAgg("p5", "'foo  '", ColumnType.STRING)}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"xxfoo", "fo", "  foo", "fooxx", "fo", "foo  ", 6L}));
    }

    @Test
    public void testBitwiseExpressions() {
        ImmutableList expected = ImmutableList.of((Object)new Object[]{null, null, null, -8L, 28L, 1L, 0x3FF0000000000000L, 3.5E-323}, (Object)new Object[]{325323L, 325323L, 0L, -325324L, 1301292L, 81330L, 0x3FFB333333333333L, 1.60731E-318}, (Object)new Object[]{0L, 0L, 0L, -1L, 0L, 0L, 0L, 0.0}, (Object)new Object[]{null, null, null, null, null, null, null, null}, (Object)new Object[]{null, null, null, null, null, null, null, null}, (Object)new Object[]{null, null, null, null, null, null, null, null});
        this.testQuery("SELECT\nBITWISE_AND(l1, l2),\nBITWISE_OR(l1, l2),\nBITWISE_XOR(l1, l2),\nBITWISE_COMPLEMENT(l1),\nBITWISE_SHIFT_LEFT(l1, 2),\nBITWISE_SHIFT_RIGHT(l1, 2),\nBITWISE_CONVERT_DOUBLE_TO_LONG_BITS(dbl1),\nBITWISE_CONVERT_LONG_BITS_TO_DOUBLE(l1)\nFROM numfoo", (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"v0", "v1", "v2", "v3", "v4", "v5", "v6", "v7"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.LONG, ColumnType.LONG, ColumnType.LONG, ColumnType.LONG, ColumnType.LONG, ColumnType.LONG, ColumnType.DOUBLE}).virtualColumns(new VirtualColumn[]{CalciteSelectQueryTest.expressionVirtualColumn("v0", "bitwiseAnd(\"l1\",\"l2\")", ColumnType.LONG), CalciteSelectQueryTest.expressionVirtualColumn("v1", "bitwiseOr(\"l1\",\"l2\")", ColumnType.LONG), CalciteSelectQueryTest.expressionVirtualColumn("v2", "bitwiseXor(\"l1\",\"l2\")", ColumnType.LONG), CalciteSelectQueryTest.expressionVirtualColumn("v3", "bitwiseComplement(\"l1\")", ColumnType.LONG), CalciteSelectQueryTest.expressionVirtualColumn("v4", "bitwiseShiftLeft(\"l1\",2)", ColumnType.LONG), CalciteSelectQueryTest.expressionVirtualColumn("v5", "bitwiseShiftRight(\"l1\",2)", ColumnType.LONG), CalciteSelectQueryTest.expressionVirtualColumn("v6", "bitwiseConvertDoubleToLongBits(\"dbl1\")", ColumnType.LONG), CalciteSelectQueryTest.expressionVirtualColumn("v7", "bitwiseConvertLongBitsToDouble(\"l1\")", ColumnType.DOUBLE)}).context(QUERY_CONTEXT_DEFAULT).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()), (List<Object[]>)expected);
    }

    @Test
    public void testSafeDivideWithoutTable() {
        HashMap<String, Object> context = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
        this.testQuery("select SAFE_DIVIDE(0, 0), SAFE_DIVIDE(1,0), SAFE_DIVIDE(10,2.5),  SAFE_DIVIDE(10.5,3.5), SAFE_DIVIDE(10.5,3), SAFE_DIVIDE(10,2)", (Map<String, Object>)context, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{0L}), (RowSignature)RowSignature.builder().add("ZERO", ColumnType.LONG).build())).intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"v0", "v1", "v2", "v3", "v4"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.DOUBLE, ColumnType.DOUBLE, ColumnType.DOUBLE, ColumnType.LONG}).virtualColumns(new VirtualColumn[]{CalciteSelectQueryTest.expressionVirtualColumn("v0", "null", ColumnType.LONG), CalciteSelectQueryTest.expressionVirtualColumn("v1", "4.0", ColumnType.DOUBLE), CalciteSelectQueryTest.expressionVirtualColumn("v2", "3.0", ColumnType.DOUBLE), CalciteSelectQueryTest.expressionVirtualColumn("v3", "3.5", ColumnType.DOUBLE), CalciteSelectQueryTest.expressionVirtualColumn("v4", "5", ColumnType.LONG)}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(context).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null, null, 4.0, 3.0, 3.5, 5}));
    }

    @Test
    public void testSafeDivideExpressions() {
        ImmutableList expected = ImmutableList.of((Object)new Object[]{null, null, null, Float.valueOf(7.0f)}, (Object)new Object[]{Float.valueOf(1.0f), 1L, 1.0, Float.valueOf(3253230.0f)}, (Object)new Object[]{Float.valueOf(0.0f), null, 0.0, Float.valueOf(0.0f)}, (Object)new Object[]{null, null, null, null}, (Object)new Object[]{null, null, null, null}, (Object)new Object[]{null, null, null, null});
        this.testQuery("SELECT\nSAFE_DIVIDE(f1, f2),\nSAFE_DIVIDE(l1, l2),\nSAFE_DIVIDE(dbl2, dbl1),\nSAFE_DIVIDE(l1, f1)\nFROM numfoo", (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"v0", "v1", "v2", "v3"}).columnTypes(new ColumnType[]{ColumnType.FLOAT, ColumnType.LONG, ColumnType.DOUBLE, ColumnType.FLOAT}).virtualColumns(new VirtualColumn[]{CalciteSelectQueryTest.expressionVirtualColumn("v0", "safe_divide(\"f1\",\"f2\")", ColumnType.FLOAT), CalciteSelectQueryTest.expressionVirtualColumn("v1", "safe_divide(\"l1\",\"l2\")", ColumnType.LONG), CalciteSelectQueryTest.expressionVirtualColumn("v2", "safe_divide(\"dbl2\",\"dbl1\")", ColumnType.DOUBLE), CalciteSelectQueryTest.expressionVirtualColumn("v3", "safe_divide(\"l1\",\"f1\")", ColumnType.FLOAT)}).context(QUERY_CONTEXT_DEFAULT).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()), (List<Object[]>)expected);
    }

    @Test
    public void testExplainSelectConstantExpression() {
        this.skipVectorize();
        String query = "EXPLAIN PLAN FOR SELECT 1 + 1";
        String explanation = "[{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"inline\",\"columnNames\":[\"EXPR$0\"],\"columnTypes\":[\"LONG\"],\"rows\":[[2]]},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"resultFormat\":\"compactedList\",\"columns\":[\"EXPR$0\"],\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"columnTypes\":[\"LONG\"],\"granularity\":{\"type\":\"all\"},\"legacy\":false},\"signature\":[{\"name\":\"EXPR$0\",\"type\":\"LONG\"}],\"columnMappings\":[{\"queryColumn\":\"EXPR$0\",\"outputColumn\":\"EXPR$0\"}]}]";
        String resources = "[]";
        String attributes = "{\"statementType\":\"SELECT\"}";
        this.testQuery(PLANNER_CONFIG_NATIVE_QUERY_EXPLAIN, "EXPLAIN PLAN FOR SELECT 1 + 1", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"inline\",\"columnNames\":[\"EXPR$0\"],\"columnTypes\":[\"LONG\"],\"rows\":[[2]]},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"resultFormat\":\"compactedList\",\"columns\":[\"EXPR$0\"],\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"columnTypes\":[\"LONG\"],\"granularity\":{\"type\":\"all\"},\"legacy\":false},\"signature\":[{\"name\":\"EXPR$0\",\"type\":\"LONG\"}],\"columnMappings\":[{\"queryColumn\":\"EXPR$0\",\"outputColumn\":\"EXPR$0\"}]}]", "[]", "{\"statementType\":\"SELECT\"}"}));
    }

    @Test
    public void testSelectStarWithDimFilter() {
        this.testQuery(PLANNER_CONFIG_DEFAULT, QUERY_CONTEXT_DEFAULT, "SELECT * FROM druid.foo WHERE dim1 > 'd' OR dim2 = 'a'", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).filters((DimFilter)CalciteSelectQueryTest.or(CalciteSelectQueryTest.range("dim1", ColumnType.STRING, "d", null, true, false), CalciteSelectQueryTest.equality("dim2", "a", ColumnType.STRING))).columns(new String[]{"__time", "dim1", "dim2", "dim3", "cnt", "m1", "m2", "unique_dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.LONG, ColumnType.FLOAT, ColumnType.DOUBLE, ColumnType.ofComplex((String)"hyperUnique")}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteSelectQueryTest.timestamp("2000-01-01"), "", "a", "[\"a\",\"b\"]", 1L, Float.valueOf(1.0f), 1.0, "\"AQAAAEAAAA==\""}, (Object)new Object[]{CalciteSelectQueryTest.timestamp("2001-01-01"), "1", "a", "", 1L, Float.valueOf(4.0f), 4.0, "\"AQAAAQAAAAFREA==\""}, (Object)new Object[]{CalciteSelectQueryTest.timestamp("2001-01-02"), "def", "abc", null, 1L, Float.valueOf(5.0f), 5.0, "\"AQAAAQAAAACyEA==\""}));
    }

    @Test
    public void testSelectDistinctWithCascadeExtractionFilter() {
        this.cannotVectorizeUnlessFallback();
        this.testQuery("SELECT distinct dim1 FROM druid.foo WHERE substring(substring(dim1, 2), 1, 1) = 'e' OR dim2 = 'a'", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteSelectQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setVirtualColumns(VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{CalciteSelectQueryTest.expressionVirtualColumn("v0", "substring(substring(\"dim1\", 1, -1), 0, 1)", ColumnType.STRING)})).setDimFilter((DimFilter)CalciteSelectQueryTest.or(CalciteSelectQueryTest.equality("v0", "e", ColumnType.STRING), CalciteSelectQueryTest.equality("dim2", "a", ColumnType.STRING))).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{""}, (Object)new Object[]{"1"}, (Object)new Object[]{"def"}));
    }

    @Test
    public void testSelectDistinctWithStrlenFilter() {
        this.cannotVectorizeUnlessFallback();
        this.testQuery("SELECT distinct dim1 FROM druid.foo WHERE CHARACTER_LENGTH(dim1) = 3 OR CAST(CHARACTER_LENGTH(dim1) AS varchar) = 3", (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setVirtualColumns(new VirtualColumn[]{CalciteSelectQueryTest.expressionVirtualColumn("v0", "strlen(\"dim1\")", ColumnType.LONG)}).setDimensions(CalciteSelectQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("dim1", "d0")})).setDimFilter(CalciteSelectQueryTest.equality("v0", 3L, ColumnType.LONG)).setContext(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc"}, (Object)new Object[]{"def"}));
    }

    @Test
    public void testSelectDistinctWithLimit() {
        this.testQuery("SELECT DISTINCT dim2 FROM druid.foo LIMIT 10", (List<Query<?>>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim2", "d0")).metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.LEXICOGRAPHIC)).threshold(10).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null}, (Object)new Object[]{""}, (Object)new Object[]{"a"}, (Object)new Object[]{"abc"}));
    }

    @Test
    public void testSelectDistinctWithSortAsOuterQuery() {
        this.testQuery("SELECT * FROM (SELECT DISTINCT dim2 FROM druid.foo ORDER BY dim2) LIMIT 10", (List<Query<?>>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim2", "d0")).metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.LEXICOGRAPHIC)).threshold(10).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null}, (Object)new Object[]{""}, (Object)new Object[]{"a"}, (Object)new Object[]{"abc"}));
    }

    @Test
    public void testSelectDistinctWithSortAsOuterQuery2() {
        this.testQuery("SELECT * FROM (SELECT DISTINCT dim2 FROM druid.foo ORDER BY dim2 LIMIT 5) LIMIT 10", (List<Query<?>>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim2", "d0")).metric((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.LEXICOGRAPHIC)).threshold(5).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null}, (Object)new Object[]{""}, (Object)new Object[]{"a"}, (Object)new Object[]{"abc"}));
    }

    @Test
    public void testSelectDistinctWithSortAsOuterQuery3() {
        this.testQuery("SELECT * FROM (SELECT DISTINCT dim2 FROM druid.foo ORDER BY dim2 DESC LIMIT 5) LIMIT 10", (List<Query<?>>)ImmutableList.of((Object)new TopNQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).dimension((DimensionSpec)new DefaultDimensionSpec("dim2", "d0")).metric((TopNMetricSpec)new InvertedTopNMetricSpec((TopNMetricSpec)new DimensionTopNMetricSpec(null, StringComparators.LEXICOGRAPHIC))).threshold(5).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{null}, (Object)new Object[]{"abc"}, (Object)new Object[]{"a"}, (Object)new Object[]{""}));
    }

    @Test
    public void testSelectNonAggregatingWithLimitLiterallyZero() {
        this.testQuery("SELECT dim2 FROM druid.foo ORDER BY dim2 LIMIT 0", (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of(), (RowSignature)RowSignature.builder().add("dim2", ColumnType.STRING).build())).intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim2"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testSelectNonAggregatingWithLimitReducedToZero() {
        this.testQuery("SELECT * FROM (SELECT dim2 FROM druid.foo ORDER BY dim2 LIMIT 2 OFFSET 5) OFFSET 2", (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of(), (RowSignature)RowSignature.builder().add("dim2", ColumnType.STRING).build())).intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim2"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testSelectAggregatingWithLimitReducedToZero() {
        this.testQuery("SELECT * FROM (SELECT DISTINCT dim2 FROM druid.foo ORDER BY dim2 LIMIT 2 OFFSET 5) OFFSET 2", (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of(), (RowSignature)RowSignature.builder().add("dim2", ColumnType.STRING).build())).intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim2"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testSelectCurrentTimeAndDateLosAngeles() {
        HashMap<String, Object> context = new HashMap<String, Object>(QUERY_CONTEXT_DEFAULT);
        context.put("sqlCurrentTimestamp", "2000-01-01T00:00:00.123Z");
        context.put("sqlTimeZone", "America/Los_Angeles");
        DateTimeZone timeZone = DateTimes.inferTzFromString((String)"America/Los_Angeles");
        this.testQuery(PLANNER_CONFIG_DEFAULT, (Map<String, Object>)context, "SELECT CURRENT_TIMESTAMP, CURRENT_TIMESTAMP(0), CURRENT_TIMESTAMP(1), CURRENT_TIMESTAMP(2), CURRENT_TIMESTAMP(3), CURRENT_DATE, CURRENT_DATE + INTERVAL '1' DAY", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)Druids.newScanQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{new DateTime((Object)"2000-01-01T00:00:00.123Z", timeZone).withZone(DateTimeZone.UTC).getMillis(), new DateTime((Object)"2000-01-01T00:00:00.000Z", timeZone).withZone(DateTimeZone.UTC).getMillis(), new DateTime((Object)"2000-01-01T00:00:00.100Z", timeZone).withZone(DateTimeZone.UTC).getMillis(), new DateTime((Object)"2000-01-01T00:00:00.120Z", timeZone).withZone(DateTimeZone.UTC).getMillis(), new DateTime((Object)"2000-01-01T00:00:00.123Z", timeZone).withZone(DateTimeZone.UTC).getMillis(), new DateTime((Object)"1999-12-31", timeZone).withZone(DateTimeZone.UTC).getMillis(), new DateTime((Object)"2000-01-01", timeZone).withZone(DateTimeZone.UTC).getMillis()}), (RowSignature)RowSignature.builder().add("CURRENT_TIMESTAMP", ColumnType.LONG).add("EXPR$1", ColumnType.LONG).add("EXPR$2", ColumnType.LONG).add("EXPR$3", ColumnType.LONG).add("EXPR$4", ColumnType.LONG).add("CURRENT_DATE", ColumnType.LONG).add("EXPR$6", ColumnType.LONG).build())).intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"CURRENT_TIMESTAMP", "EXPR$1", "EXPR$2", "EXPR$3", "EXPR$4", "CURRENT_DATE", "EXPR$6"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.LONG, ColumnType.LONG, ColumnType.LONG, ColumnType.LONG, ColumnType.LONG, ColumnType.LONG}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(context).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteSelectQueryTest.timestamp("2000-01-01T00:00:00.123Z", "America/Los_Angeles"), CalciteSelectQueryTest.timestamp("2000-01-01T00:00:00.000Z", "America/Los_Angeles"), CalciteSelectQueryTest.timestamp("2000-01-01T00:00:00.100Z", "America/Los_Angeles"), CalciteSelectQueryTest.timestamp("2000-01-01T00:00:00.120Z", "America/Los_Angeles"), CalciteSelectQueryTest.timestamp("2000-01-01T00:00:00.123Z", "America/Los_Angeles"), CalciteSelectQueryTest.day("1999-12-31"), CalciteSelectQueryTest.day("2000-01-01")}));
    }

    @Test
    public void testSelectCurrentTimePrecisionTooHigh() {
        this.testQueryThrows("SELECT CURRENT_TIMESTAMP(4)", CalciteSelectQueryTest.invalidSqlContains("Argument to function 'CURRENT_TIMESTAMP' must be a valid precision between '0' and '3'"));
    }

    @Test
    public void testSelectCountStar() {
        this.testQuery(PLANNER_CONFIG_DEFAULT, QUERY_CONTEXT_DEFAULT, "SELECT exp(count(*)) + 10, sum(m2)  FROM druid.foo WHERE  dim2 = 0", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).filters(CalciteSelectQueryTest.equality("dim2", 0L, ColumnType.LONG)).granularity(Granularities.ALL).aggregators(CalciteSelectQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0"), new DoubleSumAggregatorFactory("a1", "m2")})).postAggregators(new PostAggregator[]{CalciteSelectQueryTest.expressionPostAgg("p0", "(exp(\"a0\") + 10)", ColumnType.DOUBLE)}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{11.0, null}));
        this.testQuery(PLANNER_CONFIG_DEFAULT, QUERY_CONTEXT_DEFAULT, "SELECT exp(count(*)) + 10, sum(m2)  FROM druid.foo WHERE  __time >= TIMESTAMP '2999-01-01 00:00:00'", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Intervals.of((String)"2999-01-01T00:00:00.000Z/146140482-04-24T15:36:27.903Z"))).granularity(Granularities.ALL).aggregators(CalciteSelectQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0"), new DoubleSumAggregatorFactory("a1", "m2")})).postAggregators(new PostAggregator[]{CalciteSelectQueryTest.expressionPostAgg("p0", "(exp(\"a0\") + 10)", ColumnType.DOUBLE)}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{11.0, null}));
        this.testQuery(PLANNER_CONFIG_DEFAULT, TIMESERIES_CONTEXT_BY_GRAN, "SELECT COUNT(*) FROM foo WHERE dim1 = 'nonexistent'", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).filters(CalciteSelectQueryTest.equality("dim1", "nonexistent", ColumnType.STRING)).granularity(Granularities.ALL).aggregators(CalciteSelectQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(TIMESERIES_CONTEXT_BY_GRAN).build()), (List<Object[]>)ImmutableList.of());
        this.testQuery("SELECT COUNT(*) FROM foo WHERE dim1 = 'nonexistent' GROUP BY FLOOR(__time TO DAY)", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).filters(CalciteSelectQueryTest.equality("dim1", "nonexistent", ColumnType.STRING)).granularity(Granularities.DAY).aggregators(CalciteSelectQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(CalciteSelectQueryTest.getTimeseriesContextWithFloorTime(TIMESERIES_CONTEXT_BY_GRAN, "d0")).build()), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testSelectStarFromLookup() {
        this.testQuery("SELECT * FROM lookup.lookyloo", (List<Query<?>>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource((DataSource)new LookupDataSource("lookyloo")).intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"k", "v"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING}).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc", "xabc"}, (Object)new Object[]{"6", "x6"}, (Object)new Object[]{"a", "xa"}, (Object)new Object[]{"nosuchkey", "mysteryvalue"}));
    }

    @Test
    public void testSelectStar() {
        this.testQuery(PLANNER_CONFIG_DEFAULT, QUERY_CONTEXT_DEFAULT, "SELECT * FROM druid.foo", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "dim1", "dim2", "dim3", "cnt", "m1", "m2", "unique_dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.LONG, ColumnType.FLOAT, ColumnType.DOUBLE, ColumnType.ofComplex((String)"hyperUnique")}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteSelectQueryTest.timestamp("2000-01-01"), "", "a", "[\"a\",\"b\"]", 1L, Float.valueOf(1.0f), 1.0, "\"AQAAAEAAAA==\""}, (Object)new Object[]{CalciteSelectQueryTest.timestamp("2000-01-02"), "10.1", null, "[\"b\",\"c\"]", 1L, Float.valueOf(2.0f), 2.0, "\"AQAAAQAAAAHNBA==\""}, (Object)new Object[]{CalciteSelectQueryTest.timestamp("2000-01-03"), "2", "", "d", 1L, Float.valueOf(3.0f), 3.0, "\"AQAAAQAAAAOzAg==\""}, (Object)new Object[]{CalciteSelectQueryTest.timestamp("2001-01-01"), "1", "a", "", 1L, Float.valueOf(4.0f), 4.0, "\"AQAAAQAAAAFREA==\""}, (Object)new Object[]{CalciteSelectQueryTest.timestamp("2001-01-02"), "def", "abc", null, 1L, Float.valueOf(5.0f), 5.0, "\"AQAAAQAAAACyEA==\""}, (Object)new Object[]{CalciteSelectQueryTest.timestamp("2001-01-03"), "abc", null, null, 1L, Float.valueOf(6.0f), 6.0, "\"AQAAAQAAAAEkAQ==\""}));
    }

    @Test
    public void testCountRestrictedTable_shouldFilterOnPolicy() {
        this.testQuery(PLANNER_CONFIG_DEFAULT, "SELECT COUNT(*) FROM druid.restrictedDatasource_m1_is_6", CalciteTests.SUPER_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)RestrictedDataSource.create((DataSource)TableDataSource.create((String)"restrictedDatasource_m1_is_6"), (Policy)CalciteTests.POLICY_NO_RESTRICTION_SUPERUSER)).intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteSelectQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}));
        this.testQuery(PLANNER_CONFIG_DEFAULT, "SELECT COUNT(*) FROM druid.restrictedDatasource_m1_is_6", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)RestrictedDataSource.create((DataSource)TableDataSource.create((String)"restrictedDatasource_m1_is_6"), (Policy)CalciteTests.POLICY_RESTRICTION)).intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteSelectQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1L}));
    }

    @Test
    public void testSelectStarOnForbiddenTable() {
        this.assertQueryIsForbidden("SELECT * FROM druid.forbiddenDatasource", CalciteTests.REGULAR_USER_AUTH_RESULT);
        this.testQuery(PLANNER_CONFIG_DEFAULT, "SELECT * FROM druid.forbiddenDatasource", CalciteTests.SUPER_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("forbiddenDatasource").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "dim1", "dim2", "cnt", "m1", "m2", "unique_dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.STRING, ColumnType.LONG, ColumnType.FLOAT, ColumnType.DOUBLE, ColumnType.ofComplex((String)"hyperUnique")}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteSelectQueryTest.timestamp("2000-01-01"), "forbidden", "abcd", 1L, Float.valueOf(9999.0f), null, "\"AQAAAQAAAALFBA==\""}, (Object)new Object[]{CalciteSelectQueryTest.timestamp("2000-01-02"), "forbidden", "a", 1L, Float.valueOf(1234.0f), null, "\"AQAAAQAAAALFBA==\""}));
    }

    @Test
    public void testSelectStarOnForbiddenView() {
        this.assertQueryIsForbidden("SELECT * FROM view.forbiddenView", CalciteTests.REGULAR_USER_AUTH_RESULT);
        this.testQuery(PLANNER_CONFIG_DEFAULT, "SELECT * FROM view.forbiddenView", CalciteTests.SUPER_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteSelectQueryTest.expressionVirtualColumn("v0", "substring(\"dim1\", 0, 1)", ColumnType.STRING), CalciteSelectQueryTest.expressionVirtualColumn("v1", "'a'", ColumnType.STRING)}).filters(CalciteSelectQueryTest.equality("dim2", "a", ColumnType.STRING)).columns(new String[]{"__time", "v0", "v1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteSelectQueryTest.timestamp("2000-01-01"), null, "a"}, (Object)new Object[]{CalciteSelectQueryTest.timestamp("2001-01-01"), "1", "a"}));
    }

    @Test
    public void testSelectStarOnRestrictedView() {
        this.testQuery(PLANNER_CONFIG_DEFAULT, "SELECT * FROM view.restrictedView", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("forbiddenDatasource").filters(CalciteSelectQueryTest.equality("dim2", "a", ColumnType.STRING)).intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "dim1", "dim2", "m1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.STRING, ColumnType.FLOAT}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteSelectQueryTest.timestamp("2000-01-02"), "forbidden", "a", Float.valueOf(1234.0f)}));
        this.testQuery(PLANNER_CONFIG_DEFAULT, "SELECT * FROM view.restrictedView", CalciteTests.SUPER_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("forbiddenDatasource").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).filters(CalciteSelectQueryTest.equality("dim2", "a", ColumnType.STRING)).columns(new String[]{"__time", "dim1", "dim2", "m1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.STRING, ColumnType.FLOAT}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteSelectQueryTest.timestamp("2000-01-02"), "forbidden", "a", Float.valueOf(1234.0f)}));
    }

    @Test
    public void testUnqualifiedTableName() {
        this.testQuery("SELECT COUNT(*) FROM foo", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteSelectQueryTest.aggregators(new AggregatorFactory[]{new CountAggregatorFactory("a0")})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}));
    }

    @Test
    public void testExplainSelectStar() {
        this.skipVectorize();
        String query = "EXPLAIN PLAN FOR SELECT * FROM druid.foo";
        String explanation = "[{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"resultFormat\":\"compactedList\",\"columns\":[\"__time\",\"dim1\",\"dim2\",\"dim3\",\"cnt\",\"m1\",\"m2\",\"unique_dim1\"],\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"columnTypes\":[\"LONG\",\"STRING\",\"STRING\",\"STRING\",\"LONG\",\"FLOAT\",\"DOUBLE\",\"COMPLEX<hyperUnique>\"],\"granularity\":{\"type\":\"all\"},\"legacy\":false},\"signature\":[{\"name\":\"__time\",\"type\":\"LONG\"},{\"name\":\"dim1\",\"type\":\"STRING\"},{\"name\":\"dim2\",\"type\":\"STRING\"},{\"name\":\"dim3\",\"type\":\"STRING\"},{\"name\":\"cnt\",\"type\":\"LONG\"},{\"name\":\"m1\",\"type\":\"FLOAT\"},{\"name\":\"m2\",\"type\":\"DOUBLE\"},{\"name\":\"unique_dim1\",\"type\":\"COMPLEX<hyperUnique>\"}],\"columnMappings\":[{\"queryColumn\":\"__time\",\"outputColumn\":\"__time\"},{\"queryColumn\":\"dim1\",\"outputColumn\":\"dim1\"},{\"queryColumn\":\"dim2\",\"outputColumn\":\"dim2\"},{\"queryColumn\":\"dim3\",\"outputColumn\":\"dim3\"},{\"queryColumn\":\"cnt\",\"outputColumn\":\"cnt\"},{\"queryColumn\":\"m1\",\"outputColumn\":\"m1\"},{\"queryColumn\":\"m2\",\"outputColumn\":\"m2\"},{\"queryColumn\":\"unique_dim1\",\"outputColumn\":\"unique_dim1\"}]}]";
        String resources = "[{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]";
        String attributes = "{\"statementType\":\"SELECT\"}";
        this.testQuery(PLANNER_CONFIG_NATIVE_QUERY_EXPLAIN, "EXPLAIN PLAN FOR SELECT * FROM druid.foo", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of((Object)new Object[]{"[{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"resultFormat\":\"compactedList\",\"columns\":[\"__time\",\"dim1\",\"dim2\",\"dim3\",\"cnt\",\"m1\",\"m2\",\"unique_dim1\"],\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"columnTypes\":[\"LONG\",\"STRING\",\"STRING\",\"STRING\",\"LONG\",\"FLOAT\",\"DOUBLE\",\"COMPLEX<hyperUnique>\"],\"granularity\":{\"type\":\"all\"},\"legacy\":false},\"signature\":[{\"name\":\"__time\",\"type\":\"LONG\"},{\"name\":\"dim1\",\"type\":\"STRING\"},{\"name\":\"dim2\",\"type\":\"STRING\"},{\"name\":\"dim3\",\"type\":\"STRING\"},{\"name\":\"cnt\",\"type\":\"LONG\"},{\"name\":\"m1\",\"type\":\"FLOAT\"},{\"name\":\"m2\",\"type\":\"DOUBLE\"},{\"name\":\"unique_dim1\",\"type\":\"COMPLEX<hyperUnique>\"}],\"columnMappings\":[{\"queryColumn\":\"__time\",\"outputColumn\":\"__time\"},{\"queryColumn\":\"dim1\",\"outputColumn\":\"dim1\"},{\"queryColumn\":\"dim2\",\"outputColumn\":\"dim2\"},{\"queryColumn\":\"dim3\",\"outputColumn\":\"dim3\"},{\"queryColumn\":\"cnt\",\"outputColumn\":\"cnt\"},{\"queryColumn\":\"m1\",\"outputColumn\":\"m1\"},{\"queryColumn\":\"m2\",\"outputColumn\":\"m2\"},{\"queryColumn\":\"unique_dim1\",\"outputColumn\":\"unique_dim1\"}]}]", "[{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]", "{\"statementType\":\"SELECT\"}"}));
    }

    @Test
    public void testSelectStarWithLimit() {
        this.testQuery(PLANNER_CONFIG_DEFAULT, QUERY_CONTEXT_DEFAULT, "SELECT * FROM druid.foo LIMIT 2", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "dim1", "dim2", "dim3", "cnt", "m1", "m2", "unique_dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.LONG, ColumnType.FLOAT, ColumnType.DOUBLE, ColumnType.ofComplex((String)"hyperUnique")}).limit(2L).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteSelectQueryTest.timestamp("2000-01-01"), "", "a", "[\"a\",\"b\"]", 1L, Float.valueOf(1.0f), 1.0, "\"AQAAAEAAAA==\""}, (Object)new Object[]{CalciteSelectQueryTest.timestamp("2000-01-02"), "10.1", null, "[\"b\",\"c\"]", 1L, Float.valueOf(2.0f), 2.0, "\"AQAAAQAAAAHNBA==\""}));
    }

    @Test
    public void testSelectStarWithLimitAndOffset() {
        this.testQuery(PLANNER_CONFIG_DEFAULT, QUERY_CONTEXT_DEFAULT, "SELECT * FROM druid.foo LIMIT 2 OFFSET 1", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "dim1", "dim2", "dim3", "cnt", "m1", "m2", "unique_dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.LONG, ColumnType.FLOAT, ColumnType.DOUBLE, ColumnType.ofComplex((String)"hyperUnique")}).offset(1L).limit(2L).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteSelectQueryTest.timestamp("2000-01-02"), "10.1", null, "[\"b\",\"c\"]", 1L, Float.valueOf(2.0f), 2.0, "\"AQAAAQAAAAHNBA==\""}, (Object)new Object[]{CalciteSelectQueryTest.timestamp("2000-01-03"), "2", "", "d", 1L, Float.valueOf(3.0f), 3.0, "\"AQAAAQAAAAOzAg==\""}));
    }

    @Test
    public void testSelectWithProjection() {
        this.testQuery("SELECT SUBSTRING(dim2, 1, 1) FROM druid.foo LIMIT 2", (List<Query<?>>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteSelectQueryTest.expressionVirtualColumn("v0", "substring(\"dim2\", 0, 1)", ColumnType.STRING)}).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.STRING}).limit(2L).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a"}, (Object)new Object[]{null}));
    }

    @Test
    public void testSelectWithExpressionFilter() {
        this.testQuery("SELECT dim1 FROM druid.foo WHERE m1 + 1 = 7", (List<Query<?>>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteSelectQueryTest.expressionVirtualColumn("v0", "(\"m1\" + 1)", ColumnType.FLOAT)}).filters(CalciteSelectQueryTest.equality("v0", 7.0, ColumnType.FLOAT)).columns(new String[]{"dim1"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc"}));
    }

    @Test
    public void testSelectStarWithLimitTimeDescending() {
        this.testQuery(PLANNER_CONFIG_DEFAULT, QUERY_CONTEXT_DEFAULT, "SELECT * FROM druid.foo ORDER BY __time DESC LIMIT 2", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "dim1", "dim2", "dim3", "cnt", "m1", "m2", "unique_dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.LONG, ColumnType.FLOAT, ColumnType.DOUBLE, ColumnType.ofComplex((String)"hyperUnique")}).limit(2L).order(Order.DESCENDING).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteSelectQueryTest.timestamp("2001-01-03"), "abc", null, null, 1L, Float.valueOf(6.0f), 6.0, "\"AQAAAQAAAAEkAQ==\""}, (Object)new Object[]{CalciteSelectQueryTest.timestamp("2001-01-02"), "def", "abc", null, 1L, Float.valueOf(5.0f), 5.0, "\"AQAAAQAAAACyEA==\""}));
    }

    @Test
    public void testSelectStarWithoutLimitTimeAscending() {
        this.testQuery(PLANNER_CONFIG_DEFAULT, QUERY_CONTEXT_DEFAULT, "SELECT * FROM druid.foo ORDER BY __time", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "dim1", "dim2", "dim3", "cnt", "m1", "m2", "unique_dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.LONG, ColumnType.FLOAT, ColumnType.DOUBLE, ColumnType.ofComplex((String)"hyperUnique")}).limit(Long.MAX_VALUE).order(Order.ASCENDING).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{CalciteSelectQueryTest.timestamp("2000-01-01"), "", "a", "[\"a\",\"b\"]", 1L, Float.valueOf(1.0f), 1.0, "\"AQAAAEAAAA==\""}, (Object)new Object[]{CalciteSelectQueryTest.timestamp("2000-01-02"), "10.1", null, "[\"b\",\"c\"]", 1L, Float.valueOf(2.0f), 2.0, "\"AQAAAQAAAAHNBA==\""}, (Object)new Object[]{CalciteSelectQueryTest.timestamp("2000-01-03"), "2", "", "d", 1L, Float.valueOf(3.0f), 3.0, "\"AQAAAQAAAAOzAg==\""}, (Object)new Object[]{CalciteSelectQueryTest.timestamp("2001-01-01"), "1", "a", "", 1L, Float.valueOf(4.0f), 4.0, "\"AQAAAQAAAAFREA==\""}, (Object)new Object[]{CalciteSelectQueryTest.timestamp("2001-01-02"), "def", "abc", null, 1L, Float.valueOf(5.0f), 5.0, "\"AQAAAQAAAACyEA==\""}, (Object)new Object[]{CalciteSelectQueryTest.timestamp("2001-01-03"), "abc", null, null, 1L, Float.valueOf(6.0f), 6.0, "\"AQAAAQAAAAEkAQ==\""}));
    }

    @Test
    public void testSelectSingleColumnTwice() {
        this.testQuery("SELECT dim2 x, dim2 y FROM druid.foo LIMIT 2", (List<Query<?>>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim2"}).columnTypes(new ColumnType[]{ColumnType.STRING}).limit(2L).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a", "a"}, (Object)new Object[]{null, null}));
    }

    @Test
    public void testSelectSingleColumnWithLimitDescending() {
        this.testQuery("SELECT dim1 FROM druid.foo ORDER BY __time DESC LIMIT 2", (List<Query<?>>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1", "__time"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.LONG}).limit(2L).order(Order.DESCENDING).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc"}, (Object)new Object[]{"def"}));
    }

    @Test
    public void testSelectStarFromSelectSingleColumnWithLimitDescending() {
        this.testQuery("SELECT * FROM (SELECT dim1 FROM druid.foo ORDER BY __time DESC) LIMIT 2", (List<Query<?>>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1"}).columnTypes(new ColumnType[]{ColumnType.STRING}).limit(2L).order(Order.NONE).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{""}, (Object)new Object[]{"10.1"}));
    }

    @Test
    public void testSelectLimitWrapping() {
        this.testQuery("SELECT dim1 FROM druid.foo ORDER BY __time DESC", (Map<String, Object>)OUTER_LIMIT_CONTEXT, (List<Query<?>>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1", "__time"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.LONG}).limit(2L).order(Order.DESCENDING).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(OUTER_LIMIT_CONTEXT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc"}, (Object)new Object[]{"def"}));
    }

    @Test
    public void testSelectLimitWrappingOnTopOfOffset() {
        this.testQuery("SELECT dim1 FROM druid.foo ORDER BY __time DESC OFFSET 1", (Map<String, Object>)OUTER_LIMIT_CONTEXT, (List<Query<?>>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1", "__time"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.LONG}).offset(1L).limit(2L).order(Order.DESCENDING).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(OUTER_LIMIT_CONTEXT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"def"}, (Object)new Object[]{"1"}));
    }

    @Test
    public void testSelectLimitWrappingOnTopOfOffsetAndLowLimit() {
        this.testQuery("SELECT dim1 FROM druid.foo ORDER BY __time DESC LIMIT 1 OFFSET 1", (Map<String, Object>)OUTER_LIMIT_CONTEXT, (List<Query<?>>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1", "__time"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.LONG}).offset(1L).limit(1L).order(Order.DESCENDING).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(OUTER_LIMIT_CONTEXT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"def"}));
    }

    @Test
    public void testSelectLimitWrappingOnTopOfOffsetAndHighLimit() {
        this.testQuery("SELECT dim1 FROM druid.foo ORDER BY __time DESC LIMIT 10 OFFSET 1", (Map<String, Object>)OUTER_LIMIT_CONTEXT, (List<Query<?>>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1", "__time"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.LONG}).offset(1L).limit(2L).order(Order.DESCENDING).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(OUTER_LIMIT_CONTEXT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"def"}, (Object)new Object[]{"1"}));
    }

    @Test
    public void testSelectLimitWrappingAgainAkaIDontReallyQuiteUnderstandCalciteQueryPlanning() {
        this.testQuery("SELECT \"__time\", \"count\", \"dimHyperUnique\", \"dimMultivalEnumerated\", \"dimMultivalEnumerated2\", \"dimMultivalSequentialWithNulls\", \"dimSequential\", \"dimSequentialHalfNull\", \"dimUniform\", \"dimZipf\", \"metFloatNormal\", \"metFloatZipf\", \"metLongSequential\" FROM druid.lotsocolumns WHERE __time >= CURRENT_TIMESTAMP - INTERVAL '10' YEAR", (Map<String, Object>)OUTER_LIMIT_CONTEXT, (List<Query<?>>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("lotsocolumns").intervals(CalciteSelectQueryTest.querySegmentSpec(Intervals.of((String)"1990-01-01T00:00:00.000Z/146140482-04-24T15:36:27.903Z"))).columns(new String[]{"__time", "count", "dimHyperUnique", "dimMultivalEnumerated", "dimMultivalEnumerated2", "dimMultivalSequentialWithNulls", "dimSequential", "dimSequentialHalfNull", "dimUniform", "dimZipf", "metFloatNormal", "metFloatZipf", "metLongSequential"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.LONG, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING}).limit(2L).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(OUTER_LIMIT_CONTEXT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1576306800000L, 1L, "0", "[\"Baz\",\"Baz\",\"Hello\",\"World\"]", "[null,\"Apple\",\"Orange\"]", "[\"1\",\"2\",\"3\",\"4\",\"5\",\"6\",\"7\",\"8\"]", "0", "0", "74416", "27", "5000.0", "147.0", "0"}, (Object)new Object[]{1576306800000L, 1L, "8", "[\"Baz\",\"World\",\"\u3151 \u3153 \u3155 \u3157 \u315b \u315c \u3160 \u3161 \u3163\"]", "[null,\"Corundum\",\"Xylophone\"]", null, "8", null, "50515", "9", "4999.0", "25.0", "8"}));
        this.testQuery("SELECT \"__time\", \"count\", \"dimHyperUnique\", \"dimMultivalEnumerated\", \"dimMultivalEnumerated2\", \"dimMultivalSequentialWithNulls\", \"dimSequential\", \"dimSequentialHalfNull\", \"dimUniform\", \"dimZipf\", \"metFloatNormal\", \"metFloatZipf\", \"metLongSequential\", \"metLongUniform\" FROM druid.lotsocolumns WHERE __time >= CURRENT_TIMESTAMP - INTERVAL '10' YEAR", (Map<String, Object>)OUTER_LIMIT_CONTEXT, (List<Query<?>>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("lotsocolumns").intervals(CalciteSelectQueryTest.querySegmentSpec(Intervals.of((String)"1990-01-01T00:00:00.000Z/146140482-04-24T15:36:27.903Z"))).columns(new String[]{"__time", "count", "dimHyperUnique", "dimMultivalEnumerated", "dimMultivalEnumerated2", "dimMultivalSequentialWithNulls", "dimSequential", "dimSequentialHalfNull", "dimUniform", "dimZipf", "metFloatNormal", "metFloatZipf", "metLongSequential", "metLongUniform"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.LONG, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING}).limit(2L).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(OUTER_LIMIT_CONTEXT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{1576306800000L, 1L, "0", "[\"Baz\",\"Baz\",\"Hello\",\"World\"]", "[null,\"Apple\",\"Orange\"]", "[\"1\",\"2\",\"3\",\"4\",\"5\",\"6\",\"7\",\"8\"]", "0", "0", "74416", "27", "5000.0", "147.0", "0", "372"}, (Object)new Object[]{1576306800000L, 1L, "8", "[\"Baz\",\"World\",\"\u3151 \u3153 \u3155 \u3157 \u315b \u315c \u3160 \u3161 \u3163\"]", "[null,\"Corundum\",\"Xylophone\"]", null, "8", null, "50515", "9", "4999.0", "25.0", "8", "252"}));
    }

    @Test
    public void testSelectProjectionFromSelectSingleColumnWithInnerLimitDescending() {
        this.testQuery("SELECT 'beep ' || dim1 FROM (SELECT dim1 FROM druid.foo ORDER BY __time DESC LIMIT 2)", (List<Query<?>>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteSelectQueryTest.expressionVirtualColumn("v0", "concat('beep ',\"dim1\")", ColumnType.STRING)}).columns(new String[]{"v0", "__time"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING}).limit(2L).order(Order.DESCENDING).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"beep abc"}, (Object)new Object[]{"beep def"}));
    }

    @Test
    public void testSelectProjectionFromSelectSingleColumnDescending() {
        this.testQuery("SELECT 'beep ' || dim1 FROM (SELECT dim1 FROM druid.foo ORDER BY __time DESC)", (List<Query<?>>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteSelectQueryTest.expressionVirtualColumn("v0", "concat('beep ',\"dim1\")", ColumnType.STRING)}).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.STRING}).order(Order.NONE).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"beep "}, (Object)new Object[]{"beep 10.1"}, (Object)new Object[]{"beep 2"}, (Object)new Object[]{"beep 1"}, (Object)new Object[]{"beep def"}, (Object)new Object[]{"beep abc"}));
    }

    @Test
    public void testSelectProjectionFromSelectSingleColumnWithInnerAndOuterLimitDescending() {
        this.testQuery("SELECT 'beep ' || dim1 FROM (SELECT dim1 FROM druid.foo ORDER BY __time DESC LIMIT 4) LIMIT 2", (List<Query<?>>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteSelectQueryTest.expressionVirtualColumn("v0", "concat('beep ',\"dim1\")", ColumnType.STRING)}).columns(new String[]{"v0", "__time"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING}).limit(2L).order(Order.DESCENDING).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"beep abc"}, (Object)new Object[]{"beep def"}));
    }

    @Test
    public void testOrderThenLimitThenFilter() {
        this.testQuery("SELECT dim1 FROM (SELECT __time, dim1 FROM druid.foo ORDER BY __time DESC LIMIT 4) WHERE dim1 IN ('abc', 'def')", (List<Query<?>>)ImmutableList.of((Object)CalciteSelectQueryTest.newScanQueryBuilder().dataSource((DataSource)new QueryDataSource((Query)CalciteSelectQueryTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING}).limit(4L).order(Order.DESCENDING).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build())).intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim1"}).columnTypes(new ColumnType[]{ColumnType.STRING}).filters(CalciteSelectQueryTest.in("dim1", Arrays.asList("abc", "def"))).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{"abc"}, (Object)new Object[]{"def"}));
    }

    @Test
    public void testAggregateFilterInTheAbsenceOfProjection() {
        this.cannotVectorize();
        this.testQuery("select count(1) filter (where __time > date '2023-01-01')  from druid.foo where 'a' = 'b'", (List<Query<?>>)ImmutableList.of((Object)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of(), (RowSignature)RowSignature.builder().add("$f1", ColumnType.LONG).build())).intervals(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).granularity(Granularities.ALL).aggregators(CalciteSelectQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), (DimFilter)CalciteSelectQueryTest.expressionFilter("\"$f1\""))})).context(QUERY_CONTEXT_DEFAULT).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{0L}));
    }

    @Test
    public void testCountDistinctNonApproximateEmptySet() {
        this.testQuery(PLANNER_CONFIG_DEFAULT.withOverrides((Map)ImmutableMap.of((Object)"useApproximateCountDistinct", (Object)false)), "select count(distinct m1) from druid.foo where m1 < -1.0", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteSelectQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("m1", "d0", ColumnType.FLOAT)})).setDimFilter(CalciteSelectQueryTest.range("m1", ColumnType.DOUBLE, null, -1.0, false, true)).build()).setInterval(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteSelectQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), CalciteSelectQueryTest.notNull("d0"))})).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{0L}));
    }

    @Test
    public void testCountDistinctNonApproximateBasic() {
        this.testQuery(PLANNER_CONFIG_DEFAULT.withOverrides((Map)ImmutableMap.of((Object)"useApproximateCountDistinct", (Object)false)), "select count(distinct m1) from druid.foo where m1 < 111.0", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteSelectQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("m1", "d0", ColumnType.FLOAT)})).setDimFilter(CalciteSelectQueryTest.range("m1", ColumnType.DOUBLE, null, 111.0, false, true)).build()).setInterval(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteSelectQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), CalciteSelectQueryTest.notNull("d0"))})).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{6L}));
    }

    @Test
    public void testCountDistinctNonApproximateWithFilter() {
        this.cannotVectorizeUnlessFallback();
        this.testQuery(PLANNER_CONFIG_DEFAULT.withOverrides((Map)ImmutableMap.of((Object)"useApproximateCountDistinct", (Object)false)), "select count(distinct m1) FILTER (where m1 < -1.0) from druid.foo", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteSelectQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.FLOAT)})).setVirtualColumns(new VirtualColumn[]{CalciteSelectQueryTest.expressionVirtualColumn("v0", "case_searched((\"m1\" < -1.0),\"m1\",null)", ColumnType.FLOAT)}).build()).setInterval(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(CalciteSelectQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), CalciteSelectQueryTest.notNull("d0"))})).build()), (List<Object[]>)ImmutableList.of((Object)new Object[]{0L}));
    }

    @Test
    public void testCountDistinctNonApproximateWithFilterHaving() {
        this.cannotVectorizeUnlessFallback();
        this.testQuery(PLANNER_CONFIG_DEFAULT.withOverrides((Map)ImmutableMap.of((Object)"useApproximateCountDistinct", (Object)false)), "select count(distinct m1) FILTER (where m1 < -1.0) c from druid.foo HAVING c > 3", CalciteTests.REGULAR_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of((Object)GroupByQuery.builder().setDataSource((Query)GroupByQuery.builder().setDataSource("foo").setInterval(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteSelectQueryTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("v0", "d0", ColumnType.FLOAT)})).setVirtualColumns(new VirtualColumn[]{CalciteSelectQueryTest.expressionVirtualColumn("v0", "case_searched((\"m1\" < -1.0),\"m1\",null)", ColumnType.FLOAT)}).build()).setInterval(CalciteSelectQueryTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setHavingSpec((HavingSpec)CalciteSelectQueryTest.having(CalciteSelectQueryTest.range("a0", ColumnType.LONG, 3L, null, true, false))).setAggregatorSpecs(CalciteSelectQueryTest.aggregators(new AggregatorFactory[]{new FilteredAggregatorFactory((AggregatorFactory)new CountAggregatorFactory("a0"), CalciteSelectQueryTest.notNull("d0"))})).build()), (List<Object[]>)ImmutableList.of());
    }

    @SqlTestFrameworkConfig.ResultCache(value=CacheTestHelperModule.ResultCacheMode.ENABLED)
    @Test
    public void testCacheKeyConsistency() {
        this.skipVectorize();
        this.testBuilder().sql("select dim1,dbl1 from numfoo where 0.0 < dbl1 and dbl1 < 1.25 group by dim1,dbl1").expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{"", 1.0})).run();
        this.testBuilder().sql("select dim1,dbl1 from numfoo where 0.0 < dbl1 and dbl1 < 1.75 group by dim1,dbl1").expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{"", 1.0}, (Object)new Object[]{"10.1", 1.7})).run();
    }

    @SqlTestFrameworkConfig.ResultCache(value=CacheTestHelperModule.ResultCacheMode.ENABLED)
    @Test
    public void testTimseriesResultCachePullConsistency() {
        this.skipVectorize();
        String query = "SELECT \n  (t1.\"__time\") AS \"__time\", \n  (ANY_VALUE(t1.\"added\")) AS \"added\" \nFROM \n  (\n    SELECT \n      (time_floor(\"__time\", 'PT1H')) AS \"__time\", \n      (SUM(added)) AS \"added\" \n    FROM \"wikipedia\" \n    GROUP BY 1 \n    ORDER BY \"__time\" \n    LIMIT 1\n  ) t1 \nGROUP BY 1 \nORDER BY \"__time\"";
        this.testBuilder().sql(query).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{1442016000000L, 32251L})).run();
        this.testBuilder().sql(query).expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{1442016000000L, 32251L})).run();
    }

    @Test
    public void testSqlToRelInConversion() {
        Assertions.assertEquals((Object)"1.37.0", (Object)RelNode.class.getPackage().getImplementationVersion(), (String)"Calcite version changed; check if CALCITE-6435 is fixed and remove:\n * method CalciteRulesManager#sqlToRelWorkaroundProgram\n * FixIncorrectInExpansionTypes class\n* this assertion");
        this.testBuilder().sql("SELECT channel FROM wikipedia\nWHERE channel in ('#en.wikipedia') and channel = '#en.wikipedia' and\nisRobot = 'false'\nLIMIT 1").expectedResults((List<Object[]>)ImmutableList.of((Object)new Object[]{"#en.wikipedia"})).run();
    }

    @Test
    public void testRejectHavingWithWindowExpression() {
        Assertions.assertEquals((Object)"1.37.0", (Object)RelNode.class.getPackage().getImplementationVersion(), (String)"Calcite version changed; check if CALCITE-6473 is fixed and remove:\n * this assertion\n * DruidSqlValidator#validateHavingClause");
        this.testQueryThrows("SELECT cityName,sum(1) OVER () as w FROM wikipedia group by cityName HAVING w > 10", DruidException.class, (Matcher<Throwable>)CalciteSelectQueryTest.invalidSqlContains("Window functions are not allowed in HAVING"));
    }
}

