/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.impl.CsvInputFormat;
import org.apache.druid.data.input.impl.InlineInputSource;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.DruidExceptionMatcher;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.GranularityType;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.OrderBy;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.join.JoinType;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.sql.calcite.BaseCalciteQueryTest;
import org.apache.druid.sql.calcite.CalciteIngestionDmlTest;
import org.apache.druid.sql.calcite.external.ExternalDataSource;
import org.apache.druid.sql.calcite.external.Externals;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.jupiter.api.Test;

public class CalciteInsertDmlTest
extends CalciteIngestionDmlTest {
    protected static final Map<String, Object> PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT = ImmutableMap.of((Object)"sqlInsertSegmentGranularity", (Object)"{\"type\":\"all\"}");

    @Test
    public void testInsertFromTable() {
        this.testIngestionQuery().sql("INSERT INTO dst SELECT * FROM foo PARTITIONED BY ALL TIME").expectTarget("dst", FOO_TABLE_SIGNATURE).expectResources(CalciteInsertDmlTest.dataSourceRead("foo"), CalciteInsertDmlTest.dataSourceWrite("dst")).expectQuery((Query)CalciteInsertDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteInsertDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "dim1", "dim2", "dim3", "cnt", "m1", "m2", "unique_dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.LONG, ColumnType.FLOAT, ColumnType.DOUBLE, ColumnType.ofComplex((String)"hyperUnique")}).context(PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).verify();
    }

    @Test
    public void testInsertFromViewA() {
        this.testIngestionQuery().sql("INSERT INTO dst SELECT * FROM view.aview PARTITIONED BY ALL TIME").expectTarget("dst", RowSignature.builder().add("dim1_firstchar", ColumnType.STRING).build()).expectResources(CalciteInsertDmlTest.viewRead("aview"), CalciteInsertDmlTest.dataSourceWrite("dst")).expectQuery((Query)CalciteInsertDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteInsertDmlTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteInsertDmlTest.expressionVirtualColumn("v0", "substring(\"dim1\", 0, 1)", ColumnType.STRING)}).filters(CalciteInsertDmlTest.equality("dim2", "a", ColumnType.STRING)).columns(new String[]{"v0"}).columnTypes(new ColumnType[]{ColumnType.STRING}).context(PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).verify();
    }

    @Test
    public void testInsertFromViewC() {
        RowSignature expectedSignature = RowSignature.builder().add("dim1_firstchar", ColumnType.STRING).add("dim2", ColumnType.STRING).add("l2", ColumnType.LONG).build();
        this.testIngestionQuery().sql("INSERT INTO dst SELECT * FROM view.cview PARTITIONED BY ALL TIME").expectTarget("dst", expectedSignature).expectResources(CalciteInsertDmlTest.viewRead("cview"), CalciteInsertDmlTest.dataSourceWrite("dst")).expectQuery((Query)CalciteInsertDmlTest.newScanQueryBuilder().dataSource((DataSource)CalciteInsertDmlTest.join((DataSource)new QueryDataSource((Query)CalciteInsertDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteInsertDmlTest.querySegmentSpec(Filtration.eternity())).filters(CalciteInsertDmlTest.equality("dim2", "a", ColumnType.STRING)).columns(new String[]{"dim1", "dim2"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING}).context(PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()), (DataSource)new QueryDataSource((Query)CalciteInsertDmlTest.newScanQueryBuilder().dataSource("numfoo").intervals(CalciteInsertDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim2", "l2"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.LONG}).context(PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()), "j0.", "(\"dim2\" == \"j0.dim2\")", JoinType.INNER)).intervals(CalciteInsertDmlTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteInsertDmlTest.expressionVirtualColumn("v0", "substring(\"dim1\", 0, 1)", ColumnType.STRING), CalciteInsertDmlTest.expressionVirtualColumn("v1", "'a'", ColumnType.STRING)}).columns(new String[]{"v0", "v1", "j0.l2"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.LONG}).context(PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).verify();
    }

    @Test
    public void testInsertIntoExistingTable() {
        this.testIngestionQuery().sql("INSERT INTO foo SELECT * FROM foo PARTITIONED BY ALL TIME").expectTarget("foo", FOO_TABLE_SIGNATURE).expectResources(CalciteInsertDmlTest.dataSourceRead("foo"), CalciteInsertDmlTest.dataSourceWrite("foo")).expectQuery((Query)CalciteInsertDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteInsertDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "dim1", "dim2", "dim3", "cnt", "m1", "m2", "unique_dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.LONG, ColumnType.FLOAT, ColumnType.DOUBLE, ColumnType.ofComplex((String)"hyperUnique")}).context(PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).verify();
    }

    @Test
    public void testInsertIntoQualifiedTable() {
        this.testIngestionQuery().sql("INSERT INTO druid.dst SELECT * FROM foo PARTITIONED BY ALL TIME").expectTarget("dst", FOO_TABLE_SIGNATURE).expectResources(CalciteInsertDmlTest.dataSourceRead("foo"), CalciteInsertDmlTest.dataSourceWrite("dst")).expectQuery((Query)CalciteInsertDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteInsertDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "dim1", "dim2", "dim3", "cnt", "m1", "m2", "unique_dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.STRING, ColumnType.STRING, ColumnType.LONG, ColumnType.FLOAT, ColumnType.DOUBLE, ColumnType.ofComplex((String)"hyperUnique")}).context(PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).verify();
    }

    @Test
    public void testInsertIntoInvalidDataSourceName() {
        this.testIngestionQuery().sql("INSERT INTO \"in/valid\" SELECT dim1, dim2 FROM foo PARTITIONED BY ALL TIME").expectValidationError((Matcher<Throwable>)DruidExceptionMatcher.invalidInput().expectMessageIs("Invalid value for field [table]: Value [in/valid] cannot contain '/'.")).verify();
    }

    @Test
    public void testInsertUsingColumnList() {
        this.testIngestionQuery().sql("INSERT INTO dst (foo, bar) SELECT dim1, dim2 FROM foo PARTITIONED BY ALL TIME").expectValidationError((Matcher<Throwable>)CalciteInsertDmlTest.invalidSqlIs("Operation [INSERT] cannot be run with a target column list, given [dst (`foo`, `bar`)]")).verify();
    }

    @Test
    public void testUpsert() {
        this.testIngestionQuery().sql("UPSERT INTO dst SELECT * FROM foo PARTITIONED BY ALL TIME").expectValidationError((Matcher<Throwable>)CalciteInsertDmlTest.invalidSqlIs("UPSERT is not supported.")).verify();
    }

    @Test
    public void testSelectFromSystemTable() {
        this.testIngestionQuery().sql("INSERT INTO dst SELECT * FROM INFORMATION_SCHEMA.COLUMNS PARTITIONED BY ALL TIME").expectValidationError(DruidException.class, "Cannot query table(s) [INFORMATION_SCHEMA.COLUMNS] with SQL engine [ingestion-test]").verify();
    }

    @Test
    public void testInsertIntoSystemTable() {
        this.testIngestionQuery().sql("INSERT INTO INFORMATION_SCHEMA.COLUMNS SELECT * FROM foo PARTITIONED BY ALL TIME").expectValidationError((Matcher<Throwable>)CalciteInsertDmlTest.invalidSqlIs("Table [INFORMATION_SCHEMA.COLUMNS] does not support operation [INSERT] because it is not a Druid datasource")).verify();
    }

    @Test
    public void testInsertIntoView() {
        this.testIngestionQuery().sql("INSERT INTO view.aview SELECT * FROM foo PARTITIONED BY ALL TIME").expectValidationError((Matcher<Throwable>)CalciteInsertDmlTest.invalidSqlIs("Table [view.aview] does not support operation [INSERT] because it is not a Druid datasource")).verify();
    }

    @Test
    public void testInsertFromUnauthorizedDataSource() {
        this.testIngestionQuery().sql("INSERT INTO dst SELECT * FROM \"%s\" PARTITIONED BY ALL TIME", "forbiddenDatasource", new Object[0]).expectValidationError(ForbiddenException.class).verify();
    }

    @Test
    public void testInsertIntoUnauthorizedDataSource() {
        this.testIngestionQuery().sql("INSERT INTO \"%s\" SELECT * FROM foo PARTITIONED BY ALL TIME", "forbiddenDatasource", new Object[0]).expectValidationError(ForbiddenException.class).verify();
    }

    @Test
    public void testInsertIntoNonexistentSchema() {
        this.testIngestionQuery().sql("INSERT INTO nonexistent.dst SELECT * FROM foo PARTITIONED BY ALL TIME").expectValidationError((Matcher<Throwable>)CalciteInsertDmlTest.invalidSqlIs("Table [nonexistent.dst] does not support operation [INSERT] because it is not a Druid datasource")).verify();
    }

    @Test
    public void testInsertFromExternal() {
        this.testIngestionQuery().sql("INSERT INTO dst SELECT * FROM %s PARTITIONED BY ALL TIME", this.externSql(this.externalDataSource), new Object[0]).authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("dst", this.externalDataSource.getSignature()).expectResources(CalciteInsertDmlTest.dataSourceWrite("dst"), Externals.EXTERNAL_RESOURCE_ACTION).expectQuery((Query)CalciteInsertDmlTest.newScanQueryBuilder().dataSource((DataSource)this.externalDataSource).intervals(CalciteInsertDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"x", "y", "z"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.LONG}).context(PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).expectLogicalPlanFrom("insertFromExternal").verify();
    }

    @Test
    public void testInsertFromExternalWithInputSourceSecurityEnabled() {
        this.testIngestionQuery().sql("INSERT INTO dst SELECT * FROM %s PARTITIONED BY ALL TIME", this.externSql(this.externalDataSource), new Object[0]).authentication(CalciteTests.SUPER_USER_AUTH_RESULT).authConfig(AuthConfig.newBuilder().setEnableInputSourceSecurity(true).build()).expectTarget("dst", this.externalDataSource.getSignature()).expectResources(CalciteInsertDmlTest.dataSourceWrite("dst"), CalciteInsertDmlTest.externalRead("inline")).expectQuery((Query)CalciteInsertDmlTest.newScanQueryBuilder().dataSource((DataSource)this.externalDataSource).intervals(CalciteInsertDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"x", "y", "z"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.LONG}).context(PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).expectLogicalPlanFrom("insertFromExternal").verify();
    }

    @Test
    public void testUnauthorizedInsertFromExternalWithInputSourceSecurityEnabled() {
        this.testIngestionQuery().sql("INSERT INTO dst SELECT * FROM %s PARTITIONED BY ALL TIME", this.externSql(this.externalDataSource), new Object[0]).authentication(CalciteTests.REGULAR_USER_AUTH_RESULT).authConfig(AuthConfig.newBuilder().setEnableInputSourceSecurity(true).build()).expectLogicalPlanFrom("insertFromExternal").expectValidationError(ForbiddenException.class).verify();
    }

    @Test
    public void testInsertFromExternalWithSchema() {
        String extern;
        ObjectMapper queryJsonMapper = this.queryFramework().queryJsonMapper();
        try {
            extern = StringUtils.format((String)"TABLE(extern(%s, %s))", (Object[])new Object[]{Calcites.escapeStringLiteral((String)queryJsonMapper.writeValueAsString((Object)new InlineInputSource("a,b,1\nc,d,2\n"))), Calcites.escapeStringLiteral((String)queryJsonMapper.writeValueAsString((Object)new CsvInputFormat((List)ImmutableList.of((Object)"x", (Object)"y", (Object)"z"), null, Boolean.valueOf(false), Boolean.valueOf(false), 0, null)))});
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        this.testIngestionQuery().sql("INSERT INTO dst SELECT * FROM %s\n  (x VARCHAR, y VARCHAR, z BIGINT)\nPARTITIONED BY ALL TIME", extern, new Object[0]).authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("dst", this.externalDataSource.getSignature()).expectResources(CalciteInsertDmlTest.dataSourceWrite("dst"), Externals.EXTERNAL_RESOURCE_ACTION).expectQuery((Query)CalciteInsertDmlTest.newScanQueryBuilder().dataSource((DataSource)this.externalDataSource).intervals(CalciteInsertDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"x", "y", "z"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.LONG}).context(PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).expectLogicalPlanFrom("insertFromExternal").verify();
    }

    @Test
    public void testInsertFromExternalWithSchemaWithInputsourceSecurity() {
        String extern;
        ObjectMapper queryJsonMapper = this.queryFramework().queryJsonMapper();
        try {
            extern = StringUtils.format((String)"TABLE(extern(%s, %s))", (Object[])new Object[]{Calcites.escapeStringLiteral((String)queryJsonMapper.writeValueAsString((Object)new InlineInputSource("a,b,1\nc,d,2\n"))), Calcites.escapeStringLiteral((String)queryJsonMapper.writeValueAsString((Object)new CsvInputFormat((List)ImmutableList.of((Object)"x", (Object)"y", (Object)"z"), null, Boolean.valueOf(false), Boolean.valueOf(false), 0, null)))});
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        this.testIngestionQuery().sql("INSERT INTO dst SELECT * FROM %s\n  (x VARCHAR, y VARCHAR, z BIGINT)\nPARTITIONED BY ALL TIME", extern, new Object[0]).authentication(CalciteTests.SUPER_USER_AUTH_RESULT).authConfig(AuthConfig.newBuilder().setEnableInputSourceSecurity(true).build()).expectTarget("dst", this.externalDataSource.getSignature()).expectResources(CalciteInsertDmlTest.dataSourceWrite("dst"), CalciteInsertDmlTest.externalRead("inline")).expectQuery((Query)CalciteInsertDmlTest.newScanQueryBuilder().dataSource((DataSource)this.externalDataSource).intervals(CalciteInsertDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"x", "y", "z"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.LONG}).context(PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).expectLogicalPlanFrom("insertFromExternal").verify();
    }

    @Test
    public void testInsertFromExternalFunctionalStyleWithSchemaWithInputsourceSecurity() {
        String extern;
        ObjectMapper queryJsonMapper = this.queryFramework().queryJsonMapper();
        try {
            extern = StringUtils.format((String)"TABLE(extern(inputSource => '%s',inputFormat => '%s'))", (Object[])new Object[]{queryJsonMapper.writeValueAsString((Object)new InlineInputSource("a,b,1\nc,d,2\n")), queryJsonMapper.writeValueAsString((Object)new CsvInputFormat((List)ImmutableList.of((Object)"x", (Object)"y", (Object)"z"), null, Boolean.valueOf(false), Boolean.valueOf(false), 0, null))});
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        this.testIngestionQuery().sql("INSERT INTO dst SELECT * FROM %s\n  (x VARCHAR, y VARCHAR, z BIGINT)\nPARTITIONED BY ALL TIME", extern, new Object[0]).authentication(CalciteTests.SUPER_USER_AUTH_RESULT).authConfig(AuthConfig.newBuilder().setEnableInputSourceSecurity(true).build()).expectTarget("dst", this.externalDataSource.getSignature()).expectResources(CalciteInsertDmlTest.dataSourceWrite("dst"), CalciteInsertDmlTest.externalRead("inline")).expectQuery((Query)CalciteInsertDmlTest.newScanQueryBuilder().dataSource((DataSource)this.externalDataSource).intervals(CalciteInsertDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"x", "y", "z"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.LONG}).context(PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).expectLogicalPlanFrom("insertFromExternal").verify();
    }

    @Test
    public void testInsertFromExternalWithoutSecuritySupport() {
        String extern;
        CalciteIngestionDmlTest.TestFileInputSource inputSource = new CalciteIngestionDmlTest.TestFileInputSource((List<File>)ImmutableList.of((Object)new File("/tmp/foo.csv").getAbsoluteFile()));
        ExternalDataSource externalDataSource = new ExternalDataSource((InputSource)inputSource, (InputFormat)new CsvInputFormat((List)ImmutableList.of((Object)"x", (Object)"y", (Object)"z"), null, Boolean.valueOf(false), Boolean.valueOf(false), 0, null), RowSignature.builder().add("x", ColumnType.STRING).add("y", ColumnType.STRING).add("z", ColumnType.LONG).build());
        ObjectMapper queryJsonMapper = this.queryFramework().queryJsonMapper();
        try {
            extern = StringUtils.format((String)"TABLE(extern(inputSource => '%s',inputFormat => '%s'))", (Object[])new Object[]{queryJsonMapper.writeValueAsString((Object)inputSource), queryJsonMapper.writeValueAsString((Object)new CsvInputFormat((List)ImmutableList.of((Object)"x", (Object)"y", (Object)"z"), null, Boolean.valueOf(false), Boolean.valueOf(false), 0, null))});
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        this.testIngestionQuery().sql("INSERT INTO dst SELECT * FROM %s\n  (x VARCHAR, y VARCHAR, z BIGINT)\nPARTITIONED BY ALL TIME", extern, new Object[0]).authentication(CalciteTests.SUPER_USER_AUTH_RESULT).authConfig(AuthConfig.newBuilder().setEnableInputSourceSecurity(false).build()).expectTarget("dst", externalDataSource.getSignature()).expectResources(CalciteInsertDmlTest.dataSourceWrite("dst"), Externals.EXTERNAL_RESOURCE_ACTION).expectQuery((Query)CalciteInsertDmlTest.newScanQueryBuilder().dataSource((DataSource)externalDataSource).intervals(CalciteInsertDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"x", "y", "z"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.STRING, ColumnType.LONG}).context(PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).expectLogicalPlanFrom("InsertFromExternalWithoutSecuritySupport").verify();
    }

    @Test
    public void testInsertFromExternalWithoutSecuritySupportWithInputsourceSecurityEnabled() {
        String extern;
        ObjectMapper queryJsonMapper = this.queryFramework().queryJsonMapper();
        try {
            extern = StringUtils.format((String)"TABLE(extern(inputSource => '%s',inputFormat => '%s'))", (Object[])new Object[]{queryJsonMapper.writeValueAsString((Object)new CalciteIngestionDmlTest.TestFileInputSource((List<File>)ImmutableList.of((Object)new File("/tmp/foo.csv").getAbsoluteFile()))), queryJsonMapper.writeValueAsString((Object)new CsvInputFormat((List)ImmutableList.of((Object)"x", (Object)"y", (Object)"z"), null, Boolean.valueOf(false), Boolean.valueOf(false), 0, null))});
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        this.testIngestionQuery().sql("INSERT INTO dst SELECT * FROM %s\n  (x VARCHAR, y VARCHAR, z BIGINT)\nPARTITIONED BY ALL TIME", extern, new Object[0]).authentication(CalciteTests.SUPER_USER_AUTH_RESULT).authConfig(AuthConfig.newBuilder().setEnableInputSourceSecurity(true).build()).expectLogicalPlanFrom("insertFromExternal").expectValidationError((Matcher<Throwable>)CoreMatchers.allOf((Matcher)CoreMatchers.instanceOf(CalciteIngestionDmlTest.CalciteIngestDmlTestException.class), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.equalTo((Object)"getTypes()")))).verify();
    }

    @Test
    public void testInsertWithPartitionedBy() {
        RowSignature targetRowSignature = RowSignature.builder().add("__time", ColumnType.LONG).add("floor_m1", ColumnType.FLOAT).add("dim1", ColumnType.STRING).build();
        this.testIngestionQuery().sql("INSERT INTO druid.dst SELECT __time, FLOOR(m1) as floor_m1, dim1 FROM foo PARTITIONED BY TIME_FLOOR(__time, 'PT1H')").expectTarget("dst", targetRowSignature).expectResources(CalciteInsertDmlTest.dataSourceRead("foo"), CalciteInsertDmlTest.dataSourceWrite("dst")).expectQuery((Query)CalciteInsertDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteInsertDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "v0", "dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.FLOAT, ColumnType.STRING}).virtualColumns(new VirtualColumn[]{CalciteInsertDmlTest.expressionVirtualColumn("v0", "floor(\"m1\")", ColumnType.FLOAT)}).context(this.queryContextWithGranularity(Granularities.HOUR)).build()).expectLogicalPlanFrom("insertWithPartitionedBy").verify();
    }

    @Test
    public void testPartitionedBySupportedClauses() {
        RowSignature targetRowSignature = RowSignature.builder().add("__time", ColumnType.LONG).add("dim1", ColumnType.STRING).build();
        ImmutableMap partitionedByArgumentToGranularityMap = ImmutableMap.builder().put((Object)"HOUR", (Object)Granularities.HOUR).put((Object)"DAY", (Object)Granularities.DAY).put((Object)"MONTH", (Object)Granularities.MONTH).put((Object)"YEAR", (Object)Granularities.YEAR).put((Object)"ALL", (Object)Granularities.ALL).put((Object)"ALL TIME", (Object)Granularities.ALL).put((Object)"FLOOR(__time TO QUARTER)", (Object)Granularities.QUARTER).put((Object)"TIME_FLOOR(__time, 'PT1H')", (Object)Granularities.HOUR).build();
        ObjectMapper queryJsonMapper = this.queryFramework().queryJsonMapper();
        partitionedByArgumentToGranularityMap.forEach((partitionedByArgument, expectedGranularity) -> {
            ImmutableMap queryContext = null;
            try {
                queryContext = ImmutableMap.of((Object)"sqlInsertSegmentGranularity", (Object)queryJsonMapper.writeValueAsString(expectedGranularity));
            }
            catch (JsonProcessingException e) {
                Assert.fail((String)e.getMessage());
            }
            this.testIngestionQuery().sql(StringUtils.format((String)"INSERT INTO druid.dst SELECT __time, dim1 FROM foo PARTITIONED BY %s", (Object[])new Object[]{partitionedByArgument})).expectTarget("dst", targetRowSignature).expectResources(CalciteInsertDmlTest.dataSourceRead("foo"), CalciteInsertDmlTest.dataSourceWrite("dst")).expectQuery((Query)CalciteInsertDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteInsertDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING}).context((Map)queryContext).build()).verify();
            this.didTest = false;
        });
        this.didTest = true;
    }

    @Test
    public void testPartitionedBySupportedGranularityLiteralClauses() {
        RowSignature targetRowSignature = RowSignature.builder().add("__time", ColumnType.LONG).add("dim1", ColumnType.STRING).build();
        Map<String, Granularity> partitionedByToGranularity = Arrays.stream(GranularityType.values()).collect(Collectors.toMap(Enum::name, GranularityType::getDefaultGranularity));
        ObjectMapper queryJsonMapper = this.queryFramework().queryJsonMapper();
        partitionedByToGranularity.forEach((partitionedByArgument, expectedGranularity) -> {
            ImmutableMap queryContext = null;
            try {
                queryContext = ImmutableMap.of((Object)"sqlInsertSegmentGranularity", (Object)queryJsonMapper.writeValueAsString(expectedGranularity));
            }
            catch (JsonProcessingException e) {
                Assert.fail((String)e.getMessage());
            }
            this.testIngestionQuery().sql(StringUtils.format((String)"INSERT INTO druid.dst SELECT __time, dim1 FROM foo PARTITIONED BY '%s'", (Object[])new Object[]{partitionedByArgument})).expectTarget("dst", targetRowSignature).expectResources(CalciteInsertDmlTest.dataSourceRead("foo"), CalciteInsertDmlTest.dataSourceWrite("dst")).expectQuery((Query)CalciteInsertDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteInsertDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING}).context((Map)queryContext).build()).verify();
            this.didTest = false;
        });
        this.didTest = true;
    }

    @Test
    public void testExplainPlanInsertWithClusteredBy() throws JsonProcessingException {
        this.skipVectorize();
        String resources = "[{\"name\":\"dst\",\"type\":\"DATASOURCE\"},{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]";
        String attributes = "{\"statementType\":\"INSERT\",\"targetDataSource\":\"dst\",\"partitionedBy\":\"DAY\",\"clusteredBy\":[\"floor_m1\",\"dim1\",\"CEIL(\\\"m2\\\")\"]}";
        String sql = "EXPLAIN PLAN FOR INSERT INTO druid.dst SELECT __time, FLOOR(m1) as floor_m1, dim1, CEIL(m2) as ceil_m2 FROM foo PARTITIONED BY FLOOR(__time TO DAY) CLUSTERED BY 2, dim1, CEIL(m2)";
        ObjectMapper queryJsonMapper = this.queryFramework().queryJsonMapper();
        ScanQuery expectedQuery = CalciteInsertDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteInsertDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "dim1", "v0", "v1"}).virtualColumns(new VirtualColumn[]{CalciteInsertDmlTest.expressionVirtualColumn("v0", "floor(\"m1\")", ColumnType.FLOAT), CalciteInsertDmlTest.expressionVirtualColumn("v1", "ceil(\"m2\")", ColumnType.DOUBLE)}).orderBy((List)ImmutableList.of((Object)OrderBy.ascending((String)"v0"), (Object)OrderBy.ascending((String)"dim1"), (Object)OrderBy.ascending((String)"v1"))).context((Map)queryJsonMapper.readValue("{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlInsertSegmentGranularity\":\"\\\"DAY\\\"\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"}", JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT)).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.FLOAT, ColumnType.DOUBLE}).build();
        String explanation = "[{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[{\"type\":\"expression\",\"name\":\"v0\",\"expression\":\"floor(\\\"m1\\\")\",\"outputType\":\"FLOAT\"},{\"type\":\"expression\",\"name\":\"v1\",\"expression\":\"ceil(\\\"m2\\\")\",\"outputType\":\"DOUBLE\"}],\"resultFormat\":\"compactedList\",\"orderBy\":[{\"columnName\":\"v0\",\"order\":\"ascending\"},{\"columnName\":\"dim1\",\"order\":\"ascending\"},{\"columnName\":\"v1\",\"order\":\"ascending\"}],\"columns\":[\"__time\",\"v0\",\"dim1\",\"v1\"],\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlInsertSegmentGranularity\":\"\\\"DAY\\\"\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"columnTypes\":[\"LONG\",\"FLOAT\",\"STRING\",\"DOUBLE\"],\"granularity\":{\"type\":\"all\"},\"legacy\":false},\"signature\":[{\"name\":\"__time\",\"type\":\"LONG\"},{\"name\":\"v0\",\"type\":\"FLOAT\"},{\"name\":\"dim1\",\"type\":\"STRING\"},{\"name\":\"v1\",\"type\":\"DOUBLE\"}],\"columnMappings\":[{\"queryColumn\":\"__time\",\"outputColumn\":\"__time\"},{\"queryColumn\":\"v0\",\"outputColumn\":\"floor_m1\"},{\"queryColumn\":\"dim1\",\"outputColumn\":\"dim1\"},{\"queryColumn\":\"v1\",\"outputColumn\":\"ceil_m2\"}]}]";
        this.testQuery(PLANNER_CONFIG_NATIVE_QUERY_EXPLAIN, (Map<String, Object>)ImmutableMap.of((Object)"sqlQueryId", (Object)"dummy"), Collections.emptyList(), "EXPLAIN PLAN FOR INSERT INTO druid.dst SELECT __time, FLOOR(m1) as floor_m1, dim1, CEIL(m2) as ceil_m2 FROM foo PARTITIONED BY FLOOR(__time TO DAY) CLUSTERED BY 2, dim1, CEIL(m2)", CalciteTests.SUPER_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of(), new BaseCalciteQueryTest.DefaultResultsVerifier((List<Object[]>)ImmutableList.of((Object)new Object[]{"[{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[{\"type\":\"expression\",\"name\":\"v0\",\"expression\":\"floor(\\\"m1\\\")\",\"outputType\":\"FLOAT\"},{\"type\":\"expression\",\"name\":\"v1\",\"expression\":\"ceil(\\\"m2\\\")\",\"outputType\":\"DOUBLE\"}],\"resultFormat\":\"compactedList\",\"orderBy\":[{\"columnName\":\"v0\",\"order\":\"ascending\"},{\"columnName\":\"dim1\",\"order\":\"ascending\"},{\"columnName\":\"v1\",\"order\":\"ascending\"}],\"columns\":[\"__time\",\"v0\",\"dim1\",\"v1\"],\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlInsertSegmentGranularity\":\"\\\"DAY\\\"\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"columnTypes\":[\"LONG\",\"FLOAT\",\"STRING\",\"DOUBLE\"],\"granularity\":{\"type\":\"all\"},\"legacy\":false},\"signature\":[{\"name\":\"__time\",\"type\":\"LONG\"},{\"name\":\"v0\",\"type\":\"FLOAT\"},{\"name\":\"dim1\",\"type\":\"STRING\"},{\"name\":\"v1\",\"type\":\"DOUBLE\"}],\"columnMappings\":[{\"queryColumn\":\"__time\",\"outputColumn\":\"__time\"},{\"queryColumn\":\"v0\",\"outputColumn\":\"floor_m1\"},{\"queryColumn\":\"dim1\",\"outputColumn\":\"dim1\"},{\"queryColumn\":\"v1\",\"outputColumn\":\"ceil_m2\"}]}]", "[{\"name\":\"dst\",\"type\":\"DATASOURCE\"},{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]", "{\"statementType\":\"INSERT\",\"targetDataSource\":\"dst\",\"partitionedBy\":\"DAY\",\"clusteredBy\":[\"floor_m1\",\"dim1\",\"CEIL(\\\"m2\\\")\"]}"}), null));
        this.didTest = true;
    }

    @Test
    public void testExplainPlanInsertWithAsSubQueryClusteredBy() {
        this.skipVectorize();
        String resources = "[{\"name\":\"EXTERNAL\",\"type\":\"EXTERNAL\"},{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]";
        String attributes = "{\"statementType\":\"INSERT\",\"targetDataSource\":\"foo\",\"partitionedBy\":{\"type\":\"all\"},\"clusteredBy\":[\"namespace\",\"country\"]}";
        String sql = "EXPLAIN PLAN FOR\nINSERT INTO \"foo\"\nWITH dd AS (\nSELECT * FROM TABLE(\n  EXTERN(\n    '{\"type\":\"inline\",\"data\":\"{\\\" \\\": 1681794225551, \\\"namespace\\\": \\\"day1\\\", \\\"country\\\": \\\"one\\\"}\\n{\\\"__time\\\": 1681794225558, \\\"namespace\\\": \\\"day2\\\", \\\"country\\\": \\\"two\\\"}\"}',\n    '{\"type\":\"json\"}',\n    '[{\"name\":\"__time\",\"type\":\"long\"},{\"name\":\"namespace\",\"type\":\"string\"},{\"name\":\"country\",\"type\":\"string\"}]'\n  )\n))\n\nSELECT\n __time,\n  namespace,\n  country\nFROM dd\nPARTITIONED BY ALL\nCLUSTERED BY 2, 3";
        String explanation = "[{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"external\",\"inputSource\":{\"type\":\"inline\",\"data\":\"{\\\" \\\": 1681794225551, \\\"namespace\\\": \\\"day1\\\", \\\"country\\\": \\\"one\\\"}\\n{\\\"__time\\\": 1681794225558, \\\"namespace\\\": \\\"day2\\\", \\\"country\\\": \\\"two\\\"}\"},\"inputFormat\":{\"type\":\"json\"},\"signature\":[{\"name\":\"__time\",\"type\":\"LONG\"},{\"name\":\"namespace\",\"type\":\"STRING\"},{\"name\":\"country\",\"type\":\"STRING\"}]},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"resultFormat\":\"compactedList\",\"orderBy\":[{\"columnName\":\"namespace\",\"order\":\"ascending\"},{\"columnName\":\"country\",\"order\":\"ascending\"}],\"columns\":[\"__time\",\"namespace\",\"country\"],\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlInsertSegmentGranularity\":\"{\\\"type\\\":\\\"all\\\"}\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"columnTypes\":[\"LONG\",\"STRING\",\"STRING\"],\"granularity\":{\"type\":\"all\"},\"legacy\":false},\"signature\":[{\"name\":\"__time\",\"type\":\"LONG\"},{\"name\":\"namespace\",\"type\":\"STRING\"},{\"name\":\"country\",\"type\":\"STRING\"}],\"columnMappings\":[{\"queryColumn\":\"__time\",\"outputColumn\":\"__time\"},{\"queryColumn\":\"namespace\",\"outputColumn\":\"namespace\"},{\"queryColumn\":\"country\",\"outputColumn\":\"country\"}]}]";
        this.testQuery(PLANNER_CONFIG_NATIVE_QUERY_EXPLAIN, (Map<String, Object>)ImmutableMap.of((Object)"sqlQueryId", (Object)"dummy"), Collections.emptyList(), "EXPLAIN PLAN FOR\nINSERT INTO \"foo\"\nWITH dd AS (\nSELECT * FROM TABLE(\n  EXTERN(\n    '{\"type\":\"inline\",\"data\":\"{\\\" \\\": 1681794225551, \\\"namespace\\\": \\\"day1\\\", \\\"country\\\": \\\"one\\\"}\\n{\\\"__time\\\": 1681794225558, \\\"namespace\\\": \\\"day2\\\", \\\"country\\\": \\\"two\\\"}\"}',\n    '{\"type\":\"json\"}',\n    '[{\"name\":\"__time\",\"type\":\"long\"},{\"name\":\"namespace\",\"type\":\"string\"},{\"name\":\"country\",\"type\":\"string\"}]'\n  )\n))\n\nSELECT\n __time,\n  namespace,\n  country\nFROM dd\nPARTITIONED BY ALL\nCLUSTERED BY 2, 3", CalciteTests.SUPER_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of(), new BaseCalciteQueryTest.DefaultResultsVerifier((List<Object[]>)ImmutableList.of((Object)new Object[]{"[{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"external\",\"inputSource\":{\"type\":\"inline\",\"data\":\"{\\\" \\\": 1681794225551, \\\"namespace\\\": \\\"day1\\\", \\\"country\\\": \\\"one\\\"}\\n{\\\"__time\\\": 1681794225558, \\\"namespace\\\": \\\"day2\\\", \\\"country\\\": \\\"two\\\"}\"},\"inputFormat\":{\"type\":\"json\"},\"signature\":[{\"name\":\"__time\",\"type\":\"LONG\"},{\"name\":\"namespace\",\"type\":\"STRING\"},{\"name\":\"country\",\"type\":\"STRING\"}]},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"resultFormat\":\"compactedList\",\"orderBy\":[{\"columnName\":\"namespace\",\"order\":\"ascending\"},{\"columnName\":\"country\",\"order\":\"ascending\"}],\"columns\":[\"__time\",\"namespace\",\"country\"],\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlInsertSegmentGranularity\":\"{\\\"type\\\":\\\"all\\\"}\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"columnTypes\":[\"LONG\",\"STRING\",\"STRING\"],\"granularity\":{\"type\":\"all\"},\"legacy\":false},\"signature\":[{\"name\":\"__time\",\"type\":\"LONG\"},{\"name\":\"namespace\",\"type\":\"STRING\"},{\"name\":\"country\",\"type\":\"STRING\"}],\"columnMappings\":[{\"queryColumn\":\"__time\",\"outputColumn\":\"__time\"},{\"queryColumn\":\"namespace\",\"outputColumn\":\"namespace\"},{\"queryColumn\":\"country\",\"outputColumn\":\"country\"}]}]", "[{\"name\":\"EXTERNAL\",\"type\":\"EXTERNAL\"},{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]", "{\"statementType\":\"INSERT\",\"targetDataSource\":\"foo\",\"partitionedBy\":{\"type\":\"all\"},\"clusteredBy\":[\"namespace\",\"country\"]}"}), null));
        this.didTest = true;
    }

    @Test
    public void testExplainPlanInsertJoinQuery() {
        this.skipVectorize();
        String resources = "[{\"name\":\"EXTERNAL\",\"type\":\"EXTERNAL\"},{\"name\":\"my_table\",\"type\":\"DATASOURCE\"}]";
        String attributes = "{\"statementType\":\"INSERT\",\"targetDataSource\":\"my_table\",\"partitionedBy\":\"HOUR\",\"clusteredBy\":[\"__time\",\"isRobotAlias\",\"countryCapital\",\"regionName\"]}";
        String sql = "EXPLAIN PLAN FOR\nINSERT INTO my_table\nWITH\nwikidata AS (SELECT * FROM TABLE(\n  EXTERN(\n    '{\"type\":\"http\",\"uris\":[\"https://boo.gz\"]}',\n    '{\"type\":\"json\"}',\n    '[{\"name\":\"isRobot\",\"type\":\"string\"},{\"name\":\"timestamp\",\"type\":\"string\"},{\"name\":\"cityName\",\"type\":\"string\"},{\"name\":\"countryIsoCode\",\"type\":\"string\"},{\"name\":\"regionName\",\"type\":\"string\"}]'\n  )\n)),\ncountries AS (SELECT * FROM TABLE(\n  EXTERN(\n    '{\"type\":\"http\",\"uris\":[\"https://foo.tsv\"]}',\n    '{\"type\":\"tsv\",\"findColumnsFromHeader\":true}',\n    '[{\"name\":\"Country\",\"type\":\"string\"},{\"name\":\"Capital\",\"type\":\"string\"},{\"name\":\"ISO3\",\"type\":\"string\"},{\"name\":\"ISO2\",\"type\":\"string\"}]'\n  )\n))\nSELECT\n  TIME_PARSE(\"timestamp\") AS __time,\n  isRobot AS isRobotAlias,\n  countries.Capital AS countryCapital,\n  regionName\nFROM wikidata\nLEFT JOIN countries ON wikidata.countryIsoCode = countries.ISO2\nPARTITIONED BY HOUR\nCLUSTERED BY 1, 2, 3, regionName";
        String explanation = "[{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"join\",\"left\":{\"type\":\"external\",\"inputSource\":{\"type\":\"http\",\"uris\":[\"https://boo.gz\"],\"requestHeaders\":{}},\"inputFormat\":{\"type\":\"json\"},\"signature\":[{\"name\":\"isRobot\",\"type\":\"STRING\"},{\"name\":\"timestamp\",\"type\":\"STRING\"},{\"name\":\"cityName\",\"type\":\"STRING\"},{\"name\":\"countryIsoCode\",\"type\":\"STRING\"},{\"name\":\"regionName\",\"type\":\"STRING\"}]},\"right\":{\"type\":\"query\",\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"external\",\"inputSource\":{\"type\":\"http\",\"uris\":[\"https://foo.tsv\"],\"requestHeaders\":{}},\"inputFormat\":{\"type\":\"tsv\",\"delimiter\":\"\\t\",\"findColumnsFromHeader\":true},\"signature\":[{\"name\":\"Country\",\"type\":\"STRING\"},{\"name\":\"Capital\",\"type\":\"STRING\"},{\"name\":\"ISO3\",\"type\":\"STRING\"},{\"name\":\"ISO2\",\"type\":\"STRING\"}]},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"resultFormat\":\"compactedList\",\"columns\":[\"Capital\",\"ISO2\"],\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlInsertSegmentGranularity\":\"\\\"HOUR\\\"\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"columnTypes\":[\"STRING\",\"STRING\"],\"granularity\":{\"type\":\"all\"},\"legacy\":false}},\"rightPrefix\":\"j0.\",\"condition\":\"(\\\"countryIsoCode\\\" == \\\"j0.ISO2\\\")\",\"joinType\":\"LEFT\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[{\"type\":\"expression\",\"name\":\"v0\",\"expression\":\"timestamp_parse(\\\"timestamp\\\",null,'UTC')\",\"outputType\":\"LONG\"}],\"resultFormat\":\"compactedList\",\"orderBy\":[{\"columnName\":\"v0\",\"order\":\"ascending\"},{\"columnName\":\"isRobot\",\"order\":\"ascending\"},{\"columnName\":\"j0.Capital\",\"order\":\"ascending\"},{\"columnName\":\"regionName\",\"order\":\"ascending\"}],\"columns\":[\"v0\",\"isRobot\",\"j0.Capital\",\"regionName\"],\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlInsertSegmentGranularity\":\"\\\"HOUR\\\"\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"columnTypes\":[\"LONG\",\"STRING\",\"STRING\",\"STRING\"],\"granularity\":{\"type\":\"all\"},\"legacy\":false},\"signature\":[{\"name\":\"v0\",\"type\":\"LONG\"},{\"name\":\"isRobot\",\"type\":\"STRING\"},{\"name\":\"j0.Capital\",\"type\":\"STRING\"},{\"name\":\"regionName\",\"type\":\"STRING\"}],\"columnMappings\":[{\"queryColumn\":\"v0\",\"outputColumn\":\"__time\"},{\"queryColumn\":\"isRobot\",\"outputColumn\":\"isRobotAlias\"},{\"queryColumn\":\"j0.Capital\",\"outputColumn\":\"countryCapital\"},{\"queryColumn\":\"regionName\",\"outputColumn\":\"regionName\"}]}]";
        this.testQuery(PLANNER_CONFIG_NATIVE_QUERY_EXPLAIN, (Map<String, Object>)ImmutableMap.of((Object)"sqlQueryId", (Object)"dummy"), Collections.emptyList(), "EXPLAIN PLAN FOR\nINSERT INTO my_table\nWITH\nwikidata AS (SELECT * FROM TABLE(\n  EXTERN(\n    '{\"type\":\"http\",\"uris\":[\"https://boo.gz\"]}',\n    '{\"type\":\"json\"}',\n    '[{\"name\":\"isRobot\",\"type\":\"string\"},{\"name\":\"timestamp\",\"type\":\"string\"},{\"name\":\"cityName\",\"type\":\"string\"},{\"name\":\"countryIsoCode\",\"type\":\"string\"},{\"name\":\"regionName\",\"type\":\"string\"}]'\n  )\n)),\ncountries AS (SELECT * FROM TABLE(\n  EXTERN(\n    '{\"type\":\"http\",\"uris\":[\"https://foo.tsv\"]}',\n    '{\"type\":\"tsv\",\"findColumnsFromHeader\":true}',\n    '[{\"name\":\"Country\",\"type\":\"string\"},{\"name\":\"Capital\",\"type\":\"string\"},{\"name\":\"ISO3\",\"type\":\"string\"},{\"name\":\"ISO2\",\"type\":\"string\"}]'\n  )\n))\nSELECT\n  TIME_PARSE(\"timestamp\") AS __time,\n  isRobot AS isRobotAlias,\n  countries.Capital AS countryCapital,\n  regionName\nFROM wikidata\nLEFT JOIN countries ON wikidata.countryIsoCode = countries.ISO2\nPARTITIONED BY HOUR\nCLUSTERED BY 1, 2, 3, regionName", CalciteTests.SUPER_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of(), new BaseCalciteQueryTest.DefaultResultsVerifier((List<Object[]>)ImmutableList.of((Object)new Object[]{"[{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"join\",\"left\":{\"type\":\"external\",\"inputSource\":{\"type\":\"http\",\"uris\":[\"https://boo.gz\"],\"requestHeaders\":{}},\"inputFormat\":{\"type\":\"json\"},\"signature\":[{\"name\":\"isRobot\",\"type\":\"STRING\"},{\"name\":\"timestamp\",\"type\":\"STRING\"},{\"name\":\"cityName\",\"type\":\"STRING\"},{\"name\":\"countryIsoCode\",\"type\":\"STRING\"},{\"name\":\"regionName\",\"type\":\"STRING\"}]},\"right\":{\"type\":\"query\",\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"external\",\"inputSource\":{\"type\":\"http\",\"uris\":[\"https://foo.tsv\"],\"requestHeaders\":{}},\"inputFormat\":{\"type\":\"tsv\",\"delimiter\":\"\\t\",\"findColumnsFromHeader\":true},\"signature\":[{\"name\":\"Country\",\"type\":\"STRING\"},{\"name\":\"Capital\",\"type\":\"STRING\"},{\"name\":\"ISO3\",\"type\":\"STRING\"},{\"name\":\"ISO2\",\"type\":\"STRING\"}]},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"resultFormat\":\"compactedList\",\"columns\":[\"Capital\",\"ISO2\"],\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlInsertSegmentGranularity\":\"\\\"HOUR\\\"\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"columnTypes\":[\"STRING\",\"STRING\"],\"granularity\":{\"type\":\"all\"},\"legacy\":false}},\"rightPrefix\":\"j0.\",\"condition\":\"(\\\"countryIsoCode\\\" == \\\"j0.ISO2\\\")\",\"joinType\":\"LEFT\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[{\"type\":\"expression\",\"name\":\"v0\",\"expression\":\"timestamp_parse(\\\"timestamp\\\",null,'UTC')\",\"outputType\":\"LONG\"}],\"resultFormat\":\"compactedList\",\"orderBy\":[{\"columnName\":\"v0\",\"order\":\"ascending\"},{\"columnName\":\"isRobot\",\"order\":\"ascending\"},{\"columnName\":\"j0.Capital\",\"order\":\"ascending\"},{\"columnName\":\"regionName\",\"order\":\"ascending\"}],\"columns\":[\"v0\",\"isRobot\",\"j0.Capital\",\"regionName\"],\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlInsertSegmentGranularity\":\"\\\"HOUR\\\"\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"columnTypes\":[\"LONG\",\"STRING\",\"STRING\",\"STRING\"],\"granularity\":{\"type\":\"all\"},\"legacy\":false},\"signature\":[{\"name\":\"v0\",\"type\":\"LONG\"},{\"name\":\"isRobot\",\"type\":\"STRING\"},{\"name\":\"j0.Capital\",\"type\":\"STRING\"},{\"name\":\"regionName\",\"type\":\"STRING\"}],\"columnMappings\":[{\"queryColumn\":\"v0\",\"outputColumn\":\"__time\"},{\"queryColumn\":\"isRobot\",\"outputColumn\":\"isRobotAlias\"},{\"queryColumn\":\"j0.Capital\",\"outputColumn\":\"countryCapital\"},{\"queryColumn\":\"regionName\",\"outputColumn\":\"regionName\"}]}]", "[{\"name\":\"EXTERNAL\",\"type\":\"EXTERNAL\"},{\"name\":\"my_table\",\"type\":\"DATASOURCE\"}]", "{\"statementType\":\"INSERT\",\"targetDataSource\":\"my_table\",\"partitionedBy\":\"HOUR\",\"clusteredBy\":[\"__time\",\"isRobotAlias\",\"countryCapital\",\"regionName\"]}"}), null));
        this.didTest = true;
    }

    @Test
    public void testExplainPlanInsertWithClusteredByDescThrowsException() {
        this.skipVectorize();
        String sql = "EXPLAIN PLAN FOR INSERT INTO druid.dst SELECT __time, FLOOR(m1) as floor_m1, dim1, CEIL(m2) as ceil_m2 FROM foo PARTITIONED BY FLOOR(__time TO DAY) CLUSTERED BY 2, dim1 DESC, CEIL(m2)";
        this.testIngestionQuery().sql("EXPLAIN PLAN FOR INSERT INTO druid.dst SELECT __time, FLOOR(m1) as floor_m1, dim1, CEIL(m2) as ceil_m2 FROM foo PARTITIONED BY FLOOR(__time TO DAY) CLUSTERED BY 2, dim1 DESC, CEIL(m2)").expectValidationError((Matcher<Throwable>)CalciteInsertDmlTest.invalidSqlIs("Invalid CLUSTERED BY clause [`dim1` DESC]: cannot sort in descending order.")).verify();
    }

    @Test
    public void testInsertWithClusteredBy() {
        RowSignature targetRowSignature = RowSignature.builder().add("__time", ColumnType.LONG).add("floor_m1", ColumnType.FLOAT).add("dim1", ColumnType.STRING).add("ceil_m2", ColumnType.DOUBLE).build();
        this.testIngestionQuery().sql("INSERT INTO druid.dst SELECT __time, FLOOR(m1) as floor_m1, dim1, CEIL(m2) as ceil_m2 FROM foo PARTITIONED BY FLOOR(__time TO DAY) CLUSTERED BY 2, dim1, CEIL(m2)").expectTarget("dst", targetRowSignature).expectResources(CalciteInsertDmlTest.dataSourceRead("foo"), CalciteInsertDmlTest.dataSourceWrite("dst")).expectQuery((Query)CalciteInsertDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteInsertDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "v0", "dim1", "v1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.FLOAT, ColumnType.STRING, ColumnType.DOUBLE}).virtualColumns(new VirtualColumn[]{CalciteInsertDmlTest.expressionVirtualColumn("v0", "floor(\"m1\")", ColumnType.FLOAT), CalciteInsertDmlTest.expressionVirtualColumn("v1", "ceil(\"m2\")", ColumnType.DOUBLE)}).orderBy((List)ImmutableList.of((Object)OrderBy.ascending((String)"v0"), (Object)OrderBy.ascending((String)"dim1"), (Object)OrderBy.ascending((String)"v1"))).context(this.queryContextWithGranularity(Granularities.DAY)).build()).expectLogicalPlanFrom("insertWithClusteredBy").verify();
    }

    @Test
    public void testInsertPeriodFormGranularityWithClusteredBy() {
        RowSignature targetRowSignature = RowSignature.builder().add("__time", ColumnType.LONG).add("floor_m1", ColumnType.FLOAT).add("dim1", ColumnType.STRING).add("ceil_m2", ColumnType.DOUBLE).build();
        this.testIngestionQuery().sql("INSERT INTO druid.dst SELECT __time, FLOOR(m1) as floor_m1, dim1, CEIL(m2) as ceil_m2 FROM foo PARTITIONED BY P1D CLUSTERED BY 2, dim1, CEIL(m2)").expectTarget("dst", targetRowSignature).expectResources(CalciteInsertDmlTest.dataSourceRead("foo"), CalciteInsertDmlTest.dataSourceWrite("dst")).expectQuery((Query)CalciteInsertDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteInsertDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "v0", "dim1", "v1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.FLOAT, ColumnType.STRING, ColumnType.DOUBLE}).virtualColumns(new VirtualColumn[]{CalciteInsertDmlTest.expressionVirtualColumn("v0", "floor(\"m1\")", ColumnType.FLOAT), CalciteInsertDmlTest.expressionVirtualColumn("v1", "ceil(\"m2\")", ColumnType.DOUBLE)}).orderBy((List)ImmutableList.of((Object)OrderBy.ascending((String)"v0"), (Object)OrderBy.ascending((String)"dim1"), (Object)OrderBy.ascending((String)"v1"))).context(this.queryContextWithGranularity(Granularities.DAY)).build()).expectLogicalPlanFrom("insertPartitionedByP1DWithClusteredBy").verify();
    }

    @Test
    public void testInsertWithoutPartitionedByWithClusteredBy() {
        this.testIngestionQuery().sql("INSERT INTO druid.dst SELECT __time, FLOOR(m1) as floor_m1, dim1, CEIL(m2) as ceil_m2 FROM foo CLUSTERED BY 2, dim1, CEIL(m2)").expectValidationError((Matcher<Throwable>)CalciteInsertDmlTest.invalidSqlIs("CLUSTERED BY found before PARTITIONED BY, CLUSTERED BY must come after the PARTITIONED BY clause")).verify();
    }

    @Test
    public void testInsertWithPartitionedByAndClusteredBy() {
        RowSignature targetRowSignature = RowSignature.builder().add("__time", ColumnType.LONG).add("floor_m1", ColumnType.FLOAT).add("dim1", ColumnType.STRING).build();
        this.testIngestionQuery().sql("INSERT INTO druid.dst SELECT __time, FLOOR(m1) as floor_m1, dim1 FROM foo PARTITIONED BY DAY CLUSTERED BY 2, dim1").expectTarget("dst", targetRowSignature).expectResources(CalciteInsertDmlTest.dataSourceRead("foo"), CalciteInsertDmlTest.dataSourceWrite("dst")).expectQuery((Query)CalciteInsertDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteInsertDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "v0", "dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.FLOAT, ColumnType.STRING}).virtualColumns(new VirtualColumn[]{CalciteInsertDmlTest.expressionVirtualColumn("v0", "floor(\"m1\")", ColumnType.FLOAT)}).orderBy((List)ImmutableList.of((Object)OrderBy.ascending((String)"v0"), (Object)OrderBy.ascending((String)"dim1"))).context(this.queryContextWithGranularity(Granularities.DAY)).build()).verify();
    }

    @Test
    public void testInsertWithPartitionedByAndLimitOffset() {
        RowSignature targetRowSignature = RowSignature.builder().add("__time", ColumnType.LONG).add("floor_m1", ColumnType.FLOAT).add("dim1", ColumnType.STRING).build();
        this.testIngestionQuery().sql("INSERT INTO druid.dst SELECT __time, FLOOR(m1) as floor_m1, dim1 FROM foo LIMIT 10 OFFSET 20 PARTITIONED BY DAY").expectTarget("dst", targetRowSignature).expectResources(CalciteInsertDmlTest.dataSourceRead("foo"), CalciteInsertDmlTest.dataSourceWrite("dst")).expectQuery((Query)CalciteInsertDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteInsertDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "v0", "dim1"}).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.FLOAT, ColumnType.STRING}).virtualColumns(new VirtualColumn[]{CalciteInsertDmlTest.expressionVirtualColumn("v0", "floor(\"m1\")", ColumnType.FLOAT)}).limit(10L).offset(20L).context(this.queryContextWithGranularity(Granularities.DAY)).build()).verify();
    }

    @Test
    public void testInsertWithClusteredByAndOrderBy() {
        try {
            this.testQuery(StringUtils.format((String)"INSERT INTO dst SELECT * FROM %s ORDER BY 2 PARTITIONED BY ALL TIME", (Object[])new Object[]{this.externSql(this.externalDataSource)}), (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
            Assert.fail((String)"Exception should be thrown");
        }
        catch (DruidException e) {
            MatcherAssert.assertThat((Object)((Object)e), (Matcher)CalciteInsertDmlTest.invalidSqlIs("Cannot use an ORDER BY clause on a Query of type [INSERT], use CLUSTERED BY instead"));
        }
        this.didTest = true;
    }

    @Test
    public void testInsertWithPartitionedByContainingInvalidGranularity() {
        try {
            this.testQuery("INSERT INTO dst SELECT * FROM foo PARTITIONED BY 'invalid_granularity'", (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
            Assert.fail((String)"Exception should be thrown");
        }
        catch (DruidException e) {
            MatcherAssert.assertThat((Object)((Object)e), (Matcher)CalciteInsertDmlTest.invalidSqlIs("Invalid granularity['invalid_granularity'] specified after PARTITIONED BY clause. Expected 'SECOND', 'MINUTE', 'FIVE_MINUTE', 'TEN_MINUTE', 'FIFTEEN_MINUTE', 'THIRTY_MINUTE', 'HOUR', 'SIX_HOUR', 'EIGHT_HOUR', 'DAY', 'MONTH', 'QUARTER', 'YEAR', 'ALL', ALL TIME, FLOOR() or TIME_FLOOR()"));
        }
        this.didTest = true;
    }

    @Test
    public void testInsertWithOrderBy() {
        try {
            this.testQuery(StringUtils.format((String)"INSERT INTO dst SELECT * FROM %s ORDER BY 2 PARTITIONED BY ALL TIME", (Object[])new Object[]{this.externSql(this.externalDataSource)}), (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
            Assert.fail((String)"Exception should be thrown");
        }
        catch (DruidException e) {
            MatcherAssert.assertThat((Object)((Object)e), (Matcher)CalciteInsertDmlTest.invalidSqlIs("Cannot use an ORDER BY clause on a Query of type [INSERT], use CLUSTERED BY instead"));
        }
        finally {
            this.didTest = true;
        }
    }

    @Test
    public void testInsertWithoutPartitionedBy() {
        DruidException e = (DruidException)Assert.assertThrows(DruidException.class, () -> this.testQuery(StringUtils.format((String)"INSERT INTO dst SELECT * FROM %s", (Object[])new Object[]{this.externSql(this.externalDataSource)}), (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of()));
        MatcherAssert.assertThat((Object)((Object)e), (Matcher)CalciteInsertDmlTest.invalidSqlIs("Operation [INSERT] requires a PARTITIONED BY to be explicitly defined, but none was found."));
        this.didTest = true;
    }

    @Test
    public void testExplainInsertFromExternal() {
        this.skipVectorize();
        String query = StringUtils.format((String)"EXPLAIN PLAN FOR INSERT INTO dst SELECT * FROM %s PARTITIONED BY ALL TIME", (Object[])new Object[]{this.externSql(this.externalDataSource)});
        String explanation = "[{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"external\",\"inputSource\":{\"type\":\"inline\",\"data\":\"a,b,1\\nc,d,2\\n\"},\"inputFormat\":{\"type\":\"csv\",\"columns\":[\"x\",\"y\",\"z\"]},\"signature\":[{\"name\":\"x\",\"type\":\"STRING\"},{\"name\":\"y\",\"type\":\"STRING\"},{\"name\":\"z\",\"type\":\"LONG\"}]},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"resultFormat\":\"compactedList\",\"columns\":[\"x\",\"y\",\"z\"],\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlInsertSegmentGranularity\":\"{\\\"type\\\":\\\"all\\\"}\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"columnTypes\":[\"STRING\",\"STRING\",\"LONG\"],\"granularity\":{\"type\":\"all\"},\"legacy\":false},\"signature\":[{\"name\":\"x\",\"type\":\"STRING\"},{\"name\":\"y\",\"type\":\"STRING\"},{\"name\":\"z\",\"type\":\"LONG\"}],\"columnMappings\":[{\"queryColumn\":\"x\",\"outputColumn\":\"x\"},{\"queryColumn\":\"y\",\"outputColumn\":\"y\"},{\"queryColumn\":\"z\",\"outputColumn\":\"z\"}]}]";
        String resources = "[{\"name\":\"EXTERNAL\",\"type\":\"EXTERNAL\"},{\"name\":\"dst\",\"type\":\"DATASOURCE\"}]";
        String attributes = "{\"statementType\":\"INSERT\",\"targetDataSource\":\"dst\",\"partitionedBy\":{\"type\":\"all\"}}";
        this.testQuery(PLANNER_CONFIG_NATIVE_QUERY_EXPLAIN, (Map<String, Object>)ImmutableMap.of((Object)"sqlQueryId", (Object)"dummy"), Collections.emptyList(), query, CalciteTests.SUPER_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of(), new BaseCalciteQueryTest.DefaultResultsVerifier((List<Object[]>)ImmutableList.of((Object)new Object[]{"[{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"external\",\"inputSource\":{\"type\":\"inline\",\"data\":\"a,b,1\\nc,d,2\\n\"},\"inputFormat\":{\"type\":\"csv\",\"columns\":[\"x\",\"y\",\"z\"]},\"signature\":[{\"name\":\"x\",\"type\":\"STRING\"},{\"name\":\"y\",\"type\":\"STRING\"},{\"name\":\"z\",\"type\":\"LONG\"}]},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"resultFormat\":\"compactedList\",\"columns\":[\"x\",\"y\",\"z\"],\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlInsertSegmentGranularity\":\"{\\\"type\\\":\\\"all\\\"}\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"columnTypes\":[\"STRING\",\"STRING\",\"LONG\"],\"granularity\":{\"type\":\"all\"},\"legacy\":false},\"signature\":[{\"name\":\"x\",\"type\":\"STRING\"},{\"name\":\"y\",\"type\":\"STRING\"},{\"name\":\"z\",\"type\":\"LONG\"}],\"columnMappings\":[{\"queryColumn\":\"x\",\"outputColumn\":\"x\"},{\"queryColumn\":\"y\",\"outputColumn\":\"y\"},{\"queryColumn\":\"z\",\"outputColumn\":\"z\"}]}]", "[{\"name\":\"EXTERNAL\",\"type\":\"EXTERNAL\"},{\"name\":\"dst\",\"type\":\"DATASOURCE\"}]", "{\"statementType\":\"INSERT\",\"targetDataSource\":\"dst\",\"partitionedBy\":{\"type\":\"all\"}}"}), null));
        this.didTest = true;
    }

    @Test
    public void testExplainPlanForInsertWithClusteredBy() throws JsonProcessingException {
        this.skipVectorize();
        String query = "EXPLAIN PLAN FOR INSERT INTO druid.dst SELECT __time, FLOOR(m1) as floor_m1, dim1, CEIL(m2) as ceil_m2 FROM foo PARTITIONED BY FLOOR(__time TO DAY) CLUSTERED BY 2, dim1 ASC, CEIL(m2)";
        ObjectMapper queryJsonMapper = this.queryFramework().queryJsonMapper();
        ScanQuery expectedQuery = CalciteInsertDmlTest.newScanQueryBuilder().dataSource("foo").intervals(CalciteInsertDmlTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"__time", "dim1", "v0", "v1"}).virtualColumns(new VirtualColumn[]{CalciteInsertDmlTest.expressionVirtualColumn("v0", "floor(\"m1\")", ColumnType.FLOAT), CalciteInsertDmlTest.expressionVirtualColumn("v1", "ceil(\"m2\")", ColumnType.DOUBLE)}).orderBy((List)ImmutableList.of((Object)OrderBy.ascending((String)"v0"), (Object)OrderBy.ascending((String)"dim1"), (Object)OrderBy.ascending((String)"v1"))).context((Map)queryJsonMapper.readValue("{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlInsertSegmentGranularity\":\"\\\"DAY\\\"\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"}", JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT)).columnTypes(new ColumnType[]{ColumnType.LONG, ColumnType.STRING, ColumnType.FLOAT, ColumnType.DOUBLE}).build();
        String explanation = "[{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[{\"type\":\"expression\",\"name\":\"v0\",\"expression\":\"floor(\\\"m1\\\")\",\"outputType\":\"FLOAT\"},{\"type\":\"expression\",\"name\":\"v1\",\"expression\":\"ceil(\\\"m2\\\")\",\"outputType\":\"DOUBLE\"}],\"resultFormat\":\"compactedList\",\"orderBy\":[{\"columnName\":\"v0\",\"order\":\"ascending\"},{\"columnName\":\"dim1\",\"order\":\"ascending\"},{\"columnName\":\"v1\",\"order\":\"ascending\"}],\"columns\":[\"__time\",\"v0\",\"dim1\",\"v1\"],\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlInsertSegmentGranularity\":\"\\\"DAY\\\"\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"columnTypes\":[\"LONG\",\"FLOAT\",\"STRING\",\"DOUBLE\"],\"granularity\":{\"type\":\"all\"},\"legacy\":false},\"signature\":[{\"name\":\"__time\",\"type\":\"LONG\"},{\"name\":\"v0\",\"type\":\"FLOAT\"},{\"name\":\"dim1\",\"type\":\"STRING\"},{\"name\":\"v1\",\"type\":\"DOUBLE\"}],\"columnMappings\":[{\"queryColumn\":\"__time\",\"outputColumn\":\"__time\"},{\"queryColumn\":\"v0\",\"outputColumn\":\"floor_m1\"},{\"queryColumn\":\"dim1\",\"outputColumn\":\"dim1\"},{\"queryColumn\":\"v1\",\"outputColumn\":\"ceil_m2\"}]}]";
        String resources = "[{\"name\":\"dst\",\"type\":\"DATASOURCE\"},{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]";
        String attributes = "{\"statementType\":\"INSERT\",\"targetDataSource\":\"dst\",\"partitionedBy\":\"DAY\",\"clusteredBy\":[\"floor_m1\",\"dim1\",\"CEIL(\\\"m2\\\")\"]}";
        this.testQuery(PLANNER_CONFIG_NATIVE_QUERY_EXPLAIN, (Map<String, Object>)ImmutableMap.of((Object)"sqlQueryId", (Object)"dummy"), Collections.emptyList(), "EXPLAIN PLAN FOR INSERT INTO druid.dst SELECT __time, FLOOR(m1) as floor_m1, dim1, CEIL(m2) as ceil_m2 FROM foo PARTITIONED BY FLOOR(__time TO DAY) CLUSTERED BY 2, dim1 ASC, CEIL(m2)", CalciteTests.SUPER_USER_AUTH_RESULT, (List<Query<?>>)ImmutableList.of(), new BaseCalciteQueryTest.DefaultResultsVerifier((List<Object[]>)ImmutableList.of((Object)new Object[]{"[{\"query\":{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"foo\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"-146136543-09-08T08:23:32.096Z/146140482-04-24T15:36:27.903Z\"]},\"virtualColumns\":[{\"type\":\"expression\",\"name\":\"v0\",\"expression\":\"floor(\\\"m1\\\")\",\"outputType\":\"FLOAT\"},{\"type\":\"expression\",\"name\":\"v1\",\"expression\":\"ceil(\\\"m2\\\")\",\"outputType\":\"DOUBLE\"}],\"resultFormat\":\"compactedList\",\"orderBy\":[{\"columnName\":\"v0\",\"order\":\"ascending\"},{\"columnName\":\"dim1\",\"order\":\"ascending\"},{\"columnName\":\"v1\",\"order\":\"ascending\"}],\"columns\":[\"__time\",\"v0\",\"dim1\",\"v1\"],\"context\":{\"defaultTimeout\":300000,\"maxScatterGatherBytes\":9223372036854775807,\"sqlCurrentTimestamp\":\"2000-01-01T00:00:00Z\",\"sqlInsertSegmentGranularity\":\"\\\"DAY\\\"\",\"sqlQueryId\":\"dummy\",\"vectorize\":\"false\",\"vectorizeVirtualColumns\":\"false\"},\"columnTypes\":[\"LONG\",\"FLOAT\",\"STRING\",\"DOUBLE\"],\"granularity\":{\"type\":\"all\"},\"legacy\":false},\"signature\":[{\"name\":\"__time\",\"type\":\"LONG\"},{\"name\":\"v0\",\"type\":\"FLOAT\"},{\"name\":\"dim1\",\"type\":\"STRING\"},{\"name\":\"v1\",\"type\":\"DOUBLE\"}],\"columnMappings\":[{\"queryColumn\":\"__time\",\"outputColumn\":\"__time\"},{\"queryColumn\":\"v0\",\"outputColumn\":\"floor_m1\"},{\"queryColumn\":\"dim1\",\"outputColumn\":\"dim1\"},{\"queryColumn\":\"v1\",\"outputColumn\":\"ceil_m2\"}]}]", "[{\"name\":\"dst\",\"type\":\"DATASOURCE\"},{\"name\":\"foo\",\"type\":\"DATASOURCE\"}]", "{\"statementType\":\"INSERT\",\"targetDataSource\":\"dst\",\"partitionedBy\":\"DAY\",\"clusteredBy\":[\"floor_m1\",\"dim1\",\"CEIL(\\\"m2\\\")\"]}"}), null));
        this.didTest = true;
    }

    @Test
    public void testExplainInsertFromExternalUnauthorized() {
        Assert.assertThrows(ForbiddenException.class, () -> this.testQuery(StringUtils.format((String)"EXPLAIN PLAN FOR INSERT INTO dst SELECT * FROM %s PARTITIONED BY ALL TIME", (Object[])new Object[]{this.externSql(this.externalDataSource)}), (List<Query<?>>)ImmutableList.of(), (List<Object[]>)ImmutableList.of()));
        this.didTest = true;
    }

    @Test
    public void testSurfaceErrorsWhenInsertingThroughIncorrectSelectStatment() {
        this.assertQueryIsUnplannable("INSERT INTO druid.dst SELECT dim2, dim1, m1 FROM foo2 UNION SELECT dim1, dim2, m1 FROM foo PARTITIONED BY ALL TIME", "SQL requires 'UNION' but only 'UNION ALL' is supported.");
        this.didTest = true;
    }

    @Test
    public void testInsertFromExternalUnauthorized() {
        this.testIngestionQuery().sql("INSERT INTO dst SELECT * FROM %s PARTITIONED BY ALL TIME", this.externSql(this.externalDataSource), new Object[0]).expectValidationError(ForbiddenException.class).verify();
    }

    @Test
    public void testInsertWithOverwriteClause() {
        this.testIngestionQuery().sql("INSERT INTO dst OVERWRITE ALL SELECT * FROM foo PARTITIONED BY ALL TIME").expectValidationError(DruidException.class, "An OVERWRITE clause is not allowed with INSERT statements. Use REPLACE statements if overwriting existing segments is required or remove the OVERWRITE clause.").verify();
    }

    @Test
    public void testInsertFromExternalProjectSort() {
        this.testIngestionQuery().sql("INSERT INTO dst SELECT x || y AS xy, z FROM %s PARTITIONED BY ALL TIME CLUSTERED BY 1, 2", this.externSql(this.externalDataSource), new Object[0]).authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("dst", RowSignature.builder().add("xy", ColumnType.STRING).add("z", ColumnType.LONG).build()).expectResources(CalciteInsertDmlTest.dataSourceWrite("dst"), Externals.EXTERNAL_RESOURCE_ACTION).expectQuery((Query)CalciteInsertDmlTest.newScanQueryBuilder().dataSource((DataSource)this.externalDataSource).intervals(CalciteInsertDmlTest.querySegmentSpec(Filtration.eternity())).virtualColumns(new VirtualColumn[]{CalciteInsertDmlTest.expressionVirtualColumn("v0", "concat(\"x\",\"y\")", ColumnType.STRING)}).columns(new String[]{"v0", "z"}).columnTypes(new ColumnType[]{ColumnType.STRING, ColumnType.LONG}).orderBy((List)ImmutableList.of((Object)OrderBy.ascending((String)"v0"), (Object)OrderBy.ascending((String)"z"))).context(PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).verify();
    }

    @Test
    public void testInsertFromExternalAggregate() {
        this.testIngestionQuery().sql("INSERT INTO dst SELECT x, SUM(z) AS sum_z, COUNT(*) AS cnt FROM %s GROUP BY 1 PARTITIONED BY ALL TIME", this.externSql(this.externalDataSource), new Object[0]).authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("dst", RowSignature.builder().add("x", ColumnType.STRING).add("sum_z", ColumnType.LONG).add("cnt", ColumnType.LONG).build()).expectResources(CalciteInsertDmlTest.dataSourceWrite("dst"), Externals.EXTERNAL_RESOURCE_ACTION).expectQuery((Query)GroupByQuery.builder().setDataSource((DataSource)this.externalDataSource).setInterval(CalciteInsertDmlTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setDimensions(CalciteInsertDmlTest.dimensions(new DimensionSpec[]{new DefaultDimensionSpec("x", "d0")})).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("a0", "z"), new CountAggregatorFactory("a1")}).setContext(PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).verify();
    }

    @Test
    public void testInsertFromExternalAggregateAll() {
        this.testIngestionQuery().sql("INSERT INTO dst SELECT COUNT(*) AS cnt FROM %s PARTITIONED BY ALL TIME", this.externSql(this.externalDataSource), new Object[0]).authentication(CalciteTests.SUPER_USER_AUTH_RESULT).expectTarget("dst", RowSignature.builder().add("cnt", ColumnType.LONG).build()).expectResources(CalciteInsertDmlTest.dataSourceWrite("dst"), Externals.EXTERNAL_RESOURCE_ACTION).expectQuery((Query)GroupByQuery.builder().setDataSource((DataSource)this.externalDataSource).setInterval(CalciteInsertDmlTest.querySegmentSpec(Filtration.eternity())).setGranularity(Granularities.ALL).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("a0")}).setContext(PARTITIONED_BY_ALL_TIME_QUERY_CONTEXT).build()).verify();
    }

    @Test
    public void testInsertWithInvalidSelectStatement() {
        this.testIngestionQuery().sql("INSERT INTO t SELECT channel, added as count FROM foo PARTITIONED BY ALL").expectValidationError((Matcher<Throwable>)CalciteInsertDmlTest.invalidSqlContains("Received an unexpected token [as count]")).verify();
    }

    @Test
    public void testInsertWithLongIdentifer() {
        String longIdentifer = new String(new char[200]).replace('\u0000', 'a');
        this.testIngestionQuery().sql(StringUtils.format((String)"INSERT INTO t SELECT %s FROM foo PARTITIONED BY ALL", (Object[])new Object[]{longIdentifer})).expectValidationError((Matcher<Throwable>)CalciteInsertDmlTest.invalidSqlContains(StringUtils.format((String)"Length of identifier '%s' must be less than or equal to 128 characters", (Object[])new Object[]{longIdentifer}))).verify();
    }

    @Test
    public void testInsertWithUnnamedColumnInSelectStatement() {
        this.testIngestionQuery().sql("INSERT INTO t SELECT dim1, dim2 || '-lol' FROM foo PARTITIONED BY ALL").expectValidationError((Matcher<Throwable>)CalciteInsertDmlTest.invalidSqlContains("Insertion requires columns to be named")).verify();
    }

    @Test
    public void testInsertWithInvalidColumnNameInIngest() {
        this.testIngestionQuery().sql("INSERT INTO t SELECT __time, dim1 AS EXPR$0 FROM foo PARTITIONED BY ALL").expectValidationError((Matcher<Throwable>)CalciteInsertDmlTest.invalidSqlContains("Insertion requires columns to be named")).verify();
    }

    @Test
    public void testInsertWithInvalidColumnName2InIngest() {
        this.testIngestionQuery().sql("INSERT INTO t SELECT __time, 1+1 FROM foo PARTITIONED BY ALL").expectValidationError((Matcher<Throwable>)CalciteInsertDmlTest.invalidSqlContains("Insertion requires columns to be named")).verify();
    }

    @Test
    public void testInsertWithUnnamedColumnInNestedSelectStatement() {
        this.testIngestionQuery().sql("INSERT INTO test SELECT __time, * FROM (SELECT __time, LOWER(dim1) FROM foo) PARTITIONED BY ALL TIME").expectValidationError((Matcher<Throwable>)CalciteInsertDmlTest.invalidSqlContains("Insertion requires columns to be named")).verify();
    }

    @Test
    public void testInsertQueryWithInvalidGranularity() {
        this.testIngestionQuery().sql("insert into foo1 select __time, dim1 FROM foo partitioned by time_floor(__time, 'PT2H')").expectValidationError((Matcher<Throwable>)CoreMatchers.allOf((Matcher)CoreMatchers.instanceOf(DruidException.class), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Invalid granularity[`time_floor`(`__time`, 'PT2H')] specified after PARTITIONED BY clause. Expected 'SECOND', 'MINUTE', 'FIVE_MINUTE', 'TEN_MINUTE', 'FIFTEEN_MINUTE', 'THIRTY_MINUTE', 'HOUR', 'SIX_HOUR', 'EIGHT_HOUR', 'DAY', 'MONTH', 'QUARTER', 'YEAR', 'ALL', ALL TIME, FLOOR() or TIME_FLOOR()")))).verify();
    }

    @Test
    public void testInsertOnExternalDataSourceWithIncompatibleTimeColumnSignature() {
        ExternalDataSource restrictedSignature = new ExternalDataSource((InputSource)new InlineInputSource("100\nc200\n"), (InputFormat)new CsvInputFormat((List)ImmutableList.of((Object)"__time"), null, Boolean.valueOf(false), Boolean.valueOf(false), 0, null), RowSignature.builder().add("__time", ColumnType.STRING).build());
        this.testIngestionQuery().sql("INSERT INTO dst SELECT __time FROM %s PARTITIONED BY ALL TIME", this.externSql(restrictedSignature), new Object[0]).expectValidationError((Matcher<Throwable>)CoreMatchers.allOf((Matcher)CoreMatchers.instanceOf(DruidException.class), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"EXTERN function with __time column can be used when __time column is of type long")))).verify();
    }

    @Test
    public void testInsertWithSqlOuterLimit() {
        HashMap<String, Object> context = new HashMap<String, Object>(DEFAULT_CONTEXT);
        context.put("sqlOuterLimit", 100);
        this.testIngestionQuery().context(context).sql("INSERT INTO dst SELECT * FROM foo PARTITIONED BY ALL TIME").expectValidationError((Matcher<Throwable>)CalciteInsertDmlTest.invalidSqlIs("Context parameter [sqlOuterLimit] cannot be provided on operator [INSERT]")).verify();
    }

    @Test
    public void testErrorWithUnableToConstructColumnSignatureWithExtern() {
        String sqlString = "insert into dst \nselect time_parse(\"time\") as __time, * \nfrom table( \nextern(\n'{\"type\": \"s3\", \"uris\": [\\\"s3://imply-eng-datasets/qa/IngestionTest/wikipedia/files/wikiticker-2015-09-12-sampled.mini.json.gz\\\"]}',\n'{\"type\": \"json\"}',\n'[{\"name\": \"time\", \"type\": \"string\"}, {\"name\": \"channel\", \"type\": \"string\"}, {\"countryName\": \"string\"}]'\n)\n)\npartitioned by DAY\nclustered by channel";
        HashMap<String, Object> context = new HashMap<String, Object>(DEFAULT_CONTEXT);
        this.testIngestionQuery().context(context).sql("insert into dst \nselect time_parse(\"time\") as __time, * \nfrom table( \nextern(\n'{\"type\": \"s3\", \"uris\": [\\\"s3://imply-eng-datasets/qa/IngestionTest/wikipedia/files/wikiticker-2015-09-12-sampled.mini.json.gz\\\"]}',\n'{\"type\": \"json\"}',\n'[{\"name\": \"time\", \"type\": \"string\"}, {\"name\": \"channel\", \"type\": \"string\"}, {\"countryName\": \"string\"}]'\n)\n)\npartitioned by DAY\nclustered by channel").expectValidationError((Matcher<Throwable>)new DruidExceptionMatcher(DruidException.Persona.USER, DruidException.Category.INVALID_INPUT, "invalidInput").expectMessageContains("Cannot construct instance of `org.apache.druid.segment.column.ColumnSignature`, problem: Column name must be provided and non-empty")).verify();
    }

    @Test
    public void testErrorWhenBothRowSignatureAndExtendsProvidedToExtern() {
        String sqlString = "insert into dst \nselect time_parse(\"time\") as __time, * \nfrom table( \nextern(\n'{\"type\": \"s3\", \"uris\": [\\\"s3://imply-eng-datasets/qa/IngestionTest/wikipedia/files/wikiticker-2015-09-12-sampled.mini.json.gz\\\"]}',\n'{\"type\": \"json\"}',\n'[{\"name\": \"time\", \"type\": \"string\"}, {\"name\": \"channel\", \"type\": \"string\"}]'\n)\n) EXTEND (\"time\" VARCHAR, \"channel\" VARCHAR)\npartitioned by DAY\nclustered by channel";
        HashMap<String, Object> context = new HashMap<String, Object>(DEFAULT_CONTEXT);
        this.testIngestionQuery().context(context).sql("insert into dst \nselect time_parse(\"time\") as __time, * \nfrom table( \nextern(\n'{\"type\": \"s3\", \"uris\": [\\\"s3://imply-eng-datasets/qa/IngestionTest/wikipedia/files/wikiticker-2015-09-12-sampled.mini.json.gz\\\"]}',\n'{\"type\": \"json\"}',\n'[{\"name\": \"time\", \"type\": \"string\"}, {\"name\": \"channel\", \"type\": \"string\"}]'\n)\n) EXTEND (\"time\" VARCHAR, \"channel\" VARCHAR)\npartitioned by DAY\nclustered by channel").expectValidationError((Matcher<Throwable>)new DruidExceptionMatcher(DruidException.Persona.USER, DruidException.Category.INVALID_INPUT, "invalidInput").expectMessageContains("EXTERN requires either a [signature] value or an EXTEND clause, but not both")).verify();
    }

    @Test
    public void testErrorWhenNoneOfRowSignatureAndExtendsProvidedToExtern() {
        String sqlString = "insert into dst \nselect time_parse(\"time\") as __time, * \nfrom table( \nextern(\n'{\"type\": \"s3\", \"uris\": [\\\"s3://imply-eng-datasets/qa/IngestionTest/wikipedia/files/wikiticker-2015-09-12-sampled.mini.json.gz\\\"]}',\n'{\"type\": \"json\"}'\n)\n)\npartitioned by DAY\nclustered by channel";
        HashMap<String, Object> context = new HashMap<String, Object>(DEFAULT_CONTEXT);
        this.testIngestionQuery().context(context).sql("insert into dst \nselect time_parse(\"time\") as __time, * \nfrom table( \nextern(\n'{\"type\": \"s3\", \"uris\": [\\\"s3://imply-eng-datasets/qa/IngestionTest/wikipedia/files/wikiticker-2015-09-12-sampled.mini.json.gz\\\"]}',\n'{\"type\": \"json\"}'\n)\n)\npartitioned by DAY\nclustered by channel").expectValidationError((Matcher<Throwable>)new DruidExceptionMatcher(DruidException.Persona.USER, DruidException.Category.INVALID_INPUT, "invalidInput").expectMessageContains("EXTERN requires either a [signature] value or an EXTEND clause")).verify();
    }

    @Test
    public void testErrorWhenInputSourceInvalid() {
        String sqlString = "insert into dst \nselect time_parse(\"time\") as __time, * \nfrom table( \nextern(\n'{\"type\": \"local\"}',\n'{\"type\": \"json\"}',\n'[{\"name\": \"time\", \"type\": \"string\"}, {\"name\": \"channel\", \"type\": \"string\"}]'\n)\n)\npartitioned by DAY\nclustered by channel";
        HashMap<String, Object> context = new HashMap<String, Object>(DEFAULT_CONTEXT);
        this.testIngestionQuery().context(context).sql("insert into dst \nselect time_parse(\"time\") as __time, * \nfrom table( \nextern(\n'{\"type\": \"local\"}',\n'{\"type\": \"json\"}',\n'[{\"name\": \"time\", \"type\": \"string\"}, {\"name\": \"channel\", \"type\": \"string\"}]'\n)\n)\npartitioned by DAY\nclustered by channel").expectValidationError((Matcher<Throwable>)new DruidExceptionMatcher(DruidException.Persona.USER, DruidException.Category.INVALID_INPUT, "invalidInput").expectMessageContains("Invalid value for the field [inputSource]. Reason:")).verify();
    }
}

