/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite;

import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Module;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.avatica.SqlType;
import org.apache.druid.error.DruidException;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.sql.calcite.CalciteIngestionDmlTest;
import org.apache.druid.sql.calcite.SqlTestFrameworkConfig;
import org.apache.druid.sql.calcite.TempDirProducer;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.apache.druid.sql.calcite.util.DruidModuleCollection;
import org.apache.druid.sql.http.SqlParameter;
import org.apache.druid.storage.StorageConfig;
import org.apache.druid.storage.StorageConnectorModule;
import org.apache.druid.storage.StorageConnectorProvider;
import org.apache.druid.storage.local.LocalFileExportStorageProvider;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

@SqlTestFrameworkConfig.ComponentSupplier(value=ExportComponentSupplier.class)
public class CalciteExportTest
extends CalciteIngestionDmlTest {
    @Test
    @Disabled
    public void testReplaceIntoExtern() {
        this.testIngestionQuery().sql(StringUtils.format((String)"REPLACE INTO EXTERN(%s(exportPath => 'export')) AS CSV OVERWRITE ALL SELECT dim2 FROM foo", (Object[])new Object[]{"local"})).expectQuery((Query)Druids.newScanQueryBuilder().dataSource("foo").intervals(CalciteExportTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim2"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()).expectResources(CalciteExportTest.dataSourceRead("foo"), CalciteExportTest.externalWrite("local")).expectTarget("external", RowSignature.builder().add("dim2", ColumnType.STRING).build()).verify();
    }

    @Test
    public void testReplaceIntoExternShouldThrowUnsupportedException() {
        this.testIngestionQuery().sql(StringUtils.format((String)"REPLACE INTO EXTERN(%s(exportPath => 'export')) AS CSV OVERWRITE ALL SELECT dim2 FROM foo", (Object[])new Object[]{"local"})).expectValidationError((Matcher<Throwable>)CoreMatchers.allOf((Matcher)CoreMatchers.instanceOf(DruidException.class), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"REPLACE operations do no support EXTERN destinations. Use INSERT statements to write to an external destination.")))).verify();
    }

    @Test
    public void testExportWithoutRequiredParameter() {
        this.testIngestionQuery().sql(StringUtils.format((String)"INSERT INTO EXTERN(%s()) AS CSV SELECT dim2 FROM foo", (Object[])new Object[]{"local"})).expectValidationError((Matcher<Throwable>)CoreMatchers.allOf((Matcher)CoreMatchers.instanceOf(IllegalArgumentException.class), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Missing required creator property 'exportPath'")))).verify();
    }

    @Test
    public void testExportWithPartitionedBy() {
        this.testIngestionQuery().sql(StringUtils.format((String)"INSERT INTO EXTERN(%s(exportPath=>'/tmp/export')) AS CSV SELECT dim2 FROM foo PARTITIONED BY ALL", (Object[])new Object[]{"local"})).expectValidationError(DruidException.class, "Export statements do not support a PARTITIONED BY or CLUSTERED BY clause.").verify();
    }

    @Test
    public void testInsertIntoExtern() {
        this.testIngestionQuery().sql(StringUtils.format((String)"INSERT INTO EXTERN(%s(exportPath=>'/tmp/export')) AS CSV SELECT dim2 FROM foo", (Object[])new Object[]{"local"})).expectQuery((Query)Druids.newScanQueryBuilder().dataSource("foo").intervals(CalciteExportTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim2"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()).expectResources(CalciteExportTest.dataSourceRead("foo"), CalciteExportTest.externalWrite("local")).expectTarget("external", RowSignature.builder().add("dim2", ColumnType.STRING).build()).verify();
    }

    @Test
    public void testInsertIntoExternParameterized() {
        this.testIngestionQuery().sql(StringUtils.format((String)"INSERT INTO EXTERN(%s(exportPath=>'/tmp/export')) AS CSV SELECT dim2 FROM foo WHERE dim2=?", (Object[])new Object[]{"local"})).parameters(Collections.singletonList(new SqlParameter(SqlType.VARCHAR, (Object)"val"))).expectQuery((Query)Druids.newScanQueryBuilder().dataSource("foo").intervals(CalciteExportTest.querySegmentSpec(Filtration.eternity())).filters(CalciteExportTest.equality("dim2", "val", ColumnType.STRING)).columns(new String[]{"dim2"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()).expectResources(CalciteExportTest.dataSourceRead("foo"), CalciteExportTest.externalWrite("local")).expectTarget("external", RowSignature.builder().add("dim2", ColumnType.STRING).build()).verify();
    }

    @Test
    @Disabled
    public void testReplaceIntoExternParameterized() {
        this.testIngestionQuery().sql(StringUtils.format((String)"REPLACE INTO EXTERN(%s(exportPath=>'/tmp/export')) AS CSV SELECT dim2 FROM foo WHERE dim2=?", (Object[])new Object[]{"local"})).parameters(Collections.singletonList(new SqlParameter(SqlType.VARCHAR, (Object)"val"))).expectQuery((Query)Druids.newScanQueryBuilder().dataSource("foo").intervals(CalciteExportTest.querySegmentSpec(Filtration.eternity())).filters(CalciteExportTest.equality("dim2", "val", ColumnType.STRING)).columns(new String[]{"dim2"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()).expectResources(CalciteExportTest.dataSourceRead("foo"), CalciteExportTest.externalWrite("local")).expectTarget("external", RowSignature.builder().add("dim2", ColumnType.STRING).build()).verify();
    }

    @Test
    public void testExportWithoutFormat() {
        this.testIngestionQuery().sql("INSERT INTO EXTERN(testStorage(bucket=>'bucket1',prefix=>'prefix1',tempDir=>'/tempdir',chunkSize=>'5242880',maxRetry=>'1')) SELECT dim2 FROM foo").expectValidationError(DruidException.class, "Exporting rows into an EXTERN destination requires an AS clause to specify the format, but none was found.").verify();
    }

    @Test
    public void testWithUnsupportedStorageConnector() {
        this.testIngestionQuery().sql("insert into extern(nonExistent()) as csv select  __time, dim1 from foo").expectValidationError((Matcher<Throwable>)CoreMatchers.allOf((Matcher)CoreMatchers.instanceOf(IllegalArgumentException.class), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Could not resolve type id 'nonExistent' as a subtype")))).verify();
    }

    @Test
    public void testWithForbiddenDestination() {
        this.testIngestionQuery().sql(StringUtils.format((String)"insert into extern(%s(exportPath=>'/tmp/export')) as csv select  __time, dim1 from foo", (Object[])new Object[]{"forbiddenDestination"})).expectValidationError(ForbiddenException.class).verify();
    }

    @Test
    public void testSelectFromTableNamedExport() {
        this.testIngestionQuery().sql("INSERT INTO csv SELECT dim2 FROM foo PARTITIONED BY ALL").expectQuery((Query)Druids.newScanQueryBuilder().dataSource("foo").intervals(CalciteExportTest.querySegmentSpec(Filtration.eternity())).columns(new String[]{"dim2"}).columnTypes(new ColumnType[]{ColumnType.STRING}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build()).expectResources(CalciteExportTest.dataSourceRead("foo"), CalciteExportTest.dataSourceWrite("csv")).expectTarget("csv", RowSignature.builder().add("dim2", ColumnType.STRING).build()).verify();
    }

    @Test
    public void testNormalInsertWithFormat() {
        this.testIngestionQuery().sql("REPLACE INTO testTable AS CSV OVERWRITE ALL SELECT dim2 FROM foo PARTITIONED BY ALL").expectValidationError(DruidException.class, "The AS <format> clause should only be specified while exporting rows into an EXTERN destination.").verify();
    }

    @Test
    public void testUnsupportedExportFormat() {
        this.testIngestionQuery().sql("REPLACE INTO testTable AS JSON OVERWRITE ALL SELECT dim2 FROM foo PARTITIONED BY ALL").expectValidationError(DruidException.class, "The AS <format> clause should only be specified while exporting rows into an EXTERN destination.").verify();
    }

    protected static class ExportComponentSupplier
    extends CalciteIngestionDmlTest.IngestionDmlComponentSupplier {
        public ExportComponentSupplier(TempDirProducer tempFolderProducer) {
            super(tempFolderProducer);
        }

        @Override
        public DruidModule getCoreModule() {
            return DruidModuleCollection.of(new Module[]{super.getCoreModule(), new StorageConnectorModule()});
        }

        @Override
        public DruidModule getOverrideModule() {
            return DruidModuleCollection.of(new Module[]{super.getOverrideModule(), new LocalOverrideModule()});
        }

        private static final class LocalOverrideModule
        implements DruidModule {
            private LocalOverrideModule() {
            }

            public List<? extends com.fasterxml.jackson.databind.Module> getJacksonModules() {
                return ImmutableList.of((Object)new SimpleModule(StorageConnectorProvider.class.getSimpleName()).registerSubtypes(new NamedType[]{new NamedType(LocalFileExportStorageProvider.class, "forbiddenDestination")}));
            }

            public void configure(Binder binder) {
                binder.bind(StorageConfig.class).toInstance((Object)new StorageConfig("/tmp/export"));
            }
        }
    }
}

