/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.avatica;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.remote.TypedValue;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.segment.join.JoinableFactoryWrapper;
import org.apache.druid.server.QueryStackTests;
import org.apache.druid.server.SpecificSegmentsQuerySegmentWalker;
import org.apache.druid.server.security.AllowAllAuthenticator;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthTestUtils;
import org.apache.druid.sql.SqlQueryPlus;
import org.apache.druid.sql.SqlStatementFactory;
import org.apache.druid.sql.avatica.AvaticaServerConfig;
import org.apache.druid.sql.avatica.DruidJdbcPreparedStatement;
import org.apache.druid.sql.avatica.DruidJdbcResultSet;
import org.apache.druid.sql.avatica.DruidJdbcStatement;
import org.apache.druid.sql.calcite.planner.CalciteRulesManager;
import org.apache.druid.sql.calcite.planner.CatalogResolver;
import org.apache.druid.sql.calcite.planner.DruidOperatorTable;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.planner.PlannerFactory;
import org.apache.druid.sql.calcite.run.SqlEngine;
import org.apache.druid.sql.calcite.schema.DruidSchemaCatalog;
import org.apache.druid.sql.calcite.util.CalciteTestBase;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.apache.druid.sql.hook.DruidHookDispatcher;
import org.junit.Assert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class DruidStatementTest
extends CalciteTestBase {
    private static String SUB_QUERY_WITH_ORDER_BY = "select T20.F13 as F22\nfrom (SELECT DISTINCT dim1 as F13 FROM druid.foo T10) T20\norder by T20.F13 ASC";
    private static String SELECT_FROM_FOO = "SELECT __time, cnt, dim1, dim2, m1 FROM druid.foo";
    private static String SELECT_STAR_FROM_FOO = "SELECT * FROM druid.foo";
    private static SpecificSegmentsQuerySegmentWalker walker;
    private static QueryRunnerFactoryConglomerate conglomerate;
    private static Closer resourceCloser;
    private SqlStatementFactory sqlStatementFactory;

    @BeforeAll
    public static void setUpClass(@TempDir File tempDir) {
        resourceCloser = Closer.create();
        conglomerate = QueryStackTests.createQueryRunnerFactoryConglomerate((Closer)resourceCloser);
        walker = CalciteTests.createMockWalker(conglomerate, tempDir);
        resourceCloser.register((Closeable)walker);
    }

    @AfterAll
    public static void tearDownClass() throws IOException {
        resourceCloser.close();
    }

    @BeforeEach
    public void setUp() {
        PlannerConfig plannerConfig = new PlannerConfig();
        DruidOperatorTable operatorTable = CalciteTests.createOperatorTable();
        ExprMacroTable macroTable = CalciteTests.createExprMacroTable();
        DruidSchemaCatalog rootSchema = CalciteTests.createMockRootSchema(conglomerate, walker, plannerConfig, AuthTestUtils.TEST_AUTHORIZER_MAPPER);
        JoinableFactoryWrapper joinableFactoryWrapper = CalciteTests.createJoinableFactoryWrapper();
        PlannerFactory plannerFactory = new PlannerFactory(rootSchema, operatorTable, macroTable, plannerConfig, AuthTestUtils.TEST_AUTHORIZER_MAPPER, CalciteTests.getJsonMapper(), "druid", new CalciteRulesManager((Set)ImmutableSet.of()), joinableFactoryWrapper, CatalogResolver.NULL_RESOLVER, new AuthConfig(), new DruidHookDispatcher());
        this.sqlStatementFactory = CalciteTests.createSqlStatementFactory((SqlEngine)CalciteTests.createMockSqlEngine((QuerySegmentWalker)walker, conglomerate), plannerFactory);
    }

    @AfterEach
    public void tearDown() {
    }

    private DruidJdbcStatement jdbcStatement() {
        return new DruidJdbcStatement("", 0, Collections.emptyMap(), this.sqlStatementFactory, new DruidJdbcResultSet.ResultFetcherFactory(AvaticaServerConfig.DEFAULT_FETCH_TIMEOUT_MS));
    }

    @Test
    public void testSubQueryWithOrderByDirect() {
        SqlQueryPlus queryPlus = new SqlQueryPlus(SUB_QUERY_WITH_ORDER_BY, null, null, AllowAllAuthenticator.ALLOW_ALL_RESULT);
        try (DruidJdbcStatement statement = this.jdbcStatement();){
            statement.execute(queryPlus, -1L);
            Meta.Frame frame = statement.nextFrame(0L, 6);
            Assert.assertEquals((Object)this.subQueryWithOrderByResults(), (Object)frame);
            Assert.assertTrue((boolean)statement.isDone());
        }
    }

    @Test
    public void testFetchPastEOFDirect() {
        SqlQueryPlus queryPlus = new SqlQueryPlus(SUB_QUERY_WITH_ORDER_BY, null, null, AllowAllAuthenticator.ALLOW_ALL_RESULT);
        try (DruidJdbcStatement statement = this.jdbcStatement();){
            statement.execute(queryPlus, -1L);
            Meta.Frame frame = statement.nextFrame(0L, 6);
            Assert.assertEquals((Object)this.subQueryWithOrderByResults(), (Object)frame);
            Assert.assertTrue((boolean)statement.isDone());
            try {
                statement.nextFrame(6L, 6);
                Assert.fail();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Test
    public void testSkipExecuteDirect() {
        try (DruidJdbcStatement statement = this.jdbcStatement();){
            statement.nextFrame(0L, 6);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testFetchAfterResultCloseDirect() {
        SqlQueryPlus queryPlus = new SqlQueryPlus(SUB_QUERY_WITH_ORDER_BY, null, null, AllowAllAuthenticator.ALLOW_ALL_RESULT);
        try (DruidJdbcStatement statement = this.jdbcStatement();){
            statement.execute(queryPlus, -1L);
            statement.nextFrame(0L, 6);
            statement.closeResultSet();
            statement.nextFrame(0L, 6);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSubQueryWithOrderByDirectTwice() {
        SqlQueryPlus queryPlus = new SqlQueryPlus(SUB_QUERY_WITH_ORDER_BY, null, null, AllowAllAuthenticator.ALLOW_ALL_RESULT);
        try (DruidJdbcStatement statement = this.jdbcStatement();){
            statement.execute(queryPlus, -1L);
            Meta.Frame frame = statement.nextFrame(0L, 6);
            Assert.assertEquals((Object)this.subQueryWithOrderByResults(), (Object)frame);
            Assert.assertTrue((boolean)statement.isDone());
            statement.execute(queryPlus, -1L);
            frame = statement.nextFrame(0L, 6);
            Assert.assertEquals((Object)this.subQueryWithOrderByResults(), (Object)frame);
            Assert.assertTrue((boolean)statement.isDone());
        }
    }

    private Meta.Frame subQueryWithOrderByResults() {
        return Meta.Frame.create((long)0L, (boolean)true, (List)Lists.newArrayList((Object[])new Object[]{new Object[]{""}, new Object[]{"1"}, new Object[]{"10.1"}, new Object[]{"2"}, new Object[]{"abc"}, new Object[]{"def"}}));
    }

    @Test
    public void testSelectAllInFirstFrameDirect() {
        SqlQueryPlus queryPlus = new SqlQueryPlus(SELECT_FROM_FOO, null, null, AllowAllAuthenticator.ALLOW_ALL_RESULT);
        try (DruidJdbcStatement statement = this.jdbcStatement();){
            statement.execute(queryPlus, -1L);
            Meta.Frame frame = statement.nextFrame(0L, 6);
            Assert.assertEquals((Object)Meta.Frame.create((long)0L, (boolean)true, (List)Lists.newArrayList((Object[])new Object[]{new Object[]{DateTimes.of((String)"2000-01-01").getMillis(), 1L, "", "a", Float.valueOf(1.0f)}, new Object[]{DateTimes.of((String)"2000-01-02").getMillis(), 1L, "10.1", null, Float.valueOf(2.0f)}, new Object[]{DateTimes.of((String)"2000-01-03").getMillis(), 1L, "2", "", Float.valueOf(3.0f)}, new Object[]{DateTimes.of((String)"2001-01-01").getMillis(), 1L, "1", "a", Float.valueOf(4.0f)}, new Object[]{DateTimes.of((String)"2001-01-02").getMillis(), 1L, "def", "abc", Float.valueOf(5.0f)}, new Object[]{DateTimes.of((String)"2001-01-03").getMillis(), 1L, "abc", null, Float.valueOf(6.0f)}})), (Object)frame);
            Assert.assertTrue((boolean)statement.isDone());
        }
    }

    @Test
    public void testSelectSplitOverTwoFramesDirect() {
        SqlQueryPlus queryPlus = new SqlQueryPlus(SELECT_FROM_FOO, null, null, AllowAllAuthenticator.ALLOW_ALL_RESULT);
        try (DruidJdbcStatement statement = this.jdbcStatement();){
            statement.execute(queryPlus, -1L);
            Assert.assertEquals((long)0L, (long)statement.getCurrentOffset());
            Assert.assertFalse((boolean)statement.isDone());
            Meta.Frame frame = statement.nextFrame(0L, 2);
            Assert.assertEquals((Object)this.firstFrameResults(), (Object)frame);
            Assert.assertFalse((boolean)statement.isDone());
            Assert.assertEquals((long)2L, (long)statement.getCurrentOffset());
            frame = statement.nextFrame(2L, 10);
            Assert.assertEquals((Object)this.secondFrameResults(), (Object)frame);
            Assert.assertTrue((boolean)statement.isDone());
        }
    }

    @Test
    public void testTwoFramesAutoCloseDirect() {
        SqlQueryPlus queryPlus = new SqlQueryPlus(SELECT_FROM_FOO, null, null, AllowAllAuthenticator.ALLOW_ALL_RESULT);
        try (DruidJdbcStatement statement = this.jdbcStatement();){
            statement.execute(queryPlus, -1L);
            Meta.Frame frame = statement.nextFrame(0L, 2);
            Assert.assertEquals((Object)this.firstFrameResults(), (Object)frame);
            Assert.assertFalse((boolean)statement.isDone());
            statement.execute(queryPlus, -1L);
            frame = statement.nextFrame(0L, 2);
            Assert.assertEquals((Object)this.firstFrameResults(), (Object)frame);
            Assert.assertFalse((boolean)statement.isDone());
            frame = statement.nextFrame(2L, 10);
            Assert.assertEquals((Object)this.secondFrameResults(), (Object)frame);
            Assert.assertTrue((boolean)statement.isDone());
        }
    }

    @Test
    public void testTwoFramesCloseWithResultSetDirect() {
        SqlQueryPlus queryPlus = new SqlQueryPlus(SELECT_FROM_FOO, null, null, AllowAllAuthenticator.ALLOW_ALL_RESULT);
        try (DruidJdbcStatement statement = this.jdbcStatement();){
            statement.execute(queryPlus, -1L);
            Meta.Frame frame = statement.nextFrame(0L, 2);
            Assert.assertEquals((Object)this.firstFrameResults(), (Object)frame);
            Assert.assertFalse((boolean)statement.isDone());
        }
    }

    private Meta.Frame firstFrameResults() {
        return Meta.Frame.create((long)0L, (boolean)false, (List)Lists.newArrayList((Object[])new Object[]{new Object[]{DateTimes.of((String)"2000-01-01").getMillis(), 1L, "", "a", Float.valueOf(1.0f)}, new Object[]{DateTimes.of((String)"2000-01-02").getMillis(), 1L, "10.1", null, Float.valueOf(2.0f)}}));
    }

    private Meta.Frame secondFrameResults() {
        return Meta.Frame.create((long)2L, (boolean)true, (List)Lists.newArrayList((Object[])new Object[]{new Object[]{DateTimes.of((String)"2000-01-03").getMillis(), 1L, "2", "", Float.valueOf(3.0f)}, new Object[]{DateTimes.of((String)"2001-01-01").getMillis(), 1L, "1", "a", Float.valueOf(4.0f)}, new Object[]{DateTimes.of((String)"2001-01-02").getMillis(), 1L, "def", "abc", Float.valueOf(5.0f)}, new Object[]{DateTimes.of((String)"2001-01-03").getMillis(), 1L, "abc", null, Float.valueOf(6.0f)}}));
    }

    @Test
    public void testSignatureDirect() {
        SqlQueryPlus queryPlus = new SqlQueryPlus(SELECT_STAR_FROM_FOO, null, null, AllowAllAuthenticator.ALLOW_ALL_RESULT);
        try (DruidJdbcStatement statement = this.jdbcStatement();){
            statement.execute(queryPlus, -1L);
            this.verifySignature(statement.getSignature());
        }
    }

    private void verifySignature(Meta.Signature signature) {
        Assert.assertEquals((Object)Meta.CursorFactory.ARRAY, (Object)signature.cursorFactory);
        Assert.assertEquals((Object)Meta.StatementType.SELECT, (Object)signature.statementType);
        Assert.assertEquals((Object)SELECT_STAR_FROM_FOO, (Object)signature.sql);
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new ArrayList[]{Lists.newArrayList((Object[])new String[]{"__time", "TIMESTAMP", "java.math.BigDecimal"}), Lists.newArrayList((Object[])new String[]{"dim1", "VARCHAR", "java.lang.String"}), Lists.newArrayList((Object[])new String[]{"dim2", "VARCHAR", "java.lang.String"}), Lists.newArrayList((Object[])new String[]{"dim3", "VARCHAR", "java.lang.String"}), Lists.newArrayList((Object[])new String[]{"cnt", "BIGINT", "java.math.BigDecimal"}), Lists.newArrayList((Object[])new String[]{"m1", "FLOAT", "java.math.BigDecimal"}), Lists.newArrayList((Object[])new String[]{"m2", "DOUBLE", "java.math.BigDecimal"}), Lists.newArrayList((Object[])new String[]{"unique_dim1", "OTHER", "java.lang.Object"})}), (Object)Lists.transform((List)signature.columns, (Function)new Function<ColumnMetaData, List<String>>(){

            public List<String> apply(ColumnMetaData columnMetaData) {
                return Lists.newArrayList((Object[])new String[]{columnMetaData.label, columnMetaData.type.name, columnMetaData.type.rep.clazz.getName()});
            }
        }));
    }

    private DruidJdbcPreparedStatement jdbcPreparedStatement(SqlQueryPlus queryPlus) {
        return new DruidJdbcPreparedStatement("", 0, this.sqlStatementFactory.preparedStatement(queryPlus), Long.MAX_VALUE, new DruidJdbcResultSet.ResultFetcherFactory(AvaticaServerConfig.DEFAULT_FETCH_TIMEOUT_MS));
    }

    @Test
    public void testSubQueryWithOrderByPrepared() {
        String sql = "select T20.F13 as F22  from (SELECT DISTINCT dim1 as F13 FROM druid.foo T10) T20 order by T20.F13 ASC";
        SqlQueryPlus queryPlus = new SqlQueryPlus("select T20.F13 as F22  from (SELECT DISTINCT dim1 as F13 FROM druid.foo T10) T20 order by T20.F13 ASC", null, null, AllowAllAuthenticator.ALLOW_ALL_RESULT);
        try (DruidJdbcPreparedStatement statement = this.jdbcPreparedStatement(queryPlus);){
            statement.prepare();
            statement.execute(Collections.emptyList());
            Meta.Frame frame = statement.nextFrame(0L, 6);
            Assert.assertEquals((Object)this.subQueryWithOrderByResults(), (Object)frame);
            Assert.assertTrue((boolean)statement.isDone());
        }
    }

    @Test
    public void testSubQueryWithOrderByPreparedTwice() {
        String sql = "select T20.F13 as F22  from (SELECT DISTINCT dim1 as F13 FROM druid.foo T10) T20 order by T20.F13 ASC";
        SqlQueryPlus queryPlus = new SqlQueryPlus("select T20.F13 as F22  from (SELECT DISTINCT dim1 as F13 FROM druid.foo T10) T20 order by T20.F13 ASC", null, null, AllowAllAuthenticator.ALLOW_ALL_RESULT);
        try (DruidJdbcPreparedStatement statement = this.jdbcPreparedStatement(queryPlus);){
            statement.prepare();
            statement.execute(Collections.emptyList());
            Meta.Frame frame = statement.nextFrame(0L, 6);
            Assert.assertEquals((Object)this.subQueryWithOrderByResults(), (Object)frame);
            Assert.assertTrue((boolean)statement.isDone());
            statement.execute(Collections.emptyList());
            frame = statement.nextFrame(0L, 6);
            Assert.assertEquals((Object)this.subQueryWithOrderByResults(), (Object)frame);
            Assert.assertTrue((boolean)statement.isDone());
        }
    }

    @Test
    public void testSignaturePrepared() {
        SqlQueryPlus queryPlus = new SqlQueryPlus(SELECT_STAR_FROM_FOO, null, null, AllowAllAuthenticator.ALLOW_ALL_RESULT);
        try (DruidJdbcPreparedStatement statement = this.jdbcPreparedStatement(queryPlus);){
            statement.prepare();
            this.verifySignature(statement.getSignature());
        }
    }

    @Test
    public void testParameters() {
        SqlQueryPlus queryPlus = new SqlQueryPlus("SELECT COUNT(*) AS cnt FROM sys.servers WHERE servers.host = ?", null, null, AllowAllAuthenticator.ALLOW_ALL_RESULT);
        Meta.Frame expected = Meta.Frame.create((long)0L, (boolean)true, Collections.singletonList(new Object[]{1L}));
        List<TypedValue> matchingParams = Collections.singletonList(TypedValue.ofLocal((ColumnMetaData.Rep)ColumnMetaData.Rep.STRING, (Object)"dummy"));
        try (DruidJdbcPreparedStatement statement = this.jdbcPreparedStatement(queryPlus);){
            statement.prepare();
            statement.execute(matchingParams);
            Meta.Frame frame = statement.nextFrame(0L, 6);
            Assert.assertEquals((Object)expected, (Object)frame);
            statement.execute(matchingParams);
            frame = statement.nextFrame(0L, 6);
            Assert.assertEquals((Object)expected, (Object)frame);
            statement.execute(Collections.singletonList(TypedValue.ofLocal((ColumnMetaData.Rep)ColumnMetaData.Rep.STRING, (Object)"foo")));
            frame = statement.nextFrame(0L, 6);
            Assert.assertEquals((Object)Meta.Frame.create((long)0L, (boolean)true, Collections.emptyList()), (Object)frame);
        }
    }
}

