/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.quidem;

import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.hydromatic.quidem.CommandHandler;
import net.hydromatic.quidem.Quidem;
import org.apache.calcite.test.DiffTestCase;
import org.apache.calcite.util.Closer;
import org.apache.calcite.util.Util;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.druid.concurrent.Threads;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.quidem.DruidAvaticaTestDriver;
import org.apache.druid.quidem.DruidQuidemCommandHandler;
import org.apache.druid.quidem.DruidQuidemConnectionFactory;
import org.apache.druid.sql.calcite.MultiComponentSupplier;
import org.apache.druid.sql.calcite.SqlTestFrameworkConfig;
import org.apache.druid.sql.calcite.util.SqlTestFramework;
import org.junit.AssumptionViolatedException;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class DruidQuidemTestBase {
    public static final String IQ_SUFFIX = ".iq";
    private static final String OVERWRITE_PROPERTY = "quidem.overwrite";
    private static final String PROPERTY_FILTER = "quidem.filter";
    private FileFilter filter = TrueFileFilter.INSTANCE;
    private DruidQuidemRunner druidQuidemRunner;

    public DruidQuidemTestBase(CommandHandler commandHandler) {
        this(new DruidQuidemRunner(commandHandler, Quidem::new));
    }

    public DruidQuidemTestBase(DruidQuidemRunner druidQuidemRunner) {
        Object filterStr = System.getProperty(PROPERTY_FILTER, null);
        if (filterStr != null) {
            if (!((String)filterStr).endsWith("*") && !((String)filterStr).endsWith(IQ_SUFFIX)) {
                filterStr = (String)filterStr + IQ_SUFFIX;
            }
            this.filter = new WildcardFileFilter((String)filterStr);
        }
        this.druidQuidemRunner = druidQuidemRunner;
    }

    public List<QuidemTestCaseConfiguration> getTestConfigs() throws IOException {
        ArrayList<QuidemTestCaseConfiguration> ret = new ArrayList<QuidemTestCaseConfiguration>();
        List<String> fileNames = this.getFileNames();
        for (String file : fileNames) {
            try {
                ret.addAll(this.getConfigurationsFor(file));
            }
            catch (Exception e) {
                throw DruidException.defensive((Throwable)e, (String)"While processing configurations for quidem file [%s]", (Object[])new Object[]{file});
            }
        }
        return ret;
    }

    private List<QuidemTestCaseConfiguration> getConfigurationsFor(String testFileName) throws IOException {
        File inFile = new File(this.getTestRoot(), testFileName);
        ArrayList<QuidemTestCaseConfiguration> ret = new ArrayList<QuidemTestCaseConfiguration>();
        for (Class<? extends SqlTestFramework.QueryComponentSupplier> supplier : this.collectSuppliers(inFile)) {
            String supplierName = supplier == null ? null : supplier.getSimpleName();
            ret.add(new QuidemTestCaseConfiguration(supplierName, testFileName));
        }
        return ret;
    }

    private List<Class<? extends SqlTestFramework.QueryComponentSupplier>> collectSuppliers(File inFile) throws IOException {
        Set<Class<MultiComponentSupplier>> metaSuppliers = this.collectMetaSuppliers(inFile);
        switch (metaSuppliers.size()) {
            case 0: {
                return Collections.singletonList(null);
            }
            case 1: {
                return MultiComponentSupplier.getSuppliers((Class)Iterables.getOnlyElement(metaSuppliers));
            }
        }
        throw DruidException.defensive((String)"Multiple MetaComponentSuppliers found [%s].", (Object[])new Object[]{metaSuppliers});
    }

    private Set<Class<MultiComponentSupplier>> collectMetaSuppliers(File inFile) throws IOException {
        HashSet<Class<MultiComponentSupplier>> metaSuppliers = new HashSet<Class<MultiComponentSupplier>>();
        for (String line : Files.readLines((File)inFile, (Charset)StandardCharsets.UTF_8)) {
            String[] parts;
            if (!line.startsWith("!use") || (parts = line.split(" ")).length != 2) continue;
            SqlTestFrameworkConfig cfg = SqlTestFrameworkConfig.fromURL(parts[1]);
            this.validateFrameworkConfig(cfg);
            if (!MultiComponentSupplier.class.isAssignableFrom(cfg.componentSupplier)) continue;
            metaSuppliers.add(cfg.componentSupplier);
        }
        return metaSuppliers;
    }

    protected void validateFrameworkConfig(SqlTestFrameworkConfig cfg) {
    }

    @ParameterizedTest
    @MethodSource(value={"getTestConfigs"})
    public void test(QuidemTestCaseConfiguration testConfig) throws Exception {
        String testName = testConfig.getTestName();
        File inFile = new File(this.getTestRoot(), testConfig.fileName);
        File outFile = new File(inFile.getParentFile(), testName + ".iq.out");
        try (AutoCloseable closeable = Threads.withThreadName((String)testName);){
            this.druidQuidemRunner.run(inFile, outFile, testConfig.componentSupplierName);
        }
        catch (Error e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof AssumptionViolatedException) {
                AssumptionViolatedException assumptionViolatedException = (AssumptionViolatedException)cause;
                throw assumptionViolatedException;
            }
            throw e;
        }
    }

    protected CommandHandler getCommandHandler() {
        return new DruidQuidemCommandHandler();
    }

    protected final List<String> getFileNames() throws IOException {
        ArrayList<String> ret = new ArrayList<String>();
        File testRoot = this.getTestRoot();
        if (!testRoot.exists()) {
            throw new FileNotFoundException(StringUtils.format((String)"testRoot [%s] doesn't exists!", (Object[])new Object[]{testRoot}));
        }
        for (File f : Files.fileTraverser().breadthFirst((Object)testRoot)) {
            if (!this.isTestIncluded(f)) continue;
            Path relativePath = testRoot.toPath().relativize(f.toPath());
            ret.add(relativePath.toString());
        }
        if (ret.isEmpty()) {
            throw new IAE("There are no test cases in directory [%s] or there are no matches to filter [%s]", new Object[]{testRoot, this.filter});
        }
        Collections.sort(ret);
        return ret;
    }

    private boolean isTestIncluded(File f) {
        return !f.isDirectory() && f.getName().endsWith(IQ_SUFFIX) && this.filter.accept(f);
    }

    protected abstract File getTestRoot();

    @AfterAll
    public static void afterAll() {
        DruidAvaticaTestDriver.CONFIG_STORE.close();
    }

    public static class DruidQuidemRunner {
        private CommandHandler commandHandler;
        private Function<Quidem.Config, Quidem> quidemMaker;

        public DruidQuidemRunner() {
            this(new DruidQuidemCommandHandler(), Quidem::new);
        }

        public DruidQuidemRunner(CommandHandler commandHandler, Function<Quidem.Config, Quidem> quidemMaker) {
            this.commandHandler = commandHandler;
            this.quidemMaker = quidemMaker;
        }

        public void run(File inFile) throws Exception {
            File outFile = new File(inFile.getParent(), inFile.getName() + ".out");
            this.run(inFile, outFile, null);
        }

        public void run(File inFile, File outFile, String componentSupplier) throws Exception {
            FileUtils.mkdirp((File)outFile.getParentFile());
            try (BufferedReader reader = Util.reader((File)inFile);
                 PrintWriter writer = Util.printWriter((File)outFile);
                 Closer closer = new Closer();){
                DruidQuidemConnectionFactory connectionFactory = new DruidQuidemConnectionFactory();
                if (componentSupplier != null) {
                    connectionFactory.onSet("componentSupplier", componentSupplier);
                }
                Quidem.ConfigBuilder configBuilder = Quidem.configBuilder().withConnectionFactory((Quidem.ConnectionFactory)connectionFactory).withPropertyHandler((Quidem.PropertyHandler)connectionFactory).withEnv(connectionFactory::envLookup).withCommandHandler(this.commandHandler);
                Quidem.Config config = configBuilder.withReader((Reader)reader).withWriter((Writer)writer).withStackLimit(-1).build();
                this.quidemMaker.apply(config).execute();
            }
            catch (Exception e) {
                throw new RE((Throwable)e, "Encountered exception while running [%s]", new Object[]{inFile});
            }
            String diff = DiffTestCase.diff((File)inFile, (File)outFile);
            if (!diff.isEmpty()) {
                if (DruidQuidemRunner.isOverwrite()) {
                    Files.copy((File)outFile, (File)inFile);
                } else if (DruidQuidemRunner.isUnsupportedComponentSupplier(diff, componentSupplier)) {
                    System.out.println("Skipping verification of unsupported componentSupplier " + componentSupplier);
                } else {
                    Assertions.fail((String)("Files differ: " + String.valueOf(outFile) + " " + String.valueOf(inFile) + "\n" + diff));
                }
            }
        }

        public static boolean isOverwrite() {
            String property = System.getProperty(DruidQuidemTestBase.OVERWRITE_PROPERTY, "false");
            return property.length() == 0 || Boolean.valueOf(property) != false;
        }

        private static boolean isUnsupportedComponentSupplier(String diff, String componentSupplier) {
            return diff.contains(StringUtils.format((String)"Unsupported componentSupplier[%s], skipping verification of diff.", (Object[])new Object[]{componentSupplier}));
        }
    }

    protected static class QuidemTestCaseConfiguration {
        final String fileName;
        final String componentSupplierName;

        public QuidemTestCaseConfiguration(String componentSupplierName, String fileName) {
            this.fileName = fileName;
            this.componentSupplierName = componentSupplierName;
        }

        public String getTestName() {
            if (this.componentSupplierName == null) {
                return this.fileName;
            }
            return StringUtils.format((String)"%s@%s", (Object[])new Object[]{this.fileName, this.componentSupplierName});
        }

        public String toString() {
            return this.getTestName();
        }
    }
}

