/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.quidem;

import com.google.inject.Injector;
import java.net.URI;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.hydromatic.quidem.Quidem;
import org.apache.druid.quidem.DruidAvaticaTestDriver;
import org.apache.druid.quidem.DruidConnectionExtras;
import org.apache.druid.sql.calcite.run.SqlEngine;
import org.apache.druid.sql.calcite.util.SqlTestFramework;
import org.apache.http.client.utils.URIBuilder;

public class DruidQuidemConnectionFactory
implements Quidem.ConnectionFactory,
Quidem.PropertyHandler {
    private Properties props = new Properties();
    private Map<String, String> envs = new HashMap<String, String>();

    public DruidQuidemConnectionFactory() {
        new DruidAvaticaTestDriver();
    }

    public Connection connect(String name, boolean reference) throws Exception {
        URI uri = URI.create(name);
        if (uri.getScheme().endsWith("test")) {
            String customSupplier = this.props.getProperty("componentSupplier");
            if (customSupplier != null) {
                URIBuilder builder = new URIBuilder(uri);
                builder.addParameter("componentSupplier", customSupplier);
                builder.setHost("");
                name = builder.build().toString();
            }
            Connection connection = DriverManager.getConnection(name, this.props);
            this.envs = DruidQuidemConnectionFactory.buildEnvsForConnection(connection);
            return connection;
        }
        throw new RuntimeException("unknown connection '" + name + "'");
    }

    private static Map<String, String> buildEnvsForConnection(Connection connection) {
        HashMap<String, String> envs = new HashMap<String, String>();
        DruidConnectionExtras extras = DruidConnectionExtras.unwrapOrThrow(connection);
        Injector injector = extras.getInjector();
        SqlTestFramework.QueryComponentSupplier supplier = (SqlTestFramework.QueryComponentSupplier)injector.getInstance(SqlTestFramework.QueryComponentSupplier.class);
        Class<? extends SqlEngine> engineClazz = supplier.getSqlEngineClass();
        String engineName = engineClazz.getName();
        boolean isDart = engineName.contains("Dart");
        boolean isMSQ = engineName.contains("MSQ");
        boolean isNative = engineName.contains("Native");
        envs.put("isDart", String.valueOf(isDart));
        envs.put("isMSQ", String.valueOf(isMSQ));
        envs.put("isNative", String.valueOf(isNative));
        envs.put("isTaskBased", String.valueOf(isDart || isMSQ));
        return envs;
    }

    public Object envLookup(String key) {
        return this.envs.get(key);
    }

    public void onSet(String key, Object value) {
        this.props.setProperty(key, value.toString());
    }
}

