/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.quidem;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.inject.Injector;
import java.io.Closeable;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.hydromatic.quidem.AbstractCommand;
import net.hydromatic.quidem.Command;
import net.hydromatic.quidem.CommandHandler;
import net.hydromatic.quidem.Quidem;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelHomogeneousShuttle;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.hint.Hintable;
import org.apache.calcite.sql.SqlExplainFormat;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.util.Util;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.Query;
import org.apache.druid.quidem.DruidConnectionExtras;
import org.apache.druid.sql.calcite.BaseCalciteQueryTest;
import org.apache.druid.sql.calcite.SqlTestFrameworkConfig;
import org.apache.druid.sql.calcite.rel.DruidRel;
import org.apache.druid.sql.hook.DruidHook;
import org.apache.druid.sql.hook.DruidHookDispatcher;
import org.junit.Assume;

public class DruidQuidemCommandHandler
implements CommandHandler {
    public Command parseCommand(List<String> lines, List<String> content, String line) {
        if (line.startsWith("convertedPlan")) {
            return new ConvertedPlanCommand(lines, content);
        }
        if (line.startsWith("logicalPlan")) {
            return new LogicalPlanCommand(lines, content);
        }
        if (line.startsWith("druidPlan")) {
            return new DruidPlanCommand(lines, content);
        }
        if (line.startsWith("hints")) {
            return new HintPlanCommand(lines, content);
        }
        if (line.startsWith("nativePlan")) {
            return new NativePlanCommand(lines, content);
        }
        if (line.startsWith("msqPlan")) {
            return new MSQPlanCommand(lines, content);
        }
        if (line.startsWith("disabled")) {
            return new DisabledCommand(lines, content, line);
        }
        return null;
    }

    static class ConvertedPlanCommand
    extends AbstractRelPlanCommand {
        ConvertedPlanCommand(List<String> lines, List<String> content) {
            super(lines, content, (DruidHook.HookKey<RelNode>)DruidHook.CONVERTED_PLAN);
        }
    }

    static class LogicalPlanCommand
    extends AbstractRelPlanCommand {
        LogicalPlanCommand(List<String> lines, List<String> content) {
            super(lines, content, (DruidHook.HookKey<RelNode>)DruidHook.LOGICAL_PLAN);
        }
    }

    static class DruidPlanCommand
    extends AbstractRelPlanCommand {
        DruidPlanCommand(List<String> lines, List<String> content) {
            super(lines, content, (DruidHook.HookKey<RelNode>)DruidHook.DRUID_PLAN);
        }
    }

    static class HintPlanCommand
    extends AbstractRelPlanCommand {
        HintPlanCommand(List<String> lines, List<String> content) {
            super(lines, content, (DruidHook.HookKey<RelNode>)DruidHook.DRUID_PLAN);
        }

        @Override
        protected String convertRelToString(RelNode node) {
            HintCollector collector = new HintCollector();
            node.accept((RelShuttle)collector);
            return collector.getCollectedHintsAsString();
        }

        private static class HintCollector
        extends RelHomogeneousShuttle {
            private final List<String> hintsCollect = new ArrayList<String>();

            HintCollector() {
            }

            public RelNode visit(RelNode relNode) {
                Hintable hintableRelNode;
                if (relNode instanceof Hintable && !(hintableRelNode = (Hintable)relNode).getHints().isEmpty()) {
                    this.hintsCollect.add(relNode.getClass().getSimpleName() + ":" + String.valueOf(hintableRelNode.getHints()));
                }
                return super.visit(relNode);
            }

            public String getCollectedHintsAsString() {
                StringBuilder builder = new StringBuilder();
                for (String hintLine : this.hintsCollect) {
                    builder.append(hintLine).append("\n");
                }
                return builder.toString();
            }
        }
    }

    static class NativePlanCommand
    extends AbstractPlanCommand {
        NativePlanCommand(List<String> lines, List<String> content) {
            super(lines, content);
        }

        @Override
        protected void executeExplain(Command.Context context) throws Exception {
            DruidConnectionExtras connectionExtras = DruidConnectionExtras.unwrapOrThrow(context.connection());
            ObjectMapper objectMapper = connectionExtras.getObjectMapper();
            List logged = this.executeExplainCollectHookValues(context, DruidHook.NATIVE_PLAN);
            for (Query<?> query : logged) {
                query = BaseCalciteQueryTest.recursivelyClearContext(query, objectMapper);
                String str = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(query);
                context.echo((List)ImmutableList.of((Object)str));
            }
        }
    }

    static class MSQPlanCommand
    extends AbstractStringCaptureCommand {
        MSQPlanCommand(List<String> lines, List<String> content) {
            super(lines, content, (DruidHook.HookKey<String>)DruidHook.MSQ_PLAN);
        }
    }

    static class DisabledCommand
    extends AbstractCommand {
        private String supplierName;
        private String message;
        private Pattern DISABLED_PATTERN = Pattern.compile("disabled\\s+([\\w\\d]+)(\\s+([^\\s].+))?\\s*");
        private final List<String> content;
        private final List<String> lines;

        DisabledCommand(List<String> lines, List<String> content, String line) {
            this.lines = ImmutableList.copyOf(lines);
            this.content = content;
            Matcher m = this.DISABLED_PATTERN.matcher(line);
            if (!m.matches()) {
                throw new IllegalArgumentException("usage: !disabled <supplier> [<reason>]");
            }
            this.supplierName = m.group(1);
            this.message = DisabledCommand.buildMessage(this.supplierName, m.group(3));
        }

        private static String buildMessage(String supplierName, String message) {
            return StringUtils.format((String)"Test disabled on supplier [%s]. Reason: [%s]", (Object[])new Object[]{supplierName, message});
        }

        public final void execute(Command.Context context, boolean execute) {
            if (execute) {
                try {
                    Injector injector = DruidConnectionExtras.unwrapOrThrow(context.connection()).getInjector();
                    SqlTestFrameworkConfig cfg = (SqlTestFrameworkConfig)injector.getInstance(SqlTestFrameworkConfig.class);
                    Assume.assumeFalse((String)this.message, (boolean)cfg.componentSupplier.getSimpleName().equals(this.supplierName));
                }
                catch (Exception e) {
                    throw new Error(e);
                }
            } else {
                context.echo(this.content);
            }
            context.echo(this.lines);
        }
    }

    static abstract class AbstractStringCaptureCommand
    extends AbstractPlanCommand {
        DruidHook.HookKey<String> hook;

        AbstractStringCaptureCommand(List<String> lines, List<String> content, DruidHook.HookKey<String> hook) {
            super(lines, content);
            this.hook = hook;
        }

        @Override
        protected final void executeExplain(Command.Context context) throws IOException {
            List<String> logged = this.executeExplainCollectHookValues(context, this.hook);
            context.echo(logged);
        }
    }

    static abstract class AbstractRelPlanCommand
    extends AbstractPlanCommand {
        DruidHook.HookKey<RelNode> hook;

        AbstractRelPlanCommand(List<String> lines, List<String> content, DruidHook.HookKey<RelNode> hook) {
            super(lines, content);
            this.hook = hook;
        }

        @Override
        protected final void executeExplain(Command.Context context) throws IOException {
            List<RelNode> logged = this.executeExplainCollectHookValues(context, this.hook);
            for (RelNode node : logged) {
                if (node instanceof DruidRel) {
                    node = ((DruidRel)node).unwrapLogicalPlan();
                }
                String str = this.convertRelToString(node);
                context.echo((List)ImmutableList.of((Object)str));
            }
        }

        protected String convertRelToString(RelNode node) {
            String str = RelOptUtil.dumpPlan((String)"", (RelNode)node, (SqlExplainFormat)SqlExplainFormat.TEXT, (SqlExplainLevel)SqlExplainLevel.EXPPLAN_ATTRIBUTES);
            return str;
        }
    }

    public static abstract class AbstractPlanCommand
    extends AbstractCommand {
        private final List<String> content;
        private final List<String> lines;

        public AbstractPlanCommand(List<String> lines, List<String> content) {
            this.lines = ImmutableList.copyOf(lines);
            this.content = content;
        }

        public final String describe(Command.Context context) {
            return this.commandName() + " [sql: " + context.previousSqlCommand().sql + "]";
        }

        public final void execute(Command.Context context, boolean execute) {
            if (execute) {
                try {
                    this.executeExplain(context);
                }
                catch (Exception e) {
                    throw new Error(e);
                }
            } else {
                context.echo(this.content);
            }
            context.echo(this.lines);
        }

        protected final <T> List<T> executeExplainCollectHookValues(Command.Context context, DruidHook.HookKey<T> hook) throws IOException {
            DruidHookDispatcher dhp = this.unwrapDruidHookDispatcher(context);
            ArrayList logged = new ArrayList();
            try (Closeable unhook = dhp.withHook(hook, (key, value) -> logged.add(value));){
                this.executeExplainQuery(context);
            }
            return logged;
        }

        protected final void executeQuery(Command.Context context) {
            Quidem.SqlCommand sqlCommand = context.previousSqlCommand();
            this.executeQuery(context, sqlCommand.sql);
        }

        protected final void executeExplainQuery(Command.Context context) {
            boolean isExplainSupported = DruidConnectionExtras.unwrapOrThrow(context.connection()).isExplainSupported();
            Quidem.SqlCommand sqlCommand = context.previousSqlCommand();
            if (isExplainSupported) {
                this.executeQuery(context, "explain plan for " + sqlCommand.sql);
            } else {
                this.executeQuery(context, sqlCommand.sql);
            }
        }

        protected final void executeQuery(Command.Context context, String sql) {
            try (Statement statement = context.connection().createStatement();
                 ResultSet resultSet = statement.executeQuery(sql);){
                while (resultSet.next()) {
                    Util.discard((boolean)false);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        protected final DruidHookDispatcher unwrapDruidHookDispatcher(Command.Context context) {
            return DruidConnectionExtras.unwrapOrThrow(context.connection()).getDruidHookDispatcher();
        }

        protected abstract void executeExplain(Command.Context var1) throws Exception;
    }
}

