/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner.convertlet;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.fun.SqlAbstractTimeFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql2rel.SqlRexContext;
import org.apache.calcite.sql2rel.SqlRexConvertlet;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.convertlet.DruidConvertletFactory;

public class CurrentTimestampAndFriendsConvertletFactory
implements DruidConvertletFactory {
    public static final CurrentTimestampAndFriendsConvertletFactory INSTANCE = new CurrentTimestampAndFriendsConvertletFactory();
    private static final SqlFunction CURRENT_TIMESTAMP = new CurrentTimestampSqlFunction("CURRENT_TIMESTAMP", SqlTypeName.TIMESTAMP);
    private static final SqlFunction LOCALTIMESTAMP = new CurrentTimestampSqlFunction("LOCALTIMESTAMP", SqlTypeName.TIMESTAMP);
    private static final List<SqlOperator> SQL_OPERATORS = ImmutableList.builder().add((Object)CURRENT_TIMESTAMP).add((Object)SqlStdOperatorTable.CURRENT_TIME).add((Object)SqlStdOperatorTable.CURRENT_DATE).add((Object)LOCALTIMESTAMP).add((Object)SqlStdOperatorTable.LOCALTIME).build();

    private CurrentTimestampAndFriendsConvertletFactory() {
    }

    @Override
    public SqlRexConvertlet createConvertlet(PlannerContext plannerContext) {
        return new CurrentTimestampAndFriendsConvertlet(plannerContext);
    }

    @Override
    public List<SqlOperator> operators() {
        return SQL_OPERATORS;
    }

    private static class CurrentTimestampSqlFunction
    extends SqlAbstractTimeFunction {
        private final SqlTypeName typeName;

        public CurrentTimestampSqlFunction(String name, SqlTypeName typeName) {
            super(name, typeName);
            this.typeName = typeName;
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            if (opBinding.getOperandCount() == 0) {
                return opBinding.getTypeFactory().createSqlType(this.typeName, 3);
            }
            return super.inferReturnType(opBinding);
        }
    }

    private static class CurrentTimestampAndFriendsConvertlet
    implements SqlRexConvertlet {
        private final PlannerContext plannerContext;

        private CurrentTimestampAndFriendsConvertlet(PlannerContext plannerContext) {
            this.plannerContext = plannerContext;
        }

        public RexNode convertCall(SqlRexContext cx, SqlCall call) {
            SqlOperator operator = call.getOperator();
            if (CURRENT_TIMESTAMP.equals((Object)operator) || LOCALTIMESTAMP.equals((Object)operator)) {
                int precision = 3;
                if (call.operandCount() > 0) {
                    SqlLiteral precisionLiteral = (SqlLiteral)call.operand(0);
                    precision = precisionLiteral.intValue(true);
                }
                return Calcites.jodaToCalciteTimestampLiteral(cx.getRexBuilder(), this.plannerContext.getLocalNow(), this.plannerContext.getTimeZone(), precision);
            }
            if (operator.equals((Object)SqlStdOperatorTable.CURRENT_TIME) || operator.equals((Object)SqlStdOperatorTable.LOCALTIME)) {
                return cx.getRexBuilder().makeTimeLiteral(Calcites.jodaToCalciteTimeString(this.plannerContext.getLocalNow(), this.plannerContext.getTimeZone()), -1);
            }
            if (operator.equals((Object)SqlStdOperatorTable.CURRENT_DATE)) {
                return cx.getRexBuilder().makeDateLiteral(Calcites.jodaToCalciteDateString(this.plannerContext.getLocalNow().hourOfDay().roundFloorCopy(), this.plannerContext.getTimeZone()));
            }
            throw new ISE("Should not have got here, operator was: %s", new Object[]{operator});
        }
    }
}

