/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.external;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandMetadata;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlUserDefinedTableMacro;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorTable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.UnionDataSource;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.Types;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.calcite.expression.AuthorizableOperator;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.planner.DruidSqlValidator;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.table.DatasourceMetadata;
import org.apache.druid.sql.calcite.table.DatasourceTable;

public class TableAppendMacro
extends SqlUserDefinedTableMacro
implements AuthorizableOperator {
    public static final OperatorConversion OPERATOR_CONVERSION = new OperatorConversion();
    public static final SqlOperator APPEND_TABLE_MACRO = new TableAppendMacro();

    private TableAppendMacro() {
        super(new SqlIdentifier("APPEND", SqlParserPos.ZERO), SqlKind.OTHER_FUNCTION, ReturnTypes.CURSOR, null, (SqlOperandMetadata)new OperandMetadata(), null);
    }

    public List<String> getParamNames() {
        return ImmutableList.builder().add((Object[])new String[]{"tableName1", "tableName2"}).build();
    }

    public TranslatableTable getTable(SqlOperatorBinding operatorBinding) {
        SqlCallBinding callBinding = (SqlCallBinding)operatorBinding;
        SqlValidator validator = callBinding.getValidator();
        List<TableOperand> tables = this.getTables(callBinding, validator.getCatalogReader());
        AppendDatasourceMetadata metadata = this.buildUnionDataSource(tables);
        return new DatasourceTable(metadata.values, metadata, DatasourceTable.EffectiveMetadata.of(metadata.values));
    }

    private List<TableOperand> getTables(SqlCallBinding callBinding, SqlValidatorCatalogReader catalogReader) {
        ArrayList<TableOperand> tables = new ArrayList<TableOperand>();
        for (int i = 0; i < callBinding.getOperandCount(); ++i) {
            String tableName = (String)callBinding.getOperandLiteralValue(i, String.class);
            ImmutableList tableNameList = ImmutableList.builder().add((Object)tableName).build();
            SqlValidatorTable table = catalogReader.getTable((List)tableNameList);
            if (table == null) {
                throw DruidSqlValidator.buildCalciteContextException(StringUtils.format((String)"Table [%s] not found", (Object[])new Object[]{tableName}), callBinding.operand(i));
            }
            tables.add(new TableOperand(callBinding.operand(i), table));
        }
        return tables;
    }

    private AppendDatasourceMetadata buildUnionDataSource(List<TableOperand> tables) {
        ArrayList<DataSource> dataSources = new ArrayList<DataSource>();
        LinkedHashMap<String, ColumnType> fields = new LinkedHashMap<String, ColumnType>();
        for (TableOperand table : tables) {
            RowSignature rowSignature = table.getRowSignature();
            for (String columnName : rowSignature.getColumnNames()) {
                ColumnType currentType = (ColumnType)rowSignature.getColumnType(columnName).get();
                ColumnType existingType = (ColumnType)fields.get(columnName);
                if (existingType == null || existingType.equals((Object)currentType)) {
                    fields.put(columnName, currentType);
                    continue;
                }
                try {
                    ColumnType commonType = ColumnType.leastRestrictiveType((ColumnType)currentType, (ColumnType)existingType);
                    fields.put(columnName, commonType);
                }
                catch (Types.IncompatibleTypeException e) {
                    throw DruidSqlValidator.buildCalciteContextException(e, StringUtils.format((String)"Can't create TABLE(APPEND()).\nConflicting types for column [%s]:\n - existing type [%s]\n - new type [%s] from table [%s]", (Object[])new Object[]{columnName, existingType, currentType, table.getRelOptTable().getQualifiedName()}), table.sqlOperand);
                }
            }
            dataSources.add(table.getDataSource());
        }
        return new AppendDatasourceMetadata(this.buildRowSignatureFromMap(fields), dataSources);
    }

    private RowSignature buildRowSignatureFromMap(Map<String, ColumnType> fields) {
        RowSignature.Builder rowSignatureBuilder = RowSignature.builder();
        for (Map.Entry<String, ColumnType> col : fields.entrySet()) {
            rowSignatureBuilder.add(col.getKey(), col.getValue());
        }
        RowSignature rowSignature = rowSignatureBuilder.build();
        return rowSignature;
    }

    @Override
    public Set<ResourceAction> computeResources(SqlCall call, boolean inputSourceTypeSecurityEnabled) {
        HashSet<ResourceAction> ret = new HashSet<ResourceAction>();
        for (SqlNode operand : call.getOperandList()) {
            Resource resource = new Resource(operand.toString(), "DATASOURCE");
            ret.add(new ResourceAction(resource, Action.READ));
        }
        return ret;
    }

    static class AppendDatasourceMetadata
    implements DatasourceMetadata {
        private final RowSignature values;
        private final DataSource dataSource;

        public AppendDatasourceMetadata(RowSignature values, List<DataSource> dataSources) {
            this.values = values;
            this.dataSource = new UnionDataSource(dataSources);
        }

        @Override
        public boolean isJoinable() {
            return false;
        }

        @Override
        public boolean isBroadcast() {
            return false;
        }

        @Override
        public DataSource dataSource() {
            return this.dataSource;
        }
    }

    static class TableOperand {
        private final SqlNode sqlOperand;
        private final SqlValidatorTable table;

        public TableOperand(SqlNode sqlOperand, SqlValidatorTable table) {
            this.sqlOperand = sqlOperand;
            this.table = table;
        }

        public RelOptTable getRelOptTable() {
            return (RelOptTable)this.table.unwrapOrThrow(RelOptTable.class);
        }

        public DatasourceTable getDataSourceTable() {
            return (DatasourceTable)this.table.unwrapOrThrow(DatasourceTable.class);
        }

        public RowSignature getRowSignature() {
            return this.getDataSourceTable().getRowSignature();
        }

        public DataSource getDataSource() {
            return this.getDataSourceTable().getDataSource();
        }
    }

    private static class OperandMetadata
    implements SqlOperandMetadata {
        private OperandMetadata() {
        }

        public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
            for (int i = 0; i < callBinding.getOperandCount(); ++i) {
                SqlNode operand = callBinding.operand(i);
                if (!callBinding.isOperandLiteral(i, false)) {
                    if (throwOnFailure) {
                        throw DruidSqlValidator.buildCalciteContextException("All arguments to APPEND should be literal strings. Argument #" + (i + 1) + " is not literal", operand);
                    }
                    return false;
                }
                SqlTypeName typeName = callBinding.getOperandType(i).getSqlTypeName();
                if (SqlTypeFamily.CHARACTER.getTypeNames().contains(typeName)) continue;
                if (throwOnFailure) {
                    throw DruidSqlValidator.buildCalciteContextException("All arguments to APPEND should be literal strings. Argument #" + (i + 1) + " is not string", operand);
                }
                return false;
            }
            return true;
        }

        public SqlOperandCountRange getOperandCountRange() {
            return SqlOperandCountRanges.from((int)1);
        }

        public String getAllowedSignatures(SqlOperator op, String opName) {
            return "APPEND( <TABLE_NAME>[, <TABLE_NAME> ...] )";
        }

        public List<RelDataType> paramTypes(RelDataTypeFactory typeFactory) {
            RelDataType t = typeFactory.createSqlType(SqlTypeName.VARCHAR);
            return ImmutableList.builder().add((Object[])new RelDataType[]{t, t}).build();
        }

        public List<String> paramNames() {
            return ImmutableList.builder().add((Object[])new String[]{"tableName1", "tableName2"}).build();
        }
    }

    private static class OperatorConversion
    implements SqlOperatorConversion {
        public static final String FUNCTION_NAME = "APPEND";

        @Override
        public SqlOperator calciteOperator() {
            return APPEND_TABLE_MACRO;
        }

        @Override
        public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
            throw new IllegalStateException();
        }
    }
}

