/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Providers;
import java.util.Collections;
import java.util.Set;
import org.apache.druid.guice.DruidGuiceExtensions;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.annotations.JSR311Resource;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.guice.annotations.NativeQuery;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.ResponseContextConfig;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.sql.SqlStatementFactory;
import org.apache.druid.sql.calcite.run.NativeSqlEngine;
import org.apache.druid.sql.http.SqlHttpModule;
import org.apache.druid.sql.http.SqlResource;
import org.apache.druid.sql.http.SqlResourceTest;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.Mock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class SqlHttpModuleTest {
    @Mock
    private ObjectMapper jsonMpper;
    private SqlHttpModule target;
    private Injector injector;

    @Before
    public void setUp() {
        this.target = new SqlHttpModule();
        this.injector = Guice.createInjector((Module[])new Module[]{new LifecycleModule(), new DruidGuiceExtensions(), binder -> {
            binder.bind(ObjectMapper.class).annotatedWith(Json.class).toInstance((Object)this.jsonMpper);
            binder.bind(AuthorizerMapper.class).toInstance((Object)new AuthorizerMapper(Collections.emptyMap()));
            binder.bind(NativeSqlEngine.class).toProvider(Providers.of((Object)new NativeSqlEngine(null, null)));
            binder.bind(DruidNode.class).annotatedWith(Self.class).toInstance((Object)SqlResourceTest.DUMMY_DRUID_NODE);
            binder.bind(ResponseContextConfig.class).toInstance((Object)SqlResourceTest.TEST_RESPONSE_CONTEXT_CONFIG);
            binder.bind(SqlStatementFactory.class).annotatedWith(NativeQuery.class).toInstance((Object)((SqlStatementFactory)EasyMock.mock(SqlStatementFactory.class)));
        }, this.target});
    }

    @Test
    public void testSqlResourceIsInjectedAndSingleton() {
        SqlResource sqlResource = (SqlResource)this.injector.getInstance(SqlResource.class);
        Assert.assertNotNull((Object)sqlResource);
        SqlResource other = (SqlResource)this.injector.getInstance(SqlResource.class);
        Assert.assertSame((Object)other, (Object)sqlResource);
    }

    @Test
    public void testSqlResourceIsAvailableViaJersey() {
        Set jerseyResourceClasses = (Set)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<Class<?>>>(){}, JSR311Resource.class));
        Assert.assertEquals((long)1L, (long)jerseyResourceClasses.size());
        Assert.assertEquals(SqlResource.class, jerseyResourceClasses.iterator().next());
    }
}

