/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.inject.Named;
import org.apache.druid.collections.BlockingPool;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.guice.BuiltInTypesModule;
import org.apache.druid.guice.DruidInjectorBuilder;
import org.apache.druid.guice.ExpressionModule;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.QueryRunnerFactoryModule;
import org.apache.druid.guice.QueryableModule;
import org.apache.druid.guice.SegmentWranglerModule;
import org.apache.druid.guice.ServerModule;
import org.apache.druid.guice.StartupInjectorBuilder;
import org.apache.druid.guice.annotations.Global;
import org.apache.druid.guice.annotations.Merging;
import org.apache.druid.initialization.CoreInjectorBuilder;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.initialization.ServiceInjectorBuilder;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.DefaultGenericQueryMetricsFactory;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.query.GenericQueryMetricsFactory;
import org.apache.druid.query.GlobalTableDataSource;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.QueryWatcher;
import org.apache.druid.query.TestBufferPool;
import org.apache.druid.query.groupby.DefaultGroupByQueryMetricsFactory;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryMetricsFactory;
import org.apache.druid.query.groupby.GroupByResourcesReservationPool;
import org.apache.druid.query.groupby.GroupByStatsProvider;
import org.apache.druid.query.groupby.GroupingEngine;
import org.apache.druid.query.groupby.TestGroupByBuffers;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.druid.query.topn.TopNQueryConfig;
import org.apache.druid.quidem.TestSqlModule;
import org.apache.druid.segment.DefaultColumnFormatConfig;
import org.apache.druid.segment.join.JoinableFactoryWrapper;
import org.apache.druid.server.QueryLifecycle;
import org.apache.druid.server.QueryLifecycleFactory;
import org.apache.druid.server.QueryStackTests;
import org.apache.druid.server.SpecificSegmentsQuerySegmentWalker;
import org.apache.druid.server.log.RequestLogger;
import org.apache.druid.server.log.TestRequestLogger;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthTestUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.sql.SqlStatementFactory;
import org.apache.druid.sql.calcite.SqlTestFrameworkConfig;
import org.apache.druid.sql.calcite.TempDirProducer;
import org.apache.druid.sql.calcite.planner.CalciteRulesManager;
import org.apache.druid.sql.calcite.planner.CatalogResolver;
import org.apache.druid.sql.calcite.planner.DruidOperatorTable;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.planner.PlannerFactory;
import org.apache.druid.sql.calcite.rule.ExtensionCalciteRuleProvider;
import org.apache.druid.sql.calcite.run.NativeSqlEngine;
import org.apache.druid.sql.calcite.run.SqlEngine;
import org.apache.druid.sql.calcite.schema.DruidSchema;
import org.apache.druid.sql.calcite.schema.DruidSchemaCatalog;
import org.apache.druid.sql.calcite.schema.DruidSchemaManager;
import org.apache.druid.sql.calcite.schema.LookupSchema;
import org.apache.druid.sql.calcite.schema.NoopDruidSchemaManager;
import org.apache.druid.sql.calcite.schema.SystemSchema;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.apache.druid.sql.calcite.util.DruidModuleCollection;
import org.apache.druid.sql.calcite.util.LookylooModule;
import org.apache.druid.sql.calcite.util.QueryFrameworkUtils;
import org.apache.druid.sql.calcite.util.TestDataBuilder;
import org.apache.druid.sql.calcite.util.TestDruidViewMacroFactory;
import org.apache.druid.sql.calcite.view.DruidViewMacroFactory;
import org.apache.druid.sql.calcite.view.InProcessViewManager;
import org.apache.druid.sql.calcite.view.ViewManager;
import org.apache.druid.sql.guice.SqlModule;
import org.apache.druid.sql.hook.DruidHookDispatcher;
import org.apache.druid.timeline.DataSegment;

public class SqlTestFramework {
    public static final DruidViewMacroFactory DRUID_VIEW_MACRO_FACTORY = new TestDruidViewMacroFactory();
    private final Builder builder;
    private final QueryComponentSupplier componentSupplier;
    private final Injector injector;
    private final AuthorizerMapper authorizerMapper = CalciteTests.TEST_AUTHORIZER_MAPPER;
    private final SqlEngine engine;

    private SqlTestFramework(Builder builder) {
        this.builder = builder;
        this.componentSupplier = builder.componentSupplier;
        Properties properties = new Properties();
        this.componentSupplier.gatherProperties(properties);
        Injector startupInjector = new StartupInjectorBuilder().withProperties(properties).build();
        CoreInjectorBuilder injectorBuilder = (CoreInjectorBuilder)new CoreInjectorBuilder(startupInjector).ignoreLoadScopes();
        ArrayList<Module> overrideModules = new ArrayList<Module>(builder.overrideModules);
        injectorBuilder.add(new Object[]{this.componentSupplier.getCoreModule()});
        injectorBuilder.addModule(binder -> binder.bind(Builder.class).toInstance((Object)builder));
        overrideModules.add((Module)this.componentSupplier.getOverrideModule());
        builder.componentSupplier.configureGuice((DruidInjectorBuilder)injectorBuilder, overrideModules);
        ServiceInjectorBuilder serviceInjector = new ServiceInjectorBuilder(injectorBuilder);
        serviceInjector.addAll(overrideModules);
        this.injector = serviceInjector.build();
        this.engine = builder.componentSupplier.createEngine(this.queryLifecycleFactory(), this.queryJsonMapper(), this.injector);
        this.componentSupplier.configureJsonMapper(this.queryJsonMapper());
        this.componentSupplier.finalizeTestFramework(this);
    }

    public Injector injector() {
        return this.injector;
    }

    public SqlEngine engine() {
        return this.engine;
    }

    public ObjectMapper queryJsonMapper() {
        return (ObjectMapper)this.injector.getInstance(ObjectMapper.class);
    }

    public QueryLifecycleFactory queryLifecycleFactory() {
        return (QueryLifecycleFactory)this.injector.getInstance(QueryLifecycleFactory.class);
    }

    public QueryLifecycle queryLifecycle() {
        return this.queryLifecycleFactory().factorize();
    }

    public ExprMacroTable macroTable() {
        return (ExprMacroTable)this.injector.getInstance(ExprMacroTable.class);
    }

    public DruidOperatorTable operatorTable() {
        return (DruidOperatorTable)this.injector.getInstance(DruidOperatorTable.class);
    }

    public SpecificSegmentsQuerySegmentWalker walker() {
        return (SpecificSegmentsQuerySegmentWalker)this.injector.getInstance(SpecificSegmentsQuerySegmentWalker.class);
    }

    public QueryRunnerFactoryConglomerate conglomerate() {
        return (QueryRunnerFactoryConglomerate)this.injector.getInstance(QueryRunnerFactoryConglomerate.class);
    }

    public PlannerFixture plannerFixture(PlannerConfig plannerConfig, AuthConfig authConfig) {
        PlannerComponentSupplier plannerComponentSupplier = this.componentSupplier.getPlannerComponentSupplier();
        return new PlannerFixture(this, plannerComponentSupplier, plannerConfig, authConfig);
    }

    public void close() {
        try {
            this.builder.resourceCloser.close();
            this.componentSupplier.close();
        }
        catch (IOException e) {
            throw new RE((Throwable)e);
        }
    }

    public URI getDruidTestURI() {
        return this.builder.config.getDruidTestURI();
    }

    public static class TestSchemaSetupModule
    implements DruidModule {
        @Provides
        @LazySingleton
        private DruidSchema makeDruidSchema(Injector injector, QueryRunnerFactoryConglomerate conglomerate, QuerySegmentWalker walker, Builder builder) {
            return QueryFrameworkUtils.createMockSchema(injector, conglomerate, (SpecificSegmentsQuerySegmentWalker)walker, builder.componentSupplier.getPlannerComponentSupplier().createSchemaManager(), builder.catalogResolver);
        }

        @Provides
        @LazySingleton
        private SystemSchema makeSystemSchema(QuerySegmentWalker walker, AuthorizerMapper authorizerMapper, DruidSchema druidSchema) {
            return CalciteTests.createMockSystemSchema(druidSchema, (SpecificSegmentsQuerySegmentWalker)walker, authorizerMapper);
        }

        @Provides
        @LazySingleton
        private LookupSchema makeLookupSchema(Injector injector) {
            return QueryFrameworkUtils.createMockLookupSchema(injector);
        }

        @Provides
        @LazySingleton
        private DruidSchemaCatalog makeCatalog(PlannerConfig plannerConfig, ViewManager viewManager, AuthorizerMapper authorizerMapper, DruidSchema druidSchema, SystemSchema systemSchema, LookupSchema lookupSchema, DruidOperatorTable createOperatorTable) {
            DruidSchemaCatalog rootSchema = QueryFrameworkUtils.createMockRootSchema(plannerConfig, viewManager, authorizerMapper, druidSchema, systemSchema, lookupSchema, createOperatorTable);
            return rootSchema;
        }

        @Provides
        @LazySingleton
        public SpecificSegmentsQuerySegmentWalker specificSegmentsQuerySegmentWalker(Injector injector, Builder builder) {
            SpecificSegmentsQuerySegmentWalker walker = builder.componentSupplier.createQuerySegmentWalker((QueryRunnerFactoryConglomerate)injector.getInstance(QueryRunnerFactoryConglomerate.class), (JoinableFactoryWrapper)injector.getInstance(JoinableFactoryWrapper.class), injector);
            builder.resourceCloser.register((Closeable)walker);
            return walker;
        }

        public void configure(Binder binder) {
        }
    }

    public static class TestSetupModule
    implements DruidModule {
        @Provides
        TempDirProducer getTempDirProducer(Builder builder) {
            return builder.componentSupplier.getTempDirProducer();
        }

        @Provides
        ServiceEmitter getServiceEmitter() {
            return NoopServiceEmitter.instance();
        }

        @Provides
        @LazySingleton
        public QuerySegmentWalker getQuerySegmentWalker(SpecificSegmentsQuerySegmentWalker walker) {
            return walker;
        }

        @Provides
        GenericQueryMetricsFactory getGenericQueryMetricsFactory() {
            return DefaultGenericQueryMetricsFactory.instance();
        }

        public void configure(Binder binder) {
            binder.bind(DruidOperatorTable.class).in(LazySingleton.class);
            binder.bind(DataSegment.PruneSpecsHolder.class).toInstance((Object)DataSegment.PruneSpecsHolder.DEFAULT);
            binder.bind(DefaultColumnFormatConfig.class).toInstance((Object)new DefaultColumnFormatConfig(null, null));
            binder.bind((TypeLiteral)new TypeLiteral<NonBlockingPool<ByteBuffer>>(){}).annotatedWith(Global.class).to(TestBufferPool.class);
            TestRequestLogger testRequestLogger = new TestRequestLogger();
            binder.bind(RequestLogger.class).toInstance((Object)testRequestLogger);
        }

        @Provides
        AuthorizerMapper getAuthorizerMapper() {
            return AuthTestUtils.TEST_AUTHORIZER_MAPPER;
        }

        @Provides
        @LazySingleton
        public TopNQueryConfig makeTopNQueryConfig(final Builder builder) {
            return new TopNQueryConfig(){

                public int getMinTopNThreshold() {
                    return builder.minTopNThreshold;
                }
            };
        }

        @Provides
        @LazySingleton
        private GroupByResourcesReservationPool makeGroupByResourcesReservationPool(GroupByQueryConfig config, TestGroupByBuffers bufferPools) {
            return new GroupByResourcesReservationPool((BlockingPool)bufferPools.getMergePool(), config);
        }

        @Provides
        @LazySingleton
        private GroupingEngine makeGroupingEngine(ObjectMapper mapper, DruidProcessingConfig processingConfig, GroupByStatsProvider statsProvider, GroupByQueryConfig config, GroupByResourcesReservationPool groupByResourcesReservationPool) {
            Supplier configSupplier = Suppliers.ofInstance((Object)config);
            return new GroupingEngine(processingConfig, configSupplier, groupByResourcesReservationPool, mapper, mapper, QueryRunnerTestHelper.NOOP_QUERYWATCHER, statsProvider);
        }

        @Provides
        @LazySingleton
        GroupByQueryMetricsFactory groupByQueryMetricsFactory() {
            return DefaultGroupByQueryMetricsFactory.instance();
        }

        @Provides
        @LazySingleton
        @Merging
        GroupByResourcesReservationPool makeMergingGroupByResourcesReservationPool(GroupByResourcesReservationPool groupByResourcesReservationPool) {
            return groupByResourcesReservationPool;
        }

        @Provides
        @LazySingleton
        public DruidProcessingConfig makeProcessingConfig(Builder builder) {
            return QueryStackTests.getProcessingConfig((int)builder.mergeBufferCount);
        }

        @Provides
        @LazySingleton
        public TestBufferPool makeTestBufferPool(Builder builder) {
            return QueryStackTests.makeTestBufferPool((Closer)builder.resourceCloser);
        }

        @Provides
        @LazySingleton
        public TestGroupByBuffers makeTestGroupByBuffers(DruidProcessingConfig processingConfig, Builder builder) {
            return QueryStackTests.makeGroupByBuffers((Closer)builder.resourceCloser, (DruidProcessingConfig)processingConfig);
        }

        @Provides
        @LazySingleton
        public JoinableFactoryWrapper joinableFactoryWrapper(Injector injector, Builder builder) {
            return builder.componentSupplier.createJoinableFactoryWrapper((LookupExtractorFactoryContainerProvider)injector.getInstance(LookupExtractorFactoryContainerProvider.class));
        }

        @Provides
        @LazySingleton
        public QueryLifecycleFactory queryLifecycleFactory(Injector injector) {
            return QueryFrameworkUtils.createMockQueryLifecycleFactory((QuerySegmentWalker)injector.getInstance(QuerySegmentWalker.class), (QueryRunnerFactoryConglomerate)injector.getInstance(QueryRunnerFactoryConglomerate.class));
        }

        @Provides
        @LazySingleton
        ViewManager createViewManager(Builder builder) {
            return builder.componentSupplier.getPlannerComponentSupplier().createViewManager();
        }

        @Provides
        SqlTestFrameworkConfig getTestConfig(Builder builder) {
            return builder.config;
        }

        @Provides
        @Named(value="quidem")
        public URI getDruidTestURI(SqlTestFrameworkConfig config) {
            return config.getDruidTestURI();
        }

        @Provides
        @Named(value="isExplainSupported")
        public Boolean isExplainSupported(Builder builder) {
            return builder.componentSupplier.isExplainSupported();
        }

        @Provides
        public QueryWatcher getQueryWatcher() {
            return QueryRunnerTestHelper.NOOP_QUERYWATCHER;
        }
    }

    public static class PlannerFixture {
        private final ViewManager viewManager;
        private final PlannerFactory plannerFactory;
        private final SqlStatementFactory statementFactory;

        public PlannerFixture(SqlTestFramework framework, PlannerComponentSupplier componentSupplier, PlannerConfig plannerConfig, AuthConfig authConfig) {
            this.viewManager = componentSupplier.createViewManager();
            DruidSchemaCatalog rootSchema = QueryFrameworkUtils.createMockRootSchema(framework.injector, framework.conglomerate(), framework.walker(), plannerConfig, this.viewManager, componentSupplier.createSchemaManager(), framework.authorizerMapper, framework.builder.catalogResolver);
            this.plannerFactory = new PlannerFactory(rootSchema, framework.operatorTable(), framework.macroTable(), plannerConfig, framework.authorizerMapper, framework.queryJsonMapper(), "druid", new CalciteRulesManager(componentSupplier.extensionCalciteRules()), (JoinableFactoryWrapper)framework.injector.getInstance(JoinableFactoryWrapper.class), framework.builder.catalogResolver, authConfig != null ? authConfig : new AuthConfig(), new DruidHookDispatcher());
            componentSupplier.finalizePlanner(this);
            this.statementFactory = QueryFrameworkUtils.createSqlStatementFactory(framework.engine, this.plannerFactory, authConfig);
            componentSupplier.populateViews(this.viewManager, this.plannerFactory);
        }

        public ViewManager viewManager() {
            return this.viewManager;
        }

        public PlannerFactory plannerFactory() {
            return this.plannerFactory;
        }

        public SqlStatementFactory statementFactory() {
            return this.statementFactory;
        }
    }

    public static class Builder {
        private final QueryComponentSupplier componentSupplier;
        private int minTopNThreshold = 1000;
        private int mergeBufferCount;
        private CatalogResolver catalogResolver = CatalogResolver.NULL_RESOLVER;
        private List<Module> overrideModules = new ArrayList<Module>();
        private SqlTestFrameworkConfig config;
        private Closer resourceCloser = Closer.create();

        public Builder(QueryComponentSupplier componentSupplier) {
            this.componentSupplier = componentSupplier;
        }

        public Builder minTopNThreshold(int minTopNThreshold) {
            this.minTopNThreshold = minTopNThreshold;
            return this;
        }

        public Builder mergeBufferCount(int mergeBufferCount) {
            this.mergeBufferCount = mergeBufferCount;
            return this;
        }

        public Builder catalogResolver(CatalogResolver catalogResolver) {
            this.catalogResolver = catalogResolver;
            return this;
        }

        public Builder withOverrideModule(Module m) {
            this.overrideModules.add(m);
            return this;
        }

        public SqlTestFramework build() {
            return new SqlTestFramework(this);
        }

        public Builder withConfig(SqlTestFrameworkConfig config) {
            this.config = config;
            return this;
        }
    }

    public static class StandardPlannerComponentSupplier
    implements PlannerComponentSupplier {
        @Override
        public Set<ExtensionCalciteRuleProvider> extensionCalciteRules() {
            return ImmutableSet.of();
        }

        @Override
        public ViewManager createViewManager() {
            return new InProcessViewManager(DRUID_VIEW_MACRO_FACTORY);
        }

        @Override
        public void populateViews(ViewManager viewManager, PlannerFactory plannerFactory) {
            viewManager.createView(plannerFactory, "aview", "SELECT SUBSTRING(dim1, 1, 1) AS dim1_firstchar FROM foo WHERE dim2 = 'a'");
            viewManager.createView(plannerFactory, "bview", "SELECT COUNT(*) FROM druid.foo\nWHERE __time >= CURRENT_TIMESTAMP + INTERVAL '1' DAY AND __time < TIMESTAMP '2002-01-01 00:00:00'");
            viewManager.createView(plannerFactory, "cview", "SELECT SUBSTRING(bar.dim1, 1, 1) AS dim1_firstchar, bar.dim2 as dim2, dnf.l2 as l2\nFROM (SELECT * from foo WHERE dim2 = 'a') as bar INNER JOIN druid.numfoo dnf ON bar.dim2 = dnf.dim2");
            viewManager.createView(plannerFactory, "dview", "SELECT SUBSTRING(dim1, 1, 1) AS numfoo FROM foo WHERE dim2 = 'a'");
            viewManager.createView(plannerFactory, "forbiddenView", "SELECT __time, SUBSTRING(dim1, 1, 1) AS dim1_firstchar, dim2 FROM foo WHERE dim2 = 'a'");
            viewManager.createView(plannerFactory, "restrictedView", "SELECT __time, dim1, dim2, m1 FROM druid.forbiddenDatasource WHERE dim2 = 'a'");
            viewManager.createView(plannerFactory, "invalidView", "SELECT __time, dim1, dim2, m1 FROM druid.invalidDatasource WHERE dim2 = 'a'");
        }

        @Override
        public DruidSchemaManager createSchemaManager() {
            return new NoopDruidSchemaManager();
        }

        @Override
        public void finalizePlanner(PlannerFixture plannerFixture) {
        }
    }

    public static class StandardComponentSupplier
    implements QueryComponentSupplier {
        protected final TempDirProducer tempDirProducer;
        private final PlannerComponentSupplier plannerComponentSupplier;

        public StandardComponentSupplier(TempDirProducer tempDirProducer) {
            this.tempDirProducer = tempDirProducer;
            this.plannerComponentSupplier = this.buildPlannerComponentSupplier();
        }

        protected PlannerComponentSupplier buildPlannerComponentSupplier() {
            return new StandardPlannerComponentSupplier();
        }

        @Override
        public void gatherProperties(Properties properties) {
        }

        @Override
        public DruidModule getCoreModule() {
            return DruidModuleCollection.of(new Module[]{new LookylooModule(), new SegmentWranglerModule(), new ExpressionModule(), new QueryRunnerFactoryModule(), new BuiltInTypesModule(), new TestSqlModule(), new ServerModule(), new LifecycleModule(), new QueryableModule(), new SqlModule()});
        }

        @Override
        public DruidModule getOverrideModule() {
            return DruidModuleCollection.of(new Module[]{new TestSetupModule(), new TestSchemaSetupModule()});
        }

        @Deprecated
        protected void configureGuice(DruidInjectorBuilder builder) {
        }

        @Override
        @Deprecated
        public void configureGuice(DruidInjectorBuilder builder, List<Module> overrideModules) {
            this.configureGuice(builder);
        }

        @Override
        public SpecificSegmentsQuerySegmentWalker createQuerySegmentWalker(QueryRunnerFactoryConglomerate conglomerate, JoinableFactoryWrapper joinableFactory, Injector injector) {
            return TestDataBuilder.createMockWalker(injector, conglomerate, this.tempDirProducer.newTempFolder("segments"), QueryStackTests.DEFAULT_NOOP_SCHEDULER, joinableFactory);
        }

        @Override
        public SqlEngine createEngine(QueryLifecycleFactory qlf, ObjectMapper objectMapper, Injector injector) {
            return new NativeSqlEngine(qlf, objectMapper);
        }

        @Override
        public JoinableFactoryWrapper createJoinableFactoryWrapper(LookupExtractorFactoryContainerProvider lookupProvider) {
            return new JoinableFactoryWrapper(QueryStackTests.makeJoinableFactoryFromDefault((LookupExtractorFactoryContainerProvider)lookupProvider, (Set)ImmutableSet.of((Object)TestDataBuilder.CUSTOM_ROW_TABLE_JOINABLE), (Map)ImmutableMap.of(TestDataBuilder.CUSTOM_ROW_TABLE_JOINABLE.getClass(), GlobalTableDataSource.class)));
        }

        @Override
        public void finalizeTestFramework(SqlTestFramework sqlTestFramework) {
        }

        @Override
        public PlannerComponentSupplier getPlannerComponentSupplier() {
            return this.plannerComponentSupplier;
        }

        @Override
        public void close() throws IOException {
            this.tempDirProducer.close();
        }

        @Override
        public Boolean isExplainSupported() {
            return true;
        }

        @Override
        public QueryRunnerFactoryConglomerate wrapConglomerate(QueryRunnerFactoryConglomerate conglomerate, Closer resourceCloser) {
            return conglomerate;
        }

        @Override
        public final TempDirProducer getTempDirProducer() {
            return this.tempDirProducer;
        }
    }

    public static interface PlannerComponentSupplier {
        public Set<ExtensionCalciteRuleProvider> extensionCalciteRules();

        public ViewManager createViewManager();

        public void populateViews(ViewManager var1, PlannerFactory var2);

        public DruidSchemaManager createSchemaManager();

        public void finalizePlanner(PlannerFixture var1);
    }

    public static abstract class QueryComponentSupplierDelegate
    implements QueryComponentSupplier {
        private final QueryComponentSupplier delegate;

        public QueryComponentSupplierDelegate(QueryComponentSupplier delegate) {
            this.delegate = delegate;
        }

        @Override
        public void gatherProperties(Properties properties) {
            this.delegate.gatherProperties(properties);
        }

        @Override
        public void configureGuice(DruidInjectorBuilder builder, List<Module> overrideModules) {
            this.delegate.configureGuice(builder, overrideModules);
        }

        @Override
        public SpecificSegmentsQuerySegmentWalker createQuerySegmentWalker(QueryRunnerFactoryConglomerate conglomerate, JoinableFactoryWrapper joinableFactory, Injector injector) {
            return this.delegate.createQuerySegmentWalker(conglomerate, joinableFactory, injector);
        }

        @Override
        public SqlEngine createEngine(QueryLifecycleFactory qlf, ObjectMapper objectMapper, Injector injector) {
            return this.delegate.createEngine(qlf, objectMapper, injector);
        }

        @Override
        public void configureJsonMapper(ObjectMapper mapper) {
            this.delegate.configureJsonMapper(mapper);
        }

        @Override
        public JoinableFactoryWrapper createJoinableFactoryWrapper(LookupExtractorFactoryContainerProvider lookupProvider) {
            return this.delegate.createJoinableFactoryWrapper(lookupProvider);
        }

        @Override
        public void finalizeTestFramework(SqlTestFramework sqlTestFramework) {
            this.delegate.finalizeTestFramework(sqlTestFramework);
        }

        @Override
        public PlannerComponentSupplier getPlannerComponentSupplier() {
            return this.delegate.getPlannerComponentSupplier();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Override
        public Boolean isExplainSupported() {
            return this.delegate.isExplainSupported();
        }

        @Override
        public QueryRunnerFactoryConglomerate wrapConglomerate(QueryRunnerFactoryConglomerate conglomerate, Closer resourceCloser) {
            return this.delegate.wrapConglomerate(conglomerate, resourceCloser);
        }

        @Override
        public DruidModule getCoreModule() {
            return this.delegate.getCoreModule();
        }

        @Override
        public DruidModule getOverrideModule() {
            return this.delegate.getOverrideModule();
        }

        @Override
        public TempDirProducer getTempDirProducer() {
            return this.delegate.getTempDirProducer();
        }
    }

    public static interface QueryComponentSupplier
    extends Closeable {
        public void gatherProperties(Properties var1);

        public DruidModule getCoreModule();

        public DruidModule getOverrideModule();

        public SpecificSegmentsQuerySegmentWalker createQuerySegmentWalker(QueryRunnerFactoryConglomerate var1, JoinableFactoryWrapper var2, Injector var3);

        public SqlEngine createEngine(QueryLifecycleFactory var1, ObjectMapper var2, Injector var3);

        default public CatalogResolver createCatalogResolver() {
            return CatalogResolver.NULL_RESOLVER;
        }

        @Deprecated
        default public void configureJsonMapper(ObjectMapper mapper) {
        }

        public JoinableFactoryWrapper createJoinableFactoryWrapper(LookupExtractorFactoryContainerProvider var1);

        public void finalizeTestFramework(SqlTestFramework var1);

        public PlannerComponentSupplier getPlannerComponentSupplier();

        @Override
        default public void close() throws IOException {
        }

        @Deprecated
        public void configureGuice(DruidInjectorBuilder var1, List<Module> var2);

        public Boolean isExplainSupported();

        public QueryRunnerFactoryConglomerate wrapConglomerate(QueryRunnerFactoryConglomerate var1, Closer var2);

        public TempDirProducer getTempDirProducer();
    }
}

