/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import org.apache.druid.client.BrokerSegmentWatcherConfig;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.FilteredServerInventoryView;
import org.apache.druid.client.ServerView;
import org.apache.druid.client.TimelineServerView;
import org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.druid.discovery.DruidLeaderClient;
import org.apache.druid.discovery.DruidNodeDiscovery;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.indexer.RunnerTaskState;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.java.util.common.CloseableIterators;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.policy.NoRestrictionPolicy;
import org.apache.druid.query.policy.Policy;
import org.apache.druid.query.policy.RowFilterPolicy;
import org.apache.druid.rpc.indexing.NoopOverlordClient;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.join.JoinableFactoryWrapper;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.QueryLifecycleFactory;
import org.apache.druid.server.QueryScheduler;
import org.apache.druid.server.QueryStackTests;
import org.apache.druid.server.SpecificSegmentsQuerySegmentWalker;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AllowAllAuthenticator;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.AuthenticatorMapper;
import org.apache.druid.server.security.Authorizer;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.Escalator;
import org.apache.druid.server.security.NoopEscalator;
import org.apache.druid.sql.SqlStatementFactory;
import org.apache.druid.sql.calcite.BaseCalciteQueryTest;
import org.apache.druid.sql.calcite.aggregation.SqlAggregationModule;
import org.apache.druid.sql.calcite.planner.DruidOperatorTable;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.planner.PlannerFactory;
import org.apache.druid.sql.calcite.run.NativeSqlEngine;
import org.apache.druid.sql.calcite.run.SqlEngine;
import org.apache.druid.sql.calcite.schema.BrokerSegmentMetadataCacheConfig;
import org.apache.druid.sql.calcite.schema.DruidSchema;
import org.apache.druid.sql.calcite.schema.DruidSchemaCatalog;
import org.apache.druid.sql.calcite.schema.MetadataSegmentView;
import org.apache.druid.sql.calcite.schema.SystemSchema;
import org.apache.druid.sql.calcite.util.LookylooModule;
import org.apache.druid.sql.calcite.util.QueryFrameworkUtils;
import org.apache.druid.sql.calcite.util.TestDataBuilder;
import org.apache.druid.sql.calcite.util.TestTimelineServerView;
import org.apache.druid.sql.calcite.util.testoperator.CalciteTestOperatorModule;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Duration;

public class CalciteTests {
    public static final String DATASOURCE1 = "foo";
    public static final String DATASOURCE2 = "foo2";
    public static final String DATASOURCE3 = "numfoo";
    public static final String DATASOURCE4 = "foo4";
    public static final String DATASOURCE5 = "lotsocolumns";
    public static final String ARRAYS_DATASOURCE = "arrays";
    public static final String BROADCAST_DATASOURCE = "broadcast";
    public static final String FORBIDDEN_DATASOURCE = "forbiddenDatasource";
    public static final String RESTRICTED_DATASOURCE = "restrictedDatasource_m1_is_6";
    public static final String FORBIDDEN_DESTINATION = "forbiddenDestination";
    public static final String SOME_DATASOURCE = "some_datasource";
    public static final String SOME_DATSOURCE_ESCAPED = "some\\_datasource";
    public static final String SOMEXDATASOURCE = "somexdatasource";
    public static final String USERVISITDATASOURCE = "visits";
    public static final String DRUID_SCHEMA_NAME = "druid";
    public static final String WIKIPEDIA = "wikipedia";
    public static final String WIKIPEDIA_FIRST_LAST = "wikipedia_first_last";
    public static final String TBL_WITH_NULLS_PARQUET = "tblWnulls.parquet";
    public static final String SML_TBL_PARQUET = "smlTbl.parquet";
    public static final String ALL_TYPES_UNIQ_PARQUET = "allTypsUniq.parquet";
    public static final String FEW_ROWS_ALL_DATA_PARQUET = "fewRowsAllData.parquet";
    public static final String T_ALL_TYPE_PARQUET = "t_alltype.parquet";
    public static final String BENCHMARK_DATASOURCE = "benchmark_ds";
    public static final String TEST_SUPERUSER_NAME = "testSuperuser";
    public static final Policy POLICY_NO_RESTRICTION_SUPERUSER = NoRestrictionPolicy.instance();
    public static final Policy POLICY_RESTRICTION = RowFilterPolicy.from((DimFilter)BaseCalciteQueryTest.equality("m1", 6, ColumnType.LONG));
    public static final AuthorizerMapper TEST_AUTHORIZER_MAPPER = new AuthorizerMapper(null){

        public Authorizer getAuthorizer(String name) {
            return (authenticationResult, resource, action) -> {
                boolean isRestrictedTable = resource.getName().equals(CalciteTests.RESTRICTED_DATASOURCE);
                if (CalciteTests.TEST_SUPERUSER_NAME.equals(authenticationResult.getIdentity())) {
                    return isRestrictedTable ? Access.allowWithRestriction((Policy)POLICY_NO_RESTRICTION_SUPERUSER) : Access.OK;
                }
                switch (resource.getType()) {
                    case "DATASOURCE": {
                        switch (resource.getName()) {
                            case "forbiddenDatasource": {
                                return Access.DENIED;
                            }
                        }
                        return isRestrictedTable ? Access.allowWithRestriction((Policy)POLICY_RESTRICTION) : Access.OK;
                    }
                    case "VIEW": {
                        if ("forbiddenView".equals(resource.getName())) {
                            return Access.DENIED;
                        }
                        return Access.OK;
                    }
                    case "QUERY_CONTEXT": {
                        return Access.OK;
                    }
                    case "EXTERNAL": {
                        if (Action.WRITE.equals((Object)action)) {
                            if (CalciteTests.FORBIDDEN_DESTINATION.equals(resource.getName())) {
                                return Access.DENIED;
                            }
                            return Access.OK;
                        }
                        return Access.DENIED;
                    }
                }
                return Access.DENIED;
            };
        }
    };
    public static final AuthorizerMapper TEST_EXTERNAL_AUTHORIZER_MAPPER = new AuthorizerMapper(null){

        public Authorizer getAuthorizer(String name) {
            return (authenticationResult, resource, action) -> {
                boolean isRestrictedTable = resource.getName().equals(CalciteTests.RESTRICTED_DATASOURCE);
                if (CalciteTests.TEST_SUPERUSER_NAME.equals(authenticationResult.getIdentity())) {
                    return isRestrictedTable ? Access.allowWithRestriction((Policy)POLICY_NO_RESTRICTION_SUPERUSER) : Access.OK;
                }
                switch (resource.getType()) {
                    case "DATASOURCE": {
                        if (CalciteTests.FORBIDDEN_DATASOURCE.equals(resource.getName())) {
                            return Access.DENIED;
                        }
                        return isRestrictedTable ? Access.allowWithRestriction((Policy)POLICY_RESTRICTION) : Access.OK;
                    }
                    case "VIEW": {
                        if ("forbiddenView".equals(resource.getName())) {
                            return Access.DENIED;
                        }
                        return Access.OK;
                    }
                    case "QUERY_CONTEXT": 
                    case "EXTERNAL": {
                        return Access.OK;
                    }
                }
                return Access.DENIED;
            };
        }
    };
    public static final AuthenticatorMapper TEST_AUTHENTICATOR_MAPPER;
    public static final Escalator TEST_AUTHENTICATOR_ESCALATOR;
    public static final AuthenticationResult REGULAR_USER_AUTH_RESULT;
    public static final AuthenticationResult SUPER_USER_AUTH_RESULT;
    public static final Injector INJECTOR;

    private CalciteTests() {
    }

    public static NativeSqlEngine createMockSqlEngine(QuerySegmentWalker walker, QueryRunnerFactoryConglomerate conglomerate) {
        return new NativeSqlEngine(CalciteTests.createMockQueryLifecycleFactory(walker, conglomerate), CalciteTests.getJsonMapper());
    }

    public static QueryLifecycleFactory createMockQueryLifecycleFactory(QuerySegmentWalker walker, QueryRunnerFactoryConglomerate conglomerate) {
        return QueryFrameworkUtils.createMockQueryLifecycleFactory(walker, conglomerate);
    }

    public static SqlStatementFactory createSqlStatementFactory(SqlEngine engine, PlannerFactory plannerFactory) {
        return CalciteTests.createSqlStatementFactory(engine, plannerFactory, new AuthConfig());
    }

    public static SqlStatementFactory createSqlStatementFactory(SqlEngine engine, PlannerFactory plannerFactory, AuthConfig authConfig) {
        return QueryFrameworkUtils.createSqlStatementFactory(engine, plannerFactory, authConfig);
    }

    public static ObjectMapper getJsonMapper() {
        return (ObjectMapper)INJECTOR.getInstance(Key.get(ObjectMapper.class, Json.class));
    }

    public static SpecificSegmentsQuerySegmentWalker createMockWalker(QueryRunnerFactoryConglomerate conglomerate, File tmpDir) {
        return TestDataBuilder.createMockWalker(INJECTOR, conglomerate, tmpDir);
    }

    public static SpecificSegmentsQuerySegmentWalker createMockWalker(QueryRunnerFactoryConglomerate conglomerate, File tmpDir, QueryScheduler scheduler) {
        return TestDataBuilder.createMockWalker(INJECTOR, conglomerate, tmpDir, scheduler);
    }

    public static SpecificSegmentsQuerySegmentWalker createMockWalker(QueryRunnerFactoryConglomerate conglomerate, File tmpDir, QueryScheduler scheduler, JoinableFactory joinableFactory) {
        return TestDataBuilder.createMockWalker(INJECTOR, conglomerate, tmpDir, scheduler, joinableFactory);
    }

    public static SpecificSegmentsQuerySegmentWalker createMockWalker(QueryRunnerFactoryConglomerate conglomerate, File tmpDir, QueryScheduler scheduler, JoinableFactoryWrapper joinableFactoryWrapper) {
        return TestDataBuilder.createMockWalker(INJECTOR, conglomerate, tmpDir, scheduler, joinableFactoryWrapper);
    }

    public static ExprMacroTable createExprMacroTable() {
        return (ExprMacroTable)INJECTOR.getInstance(ExprMacroTable.class);
    }

    public static JoinableFactoryWrapper createJoinableFactoryWrapper() {
        return new JoinableFactoryWrapper(QueryFrameworkUtils.createDefaultJoinableFactory(INJECTOR));
    }

    public static DruidOperatorTable createOperatorTable() {
        return QueryFrameworkUtils.createOperatorTable(INJECTOR);
    }

    public static DruidNode mockCoordinatorNode() {
        return new DruidNode("test-coordinator", "dummy", false, Integer.valueOf(8081), null, true, false);
    }

    public static FakeDruidNodeDiscoveryProvider mockDruidNodeDiscoveryProvider(DruidNode coordinatorNode) {
        FakeDruidNodeDiscoveryProvider provider = new FakeDruidNodeDiscoveryProvider((Map<NodeRole, FakeDruidNodeDiscovery>)ImmutableMap.of((Object)NodeRole.COORDINATOR, (Object)new FakeDruidNodeDiscovery((Map<NodeRole, DruidNode>)ImmutableMap.of((Object)NodeRole.COORDINATOR, (Object)coordinatorNode))));
        return provider;
    }

    public static SystemSchema createMockSystemSchema(DruidSchema druidSchema, SpecificSegmentsQuerySegmentWalker walker, AuthorizerMapper authorizerMapper) {
        final DruidNode coordinatorNode = CalciteTests.mockCoordinatorNode();
        FakeDruidNodeDiscoveryProvider provider = CalciteTests.mockDruidNodeDiscoveryProvider(coordinatorNode);
        final DruidNode overlordNode = new DruidNode("test-overlord", "dummy", false, Integer.valueOf(8090), null, true, false);
        DruidLeaderClient druidLeaderClient = new DruidLeaderClient(new FakeHttpClient(), provider, NodeRole.COORDINATOR, "/simple/leader"){

            public String findCurrentLeader() {
                return coordinatorNode.getHostAndPortToUse();
            }
        };
        NoopOverlordClient overlordClient = new NoopOverlordClient(){

            public ListenableFuture<URI> findCurrentLeader() {
                try {
                    return Futures.immediateFuture((Object)new URI(overlordNode.getHostAndPortToUse()));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }

            public ListenableFuture<CloseableIterator<TaskStatusPlus>> taskStatuses(@Nullable String state, @Nullable String dataSource, @Nullable Integer maxCompletedTasks) {
                ArrayList<TaskStatusPlus> tasks = new ArrayList<TaskStatusPlus>();
                tasks.add(this.createTaskStatus("id1", CalciteTests.DATASOURCE1, 10L));
                tasks.add(this.createTaskStatus("id1", CalciteTests.DATASOURCE1, 1L));
                tasks.add(this.createTaskStatus("id2", CalciteTests.DATASOURCE2, 20L));
                tasks.add(this.createTaskStatus("id2", CalciteTests.DATASOURCE2, 2L));
                return Futures.immediateFuture((Object)CloseableIterators.withEmptyBaggage(tasks.iterator()));
            }

            private TaskStatusPlus createTaskStatus(String id, String datasource, Long duration) {
                return new TaskStatusPlus(id, "testGroupId", "testType", DateTimes.nowUtc(), DateTimes.nowUtc(), TaskState.RUNNING, RunnerTaskState.RUNNING, duration, TaskLocation.create((String)"testHost", (int)1010, (int)-1), datasource, null);
            }
        };
        return new SystemSchema(druidSchema, new MetadataSegmentView(druidLeaderClient, CalciteTests.getJsonMapper(), new BrokerSegmentWatcherConfig(), BrokerSegmentMetadataCacheConfig.create()), (TimelineServerView)new TestTimelineServerView(walker.getSegments()), (FilteredServerInventoryView)new FakeServerInventoryView(), authorizerMapper, druidLeaderClient, (OverlordClient)overlordClient, (DruidNodeDiscoveryProvider)provider, CalciteTests.getJsonMapper());
    }

    public static DruidSchemaCatalog createMockRootSchema(QueryRunnerFactoryConglomerate conglomerate, SpecificSegmentsQuerySegmentWalker walker, PlannerConfig plannerConfig, AuthorizerMapper authorizerMapper) {
        return QueryFrameworkUtils.createMockRootSchema(INJECTOR, conglomerate, walker, plannerConfig, authorizerMapper);
    }

    static {
        HashMap<String, 3> defaultMap = new HashMap<String, 3>();
        defaultMap.put("allowAll", new AllowAllAuthenticator(){

            public AuthenticationResult authenticateJDBCContext(Map<String, Object> context) {
                return new AuthenticationResult((String)context.get("user"), "allowAll", null, null);
            }
        });
        TEST_AUTHENTICATOR_MAPPER = new AuthenticatorMapper(defaultMap);
        TEST_AUTHENTICATOR_ESCALATOR = new NoopEscalator(){

            public AuthenticationResult createEscalatedAuthenticationResult() {
                return SUPER_USER_AUTH_RESULT;
            }
        };
        REGULAR_USER_AUTH_RESULT = new AuthenticationResult("allowAll", "allowAll", null, null);
        SUPER_USER_AUTH_RESULT = new AuthenticationResult(TEST_SUPERUSER_NAME, "allowAll", null, null);
        INJECTOR = QueryStackTests.defaultInjectorBuilder().addModule((Module)new LookylooModule()).addModule((Module)new SqlAggregationModule()).addModule((Module)new CalciteTestOperatorModule()).build();
    }

    private static class FakeServerInventoryView
    implements FilteredServerInventoryView {
        private FakeServerInventoryView() {
        }

        @Nullable
        public DruidServer getInventoryValue(String serverKey) {
            throw new UnsupportedOperationException();
        }

        public Collection<DruidServer> getInventory() {
            throw new UnsupportedOperationException();
        }

        public boolean isStarted() {
            throw new UnsupportedOperationException();
        }

        public boolean isSegmentLoadedByServer(String serverKey, DataSegment segment) {
            throw new UnsupportedOperationException();
        }

        public void registerSegmentCallback(Executor exec, ServerView.SegmentCallback callback, Predicate<Pair<DruidServerMetadata, DataSegment>> filter) {
            throw new UnsupportedOperationException();
        }

        public void registerServerRemovedCallback(Executor exec, ServerView.ServerRemovedCallback callback) {
            throw new UnsupportedOperationException();
        }
    }

    private static class FakeDruidNodeDiscovery
    implements DruidNodeDiscovery {
        private final Set<DiscoveryDruidNode> nodes;

        FakeDruidNodeDiscovery() {
            this.nodes = new HashSet<DiscoveryDruidNode>();
        }

        FakeDruidNodeDiscovery(Map<NodeRole, DruidNode> nodes) {
            this.nodes = Sets.newHashSetWithExpectedSize((int)nodes.size());
            nodes.forEach((k, v) -> this.addNode((DruidNode)v, (NodeRole)k));
        }

        public Collection<DiscoveryDruidNode> getAllNodes() {
            return this.nodes;
        }

        void addNode(DruidNode node, NodeRole role) {
            DiscoveryDruidNode discoveryNode = new DiscoveryDruidNode(node, role, (Map)ImmutableMap.of());
            this.nodes.add(discoveryNode);
        }

        public void registerListener(DruidNodeDiscovery.Listener listener) {
        }
    }

    private static class FakeDruidNodeDiscoveryProvider
    extends DruidNodeDiscoveryProvider {
        private final Map<NodeRole, FakeDruidNodeDiscovery> nodeDiscoveries;

        public FakeDruidNodeDiscoveryProvider(Map<NodeRole, FakeDruidNodeDiscovery> nodeDiscoveries) {
            this.nodeDiscoveries = nodeDiscoveries;
        }

        public BooleanSupplier getForNode(DruidNode node, NodeRole nodeRole) {
            boolean get = this.nodeDiscoveries.getOrDefault(nodeRole, new FakeDruidNodeDiscovery()).getAllNodes().stream().anyMatch(x -> x.getDruidNode().equals((Object)node));
            return () -> get;
        }

        public DruidNodeDiscovery getForNodeRole(NodeRole nodeRole) {
            return this.nodeDiscoveries.getOrDefault(nodeRole, new FakeDruidNodeDiscovery());
        }
    }

    private static class FakeHttpClient
    implements HttpClient {
        private FakeHttpClient() {
        }

        public <Intermediate, Final> ListenableFuture<Final> go(Request request, HttpResponseHandler<Intermediate, Final> handler) {
            throw new UnsupportedOperationException();
        }

        public <Intermediate, Final> ListenableFuture<Final> go(Request request, HttpResponseHandler<Intermediate, Final> handler, Duration readTimeout) {
            throw new UnsupportedOperationException();
        }
    }
}

