/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.schema;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junitparams.converters.Nullable;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.FilteredServerInventoryView;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.client.InternalQueryConfig;
import org.apache.druid.client.TimelineServerView;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.client.coordinator.NoopCoordinatorClient;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.discovery.DataNodeService;
import org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.druid.discovery.DruidLeaderClient;
import org.apache.druid.discovery.DruidNodeDiscovery;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexing.overlord.supervisor.SupervisorStatus;
import org.apache.druid.java.util.common.CloseableIterators;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.InputStreamFullResponseHolder;
import org.apache.druid.java.util.http.client.response.StringFullResponseHolder;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.join.MapJoinableFactory;
import org.apache.druid.segment.loading.SegmentCacheManager;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.QueryStackTests;
import org.apache.druid.server.SegmentManager;
import org.apache.druid.server.SpecificSegmentsQuerySegmentWalker;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordinator.BytesAccumulatingResponseHandler;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.Authorizer;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.Escalator;
import org.apache.druid.server.security.NoopEscalator;
import org.apache.druid.sql.calcite.planner.CatalogResolver;
import org.apache.druid.sql.calcite.schema.BrokerSegmentMetadataCache;
import org.apache.druid.sql.calcite.schema.BrokerSegmentMetadataCacheConfig;
import org.apache.druid.sql.calcite.schema.DruidSchema;
import org.apache.druid.sql.calcite.schema.MetadataSegmentView;
import org.apache.druid.sql.calcite.schema.PhysicalDatasourceMetadataFactory;
import org.apache.druid.sql.calcite.schema.SystemSchema;
import org.apache.druid.sql.calcite.table.RowSignatures;
import org.apache.druid.sql.calcite.util.CalciteTestBase;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.apache.druid.sql.calcite.util.TestDataBuilder;
import org.apache.druid.sql.calcite.util.TestTimelineServerView;
import org.apache.druid.timeline.CompactionState;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.SegmentStatusInCluster;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.easymock.EasyMock;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class SystemSchemaTest
extends CalciteTestBase {
    private static final BrokerSegmentMetadataCacheConfig SEGMENT_CACHE_CONFIG_DEFAULT = BrokerSegmentMetadataCacheConfig.create();
    private static final List<InputRow> ROWS1 = ImmutableList.of((Object)TestDataBuilder.createRow(ImmutableMap.of((Object)"t", (Object)"2000-01-01", (Object)"m1", (Object)"1.0", (Object)"dim1", (Object)"")), (Object)TestDataBuilder.createRow(ImmutableMap.of((Object)"t", (Object)"2000-01-02", (Object)"m1", (Object)"2.0", (Object)"dim1", (Object)"10.1")), (Object)TestDataBuilder.createRow(ImmutableMap.of((Object)"t", (Object)"2000-01-03", (Object)"m1", (Object)"3.0", (Object)"dim1", (Object)"2")));
    private static final List<InputRow> ROWS2 = ImmutableList.of((Object)TestDataBuilder.createRow(ImmutableMap.of((Object)"t", (Object)"2001-01-01", (Object)"m1", (Object)"4.0", (Object)"dim2", (Object)ImmutableList.of((Object)"a"))), (Object)TestDataBuilder.createRow(ImmutableMap.of((Object)"t", (Object)"2001-01-02", (Object)"m1", (Object)"5.0", (Object)"dim2", (Object)ImmutableList.of((Object)"abc"))), (Object)TestDataBuilder.createRow(ImmutableMap.of((Object)"t", (Object)"2001-01-03", (Object)"m1", (Object)"6.0")));
    private static final List<InputRow> ROWS3 = ImmutableList.of((Object)TestDataBuilder.createRow(ImmutableMap.of((Object)"t", (Object)"2001-01-01", (Object)"m1", (Object)"7.0", (Object)"dim3", (Object)ImmutableList.of((Object)"x"))), (Object)TestDataBuilder.createRow(ImmutableMap.of((Object)"t", (Object)"2001-01-02", (Object)"m1", (Object)"8.0", (Object)"dim3", (Object)ImmutableList.of((Object)"xyz"))));
    private SystemSchema schema;
    private SpecificSegmentsQuerySegmentWalker walker;
    private DruidLeaderClient client;
    private DruidLeaderClient coordinatorClient;
    private OverlordClient overlordClient;
    private TimelineServerView serverView;
    private ObjectMapper mapper;
    private StringFullResponseHolder responseHolder;
    private BytesAccumulatingResponseHandler responseHandler;
    private Request request;
    private DruidSchema druidSchema;
    private AuthorizerMapper authMapper;
    private static QueryRunnerFactoryConglomerate conglomerate;
    private static Closer resourceCloser;
    private MetadataSegmentView metadataView;
    private DruidNodeDiscoveryProvider druidNodeDiscoveryProvider;
    private FilteredServerInventoryView serverInventoryView;
    private final CompactionState expectedCompactionState = new CompactionState((PartitionsSpec)new DynamicPartitionsSpec(null, null), null, null, null, Collections.singletonMap("test", "map"), Collections.singletonMap("test2", "map2"));
    private final DataSegment publishedCompactedSegment1 = new DataSegment("wikipedia1", Intervals.of((String)"2007/2008"), "version1", null, (List)ImmutableList.of((Object)"dim1", (Object)"dim2"), (List)ImmutableList.of((Object)"met1", (Object)"met2"), null, this.expectedCompactionState, Integer.valueOf(1), 53000L);
    private final DataSegment publishedCompactedSegment2 = new DataSegment("wikipedia2", Intervals.of((String)"2008/2009"), "version2", null, (List)ImmutableList.of((Object)"dim1", (Object)"dim2"), (List)ImmutableList.of((Object)"met1", (Object)"met2"), null, this.expectedCompactionState, Integer.valueOf(1), 83000L);
    private final DataSegment publishedUncompactedSegment3 = new DataSegment("wikipedia3", Intervals.of((String)"2009/2010"), "version3", null, (List)ImmutableList.of((Object)"dim1", (Object)"dim2"), (List)ImmutableList.of((Object)"met1", (Object)"met2"), null, null, Integer.valueOf(1), 47000L);
    private final DataSegment segment1 = new DataSegment("test1", Intervals.of((String)"2010/2011"), "version1", null, (List)ImmutableList.of((Object)"dim1", (Object)"dim2"), (List)ImmutableList.of((Object)"met1", (Object)"met2"), null, Integer.valueOf(1), 100L);
    private final DataSegment segment2 = new DataSegment("test2", Intervals.of((String)"2011/2012"), "version2", null, (List)ImmutableList.of((Object)"dim1", (Object)"dim2"), (List)ImmutableList.of((Object)"met1", (Object)"met2"), null, Integer.valueOf(1), 100L);
    private final DataSegment segment3 = new DataSegment("test3", Intervals.of((String)"2012/2013"), "version3", null, (List)ImmutableList.of((Object)"dim1", (Object)"dim2"), (List)ImmutableList.of((Object)"met1", (Object)"met2"), (ShardSpec)new NumberedShardSpec(2, 3), Integer.valueOf(1), 100L);
    private final DataSegment segment4 = new DataSegment("test4", Intervals.of((String)"2014/2015"), "version4", null, (List)ImmutableList.of((Object)"dim1", (Object)"dim2"), (List)ImmutableList.of((Object)"met1", (Object)"met2"), null, Integer.valueOf(1), 100L);
    private final DataSegment segment5 = new DataSegment("test5", Intervals.of((String)"2015/2016"), "version5", null, (List)ImmutableList.of((Object)"dim1", (Object)"dim2"), (List)ImmutableList.of((Object)"met1", (Object)"met2"), null, Integer.valueOf(1), 100L);
    final List<DataSegment> realtimeSegments = ImmutableList.of((Object)this.segment2, (Object)this.segment4, (Object)this.segment5);
    private final DateTime startTime = DateTimes.nowUtc();
    private final DiscoveryDruidNode coordinator = new DiscoveryDruidNode(new DruidNode("s1", "localhost", false, Integer.valueOf(8081), null, true, false), NodeRole.COORDINATOR, (Map)ImmutableMap.of(), this.startTime);
    private final DiscoveryDruidNode coordinator2 = new DiscoveryDruidNode(new DruidNode("s1", "localhost", false, Integer.valueOf(8181), null, true, false), NodeRole.COORDINATOR, (Map)ImmutableMap.of(), this.startTime);
    private final DiscoveryDruidNode overlord = new DiscoveryDruidNode(new DruidNode("s2", "localhost", false, Integer.valueOf(8090), null, true, false), NodeRole.OVERLORD, (Map)ImmutableMap.of(), this.startTime);
    private final DiscoveryDruidNode overlord2 = new DiscoveryDruidNode(new DruidNode("s2", "localhost", false, Integer.valueOf(8190), null, true, false), NodeRole.OVERLORD, (Map)ImmutableMap.of(), this.startTime);
    private final DiscoveryDruidNode broker1 = new DiscoveryDruidNode(new DruidNode("s3", "localhost", false, Integer.valueOf(8082), null, true, false), NodeRole.BROKER, (Map)ImmutableMap.of(), this.startTime);
    private final DiscoveryDruidNode broker2 = new DiscoveryDruidNode(new DruidNode("s3", "brokerHost", false, Integer.valueOf(8082), null, true, false), NodeRole.BROKER, (Map)ImmutableMap.of(), this.startTime);
    private final DiscoveryDruidNode brokerWithBroadcastSegments = new DiscoveryDruidNode(new DruidNode("s3", "brokerHostWithBroadcastSegments", false, Integer.valueOf(8082), Integer.valueOf(8282), true, true), NodeRole.BROKER, (Map)ImmutableMap.of((Object)"dataNodeService", (Object)new DataNodeService("tier", 1000L, ServerType.BROKER, 0)), this.startTime);
    private final DiscoveryDruidNode router = new DiscoveryDruidNode(new DruidNode("s4", "localhost", false, Integer.valueOf(8888), null, true, false), NodeRole.ROUTER, (Map)ImmutableMap.of(), this.startTime);
    private final DiscoveryDruidNode historical1 = new DiscoveryDruidNode(new DruidNode("s5", "localhost", false, Integer.valueOf(8083), null, true, false), NodeRole.HISTORICAL, (Map)ImmutableMap.of((Object)"dataNodeService", (Object)new DataNodeService("tier", 1000L, ServerType.HISTORICAL, 0)), this.startTime);
    private final DiscoveryDruidNode historical2 = new DiscoveryDruidNode(new DruidNode("s5", "histHost", false, Integer.valueOf(8083), null, true, false), NodeRole.HISTORICAL, (Map)ImmutableMap.of((Object)"dataNodeService", (Object)new DataNodeService("tier", 1000L, ServerType.HISTORICAL, 0)), this.startTime);
    private final DiscoveryDruidNode lameHistorical = new DiscoveryDruidNode(new DruidNode("s5", "lameHost", false, Integer.valueOf(8083), null, true, false), NodeRole.HISTORICAL, (Map)ImmutableMap.of((Object)"dataNodeService", (Object)new DataNodeService("tier", 1000L, ServerType.HISTORICAL, 0)), this.startTime);
    private final DiscoveryDruidNode middleManager = new DiscoveryDruidNode(new DruidNode("s6", "mmHost", false, Integer.valueOf(8091), null, true, false), NodeRole.MIDDLE_MANAGER, (Map)ImmutableMap.of(), this.startTime);
    private final DiscoveryDruidNode peon1 = new DiscoveryDruidNode(new DruidNode("s7", "localhost", false, Integer.valueOf(8080), null, true, false), NodeRole.PEON, (Map)ImmutableMap.of((Object)"dataNodeService", (Object)new DataNodeService("tier", 1000L, ServerType.INDEXER_EXECUTOR, 0)), this.startTime);
    private final DiscoveryDruidNode peon2 = new DiscoveryDruidNode(new DruidNode("s7", "peonHost", false, Integer.valueOf(8080), null, true, false), NodeRole.PEON, (Map)ImmutableMap.of((Object)"dataNodeService", (Object)new DataNodeService("tier", 1000L, ServerType.INDEXER_EXECUTOR, 0)), this.startTime);
    private final DiscoveryDruidNode indexer = new DiscoveryDruidNode(new DruidNode("s8", "indexerHost", false, Integer.valueOf(8091), null, true, false), NodeRole.INDEXER, (Map)ImmutableMap.of((Object)"dataNodeService", (Object)new DataNodeService("tier", 1000L, ServerType.INDEXER_EXECUTOR, 0)), this.startTime);
    private final ImmutableDruidServer druidServer1 = new ImmutableDruidServer(new DruidServerMetadata("server1", "localhost:0000", null, 5L, ServerType.REALTIME, "_default_tier", 0), 1L, ImmutableMap.of((Object)"dummy", (Object)new ImmutableDruidDataSource("dummy", Collections.emptyMap(), Arrays.asList(this.segment1, this.segment2))), 2);
    private final ImmutableDruidServer druidServer2 = new ImmutableDruidServer(new DruidServerMetadata("server2", "server2:1234", null, 5L, ServerType.HISTORICAL, "_default_tier", 0), 1L, ImmutableMap.of((Object)"dummy", (Object)new ImmutableDruidDataSource("dummy", Collections.emptyMap(), Arrays.asList(this.segment3, this.segment4, this.segment5))), 3);
    private final List<ImmutableDruidServer> immutableDruidServers = ImmutableList.of((Object)this.druidServer1, (Object)this.druidServer2);

    @BeforeAll
    public static void setUpClass() {
        resourceCloser = Closer.create();
        conglomerate = QueryStackTests.createQueryRunnerFactoryConglomerate((Closer)resourceCloser);
    }

    @AfterAll
    public static void tearDownClass() throws IOException {
        resourceCloser.close();
    }

    @BeforeEach
    public void setUp(@TempDir File tmpDir) throws Exception {
        this.serverView = (TimelineServerView)EasyMock.createNiceMock(TimelineServerView.class);
        this.client = (DruidLeaderClient)EasyMock.createMock(DruidLeaderClient.class);
        this.coordinatorClient = (DruidLeaderClient)EasyMock.createMock(DruidLeaderClient.class);
        this.overlordClient = (OverlordClient)EasyMock.createMock(OverlordClient.class);
        this.mapper = TestHelper.makeJsonMapper();
        this.responseHolder = (StringFullResponseHolder)EasyMock.createMock(StringFullResponseHolder.class);
        this.responseHandler = (BytesAccumulatingResponseHandler)EasyMock.createMockBuilder(BytesAccumulatingResponseHandler.class).withConstructor().addMockedMethod("handleResponse", new Class[]{HttpResponse.class, HttpResponseHandler.TrafficCop.class}).addMockedMethod("getStatus").createMock();
        this.request = (Request)EasyMock.createMock(Request.class);
        this.authMapper = this.createAuthMapper();
        QueryableIndex index1 = IndexBuilder.create().tmpDir(new File(tmpDir, "1")).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(new IncrementalIndexSchema.Builder().withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("cnt"), new DoubleSumAggregatorFactory("m1", "m1"), new HyperUniquesAggregatorFactory("unique_dim1", "dim1")}).withRollup(false).build()).rows(ROWS1).buildMMappedIndex();
        QueryableIndex index2 = IndexBuilder.create().tmpDir(new File(tmpDir, "2")).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(new IncrementalIndexSchema.Builder().withMetrics(new AggregatorFactory[]{new LongSumAggregatorFactory("m1", "m1")}).withRollup(false).build()).rows(ROWS2).buildMMappedIndex();
        QueryableIndex index3 = IndexBuilder.create().tmpDir(new File(tmpDir, "3")).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).schema(new IncrementalIndexSchema.Builder().withMetrics(new AggregatorFactory[]{new LongSumAggregatorFactory("m1", "m1")}).withRollup(false).build()).rows(ROWS3).buildMMappedIndex();
        this.walker = SpecificSegmentsQuerySegmentWalker.createWalker((QueryRunnerFactoryConglomerate)conglomerate).add(this.segment1, index1).add(this.segment2, index2).add(this.segment3, index3);
        BrokerSegmentMetadataCache cache = new BrokerSegmentMetadataCache(CalciteTests.createMockQueryLifecycleFactory((QuerySegmentWalker)this.walker, conglomerate), (TimelineServerView)new TestTimelineServerView(this.walker.getSegments(), this.realtimeSegments), SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new InternalQueryConfig(), (ServiceEmitter)new NoopServiceEmitter(), new PhysicalDatasourceMetadataFactory((JoinableFactory)new MapJoinableFactory((Set)ImmutableSet.of(), (Map)ImmutableMap.of()), new SegmentManager((SegmentCacheManager)EasyMock.createMock(SegmentCacheManager.class))), (CoordinatorClient)new NoopCoordinatorClient(), CentralizedDatasourceSchemaConfig.create());
        cache.start();
        cache.awaitInitialization();
        this.druidSchema = new DruidSchema(cache, null, CatalogResolver.NULL_RESOLVER);
        this.metadataView = (MetadataSegmentView)EasyMock.createMock(MetadataSegmentView.class);
        this.druidNodeDiscoveryProvider = (DruidNodeDiscoveryProvider)EasyMock.createMock(DruidNodeDiscoveryProvider.class);
        this.serverInventoryView = (FilteredServerInventoryView)EasyMock.createMock(FilteredServerInventoryView.class);
        this.schema = new SystemSchema(this.druidSchema, this.metadataView, this.serverView, this.serverInventoryView, (AuthorizerMapper)EasyMock.createStrictMock(AuthorizerMapper.class), this.client, this.overlordClient, this.druidNodeDiscoveryProvider, this.mapper);
    }

    @Test
    public void testGetTableMap() {
        Assert.assertEquals((Object)ImmutableSet.of((Object)"segments", (Object)"servers", (Object)"server_segments", (Object)"tasks", (Object)"supervisors"), (Object)this.schema.getTableNames());
        Map tableMap = this.schema.getTableMap();
        Assert.assertEquals((Object)ImmutableSet.of((Object)"segments", (Object)"servers", (Object)"server_segments", (Object)"tasks", (Object)"supervisors"), tableMap.keySet());
        SystemSchema.SegmentsTable segmentsTable = (SystemSchema.SegmentsTable)this.schema.getTableMap().get("segments");
        RelDataType rowType = segmentsTable.getRowType((RelDataTypeFactory)new JavaTypeFactoryImpl());
        List fields = rowType.getFieldList();
        Assert.assertEquals((long)19L, (long)fields.size());
        SystemSchema.TasksTable tasksTable = (SystemSchema.TasksTable)this.schema.getTableMap().get("tasks");
        RelDataType sysRowType = tasksTable.getRowType((RelDataTypeFactory)new JavaTypeFactoryImpl());
        List sysFields = sysRowType.getFieldList();
        Assert.assertEquals((long)14L, (long)sysFields.size());
        Assert.assertEquals((Object)"task_id", (Object)((RelDataTypeField)sysFields.get(0)).getName());
        Assert.assertEquals((Object)SqlTypeName.VARCHAR, (Object)((RelDataTypeField)sysFields.get(0)).getType().getSqlTypeName());
        SystemSchema.ServersTable serversTable = (SystemSchema.ServersTable)this.schema.getTableMap().get("servers");
        RelDataType serverRowType = serversTable.getRowType((RelDataTypeFactory)new JavaTypeFactoryImpl());
        List serverFields = serverRowType.getFieldList();
        Assert.assertEquals((long)10L, (long)serverFields.size());
        Assert.assertEquals((Object)"server", (Object)((RelDataTypeField)serverFields.get(0)).getName());
        Assert.assertEquals((Object)SqlTypeName.VARCHAR, (Object)((RelDataTypeField)serverFields.get(0)).getType().getSqlTypeName());
    }

    @Test
    public void testSegmentsTable() throws Exception {
        SystemSchema.SegmentsTable segmentsTable = new SystemSchema.SegmentsTable(this.druidSchema, this.metadataView, new ObjectMapper(), this.authMapper);
        HashSet<SegmentStatusInCluster> publishedSegments = new HashSet<SegmentStatusInCluster>(Arrays.asList(new SegmentStatusInCluster(this.publishedCompactedSegment1, true, Integer.valueOf(2), null, false), new SegmentStatusInCluster(this.publishedCompactedSegment2, false, Integer.valueOf(0), null, false), new SegmentStatusInCluster(this.publishedUncompactedSegment3, false, Integer.valueOf(2), null, false), new SegmentStatusInCluster(this.segment1, true, Integer.valueOf(2), null, false), new SegmentStatusInCluster(this.segment2, false, Integer.valueOf(0), null, false)));
        EasyMock.expect((Object)this.metadataView.getSegments()).andReturn(publishedSegments.iterator()).once();
        EasyMock.replay((Object[])new Object[]{this.client, this.request, this.responseHolder, this.responseHandler, this.metadataView});
        DataContext dataContext = this.createDataContext("testSuperuser");
        List rows = segmentsTable.scan(dataContext, Collections.emptyList(), null).toList();
        rows.sort((row1, row2) -> ((Comparable)row1[0]).compareTo(row2[0]));
        Assert.assertEquals((long)8L, (long)rows.size());
        this.verifyRow((Object[])rows.get(0), "test1_2010-01-01T00:00:00.000Z_2011-01-01T00:00:00.000Z_version1", 100L, 0L, 1L, 3L, 1L, 1L, 0L, 1L, null, 2L);
        this.verifyRow((Object[])rows.get(1), "test2_2011-01-01T00:00:00.000Z_2012-01-01T00:00:00.000Z_version2", 100L, 0L, 2L, 3L, 1L, 1L, 0L, 0L, null, 0L);
        this.verifyRow((Object[])rows.get(2), "test3_2012-01-01T00:00:00.000Z_2013-01-01T00:00:00.000Z_version3_2", 100L, 2L, 1L, 2L, 0L, 1L, 0L, 0L, null, -1L);
        this.verifyRow((Object[])rows.get(3), "test4_2014-01-01T00:00:00.000Z_2015-01-01T00:00:00.000Z_version4", 100L, 0L, 1L, 0L, 0L, 1L, 1L, 0L, null, -1L);
        this.verifyRow((Object[])rows.get(4), "test5_2015-01-01T00:00:00.000Z_2016-01-01T00:00:00.000Z_version5", 100L, 0L, 1L, 0L, 0L, 1L, 1L, 0L, null, -1L);
        this.verifyRow((Object[])rows.get(5), "wikipedia1_2007-01-01T00:00:00.000Z_2008-01-01T00:00:00.000Z_version1", 53000L, 0L, 0L, 0L, 1L, 0L, 0L, 1L, this.expectedCompactionState, 2L);
        this.verifyRow((Object[])rows.get(6), "wikipedia2_2008-01-01T00:00:00.000Z_2009-01-01T00:00:00.000Z_version2", 83000L, 0L, 0L, 0L, 1L, 0L, 0L, 0L, this.expectedCompactionState, 0L);
        this.verifyRow((Object[])rows.get(7), "wikipedia3_2009-01-01T00:00:00.000Z_2010-01-01T00:00:00.000Z_version3", 47000L, 0L, 0L, 0L, 1L, 0L, 0L, 0L, null, 2L);
        SystemSchemaTest.verifyTypes(rows, SystemSchema.SEGMENTS_SIGNATURE);
    }

    @Test
    public void testSegmentsTableWithProjection() throws JsonProcessingException {
        SystemSchema.SegmentsTable segmentsTable = new SystemSchema.SegmentsTable(this.druidSchema, this.metadataView, new ObjectMapper(), this.authMapper);
        HashSet<SegmentStatusInCluster> publishedSegments = new HashSet<SegmentStatusInCluster>(Arrays.asList(new SegmentStatusInCluster(this.publishedCompactedSegment1, true, Integer.valueOf(2), null, false), new SegmentStatusInCluster(this.publishedCompactedSegment2, false, Integer.valueOf(0), null, false), new SegmentStatusInCluster(this.publishedUncompactedSegment3, false, Integer.valueOf(2), null, false), new SegmentStatusInCluster(this.segment1, true, Integer.valueOf(2), null, false), new SegmentStatusInCluster(this.segment2, false, Integer.valueOf(0), null, false)));
        EasyMock.expect((Object)this.metadataView.getSegments()).andReturn(publishedSegments.iterator()).once();
        EasyMock.replay((Object[])new Object[]{this.client, this.request, this.responseHolder, this.responseHandler, this.metadataView});
        DataContext dataContext = this.createDataContext("testSuperuser");
        List rows = segmentsTable.scan(dataContext, Collections.emptyList(), new int[]{SystemSchema.SEGMENTS_SIGNATURE.indexOf("last_compaction_state"), SystemSchema.SEGMENTS_SIGNATURE.indexOf("segment_id")}).toList();
        rows.sort((row1, row2) -> ((Comparable)row1[1]).compareTo(row2[1]));
        Assert.assertEquals((long)8L, (long)rows.size());
        Assert.assertNull(null, (Object)((Object[])rows.get(0))[0]);
        Assert.assertEquals((Object)"test1_2010-01-01T00:00:00.000Z_2011-01-01T00:00:00.000Z_version1", (Object)((Object[])rows.get(0))[1]);
        Assert.assertNull(null, (Object)((Object[])rows.get(1))[0]);
        Assert.assertEquals((Object)"test2_2011-01-01T00:00:00.000Z_2012-01-01T00:00:00.000Z_version2", (Object)((Object[])rows.get(1))[1]);
        Assert.assertNull(null, (Object)((Object[])rows.get(2))[0]);
        Assert.assertEquals((Object)"test3_2012-01-01T00:00:00.000Z_2013-01-01T00:00:00.000Z_version3_2", (Object)((Object[])rows.get(2))[1]);
        Assert.assertNull(null, (Object)((Object[])rows.get(3))[0]);
        Assert.assertEquals((Object)"test4_2014-01-01T00:00:00.000Z_2015-01-01T00:00:00.000Z_version4", (Object)((Object[])rows.get(3))[1]);
        Assert.assertNull(null, (Object)((Object[])rows.get(4))[0]);
        Assert.assertEquals((Object)"test5_2015-01-01T00:00:00.000Z_2016-01-01T00:00:00.000Z_version5", (Object)((Object[])rows.get(4))[1]);
        Assert.assertEquals((Object)this.mapper.writeValueAsString((Object)this.expectedCompactionState), (Object)((Object[])rows.get(5))[0]);
        Assert.assertEquals((Object)"wikipedia1_2007-01-01T00:00:00.000Z_2008-01-01T00:00:00.000Z_version1", (Object)((Object[])rows.get(5))[1]);
        Assert.assertEquals((Object)this.mapper.writeValueAsString((Object)this.expectedCompactionState), (Object)((Object[])rows.get(6))[0]);
        Assert.assertEquals((Object)"wikipedia2_2008-01-01T00:00:00.000Z_2009-01-01T00:00:00.000Z_version2", (Object)((Object[])rows.get(6))[1]);
        Assert.assertNull(null, (Object)((Object[])rows.get(7))[0]);
        Assert.assertEquals((Object)"wikipedia3_2009-01-01T00:00:00.000Z_2010-01-01T00:00:00.000Z_version3", (Object)((Object[])rows.get(7))[1]);
        SystemSchemaTest.verifyTypes(rows, RowSignature.builder().add("last_compaction_state", ColumnType.STRING).add("segment_id", ColumnType.STRING).build());
    }

    private void verifyRow(Object[] row, String segmentId, long size, long partitionNum, long numReplicas, long numRows, long isPublished, long isAvailable, long isRealtime, long isOvershadowed, CompactionState compactionState, long replicationFactor) throws Exception {
        Assert.assertEquals((Object)segmentId, (Object)row[0].toString());
        SegmentId id = (SegmentId)Iterables.get((Iterable)SegmentId.iterateAllPossibleParsings((String)segmentId), (int)0);
        Assert.assertEquals((Object)id.getDataSource(), (Object)row[1]);
        Assert.assertEquals((Object)id.getIntervalStart().toString(), (Object)row[2]);
        Assert.assertEquals((Object)id.getIntervalEnd().toString(), (Object)row[3]);
        Assert.assertEquals((Object)size, (Object)row[4]);
        Assert.assertEquals((Object)id.getVersion(), (Object)row[5]);
        Assert.assertEquals((Object)partitionNum, (Object)row[6]);
        Assert.assertEquals((Object)numReplicas, (Object)row[7]);
        Assert.assertEquals((Object)numRows, (Object)row[8]);
        Assert.assertEquals((Object)(isPublished == 1L && isOvershadowed == 0L || isRealtime == 1L ? 1L : 0L), (Object)row[9]);
        Assert.assertEquals((Object)isPublished, (Object)row[10]);
        Assert.assertEquals((Object)isAvailable, (Object)row[11]);
        Assert.assertEquals((Object)isRealtime, (Object)row[12]);
        Assert.assertEquals((Object)isOvershadowed, (Object)row[13]);
        if (compactionState == null) {
            Assert.assertNull((Object)row[17]);
        } else {
            Assert.assertEquals((Object)this.mapper.writeValueAsString((Object)compactionState), (Object)row[17]);
        }
        Assert.assertEquals((Object)replicationFactor, (Object)row[18]);
    }

    @Test
    public void testServersTable() throws URISyntaxException {
        SystemSchema.ServersTable serversTable = (SystemSchema.ServersTable)EasyMock.createMockBuilder(SystemSchema.ServersTable.class).withConstructor(new Object[]{this.druidNodeDiscoveryProvider, this.serverInventoryView, this.authMapper, this.overlordClient, this.coordinatorClient}).createMock();
        EasyMock.replay((Object[])new Object[]{serversTable});
        DruidNodeDiscovery coordinatorNodeDiscovery = (DruidNodeDiscovery)EasyMock.createMock(DruidNodeDiscovery.class);
        DruidNodeDiscovery overlordNodeDiscovery = (DruidNodeDiscovery)EasyMock.createMock(DruidNodeDiscovery.class);
        DruidNodeDiscovery brokerNodeDiscovery = (DruidNodeDiscovery)EasyMock.createMock(DruidNodeDiscovery.class);
        DruidNodeDiscovery routerNodeDiscovery = (DruidNodeDiscovery)EasyMock.createMock(DruidNodeDiscovery.class);
        DruidNodeDiscovery historicalNodeDiscovery = (DruidNodeDiscovery)EasyMock.createMock(DruidNodeDiscovery.class);
        DruidNodeDiscovery mmNodeDiscovery = (DruidNodeDiscovery)EasyMock.createMock(DruidNodeDiscovery.class);
        DruidNodeDiscovery peonNodeDiscovery = (DruidNodeDiscovery)EasyMock.createMock(DruidNodeDiscovery.class);
        DruidNodeDiscovery indexerNodeDiscovery = (DruidNodeDiscovery)EasyMock.createMock(DruidNodeDiscovery.class);
        EasyMock.expect((Object)this.druidNodeDiscoveryProvider.getForNodeRole(NodeRole.COORDINATOR)).andReturn((Object)coordinatorNodeDiscovery).once();
        EasyMock.expect((Object)this.druidNodeDiscoveryProvider.getForNodeRole(NodeRole.OVERLORD)).andReturn((Object)overlordNodeDiscovery).once();
        EasyMock.expect((Object)this.druidNodeDiscoveryProvider.getForNodeRole(NodeRole.BROKER)).andReturn((Object)brokerNodeDiscovery).once();
        EasyMock.expect((Object)this.druidNodeDiscoveryProvider.getForNodeRole(NodeRole.ROUTER)).andReturn((Object)routerNodeDiscovery).once();
        EasyMock.expect((Object)this.druidNodeDiscoveryProvider.getForNodeRole(NodeRole.HISTORICAL)).andReturn((Object)historicalNodeDiscovery).once();
        EasyMock.expect((Object)this.druidNodeDiscoveryProvider.getForNodeRole(NodeRole.MIDDLE_MANAGER)).andReturn((Object)mmNodeDiscovery).once();
        EasyMock.expect((Object)this.druidNodeDiscoveryProvider.getForNodeRole(NodeRole.INDEXER)).andReturn((Object)indexerNodeDiscovery).once();
        EasyMock.expect((Object)this.druidNodeDiscoveryProvider.getForNodeRole(NodeRole.PEON)).andReturn((Object)peonNodeDiscovery).once();
        EasyMock.expect((Object)coordinatorNodeDiscovery.getAllNodes()).andReturn((Object)ImmutableList.of((Object)this.coordinator, (Object)this.coordinator2)).once();
        EasyMock.expect((Object)overlordNodeDiscovery.getAllNodes()).andReturn((Object)ImmutableList.of((Object)this.overlord, (Object)this.overlord2)).once();
        EasyMock.expect((Object)brokerNodeDiscovery.getAllNodes()).andReturn((Object)ImmutableList.of((Object)this.broker1, (Object)this.broker2, (Object)this.brokerWithBroadcastSegments)).once();
        EasyMock.expect((Object)routerNodeDiscovery.getAllNodes()).andReturn((Object)ImmutableList.of((Object)this.router)).once();
        EasyMock.expect((Object)historicalNodeDiscovery.getAllNodes()).andReturn((Object)ImmutableList.of((Object)this.historical1, (Object)this.historical2, (Object)this.lameHistorical)).once();
        EasyMock.expect((Object)mmNodeDiscovery.getAllNodes()).andReturn((Object)ImmutableList.of((Object)this.middleManager)).once();
        EasyMock.expect((Object)peonNodeDiscovery.getAllNodes()).andReturn((Object)ImmutableList.of((Object)this.peon1, (Object)this.peon2)).once();
        EasyMock.expect((Object)indexerNodeDiscovery.getAllNodes()).andReturn((Object)ImmutableList.of((Object)this.indexer)).once();
        EasyMock.expect((Object)this.coordinatorClient.findCurrentLeader()).andReturn((Object)this.coordinator.getDruidNode().getHostAndPortToUse()).once();
        EasyMock.expect((Object)this.overlordClient.findCurrentLeader()).andReturn((Object)Futures.immediateFuture((Object)new URI(this.overlord.getDruidNode().getHostAndPortToUse()))).once();
        ArrayList<DruidServer> servers = new ArrayList<DruidServer>();
        servers.add(this.mockDataServer(this.historical1.getDruidNode().getHostAndPortToUse(), 200L, 1000L, "tier"));
        servers.add(this.mockDataServer(this.historical2.getDruidNode().getHostAndPortToUse(), 400L, 1000L, "tier"));
        servers.add(this.mockDataServer(this.peon1.getDruidNode().getHostAndPortToUse(), 0L, 1000L, "tier"));
        servers.add(this.mockDataServer(this.peon2.getDruidNode().getHostAndPortToUse(), 0L, 1000L, "tier"));
        servers.add(this.mockDataServer(this.broker1.getDruidNode().getHostAndPortToUse(), 0L, 1000L, "tier"));
        servers.add(this.mockDataServer(this.broker2.getDruidNode().getHostAndPortToUse(), 0L, 1000L, "tier"));
        servers.add(this.mockDataServer(this.indexer.getDruidNode().getHostAndPortToUse(), 0L, 1000L, "tier"));
        servers.add(this.mockDataServer(this.brokerWithBroadcastSegments.getDruidNode().getHostAndPortToUse(), 0L, 1000L, "tier"));
        EasyMock.expect((Object)this.serverInventoryView.getInventoryValue(this.lameHistorical.getDruidNode().getHostAndPortToUse())).andReturn(null).once();
        EasyMock.replay((Object[])new Object[]{this.druidNodeDiscoveryProvider, this.serverInventoryView, this.coordinatorClient, this.overlordClient});
        EasyMock.replay((Object[])servers.toArray(new Object[0]));
        EasyMock.replay((Object[])new Object[]{coordinatorNodeDiscovery, overlordNodeDiscovery, brokerNodeDiscovery, routerNodeDiscovery, historicalNodeDiscovery, mmNodeDiscovery, peonNodeDiscovery, indexerNodeDiscovery});
        DataContext dataContext = this.createDataContext("testSuperuser");
        List rows = serversTable.scan(dataContext).toList();
        rows.sort((row1, row2) -> ((Comparable)row1[0]).compareTo(row2[0]));
        ArrayList<Object[]> expectedRows = new ArrayList<Object[]>();
        Long nonLeader = null;
        String startTimeStr = this.startTime.toString();
        expectedRows.add(this.createExpectedRow("brokerHost:8082", "brokerHost", 8082, -1, NodeRole.BROKER, null, 0L, 0L, nonLeader, startTimeStr));
        expectedRows.add(this.createExpectedRow("brokerHostWithBroadcastSegments:8282", "brokerHostWithBroadcastSegments", 8082, 8282, NodeRole.BROKER, "tier", 0L, 1000L, nonLeader, startTimeStr));
        expectedRows.add(this.createExpectedRow("histHost:8083", "histHost", 8083, -1, NodeRole.HISTORICAL, "tier", 400L, 1000L, nonLeader, startTimeStr));
        expectedRows.add(this.createExpectedRow("indexerHost:8091", "indexerHost", 8091, -1, NodeRole.INDEXER, "tier", 0L, 1000L, nonLeader, startTimeStr));
        expectedRows.add(this.createExpectedRow("lameHost:8083", "lameHost", 8083, -1, NodeRole.HISTORICAL, "tier", 0L, 1000L, nonLeader, startTimeStr));
        expectedRows.add(this.createExpectedRow("localhost:8080", "localhost", 8080, -1, NodeRole.PEON, "tier", 0L, 1000L, nonLeader, startTimeStr));
        expectedRows.add(this.createExpectedRow("localhost:8081", "localhost", 8081, -1, NodeRole.COORDINATOR, null, 0L, 0L, 1L, startTimeStr));
        expectedRows.add(this.createExpectedRow("localhost:8082", "localhost", 8082, -1, NodeRole.BROKER, null, 0L, 0L, nonLeader, startTimeStr));
        expectedRows.add(this.createExpectedRow("localhost:8083", "localhost", 8083, -1, NodeRole.HISTORICAL, "tier", 200L, 1000L, nonLeader, startTimeStr));
        expectedRows.add(this.createExpectedRow("localhost:8090", "localhost", 8090, -1, NodeRole.OVERLORD, null, 0L, 0L, 1L, startTimeStr));
        expectedRows.add(this.createExpectedRow("localhost:8181", "localhost", 8181, -1, NodeRole.COORDINATOR, null, 0L, 0L, 0L, startTimeStr));
        expectedRows.add(this.createExpectedRow("localhost:8190", "localhost", 8190, -1, NodeRole.OVERLORD, null, 0L, 0L, 0L, startTimeStr));
        expectedRows.add(this.createExpectedRow("localhost:8888", "localhost", 8888, -1, NodeRole.ROUTER, null, 0L, 0L, nonLeader, startTimeStr));
        expectedRows.add(this.createExpectedRow("mmHost:8091", "mmHost", 8091, -1, NodeRole.MIDDLE_MANAGER, null, 0L, 0L, nonLeader, startTimeStr));
        expectedRows.add(this.createExpectedRow("peonHost:8080", "peonHost", 8080, -1, NodeRole.PEON, "tier", 0L, 1000L, nonLeader, startTimeStr));
        Assert.assertEquals((long)expectedRows.size(), (long)rows.size());
        for (int i = 0; i < rows.size(); ++i) {
            Assert.assertArrayEquals((Object[])((Object[])expectedRows.get(i)), (Object[])((Object[])rows.get(i)));
        }
        SystemSchemaTest.verifyTypes(rows, SystemSchema.SERVERS_SIGNATURE);
    }

    private DruidServer mockDataServer(String name, long currentSize, long maxSize, String tier) {
        DruidServer server = (DruidServer)EasyMock.createMock(DruidServer.class);
        EasyMock.expect((Object)this.serverInventoryView.getInventoryValue(name)).andReturn((Object)server).once();
        EasyMock.expect((Object)server.getCurrSize()).andReturn((Object)currentSize).once();
        EasyMock.expect((Object)server.getMaxSize()).andReturn((Object)maxSize).once();
        EasyMock.expect((Object)server.getTier()).andReturn((Object)tier).once();
        return server;
    }

    private Object[] createExpectedRow(String server, String host, int plaintextPort, int tlsPort, NodeRole nodeRole, @Nullable String tier, @Nullable Long currSize, @Nullable Long maxSize, @Nullable Long isLeader, String startTime) {
        return new Object[]{server, host, (long)plaintextPort, (long)tlsPort, StringUtils.toLowerCase((String)nodeRole.toString()), tier, currSize, maxSize, isLeader, startTime};
    }

    @Test
    public void testServerSegmentsTable() {
        SystemSchema.ServerSegmentsTable serverSegmentsTable = (SystemSchema.ServerSegmentsTable)EasyMock.createMockBuilder(SystemSchema.ServerSegmentsTable.class).withConstructor(new Object[]{this.serverView, this.authMapper}).createMock();
        EasyMock.replay((Object[])new Object[]{serverSegmentsTable});
        EasyMock.expect((Object)this.serverView.getDruidServers()).andReturn(this.immutableDruidServers).once();
        EasyMock.replay((Object[])new Object[]{this.serverView});
        DataContext dataContext = this.createDataContext("testSuperuser");
        List rows = serverSegmentsTable.scan(dataContext).toList();
        Assert.assertEquals((long)5L, (long)rows.size());
        Object[] row0 = (Object[])rows.get(0);
        Assert.assertEquals((Object)"localhost:0000", (Object)row0[0]);
        Assert.assertEquals((Object)"test1_2010-01-01T00:00:00.000Z_2011-01-01T00:00:00.000Z_version1", (Object)row0[1].toString());
        Object[] row1 = (Object[])rows.get(1);
        Assert.assertEquals((Object)"localhost:0000", (Object)row1[0]);
        Assert.assertEquals((Object)"test2_2011-01-01T00:00:00.000Z_2012-01-01T00:00:00.000Z_version2", (Object)row1[1].toString());
        Object[] row2 = (Object[])rows.get(2);
        Assert.assertEquals((Object)"server2:1234", (Object)row2[0]);
        Assert.assertEquals((Object)"test3_2012-01-01T00:00:00.000Z_2013-01-01T00:00:00.000Z_version3_2", (Object)row2[1].toString());
        Object[] row3 = (Object[])rows.get(3);
        Assert.assertEquals((Object)"server2:1234", (Object)row3[0]);
        Assert.assertEquals((Object)"test4_2014-01-01T00:00:00.000Z_2015-01-01T00:00:00.000Z_version4", (Object)row3[1].toString());
        Object[] row4 = (Object[])rows.get(4);
        Assert.assertEquals((Object)"server2:1234", (Object)row4[0]);
        Assert.assertEquals((Object)"test5_2015-01-01T00:00:00.000Z_2016-01-01T00:00:00.000Z_version5", (Object)row4[1].toString());
        SystemSchemaTest.verifyTypes(rows, SystemSchema.SERVER_SEGMENTS_SIGNATURE);
    }

    @Test
    public void testTasksTable() throws Exception {
        SystemSchema.TasksTable tasksTable = (SystemSchema.TasksTable)EasyMock.createMockBuilder(SystemSchema.TasksTable.class).withConstructor(new Object[]{this.overlordClient, this.authMapper}).createMock();
        EasyMock.replay((Object[])new Object[]{tasksTable});
        String json = "[{\n\t\"id\": \"index_wikipedia_2018-09-20T22:33:44.911Z\",\n\t\"groupId\": \"group_index_wikipedia_2018-09-20T22:33:44.911Z\",\n\t\"type\": \"index\",\n\t\"createdTime\": \"2018-09-20T22:33:44.922Z\",\n\t\"queueInsertionTime\": \"1970-01-01T00:00:00.000Z\",\n\t\"statusCode\": \"FAILED\",\n\t\"runnerStatusCode\": \"NONE\",\n\t\"duration\": -1,\n\t\"location\": {\n\t\t\"host\": \"testHost\",\n\t\t\"port\": 1234,\n\t\t\"tlsPort\": -1\n\t},\n\t\"dataSource\": \"wikipedia\",\n\t\"errorMsg\": null\n}, {\n\t\"id\": \"index_wikipedia_2018-09-21T18:38:47.773Z\",\n\t\"groupId\": \"group_index_wikipedia_2018-09-21T18:38:47.773Z\",\n\t\"type\": \"index\",\n\t\"createdTime\": \"2018-09-21T18:38:47.873Z\",\n\t\"queueInsertionTime\": \"2018-09-21T18:38:47.910Z\",\n\t\"statusCode\": \"RUNNING\",\n\t\"runnerStatusCode\": \"RUNNING\",\n\t\"duration\": null,\n\t\"location\": {\n\t\t\"host\": \"192.168.1.6\",\n\t\t\"port\": 8100,\n\t\t\"tlsPort\": -1\n\t},\n\t\"dataSource\": \"wikipedia\",\n\t\"errorMsg\": null\n}]";
        EasyMock.expect((Object)this.overlordClient.taskStatuses(null, null, null)).andReturn((Object)Futures.immediateFuture((Object)CloseableIterators.withEmptyBaggage(((List)this.mapper.readValue(json, (TypeReference)new TypeReference<List<TaskStatusPlus>>(){})).iterator())));
        EasyMock.replay((Object[])new Object[]{this.overlordClient, this.request, this.responseHandler});
        DataContext dataContext = this.createDataContext("testSuperuser");
        List rows = tasksTable.scan(dataContext).toList();
        Object[] row0 = (Object[])rows.get(0);
        Assert.assertEquals((Object)"index_wikipedia_2018-09-20T22:33:44.911Z", (Object)row0[0].toString());
        Assert.assertEquals((Object)"group_index_wikipedia_2018-09-20T22:33:44.911Z", (Object)row0[1].toString());
        Assert.assertEquals((Object)"index", (Object)row0[2].toString());
        Assert.assertEquals((Object)"wikipedia", (Object)row0[3].toString());
        Assert.assertEquals((Object)"2018-09-20T22:33:44.922Z", (Object)row0[4].toString());
        Assert.assertEquals((Object)"1970-01-01T00:00:00.000Z", (Object)row0[5].toString());
        Assert.assertEquals((Object)"FAILED", (Object)row0[6].toString());
        Assert.assertEquals((Object)"NONE", (Object)row0[7].toString());
        Assert.assertEquals((Object)-1L, (Object)row0[8]);
        Assert.assertEquals((Object)"testHost:1234", (Object)row0[9]);
        Assert.assertEquals((Object)"testHost", (Object)row0[10]);
        Assert.assertEquals((Object)1234L, (Object)row0[11]);
        Assert.assertEquals((Object)-1L, (Object)row0[12]);
        Assert.assertEquals(null, (Object)row0[13]);
        Object[] row1 = (Object[])rows.get(1);
        Assert.assertEquals((Object)"index_wikipedia_2018-09-21T18:38:47.773Z", (Object)row1[0].toString());
        Assert.assertEquals((Object)"group_index_wikipedia_2018-09-21T18:38:47.773Z", (Object)row1[1].toString());
        Assert.assertEquals((Object)"index", (Object)row1[2].toString());
        Assert.assertEquals((Object)"wikipedia", (Object)row1[3].toString());
        Assert.assertEquals((Object)"2018-09-21T18:38:47.873Z", (Object)row1[4].toString());
        Assert.assertEquals((Object)"2018-09-21T18:38:47.910Z", (Object)row1[5].toString());
        Assert.assertEquals((Object)"RUNNING", (Object)row1[6].toString());
        Assert.assertEquals((Object)"RUNNING", (Object)row1[7].toString());
        Assert.assertEquals((Object)0L, (Object)row1[8]);
        Assert.assertEquals((Object)"192.168.1.6:8100", (Object)row1[9]);
        Assert.assertEquals((Object)"192.168.1.6", (Object)row1[10]);
        Assert.assertEquals((Object)8100L, (Object)row1[11]);
        Assert.assertEquals((Object)-1L, (Object)row1[12]);
        Assert.assertEquals(null, (Object)row1[13]);
        SystemSchemaTest.verifyTypes(rows, SystemSchema.TASKS_SIGNATURE);
    }

    @Test
    public void testTasksTableAuth() {
        SystemSchema.TasksTable tasksTable = new SystemSchema.TasksTable(this.overlordClient, this.authMapper);
        String json = "[{\n\t\"id\": \"index_wikipedia_2018-09-20T22:33:44.911Z\",\n\t\"groupId\": \"group_index_wikipedia_2018-09-20T22:33:44.911Z\",\n\t\"type\": \"index\",\n\t\"createdTime\": \"2018-09-20T22:33:44.922Z\",\n\t\"queueInsertionTime\": \"1970-01-01T00:00:00.000Z\",\n\t\"statusCode\": \"FAILED\",\n\t\"runnerStatusCode\": \"NONE\",\n\t\"duration\": -1,\n\t\"location\": {\n\t\t\"host\": \"testHost\",\n\t\t\"port\": 1234,\n\t\t\"tlsPort\": -1\n\t},\n\t\"dataSource\": \"wikipedia\",\n\t\"errorMsg\": null\n}, {\n\t\"id\": \"index_wikipedia_2018-09-21T18:38:47.773Z\",\n\t\"groupId\": \"group_index_wikipedia_2018-09-21T18:38:47.773Z\",\n\t\"type\": \"index\",\n\t\"createdTime\": \"2018-09-21T18:38:47.873Z\",\n\t\"queueInsertionTime\": \"2018-09-21T18:38:47.910Z\",\n\t\"statusCode\": \"RUNNING\",\n\t\"runnerStatusCode\": \"RUNNING\",\n\t\"duration\": null,\n\t\"location\": {\n\t\t\"host\": \"192.168.1.6\",\n\t\t\"port\": 8100,\n\t\t\"tlsPort\": -1\n\t},\n\t\"dataSource\": \"wikipedia\",\n\t\"errorMsg\": null\n}]";
        EasyMock.expect((Object)this.overlordClient.taskStatuses(null, null, null)).andAnswer(() -> Futures.immediateFuture((Object)CloseableIterators.withEmptyBaggage(((List)this.mapper.readValue(json, (TypeReference)new TypeReference<List<TaskStatusPlus>>(){})).iterator()))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.overlordClient});
        List rows = tasksTable.scan(this.createDataContext("datasourceWrite")).toList();
        Assert.assertTrue((boolean)rows.isEmpty());
        rows = tasksTable.scan(this.createDataContext("datasourceRead")).toList();
        Assert.assertEquals((long)2L, (long)rows.size());
        rows = tasksTable.scan(this.createDataContext("testSuperuser")).toList();
        Assert.assertEquals((long)2L, (long)rows.size());
    }

    @Test
    public void testSupervisorTable() throws Exception {
        SystemSchema.SupervisorsTable supervisorTable = (SystemSchema.SupervisorsTable)EasyMock.createMockBuilder(SystemSchema.SupervisorsTable.class).withConstructor(new Object[]{this.overlordClient, this.authMapper}).createMock();
        EasyMock.replay((Object[])new Object[]{supervisorTable});
        String json = "[{\n\t\"id\": \"wikipedia\",\n\t\"state\": \"UNHEALTHY_SUPERVISOR\",\n\t\"detailedState\": \"UNABLE_TO_CONNECT_TO_STREAM\",\n\t\"healthy\": false,\n\t\"specString\": \"{\\\"type\\\":\\\"kafka\\\",\\\"dataSchema\\\":{\\\"dataSource\\\":\\\"wikipedia\\\"},\\\"context\\\":null,\\\"suspended\\\":false}\",\n\t\"type\": \"kafka\",\n\t\"source\": \"wikipedia\",\n\t\"suspended\": false\n}]";
        EasyMock.expect((Object)this.overlordClient.supervisorStatuses()).andReturn((Object)Futures.immediateFuture((Object)CloseableIterators.withEmptyBaggage(((List)this.mapper.readValue(json, (TypeReference)new TypeReference<List<SupervisorStatus>>(){})).iterator())));
        EasyMock.replay((Object[])new Object[]{this.overlordClient});
        DataContext dataContext = this.createDataContext("testSuperuser");
        List rows = supervisorTable.scan(dataContext).toList();
        Object[] row0 = (Object[])rows.get(0);
        Assert.assertEquals((Object)"wikipedia", (Object)row0[0].toString());
        Assert.assertEquals((Object)"UNHEALTHY_SUPERVISOR", (Object)row0[1].toString());
        Assert.assertEquals((Object)"UNABLE_TO_CONNECT_TO_STREAM", (Object)row0[2].toString());
        Assert.assertEquals((Object)0L, (Object)row0[3]);
        Assert.assertEquals((Object)"kafka", (Object)row0[4].toString());
        Assert.assertEquals((Object)"wikipedia", (Object)row0[5].toString());
        Assert.assertEquals((Object)0L, (Object)row0[6]);
        Assert.assertEquals((Object)"{\"type\":\"kafka\",\"dataSchema\":{\"dataSource\":\"wikipedia\"},\"context\":null,\"suspended\":false}", (Object)row0[7].toString());
        SystemSchemaTest.verifyTypes(rows, SystemSchema.SUPERVISOR_SIGNATURE);
    }

    @Test
    public void testSupervisorTableAuth() {
        SystemSchema.SupervisorsTable supervisorTable = new SystemSchema.SupervisorsTable(this.overlordClient, this.createAuthMapper());
        String json = "[{\n\t\"id\": \"wikipedia\",\n\t\"state\": \"UNHEALTHY_SUPERVISOR\",\n\t\"detailedState\": \"UNABLE_TO_CONNECT_TO_STREAM\",\n\t\"healthy\": false,\n\t\"specString\": \"{\\\"type\\\":\\\"kafka\\\",\\\"dataSchema\\\":{\\\"dataSource\\\":\\\"wikipedia\\\"},\\\"context\\\":null,\\\"suspended\\\":false}\",\n\t\"type\": \"kafka\",\n\t\"source\": \"wikipedia\",\n\t\"suspended\": false\n}]";
        EasyMock.expect((Object)this.overlordClient.supervisorStatuses()).andAnswer(() -> Futures.immediateFuture((Object)CloseableIterators.withEmptyBaggage(((List)this.mapper.readValue("[{\n\t\"id\": \"wikipedia\",\n\t\"state\": \"UNHEALTHY_SUPERVISOR\",\n\t\"detailedState\": \"UNABLE_TO_CONNECT_TO_STREAM\",\n\t\"healthy\": false,\n\t\"specString\": \"{\\\"type\\\":\\\"kafka\\\",\\\"dataSchema\\\":{\\\"dataSource\\\":\\\"wikipedia\\\"},\\\"context\\\":null,\\\"suspended\\\":false}\",\n\t\"type\": \"kafka\",\n\t\"source\": \"wikipedia\",\n\t\"suspended\": false\n}]", (TypeReference)new TypeReference<List<SupervisorStatus>>(){})).iterator()))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.overlordClient});
        List rows = supervisorTable.scan(this.createDataContext("datasourceWrite")).toList();
        Assert.assertTrue((boolean)rows.isEmpty());
        rows = supervisorTable.scan(this.createDataContext("datasourceRead")).toList();
        Assert.assertEquals((long)1L, (long)rows.size());
        rows = supervisorTable.scan(this.createDataContext("testSuperuser")).toList();
        Assert.assertEquals((long)1L, (long)rows.size());
    }

    private InputStreamFullResponseHolder createFullResponseHolder(HttpResponse httpResponse, String json) {
        InputStreamFullResponseHolder responseHolder = new InputStreamFullResponseHolder(httpResponse);
        byte[] bytesToWrite = json.getBytes(StandardCharsets.UTF_8);
        responseHolder.addChunk(bytesToWrite);
        responseHolder.done();
        return responseHolder;
    }

    private DataContext createDataContext(final String username) {
        return new DataContext(){

            public SchemaPlus getRootSchema() {
                return null;
            }

            public JavaTypeFactory getTypeFactory() {
                return null;
            }

            public QueryProvider getQueryProvider() {
                return null;
            }

            public Object get(String authorizerName) {
                return "testSuperuser".equals(username) ? CalciteTests.SUPER_USER_AUTH_RESULT : new AuthenticationResult(username, authorizerName, null, null);
            }
        };
    }

    private AuthorizerMapper createAuthMapper() {
        return new AuthorizerMapper(null){

            public Authorizer getAuthorizer(String name) {
                return (authenticationResult, resource, action) -> {
                    String username = authenticationResult.getIdentity();
                    if (resource.getType().equals("DATASOURCE")) {
                        return new Access(username.equals("testSuperuser") || action == Action.READ && username.equals("datasourceRead") || action == Action.WRITE && username.equals("datasourceWrite"));
                    }
                    return new Access(true);
                };
            }
        };
    }

    private static void verifyTypes(List<Object[]> rows, RowSignature signature) {
        RelDataType rowType = RowSignatures.toRelDataType((RowSignature)signature, (RelDataTypeFactory)new JavaTypeFactoryImpl());
        for (Object[] row : rows) {
            Assert.assertEquals((long)row.length, (long)signature.size());
            for (int i = 0; i < row.length; ++i) {
                Class expectedClass;
                ColumnType columnType = (ColumnType)signature.getColumnType(i).orElseThrow(() -> new ISE("Encountered null column type", new Object[0]));
                boolean nullable = ((RelDataTypeField)rowType.getFieldList().get(i)).getType().isNullable();
                switch ((ValueType)columnType.getType()) {
                    case LONG: {
                        expectedClass = Long.class;
                        break;
                    }
                    case FLOAT: {
                        expectedClass = Float.class;
                        break;
                    }
                    case DOUBLE: {
                        expectedClass = Double.class;
                        break;
                    }
                    case STRING: {
                        expectedClass = String.class;
                        break;
                    }
                    default: {
                        throw new IAE("Don't know what class to expect for valueType[%s]", new Object[]{columnType});
                    }
                }
                if (nullable) {
                    Assert.assertTrue((String)StringUtils.format((String)"Column[%s] is a [%s] or null (was %s)", (Object[])new Object[]{signature.getColumnName(i), expectedClass.getName(), row[i] == null ? null : row[i].getClass().getName()}), (row[i] == null || expectedClass.isAssignableFrom(row[i].getClass()) ? 1 : 0) != 0);
                    continue;
                }
                Assert.assertTrue((String)StringUtils.format((String)"Column[%s] is a [%s] (was %s)", (Object[])new Object[]{signature.getColumnName(i), expectedClass.getName(), row[i] == null ? null : row[i].getClass().getName()}), (row[i] != null && expectedClass.isAssignableFrom(row[i].getClass()) ? 1 : 0) != 0);
            }
        }
    }

    private static class Users {
        private static final String SUPER = "testSuperuser";
        private static final String DATASOURCE_READ = "datasourceRead";
        private static final String DATASOURCE_WRITE = "datasourceWrite";

        private Users() {
        }
    }
}

