/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.schema;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.druid.client.InternalQueryConfig;
import org.apache.druid.client.TimelineServerView;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.join.MapJoinableFactory;
import org.apache.druid.segment.loading.SegmentCacheManager;
import org.apache.druid.segment.loading.SegmentLocalCacheManager;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.server.QueryStackTests;
import org.apache.druid.server.SegmentManager;
import org.apache.druid.server.SpecificSegmentsQuerySegmentWalker;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.server.security.Escalator;
import org.apache.druid.server.security.NoopEscalator;
import org.apache.druid.sql.calcite.planner.CatalogResolver;
import org.apache.druid.sql.calcite.schema.BrokerSegmentMetadataCache;
import org.apache.druid.sql.calcite.schema.BrokerSegmentMetadataCacheConfig;
import org.apache.druid.sql.calcite.schema.DruidSchema;
import org.apache.druid.sql.calcite.schema.PhysicalDatasourceMetadataFactory;
import org.apache.druid.sql.calcite.util.CalciteTestBase;
import org.apache.druid.sql.calcite.util.CalciteTests;
import org.apache.druid.sql.calcite.util.TestTimelineServerView;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.jupiter.api.Test;

public class DruidSchemaNoDataInitTest
extends CalciteTestBase {
    private static final BrokerSegmentMetadataCacheConfig SEGMENT_CACHE_CONFIG_DEFAULT = BrokerSegmentMetadataCacheConfig.create();

    @Test
    public void testInitializationWithNoData() throws Exception {
        try (Closer closer = Closer.create();){
            QueryRunnerFactoryConglomerate conglomerate = QueryStackTests.createQueryRunnerFactoryConglomerate((Closer)closer);
            BrokerSegmentMetadataCache cache = new BrokerSegmentMetadataCache(CalciteTests.createMockQueryLifecycleFactory((QuerySegmentWalker)SpecificSegmentsQuerySegmentWalker.createWalker((QueryRunnerFactoryConglomerate)conglomerate), conglomerate), (TimelineServerView)new TestTimelineServerView(Collections.emptyList()), SEGMENT_CACHE_CONFIG_DEFAULT, (Escalator)new NoopEscalator(), new InternalQueryConfig(), (ServiceEmitter)new NoopServiceEmitter(), new PhysicalDatasourceMetadataFactory((JoinableFactory)new MapJoinableFactory((Set)ImmutableSet.of(), (Map)ImmutableMap.of()), new SegmentManager((SegmentCacheManager)EasyMock.createMock(SegmentLocalCacheManager.class))), null, CentralizedDatasourceSchemaConfig.create());
            cache.start();
            cache.awaitInitialization();
            DruidSchema druidSchema = new DruidSchema(cache, null, CatalogResolver.NULL_RESOLVER);
            Assert.assertEquals((Object)ImmutableSet.of(), (Object)druidSchema.getTableNames());
        }
    }
}

