/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.schema;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.GlobalTableDataSource;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.Joinable;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.loading.SegmentCacheManager;
import org.apache.druid.segment.metadata.SegmentMetadataCacheTestBase;
import org.apache.druid.server.SegmentManager;
import org.apache.druid.server.SpecificSegmentsQuerySegmentWalker;
import org.apache.druid.sql.calcite.util.TestTimelineServerView;
import org.apache.druid.timeline.DataSegment;
import org.easymock.EasyMock;

public class BrokerSegmentMetadataCacheTestBase
extends SegmentMetadataCacheTestBase {
    public List<ImmutableDruidServer> druidServers;
    SegmentManager segmentManager;
    Set<String> segmentDataSourceNames;
    Set<String> joinableDataSourceNames;
    JoinableFactory globalTableJoinable;
    public SpecificSegmentsQuerySegmentWalker walker;
    public TestTimelineServerView serverView;

    public void setUp() throws Exception {
        this.setUpData();
        this.setUpCommon();
        this.segmentDataSourceNames = Sets.newConcurrentHashSet();
        this.joinableDataSourceNames = Sets.newConcurrentHashSet();
        this.segmentManager = new SegmentManager((SegmentCacheManager)EasyMock.createMock(SegmentCacheManager.class)){

            public Set<String> getDataSourceNames() {
                return BrokerSegmentMetadataCacheTestBase.this.segmentDataSourceNames;
            }
        };
        this.globalTableJoinable = new JoinableFactory(){

            public boolean isDirectlyJoinable(DataSource dataSource) {
                return dataSource instanceof GlobalTableDataSource && BrokerSegmentMetadataCacheTestBase.this.joinableDataSourceNames.contains(((GlobalTableDataSource)dataSource).getName());
            }

            public Optional<Joinable> build(DataSource dataSource, JoinConditionAnalysis condition) {
                return Optional.empty();
            }
        };
        this.walker = SpecificSegmentsQuerySegmentWalker.createWalker((QueryRunnerFactoryConglomerate)this.conglomerate).add(this.segment1, this.index1).add(this.segment2, this.index2).add(this.segment3, this.index2).add(this.segment4, this.indexAuto1).add(this.segment5, this.indexAuto2);
        ImmutableList realtimeSegments = ImmutableList.of((Object)this.realtimeSegment1);
        this.serverView = new TestTimelineServerView(this.walker.getSegments(), (List<DataSegment>)realtimeSegments);
        this.druidServers = this.serverView.getDruidServers();
    }
}

