/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.util.mapping.MappingType;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.druid.sql.calcite.rel.DruidJoinQueryRel;
import org.apache.druid.sql.calcite.rel.DruidOuterQueryRel;
import org.apache.druid.sql.calcite.rel.DruidQueryRel;
import org.apache.druid.sql.calcite.rel.DruidRel;
import org.apache.druid.sql.calcite.rel.DruidRels;
import org.apache.druid.sql.calcite.rel.DruidUnionDataSourceRel;
import org.apache.druid.sql.calcite.rel.PartialDruidQuery;
import org.apache.druid.sql.calcite.table.DruidTable;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class DruidRelsTest {
    @Test
    public void test_isScanOrMapping_scan() {
        DruidRel<?> rel = DruidRelsTest.mockDruidRel(DruidQueryRel.class, PartialDruidQuery.Stage.SCAN, null, null, null);
        Assert.assertTrue((boolean)DruidRels.isScanOrMapping(rel, (boolean)true));
        Assert.assertTrue((boolean)DruidRels.isScanOrMapping(rel, (boolean)false));
        EasyMock.verify((Object[])new Object[]{rel, rel.getPartialDruidQuery()});
    }

    @Test
    public void test_isScanOrMapping_scanJoin() {
        DruidRel<?> rel = DruidRelsTest.mockDruidRel(DruidJoinQueryRel.class, PartialDruidQuery.Stage.SCAN, null, null, null);
        Assert.assertTrue((boolean)DruidRels.isScanOrMapping(rel, (boolean)true));
        Assert.assertFalse((boolean)DruidRels.isScanOrMapping(rel, (boolean)false));
        EasyMock.verify((Object[])new Object[]{rel, rel.getPartialDruidQuery()});
    }

    @Test
    public void test_isScanOrMapping_scanUnion() {
        DruidRel<?> rel = DruidRelsTest.mockDruidRel(DruidUnionDataSourceRel.class, PartialDruidQuery.Stage.SCAN, null, null, null);
        Assert.assertTrue((boolean)DruidRels.isScanOrMapping(rel, (boolean)true));
        Assert.assertFalse((boolean)DruidRels.isScanOrMapping(rel, (boolean)false));
        EasyMock.verify((Object[])new Object[]{rel, rel.getPartialDruidQuery()});
    }

    @Test
    public void test_isScanOrMapping_scanQuery() {
        DruidRel<?> rel = DruidRelsTest.mockDruidRel(DruidOuterQueryRel.class, PartialDruidQuery.Stage.SCAN, null, null, null);
        Assert.assertFalse((boolean)DruidRels.isScanOrMapping(rel, (boolean)true));
        Assert.assertFalse((boolean)DruidRels.isScanOrMapping(rel, (boolean)false));
        EasyMock.verify((Object[])new Object[]{rel, rel.getPartialDruidQuery()});
    }

    @Test
    public void test_isScanOrMapping_mapping() {
        Project project = DruidRelsTest.mockMappingProject((List<Integer>)ImmutableList.of((Object)1, (Object)0), 2);
        DruidRel<?> rel = DruidRelsTest.mockDruidRel(DruidQueryRel.class, PartialDruidQuery.Stage.SELECT_PROJECT, null, project, null);
        Assert.assertTrue((boolean)DruidRels.isScanOrMapping(rel, (boolean)true));
        Assert.assertTrue((boolean)DruidRels.isScanOrMapping(rel, (boolean)false));
        EasyMock.verify((Object[])new Object[]{rel, rel.getPartialDruidQuery(), project});
    }

    @Test
    public void test_isScanOrMapping_mappingJoin() {
        Project project = DruidRelsTest.mockMappingProject((List<Integer>)ImmutableList.of((Object)1, (Object)0), 2);
        DruidRel<?> rel = DruidRelsTest.mockDruidRel(DruidJoinQueryRel.class, PartialDruidQuery.Stage.SELECT_PROJECT, null, project, null);
        Assert.assertTrue((boolean)DruidRels.isScanOrMapping(rel, (boolean)true));
        Assert.assertFalse((boolean)DruidRels.isScanOrMapping(rel, (boolean)false));
        EasyMock.verify((Object[])new Object[]{rel, rel.getPartialDruidQuery(), project});
    }

    @Test
    public void test_isScanOrMapping_mappingUnion() {
        Project project = DruidRelsTest.mockMappingProject((List<Integer>)ImmutableList.of((Object)1, (Object)0), 2);
        DruidRel<?> rel = DruidRelsTest.mockDruidRel(DruidUnionDataSourceRel.class, PartialDruidQuery.Stage.SELECT_PROJECT, null, project, null);
        Assert.assertTrue((boolean)DruidRels.isScanOrMapping(rel, (boolean)true));
        Assert.assertFalse((boolean)DruidRels.isScanOrMapping(rel, (boolean)false));
        EasyMock.verify((Object[])new Object[]{rel, rel.getPartialDruidQuery(), project});
    }

    @Test
    public void test_isScanOrMapping_mappingQuery() {
        Project project = DruidRelsTest.mockMappingProject((List<Integer>)ImmutableList.of((Object)1, (Object)0), 2);
        DruidRel<?> rel = DruidRelsTest.mockDruidRel(DruidOuterQueryRel.class, PartialDruidQuery.Stage.SELECT_PROJECT, null, project, null);
        Assert.assertFalse((boolean)DruidRels.isScanOrMapping(rel, (boolean)true));
        Assert.assertFalse((boolean)DruidRels.isScanOrMapping(rel, (boolean)false));
        EasyMock.verify((Object[])new Object[]{rel, rel.getPartialDruidQuery(), project});
    }

    @Test
    public void test_isScanOrMapping_nonMapping() {
        Project project = DruidRelsTest.mockNonMappingProject();
        DruidRel<?> rel = DruidRelsTest.mockDruidRel(DruidQueryRel.class, PartialDruidQuery.Stage.SELECT_PROJECT, null, project, null);
        Assert.assertFalse((boolean)DruidRels.isScanOrMapping(rel, (boolean)true));
        Assert.assertFalse((boolean)DruidRels.isScanOrMapping(rel, (boolean)false));
        EasyMock.verify((Object[])new Object[]{rel, rel.getPartialDruidQuery(), project});
    }

    @Test
    public void test_isScanOrMapping_nonMappingJoin() {
        Project project = DruidRelsTest.mockNonMappingProject();
        DruidRel<?> rel = DruidRelsTest.mockDruidRel(DruidJoinQueryRel.class, PartialDruidQuery.Stage.SELECT_PROJECT, null, project, null);
        Assert.assertFalse((boolean)DruidRels.isScanOrMapping(rel, (boolean)true));
        Assert.assertFalse((boolean)DruidRels.isScanOrMapping(rel, (boolean)false));
        EasyMock.verify((Object[])new Object[]{rel, rel.getPartialDruidQuery(), project});
    }

    @Test
    public void test_isScanOrMapping_nonMappingUnion() {
        Project project = DruidRelsTest.mockNonMappingProject();
        DruidRel<?> rel = DruidRelsTest.mockDruidRel(DruidUnionDataSourceRel.class, PartialDruidQuery.Stage.SELECT_PROJECT, null, project, null);
        Assert.assertFalse((boolean)DruidRels.isScanOrMapping(rel, (boolean)true));
        Assert.assertFalse((boolean)DruidRels.isScanOrMapping(rel, (boolean)false));
        EasyMock.verify((Object[])new Object[]{rel, rel.getPartialDruidQuery(), project});
    }

    @Test
    public void test_isScanOrMapping_filterThenProject() {
        Project project = DruidRelsTest.mockMappingProject((List<Integer>)ImmutableList.of((Object)1, (Object)0), 2);
        DruidRel<?> rel = DruidRelsTest.mockDruidRel(DruidQueryRel.class, PartialDruidQuery.Stage.SELECT_PROJECT, null, project, DruidRelsTest.mockFilter());
        Assert.assertFalse((boolean)DruidRels.isScanOrMapping(rel, (boolean)true));
        Assert.assertFalse((boolean)DruidRels.isScanOrMapping(rel, (boolean)false));
        EasyMock.verify((Object[])new Object[]{rel, rel.getPartialDruidQuery(), project});
    }

    @Test
    public void test_isScanOrMapping_filterThenProjectJoin() {
        Project project = DruidRelsTest.mockMappingProject((List<Integer>)ImmutableList.of((Object)1, (Object)0), 2);
        DruidRel<?> rel = DruidRelsTest.mockDruidRel(DruidJoinQueryRel.class, PartialDruidQuery.Stage.SELECT_PROJECT, null, project, DruidRelsTest.mockFilter());
        Assert.assertFalse((boolean)DruidRels.isScanOrMapping(rel, (boolean)true));
        Assert.assertFalse((boolean)DruidRels.isScanOrMapping(rel, (boolean)false));
        EasyMock.verify((Object[])new Object[]{rel, rel.getPartialDruidQuery(), project});
    }

    @Test
    public void test_isScanOrMapping_filterThenProjectUnion() {
        Project project = DruidRelsTest.mockMappingProject((List<Integer>)ImmutableList.of((Object)1, (Object)0), 2);
        DruidRel<?> rel = DruidRelsTest.mockDruidRel(DruidUnionDataSourceRel.class, PartialDruidQuery.Stage.SELECT_PROJECT, null, project, DruidRelsTest.mockFilter());
        Assert.assertFalse((boolean)DruidRels.isScanOrMapping(rel, (boolean)true));
        Assert.assertFalse((boolean)DruidRels.isScanOrMapping(rel, (boolean)false));
        EasyMock.verify((Object[])new Object[]{rel, rel.getPartialDruidQuery(), project});
    }

    @Test
    public void test_isScanOrMapping_filter() {
        DruidRel<?> rel = DruidRelsTest.mockDruidRel(DruidQueryRel.class, PartialDruidQuery.Stage.WHERE_FILTER, null, null, DruidRelsTest.mockFilter());
        Assert.assertFalse((boolean)DruidRels.isScanOrMapping(rel, (boolean)true));
        Assert.assertFalse((boolean)DruidRels.isScanOrMapping(rel, (boolean)false));
        EasyMock.verify((Object[])new Object[]{rel, rel.getPartialDruidQuery()});
    }

    @Test
    public void test_isScanOrMapping_filterJoin() {
        DruidRel<?> rel = DruidRelsTest.mockDruidRel(DruidJoinQueryRel.class, PartialDruidQuery.Stage.WHERE_FILTER, null, null, DruidRelsTest.mockFilter());
        Assert.assertFalse((boolean)DruidRels.isScanOrMapping(rel, (boolean)true));
        Assert.assertFalse((boolean)DruidRels.isScanOrMapping(rel, (boolean)false));
        EasyMock.verify((Object[])new Object[]{rel, rel.getPartialDruidQuery()});
    }

    @Test
    public void test_isScanOrMapping_allStages() {
        ImmutableSet okStages = ImmutableSet.of((Object)PartialDruidQuery.Stage.SCAN, (Object)PartialDruidQuery.Stage.SELECT_PROJECT);
        for (PartialDruidQuery.Stage stage : PartialDruidQuery.Stage.values()) {
            Project project = DruidRelsTest.mockMappingProject((List<Integer>)ImmutableList.of((Object)1, (Object)0), 2);
            DruidRel<?> rel = DruidRelsTest.mockDruidRel(DruidQueryRel.class, stage, null, project, null);
            Assert.assertEquals((String)stage.toString(), (Object)okStages.contains((Object)stage), (Object)DruidRels.isScanOrMapping(rel, (boolean)true));
            Assert.assertEquals((String)stage.toString(), (Object)okStages.contains((Object)stage), (Object)DruidRels.isScanOrMapping(rel, (boolean)false));
            EasyMock.verify((Object[])new Object[]{rel, rel.getPartialDruidQuery(), project});
        }
    }

    public static DruidRel<?> mockDruidRel(Class<? extends DruidRel<?>> clazz, PartialDruidQuery.Stage stage, @Nullable DruidTable druidTable, @Nullable Project selectProject, @Nullable Filter whereFilter) {
        return DruidRelsTest.mockDruidRel(clazz, rel -> {}, stage, druidTable, selectProject, whereFilter);
    }

    public static <T extends DruidRel<?>> T mockDruidRel(Class<T> clazz, Consumer<T> additionalExpectationsFunction, PartialDruidQuery.Stage stage, @Nullable DruidTable druidTable, @Nullable Project selectProject, @Nullable Filter whereFilter) {
        PartialDruidQuery mockPartialQuery = (PartialDruidQuery)EasyMock.mock(PartialDruidQuery.class);
        EasyMock.expect((Object)mockPartialQuery.stage()).andReturn((Object)stage).anyTimes();
        EasyMock.expect((Object)mockPartialQuery.getSelectProject()).andReturn((Object)selectProject).anyTimes();
        EasyMock.expect((Object)mockPartialQuery.getWhereFilter()).andReturn((Object)whereFilter).anyTimes();
        RelOptTable mockRelOptTable = (RelOptTable)EasyMock.mock(RelOptTable.class);
        DruidRel mockRel = (DruidRel)EasyMock.mock(clazz);
        EasyMock.expect((Object)mockRel.getPartialDruidQuery()).andReturn((Object)mockPartialQuery).anyTimes();
        EasyMock.expect((Object)mockRel.getTable()).andReturn((Object)mockRelOptTable).anyTimes();
        if (clazz == DruidQueryRel.class) {
            EasyMock.expect((Object)((DruidQueryRel)mockRel).getDruidTable()).andReturn((Object)druidTable).anyTimes();
        }
        additionalExpectationsFunction.accept(mockRel);
        EasyMock.replay((Object[])new Object[]{mockRel, mockPartialQuery, mockRelOptTable});
        return (T)mockRel;
    }

    public static Project mockMappingProject(List<Integer> sources, int sourceCount) {
        Project mockProject = (Project)EasyMock.mock(Project.class);
        EasyMock.expect((Object)mockProject.isMapping()).andReturn((Object)true).anyTimes();
        Mappings.PartialMapping mapping = new Mappings.PartialMapping(sources, sourceCount, MappingType.SURJECTION);
        EasyMock.expect((Object)mockProject.getMapping()).andReturn((Object)mapping).anyTimes();
        EasyMock.replay((Object[])new Object[]{mockProject});
        return mockProject;
    }

    public static Project mockNonMappingProject() {
        Project mockProject = (Project)EasyMock.mock(Project.class);
        EasyMock.expect((Object)mockProject.isMapping()).andReturn((Object)false).anyTimes();
        EasyMock.replay((Object[])new Object[]{mockProject});
        return mockProject;
    }

    public static Filter mockFilter() {
        return (Filter)EasyMock.mock(Filter.class);
    }
}

